# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrganizationSubscriptionsResult',
    'AwaitableGetOrganizationSubscriptionsResult',
    'get_organization_subscriptions',
    'get_organization_subscriptions_output',
]

@pulumi.output_type
class GetOrganizationSubscriptionsResult:
    """
    A collection of values returned by getOrganizationSubscriptions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, subscription_ids=None, subscriptions=None, x_one_origin_region=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if subscription_ids and not isinstance(subscription_ids, str):
            raise TypeError("Expected argument 'subscription_ids' to be a str")
        pulumi.set(__self__, "subscription_ids", subscription_ids)
        if subscriptions and not isinstance(subscriptions, list):
            raise TypeError("Expected argument 'subscriptions' to be a list")
        pulumi.set(__self__, "subscriptions", subscriptions)
        if x_one_origin_region and not isinstance(x_one_origin_region, str):
            raise TypeError("Expected argument 'x_one_origin_region' to be a str")
        pulumi.set(__self__, "x_one_origin_region", x_one_origin_region)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOrganizationSubscriptionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subscriptionIds")
    def subscription_ids(self) -> str:
        return pulumi.get(self, "subscription_ids")

    @property
    @pulumi.getter
    def subscriptions(self) -> Sequence['outputs.GetOrganizationSubscriptionsSubscriptionResult']:
        """
        The list of subscriptions.
        """
        return pulumi.get(self, "subscriptions")

    @property
    @pulumi.getter(name="xOneOriginRegion")
    def x_one_origin_region(self) -> Optional[str]:
        return pulumi.get(self, "x_one_origin_region")


class AwaitableGetOrganizationSubscriptionsResult(GetOrganizationSubscriptionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationSubscriptionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            subscription_ids=self.subscription_ids,
            subscriptions=self.subscriptions,
            x_one_origin_region=self.x_one_origin_region)


def get_organization_subscriptions(compartment_id: Optional[str] = None,
                                   filters: Optional[Sequence[pulumi.InputType['GetOrganizationSubscriptionsFilterArgs']]] = None,
                                   subscription_ids: Optional[str] = None,
                                   x_one_origin_region: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationSubscriptionsResult:
    """
    This data source provides the list of Organization Subscriptions in Oracle Cloud Infrastructure Osub Organization Subscription service.

    API that returns data for the list of subscription ids returned from Organizations API

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_organization_subscriptions = oci.OsubOrganizationSubscription.get_organization_subscriptions(compartment_id=compartment_id,
        subscription_ids=organization_subscription_subscription_ids,
        x_one_origin_region=organization_subscription_x_one_origin_region)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str subscription_ids: Comma separated list of subscription ids, pass "DUMMY" as value
    :param str x_one_origin_region: The Oracle Cloud Infrastructure home region name in case home region is not us-ashburn-1 (IAD), e.g. ap-mumbai-1, us-phoenix-1 etc.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['subscriptionIds'] = subscription_ids
    __args__['xOneOriginRegion'] = x_one_origin_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsubOrganizationSubscription/getOrganizationSubscriptions:getOrganizationSubscriptions', __args__, opts=opts, typ=GetOrganizationSubscriptionsResult).value

    return AwaitableGetOrganizationSubscriptionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        subscription_ids=pulumi.get(__ret__, 'subscription_ids'),
        subscriptions=pulumi.get(__ret__, 'subscriptions'),
        x_one_origin_region=pulumi.get(__ret__, 'x_one_origin_region'))


@_utilities.lift_output_func(get_organization_subscriptions)
def get_organization_subscriptions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                          filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOrganizationSubscriptionsFilterArgs']]]]] = None,
                                          subscription_ids: Optional[pulumi.Input[str]] = None,
                                          x_one_origin_region: Optional[pulumi.Input[Optional[str]]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationSubscriptionsResult]:
    """
    This data source provides the list of Organization Subscriptions in Oracle Cloud Infrastructure Osub Organization Subscription service.

    API that returns data for the list of subscription ids returned from Organizations API

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_organization_subscriptions = oci.OsubOrganizationSubscription.get_organization_subscriptions(compartment_id=compartment_id,
        subscription_ids=organization_subscription_subscription_ids,
        x_one_origin_region=organization_subscription_x_one_origin_region)
    ```


    :param str compartment_id: The OCID of the compartment.
    :param str subscription_ids: Comma separated list of subscription ids, pass "DUMMY" as value
    :param str x_one_origin_region: The Oracle Cloud Infrastructure home region name in case home region is not us-ashburn-1 (IAD), e.g. ap-mumbai-1, us-phoenix-1 etc.
    """
    ...
