# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIngressGatewaysResult',
    'AwaitableGetIngressGatewaysResult',
    'get_ingress_gateways',
    'get_ingress_gateways_output',
]

@pulumi.output_type
class GetIngressGatewaysResult:
    """
    A collection of values returned by getIngressGateways.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, ingress_gateway_collections=None, mesh_id=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingress_gateway_collections and not isinstance(ingress_gateway_collections, list):
            raise TypeError("Expected argument 'ingress_gateway_collections' to be a list")
        pulumi.set(__self__, "ingress_gateway_collections", ingress_gateway_collections)
        if mesh_id and not isinstance(mesh_id, str):
            raise TypeError("Expected argument 'mesh_id' to be a str")
        pulumi.set(__self__, "mesh_id", mesh_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIngressGatewaysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingressGatewayCollections")
    def ingress_gateway_collections(self) -> Sequence['outputs.GetIngressGatewaysIngressGatewayCollectionResult']:
        """
        The list of ingress_gateway_collection.
        """
        return pulumi.get(self, "ingress_gateway_collections")

    @property
    @pulumi.getter(name="meshId")
    def mesh_id(self) -> Optional[str]:
        """
        The OCID of the service mesh in which this ingress gateway is created.
        """
        return pulumi.get(self, "mesh_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A user-friendly name. The name has to be unique within the same service mesh and cannot be changed after creation. Avoid entering confidential information.  Example: `My unique resource name`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetIngressGatewaysResult(GetIngressGatewaysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIngressGatewaysResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            ingress_gateway_collections=self.ingress_gateway_collections,
            mesh_id=self.mesh_id,
            name=self.name,
            state=self.state)


def get_ingress_gateways(compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetIngressGatewaysFilterArgs']]] = None,
                         id: Optional[str] = None,
                         mesh_id: Optional[str] = None,
                         name: Optional[str] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIngressGatewaysResult:
    """
    This data source provides the list of Ingress Gateways in Oracle Cloud Infrastructure Service Mesh service.

    Returns a list of IngressGateway objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ingress_gateways = oci.ServiceMesh.get_ingress_gateways(compartment_id=compartment_id,
        id=ingress_gateway_id,
        mesh_id=test_mesh["id"],
        name=ingress_gateway_name,
        state=ingress_gateway_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str id: Unique IngressGateway identifier.
    :param str mesh_id: Unique Mesh identifier.
    :param str name: A filter to return only resources that match the entire name given.
    :param str state: A filter to return only resources that match the life cycle state given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['meshId'] = mesh_id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceMesh/getIngressGateways:getIngressGateways', __args__, opts=opts, typ=GetIngressGatewaysResult).value

    return AwaitableGetIngressGatewaysResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ingress_gateway_collections=pulumi.get(__ret__, 'ingress_gateway_collections'),
        mesh_id=pulumi.get(__ret__, 'mesh_id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_ingress_gateways)
def get_ingress_gateways_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetIngressGatewaysFilterArgs']]]]] = None,
                                id: Optional[pulumi.Input[Optional[str]]] = None,
                                mesh_id: Optional[pulumi.Input[Optional[str]]] = None,
                                name: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIngressGatewaysResult]:
    """
    This data source provides the list of Ingress Gateways in Oracle Cloud Infrastructure Service Mesh service.

    Returns a list of IngressGateway objects.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ingress_gateways = oci.ServiceMesh.get_ingress_gateways(compartment_id=compartment_id,
        id=ingress_gateway_id,
        mesh_id=test_mesh["id"],
        name=ingress_gateway_name,
        state=ingress_gateway_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str id: Unique IngressGateway identifier.
    :param str mesh_id: Unique Mesh identifier.
    :param str name: A filter to return only resources that match the entire name given.
    :param str state: A filter to return only resources that match the life cycle state given.
    """
    ...
