# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetPathAnalyzerTestsFilterArgs',
    'PathAnalysiDestinationEndpointArgs',
    'PathAnalysiProtocolParametersArgs',
    'PathAnalysiQueryOptionsArgs',
    'PathAnalysiSourceEndpointArgs',
    'PathAnalyzerTestDestinationEndpointArgs',
    'PathAnalyzerTestProtocolParametersArgs',
    'PathAnalyzerTestQueryOptionsArgs',
    'PathAnalyzerTestSourceEndpointArgs',
]

@pulumi.input_type
class GetPathAnalyzerTestsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class PathAnalysiDestinationEndpointArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 network_load_balancer_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vnic_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of the `PathAnalysis` query.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param pulumi.Input[str] listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param pulumi.Input[str] network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param pulumi.Input[str] vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param pulumi.Input[str] vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the `PathAnalysis` query.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @network_load_balancer_id.setter
    def network_load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_load_balancer_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")

    @vnic_id.setter
    def vnic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnic_id", value)


@pulumi.input_type
class PathAnalysiProtocolParametersArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 destination_port: Optional[pulumi.Input[int]] = None,
                 icmp_code: Optional[pulumi.Input[int]] = None,
                 icmp_type: Optional[pulumi.Input[int]] = None,
                 source_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: The type of the `PathAnalysis` query.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[int] destination_port: The destination port to use in a `PathAnalyzerTest` resource.
        :param pulumi.Input[int] icmp_code: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param pulumi.Input[int] icmp_type: The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param pulumi.Input[int] source_port: The source port to use in a `PathAnalyzerTest` resource.
        """
        pulumi.set(__self__, "type", type)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if icmp_code is not None:
            pulumi.set(__self__, "icmp_code", icmp_code)
        if icmp_type is not None:
            pulumi.set(__self__, "icmp_type", icmp_type)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the `PathAnalysis` query.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[pulumi.Input[int]]:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @icmp_code.setter
    def icmp_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_code", value)

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[pulumi.Input[int]]:
        """
        The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @icmp_type.setter
    def icmp_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_type", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[int]]:
        """
        The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class PathAnalysiQueryOptionsArgs:
    def __init__(__self__, *,
                 is_bi_directional_analysis: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_bi_directional_analysis: If true, a path analysis is done for both the forward and reverse routes.
        """
        if is_bi_directional_analysis is not None:
            pulumi.set(__self__, "is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")

    @is_bi_directional_analysis.setter
    def is_bi_directional_analysis(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_bi_directional_analysis", value)


@pulumi.input_type
class PathAnalysiSourceEndpointArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 network_load_balancer_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vnic_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of the `PathAnalysis` query.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] address: The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param pulumi.Input[str] listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param pulumi.Input[str] network_load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param pulumi.Input[str] vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param pulumi.Input[str] vnic_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the `PathAnalysis` query.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @network_load_balancer_id.setter
    def network_load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_load_balancer_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance.
        """
        return pulumi.get(self, "vnic_id")

    @vnic_id.setter
    def vnic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnic_id", value)


@pulumi.input_type
class PathAnalyzerTestDestinationEndpointArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 network_load_balancer_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vnic_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) The type of the `Endpoint`.
        :param pulumi.Input[str] address: (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param pulumi.Input[str] instance_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param pulumi.Input[str] listener_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param pulumi.Input[str] load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param pulumi.Input[str] network_load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param pulumi.Input[str] state: The current state of the `PathAnalyzerTest` resource.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param pulumi.Input[str] vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param pulumi.Input[str] vnic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @network_load_balancer_id.setter
    def network_load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_load_balancer_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vnic_id")

    @vnic_id.setter
    def vnic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnic_id", value)


@pulumi.input_type
class PathAnalyzerTestProtocolParametersArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 destination_port: Optional[pulumi.Input[int]] = None,
                 icmp_code: Optional[pulumi.Input[int]] = None,
                 icmp_type: Optional[pulumi.Input[int]] = None,
                 source_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) The type of the `Endpoint`.
        :param pulumi.Input[int] destination_port: (Updatable) The destination port to use in a `PathAnalyzerTest` resource.
        :param pulumi.Input[int] icmp_code: (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        :param pulumi.Input[int] icmp_type: (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        :param pulumi.Input[int] source_port: (Updatable) The source port to use in a `PathAnalyzerTest` resource.
        """
        pulumi.set(__self__, "type", type)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if icmp_code is not None:
            pulumi.set(__self__, "icmp_code", icmp_code)
        if icmp_type is not None:
            pulumi.set(__self__, "icmp_type", icmp_type)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The destination port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) code.
        """
        return pulumi.get(self, "icmp_code")

    @icmp_code.setter
    def icmp_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_code", value)

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The [ICMP](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml) type.
        """
        return pulumi.get(self, "icmp_type")

    @icmp_type.setter
    def icmp_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_type", value)

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The source port to use in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_port", value)


@pulumi.input_type
class PathAnalyzerTestQueryOptionsArgs:
    def __init__(__self__, *,
                 is_bi_directional_analysis: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_bi_directional_analysis: (Updatable) If true, a path analysis is done for both the forward and reverse routes.
        """
        if is_bi_directional_analysis is not None:
            pulumi.set(__self__, "is_bi_directional_analysis", is_bi_directional_analysis)

    @property
    @pulumi.getter(name="isBiDirectionalAnalysis")
    def is_bi_directional_analysis(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, a path analysis is done for both the forward and reverse routes.
        """
        return pulumi.get(self, "is_bi_directional_analysis")

    @is_bi_directional_analysis.setter
    def is_bi_directional_analysis(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_bi_directional_analysis", value)


@pulumi.input_type
class PathAnalyzerTestSourceEndpointArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 network_load_balancer_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[str]] = None,
                 vnic_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) The type of the `Endpoint`.
        :param pulumi.Input[str] address: (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        :param pulumi.Input[str] instance_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        :param pulumi.Input[str] listener_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        :param pulumi.Input[str] load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        :param pulumi.Input[str] network_load_balancer_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        :param pulumi.Input[str] state: The current state of the `PathAnalyzerTest` resource.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        :param pulumi.Input[str] vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        :param pulumi.Input[str] vnic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "type", type)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if network_load_balancer_id is not None:
            pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vnic_id is not None:
            pulumi.set(__self__, "vnic_id", vnic_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the `Endpoint`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The IPv4 address of the COMPUTE_INSTANCE-type `Endpoint` object.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network load balancer listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's load balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the listener's network load balancer.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @network_load_balancer_id.setter
    def network_load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_load_balancer_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet containing the IP address. This can be used to disambiguate which subnet is intended, in case the IP address is used in more than one subnet (when there are subnets with overlapping IP ranges).
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN containing the IP address. This can be used to disambiguate which VLAN is queried, in case the endpoint IP address belongs to more than one VLAN (when there are VLANs with overlapping IP ranges).
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VNIC attached to the compute instance. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vnic_id")

    @vnic_id.setter
    def vnic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnic_id", value)


