# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppAccelerationPolicyResult',
    'AwaitableGetAppAccelerationPolicyResult',
    'get_app_acceleration_policy',
    'get_app_acceleration_policy_output',
]

@pulumi.output_type
class GetAppAccelerationPolicyResult:
    """
    A collection of values returned by getAppAccelerationPolicy.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, response_caching_policies=None, response_compression_policies=None, state=None, system_tags=None, time_created=None, time_updated=None, web_app_acceleration_policy_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if response_caching_policies and not isinstance(response_caching_policies, list):
            raise TypeError("Expected argument 'response_caching_policies' to be a list")
        pulumi.set(__self__, "response_caching_policies", response_caching_policies)
        if response_compression_policies and not isinstance(response_compression_policies, list):
            raise TypeError("Expected argument 'response_compression_policies' to be a list")
        pulumi.set(__self__, "response_compression_policies", response_compression_policies)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if web_app_acceleration_policy_id and not isinstance(web_app_acceleration_policy_id, str):
            raise TypeError("Expected argument 'web_app_acceleration_policy_id' to be a str")
        pulumi.set(__self__, "web_app_acceleration_policy_id", web_app_acceleration_policy_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        WebAppAccelerationPolicy display name, can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppAccelerationPolicy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in FAILED state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="responseCachingPolicies")
    def response_caching_policies(self) -> Sequence['outputs.GetAppAccelerationPolicyResponseCachingPolicyResult']:
        """
        An object that specifies an HTTP response caching policy.
        """
        return pulumi.get(self, "response_caching_policies")

    @property
    @pulumi.getter(name="responseCompressionPolicies")
    def response_compression_policies(self) -> Sequence['outputs.GetAppAccelerationPolicyResponseCompressionPolicyResult']:
        """
        An object that specifies a compression policy for HTTP response from ENABLEMENT POINT to the client.
        """
        return pulumi.get(self, "response_compression_policies")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the WebAppAccelerationPolicy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the WebAppAccelerationPolicy was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the WebAppAccelerationPolicy was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="webAppAccelerationPolicyId")
    def web_app_acceleration_policy_id(self) -> str:
        return pulumi.get(self, "web_app_acceleration_policy_id")


class AwaitableGetAppAccelerationPolicyResult(GetAppAccelerationPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppAccelerationPolicyResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            response_caching_policies=self.response_caching_policies,
            response_compression_policies=self.response_compression_policies,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            web_app_acceleration_policy_id=self.web_app_acceleration_policy_id)


def get_app_acceleration_policy(web_app_acceleration_policy_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppAccelerationPolicyResult:
    """
    This data source provides details about a specific Web App Acceleration Policy resource in Oracle Cloud Infrastructure Waa service.

    Gets a WebAppAccelerationPolicy with the given OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_acceleration_policy = oci.Waa.get_app_acceleration_policy(web_app_acceleration_policy_id=test_web_app_acceleration_policy_oci_waa_web_app_acceleration_policy["id"])
    ```


    :param str web_app_acceleration_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppAccelerationPolicy.
    """
    __args__ = dict()
    __args__['webAppAccelerationPolicyId'] = web_app_acceleration_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waa/getAppAccelerationPolicy:getAppAccelerationPolicy', __args__, opts=opts, typ=GetAppAccelerationPolicyResult).value

    return AwaitableGetAppAccelerationPolicyResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        response_caching_policies=pulumi.get(__ret__, 'response_caching_policies'),
        response_compression_policies=pulumi.get(__ret__, 'response_compression_policies'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        web_app_acceleration_policy_id=pulumi.get(__ret__, 'web_app_acceleration_policy_id'))


@_utilities.lift_output_func(get_app_acceleration_policy)
def get_app_acceleration_policy_output(web_app_acceleration_policy_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppAccelerationPolicyResult]:
    """
    This data source provides details about a specific Web App Acceleration Policy resource in Oracle Cloud Infrastructure Waa service.

    Gets a WebAppAccelerationPolicy with the given OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_web_app_acceleration_policy = oci.Waa.get_app_acceleration_policy(web_app_acceleration_policy_id=test_web_app_acceleration_policy_oci_waa_web_app_acceleration_policy["id"])
    ```


    :param str web_app_acceleration_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebAppAccelerationPolicy.
    """
    ...
