import { CodeDeployServiceException as __BaseException } from "./CodeDeployServiceException";
export class InstanceLimitExceededException extends __BaseException {
    name = "InstanceLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InstanceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InstanceLimitExceededException.prototype);
    }
}
export class InstanceNameRequiredException extends __BaseException {
    name = "InstanceNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InstanceNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InstanceNameRequiredException.prototype);
    }
}
export class InstanceNotRegisteredException extends __BaseException {
    name = "InstanceNotRegisteredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InstanceNotRegisteredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InstanceNotRegisteredException.prototype);
    }
}
export class InvalidInstanceNameException extends __BaseException {
    name = "InvalidInstanceNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidInstanceNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidInstanceNameException.prototype);
    }
}
export class InvalidTagException extends __BaseException {
    name = "InvalidTagException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTagException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTagException.prototype);
    }
}
export class TagLimitExceededException extends __BaseException {
    name = "TagLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TagLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TagLimitExceededException.prototype);
    }
}
export class TagRequiredException extends __BaseException {
    name = "TagRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TagRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TagRequiredException.prototype);
    }
}
export class AlarmsLimitExceededException extends __BaseException {
    name = "AlarmsLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AlarmsLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AlarmsLimitExceededException.prototype);
    }
}
export class ApplicationAlreadyExistsException extends __BaseException {
    name = "ApplicationAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApplicationAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApplicationAlreadyExistsException.prototype);
    }
}
export class ApplicationDoesNotExistException extends __BaseException {
    name = "ApplicationDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApplicationDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApplicationDoesNotExistException.prototype);
    }
}
export const ComputePlatform = {
    ECS: "ECS",
    LAMBDA: "Lambda",
    SERVER: "Server",
};
export class ApplicationLimitExceededException extends __BaseException {
    name = "ApplicationLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApplicationLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApplicationLimitExceededException.prototype);
    }
}
export class ApplicationNameRequiredException extends __BaseException {
    name = "ApplicationNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ApplicationNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ApplicationNameRequiredException.prototype);
    }
}
export const ApplicationRevisionSortBy = {
    FirstUsedTime: "firstUsedTime",
    LastUsedTime: "lastUsedTime",
    RegisterTime: "registerTime",
};
export class ArnNotSupportedException extends __BaseException {
    name = "ArnNotSupportedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ArnNotSupportedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ArnNotSupportedException.prototype);
    }
}
export const AutoRollbackEvent = {
    DEPLOYMENT_FAILURE: "DEPLOYMENT_FAILURE",
    DEPLOYMENT_STOP_ON_ALARM: "DEPLOYMENT_STOP_ON_ALARM",
    DEPLOYMENT_STOP_ON_REQUEST: "DEPLOYMENT_STOP_ON_REQUEST",
};
export const RevisionLocationType = {
    AppSpecContent: "AppSpecContent",
    GitHub: "GitHub",
    S3: "S3",
    String: "String",
};
export const BundleType = {
    JSON: "JSON",
    Tar: "tar",
    TarGZip: "tgz",
    YAML: "YAML",
    Zip: "zip",
};
export class BatchLimitExceededException extends __BaseException {
    name = "BatchLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BatchLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BatchLimitExceededException.prototype);
    }
}
export class InvalidApplicationNameException extends __BaseException {
    name = "InvalidApplicationNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidApplicationNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidApplicationNameException.prototype);
    }
}
export class InvalidRevisionException extends __BaseException {
    name = "InvalidRevisionException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRevisionException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRevisionException.prototype);
    }
}
export class RevisionRequiredException extends __BaseException {
    name = "RevisionRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RevisionRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RevisionRequiredException.prototype);
    }
}
export const DeploymentReadyAction = {
    CONTINUE_DEPLOYMENT: "CONTINUE_DEPLOYMENT",
    STOP_DEPLOYMENT: "STOP_DEPLOYMENT",
};
export const GreenFleetProvisioningAction = {
    COPY_AUTO_SCALING_GROUP: "COPY_AUTO_SCALING_GROUP",
    DISCOVER_EXISTING: "DISCOVER_EXISTING",
};
export const InstanceAction = {
    KEEP_ALIVE: "KEEP_ALIVE",
    TERMINATE: "TERMINATE",
};
export const DeploymentOption = {
    WITHOUT_TRAFFIC_CONTROL: "WITHOUT_TRAFFIC_CONTROL",
    WITH_TRAFFIC_CONTROL: "WITH_TRAFFIC_CONTROL",
};
export const DeploymentType = {
    BLUE_GREEN: "BLUE_GREEN",
    IN_PLACE: "IN_PLACE",
};
export const EC2TagFilterType = {
    KEY_AND_VALUE: "KEY_AND_VALUE",
    KEY_ONLY: "KEY_ONLY",
    VALUE_ONLY: "VALUE_ONLY",
};
export const DeploymentStatus = {
    BAKING: "Baking",
    CREATED: "Created",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    QUEUED: "Queued",
    READY: "Ready",
    STOPPED: "Stopped",
    SUCCEEDED: "Succeeded",
};
export const TagFilterType = {
    KEY_AND_VALUE: "KEY_AND_VALUE",
    KEY_ONLY: "KEY_ONLY",
    VALUE_ONLY: "VALUE_ONLY",
};
export const OutdatedInstancesStrategy = {
    Ignore: "IGNORE",
    Update: "UPDATE",
};
export const TriggerEventType = {
    DEPLOYMENT_FAILURE: "DeploymentFailure",
    DEPLOYMENT_READY: "DeploymentReady",
    DEPLOYMENT_ROLLBACK: "DeploymentRollback",
    DEPLOYMENT_START: "DeploymentStart",
    DEPLOYMENT_STOP: "DeploymentStop",
    DEPLOYMENT_SUCCESS: "DeploymentSuccess",
    INSTANCE_FAILURE: "InstanceFailure",
    INSTANCE_READY: "InstanceReady",
    INSTANCE_START: "InstanceStart",
    INSTANCE_SUCCESS: "InstanceSuccess",
};
export class DeploymentConfigDoesNotExistException extends __BaseException {
    name = "DeploymentConfigDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentConfigDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentConfigDoesNotExistException.prototype);
    }
}
export class DeploymentGroupNameRequiredException extends __BaseException {
    name = "DeploymentGroupNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentGroupNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentGroupNameRequiredException.prototype);
    }
}
export class InvalidDeploymentGroupNameException extends __BaseException {
    name = "InvalidDeploymentGroupNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentGroupNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentGroupNameException.prototype);
    }
}
export const _InstanceType = {
    BLUE: "Blue",
    GREEN: "Green",
};
export const LifecycleErrorCode = {
    SCRIPT_FAILED: "ScriptFailed",
    SCRIPT_MISSING: "ScriptMissing",
    SCRIPT_NOT_EXECUTABLE: "ScriptNotExecutable",
    SCRIPT_TIMED_OUT: "ScriptTimedOut",
    SUCCESS: "Success",
    UNKNOWN_ERROR: "UnknownError",
};
export const LifecycleEventStatus = {
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SKIPPED: "Skipped",
    SUCCEEDED: "Succeeded",
    UNKNOWN: "Unknown",
};
export const InstanceStatus = {
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    READY: "Ready",
    SKIPPED: "Skipped",
    SUCCEEDED: "Succeeded",
    UNKNOWN: "Unknown",
};
export class DeploymentDoesNotExistException extends __BaseException {
    name = "DeploymentDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentDoesNotExistException.prototype);
    }
}
export class DeploymentIdRequiredException extends __BaseException {
    name = "DeploymentIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentIdRequiredException.prototype);
    }
}
export class InstanceIdRequiredException extends __BaseException {
    name = "InstanceIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InstanceIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InstanceIdRequiredException.prototype);
    }
}
export class InvalidComputePlatformException extends __BaseException {
    name = "InvalidComputePlatformException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidComputePlatformException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidComputePlatformException.prototype);
    }
}
export class InvalidDeploymentIdException extends __BaseException {
    name = "InvalidDeploymentIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentIdException.prototype);
    }
}
export const DeploymentCreator = {
    Autoscaling: "autoscaling",
    AutoscalingTermination: "autoscalingTermination",
    CloudFormation: "CloudFormation",
    CloudFormationRollback: "CloudFormationRollback",
    CodeDeploy: "CodeDeploy",
    CodeDeployAutoUpdate: "CodeDeployAutoUpdate",
    CodeDeployRollback: "codeDeployRollback",
    User: "user",
};
export const ErrorCode = {
    AGENT_ISSUE: "AGENT_ISSUE",
    ALARM_ACTIVE: "ALARM_ACTIVE",
    APPLICATION_MISSING: "APPLICATION_MISSING",
    AUTOSCALING_VALIDATION_ERROR: "AUTOSCALING_VALIDATION_ERROR",
    AUTO_SCALING_CONFIGURATION: "AUTO_SCALING_CONFIGURATION",
    AUTO_SCALING_IAM_ROLE_PERMISSIONS: "AUTO_SCALING_IAM_ROLE_PERMISSIONS",
    CLOUDFORMATION_STACK_FAILURE: "CLOUDFORMATION_STACK_FAILURE",
    CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND: "CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND",
    CUSTOMER_APPLICATION_UNHEALTHY: "CUSTOMER_APPLICATION_UNHEALTHY",
    DEPLOYMENT_GROUP_MISSING: "DEPLOYMENT_GROUP_MISSING",
    ECS_UPDATE_ERROR: "ECS_UPDATE_ERROR",
    ELASTIC_LOAD_BALANCING_INVALID: "ELASTIC_LOAD_BALANCING_INVALID",
    ELB_INVALID_INSTANCE: "ELB_INVALID_INSTANCE",
    HEALTH_CONSTRAINTS: "HEALTH_CONSTRAINTS",
    HEALTH_CONSTRAINTS_INVALID: "HEALTH_CONSTRAINTS_INVALID",
    HOOK_EXECUTION_FAILURE: "HOOK_EXECUTION_FAILURE",
    IAM_ROLE_MISSING: "IAM_ROLE_MISSING",
    IAM_ROLE_PERMISSIONS: "IAM_ROLE_PERMISSIONS",
    INTERNAL_ERROR: "INTERNAL_ERROR",
    INVALID_ECS_SERVICE: "INVALID_ECS_SERVICE",
    INVALID_LAMBDA_CONFIGURATION: "INVALID_LAMBDA_CONFIGURATION",
    INVALID_LAMBDA_FUNCTION: "INVALID_LAMBDA_FUNCTION",
    INVALID_REVISION: "INVALID_REVISION",
    MANUAL_STOP: "MANUAL_STOP",
    MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION: "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION",
    MISSING_ELB_INFORMATION: "MISSING_ELB_INFORMATION",
    MISSING_GITHUB_TOKEN: "MISSING_GITHUB_TOKEN",
    NO_EC2_SUBSCRIPTION: "NO_EC2_SUBSCRIPTION",
    NO_INSTANCES: "NO_INSTANCES",
    OVER_MAX_INSTANCES: "OVER_MAX_INSTANCES",
    RESOURCE_LIMIT_EXCEEDED: "RESOURCE_LIMIT_EXCEEDED",
    REVISION_MISSING: "REVISION_MISSING",
    THROTTLED: "THROTTLED",
    TIMEOUT: "TIMEOUT",
};
export const FileExistsBehavior = {
    DISALLOW: "DISALLOW",
    OVERWRITE: "OVERWRITE",
    RETAIN: "RETAIN",
};
export const TargetStatus = {
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    READY: "Ready",
    SKIPPED: "Skipped",
    SUCCEEDED: "Succeeded",
    UNKNOWN: "Unknown",
};
export const DeploymentTargetType = {
    CLOUDFORMATION_TARGET: "CloudFormationTarget",
    ECS_TARGET: "ECSTarget",
    INSTANCE_TARGET: "InstanceTarget",
    LAMBDA_TARGET: "LambdaTarget",
};
export const TargetLabel = {
    BLUE: "Blue",
    GREEN: "Green",
};
export class DeploymentNotStartedException extends __BaseException {
    name = "DeploymentNotStartedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentNotStartedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentNotStartedException.prototype);
    }
}
export class DeploymentTargetDoesNotExistException extends __BaseException {
    name = "DeploymentTargetDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentTargetDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentTargetDoesNotExistException.prototype);
    }
}
export class DeploymentTargetIdRequiredException extends __BaseException {
    name = "DeploymentTargetIdRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentTargetIdRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentTargetIdRequiredException.prototype);
    }
}
export class DeploymentTargetListSizeExceededException extends __BaseException {
    name = "DeploymentTargetListSizeExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentTargetListSizeExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentTargetListSizeExceededException.prototype);
    }
}
export class InstanceDoesNotExistException extends __BaseException {
    name = "InstanceDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InstanceDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InstanceDoesNotExistException.prototype);
    }
}
export class InvalidDeploymentTargetIdException extends __BaseException {
    name = "InvalidDeploymentTargetIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentTargetIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentTargetIdException.prototype);
    }
}
export class BucketNameFilterRequiredException extends __BaseException {
    name = "BucketNameFilterRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BucketNameFilterRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BucketNameFilterRequiredException.prototype);
    }
}
export const DeploymentWaitType = {
    READY_WAIT: "READY_WAIT",
    TERMINATION_WAIT: "TERMINATION_WAIT",
};
export class DeploymentAlreadyCompletedException extends __BaseException {
    name = "DeploymentAlreadyCompletedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentAlreadyCompletedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentAlreadyCompletedException.prototype);
    }
}
export class DeploymentIsNotInReadyStateException extends __BaseException {
    name = "DeploymentIsNotInReadyStateException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentIsNotInReadyStateException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentIsNotInReadyStateException.prototype);
    }
}
export class InvalidDeploymentStatusException extends __BaseException {
    name = "InvalidDeploymentStatusException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentStatusException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentStatusException.prototype);
    }
}
export class InvalidDeploymentWaitTypeException extends __BaseException {
    name = "InvalidDeploymentWaitTypeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentWaitTypeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentWaitTypeException.prototype);
    }
}
export class UnsupportedActionForDeploymentTypeException extends __BaseException {
    name = "UnsupportedActionForDeploymentTypeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "UnsupportedActionForDeploymentTypeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, UnsupportedActionForDeploymentTypeException.prototype);
    }
}
export class InvalidTagsToAddException extends __BaseException {
    name = "InvalidTagsToAddException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTagsToAddException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTagsToAddException.prototype);
    }
}
export class DeploymentGroupDoesNotExistException extends __BaseException {
    name = "DeploymentGroupDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentGroupDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentGroupDoesNotExistException.prototype);
    }
}
export class DeploymentLimitExceededException extends __BaseException {
    name = "DeploymentLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentLimitExceededException.prototype);
    }
}
export class DescriptionTooLongException extends __BaseException {
    name = "DescriptionTooLongException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DescriptionTooLongException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DescriptionTooLongException.prototype);
    }
}
export class InvalidAlarmConfigException extends __BaseException {
    name = "InvalidAlarmConfigException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidAlarmConfigException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidAlarmConfigException.prototype);
    }
}
export class InvalidAutoRollbackConfigException extends __BaseException {
    name = "InvalidAutoRollbackConfigException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidAutoRollbackConfigException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidAutoRollbackConfigException.prototype);
    }
}
export class InvalidAutoScalingGroupException extends __BaseException {
    name = "InvalidAutoScalingGroupException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidAutoScalingGroupException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidAutoScalingGroupException.prototype);
    }
}
export class InvalidDeploymentConfigNameException extends __BaseException {
    name = "InvalidDeploymentConfigNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentConfigNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentConfigNameException.prototype);
    }
}
export class InvalidFileExistsBehaviorException extends __BaseException {
    name = "InvalidFileExistsBehaviorException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidFileExistsBehaviorException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidFileExistsBehaviorException.prototype);
    }
}
export class InvalidGitHubAccountTokenException extends __BaseException {
    name = "InvalidGitHubAccountTokenException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidGitHubAccountTokenException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidGitHubAccountTokenException.prototype);
    }
}
export class InvalidIgnoreApplicationStopFailuresValueException extends __BaseException {
    name = "InvalidIgnoreApplicationStopFailuresValueException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidIgnoreApplicationStopFailuresValueException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidIgnoreApplicationStopFailuresValueException.prototype);
    }
}
export class InvalidLoadBalancerInfoException extends __BaseException {
    name = "InvalidLoadBalancerInfoException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidLoadBalancerInfoException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidLoadBalancerInfoException.prototype);
    }
}
export class InvalidRoleException extends __BaseException {
    name = "InvalidRoleException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRoleException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRoleException.prototype);
    }
}
export class InvalidTargetInstancesException extends __BaseException {
    name = "InvalidTargetInstancesException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTargetInstancesException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTargetInstancesException.prototype);
    }
}
export class InvalidTrafficRoutingConfigurationException extends __BaseException {
    name = "InvalidTrafficRoutingConfigurationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTrafficRoutingConfigurationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTrafficRoutingConfigurationException.prototype);
    }
}
export class InvalidUpdateOutdatedInstancesOnlyValueException extends __BaseException {
    name = "InvalidUpdateOutdatedInstancesOnlyValueException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidUpdateOutdatedInstancesOnlyValueException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidUpdateOutdatedInstancesOnlyValueException.prototype);
    }
}
export class RevisionDoesNotExistException extends __BaseException {
    name = "RevisionDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RevisionDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RevisionDoesNotExistException.prototype);
    }
}
export class ThrottlingException extends __BaseException {
    name = "ThrottlingException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ThrottlingException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ThrottlingException.prototype);
    }
}
export const MinimumHealthyHostsType = {
    FLEET_PERCENT: "FLEET_PERCENT",
    HOST_COUNT: "HOST_COUNT",
};
export const TrafficRoutingType = {
    AllAtOnce: "AllAtOnce",
    TimeBasedCanary: "TimeBasedCanary",
    TimeBasedLinear: "TimeBasedLinear",
};
export const MinimumHealthyHostsPerZoneType = {
    FLEET_PERCENT: "FLEET_PERCENT",
    HOST_COUNT: "HOST_COUNT",
};
export class DeploymentConfigAlreadyExistsException extends __BaseException {
    name = "DeploymentConfigAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentConfigAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentConfigAlreadyExistsException.prototype);
    }
}
export class DeploymentConfigLimitExceededException extends __BaseException {
    name = "DeploymentConfigLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentConfigLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentConfigLimitExceededException.prototype);
    }
}
export class DeploymentConfigNameRequiredException extends __BaseException {
    name = "DeploymentConfigNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentConfigNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentConfigNameRequiredException.prototype);
    }
}
export class InvalidMinimumHealthyHostValueException extends __BaseException {
    name = "InvalidMinimumHealthyHostValueException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidMinimumHealthyHostValueException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidMinimumHealthyHostValueException.prototype);
    }
}
export class InvalidZonalDeploymentConfigurationException extends __BaseException {
    name = "InvalidZonalDeploymentConfigurationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidZonalDeploymentConfigurationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidZonalDeploymentConfigurationException.prototype);
    }
}
export class DeploymentGroupAlreadyExistsException extends __BaseException {
    name = "DeploymentGroupAlreadyExistsException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentGroupAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentGroupAlreadyExistsException.prototype);
    }
}
export class DeploymentGroupLimitExceededException extends __BaseException {
    name = "DeploymentGroupLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentGroupLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentGroupLimitExceededException.prototype);
    }
}
export class ECSServiceMappingLimitExceededException extends __BaseException {
    name = "ECSServiceMappingLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ECSServiceMappingLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ECSServiceMappingLimitExceededException.prototype);
    }
}
export class InvalidBlueGreenDeploymentConfigurationException extends __BaseException {
    name = "InvalidBlueGreenDeploymentConfigurationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidBlueGreenDeploymentConfigurationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidBlueGreenDeploymentConfigurationException.prototype);
    }
}
export class InvalidDeploymentStyleException extends __BaseException {
    name = "InvalidDeploymentStyleException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentStyleException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentStyleException.prototype);
    }
}
export class InvalidEC2TagCombinationException extends __BaseException {
    name = "InvalidEC2TagCombinationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidEC2TagCombinationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidEC2TagCombinationException.prototype);
    }
}
export class InvalidEC2TagException extends __BaseException {
    name = "InvalidEC2TagException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidEC2TagException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidEC2TagException.prototype);
    }
}
export class InvalidECSServiceException extends __BaseException {
    name = "InvalidECSServiceException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidECSServiceException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidECSServiceException.prototype);
    }
}
export class InvalidInputException extends __BaseException {
    name = "InvalidInputException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidInputException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidInputException.prototype);
    }
}
export class InvalidOnPremisesTagCombinationException extends __BaseException {
    name = "InvalidOnPremisesTagCombinationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidOnPremisesTagCombinationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidOnPremisesTagCombinationException.prototype);
    }
}
export class InvalidTargetGroupPairException extends __BaseException {
    name = "InvalidTargetGroupPairException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTargetGroupPairException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTargetGroupPairException.prototype);
    }
}
export class InvalidTriggerConfigException extends __BaseException {
    name = "InvalidTriggerConfigException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTriggerConfigException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTriggerConfigException.prototype);
    }
}
export class LifecycleHookLimitExceededException extends __BaseException {
    name = "LifecycleHookLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LifecycleHookLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LifecycleHookLimitExceededException.prototype);
    }
}
export class RoleRequiredException extends __BaseException {
    name = "RoleRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "RoleRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, RoleRequiredException.prototype);
    }
}
export class TagSetListLimitExceededException extends __BaseException {
    name = "TagSetListLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TagSetListLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TagSetListLimitExceededException.prototype);
    }
}
export class TriggerTargetsLimitExceededException extends __BaseException {
    name = "TriggerTargetsLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TriggerTargetsLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TriggerTargetsLimitExceededException.prototype);
    }
}
export class DeploymentConfigInUseException extends __BaseException {
    name = "DeploymentConfigInUseException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DeploymentConfigInUseException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DeploymentConfigInUseException.prototype);
    }
}
export class InvalidOperationException extends __BaseException {
    name = "InvalidOperationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidOperationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidOperationException.prototype);
    }
}
export class GitHubAccountTokenDoesNotExistException extends __BaseException {
    name = "GitHubAccountTokenDoesNotExistException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "GitHubAccountTokenDoesNotExistException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, GitHubAccountTokenDoesNotExistException.prototype);
    }
}
export class GitHubAccountTokenNameRequiredException extends __BaseException {
    name = "GitHubAccountTokenNameRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "GitHubAccountTokenNameRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, GitHubAccountTokenNameRequiredException.prototype);
    }
}
export class InvalidGitHubAccountTokenNameException extends __BaseException {
    name = "InvalidGitHubAccountTokenNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidGitHubAccountTokenNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidGitHubAccountTokenNameException.prototype);
    }
}
export class OperationNotSupportedException extends __BaseException {
    name = "OperationNotSupportedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "OperationNotSupportedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OperationNotSupportedException.prototype);
    }
}
export class ResourceValidationException extends __BaseException {
    name = "ResourceValidationException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceValidationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceValidationException.prototype);
    }
}
export class InvalidBucketNameFilterException extends __BaseException {
    name = "InvalidBucketNameFilterException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidBucketNameFilterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidBucketNameFilterException.prototype);
    }
}
export class InvalidDeployedStateFilterException extends __BaseException {
    name = "InvalidDeployedStateFilterException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeployedStateFilterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeployedStateFilterException.prototype);
    }
}
export class InvalidKeyPrefixFilterException extends __BaseException {
    name = "InvalidKeyPrefixFilterException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidKeyPrefixFilterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidKeyPrefixFilterException.prototype);
    }
}
export class InvalidNextTokenException extends __BaseException {
    name = "InvalidNextTokenException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidNextTokenException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidNextTokenException.prototype);
    }
}
export class InvalidSortByException extends __BaseException {
    name = "InvalidSortByException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidSortByException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidSortByException.prototype);
    }
}
export class InvalidSortOrderException extends __BaseException {
    name = "InvalidSortOrderException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidSortOrderException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidSortOrderException.prototype);
    }
}
export const ListStateFilterAction = {
    Exclude: "exclude",
    Ignore: "ignore",
    Include: "include",
};
export const SortOrder = {
    Ascending: "ascending",
    Descending: "descending",
};
export class InvalidDeploymentInstanceTypeException extends __BaseException {
    name = "InvalidDeploymentInstanceTypeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDeploymentInstanceTypeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDeploymentInstanceTypeException.prototype);
    }
}
export class InvalidInstanceStatusException extends __BaseException {
    name = "InvalidInstanceStatusException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidInstanceStatusException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidInstanceStatusException.prototype);
    }
}
export class InvalidInstanceTypeException extends __BaseException {
    name = "InvalidInstanceTypeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidInstanceTypeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidInstanceTypeException.prototype);
    }
}
export class InvalidTargetFilterNameException extends __BaseException {
    name = "InvalidTargetFilterNameException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTargetFilterNameException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTargetFilterNameException.prototype);
    }
}
export class InvalidExternalIdException extends __BaseException {
    name = "InvalidExternalIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidExternalIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidExternalIdException.prototype);
    }
}
export class InvalidTimeRangeException extends __BaseException {
    name = "InvalidTimeRangeException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTimeRangeException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTimeRangeException.prototype);
    }
}
export const TargetFilterName = {
    SERVER_INSTANCE_LABEL: "ServerInstanceLabel",
    TARGET_STATUS: "TargetStatus",
};
export class InvalidRegistrationStatusException extends __BaseException {
    name = "InvalidRegistrationStatusException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRegistrationStatusException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRegistrationStatusException.prototype);
    }
}
export class InvalidTagFilterException extends __BaseException {
    name = "InvalidTagFilterException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTagFilterException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTagFilterException.prototype);
    }
}
export const RegistrationStatus = {
    Deregistered: "Deregistered",
    Registered: "Registered",
};
export class InvalidArnException extends __BaseException {
    name = "InvalidArnException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidArnException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidArnException.prototype);
    }
}
export class ResourceArnRequiredException extends __BaseException {
    name = "ResourceArnRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceArnRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceArnRequiredException.prototype);
    }
}
export class InvalidLifecycleEventHookExecutionIdException extends __BaseException {
    name = "InvalidLifecycleEventHookExecutionIdException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidLifecycleEventHookExecutionIdException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidLifecycleEventHookExecutionIdException.prototype);
    }
}
export class InvalidLifecycleEventHookExecutionStatusException extends __BaseException {
    name = "InvalidLifecycleEventHookExecutionStatusException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidLifecycleEventHookExecutionStatusException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidLifecycleEventHookExecutionStatusException.prototype);
    }
}
export class LifecycleEventAlreadyCompletedException extends __BaseException {
    name = "LifecycleEventAlreadyCompletedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "LifecycleEventAlreadyCompletedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LifecycleEventAlreadyCompletedException.prototype);
    }
}
export class IamArnRequiredException extends __BaseException {
    name = "IamArnRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IamArnRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IamArnRequiredException.prototype);
    }
}
export class IamSessionArnAlreadyRegisteredException extends __BaseException {
    name = "IamSessionArnAlreadyRegisteredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IamSessionArnAlreadyRegisteredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IamSessionArnAlreadyRegisteredException.prototype);
    }
}
export class IamUserArnAlreadyRegisteredException extends __BaseException {
    name = "IamUserArnAlreadyRegisteredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IamUserArnAlreadyRegisteredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IamUserArnAlreadyRegisteredException.prototype);
    }
}
export class IamUserArnRequiredException extends __BaseException {
    name = "IamUserArnRequiredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IamUserArnRequiredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IamUserArnRequiredException.prototype);
    }
}
export class InstanceNameAlreadyRegisteredException extends __BaseException {
    name = "InstanceNameAlreadyRegisteredException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InstanceNameAlreadyRegisteredException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InstanceNameAlreadyRegisteredException.prototype);
    }
}
export class InvalidIamSessionArnException extends __BaseException {
    name = "InvalidIamSessionArnException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidIamSessionArnException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidIamSessionArnException.prototype);
    }
}
export class InvalidIamUserArnException extends __BaseException {
    name = "InvalidIamUserArnException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidIamUserArnException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidIamUserArnException.prototype);
    }
}
export class MultipleIamArnsProvidedException extends __BaseException {
    name = "MultipleIamArnsProvidedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MultipleIamArnsProvidedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MultipleIamArnsProvidedException.prototype);
    }
}
export const StopStatus = {
    PENDING: "Pending",
    SUCCEEDED: "Succeeded",
};
