from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkInteractionStyle
import vtkmodules.vtkRenderingContext2D
import vtkmodules.vtkViewsCore

class vtkApplyColors(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    cell_color_output_array_name:'getset_descriptor'
    cell_lookup_table:'getset_descriptor'
    default_cell_color:'getset_descriptor'
    default_cell_opacity:'getset_descriptor'
    default_point_color:'getset_descriptor'
    default_point_opacity:'getset_descriptor'
    m_time:'getset_descriptor'
    point_color_output_array_name:'getset_descriptor'
    point_lookup_table:'getset_descriptor'
    scale_cell_lookup_table:'getset_descriptor'
    scale_point_lookup_table:'getset_descriptor'
    selected_cell_color:'getset_descriptor'
    selected_cell_opacity:'getset_descriptor'
    selected_point_color:'getset_descriptor'
    selected_point_opacity:'getset_descriptor'
    use_cell_lookup_table:'getset_descriptor'
    use_current_annotation_color:'getset_descriptor'
    use_point_lookup_table:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellColorOutputArrayName(self) -> str: ...
    def GetCellLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetDefaultCellColor(self) -> Tuple[float, float, float]: ...
    def GetDefaultCellOpacity(self) -> float: ...
    def GetDefaultPointColor(self) -> Tuple[float, float, float]: ...
    def GetDefaultPointOpacity(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointColorOutputArrayName(self) -> str: ...
    def GetPointLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetScaleCellLookupTable(self) -> bool: ...
    def GetScalePointLookupTable(self) -> bool: ...
    def GetSelectedCellColor(self) -> Tuple[float, float, float]: ...
    def GetSelectedCellOpacity(self) -> float: ...
    def GetSelectedPointColor(self) -> Tuple[float, float, float]: ...
    def GetSelectedPointOpacity(self) -> float: ...
    def GetUseCellLookupTable(self) -> bool: ...
    def GetUseCurrentAnnotationColor(self) -> bool: ...
    def GetUsePointLookupTable(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkApplyColors': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkApplyColors': ...
    def ScaleCellLookupTableOff(self) -> None: ...
    def ScaleCellLookupTableOn(self) -> None: ...
    def ScalePointLookupTableOff(self) -> None: ...
    def ScalePointLookupTableOn(self) -> None: ...
    def SetCellColorOutputArrayName(self, _arg:str) -> None: ...
    def SetCellLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    @overload
    def SetDefaultCellColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultCellColor(self, _arg:Sequence[float]) -> None: ...
    def SetDefaultCellOpacity(self, _arg:float) -> None: ...
    @overload
    def SetDefaultPointColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultPointColor(self, _arg:Sequence[float]) -> None: ...
    def SetDefaultPointOpacity(self, _arg:float) -> None: ...
    def SetPointColorOutputArrayName(self, _arg:str) -> None: ...
    def SetPointLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetScaleCellLookupTable(self, _arg:bool) -> None: ...
    def SetScalePointLookupTable(self, _arg:bool) -> None: ...
    @overload
    def SetSelectedCellColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSelectedCellColor(self, _arg:Sequence[float]) -> None: ...
    def SetSelectedCellOpacity(self, _arg:float) -> None: ...
    @overload
    def SetSelectedPointColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSelectedPointColor(self, _arg:Sequence[float]) -> None: ...
    def SetSelectedPointOpacity(self, _arg:float) -> None: ...
    def SetUseCellLookupTable(self, _arg:bool) -> None: ...
    def SetUseCurrentAnnotationColor(self, _arg:bool) -> None: ...
    def SetUsePointLookupTable(self, _arg:bool) -> None: ...
    def UseCellLookupTableOff(self) -> None: ...
    def UseCellLookupTableOn(self) -> None: ...
    def UseCurrentAnnotationColorOff(self) -> None: ...
    def UseCurrentAnnotationColorOn(self) -> None: ...
    def UsePointLookupTableOff(self) -> None: ...
    def UsePointLookupTableOn(self) -> None: ...

class vtkApplyIcons(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    ANNOTATION_ICON:int
    IGNORE_SELECTION:int
    SELECTED_ICON:int
    SELECTED_OFFSET:int
    attribute_type:'getset_descriptor'
    default_icon:'getset_descriptor'
    icon_output_array_name:'getset_descriptor'
    selected_icon:'getset_descriptor'
    selection_mode:'getset_descriptor'
    use_lookup_table:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClearAllIconTypes(self) -> None: ...
    def GetAttributeType(self) -> int: ...
    def GetDefaultIcon(self) -> int: ...
    def GetIconOutputArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectedIcon(self) -> int: ...
    def GetSelectionMode(self) -> int: ...
    def GetUseLookupTable(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkApplyIcons': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkApplyIcons': ...
    def SetAttributeType(self, _arg:int) -> None: ...
    def SetDefaultIcon(self, _arg:int) -> None: ...
    def SetIconOutputArrayName(self, _arg:str) -> None: ...
    @overload
    def SetIconType(self, v:'vtkVariant', icon:int) -> None: ...
    @overload
    def SetIconType(self, v:float, icon:int) -> None: ...
    @overload
    def SetIconType(self, v:str, icon:int) -> None: ...
    def SetSelectedIcon(self, _arg:int) -> None: ...
    def SetSelectionMode(self, _arg:int) -> None: ...
    def SetSelectionModeToAnnotationIcon(self) -> None: ...
    def SetSelectionModeToIgnoreSelection(self) -> None: ...
    def SetSelectionModeToSelectedIcon(self) -> None: ...
    def SetSelectionModeToSelectedOffset(self) -> None: ...
    def SetUseLookupTable(self, _arg:bool) -> None: ...
    def UseLookupTableOff(self) -> None: ...
    def UseLookupTableOn(self) -> None: ...

class vtkDendrogramItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    DOWN_TO_UP:int
    LEFT_TO_RIGHT:int
    RIGHT_TO_LEFT:int
    UP_TO_DOWN:int
    color_array:'getset_descriptor'
    display_number_of_collapsed_leaf_nodes:'getset_descriptor'
    distance_array_name:'getset_descriptor'
    draw_labels:'getset_descriptor'
    extend_leaf_nodes:'getset_descriptor'
    label_width:'getset_descriptor'
    leaf_spacing:'getset_descriptor'
    line_width:'getset_descriptor'
    orientation:'getset_descriptor'
    position:'getset_descriptor'
    position_vector:'getset_descriptor'
    pruned_tree:'getset_descriptor'
    tree:'getset_descriptor'
    vertex_name_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CollapseToNumberOfLeafNodes(self, n:int) -> None: ...
    def ComputeLabelWidth(self, painter:'vtkContext2D') -> None: ...
    def DisplayNumberOfCollapsedLeafNodesOff(self) -> None: ...
    def DisplayNumberOfCollapsedLeafNodesOn(self) -> None: ...
    def DrawLabelsOff(self) -> None: ...
    def DrawLabelsOn(self) -> None: ...
    def ExtendLeafNodesOff(self) -> None: ...
    def ExtendLeafNodesOn(self) -> None: ...
    def GetAngleForOrientation(self, orientation:int) -> float: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDisplayNumberOfCollapsedLeafNodes(self) -> bool: ...
    def GetDistanceArrayName(self) -> str: ...
    def GetDrawLabels(self) -> bool: ...
    def GetExtendLeafNodes(self) -> bool: ...
    def GetLabelWidth(self) -> float: ...
    def GetLeafSpacing(self) -> float: ...
    def GetLineWidth(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPosition(self) -> Tuple[float, float]: ...
    def GetPositionOfVertex(self, vertexName:str, position:MutableSequence[float]) -> bool: ...
    def GetPositionVector(self) -> 'vtkVector2f': ...
    def GetPrunedTree(self) -> 'vtkTree': ...
    def GetTextAngleForOrientation(self, orientation:int) -> float: ...
    def GetTree(self) -> 'vtkTree': ...
    def GetVertexNameArrayName(self) -> str: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseDoubleClickEvent(self, event:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkDendrogramItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PrepareToPaint(self, painter:'vtkContext2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDendrogramItem': ...
    def SetColorArray(self, arrayName:str) -> None: ...
    def SetDisplayNumberOfCollapsedLeafNodes(self, _arg:bool) -> None: ...
    def SetDistanceArrayName(self, _arg:str) -> None: ...
    def SetDrawLabels(self, _arg:bool) -> None: ...
    def SetExtendLeafNodes(self, _arg:bool) -> None: ...
    def SetLeafSpacing(self, _arg:float) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPosition(self, pos:'vtkVector2f') -> None: ...
    def SetTree(self, tree:'vtkTree') -> None: ...
    def SetVertexNameArrayName(self, _arg:str) -> None: ...

class vtkGraphItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    graph:'getset_descriptor'
    layout:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetGraph(self) -> 'vtkGraph': ...
    def GetLayout(self) -> 'vtkIncrementalForceLayout': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphItem': ...
    def SetGraph(self, graph:'vtkGraph') -> None: ...
    def StartLayoutAnimation(self, interactor:'vtkRenderWindowInteractor') -> None: ...
    def StopLayoutAnimation(self) -> None: ...
    def UpdateLayout(self) -> None: ...

class vtkRenderView(vtkmodules.vtkViewsCore.vtkRenderViewBase):
    ALL:int
    FREETYPE:int
    FRUSTUM:int
    INTERACTION_MODE_2D:int
    INTERACTION_MODE_3D:int
    INTERACTION_MODE_UNKNOWN:int
    NO_OVERLAP:int
    QT:int
    SURFACE:int
    display_hover_text:'getset_descriptor'
    display_size:'getset_descriptor'
    icon_size:'getset_descriptor'
    icon_texture:'getset_descriptor'
    interaction_mode:'getset_descriptor'
    interactor:'getset_descriptor'
    interactor_style:'getset_descriptor'
    label_placement_mode:'getset_descriptor'
    label_render_mode:'getset_descriptor'
    render_on_mouse_move:'getset_descriptor'
    render_window:'getset_descriptor'
    selection_mode:'getset_descriptor'
    transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddLabels(self, conn:'vtkAlgorithmOutput') -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def DisplayHoverTextOff(self) -> None: ...
    def DisplayHoverTextOn(self) -> None: ...
    def GetDisplayHoverText(self) -> bool: ...
    @overload
    def GetDisplaySize(self) -> Pointer: ...
    @overload
    def GetDisplaySize(self, dsx:int, dsy:int) -> None: ...
    def GetIconSize(self) -> Tuple[int, int]: ...
    def GetIconTexture(self) -> 'vtkTexture': ...
    def GetInteractionMode(self) -> int: ...
    def GetInteractorStyle(self) -> 'vtkInteractorObserver': ...
    def GetLabelPlacementMode(self) -> int: ...
    def GetLabelRenderMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderOnMouseMove(self) -> bool: ...
    def GetSelectionMode(self) -> int: ...
    def GetSelectionModeMaxValue(self) -> int: ...
    def GetSelectionModeMinValue(self) -> int: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderView': ...
    def RemoveLabels(self, conn:'vtkAlgorithmOutput') -> None: ...
    def Render(self) -> None: ...
    def RenderOnMouseMoveOff(self) -> None: ...
    def RenderOnMouseMoveOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderView': ...
    def SetDisplayHoverText(self, b:bool) -> None: ...
    @overload
    def SetDisplaySize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetDisplaySize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetIconSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetIconSize(self, _arg:Sequence[int]) -> None: ...
    def SetIconTexture(self, texture:'vtkTexture') -> None: ...
    def SetInteractionMode(self, mode:int) -> None: ...
    def SetInteractionModeTo2D(self) -> None: ...
    def SetInteractionModeTo3D(self) -> None: ...
    def SetInteractor(self, interactor:'vtkRenderWindowInteractor') -> None: ...
    def SetInteractorStyle(self, style:'vtkInteractorObserver') -> None: ...
    def SetLabelPlacementMode(self, mode:int) -> None: ...
    def SetLabelPlacementModeToAll(self) -> None: ...
    def SetLabelPlacementModeToNoOverlap(self) -> None: ...
    def SetLabelRenderMode(self, mode:int) -> None: ...
    def SetLabelRenderModeToFreetype(self) -> None: ...
    def SetLabelRenderModeToQt(self) -> None: ...
    def SetRenderOnMouseMove(self, b:bool) -> None: ...
    def SetRenderWindow(self, win:'vtkRenderWindow') -> None: ...
    def SetSelectionMode(self, _arg:int) -> None: ...
    def SetSelectionModeToFrustum(self) -> None: ...
    def SetSelectionModeToSurface(self) -> None: ...
    def SetTransform(self, transform:'vtkAbstractTransform') -> None: ...

class vtkGraphLayoutView(vtkRenderView):
    color_edges:'getset_descriptor'
    color_vertices:'getset_descriptor'
    edge_color_array_name:'getset_descriptor'
    edge_label_array_name:'getset_descriptor'
    edge_label_font_size:'getset_descriptor'
    edge_label_visibility:'getset_descriptor'
    edge_layout_strategy:'getset_descriptor'
    edge_layout_strategy_name:'getset_descriptor'
    edge_scalar_bar_visibility:'getset_descriptor'
    edge_selection:'getset_descriptor'
    edge_visibility:'getset_descriptor'
    enable_edges_by_array:'getset_descriptor'
    enable_vertices_by_array:'getset_descriptor'
    enabled_edges_array_name:'getset_descriptor'
    enabled_vertices_array_name:'getset_descriptor'
    glyph_type:'getset_descriptor'
    hide_edge_labels_on_interaction:'getset_descriptor'
    hide_vertex_labels_on_interaction:'getset_descriptor'
    icon_alignment:'getset_descriptor'
    icon_array_name:'getset_descriptor'
    icon_visibility:'getset_descriptor'
    layout_strategy:'getset_descriptor'
    layout_strategy_name:'getset_descriptor'
    scaled_glyphs:'getset_descriptor'
    scaling_array_name:'getset_descriptor'
    vertex_color_array_name:'getset_descriptor'
    vertex_label_array_name:'getset_descriptor'
    vertex_label_font_size:'getset_descriptor'
    vertex_label_visibility:'getset_descriptor'
    vertex_scalar_bar_visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddIconType(self, type:str, index:int) -> None: ...
    def ClearIconTypes(self) -> None: ...
    def ColorEdgesOff(self) -> None: ...
    def ColorEdgesOn(self) -> None: ...
    def ColorVerticesOff(self) -> None: ...
    def ColorVerticesOn(self) -> None: ...
    def EdgeLabelVisibilityOff(self) -> None: ...
    def EdgeLabelVisibilityOn(self) -> None: ...
    def EdgeSelectionOff(self) -> None: ...
    def EdgeSelectionOn(self) -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def GetColorEdges(self) -> bool: ...
    def GetColorVertices(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeLabelArrayName(self) -> str: ...
    def GetEdgeLabelFontSize(self) -> int: ...
    def GetEdgeLabelVisibility(self) -> bool: ...
    def GetEdgeLayoutStrategy(self) -> 'vtkEdgeLayoutStrategy': ...
    def GetEdgeLayoutStrategyName(self) -> str: ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    def GetEdgeSelection(self) -> bool: ...
    def GetEdgeVisibility(self) -> bool: ...
    def GetEnableEdgesByArray(self) -> int: ...
    def GetEnableVerticesByArray(self) -> int: ...
    def GetEnabledEdgesArrayName(self) -> str: ...
    def GetEnabledVerticesArrayName(self) -> str: ...
    def GetGlyphType(self) -> int: ...
    def GetHideEdgeLabelsOnInteraction(self) -> bool: ...
    def GetHideVertexLabelsOnInteraction(self) -> bool: ...
    def GetIconArrayName(self) -> str: ...
    def GetIconVisibility(self) -> bool: ...
    def GetLayoutStrategy(self) -> 'vtkGraphLayoutStrategy': ...
    def GetLayoutStrategyName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaledGlyphs(self) -> bool: ...
    def GetScalingArrayName(self) -> str: ...
    def GetVertexColorArrayName(self) -> str: ...
    def GetVertexLabelArrayName(self) -> str: ...
    def GetVertexLabelFontSize(self) -> int: ...
    def GetVertexLabelVisibility(self) -> bool: ...
    def GetVertexScalarBarVisibility(self) -> bool: ...
    def HideEdgeLabelsOnInteractionOff(self) -> None: ...
    def HideEdgeLabelsOnInteractionOn(self) -> None: ...
    def HideVertexLabelsOnInteractionOff(self) -> None: ...
    def HideVertexLabelsOnInteractionOn(self) -> None: ...
    def IconVisibilityOff(self) -> None: ...
    def IconVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphLayoutView': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphLayoutView': ...
    def ScaledGlyphsOff(self) -> None: ...
    def ScaledGlyphsOn(self) -> None: ...
    def SetColorEdges(self, vis:bool) -> None: ...
    def SetColorVertices(self, vis:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeLabelArrayName(self, name:str) -> None: ...
    def SetEdgeLabelFontSize(self, size:int) -> None: ...
    def SetEdgeLabelVisibility(self, vis:bool) -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, name:str) -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, s:'vtkEdgeLayoutStrategy') -> None: ...
    def SetEdgeLayoutStrategyToArcParallel(self) -> None: ...
    def SetEdgeLayoutStrategyToPassThrough(self) -> None: ...
    def SetEdgeScalarBarVisibility(self, vis:bool) -> None: ...
    def SetEdgeSelection(self, vis:bool) -> None: ...
    def SetEdgeVisibility(self, vis:bool) -> None: ...
    def SetEnableEdgesByArray(self, vis:bool) -> None: ...
    def SetEnableVerticesByArray(self, vis:bool) -> None: ...
    def SetEnabledEdgesArrayName(self, name:str) -> None: ...
    def SetEnabledVerticesArrayName(self, name:str) -> None: ...
    def SetGlyphType(self, type:int) -> None: ...
    def SetHideEdgeLabelsOnInteraction(self, vis:bool) -> None: ...
    def SetHideVertexLabelsOnInteraction(self, vis:bool) -> None: ...
    def SetIconAlignment(self, alignment:int) -> None: ...
    def SetIconArrayName(self, name:str) -> None: ...
    def SetIconVisibility(self, b:bool) -> None: ...
    @overload
    def SetLayoutStrategy(self, name:str) -> None: ...
    @overload
    def SetLayoutStrategy(self, s:'vtkGraphLayoutStrategy') -> None: ...
    def SetLayoutStrategyToCircular(self) -> None: ...
    def SetLayoutStrategyToClustering2D(self) -> None: ...
    def SetLayoutStrategyToCommunity2D(self) -> None: ...
    def SetLayoutStrategyToCone(self) -> None: ...
    def SetLayoutStrategyToCosmicTree(self) -> None: ...
    def SetLayoutStrategyToFast2D(self) -> None: ...
    def SetLayoutStrategyToForceDirected(self) -> None: ...
    def SetLayoutStrategyToPassThrough(self) -> None: ...
    def SetLayoutStrategyToRandom(self) -> None: ...
    def SetLayoutStrategyToSimple2D(self) -> None: ...
    def SetLayoutStrategyToSpanTree(self) -> None: ...
    def SetLayoutStrategyToTree(self) -> None: ...
    def SetScaledGlyphs(self, arg:bool) -> None: ...
    def SetScalingArrayName(self, name:str) -> None: ...
    def SetVertexColorArrayName(self, name:str) -> None: ...
    def SetVertexLabelArrayName(self, name:str) -> None: ...
    def SetVertexLabelFontSize(self, size:int) -> None: ...
    def SetVertexLabelVisibility(self, vis:bool) -> None: ...
    def SetVertexScalarBarVisibility(self, vis:bool) -> None: ...
    def UpdateLayout(self) -> None: ...
    def VertexLabelVisibilityOff(self) -> None: ...
    def VertexLabelVisibilityOn(self) -> None: ...
    def ZoomToSelection(self) -> None: ...

class vtkHeatmapItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    DOWN_TO_UP:int
    LEFT_TO_RIGHT:int
    RIGHT_TO_LEFT:int
    UP_TO_DOWN:int
    cell_height:'getset_descriptor'
    cell_width:'getset_descriptor'
    column_label_width:'getset_descriptor'
    name_column:'getset_descriptor'
    orientation:'getset_descriptor'
    position:'getset_descriptor'
    position_vector:'getset_descriptor'
    row_label_width:'getset_descriptor'
    row_names:'getset_descriptor'
    table:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCellHeight(self) -> float: ...
    def GetCellWidth(self) -> float: ...
    def GetColumnLabelWidth(self) -> float: ...
    def GetNameColumn(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPosition(self) -> Tuple[float, float]: ...
    def GetPositionVector(self) -> 'vtkVector2f': ...
    def GetRowLabelWidth(self) -> float: ...
    def GetRowNames(self) -> 'vtkStringArray': ...
    def GetTable(self) -> 'vtkTable': ...
    def GetTextAngleForOrientation(self, orientation:int) -> float: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkRowAsBlank(self, rowName:str) -> None: ...
    def MouseDoubleClickEvent(self, event:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, event:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkHeatmapItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHeatmapItem': ...
    def SetCellHeight(self, _arg:float) -> None: ...
    def SetCellWidth(self, _arg:float) -> None: ...
    def SetNameColumn(self, _arg:str) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPosition(self, pos:'vtkVector2f') -> None: ...
    def SetTable(self, table:'vtkTable') -> None: ...

class vtkHierarchicalGraphPipeline(vtkmodules.vtkCommonCore.vtkObject):
    actor:'getset_descriptor'
    bundling_strength:'getset_descriptor'
    color_array_name:'getset_descriptor'
    color_edges_by_array:'getset_descriptor'
    hover_array_name:'getset_descriptor'
    label_actor:'getset_descriptor'
    label_array_name:'getset_descriptor'
    label_text_property:'getset_descriptor'
    label_visibility:'getset_descriptor'
    spline_type:'getset_descriptor'
    visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def ColorEdgesByArrayOff(self) -> None: ...
    def ColorEdgesByArrayOn(self) -> None: ...
    def ConvertSelection(self, rep:'vtkDataRepresentation', sel:'vtkSelection') -> 'vtkSelection': ...
    def GetActor(self) -> 'vtkActor': ...
    def GetBundlingStrength(self) -> float: ...
    def GetColorArrayName(self) -> str: ...
    def GetColorEdgesByArray(self) -> bool: ...
    def GetHoverArrayName(self) -> str: ...
    def GetLabelActor(self) -> 'vtkActor2D': ...
    def GetLabelArrayName(self) -> str: ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLabelVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSplineType(self) -> int: ...
    def GetVisibility(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkHierarchicalGraphPipeline': ...
    def PrepareInputConnections(self, graphConn:'vtkAlgorithmOutput', treeConn:'vtkAlgorithmOutput', annConn:'vtkAlgorithmOutput') -> None: ...
    def RegisterProgress(self, view:'vtkRenderView') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalGraphPipeline': ...
    def SetBundlingStrength(self, strength:float) -> None: ...
    def SetColorArrayName(self, name:str) -> None: ...
    def SetColorEdgesByArray(self, vis:bool) -> None: ...
    def SetHoverArrayName(self, _arg:str) -> None: ...
    def SetLabelArrayName(self, name:str) -> None: ...
    def SetLabelTextProperty(self, prop:'vtkTextProperty') -> None: ...
    def SetLabelVisibility(self, vis:bool) -> None: ...
    def SetSplineType(self, type:int) -> None: ...
    def SetVisibility(self, vis:bool) -> None: ...
    def VisibilityOff(self) -> None: ...
    def VisibilityOn(self) -> None: ...

class vtkHierarchicalGraphView(vtkGraphLayoutView):
    bundling_strength:'getset_descriptor'
    color_graph_edges_by_array:'getset_descriptor'
    graph_edge_color_array_name:'getset_descriptor'
    graph_edge_label_array_name:'getset_descriptor'
    graph_edge_label_font_size:'getset_descriptor'
    graph_edge_label_visibility:'getset_descriptor'
    graph_visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ColorGraphEdgesByArrayOff(self) -> None: ...
    def ColorGraphEdgesByArrayOn(self) -> None: ...
    def GetBundlingStrength(self) -> float: ...
    def GetColorGraphEdgesByArray(self) -> bool: ...
    def GetGraphEdgeColorArrayName(self) -> str: ...
    def GetGraphEdgeLabelArrayName(self) -> str: ...
    def GetGraphEdgeLabelFontSize(self) -> int: ...
    def GetGraphEdgeLabelVisibility(self) -> bool: ...
    def GetGraphVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GraphEdgeLabelVisibilityOff(self) -> None: ...
    def GraphEdgeLabelVisibilityOn(self) -> None: ...
    def GraphVisibilityOff(self) -> None: ...
    def GraphVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHierarchicalGraphView': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalGraphView': ...
    def SetBundlingStrength(self, strength:float) -> None: ...
    def SetColorGraphEdgesByArray(self, vis:bool) -> None: ...
    def SetGraphEdgeColorArrayName(self, name:str) -> None: ...
    def SetGraphEdgeColorToSplineFraction(self) -> None: ...
    def SetGraphEdgeLabelArrayName(self, name:str) -> None: ...
    def SetGraphEdgeLabelFontSize(self, size:int) -> None: ...
    def SetGraphEdgeLabelVisibility(self, vis:bool) -> None: ...
    def SetGraphFromInput(self, input:'vtkDataObject') -> 'vtkDataRepresentation': ...
    def SetGraphFromInputConnection(self, conn:'vtkAlgorithmOutput') -> 'vtkDataRepresentation': ...
    def SetGraphVisibility(self, vis:bool) -> None: ...
    def SetHierarchyFromInput(self, input:'vtkDataObject') -> 'vtkDataRepresentation': ...
    def SetHierarchyFromInputConnection(self, conn:'vtkAlgorithmOutput') -> 'vtkDataRepresentation': ...

class vtkTreeAreaView(vtkRenderView):
    area_color_array_name:'getset_descriptor'
    area_hover_array_name:'getset_descriptor'
    area_label_array_name:'getset_descriptor'
    area_label_font_size:'getset_descriptor'
    area_label_visibility:'getset_descriptor'
    area_size_array_name:'getset_descriptor'
    bundling_strength:'getset_descriptor'
    color_areas:'getset_descriptor'
    color_edges:'getset_descriptor'
    edge_color_array_name:'getset_descriptor'
    edge_label_array_name:'getset_descriptor'
    edge_label_font_size:'getset_descriptor'
    edge_label_visibility:'getset_descriptor'
    edge_scalar_bar_visibility:'getset_descriptor'
    label_priority_array_name:'getset_descriptor'
    layout_strategy:'getset_descriptor'
    shrink_percentage:'getset_descriptor'
    use_rectangular_coordinates:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AreaLabelVisibilityOff(self) -> None: ...
    def AreaLabelVisibilityOn(self) -> None: ...
    def ColorAreasOff(self) -> None: ...
    def ColorAreasOn(self) -> None: ...
    def ColorEdgesOff(self) -> None: ...
    def ColorEdgesOn(self) -> None: ...
    def EdgeLabelVisibilityOff(self) -> None: ...
    def EdgeLabelVisibilityOn(self) -> None: ...
    def GetAreaColorArrayName(self) -> str: ...
    def GetAreaHoverArrayName(self) -> str: ...
    def GetAreaLabelArrayName(self) -> str: ...
    def GetAreaLabelFontSize(self) -> int: ...
    def GetAreaLabelVisibility(self) -> bool: ...
    def GetAreaSizeArrayName(self) -> str: ...
    def GetBundlingStrength(self) -> float: ...
    def GetColorAreas(self) -> bool: ...
    def GetColorEdges(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeLabelArrayName(self) -> str: ...
    def GetEdgeLabelFontSize(self) -> int: ...
    def GetEdgeLabelVisibility(self) -> bool: ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    def GetLabelPriorityArrayName(self) -> str: ...
    def GetLayoutStrategy(self) -> 'vtkAreaLayoutStrategy': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkPercentage(self) -> float: ...
    def GetUseRectangularCoordinates(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeAreaView': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeAreaView': ...
    def SetAreaColorArrayName(self, name:str) -> None: ...
    def SetAreaHoverArrayName(self, name:str) -> None: ...
    def SetAreaLabelArrayName(self, name:str) -> None: ...
    def SetAreaLabelFontSize(self, size:int) -> None: ...
    def SetAreaLabelVisibility(self, vis:bool) -> None: ...
    def SetAreaSizeArrayName(self, name:str) -> None: ...
    def SetBundlingStrength(self, strength:float) -> None: ...
    def SetColorAreas(self, vis:bool) -> None: ...
    def SetColorEdges(self, vis:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeColorToSplineFraction(self) -> None: ...
    def SetEdgeLabelArrayName(self, name:str) -> None: ...
    def SetEdgeLabelFontSize(self, size:int) -> None: ...
    def SetEdgeLabelVisibility(self, vis:bool) -> None: ...
    def SetEdgeScalarBarVisibility(self, b:bool) -> None: ...
    def SetGraphFromInput(self, input:'vtkGraph') -> 'vtkDataRepresentation': ...
    def SetGraphFromInputConnection(self, conn:'vtkAlgorithmOutput') -> 'vtkDataRepresentation': ...
    def SetLabelPriorityArrayName(self, name:str) -> None: ...
    def SetLayoutStrategy(self, strategy:'vtkAreaLayoutStrategy') -> None: ...
    def SetShrinkPercentage(self, value:float) -> None: ...
    def SetTreeFromInput(self, input:'vtkTree') -> 'vtkDataRepresentation': ...
    def SetTreeFromInputConnection(self, conn:'vtkAlgorithmOutput') -> 'vtkDataRepresentation': ...
    def SetUseRectangularCoordinates(self, rect:bool) -> None: ...
    def UseRectangularCoordinatesOff(self) -> None: ...
    def UseRectangularCoordinatesOn(self) -> None: ...

class vtkIcicleView(vtkTreeAreaView):
    layer_thickness:'getset_descriptor'
    root_width:'getset_descriptor'
    top_to_bottom:'getset_descriptor'
    use_gradient_coloring:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLayerThickness(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRootWidth(self) -> float: ...
    def GetTopToBottom(self) -> bool: ...
    def GetUseGradientColoring(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIcicleView': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIcicleView': ...
    def SetLayerThickness(self, thickness:float) -> None: ...
    def SetRootWidth(self, width:float) -> None: ...
    def SetTopToBottom(self, reversed:bool) -> None: ...
    def SetUseGradientColoring(self, value:bool) -> None: ...
    def TopToBottomOff(self) -> None: ...
    def TopToBottomOn(self) -> None: ...
    def UseGradientColoringOff(self) -> None: ...
    def UseGradientColoringOn(self) -> None: ...

class vtkInteractorStyleAreaSelectHover(vtkmodules.vtkInteractionStyle.vtkInteractorStyleRubberBand2D):
    high_light_color:'getset_descriptor'
    high_light_width:'getset_descriptor'
    interactor:'getset_descriptor'
    label_field:'getset_descriptor'
    layout:'getset_descriptor'
    use_rectangular_coordinates:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetHighLightWidth(self) -> float: ...
    def GetIdAtPos(self, x:int, y:int) -> int: ...
    def GetLabelField(self) -> str: ...
    def GetLayout(self) -> 'vtkAreaLayout': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseRectangularCoordinates(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInteractorStyleAreaSelectHover': ...
    def OnMouseMove(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractorStyleAreaSelectHover': ...
    def SetHighLightColor(self, r:float, g:float, b:float) -> None: ...
    def SetHighLightWidth(self, lw:float) -> None: ...
    def SetInteractor(self, rwi:'vtkRenderWindowInteractor') -> None: ...
    def SetLabelField(self, _arg:str) -> None: ...
    def SetLayout(self, layout:'vtkAreaLayout') -> None: ...
    def SetUseRectangularCoordinates(self, _arg:bool) -> None: ...
    def UseRectangularCoordinatesOff(self) -> None: ...
    def UseRectangularCoordinatesOn(self) -> None: ...

class vtkInteractorStyleTreeMapHover(vtkmodules.vtkInteractionStyle.vtkInteractorStyleImage):
    high_light_color:'getset_descriptor'
    high_light_width:'getset_descriptor'
    interactor:'getset_descriptor'
    label_field:'getset_descriptor'
    layout:'getset_descriptor'
    selection_light_color:'getset_descriptor'
    selection_width:'getset_descriptor'
    tree_map_to_poly_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetHighLightWidth(self) -> float: ...
    def GetLabelField(self) -> str: ...
    def GetLayout(self) -> 'vtkTreeMapLayout': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectionWidth(self) -> float: ...
    def GetTreeMapToPolyData(self) -> 'vtkTreeMapToPolyData': ...
    def HighLightCurrentSelectedItem(self) -> None: ...
    def HighLightItem(self, id:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInteractorStyleTreeMapHover': ...
    def OnLeftButtonUp(self) -> None: ...
    def OnMouseMove(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractorStyleTreeMapHover': ...
    def SetHighLightColor(self, r:float, g:float, b:float) -> None: ...
    def SetHighLightWidth(self, lw:float) -> None: ...
    def SetInteractor(self, rwi:'vtkRenderWindowInteractor') -> None: ...
    def SetLabelField(self, _arg:str) -> None: ...
    def SetLayout(self, layout:'vtkTreeMapLayout') -> None: ...
    def SetSelectionLightColor(self, r:float, g:float, b:float) -> None: ...
    def SetSelectionWidth(self, lw:float) -> None: ...
    def SetTreeMapToPolyData(self, filter:'vtkTreeMapToPolyData') -> None: ...

class vtkRenderedRepresentation(vtkmodules.vtkViewsCore.vtkDataRepresentation):
    label_render_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLabelRenderMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderedRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderedRepresentation': ...
    def SetLabelRenderMode(self, _arg:int) -> None: ...

class vtkParallelCoordinatesRepresentation(vtkRenderedRepresentation):
    class InputPorts(int): ...
    INPUT_DATA:'InputPorts'
    INPUT_TITLES:'InputPorts'
    NUM_INPUT_PORTS:'InputPorts'
    angle_brush_threshold:'getset_descriptor'
    axis_color:'getset_descriptor'
    axis_label_color:'getset_descriptor'
    axis_titles:'getset_descriptor'
    curve_resolution:'getset_descriptor'
    font_size:'getset_descriptor'
    function_brush_threshold:'getset_descriptor'
    line_color:'getset_descriptor'
    line_opacity:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    number_of_axis_labels:'getset_descriptor'
    number_of_samples:'getset_descriptor'
    plot_title:'getset_descriptor'
    use_curves:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AngleSelect(self, brushClass:int, brushOperator:int, p1:MutableSequence[float], p2:MutableSequence[float]) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def FunctionSelect(self, brushClass:int, brushOperator:int, p1:MutableSequence[float], p2:MutableSequence[float], q1:MutableSequence[float], q2:MutableSequence[float]) -> None: ...
    def GetAngleBrushThreshold(self) -> float: ...
    def GetAxisColor(self) -> Tuple[float, float, float]: ...
    def GetAxisLabelColor(self) -> Tuple[float, float, float]: ...
    def GetCurveResolution(self) -> int: ...
    def GetFontSize(self) -> float: ...
    def GetFunctionBrushThreshold(self) -> float: ...
    def GetHoverString(self, view:'vtkView', x:int, y:int) -> str: ...
    def GetLineColor(self) -> Tuple[float, float, float]: ...
    def GetLineOpacity(self) -> float: ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfAxisLabels(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSamples(self) -> int: ...
    def GetPositionAndSize(self, position:MutableSequence[float], size:MutableSequence[float]) -> int: ...
    def GetPositionNearXCoordinate(self, xcoord:float) -> int: ...
    def GetRangeAtPosition(self, position:int, range:MutableSequence[float]) -> int: ...
    def GetUseCurves(self) -> int: ...
    def GetXCoordinateOfPosition(self, axis:int) -> float: ...
    def GetXCoordinatesOfPositions(self, coords:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LassoSelect(self, brushClass:int, brushOperator:int, brushPoints:'vtkPoints') -> None: ...
    def NewInstance(self) -> 'vtkParallelCoordinatesRepresentation': ...
    def RangeSelect(self, brushClass:int, brushOperator:int, p1:MutableSequence[float], p2:MutableSequence[float]) -> None: ...
    def ResetAxes(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelCoordinatesRepresentation': ...
    def SetAngleBrushThreshold(self, _arg:float) -> None: ...
    @overload
    def SetAxisColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAxisLabelColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisLabelColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAxisTitles(self, __a:'vtkStringArray') -> None: ...
    @overload
    def SetAxisTitles(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetCurveResolution(self, _arg:int) -> None: ...
    def SetFontSize(self, _arg:float) -> None: ...
    def SetFunctionBrushThreshold(self, _arg:float) -> None: ...
    @overload
    def SetLineColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLineColor(self, _arg:Sequence[float]) -> None: ...
    def SetLineOpacity(self, _arg:float) -> None: ...
    def SetNumberOfAxisLabels(self, num:int) -> None: ...
    def SetPlotTitle(self, __a:str) -> None: ...
    def SetPositionAndSize(self, position:MutableSequence[float], size:MutableSequence[float]) -> int: ...
    def SetRangeAtPosition(self, position:int, range:MutableSequence[float]) -> int: ...
    def SetUseCurves(self, _arg:int) -> None: ...
    def SetXCoordinateOfPosition(self, position:int, xcoord:float) -> int: ...
    def SwapAxisPositions(self, position1:int, position2:int) -> int: ...
    def UseCurvesOff(self) -> None: ...
    def UseCurvesOn(self) -> None: ...

class vtkParallelCoordinatesHistogramRepresentation(vtkParallelCoordinatesRepresentation):
    histogram_lookup_table_range:'getset_descriptor'
    number_of_histogram_bins:'getset_descriptor'
    preferred_number_of_outliers:'getset_descriptor'
    show_outliers:'getset_descriptor'
    use_histograms:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def GetHistogramLookupTableRange(self) -> Tuple[float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfHistogramBins(self) -> Tuple[int, int]: ...
    def GetPreferredNumberOfOutliers(self) -> int: ...
    def GetShowOutliers(self) -> int: ...
    def GetUseHistograms(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParallelCoordinatesHistogramRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelCoordinatesHistogramRepresentation': ...
    @overload
    def SetHistogramLookupTableRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetHistogramLookupTableRange(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetNumberOfHistogramBins(self, __a:int, __b:int) -> None: ...
    @overload
    def SetNumberOfHistogramBins(self, __a:MutableSequence[int]) -> None: ...
    def SetPreferredNumberOfOutliers(self, __a:int) -> None: ...
    def SetRangeAtPosition(self, position:int, range:MutableSequence[float]) -> int: ...
    def SetShowOutliers(self, __a:int) -> None: ...
    def SetUseHistograms(self, __a:int) -> None: ...
    def ShowOutliersOff(self) -> None: ...
    def ShowOutliersOn(self) -> None: ...
    def SwapAxisPositions(self, position1:int, position2:int) -> int: ...
    def UseHistogramsOff(self) -> None: ...
    def UseHistogramsOn(self) -> None: ...

class vtkParallelCoordinatesView(vtkRenderView):
    VTK_BRUSHOPERATOR_ADD:int
    VTK_BRUSHOPERATOR_INTERSECT:int
    VTK_BRUSHOPERATOR_MODECOUNT:int
    VTK_BRUSHOPERATOR_REPLACE:int
    VTK_BRUSHOPERATOR_SUBTRACT:int
    VTK_BRUSH_ANGLE:int
    VTK_BRUSH_AXISTHRESHOLD:int
    VTK_BRUSH_FUNCTION:int
    VTK_BRUSH_LASSO:int
    VTK_BRUSH_MODECOUNT:int
    VTK_INSPECT_MANIPULATE_AXES:int
    VTK_INSPECT_MODECOUNT:int
    VTK_INSPECT_SELECT_DATA:int
    brush_mode:'getset_descriptor'
    brush_operator:'getset_descriptor'
    current_brush_class:'getset_descriptor'
    inspect_mode:'getset_descriptor'
    maximum_number_of_brush_points:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def GetBrushMode(self) -> int: ...
    def GetBrushOperator(self) -> int: ...
    def GetCurrentBrushClass(self) -> int: ...
    def GetInspectMode(self) -> int: ...
    def GetMaximumNumberOfBrushPoints(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParallelCoordinatesView': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelCoordinatesView': ...
    def SetBrushMode(self, __a:int) -> None: ...
    def SetBrushModeToAngle(self) -> None: ...
    def SetBrushModeToAxisThreshold(self) -> None: ...
    def SetBrushModeToFunction(self) -> None: ...
    def SetBrushModeToLasso(self) -> None: ...
    def SetBrushOperator(self, __a:int) -> None: ...
    def SetBrushOperatorToAdd(self) -> None: ...
    def SetBrushOperatorToIntersect(self) -> None: ...
    def SetBrushOperatorToReplace(self) -> None: ...
    def SetBrushOperatorToSubtract(self) -> None: ...
    def SetCurrentBrushClass(self, _arg:int) -> None: ...
    def SetInpsectModeToSelectData(self) -> None: ...
    def SetInspectMode(self, __a:int) -> None: ...
    def SetInspectModeToManipulateAxes(self) -> None: ...
    def SetMaximumNumberOfBrushPoints(self, __a:int) -> None: ...

class vtkRenderedGraphRepresentation(vtkRenderedRepresentation):
    color_edges_by_array:'getset_descriptor'
    color_vertices_by_array:'getset_descriptor'
    edge_color_array_name:'getset_descriptor'
    edge_hover_array_name:'getset_descriptor'
    edge_icon_alignment:'getset_descriptor'
    edge_icon_array_name:'getset_descriptor'
    edge_icon_priority_array_name:'getset_descriptor'
    edge_icon_visibility:'getset_descriptor'
    edge_label_array_name:'getset_descriptor'
    edge_label_priority_array_name:'getset_descriptor'
    edge_label_text_property:'getset_descriptor'
    edge_label_visibility:'getset_descriptor'
    edge_layout_strategy:'getset_descriptor'
    edge_layout_strategy_name:'getset_descriptor'
    edge_layout_strategy_to_geo:'getset_descriptor'
    edge_scalar_bar:'getset_descriptor'
    edge_scalar_bar_visibility:'getset_descriptor'
    edge_selection:'getset_descriptor'
    edge_visibility:'getset_descriptor'
    enable_edges_by_array:'getset_descriptor'
    enable_vertices_by_array:'getset_descriptor'
    enabled_edges_array_name:'getset_descriptor'
    enabled_vertices_array_name:'getset_descriptor'
    glyph_type:'getset_descriptor'
    hide_edge_labels_on_interaction:'getset_descriptor'
    hide_vertex_labels_on_interaction:'getset_descriptor'
    layout_strategy:'getset_descriptor'
    layout_strategy_name:'getset_descriptor'
    scaling:'getset_descriptor'
    scaling_array_name:'getset_descriptor'
    use_edge_icon_type_map:'getset_descriptor'
    use_vertex_icon_type_map:'getset_descriptor'
    vertex_color_array_name:'getset_descriptor'
    vertex_default_icon:'getset_descriptor'
    vertex_hover_array_name:'getset_descriptor'
    vertex_icon_alignment:'getset_descriptor'
    vertex_icon_array_name:'getset_descriptor'
    vertex_icon_priority_array_name:'getset_descriptor'
    vertex_icon_selection_mode:'getset_descriptor'
    vertex_icon_visibility:'getset_descriptor'
    vertex_label_array_name:'getset_descriptor'
    vertex_label_priority_array_name:'getset_descriptor'
    vertex_label_text_property:'getset_descriptor'
    vertex_label_visibility:'getset_descriptor'
    vertex_scalar_bar:'getset_descriptor'
    vertex_scalar_bar_visibility:'getset_descriptor'
    vertex_selected_icon:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddEdgeIconType(self, name:str, type:int) -> None: ...
    def AddVertexIconType(self, name:str, type:int) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def ClearEdgeIconTypes(self) -> None: ...
    def ClearVertexIconTypes(self) -> None: ...
    def ColorEdgesByArrayOff(self) -> None: ...
    def ColorEdgesByArrayOn(self) -> None: ...
    def ColorVerticesByArrayOff(self) -> None: ...
    def ColorVerticesByArrayOn(self) -> None: ...
    def ComputeSelectedGraphBounds(self, bounds:MutableSequence[float]) -> None: ...
    def EdgeIconVisibilityOff(self) -> None: ...
    def EdgeIconVisibilityOn(self) -> None: ...
    def EdgeLabelVisibilityOff(self) -> None: ...
    def EdgeLabelVisibilityOn(self) -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def EnableEdgesByArrayOff(self) -> None: ...
    def EnableEdgesByArrayOn(self) -> None: ...
    def EnableVerticesByArrayOff(self) -> None: ...
    def EnableVerticesByArrayOn(self) -> None: ...
    def GetColorEdgesByArray(self) -> bool: ...
    def GetColorVerticesByArray(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeHoverArrayName(self) -> str: ...
    def GetEdgeIconAlignment(self) -> int: ...
    def GetEdgeIconArrayName(self) -> str: ...
    def GetEdgeIconPriorityArrayName(self) -> str: ...
    def GetEdgeIconVisibility(self) -> bool: ...
    def GetEdgeLabelArrayName(self) -> str: ...
    def GetEdgeLabelPriorityArrayName(self) -> str: ...
    def GetEdgeLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetEdgeLabelVisibility(self) -> bool: ...
    def GetEdgeLayoutStrategy(self) -> 'vtkEdgeLayoutStrategy': ...
    def GetEdgeLayoutStrategyName(self) -> str: ...
    def GetEdgeScalarBar(self) -> 'vtkScalarBarWidget': ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    def GetEdgeSelection(self) -> bool: ...
    def GetEdgeVisibility(self) -> bool: ...
    def GetEnableEdgesByArray(self) -> bool: ...
    def GetEnableVerticesByArray(self) -> bool: ...
    def GetEnabledEdgesArrayName(self) -> str: ...
    def GetEnabledVerticesArrayName(self) -> str: ...
    def GetGlyphType(self) -> int: ...
    def GetHideEdgeLabelsOnInteraction(self) -> bool: ...
    def GetHideVertexLabelsOnInteraction(self) -> bool: ...
    def GetLayoutStrategy(self) -> 'vtkGraphLayoutStrategy': ...
    def GetLayoutStrategyName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaling(self) -> bool: ...
    def GetScalingArrayName(self) -> str: ...
    def GetUseEdgeIconTypeMap(self) -> bool: ...
    def GetUseVertexIconTypeMap(self) -> bool: ...
    def GetVertexColorArrayName(self) -> str: ...
    def GetVertexDefaultIcon(self) -> int: ...
    def GetVertexHoverArrayName(self) -> str: ...
    def GetVertexIconAlignment(self) -> int: ...
    def GetVertexIconArrayName(self) -> str: ...
    def GetVertexIconPriorityArrayName(self) -> str: ...
    def GetVertexIconSelectionMode(self) -> int: ...
    def GetVertexIconVisibility(self) -> bool: ...
    def GetVertexLabelArrayName(self) -> str: ...
    def GetVertexLabelPriorityArrayName(self) -> str: ...
    def GetVertexLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetVertexLabelVisibility(self) -> bool: ...
    def GetVertexScalarBar(self) -> 'vtkScalarBarWidget': ...
    def GetVertexScalarBarVisibility(self) -> bool: ...
    def GetVertexSelectedIcon(self) -> int: ...
    def HideEdgeLabelsOnInteractionOff(self) -> None: ...
    def HideEdgeLabelsOnInteractionOn(self) -> None: ...
    def HideVertexLabelsOnInteractionOff(self) -> None: ...
    def HideVertexLabelsOnInteractionOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsLayoutComplete(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderedGraphRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderedGraphRepresentation': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetColorEdgesByArray(self, b:bool) -> None: ...
    def SetColorVerticesByArray(self, b:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeHoverArrayName(self, _arg:str) -> None: ...
    def SetEdgeIconAlignment(self, align:int) -> None: ...
    def SetEdgeIconArrayName(self, name:str) -> None: ...
    def SetEdgeIconPriorityArrayName(self, name:str) -> None: ...
    def SetEdgeIconVisibility(self, b:bool) -> None: ...
    def SetEdgeLabelArrayName(self, name:str) -> None: ...
    def SetEdgeLabelPriorityArrayName(self, name:str) -> None: ...
    def SetEdgeLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetEdgeLabelVisibility(self, b:bool) -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, strategy:'vtkEdgeLayoutStrategy') -> None: ...
    @overload
    def SetEdgeLayoutStrategy(self, name:str) -> None: ...
    def SetEdgeLayoutStrategyToArcParallel(self) -> None: ...
    def SetEdgeLayoutStrategyToGeo(self, explodeFactor:float=0.2) -> None: ...
    def SetEdgeLayoutStrategyToPassThrough(self) -> None: ...
    def SetEdgeScalarBarVisibility(self, b:bool) -> None: ...
    def SetEdgeSelection(self, b:bool) -> None: ...
    def SetEdgeVisibility(self, b:bool) -> None: ...
    def SetEnableEdgesByArray(self, b:bool) -> None: ...
    def SetEnableVerticesByArray(self, b:bool) -> None: ...
    def SetEnabledEdgesArrayName(self, name:str) -> None: ...
    def SetEnabledVerticesArrayName(self, name:str) -> None: ...
    def SetGlyphType(self, type:int) -> None: ...
    def SetHideEdgeLabelsOnInteraction(self, _arg:bool) -> None: ...
    def SetHideVertexLabelsOnInteraction(self, _arg:bool) -> None: ...
    @overload
    def SetLayoutStrategy(self, strategy:'vtkGraphLayoutStrategy') -> None: ...
    @overload
    def SetLayoutStrategy(self, name:str) -> None: ...
    def SetLayoutStrategyToAssignCoordinates(self, xarr:str, yarr:str=..., zarr:str=...) -> None: ...
    def SetLayoutStrategyToCircular(self) -> None: ...
    def SetLayoutStrategyToClustering2D(self) -> None: ...
    def SetLayoutStrategyToCommunity2D(self) -> None: ...
    def SetLayoutStrategyToCone(self) -> None: ...
    @overload
    def SetLayoutStrategyToCosmicTree(self) -> None: ...
    @overload
    def SetLayoutStrategyToCosmicTree(self, nodeSizeArrayName:str, sizeLeafNodesOnly:bool=True, layoutDepth:int=0, layoutRoot:int=-1) -> None: ...
    def SetLayoutStrategyToFast2D(self) -> None: ...
    def SetLayoutStrategyToForceDirected(self) -> None: ...
    def SetLayoutStrategyToPassThrough(self) -> None: ...
    def SetLayoutStrategyToRandom(self) -> None: ...
    def SetLayoutStrategyToSimple2D(self) -> None: ...
    def SetLayoutStrategyToSpanTree(self) -> None: ...
    @overload
    def SetLayoutStrategyToTree(self) -> None: ...
    @overload
    def SetLayoutStrategyToTree(self, radial:bool, angle:float=90, leafSpacing:float=0.9, logSpacing:float=1.0) -> None: ...
    def SetScaling(self, b:bool) -> None: ...
    def SetScalingArrayName(self, name:str) -> None: ...
    def SetUseEdgeIconTypeMap(self, b:bool) -> None: ...
    def SetUseVertexIconTypeMap(self, b:bool) -> None: ...
    def SetVertexColorArrayName(self, name:str) -> None: ...
    def SetVertexDefaultIcon(self, icon:int) -> None: ...
    def SetVertexHoverArrayName(self, _arg:str) -> None: ...
    def SetVertexIconAlignment(self, align:int) -> None: ...
    def SetVertexIconArrayName(self, name:str) -> None: ...
    def SetVertexIconPriorityArrayName(self, name:str) -> None: ...
    def SetVertexIconSelectionMode(self, mode:int) -> None: ...
    def SetVertexIconSelectionModeToAnnotationIcon(self) -> None: ...
    def SetVertexIconSelectionModeToIgnoreSelection(self) -> None: ...
    def SetVertexIconSelectionModeToSelectedIcon(self) -> None: ...
    def SetVertexIconSelectionModeToSelectedOffset(self) -> None: ...
    def SetVertexIconVisibility(self, b:bool) -> None: ...
    def SetVertexLabelArrayName(self, name:str) -> None: ...
    def SetVertexLabelPriorityArrayName(self, name:str) -> None: ...
    def SetVertexLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetVertexLabelVisibility(self, b:bool) -> None: ...
    def SetVertexScalarBarVisibility(self, b:bool) -> None: ...
    def SetVertexSelectedIcon(self, icon:int) -> None: ...
    def UpdateLayout(self) -> None: ...
    def UseEdgeIconTypeMapOff(self) -> None: ...
    def UseEdgeIconTypeMapOn(self) -> None: ...
    def UseVertexIconTypeMapOff(self) -> None: ...
    def UseVertexIconTypeMapOn(self) -> None: ...
    def VertexIconVisibilityOff(self) -> None: ...
    def VertexIconVisibilityOn(self) -> None: ...
    def VertexLabelVisibilityOff(self) -> None: ...
    def VertexLabelVisibilityOn(self) -> None: ...

class vtkRenderedHierarchyRepresentation(vtkRenderedGraphRepresentation):
    bundling_strength:'getset_descriptor'
    color_graph_edges_by_array:'getset_descriptor'
    graph_edge_color_array_name:'getset_descriptor'
    graph_edge_color_to_spline_fraction:'getset_descriptor'
    graph_edge_label_array_name:'getset_descriptor'
    graph_edge_label_font_size:'getset_descriptor'
    graph_edge_label_visibility:'getset_descriptor'
    graph_spline_type:'getset_descriptor'
    graph_visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ColorGraphEdgesByArrayOff(self) -> None: ...
    def ColorGraphEdgesByArrayOn(self) -> None: ...
    @overload
    def GetBundlingStrength(self) -> float: ...
    @overload
    def GetBundlingStrength(self, idx:int) -> float: ...
    @overload
    def GetColorGraphEdgesByArray(self) -> bool: ...
    @overload
    def GetColorGraphEdgesByArray(self, idx:int) -> bool: ...
    @overload
    def GetGraphEdgeColorArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeColorArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelFontSize(self) -> int: ...
    @overload
    def GetGraphEdgeLabelFontSize(self, idx:int) -> int: ...
    @overload
    def GetGraphEdgeLabelVisibility(self) -> bool: ...
    @overload
    def GetGraphEdgeLabelVisibility(self, idx:int) -> bool: ...
    def GetGraphSplineType(self, idx:int) -> int: ...
    @overload
    def GetGraphVisibility(self) -> bool: ...
    @overload
    def GetGraphVisibility(self, idx:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GraphEdgeLabelVisibilityOff(self) -> None: ...
    def GraphEdgeLabelVisibilityOn(self) -> None: ...
    def GraphVisibilityOff(self) -> None: ...
    def GraphVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderedHierarchyRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderedHierarchyRepresentation': ...
    @overload
    def SetBundlingStrength(self, strength:float) -> None: ...
    @overload
    def SetBundlingStrength(self, strength:float, idx:int) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelFontSize(self, size:int) -> None: ...
    @overload
    def SetGraphEdgeLabelFontSize(self, size:int, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool, idx:int) -> None: ...
    def SetGraphSplineType(self, type:int, idx:int) -> None: ...
    @overload
    def SetGraphVisibility(self, vis:bool) -> None: ...
    @overload
    def SetGraphVisibility(self, vis:bool, idx:int) -> None: ...

class vtkRenderedSurfaceRepresentation(vtkRenderedRepresentation):
    cell_color_array_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def GetCellColorArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderedSurfaceRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderedSurfaceRepresentation': ...
    def SetCellColorArrayName(self, arrayName:str) -> None: ...

class vtkRenderedTreeAreaRepresentation(vtkRenderedRepresentation):
    area_color_array_name:'getset_descriptor'
    area_hover_array_name:'getset_descriptor'
    area_label_array_name:'getset_descriptor'
    area_label_mapper:'getset_descriptor'
    area_label_priority_array_name:'getset_descriptor'
    area_label_text_property:'getset_descriptor'
    area_label_visibility:'getset_descriptor'
    area_layout_strategy:'getset_descriptor'
    area_size_array_name:'getset_descriptor'
    area_to_poly_data:'getset_descriptor'
    color_areas_by_array:'getset_descriptor'
    color_graph_edges_by_array:'getset_descriptor'
    edge_scalar_bar_visibility:'getset_descriptor'
    graph_bundling_strength:'getset_descriptor'
    graph_edge_color_array_name:'getset_descriptor'
    graph_edge_color_to_spline_fraction:'getset_descriptor'
    graph_edge_label_array_name:'getset_descriptor'
    graph_edge_label_text_property:'getset_descriptor'
    graph_edge_label_visibility:'getset_descriptor'
    graph_hover_array_name:'getset_descriptor'
    graph_spline_type:'getset_descriptor'
    label_render_mode:'getset_descriptor'
    shrink_percentage:'getset_descriptor'
    use_rectangular_coordinates:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def AreaLabelVisibilityOff(self) -> None: ...
    def AreaLabelVisibilityOn(self) -> None: ...
    def ColorAreasByArrayOff(self) -> None: ...
    def ColorAreasByArrayOn(self) -> None: ...
    def ColorGraphEdgesByArrayOff(self) -> None: ...
    def ColorGraphEdgesByArrayOn(self) -> None: ...
    def GetAreaColorArrayName(self) -> str: ...
    def GetAreaHoverArrayName(self) -> str: ...
    def GetAreaLabelArrayName(self) -> str: ...
    def GetAreaLabelMapper(self) -> 'vtkLabeledDataMapper': ...
    def GetAreaLabelPriorityArrayName(self) -> str: ...
    def GetAreaLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetAreaLabelVisibility(self) -> bool: ...
    def GetAreaLayoutStrategy(self) -> 'vtkAreaLayoutStrategy': ...
    def GetAreaSizeArrayName(self) -> str: ...
    def GetAreaToPolyData(self) -> 'vtkPolyDataAlgorithm': ...
    def GetColorAreasByArray(self) -> bool: ...
    @overload
    def GetColorGraphEdgesByArray(self) -> bool: ...
    @overload
    def GetColorGraphEdgesByArray(self, idx:int) -> bool: ...
    def GetEdgeScalarBarVisibility(self) -> bool: ...
    @overload
    def GetGraphBundlingStrength(self) -> float: ...
    @overload
    def GetGraphBundlingStrength(self, idx:int) -> float: ...
    @overload
    def GetGraphEdgeColorArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeColorArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self) -> str: ...
    @overload
    def GetGraphEdgeLabelArrayName(self, idx:int) -> str: ...
    @overload
    def GetGraphEdgeLabelTextProperty(self) -> 'vtkTextProperty': ...
    @overload
    def GetGraphEdgeLabelTextProperty(self, idx:int) -> 'vtkTextProperty': ...
    @overload
    def GetGraphEdgeLabelVisibility(self) -> bool: ...
    @overload
    def GetGraphEdgeLabelVisibility(self, idx:int) -> bool: ...
    @overload
    def GetGraphHoverArrayName(self) -> str: ...
    @overload
    def GetGraphHoverArrayName(self, idx:int) -> str: ...
    def GetGraphSplineType(self, idx:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkPercentage(self) -> float: ...
    def GetUseRectangularCoordinates(self) -> bool: ...
    def GraphEdgeLabelVisibilityOff(self) -> None: ...
    def GraphEdgeLabelVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderedTreeAreaRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderedTreeAreaRepresentation': ...
    def SetAreaColorArrayName(self, name:str) -> None: ...
    def SetAreaHoverArrayName(self, _arg:str) -> None: ...
    def SetAreaLabelArrayName(self, name:str) -> None: ...
    def SetAreaLabelMapper(self, mapper:'vtkLabeledDataMapper') -> None: ...
    def SetAreaLabelPriorityArrayName(self, name:str) -> None: ...
    def SetAreaLabelTextProperty(self, tp:'vtkTextProperty') -> None: ...
    def SetAreaLabelVisibility(self, vis:bool) -> None: ...
    def SetAreaLayoutStrategy(self, strategy:'vtkAreaLayoutStrategy') -> None: ...
    def SetAreaSizeArrayName(self, name:str) -> None: ...
    def SetAreaToPolyData(self, areaToPoly:'vtkPolyDataAlgorithm') -> None: ...
    def SetColorAreasByArray(self, vis:bool) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool) -> None: ...
    @overload
    def SetColorGraphEdgesByArray(self, vis:bool, idx:int) -> None: ...
    def SetEdgeScalarBarVisibility(self, b:bool) -> None: ...
    @overload
    def SetGraphBundlingStrength(self, strength:float) -> None: ...
    @overload
    def SetGraphBundlingStrength(self, strength:float, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeColorArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self) -> None: ...
    @overload
    def SetGraphEdgeColorToSplineFraction(self, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphEdgeLabelArrayName(self, name:str, idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelTextProperty(self, tp:'vtkTextProperty') -> None: ...
    @overload
    def SetGraphEdgeLabelTextProperty(self, tp:'vtkTextProperty', idx:int) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool) -> None: ...
    @overload
    def SetGraphEdgeLabelVisibility(self, vis:bool, idx:int) -> None: ...
    @overload
    def SetGraphHoverArrayName(self, name:str) -> None: ...
    @overload
    def SetGraphHoverArrayName(self, name:str, idx:int) -> None: ...
    def SetGraphSplineType(self, type:int, idx:int) -> None: ...
    def SetLabelRenderMode(self, mode:int) -> None: ...
    def SetShrinkPercentage(self, value:float) -> None: ...
    def SetUseRectangularCoordinates(self, _arg:bool) -> None: ...
    def UseRectangularCoordinatesOff(self) -> None: ...
    def UseRectangularCoordinatesOn(self) -> None: ...

class vtkSCurveSpline(vtkmodules.vtkCommonDataModel.vtkSpline):
    node_weight:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Compute(self) -> None: ...
    def DeepCopy(self, s:'vtkSpline') -> None: ...
    def Evaluate(self, t:float) -> float: ...
    def GetNodeWeight(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSCurveSpline': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSCurveSpline': ...
    def SetNodeWeight(self, _arg:float) -> None: ...

class vtkTanglegramItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    correspondence_line_width:'getset_descriptor'
    label_size_difference:'getset_descriptor'
    minimum_visible_font_size:'getset_descriptor'
    orientation:'getset_descriptor'
    table:'getset_descriptor'
    tree1:'getset_descriptor'
    tree1_label:'getset_descriptor'
    tree2:'getset_descriptor'
    tree2_label:'getset_descriptor'
    tree_line_width:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCorrespondenceLineWidth(self) -> float: ...
    def GetLabelSizeDifference(self) -> int: ...
    def GetMinimumVisibleFontSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetTable(self) -> 'vtkTable': ...
    def GetTree1Label(self) -> str: ...
    def GetTree2Label(self) -> str: ...
    def GetTreeLineWidth(self) -> float: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseDoubleClickEvent(self, event:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkTanglegramItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTanglegramItem': ...
    def SetCorrespondenceLineWidth(self, _arg:float) -> None: ...
    def SetLabelSizeDifference(self, _arg:int) -> None: ...
    def SetMinimumVisibleFontSize(self, _arg:int) -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    def SetTable(self, table:'vtkTable') -> None: ...
    def SetTree1(self, tree:'vtkTree') -> None: ...
    def SetTree1Label(self, _arg:str) -> None: ...
    def SetTree2(self, tree:'vtkTree') -> None: ...
    def SetTree2Label(self, _arg:str) -> None: ...
    def SetTreeLineWidth(self, width:float) -> None: ...

class vtkTreeHeatmapItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    column_tree:'getset_descriptor'
    dendrogram:'getset_descriptor'
    heatmap:'getset_descriptor'
    orientation:'getset_descriptor'
    pruned_tree:'getset_descriptor'
    table:'getset_descriptor'
    tree:'getset_descriptor'
    tree_color_array:'getset_descriptor'
    tree_line_width:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CollapseToNumberOfLeafNodes(self, n:int) -> None: ...
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCenter(self, center:MutableSequence[float]) -> None: ...
    def GetColumnTree(self) -> 'vtkTree': ...
    def GetDendrogram(self) -> 'vtkDendrogramItem': ...
    def GetHeatmap(self) -> 'vtkHeatmapItem': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetPrunedTree(self) -> 'vtkTree': ...
    def GetSize(self, size:MutableSequence[float]) -> None: ...
    def GetTable(self) -> 'vtkTable': ...
    def GetTree(self) -> 'vtkTree': ...
    def GetTreeLineWidth(self) -> float: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseDoubleClickEvent(self, event:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkTreeHeatmapItem': ...
    def ReorderTable(self) -> None: ...
    def ReverseTableColumns(self) -> None: ...
    def ReverseTableRows(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeHeatmapItem': ...
    def SetColumnTree(self, tree:'vtkTree') -> None: ...
    def SetDendrogram(self, dendrogram:'vtkDendrogramItem') -> None: ...
    def SetHeatmap(self, heatmap:'vtkHeatmapItem') -> None: ...
    def SetOrientation(self, orientation:int) -> None: ...
    def SetTable(self, table:'vtkTable') -> None: ...
    def SetTree(self, tree:'vtkTree') -> None: ...
    def SetTreeColorArray(self, arrayName:str) -> None: ...
    def SetTreeLineWidth(self, width:float) -> None: ...

class vtkTreeMapView(vtkTreeAreaView):
    font_size_range:'getset_descriptor'
    layout_strategy:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFontSizeRange(self, range:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeMapView': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeMapView': ...
    def SetFontSizeRange(self, maxSize:int, minSize:int, delta:int=4) -> None: ...
    @overload
    def SetLayoutStrategy(self, s:'vtkAreaLayoutStrategy') -> None: ...
    @overload
    def SetLayoutStrategy(self, name:str) -> None: ...
    def SetLayoutStrategyToBox(self) -> None: ...
    def SetLayoutStrategyToSliceAndDice(self) -> None: ...
    def SetLayoutStrategyToSquarify(self) -> None: ...

class vtkTreeRingView(vtkTreeAreaView):
    interior_log_spacing_value:'getset_descriptor'
    interior_radius:'getset_descriptor'
    layer_thickness:'getset_descriptor'
    root_angles:'getset_descriptor'
    root_at_center:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetInteriorLogSpacingValue(self) -> float: ...
    def GetInteriorRadius(self) -> float: ...
    def GetLayerThickness(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRootAtCenter(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeRingView': ...
    def RootAtCenterOff(self) -> None: ...
    def RootAtCenterOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeRingView': ...
    def SetInteriorLogSpacingValue(self, value:float) -> None: ...
    def SetInteriorRadius(self, rad:float) -> None: ...
    def SetLayerThickness(self, thickness:float) -> None: ...
    def SetRootAngles(self, start:float, end:float) -> None: ...
    def SetRootAtCenter(self, center:bool) -> None: ...

class vtkViewUpdater(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def AddAnnotationLink(self, link:'vtkAnnotationLink') -> None: ...
    def AddView(self, view:'vtkView') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkViewUpdater': ...
    def RemoveView(self, view:'vtkView') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkViewUpdater': ...

