"""Initial models

Revision ID: 2a7a559e761b
Revises: 
Create Date: 2021-08-15 13:34:25.911247

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "2a7a559e761b"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "gamestate",
        sa.Column("workspace_id", sa.Text(), nullable=False),
        sa.Column("channel_id", sa.Text(), nullable=False),
        sa.Column(
            "step",
            sa.Enum(
                "NEW_GAME",
                "WAITING",
                "PROVIDED",
                "GUESSING",
                name="gamestatestep",
            ),
            nullable=False,
        ),
        sa.Column("current_winner", sa.Text(), nullable=True),
        sa.Column("previous_winner", sa.Text(), nullable=True),
        sa.Column("emojirade", sa.Text(), nullable=True),
        sa.Column("raw_emojirade", sa.Text(), nullable=True),
        sa.Column("first_guess", sa.Boolean(), nullable=True),
        sa.Column("admins", sa.Text(), nullable=False),
        sa.Column("last_updated", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("workspace_id", "channel_id"),
    )
    op.create_table(
        "gamestate_history",
        sa.Column("event_id", sa.Integer(), sa.Identity(always=False), nullable=False),
        sa.Column("workspace_id", sa.Text(), nullable=True),
        sa.Column("channel_id", sa.Text(), nullable=True),
        sa.Column("user_id", sa.Text(), nullable=True),
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.Column("operation", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("event_id"),
    )
    op.create_index(
        "idx_gamestate_history_channel",
        "gamestate_history",
        ["workspace_id", "channel_id"],
        unique=False,
    )
    op.create_table(
        "scoreboard",
        sa.Column("workspace_id", sa.Text(), nullable=False),
        sa.Column("channel_id", sa.Text(), nullable=False),
        sa.Column("user_id", sa.Text(), nullable=False),
        sa.Column("score", sa.Integer(), nullable=False),
        sa.Column("last_updated", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("workspace_id", "channel_id", "user_id"),
    )
    op.create_table(
        "scoreboard_history",
        sa.Column("event_id", sa.Integer(), sa.Identity(always=False), nullable=False),
        sa.Column("workspace_id", sa.Text(), nullable=True),
        sa.Column("channel_id", sa.Text(), nullable=True),
        sa.Column("user_id", sa.Text(), nullable=True),
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.Column("operation", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("event_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("scoreboard_history")
    op.drop_table("scoreboard")
    op.drop_index("idx_gamestate_history_channel", table_name="gamestate_history")
    op.drop_table("gamestate_history")
    op.drop_table("gamestate")
    # ### end Alembic commands ###
