"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Mode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Mode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MODE_UNSPECIFIED: _Mode.ValueType  # 0
    """Unspecified."""
    MODE_SYNC: _Mode.ValueType  # 1
    """Synchronous (result is returned in the response)."""
    MODE_ASYNC: _Mode.ValueType  # 2
    """Asynchronous (response only contains acknowledgement)."""

class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
    """Mode describes the execution mode of the pipeline (sync or async)."""

MODE_UNSPECIFIED: Mode.ValueType  # 0
"""Unspecified."""
MODE_SYNC: Mode.ValueType  # 1
"""Synchronous (result is returned in the response)."""
MODE_ASYNC: Mode.ValueType  # 2
"""Asynchronous (response only contains acknowledgement)."""
global___Mode = Mode

class _Status:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Status.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STATUS_UNSPECIFIED: _Status.ValueType  # 0
    """Unspecified."""
    STATUS_COMPLETED: _Status.ValueType  # 1
    """Successfully completed."""
    STATUS_ERRORED: _Status.ValueType  # 2
    """Finished with error."""

class Status(_Status, metaclass=_StatusEnumTypeWrapper):
    """Status describes the output of an execution."""

STATUS_UNSPECIFIED: Status.ValueType  # 0
"""Unspecified."""
STATUS_COMPLETED: Status.ValueType  # 1
"""Successfully completed."""
STATUS_ERRORED: Status.ValueType  # 2
"""Finished with error."""
global___Status = Status

@typing_extensions.final
class PipelineTriggerRecord(google.protobuf.message.Message):
    """========== Pipeline endpoints

    PipelineTriggerRecord represents a pipeline execution event.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRIGGER_TIME_FIELD_NUMBER: builtins.int
    PIPELINE_TRIGGER_ID_FIELD_NUMBER: builtins.int
    PIPELINE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_UID_FIELD_NUMBER: builtins.int
    TRIGGER_MODE_FIELD_NUMBER: builtins.int
    COMPUTE_TIME_DURATION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_RELEASE_UID_FIELD_NUMBER: builtins.int
    @property
    def trigger_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The moment when the pipeline was triggered."""
    pipeline_trigger_id: builtins.str
    """UUID of the trigger."""
    pipeline_id: builtins.str
    """Pipeline ID."""
    pipeline_uid: builtins.str
    """Pipeline UUID."""
    trigger_mode: global___Mode.ValueType
    """Trigger mode."""
    compute_time_duration: builtins.float
    """Total execution duration."""
    status: global___Status.ValueType
    """Final status."""
    pipeline_release_id: builtins.str
    """If a release of the pipeline was triggered, pipeline version."""
    pipeline_release_uid: builtins.str
    """If a release of the pipeline was triggered, release UUID."""
    def __init__(
        self,
        *,
        trigger_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        pipeline_trigger_id: builtins.str = ...,
        pipeline_id: builtins.str = ...,
        pipeline_uid: builtins.str = ...,
        trigger_mode: global___Mode.ValueType = ...,
        compute_time_duration: builtins.float = ...,
        status: global___Status.ValueType = ...,
        pipeline_release_id: builtins.str = ...,
        pipeline_release_uid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["trigger_time", b"trigger_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["compute_time_duration", b"compute_time_duration", "pipeline_id", b"pipeline_id", "pipeline_release_id", b"pipeline_release_id", "pipeline_release_uid", b"pipeline_release_uid", "pipeline_trigger_id", b"pipeline_trigger_id", "pipeline_uid", b"pipeline_uid", "status", b"status", "trigger_mode", b"trigger_mode", "trigger_time", b"trigger_time"]) -> None: ...

global___PipelineTriggerRecord = PipelineTriggerRecord

@typing_extensions.final
class PipelineTriggerTableRecord(google.protobuf.message.Message):
    """PipelineTriggerTableRecord contains pipeline trigger metrics, aggregated by
    pipeline ID.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_UID_FIELD_NUMBER: builtins.int
    TRIGGER_COUNT_COMPLETED_FIELD_NUMBER: builtins.int
    TRIGGER_COUNT_ERRORED_FIELD_NUMBER: builtins.int
    PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_RELEASE_UID_FIELD_NUMBER: builtins.int
    pipeline_id: builtins.str
    """Pipeline ID."""
    pipeline_uid: builtins.str
    """Pipeline UUID."""
    trigger_count_completed: builtins.int
    """Number of triggers with `STATUS_COMPLETED`."""
    trigger_count_errored: builtins.int
    """Number of triggers with `STATUS_ERRORED`."""
    pipeline_release_id: builtins.str
    """Version for the triggered pipeline if it is a release pipeline."""
    pipeline_release_uid: builtins.str
    """Release UUID for the triggered pipeline if it is a release pipeline."""
    def __init__(
        self,
        *,
        pipeline_id: builtins.str = ...,
        pipeline_uid: builtins.str = ...,
        trigger_count_completed: builtins.int = ...,
        trigger_count_errored: builtins.int = ...,
        pipeline_release_id: builtins.str = ...,
        pipeline_release_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline_id", b"pipeline_id", "pipeline_release_id", b"pipeline_release_id", "pipeline_release_uid", b"pipeline_release_uid", "pipeline_uid", b"pipeline_uid", "trigger_count_completed", b"trigger_count_completed", "trigger_count_errored", b"trigger_count_errored"]) -> None: ...

global___PipelineTriggerTableRecord = PipelineTriggerTableRecord

@typing_extensions.final
class PipelineTriggerChartRecord(google.protobuf.message.Message):
    """PipelineTriggerChartRecord contains pipeline trigger metrics, aggregated by
    pipeline ID and time frame.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_UID_FIELD_NUMBER: builtins.int
    TRIGGER_MODE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TIME_BUCKETS_FIELD_NUMBER: builtins.int
    TRIGGER_COUNTS_FIELD_NUMBER: builtins.int
    COMPUTE_TIME_DURATION_FIELD_NUMBER: builtins.int
    PIPELINE_RELEASE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_RELEASE_UID_FIELD_NUMBER: builtins.int
    pipeline_id: builtins.str
    """Pipeline ID."""
    pipeline_uid: builtins.str
    """Pipeline UUID."""
    trigger_mode: global___Mode.ValueType
    """Trigger mode."""
    status: global___Status.ValueType
    """Final status."""
    @property
    def time_buckets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.timestamp_pb2.Timestamp]:
        """Time buckets."""
    @property
    def trigger_counts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Aggregated trigger count in each time bucket."""
    @property
    def compute_time_duration(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Total computation time duration in each time bucket."""
    pipeline_release_id: builtins.str
    """Version for the triggered pipeline if it is a release pipeline."""
    pipeline_release_uid: builtins.str
    """Release UUID for the triggered pipeline if it is a release pipeline."""
    def __init__(
        self,
        *,
        pipeline_id: builtins.str = ...,
        pipeline_uid: builtins.str = ...,
        trigger_mode: global___Mode.ValueType = ...,
        status: global___Status.ValueType = ...,
        time_buckets: collections.abc.Iterable[google.protobuf.timestamp_pb2.Timestamp] | None = ...,
        trigger_counts: collections.abc.Iterable[builtins.int] | None = ...,
        compute_time_duration: collections.abc.Iterable[builtins.float] | None = ...,
        pipeline_release_id: builtins.str = ...,
        pipeline_release_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["compute_time_duration", b"compute_time_duration", "pipeline_id", b"pipeline_id", "pipeline_release_id", b"pipeline_release_id", "pipeline_release_uid", b"pipeline_release_uid", "pipeline_uid", b"pipeline_uid", "status", b"status", "time_buckets", b"time_buckets", "trigger_counts", b"trigger_counts", "trigger_mode", b"trigger_mode"]) -> None: ...

global___PipelineTriggerChartRecord = PipelineTriggerChartRecord

@typing_extensions.final
class ListPipelineTriggerRecordsRequest(google.protobuf.message.Message):
    """ListPipelineTriggerRecordsRequest represents a request to list the triggers
    of a pipeline.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of triggers to return. If this parameter is unspecified,
    at most 100 pipelines will be returned. The cap value for this parameter is
    1000 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListPipelineTriggerRecordsRequest = ListPipelineTriggerRecordsRequest

@typing_extensions.final
class ListPipelineTriggerRecordsResponse(google.protobuf.message.Message):
    """ListPipelineTriggerRecordsResponse contains a list of pipeline triggers."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_TRIGGER_RECORDS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipeline_trigger_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineTriggerRecord]:
        """A list of pipeline triggers."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipeline triggers."""
    def __init__(
        self,
        *,
        pipeline_trigger_records: collections.abc.Iterable[global___PipelineTriggerRecord] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipeline_trigger_records", b"pipeline_trigger_records", "total_size", b"total_size"]) -> None: ...

global___ListPipelineTriggerRecordsResponse = ListPipelineTriggerRecordsResponse

@typing_extensions.final
class ListPipelineTriggerTableRecordsRequest(google.protobuf.message.Message):
    """ListPipelineTriggerTableRecordsRequest represents a request to list the
    pipeline triggers metrics, aggregated by pipeline ID.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results to return. If this parameter is unspecified,
    at most 100 pipelines will be returned. The cap value for this parameter
    is 1000 (i.e. any value above that will be coerced to 1000).
    """
    page_token: builtins.str
    """Page token."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListPipelineTriggerTableRecordsRequest = ListPipelineTriggerTableRecordsRequest

@typing_extensions.final
class ListPipelineTriggerTableRecordsResponse(google.protobuf.message.Message):
    """ListPipelineTriggerTableRecordsResponse contains the pipeline metrics."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_TRIGGER_TABLE_RECORDS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def pipeline_trigger_table_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineTriggerTableRecord]:
        """A list of pipeline trigger tables."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of pipeline trigger records"""
    def __init__(
        self,
        *,
        pipeline_trigger_table_records: collections.abc.Iterable[global___PipelineTriggerTableRecord] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "pipeline_trigger_table_records", b"pipeline_trigger_table_records", "total_size", b"total_size"]) -> None: ...

global___ListPipelineTriggerTableRecordsResponse = ListPipelineTriggerTableRecordsResponse

@typing_extensions.final
class ListPipelineTriggerChartRecordsRequest(google.protobuf.message.Message):
    """ListPipelineTriggerChartRecordsRequest represents a request to list pipeline
    trigger metrics, aggregated by pipeline ID and time frame.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGGREGATION_WINDOW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    aggregation_window: builtins.int
    """Aggregation window in nanoseconds."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        aggregation_window: builtins.int = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "aggregation_window", b"aggregation_window", "filter", b"filter"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...

global___ListPipelineTriggerChartRecordsRequest = ListPipelineTriggerChartRecordsRequest

@typing_extensions.final
class ListPipelineTriggerChartRecordsResponse(google.protobuf.message.Message):
    """ListPipelineTriggerChartRecordsResponse contains a list of pipeline trigger
    chart records.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_TRIGGER_CHART_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def pipeline_trigger_chart_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineTriggerChartRecord]:
        """A list of pipeline trigger records."""
    def __init__(
        self,
        *,
        pipeline_trigger_chart_records: collections.abc.Iterable[global___PipelineTriggerChartRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline_trigger_chart_records", b"pipeline_trigger_chart_records"]) -> None: ...

global___ListPipelineTriggerChartRecordsResponse = ListPipelineTriggerChartRecordsResponse

@typing_extensions.final
class ConnectorExecuteRecord(google.protobuf.message.Message):
    """========== Connector endpoints

    ConnectorExecuteRecord represents a connector execution event.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXECUTE_TIME_FIELD_NUMBER: builtins.int
    CONNECTOR_EXECUTE_ID_FIELD_NUMBER: builtins.int
    CONNECTOR_ID_FIELD_NUMBER: builtins.int
    CONNECTOR_UID_FIELD_NUMBER: builtins.int
    CONNECTOR_DEFINITION_UID_FIELD_NUMBER: builtins.int
    PIPELINE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_UID_FIELD_NUMBER: builtins.int
    PIPELINE_TRIGGER_ID_FIELD_NUMBER: builtins.int
    COMPUTE_TIME_DURATION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    @property
    def execute_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The moment when the connector was executed."""
    connector_execute_id: builtins.str
    """UUID of the execution."""
    connector_id: builtins.str
    """Connector ID."""
    connector_uid: builtins.str
    """Connector UUID."""
    connector_definition_uid: builtins.str
    """Connector definition UUID."""
    pipeline_id: builtins.str
    """Pipeline ID."""
    pipeline_uid: builtins.str
    """Pipeline UUID."""
    pipeline_trigger_id: builtins.str
    """UUID of the pipeline trigger."""
    compute_time_duration: builtins.float
    """Total execution time."""
    status: global___Status.ValueType
    """Final status for the connector execution."""
    def __init__(
        self,
        *,
        execute_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        connector_execute_id: builtins.str = ...,
        connector_id: builtins.str = ...,
        connector_uid: builtins.str = ...,
        connector_definition_uid: builtins.str = ...,
        pipeline_id: builtins.str = ...,
        pipeline_uid: builtins.str = ...,
        pipeline_trigger_id: builtins.str = ...,
        compute_time_duration: builtins.float = ...,
        status: global___Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["execute_time", b"execute_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["compute_time_duration", b"compute_time_duration", "connector_definition_uid", b"connector_definition_uid", "connector_execute_id", b"connector_execute_id", "connector_id", b"connector_id", "connector_uid", b"connector_uid", "execute_time", b"execute_time", "pipeline_id", b"pipeline_id", "pipeline_trigger_id", b"pipeline_trigger_id", "pipeline_uid", b"pipeline_uid", "status", b"status"]) -> None: ...

global___ConnectorExecuteRecord = ConnectorExecuteRecord

@typing_extensions.final
class ConnectorExecuteTableRecord(google.protobuf.message.Message):
    """ConnectorExecuteTableRecord contains connector execution metrics, a aggregated by connector ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_ID_FIELD_NUMBER: builtins.int
    CONNECTOR_UID_FIELD_NUMBER: builtins.int
    EXECUTE_COUNT_COMPLETED_FIELD_NUMBER: builtins.int
    EXECUTE_COUNT_ERRORED_FIELD_NUMBER: builtins.int
    connector_id: builtins.str
    """Connector ID."""
    connector_uid: builtins.str
    """Connector UUID."""
    execute_count_completed: builtins.int
    """Number of executions with `STATUS_COMPLETED`."""
    execute_count_errored: builtins.int
    """Number of executions with `STATUS_ERRORED`."""
    def __init__(
        self,
        *,
        connector_id: builtins.str = ...,
        connector_uid: builtins.str = ...,
        execute_count_completed: builtins.int = ...,
        execute_count_errored: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_id", b"connector_id", "connector_uid", b"connector_uid", "execute_count_completed", b"execute_count_completed", "execute_count_errored", b"execute_count_errored"]) -> None: ...

global___ConnectorExecuteTableRecord = ConnectorExecuteTableRecord

@typing_extensions.final
class ConnectorExecuteChartRecord(google.protobuf.message.Message):
    """ConnectorExecuteChartRecord contains connector execution metrics,
    agggregated by connector ID and time frame.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_ID_FIELD_NUMBER: builtins.int
    CONNECTOR_UID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TIME_BUCKETS_FIELD_NUMBER: builtins.int
    EXECUTE_COUNTS_FIELD_NUMBER: builtins.int
    COMPUTE_TIME_DURATION_FIELD_NUMBER: builtins.int
    connector_id: builtins.str
    """Connector ID."""
    connector_uid: builtins.str
    """Connector UUID."""
    status: global___Status.ValueType
    """Final status."""
    @property
    def time_buckets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.timestamp_pb2.Timestamp]:
        """Time buckets."""
    @property
    def execute_counts(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Aggregated execution count in each time bucket."""
    @property
    def compute_time_duration(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """Total computation time duration in each time bucket."""
    def __init__(
        self,
        *,
        connector_id: builtins.str = ...,
        connector_uid: builtins.str = ...,
        status: global___Status.ValueType = ...,
        time_buckets: collections.abc.Iterable[google.protobuf.timestamp_pb2.Timestamp] | None = ...,
        execute_counts: collections.abc.Iterable[builtins.int] | None = ...,
        compute_time_duration: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["compute_time_duration", b"compute_time_duration", "connector_id", b"connector_id", "connector_uid", b"connector_uid", "execute_counts", b"execute_counts", "status", b"status", "time_buckets", b"time_buckets"]) -> None: ...

global___ConnectorExecuteChartRecord = ConnectorExecuteChartRecord

@typing_extensions.final
class ListConnectorExecuteRecordsRequest(google.protobuf.message.Message):
    """ListConnectorExecuteRecordsRequest represents a request to list connector
    executions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of executions to return. If this parameter is
    unspecified, at most 100 pipelines will be returned. The cap value for
    this parameter is 1000 (i.e. any value above that will be coerced to
    1000).
    """
    page_token: builtins.str
    """Page token."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListConnectorExecuteRecordsRequest = ListConnectorExecuteRecordsRequest

@typing_extensions.final
class ListConnectorExecuteRecordsResponse(google.protobuf.message.Message):
    """ListConnectorExecuteRecordsResponse represents a response for a list
    of connector execute record
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_EXECUTE_RECORDS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connector_execute_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConnectorExecuteRecord]:
        """A list of connector execute records"""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total count of connector execute records"""
    def __init__(
        self,
        *,
        connector_execute_records: collections.abc.Iterable[global___ConnectorExecuteRecord] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_execute_records", b"connector_execute_records", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListConnectorExecuteRecordsResponse = ListConnectorExecuteRecordsResponse

@typing_extensions.final
class ListConnectorExecuteTableRecordsRequest(google.protobuf.message.Message):
    """ListConnectorExecuteTableRecordsRequest represents a request to list the
    connector execution metrics, aggregated by connector.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of results to return. If this parameter is unspecified,
    at most 100 pipelines will be returned. The cap value for this parameter
    is 1000 (i.e. any value above that will be coerced to 1000).
    """
    page_token: builtins.str
    """Page token."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListConnectorExecuteTableRecordsRequest = ListConnectorExecuteTableRecordsRequest

@typing_extensions.final
class ListConnectorExecuteTableRecordsResponse(google.protobuf.message.Message):
    """ListConnectorExecuteTableRecordsResponse contains the connector metrics."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_EXECUTE_TABLE_RECORDS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connector_execute_table_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConnectorExecuteTableRecord]:
        """A list of connector execution records."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of connector execution records."""
    def __init__(
        self,
        *,
        connector_execute_table_records: collections.abc.Iterable[global___ConnectorExecuteTableRecord] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_execute_table_records", b"connector_execute_table_records", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListConnectorExecuteTableRecordsResponse = ListConnectorExecuteTableRecordsResponse

@typing_extensions.final
class ListConnectorExecuteChartRecordsRequest(google.protobuf.message.Message):
    """ListConnectorExecuteChartRecordsRequest represents a request to list
    connector execution metrics, aggregated by connector and time frame.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGGREGATION_WINDOW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    aggregation_window: builtins.int
    """Aggregation window in nanoseconds."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        aggregation_window: builtins.int = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "aggregation_window", b"aggregation_window", "filter", b"filter"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...

global___ListConnectorExecuteChartRecordsRequest = ListConnectorExecuteChartRecordsRequest

@typing_extensions.final
class ListConnectorExecuteChartRecordsResponse(google.protobuf.message.Message):
    """ListConnectorExecuteChartRecordsResponse contains a list of connector
    execution chart records.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_EXECUTE_CHART_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def connector_execute_chart_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConnectorExecuteChartRecord]:
        """A list of connector execution records."""
    def __init__(
        self,
        *,
        connector_execute_chart_records: collections.abc.Iterable[global___ConnectorExecuteChartRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_execute_chart_records", b"connector_execute_chart_records"]) -> None: ...

global___ListConnectorExecuteChartRecordsResponse = ListConnectorExecuteChartRecordsResponse
