# coding: utf-8

"""
    aind-labtracks-service-server

     ## aind-labtracks-service-server  Service to fetch data from LabTracks.  

    The version of the OpenAPI document: 0.0.3
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_labtracks_service_client.models.mouse_custom_class import MouseCustomClass
from typing import Optional, Set
from typing_extensions import Self

class Subject(BaseModel):
    """
    Expected Subject view of joined tables
    """ # noqa: E501
    id: StrictStr
    class_values: Optional[MouseCustomClass] = None
    sex: Optional[StrictStr] = None
    birth_date: Optional[datetime] = None
    species_name: Optional[StrictStr] = None
    cage_id: Optional[StrictStr] = None
    room_id: Optional[StrictStr] = None
    paternal_id: Optional[StrictStr] = None
    paternal_class_values: Optional[MouseCustomClass] = None
    maternal_id: Optional[StrictStr] = None
    maternal_class_values: Optional[MouseCustomClass] = None
    group_name: Optional[StrictStr] = None
    group_description: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "class_values", "sex", "birth_date", "species_name", "cage_id", "room_id", "paternal_id", "paternal_class_values", "maternal_id", "maternal_class_values", "group_name", "group_description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Subject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of class_values
        if self.class_values:
            _dict['class_values'] = self.class_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of paternal_class_values
        if self.paternal_class_values:
            _dict['paternal_class_values'] = self.paternal_class_values.to_dict()
        # override the default output from pydantic by calling `to_dict()` of maternal_class_values
        if self.maternal_class_values:
            _dict['maternal_class_values'] = self.maternal_class_values.to_dict()
        # set to None if class_values (nullable) is None
        # and model_fields_set contains the field
        if self.class_values is None and "class_values" in self.model_fields_set:
            _dict['class_values'] = None

        # set to None if sex (nullable) is None
        # and model_fields_set contains the field
        if self.sex is None and "sex" in self.model_fields_set:
            _dict['sex'] = None

        # set to None if birth_date (nullable) is None
        # and model_fields_set contains the field
        if self.birth_date is None and "birth_date" in self.model_fields_set:
            _dict['birth_date'] = None

        # set to None if species_name (nullable) is None
        # and model_fields_set contains the field
        if self.species_name is None and "species_name" in self.model_fields_set:
            _dict['species_name'] = None

        # set to None if cage_id (nullable) is None
        # and model_fields_set contains the field
        if self.cage_id is None and "cage_id" in self.model_fields_set:
            _dict['cage_id'] = None

        # set to None if room_id (nullable) is None
        # and model_fields_set contains the field
        if self.room_id is None and "room_id" in self.model_fields_set:
            _dict['room_id'] = None

        # set to None if paternal_id (nullable) is None
        # and model_fields_set contains the field
        if self.paternal_id is None and "paternal_id" in self.model_fields_set:
            _dict['paternal_id'] = None

        # set to None if paternal_class_values (nullable) is None
        # and model_fields_set contains the field
        if self.paternal_class_values is None and "paternal_class_values" in self.model_fields_set:
            _dict['paternal_class_values'] = None

        # set to None if maternal_id (nullable) is None
        # and model_fields_set contains the field
        if self.maternal_id is None and "maternal_id" in self.model_fields_set:
            _dict['maternal_id'] = None

        # set to None if maternal_class_values (nullable) is None
        # and model_fields_set contains the field
        if self.maternal_class_values is None and "maternal_class_values" in self.model_fields_set:
            _dict['maternal_class_values'] = None

        # set to None if group_name (nullable) is None
        # and model_fields_set contains the field
        if self.group_name is None and "group_name" in self.model_fields_set:
            _dict['group_name'] = None

        # set to None if group_description (nullable) is None
        # and model_fields_set contains the field
        if self.group_description is None and "group_description" in self.model_fields_set:
            _dict['group_description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Subject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "class_values": MouseCustomClass.from_dict(obj["class_values"]) if obj.get("class_values") is not None else None,
            "sex": obj.get("sex"),
            "birth_date": obj.get("birth_date"),
            "species_name": obj.get("species_name"),
            "cage_id": obj.get("cage_id"),
            "room_id": obj.get("room_id"),
            "paternal_id": obj.get("paternal_id"),
            "paternal_class_values": MouseCustomClass.from_dict(obj["paternal_class_values"]) if obj.get("paternal_class_values") is not None else None,
            "maternal_id": obj.get("maternal_id"),
            "maternal_class_values": MouseCustomClass.from_dict(obj["maternal_class_values"]) if obj.get("maternal_class_values") is not None else None,
            "group_name": obj.get("group_name"),
            "group_description": obj.get("group_description")
        })
        return _obj


