"""Generic utilities.

This module contains a number of utility functions to work with images in general.
"""

from ._invert import invert
from ._map_array import map_array
from .arraycrop import crop
from .dtype import (
    dtype_limits,
    img_as_bool,
    img_as_float,
    img_as_float32,
    img_as_float64,
    img_as_int,
    img_as_ubyte,
    img_as_uint,
)
from .noise import random_noise
from .shape import view_as_blocks, view_as_windows

__all__ = [
    "img_as_float32",
    "img_as_float64",
    "img_as_float",
    "img_as_int",
    "img_as_uint",
    "img_as_ubyte",
    "img_as_bool",
    "dtype_limits",
    "view_as_blocks",
    "view_as_windows",
    "crop",
    "map_array",
    "random_noise",
    "invert",
]
