#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 225
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 83
#define ALIAS_COUNT 0
#define TOKEN_COUNT 42
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 1

enum {
  sym_comment = 1,
  sym_identifier = 2,
  anon_sym_DOT = 3,
  anon_sym_import = 4,
  anon_sym_const = 5,
  anon_sym_EQ = 6,
  anon_sym_COMMA = 7,
  anon_sym_LPAREN = 8,
  anon_sym_RPAREN = 9,
  anon_sym_bus = 10,
  anon_sym_block = 11,
  anon_sym_config = 12,
  anon_sym_func = 13,
  anon_sym_mask = 14,
  anon_sym_param = 15,
  anon_sym_status = 16,
  anon_sym_type = 17,
  anon_sym_LBRACK = 18,
  anon_sym_RBRACK = 19,
  anon_sym_DQUOTE = 20,
  aux_sym_string_literal_token1 = 21,
  sym_zero_literal = 22,
  sym_decimal_literal = 23,
  sym_binary_literal = 24,
  sym_octal_literal = 25,
  sym_hex_literal = 26,
  anon_sym_and = 27,
  anon_sym_or = 28,
  anon_sym_PLUS = 29,
  anon_sym_DASH = 30,
  anon_sym_STAR = 31,
  anon_sym_SLASH = 32,
  anon_sym_PERCENT = 33,
  anon_sym_STAR_STAR = 34,
  anon_sym_LT_LT = 35,
  anon_sym_GT_GT = 36,
  anon_sym_true = 37,
  anon_sym_false = 38,
  sym__indent = 39,
  sym__dedent = 40,
  sym__newline = 41,
  sym_description = 42,
  sym__declared_identifier = 43,
  sym_qualified_identifier = 44,
  sym__meta_statement = 45,
  sym__import_statement = 46,
  sym_single_import_statement = 47,
  sym_multi_import_statement = 48,
  sym__constant_definition = 49,
  sym_single_constant_definition = 50,
  sym_multi_constant_definition = 51,
  sym__parameter = 52,
  sym__parameters = 53,
  sym_parameter_list = 54,
  sym_element_type = 55,
  sym_element_type_definition = 56,
  sym_element_body = 57,
  sym_property_assignment = 58,
  sym__element_instantiation = 59,
  sym__argument = 60,
  sym__arguments = 61,
  sym_argument_list = 62,
  sym_element_definitive_instantiation = 63,
  sym_element_anonymous_instantiation = 64,
  sym_string_literal = 65,
  sym__integer_literal = 66,
  sym_unary_operation = 67,
  sym_binary_operation = 68,
  sym_call = 69,
  sym_parenthesized_expression = 70,
  sym_subscript = 71,
  sym_primary_expression = 72,
  sym__expressions = 73,
  sym_expression_list = 74,
  sym__expression = 75,
  aux_sym_description_repeat1 = 76,
  aux_sym_multi_import_statement_repeat1 = 77,
  aux_sym_multi_constant_definition_repeat1 = 78,
  aux_sym__parameters_repeat1 = 79,
  aux_sym_element_body_repeat1 = 80,
  aux_sym__arguments_repeat1 = 81,
  aux_sym_call_repeat1 = 82,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_comment] = "comment",
  [sym_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_import] = "import",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_bus] = "bus",
  [anon_sym_block] = "block",
  [anon_sym_config] = "config",
  [anon_sym_func] = "func",
  [anon_sym_mask] = "mask",
  [anon_sym_param] = "param",
  [anon_sym_status] = "status",
  [anon_sym_type] = "type",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [sym_zero_literal] = "zero_literal",
  [sym_decimal_literal] = "decimal_literal",
  [sym_binary_literal] = "binary_literal",
  [sym_octal_literal] = "octal_literal",
  [sym_hex_literal] = "hex_literal",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__newline] = "_newline",
  [sym_description] = "description",
  [sym__declared_identifier] = "_declared_identifier",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym__meta_statement] = "_meta_statement",
  [sym__import_statement] = "_import_statement",
  [sym_single_import_statement] = "single_import_statement",
  [sym_multi_import_statement] = "multi_import_statement",
  [sym__constant_definition] = "_constant_definition",
  [sym_single_constant_definition] = "single_constant_definition",
  [sym_multi_constant_definition] = "multi_constant_definition",
  [sym__parameter] = "_parameter",
  [sym__parameters] = "_parameters",
  [sym_parameter_list] = "parameter_list",
  [sym_element_type] = "element_type",
  [sym_element_type_definition] = "element_type_definition",
  [sym_element_body] = "element_body",
  [sym_property_assignment] = "property_assignment",
  [sym__element_instantiation] = "_element_instantiation",
  [sym__argument] = "_argument",
  [sym__arguments] = "_arguments",
  [sym_argument_list] = "argument_list",
  [sym_element_definitive_instantiation] = "element_definitive_instantiation",
  [sym_element_anonymous_instantiation] = "element_anonymous_instantiation",
  [sym_string_literal] = "string_literal",
  [sym__integer_literal] = "_integer_literal",
  [sym_unary_operation] = "unary_operation",
  [sym_binary_operation] = "binary_operation",
  [sym_call] = "call",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_subscript] = "subscript",
  [sym_primary_expression] = "primary_expression",
  [sym__expressions] = "_expressions",
  [sym_expression_list] = "expression_list",
  [sym__expression] = "_expression",
  [aux_sym_description_repeat1] = "description_repeat1",
  [aux_sym_multi_import_statement_repeat1] = "multi_import_statement_repeat1",
  [aux_sym_multi_constant_definition_repeat1] = "multi_constant_definition_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym_element_body_repeat1] = "element_body_repeat1",
  [aux_sym__arguments_repeat1] = "_arguments_repeat1",
  [aux_sym_call_repeat1] = "call_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_comment] = sym_comment,
  [sym_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_bus] = anon_sym_bus,
  [anon_sym_block] = anon_sym_block,
  [anon_sym_config] = anon_sym_config,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_mask] = anon_sym_mask,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_status] = anon_sym_status,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [sym_zero_literal] = sym_zero_literal,
  [sym_decimal_literal] = sym_decimal_literal,
  [sym_binary_literal] = sym_binary_literal,
  [sym_octal_literal] = sym_octal_literal,
  [sym_hex_literal] = sym_hex_literal,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__newline] = sym__newline,
  [sym_description] = sym_description,
  [sym__declared_identifier] = sym__declared_identifier,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym__meta_statement] = sym__meta_statement,
  [sym__import_statement] = sym__import_statement,
  [sym_single_import_statement] = sym_single_import_statement,
  [sym_multi_import_statement] = sym_multi_import_statement,
  [sym__constant_definition] = sym__constant_definition,
  [sym_single_constant_definition] = sym_single_constant_definition,
  [sym_multi_constant_definition] = sym_multi_constant_definition,
  [sym__parameter] = sym__parameter,
  [sym__parameters] = sym__parameters,
  [sym_parameter_list] = sym_parameter_list,
  [sym_element_type] = sym_element_type,
  [sym_element_type_definition] = sym_element_type_definition,
  [sym_element_body] = sym_element_body,
  [sym_property_assignment] = sym_property_assignment,
  [sym__element_instantiation] = sym__element_instantiation,
  [sym__argument] = sym__argument,
  [sym__arguments] = sym__arguments,
  [sym_argument_list] = sym_argument_list,
  [sym_element_definitive_instantiation] = sym_element_definitive_instantiation,
  [sym_element_anonymous_instantiation] = sym_element_anonymous_instantiation,
  [sym_string_literal] = sym_string_literal,
  [sym__integer_literal] = sym__integer_literal,
  [sym_unary_operation] = sym_unary_operation,
  [sym_binary_operation] = sym_binary_operation,
  [sym_call] = sym_call,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_subscript] = sym_subscript,
  [sym_primary_expression] = sym_primary_expression,
  [sym__expressions] = sym__expressions,
  [sym_expression_list] = sym_expression_list,
  [sym__expression] = sym__expression,
  [aux_sym_description_repeat1] = aux_sym_description_repeat1,
  [aux_sym_multi_import_statement_repeat1] = aux_sym_multi_import_statement_repeat1,
  [aux_sym_multi_constant_definition_repeat1] = aux_sym_multi_constant_definition_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym_element_body_repeat1] = aux_sym_element_body_repeat1,
  [aux_sym__arguments_repeat1] = aux_sym__arguments_repeat1,
  [aux_sym_call_repeat1] = aux_sym_call_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_block] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_config] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mask] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_status] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_zero_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym_description] = {
    .visible = true,
    .named = true,
  },
  [sym__declared_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__meta_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__import_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_single_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_multi_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_single_constant_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_multi_constant_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_type] = {
    .visible = true,
    .named = true,
  },
  [sym_element_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_element_body] = {
    .visible = true,
    .named = true,
  },
  [sym_property_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__element_instantiation] = {
    .visible = false,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym__arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_element_definitive_instantiation] = {
    .visible = true,
    .named = true,
  },
  [sym_element_anonymous_instantiation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__integer_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expressions] = {
    .visible = false,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_description_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multi_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multi_constant_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(11);
      if (lookahead == '"') ADVANCE(84);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '%') ADVANCE(98);
      if (lookahead == '(') ADVANCE(72);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == '/') ADVANCE(97);
      if (lookahead == '0') ADVANCE(87);
      if (lookahead == '<') ADVANCE(5);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(6);
      if (lookahead == '[') ADVANCE(82);
      if (lookahead == ']') ADVANCE(83);
      if (lookahead == 'a') ADVANCE(32);
      if (lookahead == 'b') ADVANCE(15);
      if (lookahead == 'c') ADVANCE(38);
      if (lookahead == 'f') ADVANCE(17);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'm') ADVANCE(65);
      if (lookahead == 'o') ADVANCE(44);
      if (lookahead == 'p') ADVANCE(63);
      if (lookahead == 's') ADVANCE(56);
      if (lookahead == 't') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(88);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(84);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '(') ADVANCE(72);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '0') ADVANCE(87);
      if (lookahead == '[') ADVANCE(82);
      if (lookahead == ']') ADVANCE(83);
      if (lookahead == 'f') ADVANCE(61);
      if (lookahead == 't') ADVANCE(45);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(88);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(84);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '(') ADVANCE(72);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '[') ADVANCE(82);
      if (lookahead == 'b') ADVANCE(15);
      if (lookahead == 'c') ADVANCE(41);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == 'm') ADVANCE(65);
      if (lookahead == 'p') ADVANCE(63);
      if (lookahead == 's') ADVANCE(56);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == 'c') ADVANCE(40);
      if (lookahead == 't') ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 5:
      if (lookahead == '<') ADVANCE(100);
      END_STATE();
    case 6:
      if (lookahead == '>') ADVANCE(101);
      END_STATE();
    case 7:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(89);
      END_STATE();
    case 8:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(90);
      END_STATE();
    case 9:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f') ||
          lookahead == '|') ADVANCE(91);
      END_STATE();
    case 10:
      if (eof) ADVANCE(11);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == 'c') ADVANCE(40);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 't') ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(86);
      if (lookahead == '"') ADVANCE(13);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(13);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'e') ||
          ('g' <= lookahead && lookahead <= 'r') ||
          ('t' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 's') ADVANCE(53);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'k') ||
          ('m' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'l') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'q') ||
          ('s' <= lookahead && lookahead <= 'x') ||
          lookahead == 'z') ADVANCE(66);
      if (lookahead == 'r') ADVANCE(57);
      if (lookahead == 'y') ADVANCE(42);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'c') ADVANCE(77);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'c') ADVANCE(28);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'c') ||
          ('e' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'd') ||
          ('f' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'e') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'f') ADVANCE(26);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'g') ADVANCE(76);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'h') ||
          ('j' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'j') ||
          ('l' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'k') ADVANCE(78);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'j') ||
          ('l' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'k') ADVANCE(75);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'k') ||
          ('m' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'l') ADVANCE(52);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'l') ||
          ('n' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'm') ADVANCE(43);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'l') ||
          ('n' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'm') ADVANCE(79);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'm') ||
          ('o' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'n') ADVANCE(20);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'm') ||
          ('o' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'n') ADVANCE(14);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'm') ||
          ('o' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'm') ||
          ('o' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'n') ADVANCE(18);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'm') ||
          ('o' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'n') ||
          ('p' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'n') ||
          ('p' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'n') ||
          ('p' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'o') ADVANCE(47);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'n') ||
          ('p' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'n') ||
          ('p' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'o') ||
          ('q' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'p') ADVANCE(22);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'o') ||
          ('q' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'p') ADVANCE(39);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'q') ||
          ('s' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'q') ||
          ('s' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'q') ||
          ('s' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'q') ||
          ('s' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'r') ||
          ('t' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'r') ||
          ('t' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'r') ||
          ('t' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'r') ||
          ('t' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 's') ADVANCE(53);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'r') ||
          ('t' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 's') ||
          ('u' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 's') ||
          ('u' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 's') ||
          ('u' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 's') ||
          ('u' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'u') ADVANCE(21);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 't') ||
          ('v' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'x') ||
          lookahead == 'z') ADVANCE(66);
      if (lookahead == 'y') ADVANCE(42);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'a') ADVANCE(29);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'a') ADVANCE(31);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_bus);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_block);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_config);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_func);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_mask);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_param);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_status);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '#') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(86);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_zero_literal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(7);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(8);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(9);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_decimal_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_binary_literal);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_octal_literal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_hex_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f') ||
          lookahead == '|') ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(99);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 10},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 1},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 1},
  [16] = {.lex_state = 1},
  [17] = {.lex_state = 1},
  [18] = {.lex_state = 1},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 1},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 1},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 1},
  [27] = {.lex_state = 1},
  [28] = {.lex_state = 1},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 10},
  [32] = {.lex_state = 10},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 3},
  [35] = {.lex_state = 4, .external_lex_state = 2},
  [36] = {.lex_state = 4, .external_lex_state = 2},
  [37] = {.lex_state = 4, .external_lex_state = 2},
  [38] = {.lex_state = 0, .external_lex_state = 3},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 4},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0, .external_lex_state = 3},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 3},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0, .external_lex_state = 3},
  [60] = {.lex_state = 0, .external_lex_state = 3},
  [61] = {.lex_state = 0, .external_lex_state = 3},
  [62] = {.lex_state = 0, .external_lex_state = 3},
  [63] = {.lex_state = 0, .external_lex_state = 3},
  [64] = {.lex_state = 0, .external_lex_state = 3},
  [65] = {.lex_state = 0, .external_lex_state = 3},
  [66] = {.lex_state = 0, .external_lex_state = 3},
  [67] = {.lex_state = 0, .external_lex_state = 3},
  [68] = {.lex_state = 0, .external_lex_state = 3},
  [69] = {.lex_state = 0, .external_lex_state = 3},
  [70] = {.lex_state = 0, .external_lex_state = 3},
  [71] = {.lex_state = 0, .external_lex_state = 3},
  [72] = {.lex_state = 0, .external_lex_state = 3},
  [73] = {.lex_state = 10, .external_lex_state = 4},
  [74] = {.lex_state = 10, .external_lex_state = 4},
  [75] = {.lex_state = 10, .external_lex_state = 4},
  [76] = {.lex_state = 10, .external_lex_state = 4},
  [77] = {.lex_state = 10, .external_lex_state = 4},
  [78] = {.lex_state = 10, .external_lex_state = 4},
  [79] = {.lex_state = 10, .external_lex_state = 4},
  [80] = {.lex_state = 10, .external_lex_state = 4},
  [81] = {.lex_state = 10, .external_lex_state = 4},
  [82] = {.lex_state = 4, .external_lex_state = 5},
  [83] = {.lex_state = 10},
  [84] = {.lex_state = 10},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 4, .external_lex_state = 5},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 4, .external_lex_state = 5},
  [89] = {.lex_state = 4, .external_lex_state = 5},
  [90] = {.lex_state = 10},
  [91] = {.lex_state = 10},
  [92] = {.lex_state = 10},
  [93] = {.lex_state = 10},
  [94] = {.lex_state = 4, .external_lex_state = 5},
  [95] = {.lex_state = 2, .external_lex_state = 2},
  [96] = {.lex_state = 4, .external_lex_state = 5},
  [97] = {.lex_state = 10},
  [98] = {.lex_state = 4, .external_lex_state = 5},
  [99] = {.lex_state = 10},
  [100] = {.lex_state = 4, .external_lex_state = 5},
  [101] = {.lex_state = 4, .external_lex_state = 5},
  [102] = {.lex_state = 10},
  [103] = {.lex_state = 10},
  [104] = {.lex_state = 10},
  [105] = {.lex_state = 2, .external_lex_state = 2},
  [106] = {.lex_state = 10},
  [107] = {.lex_state = 10},
  [108] = {.lex_state = 10},
  [109] = {.lex_state = 10},
  [110] = {.lex_state = 4, .external_lex_state = 2},
  [111] = {.lex_state = 4, .external_lex_state = 2},
  [112] = {.lex_state = 0, .external_lex_state = 3},
  [113] = {.lex_state = 4, .external_lex_state = 2},
  [114] = {.lex_state = 4, .external_lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 0, .external_lex_state = 3},
  [117] = {.lex_state = 0, .external_lex_state = 3},
  [118] = {.lex_state = 0, .external_lex_state = 3},
  [119] = {.lex_state = 4, .external_lex_state = 2},
  [120] = {.lex_state = 4, .external_lex_state = 2},
  [121] = {.lex_state = 4, .external_lex_state = 2},
  [122] = {.lex_state = 0, .external_lex_state = 3},
  [123] = {.lex_state = 2, .external_lex_state = 3},
  [124] = {.lex_state = 0, .external_lex_state = 3},
  [125] = {.lex_state = 0, .external_lex_state = 3},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 4, .external_lex_state = 2},
  [129] = {.lex_state = 4, .external_lex_state = 2},
  [130] = {.lex_state = 4, .external_lex_state = 2},
  [131] = {.lex_state = 4, .external_lex_state = 2},
  [132] = {.lex_state = 4, .external_lex_state = 2},
  [133] = {.lex_state = 0, .external_lex_state = 3},
  [134] = {.lex_state = 4, .external_lex_state = 2},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 2, .external_lex_state = 2},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 2, .external_lex_state = 2},
  [146] = {.lex_state = 2},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0, .external_lex_state = 3},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 2, .external_lex_state = 2},
  [154] = {.lex_state = 2, .external_lex_state = 2},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 2, .external_lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 3},
  [160] = {.lex_state = 0, .external_lex_state = 3},
  [161] = {.lex_state = 0, .external_lex_state = 3},
  [162] = {.lex_state = 0, .external_lex_state = 3},
  [163] = {.lex_state = 0, .external_lex_state = 3},
  [164] = {.lex_state = 0, .external_lex_state = 3},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0, .external_lex_state = 3},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0, .external_lex_state = 3},
  [169] = {.lex_state = 2},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 0, .external_lex_state = 3},
  [172] = {.lex_state = 2},
  [173] = {.lex_state = 2, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 3},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 0},
  [179] = {.lex_state = 0, .external_lex_state = 3},
  [180] = {.lex_state = 0, .external_lex_state = 3},
  [181] = {.lex_state = 2},
  [182] = {.lex_state = 2, .external_lex_state = 3},
  [183] = {.lex_state = 2, .external_lex_state = 3},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 0, .external_lex_state = 3},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0, .external_lex_state = 3},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 85},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0, .external_lex_state = 3},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 0, .external_lex_state = 3},
  [197] = {.lex_state = 0, .external_lex_state = 3},
  [198] = {.lex_state = 0, .external_lex_state = 3},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0, .external_lex_state = 4},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 4},
  [205] = {.lex_state = 0, .external_lex_state = 3},
  [206] = {.lex_state = 0, .external_lex_state = 3},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 85},
  [209] = {.lex_state = 2},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0, .external_lex_state = 3},
  [213] = {.lex_state = 0, .external_lex_state = 3},
  [214] = {.lex_state = 0, .external_lex_state = 3},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 2},
  [218] = {.lex_state = 2},
  [219] = {.lex_state = 0, .external_lex_state = 4},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 0, .external_lex_state = 3},
};

enum {
  ts_external_token__indent = 0,
  ts_external_token__dedent = 1,
  ts_external_token__newline = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__newline] = sym__newline,
};

static const bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__newline] = true,
  },
  [2] = {
    [ts_external_token__dedent] = true,
  },
  [3] = {
    [ts_external_token__newline] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_bus] = ACTIONS(1),
    [anon_sym_block] = ACTIONS(1),
    [anon_sym_config] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_mask] = ACTIONS(1),
    [anon_sym_param] = ACTIONS(1),
    [anon_sym_status] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_zero_literal] = ACTIONS(1),
    [sym_decimal_literal] = ACTIONS(1),
    [sym_binary_literal] = ACTIONS(1),
    [sym_octal_literal] = ACTIONS(1),
    [sym_hex_literal] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
  },
  [1] = {
    [sym_description] = STATE(216),
    [sym__meta_statement] = STATE(32),
    [sym__import_statement] = STATE(32),
    [sym_single_import_statement] = STATE(32),
    [sym_multi_import_statement] = STATE(32),
    [sym__constant_definition] = STATE(32),
    [sym_single_constant_definition] = STATE(32),
    [sym_multi_constant_definition] = STATE(32),
    [sym_element_type_definition] = STATE(32),
    [sym__element_instantiation] = STATE(32),
    [sym_element_definitive_instantiation] = STATE(32),
    [sym_element_anonymous_instantiation] = STATE(32),
    [aux_sym_description_repeat1] = STATE(32),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_const] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_RPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(170), 1,
      sym__declared_identifier,
    STATE(184), 1,
      sym__arguments,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    STATE(156), 3,
      sym__argument,
      sym_expression_list,
      sym__expression,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [60] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(187), 1,
      sym__expressions,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(138), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [119] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(195), 1,
      sym__expressions,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(138), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [178] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(170), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    STATE(177), 3,
      sym__argument,
      sym_expression_list,
      sym__expression,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [232] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(176), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [285] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(191), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [338] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(201), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [391] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(222), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [444] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(155), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [497] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(63), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(197), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [550] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(210), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [603] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(194), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [656] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(178), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [709] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(136), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [762] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(63), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(213), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [815] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(140), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [868] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(63), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(205), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [921] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(48), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(185), 2,
      sym_expression_list,
      sym__expression,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [974] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(64), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1020] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(45), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1066] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(51), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1112] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(68), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1158] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(47), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1204] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(60), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1250] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(62), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1296] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(44), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1342] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(61), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1388] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(59), 1,
      sym_qualified_identifier,
    STATE(72), 1,
      sym_primary_expression,
    STATE(221), 1,
      sym__declared_identifier,
    ACTIONS(47), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(43), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(45), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(66), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1434] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(42), 1,
      sym_qualified_identifier,
    STATE(56), 1,
      sym_primary_expression,
    STATE(207), 1,
      sym__declared_identifier,
    ACTIONS(29), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(25), 3,
      sym_zero_literal,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(27), 4,
      sym_decimal_literal,
      sym_binary_literal,
      sym_octal_literal,
      sym_hex_literal,
    STATE(52), 7,
      sym_string_literal,
      sym__integer_literal,
      sym_unary_operation,
      sym_binary_operation,
      sym_call,
      sym_parenthesized_expression,
      sym_subscript,
  [1480] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      ts_builtin_sym_end,
    ACTIONS(51), 1,
      sym_identifier,
    ACTIONS(54), 1,
      anon_sym_import,
    ACTIONS(57), 1,
      anon_sym_const,
    ACTIONS(60), 1,
      anon_sym_type,
    STATE(31), 12,
      sym__meta_statement,
      sym__import_statement,
      sym_single_import_statement,
      sym_multi_import_statement,
      sym__constant_definition,
      sym_single_constant_definition,
      sym_multi_constant_definition,
      sym_element_type_definition,
      sym__element_instantiation,
      sym_element_definitive_instantiation,
      sym_element_anonymous_instantiation,
      aux_sym_description_repeat1,
  [1513] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_import,
    ACTIONS(11), 1,
      anon_sym_const,
    ACTIONS(13), 1,
      anon_sym_type,
    ACTIONS(63), 1,
      ts_builtin_sym_end,
    STATE(31), 12,
      sym__meta_statement,
      sym__import_statement,
      sym_single_import_statement,
      sym_multi_import_statement,
      sym__constant_definition,
      sym_single_constant_definition,
      sym_multi_constant_definition,
      sym_element_type_definition,
      sym__element_instantiation,
      sym_element_definitive_instantiation,
      sym_element_anonymous_instantiation,
      aux_sym_description_repeat1,
  [1546] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      anon_sym_STAR,
    ACTIONS(67), 2,
      anon_sym_EQ,
      anon_sym_LBRACK,
    ACTIONS(69), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1575] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(77), 1,
      anon_sym_EQ,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(168), 1,
      sym_element_type,
    STATE(124), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
    ACTIONS(79), 7,
      anon_sym_bus,
      anon_sym_block,
      anon_sym_config,
      anon_sym_func,
      anon_sym_mask,
      anon_sym_param,
      anon_sym_status,
  [1604] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      sym_identifier,
    ACTIONS(85), 1,
      anon_sym_const,
    ACTIONS(87), 1,
      anon_sym_type,
    ACTIONS(89), 1,
      sym__dedent,
    STATE(36), 9,
      sym__constant_definition,
      sym_single_constant_definition,
      sym_multi_constant_definition,
      sym_element_type_definition,
      sym_property_assignment,
      sym__element_instantiation,
      sym_element_definitive_instantiation,
      sym_element_anonymous_instantiation,
      aux_sym_element_body_repeat1,
  [1631] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      sym_identifier,
    ACTIONS(94), 1,
      anon_sym_const,
    ACTIONS(97), 1,
      anon_sym_type,
    ACTIONS(100), 1,
      sym__dedent,
    STATE(36), 9,
      sym__constant_definition,
      sym_single_constant_definition,
      sym_multi_constant_definition,
      sym_element_type_definition,
      sym_property_assignment,
      sym__element_instantiation,
      sym_element_definitive_instantiation,
      sym_element_anonymous_instantiation,
      aux_sym_element_body_repeat1,
  [1658] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      sym_identifier,
    ACTIONS(85), 1,
      anon_sym_const,
    ACTIONS(87), 1,
      anon_sym_type,
    ACTIONS(102), 1,
      sym__dedent,
    STATE(36), 9,
      sym__constant_definition,
      sym_single_constant_definition,
      sym_multi_constant_definition,
      sym_element_type_definition,
      sym_property_assignment,
      sym__element_instantiation,
      sym_element_definitive_instantiation,
      sym_element_anonymous_instantiation,
      aux_sym_element_body_repeat1,
  [1685] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      anon_sym_STAR,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(106), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(110), 1,
      anon_sym_STAR,
    ACTIONS(108), 11,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1731] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      sym_identifier,
    ACTIONS(85), 1,
      anon_sym_const,
    ACTIONS(87), 1,
      anon_sym_type,
    STATE(35), 9,
      sym__constant_definition,
      sym_single_constant_definition,
      sym_multi_constant_definition,
      sym_element_type_definition,
      sym_property_assignment,
      sym__element_instantiation,
      sym_element_definitive_instantiation,
      sym_element_anonymous_instantiation,
      aux_sym_element_body_repeat1,
  [1755] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      sym_identifier,
    ACTIONS(85), 1,
      anon_sym_const,
    ACTIONS(87), 1,
      anon_sym_type,
    STATE(37), 9,
      sym__constant_definition,
      sym_single_constant_definition,
      sym_multi_constant_definition,
      sym_element_type_definition,
      sym_property_assignment,
      sym__element_instantiation,
      sym_element_definitive_instantiation,
      sym_element_anonymous_instantiation,
      aux_sym_element_body_repeat1,
  [1779] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      anon_sym_STAR,
    ACTIONS(112), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1801] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(114), 1,
      anon_sym_LBRACK,
    STATE(159), 1,
      sym_element_type,
    STATE(133), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
    ACTIONS(79), 7,
      anon_sym_bus,
      anon_sym_block,
      anon_sym_config,
      anon_sym_func,
      anon_sym_mask,
      anon_sym_param,
      anon_sym_status,
  [1827] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(118), 1,
      anon_sym_STAR,
    ACTIONS(120), 1,
      anon_sym_STAR_STAR,
    ACTIONS(116), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1848] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 1,
      anon_sym_STAR_STAR,
    ACTIONS(124), 1,
      anon_sym_STAR,
    ACTIONS(122), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(126), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(116), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(110), 1,
      anon_sym_STAR,
    ACTIONS(108), 10,
      sym__newline,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1892] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(118), 1,
      anon_sym_STAR,
    ACTIONS(120), 1,
      anon_sym_STAR_STAR,
    ACTIONS(116), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1913] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 1,
      anon_sym_STAR_STAR,
    ACTIONS(124), 1,
      anon_sym_STAR,
    ACTIONS(122), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(126), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(130), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(128), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(134), 1,
      anon_sym_STAR,
    ACTIONS(132), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(138), 1,
      anon_sym_STAR,
    ACTIONS(136), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1978] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 1,
      anon_sym_STAR_STAR,
    ACTIONS(142), 1,
      anon_sym_STAR,
    ACTIONS(140), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [1999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      anon_sym_STAR,
    ACTIONS(69), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2018] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(146), 1,
      anon_sym_STAR,
    ACTIONS(144), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2037] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(150), 1,
      anon_sym_STAR,
    ACTIONS(148), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2056] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(162), 1,
      sym_element_type,
    STATE(118), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
    ACTIONS(79), 7,
      anon_sym_bus,
      anon_sym_block,
      anon_sym_config,
      anon_sym_func,
      anon_sym_mask,
      anon_sym_param,
      anon_sym_status,
  [2079] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 1,
      anon_sym_STAR_STAR,
    ACTIONS(124), 1,
      anon_sym_STAR,
    ACTIONS(126), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(116), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2102] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(164), 1,
      sym_element_type,
    STATE(112), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
    ACTIONS(79), 7,
      anon_sym_bus,
      anon_sym_block,
      anon_sym_config,
      anon_sym_func,
      anon_sym_mask,
      anon_sym_param,
      anon_sym_status,
  [2125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(154), 1,
      anon_sym_STAR,
    ACTIONS(152), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2144] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      anon_sym_STAR,
    ACTIONS(156), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2164] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(118), 1,
      anon_sym_STAR,
    ACTIONS(158), 1,
      anon_sym_STAR_STAR,
    ACTIONS(116), 7,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2183] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(118), 1,
      anon_sym_STAR,
    ACTIONS(158), 1,
      anon_sym_STAR_STAR,
    ACTIONS(116), 7,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2202] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(142), 1,
      anon_sym_STAR,
    ACTIONS(158), 1,
      anon_sym_STAR_STAR,
    ACTIONS(140), 7,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2221] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(128), 1,
      sym__newline,
    ACTIONS(158), 1,
      anon_sym_STAR_STAR,
    ACTIONS(162), 1,
      anon_sym_STAR,
    ACTIONS(160), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(164), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(166), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2246] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_STAR_STAR,
    ACTIONS(162), 1,
      anon_sym_STAR,
    ACTIONS(168), 1,
      sym__newline,
    ACTIONS(160), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(164), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(166), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(134), 1,
      anon_sym_STAR,
    ACTIONS(132), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2288] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      anon_sym_STAR,
    ACTIONS(69), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(138), 1,
      anon_sym_STAR,
    ACTIONS(136), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2322] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_STAR_STAR,
    ACTIONS(162), 1,
      anon_sym_STAR,
    ACTIONS(164), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(116), 5,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(146), 1,
      anon_sym_STAR,
    ACTIONS(144), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(154), 1,
      anon_sym_STAR,
    ACTIONS(152), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(150), 1,
      anon_sym_STAR,
    ACTIONS(148), 8,
      sym__newline,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2394] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_STAR_STAR,
    ACTIONS(162), 1,
      anon_sym_STAR,
    ACTIONS(160), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(164), 2,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(116), 3,
      sym__newline,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
  [2417] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      ts_builtin_sym_end,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(172), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2433] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(176), 1,
      ts_builtin_sym_end,
    ACTIONS(178), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(180), 1,
      ts_builtin_sym_end,
    ACTIONS(182), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2465] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(184), 1,
      ts_builtin_sym_end,
    ACTIONS(186), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2481] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(188), 1,
      ts_builtin_sym_end,
    ACTIONS(190), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2497] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(192), 1,
      ts_builtin_sym_end,
    ACTIONS(194), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2513] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(196), 1,
      ts_builtin_sym_end,
    ACTIONS(198), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2529] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(200), 1,
      ts_builtin_sym_end,
    ACTIONS(202), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2545] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(174), 1,
      sym__indent,
    ACTIONS(204), 1,
      ts_builtin_sym_end,
    ACTIONS(206), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2561] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(178), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      ts_builtin_sym_end,
    ACTIONS(194), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2589] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(210), 1,
      ts_builtin_sym_end,
    ACTIONS(212), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2602] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      sym_identifier,
    ACTIONS(216), 1,
      anon_sym_LPAREN,
    STATE(135), 1,
      sym_parameter_list,
    STATE(116), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
  [2619] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(190), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2634] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      sym_identifier,
    ACTIONS(216), 1,
      anon_sym_LPAREN,
    STATE(146), 1,
      sym_parameter_list,
    STATE(122), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
  [2651] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(186), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2666] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(172), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      ts_builtin_sym_end,
    ACTIONS(186), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2694] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      ts_builtin_sym_end,
    ACTIONS(172), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 1,
      ts_builtin_sym_end,
    ACTIONS(190), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(180), 1,
      ts_builtin_sym_end,
    ACTIONS(182), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2733] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(198), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2748] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(218), 1,
      sym_identifier,
    ACTIONS(220), 1,
      sym__dedent,
    STATE(105), 1,
      aux_sym_multi_import_statement_repeat1,
    STATE(196), 1,
      sym_string_literal,
  [2767] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(202), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 1,
      ts_builtin_sym_end,
    ACTIONS(202), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2795] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(206), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      ts_builtin_sym_end,
    ACTIONS(198), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2823] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(194), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2838] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(180), 1,
      sym__dedent,
    ACTIONS(208), 1,
      sym__indent,
    ACTIONS(182), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      ts_builtin_sym_end,
    ACTIONS(206), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      ts_builtin_sym_end,
    ACTIONS(178), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 1,
      ts_builtin_sym_end,
    ACTIONS(224), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2892] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(226), 1,
      sym_identifier,
    ACTIONS(229), 1,
      anon_sym_DQUOTE,
    ACTIONS(232), 1,
      sym__dedent,
    STATE(105), 1,
      aux_sym_multi_import_statement_repeat1,
    STATE(196), 1,
      sym_string_literal,
  [2911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 1,
      ts_builtin_sym_end,
    ACTIONS(236), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      ts_builtin_sym_end,
    ACTIONS(240), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 1,
      ts_builtin_sym_end,
    ACTIONS(244), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(246), 1,
      ts_builtin_sym_end,
    ACTIONS(248), 4,
      sym_identifier,
      anon_sym_import,
      anon_sym_const,
      anon_sym_type,
  [2963] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(252), 1,
      sym__dedent,
    ACTIONS(250), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      sym__dedent,
    ACTIONS(172), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [2987] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(256), 1,
      sym__newline,
    STATE(97), 1,
      sym_element_body,
    STATE(179), 1,
      sym_argument_list,
  [3003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(180), 1,
      sym__dedent,
    ACTIONS(182), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(184), 1,
      sym__dedent,
    ACTIONS(186), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3027] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 1,
      sym_identifier,
    ACTIONS(260), 1,
      anon_sym_RPAREN,
    STATE(148), 1,
      sym__parameter,
    STATE(211), 1,
      sym__parameters,
  [3043] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(262), 1,
      sym__newline,
    STATE(91), 1,
      sym_element_body,
    STATE(171), 1,
      sym_argument_list,
  [3059] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(264), 1,
      sym__newline,
    STATE(134), 1,
      sym_element_body,
    STATE(161), 1,
      sym_argument_list,
  [3075] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(266), 1,
      sym__newline,
    STATE(130), 1,
      sym_element_body,
    STATE(163), 1,
      sym_argument_list,
  [3091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      sym__dedent,
    ACTIONS(194), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3103] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      sym__dedent,
    ACTIONS(178), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(188), 1,
      sym__dedent,
    ACTIONS(190), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3127] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(268), 1,
      sym__newline,
    STATE(111), 1,
      sym_element_body,
    STATE(160), 1,
      sym_argument_list,
  [3143] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(272), 1,
      sym__newline,
    STATE(198), 1,
      sym_string_literal,
  [3159] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      sym__newline,
    STATE(121), 1,
      sym_element_body,
    STATE(166), 1,
      sym_argument_list,
  [3175] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(276), 1,
      sym__newline,
    STATE(99), 1,
      sym_element_body,
    STATE(180), 1,
      sym_argument_list,
  [3191] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 1,
      anon_sym_COMMA,
    STATE(126), 1,
      aux_sym_call_repeat1,
    ACTIONS(281), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [3205] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    ACTIONS(218), 1,
      sym_identifier,
    STATE(95), 1,
      aux_sym_multi_import_statement_repeat1,
    STATE(196), 1,
      sym_string_literal,
  [3221] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      sym__dedent,
    ACTIONS(240), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3233] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      sym__dedent,
    ACTIONS(206), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 1,
      sym__dedent,
    ACTIONS(202), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 1,
      sym__dedent,
    ACTIONS(236), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(242), 1,
      sym__dedent,
    ACTIONS(244), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3281] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(254), 1,
      anon_sym_LPAREN,
    ACTIONS(283), 1,
      sym__newline,
    STATE(92), 1,
      sym_element_body,
    STATE(174), 1,
      sym_argument_list,
  [3297] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      sym__dedent,
    ACTIONS(198), 3,
      sym_identifier,
      anon_sym_const,
      anon_sym_type,
  [3309] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      sym_identifier,
    STATE(125), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
  [3320] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [3329] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(287), 1,
      anon_sym_RBRACK,
    STATE(126), 1,
      aux_sym_call_repeat1,
  [3342] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(289), 1,
      anon_sym_RBRACK,
    STATE(137), 1,
      aux_sym_call_repeat1,
  [3355] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [3364] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(293), 1,
      anon_sym_RPAREN,
    STATE(144), 1,
      aux_sym_call_repeat1,
  [3377] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [3386] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 3,
      sym__dedent,
      sym_identifier,
      anon_sym_DQUOTE,
  [3395] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 1,
      anon_sym_COMMA,
    ACTIONS(302), 1,
      anon_sym_RPAREN,
    STATE(143), 1,
      aux_sym__arguments_repeat1,
  [3408] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(304), 1,
      anon_sym_RPAREN,
    STATE(126), 1,
      aux_sym_call_repeat1,
  [3421] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(232), 3,
      sym__dedent,
      sym_identifier,
      anon_sym_DQUOTE,
  [3430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      sym_identifier,
    STATE(117), 2,
      sym__declared_identifier,
      sym_qualified_identifier,
  [3441] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(306), 1,
      anon_sym_RPAREN,
    STATE(126), 1,
      aux_sym_call_repeat1,
  [3454] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      anon_sym_COMMA,
    ACTIONS(310), 1,
      anon_sym_RPAREN,
    STATE(151), 1,
      aux_sym__parameters_repeat1,
  [3467] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(104), 1,
      anon_sym_DOT,
    ACTIONS(67), 2,
      sym__newline,
      anon_sym_LPAREN,
  [3478] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(312), 1,
      anon_sym_EQ,
    ACTIONS(314), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [3489] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(308), 1,
      anon_sym_COMMA,
    ACTIONS(316), 1,
      anon_sym_RPAREN,
    STATE(152), 1,
      aux_sym__parameters_repeat1,
  [3502] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 1,
      anon_sym_COMMA,
    ACTIONS(321), 1,
      anon_sym_RPAREN,
    STATE(152), 1,
      aux_sym__parameters_repeat1,
  [3515] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(323), 1,
      sym_identifier,
    ACTIONS(326), 1,
      sym__dedent,
    STATE(153), 1,
      aux_sym_multi_constant_definition_repeat1,
  [3528] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 1,
      sym_identifier,
    ACTIONS(330), 1,
      sym__dedent,
    STATE(153), 1,
      aux_sym_multi_constant_definition_repeat1,
  [3541] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    ACTIONS(332), 1,
      anon_sym_RPAREN,
    STATE(147), 1,
      aux_sym_call_repeat1,
  [3554] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      anon_sym_COMMA,
    ACTIONS(336), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      aux_sym__arguments_repeat1,
  [3567] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(334), 1,
      anon_sym_COMMA,
    ACTIONS(338), 1,
      anon_sym_RPAREN,
    STATE(143), 1,
      aux_sym__arguments_repeat1,
  [3580] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 1,
      sym_identifier,
    ACTIONS(340), 1,
      sym__dedent,
    STATE(153), 1,
      aux_sym_multi_constant_definition_repeat1,
  [3593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(342), 1,
      sym__newline,
    STATE(103), 1,
      sym_element_body,
  [3603] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 1,
      sym__newline,
    STATE(134), 1,
      sym_element_body,
  [3613] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(344), 1,
      sym__newline,
    STATE(119), 1,
      sym_element_body,
  [3623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(346), 1,
      sym__newline,
    STATE(129), 1,
      sym_element_body,
  [3633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(348), 1,
      sym__newline,
    STATE(113), 1,
      sym_element_body,
  [3643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(350), 1,
      sym__newline,
    STATE(102), 1,
      sym_element_body,
  [3653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(224), 1,
      sym_string_literal,
  [3663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(352), 1,
      sym__newline,
    STATE(114), 1,
      sym_element_body,
  [3673] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_DQUOTE,
    STATE(212), 1,
      sym_string_literal,
  [3683] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(354), 1,
      sym__newline,
    STATE(120), 1,
      sym_element_body,
  [3693] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 1,
      sym_identifier,
    STATE(154), 1,
      aux_sym_multi_constant_definition_repeat1,
  [3703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(112), 1,
      anon_sym_LBRACK,
    ACTIONS(356), 1,
      anon_sym_EQ,
  [3713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(276), 1,
      sym__newline,
    STATE(99), 1,
      sym_element_body,
  [3723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 1,
      sym_identifier,
    STATE(158), 1,
      aux_sym_multi_constant_definition_repeat1,
  [3733] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(358), 2,
      sym__dedent,
      sym_identifier,
  [3741] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(360), 1,
      sym__newline,
    STATE(90), 1,
      sym_element_body,
  [3751] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [3759] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(362), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [3767] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [3775] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(364), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [3783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(366), 1,
      sym__newline,
    STATE(93), 1,
      sym_element_body,
  [3793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 1,
      sym__newline,
    STATE(83), 1,
      sym_element_body,
  [3803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(258), 1,
      sym_identifier,
    STATE(175), 1,
      sym__parameter,
  [3813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      sym_identifier,
    ACTIONS(372), 1,
      sym__newline,
  [3823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      sym_identifier,
    ACTIONS(376), 1,
      sym__newline,
  [3833] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_RPAREN,
  [3840] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 1,
      anon_sym_RPAREN,
  [3847] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      sym__newline,
  [3854] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 1,
      anon_sym_RBRACK,
  [3861] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      sym__newline,
  [3868] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
  [3875] = 2,
    ACTIONS(390), 1,
      sym_comment,
    ACTIONS(392), 1,
      aux_sym_string_literal_token1,
  [3882] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 1,
      anon_sym_RBRACK,
  [3889] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 1,
      anon_sym_DQUOTE,
  [3896] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      sym__newline,
  [3903] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 1,
      anon_sym_RPAREN,
  [3910] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 1,
      anon_sym_RBRACK,
  [3917] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 1,
      sym__newline,
  [3924] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      sym__newline,
  [3931] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 1,
      sym__newline,
  [3938] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_EQ,
  [3945] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 1,
      sym__indent,
  [3952] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 1,
      anon_sym_RBRACK,
  [3959] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_EQ,
  [3966] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 1,
      sym_identifier,
  [3973] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 1,
      sym__indent,
  [3980] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(420), 1,
      sym__newline,
  [3987] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(295), 1,
      sym__newline,
  [3994] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(112), 1,
      anon_sym_LBRACK,
  [4001] = 2,
    ACTIONS(390), 1,
      sym_comment,
    ACTIONS(422), 1,
      aux_sym_string_literal_token1,
  [4008] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
  [4015] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 1,
      anon_sym_RBRACK,
  [4022] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(428), 1,
      anon_sym_RPAREN,
  [4029] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 1,
      sym__newline,
  [4036] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(432), 1,
      sym__newline,
  [4043] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(434), 1,
      sym__newline,
  [4050] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
  [4057] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 1,
      ts_builtin_sym_end,
  [4064] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 1,
      sym_identifier,
  [4071] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 1,
      sym_identifier,
  [4078] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 1,
      sym__indent,
  [4085] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 1,
      anon_sym_EQ,
  [4092] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      anon_sym_LBRACK,
  [4099] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(448), 1,
      anon_sym_RBRACK,
  [4106] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 1,
      sym_identifier,
  [4113] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(452), 1,
      sym__newline,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 60,
  [SMALL_STATE(4)] = 119,
  [SMALL_STATE(5)] = 178,
  [SMALL_STATE(6)] = 232,
  [SMALL_STATE(7)] = 285,
  [SMALL_STATE(8)] = 338,
  [SMALL_STATE(9)] = 391,
  [SMALL_STATE(10)] = 444,
  [SMALL_STATE(11)] = 497,
  [SMALL_STATE(12)] = 550,
  [SMALL_STATE(13)] = 603,
  [SMALL_STATE(14)] = 656,
  [SMALL_STATE(15)] = 709,
  [SMALL_STATE(16)] = 762,
  [SMALL_STATE(17)] = 815,
  [SMALL_STATE(18)] = 868,
  [SMALL_STATE(19)] = 921,
  [SMALL_STATE(20)] = 974,
  [SMALL_STATE(21)] = 1020,
  [SMALL_STATE(22)] = 1066,
  [SMALL_STATE(23)] = 1112,
  [SMALL_STATE(24)] = 1158,
  [SMALL_STATE(25)] = 1204,
  [SMALL_STATE(26)] = 1250,
  [SMALL_STATE(27)] = 1296,
  [SMALL_STATE(28)] = 1342,
  [SMALL_STATE(29)] = 1388,
  [SMALL_STATE(30)] = 1434,
  [SMALL_STATE(31)] = 1480,
  [SMALL_STATE(32)] = 1513,
  [SMALL_STATE(33)] = 1546,
  [SMALL_STATE(34)] = 1575,
  [SMALL_STATE(35)] = 1604,
  [SMALL_STATE(36)] = 1631,
  [SMALL_STATE(37)] = 1658,
  [SMALL_STATE(38)] = 1685,
  [SMALL_STATE(39)] = 1711,
  [SMALL_STATE(40)] = 1731,
  [SMALL_STATE(41)] = 1755,
  [SMALL_STATE(42)] = 1779,
  [SMALL_STATE(43)] = 1801,
  [SMALL_STATE(44)] = 1827,
  [SMALL_STATE(45)] = 1848,
  [SMALL_STATE(46)] = 1873,
  [SMALL_STATE(47)] = 1892,
  [SMALL_STATE(48)] = 1913,
  [SMALL_STATE(49)] = 1940,
  [SMALL_STATE(50)] = 1959,
  [SMALL_STATE(51)] = 1978,
  [SMALL_STATE(52)] = 1999,
  [SMALL_STATE(53)] = 2018,
  [SMALL_STATE(54)] = 2037,
  [SMALL_STATE(55)] = 2056,
  [SMALL_STATE(56)] = 2079,
  [SMALL_STATE(57)] = 2102,
  [SMALL_STATE(58)] = 2125,
  [SMALL_STATE(59)] = 2144,
  [SMALL_STATE(60)] = 2164,
  [SMALL_STATE(61)] = 2183,
  [SMALL_STATE(62)] = 2202,
  [SMALL_STATE(63)] = 2221,
  [SMALL_STATE(64)] = 2246,
  [SMALL_STATE(65)] = 2271,
  [SMALL_STATE(66)] = 2288,
  [SMALL_STATE(67)] = 2305,
  [SMALL_STATE(68)] = 2322,
  [SMALL_STATE(69)] = 2343,
  [SMALL_STATE(70)] = 2360,
  [SMALL_STATE(71)] = 2377,
  [SMALL_STATE(72)] = 2394,
  [SMALL_STATE(73)] = 2417,
  [SMALL_STATE(74)] = 2433,
  [SMALL_STATE(75)] = 2449,
  [SMALL_STATE(76)] = 2465,
  [SMALL_STATE(77)] = 2481,
  [SMALL_STATE(78)] = 2497,
  [SMALL_STATE(79)] = 2513,
  [SMALL_STATE(80)] = 2529,
  [SMALL_STATE(81)] = 2545,
  [SMALL_STATE(82)] = 2561,
  [SMALL_STATE(83)] = 2576,
  [SMALL_STATE(84)] = 2589,
  [SMALL_STATE(85)] = 2602,
  [SMALL_STATE(86)] = 2619,
  [SMALL_STATE(87)] = 2634,
  [SMALL_STATE(88)] = 2651,
  [SMALL_STATE(89)] = 2666,
  [SMALL_STATE(90)] = 2681,
  [SMALL_STATE(91)] = 2694,
  [SMALL_STATE(92)] = 2707,
  [SMALL_STATE(93)] = 2720,
  [SMALL_STATE(94)] = 2733,
  [SMALL_STATE(95)] = 2748,
  [SMALL_STATE(96)] = 2767,
  [SMALL_STATE(97)] = 2782,
  [SMALL_STATE(98)] = 2795,
  [SMALL_STATE(99)] = 2810,
  [SMALL_STATE(100)] = 2823,
  [SMALL_STATE(101)] = 2838,
  [SMALL_STATE(102)] = 2853,
  [SMALL_STATE(103)] = 2866,
  [SMALL_STATE(104)] = 2879,
  [SMALL_STATE(105)] = 2892,
  [SMALL_STATE(106)] = 2911,
  [SMALL_STATE(107)] = 2924,
  [SMALL_STATE(108)] = 2937,
  [SMALL_STATE(109)] = 2950,
  [SMALL_STATE(110)] = 2963,
  [SMALL_STATE(111)] = 2975,
  [SMALL_STATE(112)] = 2987,
  [SMALL_STATE(113)] = 3003,
  [SMALL_STATE(114)] = 3015,
  [SMALL_STATE(115)] = 3027,
  [SMALL_STATE(116)] = 3043,
  [SMALL_STATE(117)] = 3059,
  [SMALL_STATE(118)] = 3075,
  [SMALL_STATE(119)] = 3091,
  [SMALL_STATE(120)] = 3103,
  [SMALL_STATE(121)] = 3115,
  [SMALL_STATE(122)] = 3127,
  [SMALL_STATE(123)] = 3143,
  [SMALL_STATE(124)] = 3159,
  [SMALL_STATE(125)] = 3175,
  [SMALL_STATE(126)] = 3191,
  [SMALL_STATE(127)] = 3205,
  [SMALL_STATE(128)] = 3221,
  [SMALL_STATE(129)] = 3233,
  [SMALL_STATE(130)] = 3245,
  [SMALL_STATE(131)] = 3257,
  [SMALL_STATE(132)] = 3269,
  [SMALL_STATE(133)] = 3281,
  [SMALL_STATE(134)] = 3297,
  [SMALL_STATE(135)] = 3309,
  [SMALL_STATE(136)] = 3320,
  [SMALL_STATE(137)] = 3329,
  [SMALL_STATE(138)] = 3342,
  [SMALL_STATE(139)] = 3355,
  [SMALL_STATE(140)] = 3364,
  [SMALL_STATE(141)] = 3377,
  [SMALL_STATE(142)] = 3386,
  [SMALL_STATE(143)] = 3395,
  [SMALL_STATE(144)] = 3408,
  [SMALL_STATE(145)] = 3421,
  [SMALL_STATE(146)] = 3430,
  [SMALL_STATE(147)] = 3441,
  [SMALL_STATE(148)] = 3454,
  [SMALL_STATE(149)] = 3467,
  [SMALL_STATE(150)] = 3478,
  [SMALL_STATE(151)] = 3489,
  [SMALL_STATE(152)] = 3502,
  [SMALL_STATE(153)] = 3515,
  [SMALL_STATE(154)] = 3528,
  [SMALL_STATE(155)] = 3541,
  [SMALL_STATE(156)] = 3554,
  [SMALL_STATE(157)] = 3567,
  [SMALL_STATE(158)] = 3580,
  [SMALL_STATE(159)] = 3593,
  [SMALL_STATE(160)] = 3603,
  [SMALL_STATE(161)] = 3613,
  [SMALL_STATE(162)] = 3623,
  [SMALL_STATE(163)] = 3633,
  [SMALL_STATE(164)] = 3643,
  [SMALL_STATE(165)] = 3653,
  [SMALL_STATE(166)] = 3663,
  [SMALL_STATE(167)] = 3673,
  [SMALL_STATE(168)] = 3683,
  [SMALL_STATE(169)] = 3693,
  [SMALL_STATE(170)] = 3703,
  [SMALL_STATE(171)] = 3713,
  [SMALL_STATE(172)] = 3723,
  [SMALL_STATE(173)] = 3733,
  [SMALL_STATE(174)] = 3741,
  [SMALL_STATE(175)] = 3751,
  [SMALL_STATE(176)] = 3759,
  [SMALL_STATE(177)] = 3767,
  [SMALL_STATE(178)] = 3775,
  [SMALL_STATE(179)] = 3783,
  [SMALL_STATE(180)] = 3793,
  [SMALL_STATE(181)] = 3803,
  [SMALL_STATE(182)] = 3813,
  [SMALL_STATE(183)] = 3823,
  [SMALL_STATE(184)] = 3833,
  [SMALL_STATE(185)] = 3840,
  [SMALL_STATE(186)] = 3847,
  [SMALL_STATE(187)] = 3854,
  [SMALL_STATE(188)] = 3861,
  [SMALL_STATE(189)] = 3868,
  [SMALL_STATE(190)] = 3875,
  [SMALL_STATE(191)] = 3882,
  [SMALL_STATE(192)] = 3889,
  [SMALL_STATE(193)] = 3896,
  [SMALL_STATE(194)] = 3903,
  [SMALL_STATE(195)] = 3910,
  [SMALL_STATE(196)] = 3917,
  [SMALL_STATE(197)] = 3924,
  [SMALL_STATE(198)] = 3931,
  [SMALL_STATE(199)] = 3938,
  [SMALL_STATE(200)] = 3945,
  [SMALL_STATE(201)] = 3952,
  [SMALL_STATE(202)] = 3959,
  [SMALL_STATE(203)] = 3966,
  [SMALL_STATE(204)] = 3973,
  [SMALL_STATE(205)] = 3980,
  [SMALL_STATE(206)] = 3987,
  [SMALL_STATE(207)] = 3994,
  [SMALL_STATE(208)] = 4001,
  [SMALL_STATE(209)] = 4008,
  [SMALL_STATE(210)] = 4015,
  [SMALL_STATE(211)] = 4022,
  [SMALL_STATE(212)] = 4029,
  [SMALL_STATE(213)] = 4036,
  [SMALL_STATE(214)] = 4043,
  [SMALL_STATE(215)] = 4050,
  [SMALL_STATE(216)] = 4057,
  [SMALL_STATE(217)] = 4064,
  [SMALL_STATE(218)] = 4071,
  [SMALL_STATE(219)] = 4078,
  [SMALL_STATE(220)] = 4085,
  [SMALL_STATE(221)] = 4092,
  [SMALL_STATE(222)] = 4099,
  [SMALL_STATE(223)] = 4106,
  [SMALL_STATE(224)] = 4113,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_description, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [49] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_description_repeat1, 2),
  [51] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_description_repeat1, 2), SHIFT_REPEAT(43),
  [54] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_description_repeat1, 2), SHIFT_REPEAT(123),
  [57] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_description_repeat1, 2), SHIFT_REPEAT(183),
  [60] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_description_repeat1, 2), SHIFT_REPEAT(217),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_description, 1),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__declared_identifier, 1),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 1),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 1),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(149),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_element_body_repeat1, 2), SHIFT_REPEAT(34),
  [94] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_element_body_repeat1, 2), SHIFT_REPEAT(182),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_element_body_repeat1, 2), SHIFT_REPEAT(218),
  [100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_element_body_repeat1, 2),
  [102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_qualified_identifier, 3),
  [110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_qualified_identifier, 3),
  [112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_operation, 3),
  [118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_operation, 3),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [124] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 5),
  [134] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 5),
  [136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_operation, 2),
  [142] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_operation, 2),
  [144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 4),
  [146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 4),
  [148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 3),
  [150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 3),
  [152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call, 4),
  [154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call, 4),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [162] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_type_definition, 4),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_type_definition, 4),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_anonymous_instantiation, 3),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_anonymous_instantiation, 3),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_definitive_instantiation, 7),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_definitive_instantiation, 7),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_definitive_instantiation, 4),
  [186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_definitive_instantiation, 4),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_definitive_instantiation, 3),
  [190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_definitive_instantiation, 3),
  [192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_type_definition, 6),
  [194] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_type_definition, 6),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_type_definition, 5),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_type_definition, 5),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_definitive_instantiation, 6),
  [202] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_definitive_instantiation, 6),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_anonymous_instantiation, 6),
  [206] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_anonymous_instantiation, 6),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_import_statement, 4),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_import_statement, 4),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multi_import_statement, 5),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multi_import_statement, 5),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multi_import_statement_repeat1, 2), SHIFT_REPEAT(165),
  [229] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multi_import_statement_repeat1, 2), SHIFT_REPEAT(190),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_multi_import_statement_repeat1, 2),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multi_constant_definition, 5),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multi_constant_definition, 5),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_body, 4),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_body, 4),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_constant_definition, 5),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_constant_definition, 5),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_import_statement, 3),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_single_import_statement, 3),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property_assignment, 4),
  [252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_assignment, 4),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_call_repeat1, 2), SHIFT_REPEAT(15),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_call_repeat1, 2),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expressions, 2),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expressions, 1),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_list, 3),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_list, 2),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_multi_import_statement_repeat1, 3),
  [299] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2), SHIFT_REPEAT(5),
  [302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameters, 1),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter, 1),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameters, 2),
  [318] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__parameters_repeat1, 2), SHIFT_REPEAT(181),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__parameters_repeat1, 2),
  [323] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multi_constant_definition_repeat1, 2), SHIFT_REPEAT(199),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_multi_constant_definition_repeat1, 2),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__arguments, 1),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__arguments, 2),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_multi_constant_definition_repeat1, 4),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter, 3),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__argument, 3),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [382] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [422] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_type, 1),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [438] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [450] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_fbdl_external_scanner_create(void);
void tree_sitter_fbdl_external_scanner_destroy(void *);
bool tree_sitter_fbdl_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_fbdl_external_scanner_serialize(void *, char *);
void tree_sitter_fbdl_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_fbdl(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_fbdl_external_scanner_create,
      tree_sitter_fbdl_external_scanner_destroy,
      tree_sitter_fbdl_external_scanner_scan,
      tree_sitter_fbdl_external_scanner_serialize,
      tree_sitter_fbdl_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
