/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.router;

import io.ray.api.BaseActorHandle;
import io.ray.api.ObjectRef;
import io.ray.runtime.metric.Count;
import io.ray.runtime.metric.Metrics;
import io.ray.serve.generated.RequestMetadata;
import io.ray.serve.metrics.RayServeMetrics;
import io.ray.serve.poll.KeyListener;
import io.ray.serve.poll.KeyType;
import io.ray.serve.poll.LongPollClient;
import io.ray.serve.poll.LongPollNamespace;
import io.ray.serve.router.Query;
import io.ray.serve.router.ReplicaSet;
import io.ray.shaded.com.google.common.collect.ImmutableMap;
import java.util.HashMap;

public class Router {
    private ReplicaSet replicaSet;
    private Count numRouterRequests;
    private LongPollClient longPollClient;

    public Router(BaseActorHandle controllerHandle, String deploymentName) {
        this.replicaSet = new ReplicaSet(deploymentName);
        RayServeMetrics.execute(() -> {
            this.numRouterRequests = (Count)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)((Metrics.CountBuilder)Metrics.count().name(RayServeMetrics.SERVE_NUM_ROUTER_REQUESTS.getName())).description(RayServeMetrics.SERVE_NUM_ROUTER_REQUESTS.getDescription())).unit("")).tags(ImmutableMap.of("deployment", deploymentName))).register();
        });
        HashMap<KeyType, KeyListener> keyListeners = new HashMap<KeyType, KeyListener>();
        keyListeners.put(new KeyType(LongPollNamespace.RUNNING_REPLICAS, deploymentName), workerReplicas -> this.replicaSet.updateWorkerReplicas(workerReplicas));
        this.longPollClient = new LongPollClient(controllerHandle, keyListeners);
    }

    public ObjectRef<Object> assignRequest(RequestMetadata requestMetadata, Object[] requestArgs) {
        RayServeMetrics.execute(() -> this.numRouterRequests.inc(1.0));
        return this.replicaSet.assignReplica(new Query(requestMetadata, requestArgs));
    }

    public ReplicaSet getReplicaSet() {
        return this.replicaSet;
    }

    public LongPollClient getLongPollClient() {
        return this.longPollClient;
    }
}

