"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
// import * as ec2 from '@aws-cdk/aws-ec2';
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test with new resourcesfor aws-lambda-elasticachememcached';
const testVpc = core_1.getTestVpc(stack, false);
// const testSG = new ec2.SecurityGroup(stack, 'test-sg', {
//   vpc: testVpc,
// });
// addCfnSuppressRules(testSG, [{ id: "W40", reason: "Test Resource" }]);
// addCfnSuppressRules(testSG, [{ id: "W5", reason: "Test Resource" }]);
// addCfnSuppressRules(testSG, [{ id: "W36", reason: "Test Resource" }]);
const testSG = core_1.buildSecurityGroup(stack, 'test-sg', { vpc: testVpc }, [], []);
const testFunction = new lambda.Function(stack, 'test-function', {
    runtime: lambda.Runtime.NODEJS_14_X,
    handler: 'index.handler',
    code: lambda.Code.fromAsset(`${__dirname}/lambda`),
    vpc: testVpc,
    securityGroups: [testSG],
});
core_1.addCfnSuppressRules(testFunction, [{ id: "W58", reason: "Test Resource" }]);
core_1.addCfnSuppressRules(testFunction, [{ id: "W92", reason: "Test Resource" }]);
const testCache = core_1.CreateTestCache(stack, 'test-cache', testVpc);
// Definitions
const props = {
    existingVpc: testVpc,
    existingLambdaObj: testFunction,
    existingCache: testCache,
};
new lib_1.LambdaToElasticachememcached(stack, 'test', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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