/*
 * hddm_s++.cpp - DO NOT EDIT THIS FILE
 *
 * This file was generated automatically by hddm-cpp from the file
 * event.xml

 * This c++ source implements the methods for the classes 
 * described in the data model (from event.xml). 
 *
 * The hddm data model tool set was written by
 * Richard Jones, University of Connecticut.
 *
 * For more information see the documentation at
 * http://github.com/rjones30/HDDM
 */

#include <sstream>
#include "hddm_s.hpp"

#ifndef _FILE_OFFSET_BITS
# define _FILE_OFFSET_BITS 64
# define _LARGEFILE64_SOURCE 1
#endif

using namespace hddm_s;

std::atomic<int> threads::next_unique_ID(0);
thread_local int threads::ID(0);

static int tags_match(const std::string &a, const std::string &b)
{
   if (a == b) {
      return true;
   }
   else if (a.find("<HDDM ") == 0 && b.find("<HDDM ") == 0) {
      return true;
   }
   else {
      size_t len = a.length();
      int ia=0;
      int ib=0;
      for (; a[ia] == b[ib]; ++ia, ++ib, --len) {}
      for (; a[ia] == ' '; ++ia, --len) {}
      for (; a[ia] == '/'; ++ia, --len) {}
      for (; b[ib] == ' '; ++ib) {}
      for (; b[ib] == '/'; ++ib) {}
      return (a.substr(ia) == b.substr(ib));
   }
}

std::string Geometry::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "geometry"
        << " md5reconstruction=" << "\"" << m_md5reconstruction << "\""
        << " md5simulation=" << "\"" << m_md5simulation << "\""
        << " md5smear=" << "\"" << m_md5smear << "\""
             << std::endl;
   return ostr.str();
}

std::string Geometry::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<geometry"
        << " md5reconstruction=" << "\"" << getMd5reconstruction() << "\""
        << " md5simulation=" << "\"" << getMd5simulation() << "\""
        << " md5smear=" << "\"" << getMd5smear() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Geometry::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("geometry");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "md5reconstruction", (char*)&mx_md5reconstruction - (char*)this, vl_string_tid);
   H5Tinsert(tid, "md5simulation", (char*)&mx_md5simulation - (char*)this, vl_string_tid);
   H5Tinsert(tid, "md5smear", (char*)&mx_md5smear - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["geometry"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["geometry"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "geometry", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "geometry", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Geometry::hdf5DataPack()
{
   mx_md5reconstruction = m_md5reconstruction.c_str();
   mx_md5simulation = m_md5simulation.c_str();
   mx_md5smear = m_md5smear.c_str();
}
void Geometry::hdf5DataUnpack()
{
   new(&m_md5reconstruction) std::string();
   if (mx_md5reconstruction != 0) {
      m_md5reconstruction = mx_md5reconstruction;
      m_host->m_hdf5_strings.push_back(&m_md5reconstruction);
   }
   new(&m_md5simulation) std::string();
   if (mx_md5simulation != 0) {
      m_md5simulation = mx_md5simulation;
      m_host->m_hdf5_strings.push_back(&m_md5simulation);
   }
   new(&m_md5smear) std::string();
   if (mx_md5smear != 0) {
      m_md5smear = mx_md5smear;
      m_host->m_hdf5_strings.push_back(&m_md5smear);
   }
}
#endif

std::string DataVersionString::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dataVersionString"
        << " text=" << "\"" << m_text << "\""
             << std::endl;
   return ostr.str();
}

std::string DataVersionString::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dataVersionString"
        << " text=" << "\"" << getText() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DataVersionString::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dataVersionString");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "text", (char*)&mx_text - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dataVersionString"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dataVersionString"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dataVersionString", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dataVersionString", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DataVersionString::hdf5DataPack()
{
   mx_text = m_text.c_str();
}
void DataVersionString::hdf5DataUnpack()
{
   new(&m_text) std::string();
   if (mx_text != 0) {
      m_text = mx_text;
      m_host->m_hdf5_strings.push_back(&m_text);
   }
}
#endif

std::string CcdbContext::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccdbContext"
        << " text=" << "\"" << m_text << "\""
             << std::endl;
   return ostr.str();
}

std::string CcdbContext::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccdbContext"
        << " text=" << "\"" << getText() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcdbContext::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccdbContext");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "text", (char*)&mx_text - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccdbContext"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccdbContext"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccdbContext", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccdbContext", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcdbContext::hdf5DataPack()
{
   mx_text = m_text.c_str();
}
void CcdbContext::hdf5DataUnpack()
{
   new(&m_text) std::string();
   if (mx_text != 0) {
      m_text = mx_text;
      m_host->m_hdf5_strings.push_back(&m_text);
   }
}
#endif

std::string Momentum::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "momentum"
        << " E=" << m_E
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
             << std::endl;
   return ostr.str();
}

std::string Momentum::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<momentum"
        << " E=" << "\"" << getE() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Momentum::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("momentum");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["momentum"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["momentum"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "momentum", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "momentum", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Momentum::hdf5DataPack()
{
}
void Momentum::hdf5DataUnpack()
{
}
#endif

std::string Polarization::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "polarization"
        << " Px=" << m_Px
        << " Py=" << m_Py
        << " Pz=" << m_Pz
             << std::endl;
   return ostr.str();
}

std::string Polarization::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<polarization"
        << " Px=" << "\"" << getPx() << "\""
        << " Py=" << "\"" << getPy() << "\""
        << " Pz=" << "\"" << getPz() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Polarization::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("polarization");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "Px", (char*)&m_Px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Py", (char*)&m_Py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Pz", (char*)&m_Pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["polarization"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["polarization"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "polarization", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "polarization", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Polarization::hdf5DataPack()
{
}
void Polarization::hdf5DataUnpack()
{
}
#endif

std::string Properties::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "properties"
        << " charge=" << m_charge
        << " mass=" << m_mass
             << std::endl;
   return ostr.str();
}

std::string Properties::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<properties"
        << " charge=" << "\"" << getCharge() << "\""
        << " mass=" << "\"" << getMass() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Properties::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("properties");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "charge", (char*)&m_charge - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "mass", (char*)&m_mass - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["properties"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["properties"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "properties", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "properties", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Properties::hdf5DataPack()
{
}
void Properties::hdf5DataUnpack()
{
}
#endif

std::string Beam::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "beam"
        << " type=" << ParticleType((Particle_t)m_type)
             << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toString(indent + 2);
   }
   if (! m_polarization_link.empty()) {
      ostr << m_polarization_link.begin()->toString(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string Beam::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<beam"
        << " type=\"" << ParticleType((Particle_t)m_type) << "\""
        << ">" << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toXML(indent + 2);
   }
   if (! m_polarization_link.empty()) {
      ostr << m_polarization_link.begin()->toXML(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</beam>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Beam::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("beam");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "type", (char*)&m_type - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "MomentumList_size", (char*)&m_momentum_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "MomentumList_offset", (char*)&m_momentum_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PolarizationList_size", (char*)&m_polarization_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PolarizationList_offset", (char*)&m_polarization_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_size", (char*)&m_properties_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_offset", (char*)&m_properties_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["beam"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["beam"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "beam", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "beam", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Beam::hdf5DataPack()
{
   m_momentum_link.deflate();
   m_polarization_link.deflate();
   m_properties_link.deflate();
}
void Beam::hdf5DataUnpack()
{
   {
      std::list<Momentum*> *host_plist = &m_host->m_momentum_plist;
      m_momentum_link.inflate(m_host, host_plist, this);
      MomentumList::iterator iter;
      for (iter = m_momentum_link.begin();
           iter != m_momentum_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Polarization*> *host_plist = &m_host->m_polarization_plist;
      m_polarization_link.inflate(m_host, host_plist, this);
      PolarizationList::iterator iter;
      for (iter = m_polarization_link.begin();
           iter != m_polarization_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Properties*> *host_plist = &m_host->m_properties_plist;
      m_properties_link.inflate(m_host, host_plist, this);
      PropertiesList::iterator iter;
      for (iter = m_properties_link.begin();
           iter != m_properties_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Target::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "target"
        << " type=" << ParticleType((Particle_t)m_type)
             << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toString(indent + 2);
   }
   if (! m_polarization_link.empty()) {
      ostr << m_polarization_link.begin()->toString(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string Target::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<target"
        << " type=\"" << ParticleType((Particle_t)m_type) << "\""
        << ">" << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toXML(indent + 2);
   }
   if (! m_polarization_link.empty()) {
      ostr << m_polarization_link.begin()->toXML(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</target>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Target::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("target");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "type", (char*)&m_type - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "MomentumList_size", (char*)&m_momentum_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "MomentumList_offset", (char*)&m_momentum_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PolarizationList_size", (char*)&m_polarization_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PolarizationList_offset", (char*)&m_polarization_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_size", (char*)&m_properties_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_offset", (char*)&m_properties_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["target"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["target"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "target", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "target", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Target::hdf5DataPack()
{
   m_momentum_link.deflate();
   m_polarization_link.deflate();
   m_properties_link.deflate();
}
void Target::hdf5DataUnpack()
{
   {
      std::list<Momentum*> *host_plist = &m_host->m_momentum_plist;
      m_momentum_link.inflate(m_host, host_plist, this);
      MomentumList::iterator iter;
      for (iter = m_momentum_link.begin();
           iter != m_momentum_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Polarization*> *host_plist = &m_host->m_polarization_plist;
      m_polarization_link.inflate(m_host, host_plist, this);
      PolarizationList::iterator iter;
      for (iter = m_polarization_link.begin();
           iter != m_polarization_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Properties*> *host_plist = &m_host->m_properties_plist;
      m_properties_link.inflate(m_host, host_plist, this);
      PropertiesList::iterator iter;
      for (iter = m_properties_link.begin();
           iter != m_properties_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Product::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "product"
        << " decayVertex=" << m_decayVertex
        << " id=" << m_id
        << " mech=" << m_mech
        << " parentid=" << m_parentid
        << " pdgtype=" << m_pdgtype
        << " type=" << ParticleType((Particle_t)m_type)
             << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toString(indent + 2);
   }
   if (! m_polarization_link.empty()) {
      ostr << m_polarization_link.begin()->toString(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string Product::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<product"
        << " decayVertex=" << "\"" << getDecayVertex() << "\""
        << " id=" << "\"" << getId() << "\""
        << " mech=" << "\"" << getMech() << "\""
        << " parentid=" << "\"" << getParentid() << "\""
        << " pdgtype=" << "\"" << getPdgtype() << "\""
        << " type=\"" << ParticleType((Particle_t)m_type) << "\""
        << ">" << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toXML(indent + 2);
   }
   if (! m_polarization_link.empty()) {
      ostr << m_polarization_link.begin()->toXML(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</product>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Product::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("product");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "decayVertex", (char*)&m_decayVertex - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "id", (char*)&m_id - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "mech", (char*)&m_mech - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "parentid", (char*)&m_parentid - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "pdgtype", (char*)&m_pdgtype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "type", (char*)&m_type - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "MomentumList_size", (char*)&m_momentum_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "MomentumList_offset", (char*)&m_momentum_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PolarizationList_size", (char*)&m_polarization_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PolarizationList_offset", (char*)&m_polarization_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_size", (char*)&m_properties_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_offset", (char*)&m_properties_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["product"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["product"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "product", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "product", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Product::hdf5DataPack()
{
   m_momentum_link.deflate();
   m_polarization_link.deflate();
   m_properties_link.deflate();
}
void Product::hdf5DataUnpack()
{
   {
      std::list<Momentum*> *host_plist = &m_host->m_momentum_plist;
      m_momentum_link.inflate(m_host, host_plist, this);
      MomentumList::iterator iter;
      for (iter = m_momentum_link.begin();
           iter != m_momentum_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Polarization*> *host_plist = &m_host->m_polarization_plist;
      m_polarization_link.inflate(m_host, host_plist, this);
      PolarizationList::iterator iter;
      for (iter = m_polarization_link.begin();
           iter != m_polarization_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Properties*> *host_plist = &m_host->m_properties_plist;
      m_properties_link.inflate(m_host, host_plist, this);
      PropertiesList::iterator iter;
      for (iter = m_properties_link.begin();
           iter != m_properties_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Origin::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "origin"
        << " t=" << m_t
        << " vx=" << m_vx
        << " vy=" << m_vy
        << " vz=" << m_vz
             << std::endl;
   return ostr.str();
}

std::string Origin::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<origin"
        << " t=" << "\"" << getT() << "\""
        << " vx=" << "\"" << getVx() << "\""
        << " vy=" << "\"" << getVy() << "\""
        << " vz=" << "\"" << getVz() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Origin::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("origin");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "vx", (char*)&m_vx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "vy", (char*)&m_vy - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "vz", (char*)&m_vz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["origin"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["origin"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "origin", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "origin", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Origin::hdf5DataPack()
{
}
void Origin::hdf5DataUnpack()
{
}
#endif

std::string Vertex::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "vertex"
             << std::endl;
   int ProductListCount=0;
   for (ProductList::iterator it = m_product_list.begin();
        it != m_product_list.end(); ++it)
   {
      if (++ProductListCount > m_product_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   if (! m_origin_link.empty()) {
      ostr << m_origin_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string Vertex::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<vertex"
        << ">" << std::endl;
   int ProductListCount=0;
   for (ProductList::iterator it = m_product_list.begin();
        it != m_product_list.end(); ++it)
   {
      if (++ProductListCount > m_product_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   if (! m_origin_link.empty()) {
      ostr << m_origin_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</vertex>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Vertex::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("vertex");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "ProductList_size", (char*)&m_product_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ProductList_offset", (char*)&m_product_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "OriginList_size", (char*)&m_origin_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "OriginList_offset", (char*)&m_origin_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["vertex"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["vertex"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "vertex", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "vertex", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Vertex::hdf5DataPack()
{
   m_product_list.deflate();
   m_origin_link.deflate();
}
void Vertex::hdf5DataUnpack()
{
   {
      std::list<Product*> *host_plist = &m_host->m_product_plist;
      m_product_list.inflate(m_host, host_plist, this);
      ProductList::iterator iter;
      for (iter = m_product_list.begin();
           iter != m_product_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Origin*> *host_plist = &m_host->m_origin_plist;
      m_origin_link.inflate(m_host, host_plist, this);
      OriginList::iterator iter;
      for (iter = m_origin_link.begin();
           iter != m_origin_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Random::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "random"
        << " seed1=" << m_seed1
        << " seed2=" << m_seed2
        << " seed3=" << m_seed3
        << " seed4=" << m_seed4
             << std::endl;
   return ostr.str();
}

std::string Random::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<random"
        << " seed1=" << "\"" << getSeed1() << "\""
        << " seed2=" << "\"" << getSeed2() << "\""
        << " seed3=" << "\"" << getSeed3() << "\""
        << " seed4=" << "\"" << getSeed4() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Random::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("random");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "seed1", (char*)&m_seed1 - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "seed2", (char*)&m_seed2 - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "seed3", (char*)&m_seed3 - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "seed4", (char*)&m_seed4 - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["random"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["random"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "random", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "random", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Random::hdf5DataPack()
{
}
void Random::hdf5DataUnpack()
{
}
#endif

std::string UserDataFloat::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "userDataFloat"
        << " data=" << m_data
        << " meaning=" << "\"" << m_meaning << "\""
             << std::endl;
   return ostr.str();
}

std::string UserDataFloat::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<userDataFloat"
        << " data=" << "\"" << getData() << "\""
        << " meaning=" << "\"" << getMeaning() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UserDataFloat::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("userDataFloat");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "data", (char*)&m_data - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "meaning", (char*)&mx_meaning - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["userDataFloat"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["userDataFloat"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "userDataFloat", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "userDataFloat", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UserDataFloat::hdf5DataPack()
{
   mx_meaning = m_meaning.c_str();
}
void UserDataFloat::hdf5DataUnpack()
{
   new(&m_meaning) std::string();
   if (mx_meaning != 0) {
      m_meaning = mx_meaning;
      m_host->m_hdf5_strings.push_back(&m_meaning);
   }
}
#endif

std::string UserDataInt::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "userDataInt"
        << " data=" << m_data
        << " meaning=" << "\"" << m_meaning << "\""
             << std::endl;
   return ostr.str();
}

std::string UserDataInt::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<userDataInt"
        << " data=" << "\"" << getData() << "\""
        << " meaning=" << "\"" << getMeaning() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UserDataInt::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("userDataInt");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "data", (char*)&m_data - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "meaning", (char*)&mx_meaning - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["userDataInt"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["userDataInt"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "userDataInt", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "userDataInt", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UserDataInt::hdf5DataPack()
{
   mx_meaning = m_meaning.c_str();
}
void UserDataInt::hdf5DataUnpack()
{
   new(&m_meaning) std::string();
   if (mx_meaning != 0) {
      m_meaning = mx_meaning;
      m_host->m_hdf5_strings.push_back(&m_meaning);
   }
}
#endif

std::string UserData::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "userData"
        << " description=" << "\"" << m_description << "\""
             << std::endl;
   int UserDataFloatListCount=0;
   for (UserDataFloatList::iterator it = m_userDataFloat_list.begin();
        it != m_userDataFloat_list.end(); ++it)
   {
      if (++UserDataFloatListCount > m_userDataFloat_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int UserDataIntListCount=0;
   for (UserDataIntList::iterator it = m_userDataInt_list.begin();
        it != m_userDataInt_list.end(); ++it)
   {
      if (++UserDataIntListCount > m_userDataInt_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string UserData::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<userData"
        << " description=" << "\"" << getDescription() << "\""
        << ">" << std::endl;
   int UserDataFloatListCount=0;
   for (UserDataFloatList::iterator it = m_userDataFloat_list.begin();
        it != m_userDataFloat_list.end(); ++it)
   {
      if (++UserDataFloatListCount > m_userDataFloat_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int UserDataIntListCount=0;
   for (UserDataIntList::iterator it = m_userDataInt_list.begin();
        it != m_userDataInt_list.end(); ++it)
   {
      if (++UserDataIntListCount > m_userDataInt_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</userData>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UserData::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("userData");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "description", (char*)&mx_description - (char*)this, vl_string_tid);
   H5Tinsert(tid, "UserDataFloatList_size", (char*)&m_userDataFloat_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UserDataFloatList_offset", (char*)&m_userDataFloat_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UserDataIntList_size", (char*)&m_userDataInt_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UserDataIntList_offset", (char*)&m_userDataInt_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["userData"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["userData"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "userData", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "userData", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UserData::hdf5DataPack()
{
   mx_description = m_description.c_str();
   m_userDataFloat_list.deflate();
   m_userDataInt_list.deflate();
}
void UserData::hdf5DataUnpack()
{
   new(&m_description) std::string();
   if (mx_description != 0) {
      m_description = mx_description;
      m_host->m_hdf5_strings.push_back(&m_description);
   }
   {
      std::list<UserDataFloat*> *host_plist = &m_host->m_userDataFloat_plist;
      m_userDataFloat_list.inflate(m_host, host_plist, this);
      UserDataFloatList::iterator iter;
      for (iter = m_userDataFloat_list.begin();
           iter != m_userDataFloat_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<UserDataInt*> *host_plist = &m_host->m_userDataInt_plist;
      m_userDataInt_list.inflate(m_host, host_plist, this);
      UserDataIntList::iterator iter;
      for (iter = m_userDataInt_list.begin();
           iter != m_userDataInt_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Reaction::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "reaction"
        << " type=" << m_type
        << " weight=" << m_weight
             << std::endl;
   if (! m_beam_link.empty()) {
      ostr << m_beam_link.begin()->toString(indent + 2);
   }
   if (! m_target_link.empty()) {
      ostr << m_target_link.begin()->toString(indent + 2);
   }
   int VertexListCount=0;
   for (VertexList::iterator it = m_vertex_list.begin();
        it != m_vertex_list.end(); ++it)
   {
      if (++VertexListCount > m_vertex_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   if (! m_random_link.empty()) {
      ostr << m_random_link.begin()->toString(indent + 2);
   }
   int UserDataListCount=0;
   for (UserDataList::iterator it = m_userData_list.begin();
        it != m_userData_list.end(); ++it)
   {
      if (++UserDataListCount > m_userData_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string Reaction::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<reaction"
        << " type=" << "\"" << getType() << "\""
        << " weight=" << "\"" << getWeight() << "\""
        << ">" << std::endl;
   if (! m_beam_link.empty()) {
      ostr << m_beam_link.begin()->toXML(indent + 2);
   }
   if (! m_target_link.empty()) {
      ostr << m_target_link.begin()->toXML(indent + 2);
   }
   int VertexListCount=0;
   for (VertexList::iterator it = m_vertex_list.begin();
        it != m_vertex_list.end(); ++it)
   {
      if (++VertexListCount > m_vertex_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   if (! m_random_link.empty()) {
      ostr << m_random_link.begin()->toXML(indent + 2);
   }
   int UserDataListCount=0;
   for (UserDataList::iterator it = m_userData_list.begin();
        it != m_userData_list.end(); ++it)
   {
      if (++UserDataListCount > m_userData_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</reaction>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Reaction::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("reaction");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "type", (char*)&m_type - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "weight", (char*)&m_weight - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "BeamList_size", (char*)&m_beam_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BeamList_offset", (char*)&m_beam_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TargetList_size", (char*)&m_target_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TargetList_offset", (char*)&m_target_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "VertexList_size", (char*)&m_vertex_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "VertexList_offset", (char*)&m_vertex_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RandomList_size", (char*)&m_random_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RandomList_offset", (char*)&m_random_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UserDataList_size", (char*)&m_userData_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UserDataList_offset", (char*)&m_userData_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["reaction"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["reaction"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "reaction", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "reaction", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Reaction::hdf5DataPack()
{
   m_beam_link.deflate();
   m_target_link.deflate();
   m_vertex_list.deflate();
   m_random_link.deflate();
   m_userData_list.deflate();
}
void Reaction::hdf5DataUnpack()
{
   {
      std::list<Beam*> *host_plist = &m_host->m_beam_plist;
      m_beam_link.inflate(m_host, host_plist, this);
      BeamList::iterator iter;
      for (iter = m_beam_link.begin();
           iter != m_beam_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Target*> *host_plist = &m_host->m_target_plist;
      m_target_link.inflate(m_host, host_plist, this);
      TargetList::iterator iter;
      for (iter = m_target_link.begin();
           iter != m_target_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Vertex*> *host_plist = &m_host->m_vertex_plist;
      m_vertex_list.inflate(m_host, host_plist, this);
      VertexList::iterator iter;
      for (iter = m_vertex_list.begin();
           iter != m_vertex_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Random*> *host_plist = &m_host->m_random_plist;
      m_random_link.inflate(m_host, host_plist, this);
      RandomList::iterator iter;
      for (iter = m_random_link.begin();
           iter != m_random_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<UserData*> *host_plist = &m_host->m_userData_plist;
      m_userData_list.inflate(m_host, host_plist, this);
      UserDataList::iterator iter;
      for (iter = m_userData_list.begin();
           iter != m_userData_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CdcDigihit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cdcDigihit"
        << " peakAmp=" << m_peakAmp
             << std::endl;
   return ostr.str();
}

std::string CdcDigihit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cdcDigihit"
        << " peakAmp=" << "\"" << getPeakAmp() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CdcDigihit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cdcDigihit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "peakAmp", (char*)&m_peakAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cdcDigihit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cdcDigihit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cdcDigihit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cdcDigihit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CdcDigihit::hdf5DataPack()
{
}
void CdcDigihit::hdf5DataUnpack()
{
}
#endif

std::string CdcHitQF::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cdcHitQF"
        << " QF=" << m_QF
             << std::endl;
   return ostr.str();
}

std::string CdcHitQF::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cdcHitQF"
        << " QF=" << "\"" << getQF() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CdcHitQF::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cdcHitQF");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "QF", (char*)&m_QF - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cdcHitQF"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cdcHitQF"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cdcHitQF", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cdcHitQF", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CdcHitQF::hdf5DataPack()
{
}
void CdcHitQF::hdf5DataUnpack()
{
}
#endif

std::string CdcStrawHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cdcStrawHit"
        << " q=" << m_q
        << " t=" << m_t
             << std::endl;
   if (! m_cdcDigihit_link.empty()) {
      ostr << m_cdcDigihit_link.begin()->toString(indent + 2);
   }
   if (! m_cdcHitQF_link.empty()) {
      ostr << m_cdcHitQF_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string CdcStrawHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cdcStrawHit"
        << " q=" << "\"" << getQ() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   if (! m_cdcDigihit_link.empty()) {
      ostr << m_cdcDigihit_link.begin()->toXML(indent + 2);
   }
   if (! m_cdcHitQF_link.empty()) {
      ostr << m_cdcHitQF_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</cdcStrawHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CdcStrawHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cdcStrawHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "q", (char*)&m_q - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "CdcDigihitList_size", (char*)&m_cdcDigihit_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcDigihitList_offset", (char*)&m_cdcDigihit_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcHitQFList_size", (char*)&m_cdcHitQF_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcHitQFList_offset", (char*)&m_cdcHitQF_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cdcStrawHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cdcStrawHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStrawHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStrawHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CdcStrawHit::hdf5DataPack()
{
   m_cdcDigihit_link.deflate();
   m_cdcHitQF_link.deflate();
}
void CdcStrawHit::hdf5DataUnpack()
{
   {
      std::list<CdcDigihit*> *host_plist = &m_host->m_cdcDigihit_plist;
      m_cdcDigihit_link.inflate(m_host, host_plist, this);
      CdcDigihitList::iterator iter;
      for (iter = m_cdcDigihit_link.begin();
           iter != m_cdcDigihit_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CdcHitQF*> *host_plist = &m_host->m_cdcHitQF_plist;
      m_cdcHitQF_link.inflate(m_host, host_plist, this);
      CdcHitQFList::iterator iter;
      for (iter = m_cdcHitQF_link.begin();
           iter != m_cdcHitQF_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CdcStrawTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cdcStrawTruthHit"
        << " d=" << m_d
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " q=" << m_q
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string CdcStrawTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cdcStrawTruthHit"
        << " d=" << "\"" << getD() << "\""
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " q=" << "\"" << getQ() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CdcStrawTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cdcStrawTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "d", (char*)&m_d - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "q", (char*)&m_q - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cdcStrawTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cdcStrawTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStrawTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStrawTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CdcStrawTruthHit::hdf5DataPack()
{
}
void CdcStrawTruthHit::hdf5DataUnpack()
{
}
#endif

std::string CdcStraw::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cdcStraw"
        << " ring=" << m_ring
        << " straw=" << m_straw
             << std::endl;
   int CdcStrawHitListCount=0;
   for (CdcStrawHitList::iterator it = m_cdcStrawHit_list.begin();
        it != m_cdcStrawHit_list.end(); ++it)
   {
      if (++CdcStrawHitListCount > m_cdcStrawHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CdcStrawTruthHitListCount=0;
   for (CdcStrawTruthHitList::iterator it = m_cdcStrawTruthHit_list.begin();
        it != m_cdcStrawTruthHit_list.end(); ++it)
   {
      if (++CdcStrawTruthHitListCount > m_cdcStrawTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string CdcStraw::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cdcStraw"
        << " ring=" << "\"" << getRing() << "\""
        << " straw=" << "\"" << getStraw() << "\""
        << ">" << std::endl;
   int CdcStrawHitListCount=0;
   for (CdcStrawHitList::iterator it = m_cdcStrawHit_list.begin();
        it != m_cdcStrawHit_list.end(); ++it)
   {
      if (++CdcStrawHitListCount > m_cdcStrawHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CdcStrawTruthHitListCount=0;
   for (CdcStrawTruthHitList::iterator it = m_cdcStrawTruthHit_list.begin();
        it != m_cdcStrawTruthHit_list.end(); ++it)
   {
      if (++CdcStrawTruthHitListCount > m_cdcStrawTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</cdcStraw>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CdcStraw::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cdcStraw");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "ring", (char*)&m_ring - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "straw", (char*)&m_straw - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "CdcStrawHitList_size", (char*)&m_cdcStrawHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcStrawHitList_offset", (char*)&m_cdcStrawHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcStrawTruthHitList_size", (char*)&m_cdcStrawTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcStrawTruthHitList_offset", (char*)&m_cdcStrawTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cdcStraw"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cdcStraw"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStraw", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cdcStraw", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CdcStraw::hdf5DataPack()
{
   m_cdcStrawHit_list.deflate();
   m_cdcStrawTruthHit_list.deflate();
}
void CdcStraw::hdf5DataUnpack()
{
   {
      std::list<CdcStrawHit*> *host_plist = &m_host->m_cdcStrawHit_plist;
      m_cdcStrawHit_list.inflate(m_host, host_plist, this);
      CdcStrawHitList::iterator iter;
      for (iter = m_cdcStrawHit_list.begin();
           iter != m_cdcStrawHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CdcStrawTruthHit*> *host_plist = &m_host->m_cdcStrawTruthHit_plist;
      m_cdcStrawTruthHit_list.inflate(m_host, host_plist, this);
      CdcStrawTruthHitList::iterator iter;
      for (iter = m_cdcStrawTruthHit_list.begin();
           iter != m_cdcStrawTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TrackID::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "trackID"
        << " itrack=" << m_itrack
             << std::endl;
   return ostr.str();
}

std::string TrackID::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<trackID"
        << " itrack=" << "\"" << getItrack() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TrackID::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("trackID");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["trackID"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["trackID"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "trackID", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "trackID", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TrackID::hdf5DataPack()
{
}
void TrackID::hdf5DataUnpack()
{
}
#endif

std::string CdcTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cdcTruthPoint"
        << " dEdx=" << m_dEdx
        << " dradius=" << m_dradius
        << " phi=" << m_phi
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " r=" << m_r
        << " t=" << m_t
        << " track=" << m_track
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string CdcTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cdcTruthPoint"
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " dradius=" << "\"" << getDradius() << "\""
        << " phi=" << "\"" << getPhi() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " r=" << "\"" << getR() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</cdcTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CdcTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cdcTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dradius", (char*)&m_dradius - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "phi", (char*)&m_phi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "r", (char*)&m_r - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cdcTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cdcTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cdcTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cdcTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CdcTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void CdcTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CentralDC::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "centralDC"
             << std::endl;
   int CdcStrawListCount=0;
   for (CdcStrawList::iterator it = m_cdcStraw_list.begin();
        it != m_cdcStraw_list.end(); ++it)
   {
      if (++CdcStrawListCount > m_cdcStraw_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CdcTruthPointListCount=0;
   for (CdcTruthPointList::iterator it = m_cdcTruthPoint_list.begin();
        it != m_cdcTruthPoint_list.end(); ++it)
   {
      if (++CdcTruthPointListCount > m_cdcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string CentralDC::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<centralDC"
        << ">" << std::endl;
   int CdcStrawListCount=0;
   for (CdcStrawList::iterator it = m_cdcStraw_list.begin();
        it != m_cdcStraw_list.end(); ++it)
   {
      if (++CdcStrawListCount > m_cdcStraw_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CdcTruthPointListCount=0;
   for (CdcTruthPointList::iterator it = m_cdcTruthPoint_list.begin();
        it != m_cdcTruthPoint_list.end(); ++it)
   {
      if (++CdcTruthPointListCount > m_cdcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</centralDC>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CentralDC::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("centralDC");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "CdcStrawList_size", (char*)&m_cdcStraw_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcStrawList_offset", (char*)&m_cdcStraw_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcTruthPointList_size", (char*)&m_cdcTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CdcTruthPointList_offset", (char*)&m_cdcTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["centralDC"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["centralDC"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "centralDC", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "centralDC", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CentralDC::hdf5DataPack()
{
   m_cdcStraw_list.deflate();
   m_cdcTruthPoint_list.deflate();
}
void CentralDC::hdf5DataUnpack()
{
   {
      std::list<CdcStraw*> *host_plist = &m_host->m_cdcStraw_plist;
      m_cdcStraw_list.inflate(m_host, host_plist, this);
      CdcStrawList::iterator iter;
      for (iter = m_cdcStraw_list.begin();
           iter != m_cdcStraw_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CdcTruthPoint*> *host_plist = &m_host->m_cdcTruthPoint_plist;
      m_cdcTruthPoint_list.inflate(m_host, host_plist, this);
      CdcTruthPointList::iterator iter;
      for (iter = m_cdcTruthPoint_list.begin();
           iter != m_cdcTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FdcAnodeHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcAnodeHit"
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string FdcAnodeHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcAnodeHit"
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcAnodeHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcAnodeHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcAnodeHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcAnodeHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcAnodeHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcAnodeHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcAnodeHit::hdf5DataPack()
{
}
void FdcAnodeHit::hdf5DataUnpack()
{
}
#endif

std::string FdcAnodeTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcAnodeTruthHit"
        << " d=" << m_d
        << " dE=" << m_dE
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " t=" << m_t
        << " t_unsmeared=" << m_t_unsmeared
             << std::endl;
   return ostr.str();
}

std::string FdcAnodeTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcAnodeTruthHit"
        << " d=" << "\"" << getD() << "\""
        << " dE=" << "\"" << getDE() << "\""
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " t=" << "\"" << getT() << "\""
        << " t_unsmeared=" << "\"" << getT_unsmeared() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcAnodeTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcAnodeTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "d", (char*)&m_d - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t_unsmeared", (char*)&m_t_unsmeared - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcAnodeTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcAnodeTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcAnodeTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcAnodeTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcAnodeTruthHit::hdf5DataPack()
{
}
void FdcAnodeTruthHit::hdf5DataUnpack()
{
}
#endif

std::string FdcAnodeWire::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcAnodeWire"
        << " wire=" << m_wire
             << std::endl;
   int FdcAnodeHitListCount=0;
   for (FdcAnodeHitList::iterator it = m_fdcAnodeHit_list.begin();
        it != m_fdcAnodeHit_list.end(); ++it)
   {
      if (++FdcAnodeHitListCount > m_fdcAnodeHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FdcAnodeTruthHitListCount=0;
   for (FdcAnodeTruthHitList::iterator it = m_fdcAnodeTruthHit_list.begin();
        it != m_fdcAnodeTruthHit_list.end(); ++it)
   {
      if (++FdcAnodeTruthHitListCount > m_fdcAnodeTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FdcAnodeWire::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcAnodeWire"
        << " wire=" << "\"" << getWire() << "\""
        << ">" << std::endl;
   int FdcAnodeHitListCount=0;
   for (FdcAnodeHitList::iterator it = m_fdcAnodeHit_list.begin();
        it != m_fdcAnodeHit_list.end(); ++it)
   {
      if (++FdcAnodeHitListCount > m_fdcAnodeHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FdcAnodeTruthHitListCount=0;
   for (FdcAnodeTruthHitList::iterator it = m_fdcAnodeTruthHit_list.begin();
        it != m_fdcAnodeTruthHit_list.end(); ++it)
   {
      if (++FdcAnodeTruthHitListCount > m_fdcAnodeTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fdcAnodeWire>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcAnodeWire::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcAnodeWire");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "wire", (char*)&m_wire - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FdcAnodeHitList_size", (char*)&m_fdcAnodeHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcAnodeHitList_offset", (char*)&m_fdcAnodeHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcAnodeTruthHitList_size", (char*)&m_fdcAnodeTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcAnodeTruthHitList_offset", (char*)&m_fdcAnodeTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcAnodeWire"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcAnodeWire"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcAnodeWire", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcAnodeWire", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcAnodeWire::hdf5DataPack()
{
   m_fdcAnodeHit_list.deflate();
   m_fdcAnodeTruthHit_list.deflate();
}
void FdcAnodeWire::hdf5DataUnpack()
{
   {
      std::list<FdcAnodeHit*> *host_plist = &m_host->m_fdcAnodeHit_plist;
      m_fdcAnodeHit_list.inflate(m_host, host_plist, this);
      FdcAnodeHitList::iterator iter;
      for (iter = m_fdcAnodeHit_list.begin();
           iter != m_fdcAnodeHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FdcAnodeTruthHit*> *host_plist = &m_host->m_fdcAnodeTruthHit_plist;
      m_fdcAnodeTruthHit_list.inflate(m_host, host_plist, this);
      FdcAnodeTruthHitList::iterator iter;
      for (iter = m_fdcAnodeTruthHit_list.begin();
           iter != m_fdcAnodeTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FdcDigihit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcDigihit"
        << " peakAmp=" << m_peakAmp
             << std::endl;
   return ostr.str();
}

std::string FdcDigihit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcDigihit"
        << " peakAmp=" << "\"" << getPeakAmp() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcDigihit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcDigihit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "peakAmp", (char*)&m_peakAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcDigihit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcDigihit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcDigihit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcDigihit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcDigihit::hdf5DataPack()
{
}
void FdcDigihit::hdf5DataUnpack()
{
}
#endif

std::string FdcCathodeHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcCathodeHit"
        << " q=" << m_q
        << " t=" << m_t
             << std::endl;
   if (! m_fdcDigihit_link.empty()) {
      ostr << m_fdcDigihit_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FdcCathodeHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcCathodeHit"
        << " q=" << "\"" << getQ() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   if (! m_fdcDigihit_link.empty()) {
      ostr << m_fdcDigihit_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fdcCathodeHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcCathodeHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcCathodeHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "q", (char*)&m_q - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FdcDigihitList_size", (char*)&m_fdcDigihit_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcDigihitList_offset", (char*)&m_fdcDigihit_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcCathodeHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcCathodeHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcCathodeHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcCathodeHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcCathodeHit::hdf5DataPack()
{
   m_fdcDigihit_link.deflate();
}
void FdcCathodeHit::hdf5DataUnpack()
{
   {
      std::list<FdcDigihit*> *host_plist = &m_host->m_fdcDigihit_plist;
      m_fdcDigihit_link.inflate(m_host, host_plist, this);
      FdcDigihitList::iterator iter;
      for (iter = m_fdcDigihit_link.begin();
           iter != m_fdcDigihit_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FdcCathodeTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcCathodeTruthHit"
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " q=" << m_q
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string FdcCathodeTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcCathodeTruthHit"
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " q=" << "\"" << getQ() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcCathodeTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcCathodeTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "q", (char*)&m_q - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcCathodeTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcCathodeTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcCathodeTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcCathodeTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcCathodeTruthHit::hdf5DataPack()
{
}
void FdcCathodeTruthHit::hdf5DataUnpack()
{
}
#endif

std::string FdcCathodeStrip::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcCathodeStrip"
        << " plane=" << m_plane
        << " strip=" << m_strip
             << std::endl;
   int FdcCathodeHitListCount=0;
   for (FdcCathodeHitList::iterator it = m_fdcCathodeHit_list.begin();
        it != m_fdcCathodeHit_list.end(); ++it)
   {
      if (++FdcCathodeHitListCount > m_fdcCathodeHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FdcCathodeTruthHitListCount=0;
   for (FdcCathodeTruthHitList::iterator it = m_fdcCathodeTruthHit_list.begin();
        it != m_fdcCathodeTruthHit_list.end(); ++it)
   {
      if (++FdcCathodeTruthHitListCount > m_fdcCathodeTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FdcCathodeStrip::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcCathodeStrip"
        << " plane=" << "\"" << getPlane() << "\""
        << " strip=" << "\"" << getStrip() << "\""
        << ">" << std::endl;
   int FdcCathodeHitListCount=0;
   for (FdcCathodeHitList::iterator it = m_fdcCathodeHit_list.begin();
        it != m_fdcCathodeHit_list.end(); ++it)
   {
      if (++FdcCathodeHitListCount > m_fdcCathodeHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FdcCathodeTruthHitListCount=0;
   for (FdcCathodeTruthHitList::iterator it = m_fdcCathodeTruthHit_list.begin();
        it != m_fdcCathodeTruthHit_list.end(); ++it)
   {
      if (++FdcCathodeTruthHitListCount > m_fdcCathodeTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fdcCathodeStrip>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcCathodeStrip::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcCathodeStrip");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "plane", (char*)&m_plane - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "strip", (char*)&m_strip - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FdcCathodeHitList_size", (char*)&m_fdcCathodeHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcCathodeHitList_offset", (char*)&m_fdcCathodeHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcCathodeTruthHitList_size", (char*)&m_fdcCathodeTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcCathodeTruthHitList_offset", (char*)&m_fdcCathodeTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcCathodeStrip"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcCathodeStrip"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcCathodeStrip", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcCathodeStrip", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcCathodeStrip::hdf5DataPack()
{
   m_fdcCathodeHit_list.deflate();
   m_fdcCathodeTruthHit_list.deflate();
}
void FdcCathodeStrip::hdf5DataUnpack()
{
   {
      std::list<FdcCathodeHit*> *host_plist = &m_host->m_fdcCathodeHit_plist;
      m_fdcCathodeHit_list.inflate(m_host, host_plist, this);
      FdcCathodeHitList::iterator iter;
      for (iter = m_fdcCathodeHit_list.begin();
           iter != m_fdcCathodeHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FdcCathodeTruthHit*> *host_plist = &m_host->m_fdcCathodeTruthHit_plist;
      m_fdcCathodeTruthHit_list.inflate(m_host, host_plist, this);
      FdcCathodeTruthHitList::iterator iter;
      for (iter = m_fdcCathodeTruthHit_list.begin();
           iter != m_fdcCathodeTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FdcTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcTruthPoint"
        << " E=" << m_E
        << " dEdx=" << m_dEdx
        << " dradius=" << m_dradius
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FdcTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " dradius=" << "\"" << getDradius() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fdcTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dradius", (char*)&m_dradius - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void FdcTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FdcChamber::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fdcChamber"
        << " layer=" << m_layer
        << " module=" << m_module
             << std::endl;
   int FdcAnodeWireListCount=0;
   for (FdcAnodeWireList::iterator it = m_fdcAnodeWire_list.begin();
        it != m_fdcAnodeWire_list.end(); ++it)
   {
      if (++FdcAnodeWireListCount > m_fdcAnodeWire_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FdcCathodeStripListCount=0;
   for (FdcCathodeStripList::iterator it = m_fdcCathodeStrip_list.begin();
        it != m_fdcCathodeStrip_list.end(); ++it)
   {
      if (++FdcCathodeStripListCount > m_fdcCathodeStrip_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FdcTruthPointListCount=0;
   for (FdcTruthPointList::iterator it = m_fdcTruthPoint_list.begin();
        it != m_fdcTruthPoint_list.end(); ++it)
   {
      if (++FdcTruthPointListCount > m_fdcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FdcChamber::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fdcChamber"
        << " layer=" << "\"" << getLayer() << "\""
        << " module=" << "\"" << getModule() << "\""
        << ">" << std::endl;
   int FdcAnodeWireListCount=0;
   for (FdcAnodeWireList::iterator it = m_fdcAnodeWire_list.begin();
        it != m_fdcAnodeWire_list.end(); ++it)
   {
      if (++FdcAnodeWireListCount > m_fdcAnodeWire_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FdcCathodeStripListCount=0;
   for (FdcCathodeStripList::iterator it = m_fdcCathodeStrip_list.begin();
        it != m_fdcCathodeStrip_list.end(); ++it)
   {
      if (++FdcCathodeStripListCount > m_fdcCathodeStrip_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FdcTruthPointListCount=0;
   for (FdcTruthPointList::iterator it = m_fdcTruthPoint_list.begin();
        it != m_fdcTruthPoint_list.end(); ++it)
   {
      if (++FdcTruthPointListCount > m_fdcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fdcChamber>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FdcChamber::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fdcChamber");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "layer", (char*)&m_layer - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "module", (char*)&m_module - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FdcAnodeWireList_size", (char*)&m_fdcAnodeWire_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcAnodeWireList_offset", (char*)&m_fdcAnodeWire_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcCathodeStripList_size", (char*)&m_fdcCathodeStrip_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcCathodeStripList_offset", (char*)&m_fdcCathodeStrip_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcTruthPointList_size", (char*)&m_fdcTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcTruthPointList_offset", (char*)&m_fdcTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fdcChamber"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fdcChamber"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fdcChamber", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fdcChamber", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FdcChamber::hdf5DataPack()
{
   m_fdcAnodeWire_list.deflate();
   m_fdcCathodeStrip_list.deflate();
   m_fdcTruthPoint_list.deflate();
}
void FdcChamber::hdf5DataUnpack()
{
   {
      std::list<FdcAnodeWire*> *host_plist = &m_host->m_fdcAnodeWire_plist;
      m_fdcAnodeWire_list.inflate(m_host, host_plist, this);
      FdcAnodeWireList::iterator iter;
      for (iter = m_fdcAnodeWire_list.begin();
           iter != m_fdcAnodeWire_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FdcCathodeStrip*> *host_plist = &m_host->m_fdcCathodeStrip_plist;
      m_fdcCathodeStrip_list.inflate(m_host, host_plist, this);
      FdcCathodeStripList::iterator iter;
      for (iter = m_fdcCathodeStrip_list.begin();
           iter != m_fdcCathodeStrip_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FdcTruthPoint*> *host_plist = &m_host->m_fdcTruthPoint_plist;
      m_fdcTruthPoint_list.inflate(m_host, host_plist, this);
      FdcTruthPointList::iterator iter;
      for (iter = m_fdcTruthPoint_list.begin();
           iter != m_fdcTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ForwardDC::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "forwardDC"
             << std::endl;
   int FdcChamberListCount=0;
   for (FdcChamberList::iterator it = m_fdcChamber_list.begin();
        it != m_fdcChamber_list.end(); ++it)
   {
      if (++FdcChamberListCount > m_fdcChamber_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string ForwardDC::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<forwardDC"
        << ">" << std::endl;
   int FdcChamberListCount=0;
   for (FdcChamberList::iterator it = m_fdcChamber_list.begin();
        it != m_fdcChamber_list.end(); ++it)
   {
      if (++FdcChamberListCount > m_fdcChamber_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</forwardDC>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ForwardDC::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("forwardDC");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "FdcChamberList_size", (char*)&m_fdcChamber_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FdcChamberList_offset", (char*)&m_fdcChamber_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["forwardDC"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["forwardDC"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "forwardDC", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "forwardDC", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ForwardDC::hdf5DataPack()
{
   m_fdcChamber_list.deflate();
}
void ForwardDC::hdf5DataUnpack()
{
   {
      std::list<FdcChamber*> *host_plist = &m_host->m_fdcChamber_plist;
      m_fdcChamber_list.inflate(m_host, host_plist, this);
      FdcChamberList::iterator iter;
      for (iter = m_fdcChamber_list.begin();
           iter != m_fdcChamber_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string StcDigihit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "stcDigihit"
        << " peakAmp=" << m_peakAmp
             << std::endl;
   return ostr.str();
}

std::string StcDigihit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<stcDigihit"
        << " peakAmp=" << "\"" << getPeakAmp() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StcDigihit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("stcDigihit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "peakAmp", (char*)&m_peakAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["stcDigihit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["stcDigihit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "stcDigihit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "stcDigihit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StcDigihit::hdf5DataPack()
{
}
void StcDigihit::hdf5DataUnpack()
{
}
#endif

std::string StcHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "stcHit"
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   if (! m_stcDigihit_link.empty()) {
      ostr << m_stcDigihit_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string StcHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<stcHit"
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   if (! m_stcDigihit_link.empty()) {
      ostr << m_stcDigihit_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</stcHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StcHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("stcHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "StcDigihitList_size", (char*)&m_stcDigihit_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StcDigihitList_offset", (char*)&m_stcDigihit_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["stcHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["stcHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "stcHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "stcHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StcHit::hdf5DataPack()
{
   m_stcDigihit_link.deflate();
}
void StcHit::hdf5DataUnpack()
{
   {
      std::list<StcDigihit*> *host_plist = &m_host->m_stcDigihit_plist;
      m_stcDigihit_link.inflate(m_host, host_plist, this);
      StcDigihitList::iterator iter;
      for (iter = m_stcDigihit_link.begin();
           iter != m_stcDigihit_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string StcTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "stcTruthHit"
        << " dE=" << m_dE
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string StcTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<stcTruthHit"
        << " dE=" << "\"" << getDE() << "\""
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StcTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("stcTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["stcTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["stcTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "stcTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "stcTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StcTruthHit::hdf5DataPack()
{
}
void StcTruthHit::hdf5DataUnpack()
{
}
#endif

std::string StcPaddle::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "stcPaddle"
        << " sector=" << m_sector
             << std::endl;
   int StcHitListCount=0;
   for (StcHitList::iterator it = m_stcHit_list.begin();
        it != m_stcHit_list.end(); ++it)
   {
      if (++StcHitListCount > m_stcHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int StcTruthHitListCount=0;
   for (StcTruthHitList::iterator it = m_stcTruthHit_list.begin();
        it != m_stcTruthHit_list.end(); ++it)
   {
      if (++StcTruthHitListCount > m_stcTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string StcPaddle::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<stcPaddle"
        << " sector=" << "\"" << getSector() << "\""
        << ">" << std::endl;
   int StcHitListCount=0;
   for (StcHitList::iterator it = m_stcHit_list.begin();
        it != m_stcHit_list.end(); ++it)
   {
      if (++StcHitListCount > m_stcHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int StcTruthHitListCount=0;
   for (StcTruthHitList::iterator it = m_stcTruthHit_list.begin();
        it != m_stcTruthHit_list.end(); ++it)
   {
      if (++StcTruthHitListCount > m_stcTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</stcPaddle>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StcPaddle::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("stcPaddle");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "sector", (char*)&m_sector - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "StcHitList_size", (char*)&m_stcHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StcHitList_offset", (char*)&m_stcHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StcTruthHitList_size", (char*)&m_stcTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StcTruthHitList_offset", (char*)&m_stcTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["stcPaddle"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["stcPaddle"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "stcPaddle", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "stcPaddle", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StcPaddle::hdf5DataPack()
{
   m_stcHit_list.deflate();
   m_stcTruthHit_list.deflate();
}
void StcPaddle::hdf5DataUnpack()
{
   {
      std::list<StcHit*> *host_plist = &m_host->m_stcHit_plist;
      m_stcHit_list.inflate(m_host, host_plist, this);
      StcHitList::iterator iter;
      for (iter = m_stcHit_list.begin();
           iter != m_stcHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<StcTruthHit*> *host_plist = &m_host->m_stcTruthHit_plist;
      m_stcTruthHit_list.inflate(m_host, host_plist, this);
      StcTruthHitList::iterator iter;
      for (iter = m_stcTruthHit_list.begin();
           iter != m_stcTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string StcTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "stcTruthPoint"
        << " E=" << m_E
        << " dEdx=" << m_dEdx
        << " phi=" << m_phi
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " r=" << m_r
        << " sector=" << m_sector
        << " t=" << m_t
        << " track=" << m_track
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string StcTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<stcTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " phi=" << "\"" << getPhi() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " r=" << "\"" << getR() << "\""
        << " sector=" << "\"" << getSector() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</stcTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StcTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("stcTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "phi", (char*)&m_phi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "r", (char*)&m_r - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "sector", (char*)&m_sector - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["stcTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["stcTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "stcTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "stcTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StcTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void StcTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string StartCntr::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "startCntr"
             << std::endl;
   int StcPaddleListCount=0;
   for (StcPaddleList::iterator it = m_stcPaddle_list.begin();
        it != m_stcPaddle_list.end(); ++it)
   {
      if (++StcPaddleListCount > m_stcPaddle_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int StcTruthPointListCount=0;
   for (StcTruthPointList::iterator it = m_stcTruthPoint_list.begin();
        it != m_stcTruthPoint_list.end(); ++it)
   {
      if (++StcTruthPointListCount > m_stcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string StartCntr::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<startCntr"
        << ">" << std::endl;
   int StcPaddleListCount=0;
   for (StcPaddleList::iterator it = m_stcPaddle_list.begin();
        it != m_stcPaddle_list.end(); ++it)
   {
      if (++StcPaddleListCount > m_stcPaddle_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int StcTruthPointListCount=0;
   for (StcTruthPointList::iterator it = m_stcTruthPoint_list.begin();
        it != m_stcTruthPoint_list.end(); ++it)
   {
      if (++StcTruthPointListCount > m_stcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</startCntr>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t StartCntr::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("startCntr");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "StcPaddleList_size", (char*)&m_stcPaddle_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StcPaddleList_offset", (char*)&m_stcPaddle_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StcTruthPointList_size", (char*)&m_stcTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StcTruthPointList_offset", (char*)&m_stcTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["startCntr"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["startCntr"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "startCntr", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "startCntr", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void StartCntr::hdf5DataPack()
{
   m_stcPaddle_list.deflate();
   m_stcTruthPoint_list.deflate();
}
void StartCntr::hdf5DataUnpack()
{
   {
      std::list<StcPaddle*> *host_plist = &m_host->m_stcPaddle_plist;
      m_stcPaddle_list.inflate(m_host, host_plist, this);
      StcPaddleList::iterator iter;
      for (iter = m_stcPaddle_list.begin();
           iter != m_stcPaddle_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<StcTruthPoint*> *host_plist = &m_host->m_stcTruthPoint_plist;
      m_stcTruthPoint_list.inflate(m_host, host_plist, this);
      StcTruthPointList::iterator iter;
      for (iter = m_stcTruthPoint_list.begin();
           iter != m_stcTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string BcalSiPMUpHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalSiPMUpHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string BcalSiPMUpHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalSiPMUpHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalSiPMUpHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalSiPMUpHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalSiPMUpHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalSiPMUpHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMUpHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMUpHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalSiPMUpHit::hdf5DataPack()
{
}
void BcalSiPMUpHit::hdf5DataUnpack()
{
}
#endif

std::string BcalSiPMDownHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalSiPMDownHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string BcalSiPMDownHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalSiPMDownHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalSiPMDownHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalSiPMDownHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalSiPMDownHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalSiPMDownHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMDownHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMDownHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalSiPMDownHit::hdf5DataPack()
{
}
void BcalSiPMDownHit::hdf5DataUnpack()
{
}
#endif

std::string BcalSiPMTruth::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalSiPMTruth"
        << " E=" << m_E
        << " incident_id=" << m_incident_id
             << std::endl;
   return ostr.str();
}

std::string BcalSiPMTruth::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalSiPMTruth"
        << " E=" << "\"" << getE() << "\""
        << " incident_id=" << "\"" << getIncident_id() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalSiPMTruth::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalSiPMTruth");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "incident_id", (char*)&m_incident_id - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalSiPMTruth"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalSiPMTruth"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMTruth", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMTruth", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalSiPMTruth::hdf5DataPack()
{
}
void BcalSiPMTruth::hdf5DataUnpack()
{
}
#endif

std::string BcalSiPMSpectrum::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalSiPMSpectrum"
        << " bin_width=" << m_bin_width
        << " end=" << m_end
        << " tstart=" << m_tstart
        << " vals=" << "\"" << m_vals << "\""
             << std::endl;
   if (! m_bcalSiPMTruth_link.empty()) {
      ostr << m_bcalSiPMTruth_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string BcalSiPMSpectrum::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalSiPMSpectrum"
        << " bin_width=" << "\"" << getBin_width() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " tstart=" << "\"" << getTstart() << "\""
        << " vals=" << "\"" << getVals() << "\""
        << ">" << std::endl;
   if (! m_bcalSiPMTruth_link.empty()) {
      ostr << m_bcalSiPMTruth_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</bcalSiPMSpectrum>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalSiPMSpectrum::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalSiPMSpectrum");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "bin_width", (char*)&m_bin_width - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "tstart", (char*)&m_tstart - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "vals", (char*)&mx_vals - (char*)this, vl_string_tid);
   H5Tinsert(tid, "BcalSiPMTruthList_size", (char*)&m_bcalSiPMTruth_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalSiPMTruthList_offset", (char*)&m_bcalSiPMTruth_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalSiPMSpectrum"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalSiPMSpectrum"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMSpectrum", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalSiPMSpectrum", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalSiPMSpectrum::hdf5DataPack()
{
   mx_vals = m_vals.c_str();
   m_bcalSiPMTruth_link.deflate();
}
void BcalSiPMSpectrum::hdf5DataUnpack()
{
   new(&m_vals) std::string();
   if (mx_vals != 0) {
      m_vals = mx_vals;
      m_host->m_hdf5_strings.push_back(&m_vals);
   }
   {
      std::list<BcalSiPMTruth*> *host_plist = &m_host->m_bcalSiPMTruth_plist;
      m_bcalSiPMTruth_link.inflate(m_host, host_plist, this);
      BcalSiPMTruthList::iterator iter;
      for (iter = m_bcalSiPMTruth_link.begin();
           iter != m_bcalSiPMTruth_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string BcalfADCHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalfADCHit"
        << " E=" << m_E
        << " end=" << m_end
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string BcalfADCHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalfADCHit"
        << " E=" << "\"" << getE() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalfADCHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalfADCHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalfADCHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalfADCHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalfADCHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalfADCHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalfADCHit::hdf5DataPack()
{
}
void BcalfADCHit::hdf5DataUnpack()
{
}
#endif

std::string BcalfADCPeak::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalfADCPeak"
        << " peakAmp=" << m_peakAmp
             << std::endl;
   return ostr.str();
}

std::string BcalfADCPeak::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalfADCPeak"
        << " peakAmp=" << "\"" << getPeakAmp() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalfADCPeak::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalfADCPeak");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "peakAmp", (char*)&m_peakAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalfADCPeak"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalfADCPeak"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalfADCPeak", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalfADCPeak", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalfADCPeak::hdf5DataPack()
{
}
void BcalfADCPeak::hdf5DataUnpack()
{
}
#endif

std::string BcalfADCDigiHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalfADCDigiHit"
        << " end=" << m_end
        << " pulse_integral=" << m_pulse_integral
        << " pulse_time=" << m_pulse_time
             << std::endl;
   if (! m_bcalfADCPeak_link.empty()) {
      ostr << m_bcalfADCPeak_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string BcalfADCDigiHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalfADCDigiHit"
        << " end=" << "\"" << getEnd() << "\""
        << " pulse_integral=" << "\"" << getPulse_integral() << "\""
        << " pulse_time=" << "\"" << getPulse_time() << "\""
        << ">" << std::endl;
   if (! m_bcalfADCPeak_link.empty()) {
      ostr << m_bcalfADCPeak_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</bcalfADCDigiHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalfADCDigiHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalfADCDigiHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "pulse_integral", (char*)&m_pulse_integral - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "pulse_time", (char*)&m_pulse_time - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "BcalfADCPeakList_size", (char*)&m_bcalfADCPeak_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalfADCPeakList_offset", (char*)&m_bcalfADCPeak_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalfADCDigiHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalfADCDigiHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalfADCDigiHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalfADCDigiHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalfADCDigiHit::hdf5DataPack()
{
   m_bcalfADCPeak_link.deflate();
}
void BcalfADCDigiHit::hdf5DataUnpack()
{
   {
      std::list<BcalfADCPeak*> *host_plist = &m_host->m_bcalfADCPeak_plist;
      m_bcalfADCPeak_link.inflate(m_host, host_plist, this);
      BcalfADCPeakList::iterator iter;
      for (iter = m_bcalfADCPeak_link.begin();
           iter != m_bcalfADCPeak_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string BcalTDCHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalTDCHit"
        << " end=" << m_end
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string BcalTDCHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalTDCHit"
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalTDCHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalTDCHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalTDCHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalTDCHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTDCHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTDCHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalTDCHit::hdf5DataPack()
{
}
void BcalTDCHit::hdf5DataUnpack()
{
}
#endif

std::string BcalTDCDigiHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalTDCDigiHit"
        << " end=" << m_end
        << " time=" << m_time
             << std::endl;
   return ostr.str();
}

std::string BcalTDCDigiHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalTDCDigiHit"
        << " end=" << "\"" << getEnd() << "\""
        << " time=" << "\"" << getTime() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalTDCDigiHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalTDCDigiHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "time", (char*)&m_time - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalTDCDigiHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalTDCDigiHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTDCDigiHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTDCDigiHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalTDCDigiHit::hdf5DataPack()
{
}
void BcalTDCDigiHit::hdf5DataUnpack()
{
}
#endif

std::string BcalTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalTruthHit"
        << " E=" << m_E
        << " incident_id=" << m_incident_id
        << " t=" << m_t
        << " zLocal=" << m_zLocal
             << std::endl;
   return ostr.str();
}

std::string BcalTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalTruthHit"
        << " E=" << "\"" << getE() << "\""
        << " incident_id=" << "\"" << getIncident_id() << "\""
        << " t=" << "\"" << getT() << "\""
        << " zLocal=" << "\"" << getZLocal() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "incident_id", (char*)&m_incident_id - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "zLocal", (char*)&m_zLocal - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalTruthHit::hdf5DataPack()
{
}
void BcalTruthHit::hdf5DataUnpack()
{
}
#endif

std::string BcalCell::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalCell"
        << " layer=" << m_layer
        << " module=" << m_module
        << " sector=" << m_sector
             << std::endl;
   int BcalSiPMUpHitListCount=0;
   for (BcalSiPMUpHitList::iterator it = m_bcalSiPMUpHit_list.begin();
        it != m_bcalSiPMUpHit_list.end(); ++it)
   {
      if (++BcalSiPMUpHitListCount > m_bcalSiPMUpHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalSiPMDownHitListCount=0;
   for (BcalSiPMDownHitList::iterator it = m_bcalSiPMDownHit_list.begin();
        it != m_bcalSiPMDownHit_list.end(); ++it)
   {
      if (++BcalSiPMDownHitListCount > m_bcalSiPMDownHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalSiPMSpectrumListCount=0;
   for (BcalSiPMSpectrumList::iterator it = m_bcalSiPMSpectrum_list.begin();
        it != m_bcalSiPMSpectrum_list.end(); ++it)
   {
      if (++BcalSiPMSpectrumListCount > m_bcalSiPMSpectrum_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalfADCHitListCount=0;
   for (BcalfADCHitList::iterator it = m_bcalfADCHit_list.begin();
        it != m_bcalfADCHit_list.end(); ++it)
   {
      if (++BcalfADCHitListCount > m_bcalfADCHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalfADCDigiHitListCount=0;
   for (BcalfADCDigiHitList::iterator it = m_bcalfADCDigiHit_list.begin();
        it != m_bcalfADCDigiHit_list.end(); ++it)
   {
      if (++BcalfADCDigiHitListCount > m_bcalfADCDigiHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalTDCHitListCount=0;
   for (BcalTDCHitList::iterator it = m_bcalTDCHit_list.begin();
        it != m_bcalTDCHit_list.end(); ++it)
   {
      if (++BcalTDCHitListCount > m_bcalTDCHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalTDCDigiHitListCount=0;
   for (BcalTDCDigiHitList::iterator it = m_bcalTDCDigiHit_list.begin();
        it != m_bcalTDCDigiHit_list.end(); ++it)
   {
      if (++BcalTDCDigiHitListCount > m_bcalTDCDigiHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalTruthHitListCount=0;
   for (BcalTruthHitList::iterator it = m_bcalTruthHit_list.begin();
        it != m_bcalTruthHit_list.end(); ++it)
   {
      if (++BcalTruthHitListCount > m_bcalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string BcalCell::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalCell"
        << " layer=" << "\"" << getLayer() << "\""
        << " module=" << "\"" << getModule() << "\""
        << " sector=" << "\"" << getSector() << "\""
        << ">" << std::endl;
   int BcalSiPMUpHitListCount=0;
   for (BcalSiPMUpHitList::iterator it = m_bcalSiPMUpHit_list.begin();
        it != m_bcalSiPMUpHit_list.end(); ++it)
   {
      if (++BcalSiPMUpHitListCount > m_bcalSiPMUpHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalSiPMDownHitListCount=0;
   for (BcalSiPMDownHitList::iterator it = m_bcalSiPMDownHit_list.begin();
        it != m_bcalSiPMDownHit_list.end(); ++it)
   {
      if (++BcalSiPMDownHitListCount > m_bcalSiPMDownHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalSiPMSpectrumListCount=0;
   for (BcalSiPMSpectrumList::iterator it = m_bcalSiPMSpectrum_list.begin();
        it != m_bcalSiPMSpectrum_list.end(); ++it)
   {
      if (++BcalSiPMSpectrumListCount > m_bcalSiPMSpectrum_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalfADCHitListCount=0;
   for (BcalfADCHitList::iterator it = m_bcalfADCHit_list.begin();
        it != m_bcalfADCHit_list.end(); ++it)
   {
      if (++BcalfADCHitListCount > m_bcalfADCHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalfADCDigiHitListCount=0;
   for (BcalfADCDigiHitList::iterator it = m_bcalfADCDigiHit_list.begin();
        it != m_bcalfADCDigiHit_list.end(); ++it)
   {
      if (++BcalfADCDigiHitListCount > m_bcalfADCDigiHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalTDCHitListCount=0;
   for (BcalTDCHitList::iterator it = m_bcalTDCHit_list.begin();
        it != m_bcalTDCHit_list.end(); ++it)
   {
      if (++BcalTDCHitListCount > m_bcalTDCHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalTDCDigiHitListCount=0;
   for (BcalTDCDigiHitList::iterator it = m_bcalTDCDigiHit_list.begin();
        it != m_bcalTDCDigiHit_list.end(); ++it)
   {
      if (++BcalTDCDigiHitListCount > m_bcalTDCDigiHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalTruthHitListCount=0;
   for (BcalTruthHitList::iterator it = m_bcalTruthHit_list.begin();
        it != m_bcalTruthHit_list.end(); ++it)
   {
      if (++BcalTruthHitListCount > m_bcalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</bcalCell>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalCell::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalCell");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "layer", (char*)&m_layer - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "module", (char*)&m_module - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "sector", (char*)&m_sector - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "BcalSiPMUpHitList_size", (char*)&m_bcalSiPMUpHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalSiPMUpHitList_offset", (char*)&m_bcalSiPMUpHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalSiPMDownHitList_size", (char*)&m_bcalSiPMDownHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalSiPMDownHitList_offset", (char*)&m_bcalSiPMDownHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalSiPMSpectrumList_size", (char*)&m_bcalSiPMSpectrum_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalSiPMSpectrumList_offset", (char*)&m_bcalSiPMSpectrum_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalfADCHitList_size", (char*)&m_bcalfADCHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalfADCHitList_offset", (char*)&m_bcalfADCHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalfADCDigiHitList_size", (char*)&m_bcalfADCDigiHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalfADCDigiHitList_offset", (char*)&m_bcalfADCDigiHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTDCHitList_size", (char*)&m_bcalTDCHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTDCHitList_offset", (char*)&m_bcalTDCHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTDCDigiHitList_size", (char*)&m_bcalTDCDigiHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTDCDigiHitList_offset", (char*)&m_bcalTDCDigiHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTruthHitList_size", (char*)&m_bcalTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTruthHitList_offset", (char*)&m_bcalTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalCell"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalCell"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCell", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalCell", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalCell::hdf5DataPack()
{
   m_bcalSiPMUpHit_list.deflate();
   m_bcalSiPMDownHit_list.deflate();
   m_bcalSiPMSpectrum_list.deflate();
   m_bcalfADCHit_list.deflate();
   m_bcalfADCDigiHit_list.deflate();
   m_bcalTDCHit_list.deflate();
   m_bcalTDCDigiHit_list.deflate();
   m_bcalTruthHit_list.deflate();
}
void BcalCell::hdf5DataUnpack()
{
   {
      std::list<BcalSiPMUpHit*> *host_plist = &m_host->m_bcalSiPMUpHit_plist;
      m_bcalSiPMUpHit_list.inflate(m_host, host_plist, this);
      BcalSiPMUpHitList::iterator iter;
      for (iter = m_bcalSiPMUpHit_list.begin();
           iter != m_bcalSiPMUpHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalSiPMDownHit*> *host_plist = &m_host->m_bcalSiPMDownHit_plist;
      m_bcalSiPMDownHit_list.inflate(m_host, host_plist, this);
      BcalSiPMDownHitList::iterator iter;
      for (iter = m_bcalSiPMDownHit_list.begin();
           iter != m_bcalSiPMDownHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalSiPMSpectrum*> *host_plist = &m_host->m_bcalSiPMSpectrum_plist;
      m_bcalSiPMSpectrum_list.inflate(m_host, host_plist, this);
      BcalSiPMSpectrumList::iterator iter;
      for (iter = m_bcalSiPMSpectrum_list.begin();
           iter != m_bcalSiPMSpectrum_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalfADCHit*> *host_plist = &m_host->m_bcalfADCHit_plist;
      m_bcalfADCHit_list.inflate(m_host, host_plist, this);
      BcalfADCHitList::iterator iter;
      for (iter = m_bcalfADCHit_list.begin();
           iter != m_bcalfADCHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalfADCDigiHit*> *host_plist = &m_host->m_bcalfADCDigiHit_plist;
      m_bcalfADCDigiHit_list.inflate(m_host, host_plist, this);
      BcalfADCDigiHitList::iterator iter;
      for (iter = m_bcalfADCDigiHit_list.begin();
           iter != m_bcalfADCDigiHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalTDCHit*> *host_plist = &m_host->m_bcalTDCHit_plist;
      m_bcalTDCHit_list.inflate(m_host, host_plist, this);
      BcalTDCHitList::iterator iter;
      for (iter = m_bcalTDCHit_list.begin();
           iter != m_bcalTDCHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalTDCDigiHit*> *host_plist = &m_host->m_bcalTDCDigiHit_plist;
      m_bcalTDCDigiHit_list.inflate(m_host, host_plist, this);
      BcalTDCDigiHitList::iterator iter;
      for (iter = m_bcalTDCDigiHit_list.begin();
           iter != m_bcalTDCDigiHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalTruthHit*> *host_plist = &m_host->m_bcalTruthHit_plist;
      m_bcalTruthHit_list.inflate(m_host, host_plist, this);
      BcalTruthHitList::iterator iter;
      for (iter = m_bcalTruthHit_list.begin();
           iter != m_bcalTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string BcalTruthIncidentParticle::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalTruthIncidentParticle"
        << " id=" << m_id
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string BcalTruthIncidentParticle::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalTruthIncidentParticle"
        << " id=" << "\"" << getId() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalTruthIncidentParticle::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalTruthIncidentParticle");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "id", (char*)&m_id - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalTruthIncidentParticle"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalTruthIncidentParticle"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTruthIncidentParticle", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTruthIncidentParticle", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalTruthIncidentParticle::hdf5DataPack()
{
}
void BcalTruthIncidentParticle::hdf5DataUnpack()
{
}
#endif

std::string BcalTruthShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "bcalTruthShower"
        << " E=" << m_E
        << " phi=" << m_phi
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " r=" << m_r
        << " t=" << m_t
        << " track=" << m_track
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string BcalTruthShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<bcalTruthShower"
        << " E=" << "\"" << getE() << "\""
        << " phi=" << "\"" << getPhi() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " r=" << "\"" << getR() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</bcalTruthShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BcalTruthShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("bcalTruthShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "phi", (char*)&m_phi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "r", (char*)&m_r - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["bcalTruthShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["bcalTruthShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTruthShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "bcalTruthShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BcalTruthShower::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void BcalTruthShower::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string BarrelEMcal::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "barrelEMcal"
             << std::endl;
   int BcalCellListCount=0;
   for (BcalCellList::iterator it = m_bcalCell_list.begin();
        it != m_bcalCell_list.end(); ++it)
   {
      if (++BcalCellListCount > m_bcalCell_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalTruthIncidentParticleListCount=0;
   for (BcalTruthIncidentParticleList::iterator it = m_bcalTruthIncidentParticle_list.begin();
        it != m_bcalTruthIncidentParticle_list.end(); ++it)
   {
      if (++BcalTruthIncidentParticleListCount > m_bcalTruthIncidentParticle_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int BcalTruthShowerListCount=0;
   for (BcalTruthShowerList::iterator it = m_bcalTruthShower_list.begin();
        it != m_bcalTruthShower_list.end(); ++it)
   {
      if (++BcalTruthShowerListCount > m_bcalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string BarrelEMcal::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<barrelEMcal"
        << ">" << std::endl;
   int BcalCellListCount=0;
   for (BcalCellList::iterator it = m_bcalCell_list.begin();
        it != m_bcalCell_list.end(); ++it)
   {
      if (++BcalCellListCount > m_bcalCell_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalTruthIncidentParticleListCount=0;
   for (BcalTruthIncidentParticleList::iterator it = m_bcalTruthIncidentParticle_list.begin();
        it != m_bcalTruthIncidentParticle_list.end(); ++it)
   {
      if (++BcalTruthIncidentParticleListCount > m_bcalTruthIncidentParticle_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int BcalTruthShowerListCount=0;
   for (BcalTruthShowerList::iterator it = m_bcalTruthShower_list.begin();
        it != m_bcalTruthShower_list.end(); ++it)
   {
      if (++BcalTruthShowerListCount > m_bcalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</barrelEMcal>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t BarrelEMcal::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("barrelEMcal");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "BcalCellList_size", (char*)&m_bcalCell_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalCellList_offset", (char*)&m_bcalCell_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTruthIncidentParticleList_size", (char*)&m_bcalTruthIncidentParticle_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTruthIncidentParticleList_offset", (char*)&m_bcalTruthIncidentParticle_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTruthShowerList_size", (char*)&m_bcalTruthShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BcalTruthShowerList_offset", (char*)&m_bcalTruthShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["barrelEMcal"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["barrelEMcal"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "barrelEMcal", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "barrelEMcal", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void BarrelEMcal::hdf5DataPack()
{
   m_bcalCell_list.deflate();
   m_bcalTruthIncidentParticle_list.deflate();
   m_bcalTruthShower_list.deflate();
}
void BarrelEMcal::hdf5DataUnpack()
{
   {
      std::list<BcalCell*> *host_plist = &m_host->m_bcalCell_plist;
      m_bcalCell_list.inflate(m_host, host_plist, this);
      BcalCellList::iterator iter;
      for (iter = m_bcalCell_list.begin();
           iter != m_bcalCell_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalTruthIncidentParticle*> *host_plist = &m_host->m_bcalTruthIncidentParticle_plist;
      m_bcalTruthIncidentParticle_list.inflate(m_host, host_plist, this);
      BcalTruthIncidentParticleList::iterator iter;
      for (iter = m_bcalTruthIncidentParticle_list.begin();
           iter != m_bcalTruthIncidentParticle_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BcalTruthShower*> *host_plist = &m_host->m_bcalTruthShower_plist;
      m_bcalTruthShower_list.inflate(m_host, host_plist, this);
      BcalTruthShowerList::iterator iter;
      for (iter = m_bcalTruthShower_list.begin();
           iter != m_bcalTruthShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string GcalHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "gcalHit"
        << " E=" << m_E
        << " t=" << m_t
        << " zLocal=" << m_zLocal
             << std::endl;
   return ostr.str();
}

std::string GcalHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<gcalHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " zLocal=" << "\"" << getZLocal() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t GcalHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("gcalHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "zLocal", (char*)&m_zLocal - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["gcalHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["gcalHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "gcalHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "gcalHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void GcalHit::hdf5DataPack()
{
}
void GcalHit::hdf5DataUnpack()
{
}
#endif

std::string GcalTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "gcalTruthHit"
        << " E=" << m_E
        << " t=" << m_t
        << " zLocal=" << m_zLocal
             << std::endl;
   return ostr.str();
}

std::string GcalTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<gcalTruthHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " zLocal=" << "\"" << getZLocal() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t GcalTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("gcalTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "zLocal", (char*)&m_zLocal - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["gcalTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["gcalTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "gcalTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "gcalTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void GcalTruthHit::hdf5DataPack()
{
}
void GcalTruthHit::hdf5DataUnpack()
{
}
#endif

std::string GcalCell::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "gcalCell"
        << " module=" << m_module
             << std::endl;
   int GcalHitListCount=0;
   for (GcalHitList::iterator it = m_gcalHit_list.begin();
        it != m_gcalHit_list.end(); ++it)
   {
      if (++GcalHitListCount > m_gcalHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int GcalTruthHitListCount=0;
   for (GcalTruthHitList::iterator it = m_gcalTruthHit_list.begin();
        it != m_gcalTruthHit_list.end(); ++it)
   {
      if (++GcalTruthHitListCount > m_gcalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string GcalCell::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<gcalCell"
        << " module=" << "\"" << getModule() << "\""
        << ">" << std::endl;
   int GcalHitListCount=0;
   for (GcalHitList::iterator it = m_gcalHit_list.begin();
        it != m_gcalHit_list.end(); ++it)
   {
      if (++GcalHitListCount > m_gcalHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int GcalTruthHitListCount=0;
   for (GcalTruthHitList::iterator it = m_gcalTruthHit_list.begin();
        it != m_gcalTruthHit_list.end(); ++it)
   {
      if (++GcalTruthHitListCount > m_gcalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</gcalCell>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t GcalCell::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("gcalCell");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "module", (char*)&m_module - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "GcalHitList_size", (char*)&m_gcalHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GcalHitList_offset", (char*)&m_gcalHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GcalTruthHitList_size", (char*)&m_gcalTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GcalTruthHitList_offset", (char*)&m_gcalTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["gcalCell"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["gcalCell"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "gcalCell", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "gcalCell", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void GcalCell::hdf5DataPack()
{
   m_gcalHit_list.deflate();
   m_gcalTruthHit_list.deflate();
}
void GcalCell::hdf5DataUnpack()
{
   {
      std::list<GcalHit*> *host_plist = &m_host->m_gcalHit_plist;
      m_gcalHit_list.inflate(m_host, host_plist, this);
      GcalHitList::iterator iter;
      for (iter = m_gcalHit_list.begin();
           iter != m_gcalHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<GcalTruthHit*> *host_plist = &m_host->m_gcalTruthHit_plist;
      m_gcalTruthHit_list.inflate(m_host, host_plist, this);
      GcalTruthHitList::iterator iter;
      for (iter = m_gcalTruthHit_list.begin();
           iter != m_gcalTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string GcalTruthShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "gcalTruthShower"
        << " E=" << m_E
        << " phi=" << m_phi
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " r=" << m_r
        << " t=" << m_t
        << " track=" << m_track
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string GcalTruthShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<gcalTruthShower"
        << " E=" << "\"" << getE() << "\""
        << " phi=" << "\"" << getPhi() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " r=" << "\"" << getR() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</gcalTruthShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t GcalTruthShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("gcalTruthShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "phi", (char*)&m_phi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "r", (char*)&m_r - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["gcalTruthShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["gcalTruthShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "gcalTruthShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "gcalTruthShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void GcalTruthShower::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void GcalTruthShower::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string GapEMcal::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "gapEMcal"
             << std::endl;
   int GcalCellListCount=0;
   for (GcalCellList::iterator it = m_gcalCell_list.begin();
        it != m_gcalCell_list.end(); ++it)
   {
      if (++GcalCellListCount > m_gcalCell_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int GcalTruthShowerListCount=0;
   for (GcalTruthShowerList::iterator it = m_gcalTruthShower_list.begin();
        it != m_gcalTruthShower_list.end(); ++it)
   {
      if (++GcalTruthShowerListCount > m_gcalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string GapEMcal::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<gapEMcal"
        << ">" << std::endl;
   int GcalCellListCount=0;
   for (GcalCellList::iterator it = m_gcalCell_list.begin();
        it != m_gcalCell_list.end(); ++it)
   {
      if (++GcalCellListCount > m_gcalCell_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int GcalTruthShowerListCount=0;
   for (GcalTruthShowerList::iterator it = m_gcalTruthShower_list.begin();
        it != m_gcalTruthShower_list.end(); ++it)
   {
      if (++GcalTruthShowerListCount > m_gcalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</gapEMcal>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t GapEMcal::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("gapEMcal");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "GcalCellList_size", (char*)&m_gcalCell_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GcalCellList_offset", (char*)&m_gcalCell_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GcalTruthShowerList_size", (char*)&m_gcalTruthShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GcalTruthShowerList_offset", (char*)&m_gcalTruthShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["gapEMcal"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["gapEMcal"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "gapEMcal", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "gapEMcal", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void GapEMcal::hdf5DataPack()
{
   m_gcalCell_list.deflate();
   m_gcalTruthShower_list.deflate();
}
void GapEMcal::hdf5DataUnpack()
{
   {
      std::list<GcalCell*> *host_plist = &m_host->m_gcalCell_plist;
      m_gcalCell_list.inflate(m_host, host_plist, this);
      GcalCellList::iterator iter;
      for (iter = m_gcalCell_list.begin();
           iter != m_gcalCell_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<GcalTruthShower*> *host_plist = &m_host->m_gcalTruthShower_plist;
      m_gcalTruthShower_list.inflate(m_host, host_plist, this);
      GcalTruthShowerList::iterator iter;
      for (iter = m_gcalTruthShower_list.begin();
           iter != m_gcalTruthShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CereHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cereHit"
        << " pe=" << m_pe
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string CereHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cereHit"
        << " pe=" << "\"" << getPe() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CereHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cereHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "pe", (char*)&m_pe - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cereHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cereHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cereHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cereHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CereHit::hdf5DataPack()
{
}
void CereHit::hdf5DataUnpack()
{
}
#endif

std::string CereTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cereTruthHit"
        << " pe=" << m_pe
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string CereTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cereTruthHit"
        << " pe=" << "\"" << getPe() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CereTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cereTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "pe", (char*)&m_pe - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cereTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cereTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cereTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cereTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CereTruthHit::hdf5DataPack()
{
}
void CereTruthHit::hdf5DataUnpack()
{
}
#endif

std::string CereSection::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cereSection"
        << " sector=" << m_sector
             << std::endl;
   int CereHitListCount=0;
   for (CereHitList::iterator it = m_cereHit_list.begin();
        it != m_cereHit_list.end(); ++it)
   {
      if (++CereHitListCount > m_cereHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CereTruthHitListCount=0;
   for (CereTruthHitList::iterator it = m_cereTruthHit_list.begin();
        it != m_cereTruthHit_list.end(); ++it)
   {
      if (++CereTruthHitListCount > m_cereTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string CereSection::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cereSection"
        << " sector=" << "\"" << getSector() << "\""
        << ">" << std::endl;
   int CereHitListCount=0;
   for (CereHitList::iterator it = m_cereHit_list.begin();
        it != m_cereHit_list.end(); ++it)
   {
      if (++CereHitListCount > m_cereHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CereTruthHitListCount=0;
   for (CereTruthHitList::iterator it = m_cereTruthHit_list.begin();
        it != m_cereTruthHit_list.end(); ++it)
   {
      if (++CereTruthHitListCount > m_cereTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</cereSection>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CereSection::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cereSection");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "sector", (char*)&m_sector - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "CereHitList_size", (char*)&m_cereHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CereHitList_offset", (char*)&m_cereHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CereTruthHitList_size", (char*)&m_cereTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CereTruthHitList_offset", (char*)&m_cereTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cereSection"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cereSection"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cereSection", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cereSection", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CereSection::hdf5DataPack()
{
   m_cereHit_list.deflate();
   m_cereTruthHit_list.deflate();
}
void CereSection::hdf5DataUnpack()
{
   {
      std::list<CereHit*> *host_plist = &m_host->m_cereHit_plist;
      m_cereHit_list.inflate(m_host, host_plist, this);
      CereHitList::iterator iter;
      for (iter = m_cereHit_list.begin();
           iter != m_cereHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CereTruthHit*> *host_plist = &m_host->m_cereTruthHit_plist;
      m_cereTruthHit_list.inflate(m_host, host_plist, this);
      CereTruthHitList::iterator iter;
      for (iter = m_cereTruthHit_list.begin();
           iter != m_cereTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CereTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cereTruthPoint"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string CereTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cereTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</cereTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CereTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cereTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cereTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cereTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cereTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cereTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CereTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void CereTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Cerenkov::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "Cerenkov"
             << std::endl;
   int CereSectionListCount=0;
   for (CereSectionList::iterator it = m_cereSection_list.begin();
        it != m_cereSection_list.end(); ++it)
   {
      if (++CereSectionListCount > m_cereSection_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CereTruthPointListCount=0;
   for (CereTruthPointList::iterator it = m_cereTruthPoint_list.begin();
        it != m_cereTruthPoint_list.end(); ++it)
   {
      if (++CereTruthPointListCount > m_cereTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string Cerenkov::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<Cerenkov"
        << ">" << std::endl;
   int CereSectionListCount=0;
   for (CereSectionList::iterator it = m_cereSection_list.begin();
        it != m_cereSection_list.end(); ++it)
   {
      if (++CereSectionListCount > m_cereSection_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CereTruthPointListCount=0;
   for (CereTruthPointList::iterator it = m_cereTruthPoint_list.begin();
        it != m_cereTruthPoint_list.end(); ++it)
   {
      if (++CereTruthPointListCount > m_cereTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</Cerenkov>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Cerenkov::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("Cerenkov");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "CereSectionList_size", (char*)&m_cereSection_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CereSectionList_offset", (char*)&m_cereSection_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CereTruthPointList_size", (char*)&m_cereTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CereTruthPointList_offset", (char*)&m_cereTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["Cerenkov"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["Cerenkov"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "Cerenkov", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "Cerenkov", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Cerenkov::hdf5DataPack()
{
   m_cereSection_list.deflate();
   m_cereTruthPoint_list.deflate();
}
void Cerenkov::hdf5DataUnpack()
{
   {
      std::list<CereSection*> *host_plist = &m_host->m_cereSection_plist;
      m_cereSection_list.inflate(m_host, host_plist, this);
      CereSectionList::iterator iter;
      for (iter = m_cereSection_list.begin();
           iter != m_cereSection_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CereTruthPoint*> *host_plist = &m_host->m_cereTruthPoint_plist;
      m_cereTruthPoint_list.inflate(m_host, host_plist, this);
      CereTruthPointList::iterator iter;
      for (iter = m_cereTruthPoint_list.begin();
           iter != m_cereTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string RichTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "richTruthHit"
        << " t=" << m_t
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string RichTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<richTruthHit"
        << " t=" << "\"" << getT() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t RichTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("richTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["richTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["richTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "richTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "richTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void RichTruthHit::hdf5DataPack()
{
}
void RichTruthHit::hdf5DataUnpack()
{
}
#endif

std::string RichTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "richTruthPoint"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string RichTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<richTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</richTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t RichTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("richTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["richTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["richTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "richTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "richTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void RichTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void RichTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string RICH::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "RICH"
             << std::endl;
   int RichTruthHitListCount=0;
   for (RichTruthHitList::iterator it = m_richTruthHit_list.begin();
        it != m_richTruthHit_list.end(); ++it)
   {
      if (++RichTruthHitListCount > m_richTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int RichTruthPointListCount=0;
   for (RichTruthPointList::iterator it = m_richTruthPoint_list.begin();
        it != m_richTruthPoint_list.end(); ++it)
   {
      if (++RichTruthPointListCount > m_richTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string RICH::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<RICH"
        << ">" << std::endl;
   int RichTruthHitListCount=0;
   for (RichTruthHitList::iterator it = m_richTruthHit_list.begin();
        it != m_richTruthHit_list.end(); ++it)
   {
      if (++RichTruthHitListCount > m_richTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int RichTruthPointListCount=0;
   for (RichTruthPointList::iterator it = m_richTruthPoint_list.begin();
        it != m_richTruthPoint_list.end(); ++it)
   {
      if (++RichTruthPointListCount > m_richTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</RICH>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t RICH::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("RICH");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "RichTruthHitList_size", (char*)&m_richTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RichTruthHitList_offset", (char*)&m_richTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RichTruthPointList_size", (char*)&m_richTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RichTruthPointList_offset", (char*)&m_richTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["RICH"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["RICH"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "RICH", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "RICH", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void RICH::hdf5DataPack()
{
   m_richTruthHit_list.deflate();
   m_richTruthPoint_list.deflate();
}
void RICH::hdf5DataUnpack()
{
   {
      std::list<RichTruthHit*> *host_plist = &m_host->m_richTruthHit_plist;
      m_richTruthHit_list.inflate(m_host, host_plist, this);
      RichTruthHitList::iterator iter;
      for (iter = m_richTruthHit_list.begin();
           iter != m_richTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<RichTruthPoint*> *host_plist = &m_host->m_richTruthPoint_plist;
      m_richTruthPoint_list.inflate(m_host, host_plist, this);
      RichTruthPointList::iterator iter;
      for (iter = m_richTruthPoint_list.begin();
           iter != m_richTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string DircTruthBarHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircTruthBarHit"
        << " E=" << m_E
        << " bar=" << m_bar
        << " pdg=" << m_pdg
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string DircTruthBarHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircTruthBarHit"
        << " E=" << "\"" << getE() << "\""
        << " bar=" << "\"" << getBar() << "\""
        << " pdg=" << "\"" << getPdg() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircTruthBarHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircTruthBarHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "bar", (char*)&m_bar - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "pdg", (char*)&m_pdg - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircTruthBarHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircTruthBarHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircTruthBarHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircTruthBarHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircTruthBarHit::hdf5DataPack()
{
}
void DircTruthBarHit::hdf5DataUnpack()
{
}
#endif

std::string DircTruthPmtHitExtra::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircTruthPmtHitExtra"
        << " bbrefl=" << ((m_bbrefl == 0)? "true" : "false")
        << " path=" << m_path
        << " refl=" << m_refl
        << " t_fixed=" << m_t_fixed
             << std::endl;
   return ostr.str();
}

std::string DircTruthPmtHitExtra::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircTruthPmtHitExtra"
        << " bbrefl=" << ((m_bbrefl == 0)? "\"true\"" : "\"false\"")
        << " path=" << "\"" << getPath() << "\""
        << " refl=" << "\"" << getRefl() << "\""
        << " t_fixed=" << "\"" << getT_fixed() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircTruthPmtHitExtra::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircTruthPmtHitExtra");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "bbrefl", (char*)&m_bbrefl - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "path", (char*)&m_path - (char*)this, ((inmemory)? H5T_NATIVE_LONG : H5T_STD_I64LE));
   H5Tinsert(tid, "refl", (char*)&m_refl - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t_fixed", (char*)&m_t_fixed - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircTruthPmtHitExtra"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircTruthPmtHitExtra"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircTruthPmtHitExtra", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircTruthPmtHitExtra", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircTruthPmtHitExtra::hdf5DataPack()
{
}
void DircTruthPmtHitExtra::hdf5DataUnpack()
{
}
#endif

std::string DircTruthPmtHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircTruthPmtHit"
        << " E=" << m_E
        << " ch=" << m_ch
        << " key_bar=" << m_key_bar
        << " t=" << m_t
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   int DircTruthPmtHitExtraListCount=0;
   for (DircTruthPmtHitExtraList::iterator it = m_dircTruthPmtHitExtra_list.begin();
        it != m_dircTruthPmtHitExtra_list.end(); ++it)
   {
      if (++DircTruthPmtHitExtraListCount > m_dircTruthPmtHitExtra_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string DircTruthPmtHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircTruthPmtHit"
        << " E=" << "\"" << getE() << "\""
        << " ch=" << "\"" << getCh() << "\""
        << " key_bar=" << "\"" << getKey_bar() << "\""
        << " t=" << "\"" << getT() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   int DircTruthPmtHitExtraListCount=0;
   for (DircTruthPmtHitExtraList::iterator it = m_dircTruthPmtHitExtra_list.begin();
        it != m_dircTruthPmtHitExtra_list.end(); ++it)
   {
      if (++DircTruthPmtHitExtraListCount > m_dircTruthPmtHitExtra_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</dircTruthPmtHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircTruthPmtHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircTruthPmtHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "ch", (char*)&m_ch - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "key_bar", (char*)&m_key_bar - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "DircTruthPmtHitExtraList_size", (char*)&m_dircTruthPmtHitExtra_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircTruthPmtHitExtraList_offset", (char*)&m_dircTruthPmtHitExtra_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircTruthPmtHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircTruthPmtHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircTruthPmtHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircTruthPmtHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircTruthPmtHit::hdf5DataPack()
{
   m_dircTruthPmtHitExtra_list.deflate();
}
void DircTruthPmtHit::hdf5DataUnpack()
{
   {
      std::list<DircTruthPmtHitExtra*> *host_plist = &m_host->m_dircTruthPmtHitExtra_plist;
      m_dircTruthPmtHitExtra_list.inflate(m_host, host_plist, this);
      DircTruthPmtHitExtraList::iterator iter;
      for (iter = m_dircTruthPmtHitExtra_list.begin();
           iter != m_dircTruthPmtHitExtra_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string DircPmtHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "dircPmtHit"
        << " ch=" << m_ch
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string DircPmtHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<dircPmtHit"
        << " ch=" << "\"" << getCh() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DircPmtHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("dircPmtHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "ch", (char*)&m_ch - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["dircPmtHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["dircPmtHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "dircPmtHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "dircPmtHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DircPmtHit::hdf5DataPack()
{
}
void DircPmtHit::hdf5DataUnpack()
{
}
#endif

std::string DIRC::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "DIRC"
             << std::endl;
   int DircTruthBarHitListCount=0;
   for (DircTruthBarHitList::iterator it = m_dircTruthBarHit_list.begin();
        it != m_dircTruthBarHit_list.end(); ++it)
   {
      if (++DircTruthBarHitListCount > m_dircTruthBarHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int DircTruthPmtHitListCount=0;
   for (DircTruthPmtHitList::iterator it = m_dircTruthPmtHit_list.begin();
        it != m_dircTruthPmtHit_list.end(); ++it)
   {
      if (++DircTruthPmtHitListCount > m_dircTruthPmtHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int DircPmtHitListCount=0;
   for (DircPmtHitList::iterator it = m_dircPmtHit_list.begin();
        it != m_dircPmtHit_list.end(); ++it)
   {
      if (++DircPmtHitListCount > m_dircPmtHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string DIRC::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<DIRC"
        << ">" << std::endl;
   int DircTruthBarHitListCount=0;
   for (DircTruthBarHitList::iterator it = m_dircTruthBarHit_list.begin();
        it != m_dircTruthBarHit_list.end(); ++it)
   {
      if (++DircTruthBarHitListCount > m_dircTruthBarHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int DircTruthPmtHitListCount=0;
   for (DircTruthPmtHitList::iterator it = m_dircTruthPmtHit_list.begin();
        it != m_dircTruthPmtHit_list.end(); ++it)
   {
      if (++DircTruthPmtHitListCount > m_dircTruthPmtHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int DircPmtHitListCount=0;
   for (DircPmtHitList::iterator it = m_dircPmtHit_list.begin();
        it != m_dircPmtHit_list.end(); ++it)
   {
      if (++DircPmtHitListCount > m_dircPmtHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</DIRC>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t DIRC::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("DIRC");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "DircTruthBarHitList_size", (char*)&m_dircTruthBarHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircTruthBarHitList_offset", (char*)&m_dircTruthBarHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircTruthPmtHitList_size", (char*)&m_dircTruthPmtHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircTruthPmtHitList_offset", (char*)&m_dircTruthPmtHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircPmtHitList_size", (char*)&m_dircPmtHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DircPmtHitList_offset", (char*)&m_dircPmtHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["DIRC"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["DIRC"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "DIRC", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "DIRC", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void DIRC::hdf5DataPack()
{
   m_dircTruthBarHit_list.deflate();
   m_dircTruthPmtHit_list.deflate();
   m_dircPmtHit_list.deflate();
}
void DIRC::hdf5DataUnpack()
{
   {
      std::list<DircTruthBarHit*> *host_plist = &m_host->m_dircTruthBarHit_plist;
      m_dircTruthBarHit_list.inflate(m_host, host_plist, this);
      DircTruthBarHitList::iterator iter;
      for (iter = m_dircTruthBarHit_list.begin();
           iter != m_dircTruthBarHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DircTruthPmtHit*> *host_plist = &m_host->m_dircTruthPmtHit_plist;
      m_dircTruthPmtHit_list.inflate(m_host, host_plist, this);
      DircTruthPmtHitList::iterator iter;
      for (iter = m_dircTruthPmtHit_list.begin();
           iter != m_dircTruthPmtHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DircPmtHit*> *host_plist = &m_host->m_dircPmtHit_plist;
      m_dircPmtHit_list.inflate(m_host, host_plist, this);
      DircPmtHitList::iterator iter;
      for (iter = m_dircPmtHit_list.begin();
           iter != m_dircPmtHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FtofDigihit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ftofDigihit"
        << " peakAmp=" << m_peakAmp
             << std::endl;
   return ostr.str();
}

std::string FtofDigihit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ftofDigihit"
        << " peakAmp=" << "\"" << getPeakAmp() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FtofDigihit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ftofDigihit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "peakAmp", (char*)&m_peakAmp - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ftofDigihit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ftofDigihit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ftofDigihit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ftofDigihit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FtofDigihit::hdf5DataPack()
{
}
void FtofDigihit::hdf5DataUnpack()
{
}
#endif

std::string FtofHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ftofHit"
        << " dE=" << m_dE
        << " end=" << m_end
        << " t=" << m_t
             << std::endl;
   if (! m_ftofDigihit_link.empty()) {
      ostr << m_ftofDigihit_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FtofHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ftofHit"
        << " dE=" << "\"" << getDE() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   if (! m_ftofDigihit_link.empty()) {
      ostr << m_ftofDigihit_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ftofHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FtofHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ftofHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FtofDigihitList_size", (char*)&m_ftofDigihit_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofDigihitList_offset", (char*)&m_ftofDigihit_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ftofHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ftofHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ftofHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ftofHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FtofHit::hdf5DataPack()
{
   m_ftofDigihit_link.deflate();
}
void FtofHit::hdf5DataUnpack()
{
   {
      std::list<FtofDigihit*> *host_plist = &m_host->m_ftofDigihit_plist;
      m_ftofDigihit_link.inflate(m_host, host_plist, this);
      FtofDigihitList::iterator iter;
      for (iter = m_ftofDigihit_link.begin();
           iter != m_ftofDigihit_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FtofTruthExtra::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ftofTruthExtra"
        << " E=" << m_E
        << " dist=" << m_dist
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string FtofTruthExtra::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ftofTruthExtra"
        << " E=" << "\"" << getE() << "\""
        << " dist=" << "\"" << getDist() << "\""
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FtofTruthExtra::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ftofTruthExtra");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dist", (char*)&m_dist - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ftofTruthExtra"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ftofTruthExtra"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ftofTruthExtra", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ftofTruthExtra", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FtofTruthExtra::hdf5DataPack()
{
}
void FtofTruthExtra::hdf5DataUnpack()
{
}
#endif

std::string FtofTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ftofTruthHit"
        << " dE=" << m_dE
        << " end=" << m_end
        << " t=" << m_t
             << std::endl;
   int FtofTruthExtraListCount=0;
   for (FtofTruthExtraList::iterator it = m_ftofTruthExtra_list.begin();
        it != m_ftofTruthExtra_list.end(); ++it)
   {
      if (++FtofTruthExtraListCount > m_ftofTruthExtra_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FtofTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ftofTruthHit"
        << " dE=" << "\"" << getDE() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   int FtofTruthExtraListCount=0;
   for (FtofTruthExtraList::iterator it = m_ftofTruthExtra_list.begin();
        it != m_ftofTruthExtra_list.end(); ++it)
   {
      if (++FtofTruthExtraListCount > m_ftofTruthExtra_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ftofTruthHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FtofTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ftofTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FtofTruthExtraList_size", (char*)&m_ftofTruthExtra_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofTruthExtraList_offset", (char*)&m_ftofTruthExtra_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ftofTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ftofTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ftofTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ftofTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FtofTruthHit::hdf5DataPack()
{
   m_ftofTruthExtra_list.deflate();
}
void FtofTruthHit::hdf5DataUnpack()
{
   {
      std::list<FtofTruthExtra*> *host_plist = &m_host->m_ftofTruthExtra_plist;
      m_ftofTruthExtra_list.inflate(m_host, host_plist, this);
      FtofTruthExtraList::iterator iter;
      for (iter = m_ftofTruthExtra_list.begin();
           iter != m_ftofTruthExtra_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FtofCounter::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ftofCounter"
        << " bar=" << m_bar
        << " plane=" << m_plane
             << std::endl;
   int FtofHitListCount=0;
   for (FtofHitList::iterator it = m_ftofHit_list.begin();
        it != m_ftofHit_list.end(); ++it)
   {
      if (++FtofHitListCount > m_ftofHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FtofTruthHitListCount=0;
   for (FtofTruthHitList::iterator it = m_ftofTruthHit_list.begin();
        it != m_ftofTruthHit_list.end(); ++it)
   {
      if (++FtofTruthHitListCount > m_ftofTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FtofCounter::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ftofCounter"
        << " bar=" << "\"" << getBar() << "\""
        << " plane=" << "\"" << getPlane() << "\""
        << ">" << std::endl;
   int FtofHitListCount=0;
   for (FtofHitList::iterator it = m_ftofHit_list.begin();
        it != m_ftofHit_list.end(); ++it)
   {
      if (++FtofHitListCount > m_ftofHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FtofTruthHitListCount=0;
   for (FtofTruthHitList::iterator it = m_ftofTruthHit_list.begin();
        it != m_ftofTruthHit_list.end(); ++it)
   {
      if (++FtofTruthHitListCount > m_ftofTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ftofCounter>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FtofCounter::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ftofCounter");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "bar", (char*)&m_bar - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "plane", (char*)&m_plane - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FtofHitList_size", (char*)&m_ftofHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofHitList_offset", (char*)&m_ftofHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofTruthHitList_size", (char*)&m_ftofTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofTruthHitList_offset", (char*)&m_ftofTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ftofCounter"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ftofCounter"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ftofCounter", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ftofCounter", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FtofCounter::hdf5DataPack()
{
   m_ftofHit_list.deflate();
   m_ftofTruthHit_list.deflate();
}
void FtofCounter::hdf5DataUnpack()
{
   {
      std::list<FtofHit*> *host_plist = &m_host->m_ftofHit_plist;
      m_ftofHit_list.inflate(m_host, host_plist, this);
      FtofHitList::iterator iter;
      for (iter = m_ftofHit_list.begin();
           iter != m_ftofHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FtofTruthHit*> *host_plist = &m_host->m_ftofTruthHit_plist;
      m_ftofTruthHit_list.inflate(m_host, host_plist, this);
      FtofTruthHitList::iterator iter;
      for (iter = m_ftofTruthHit_list.begin();
           iter != m_ftofTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FtofTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ftofTruthPoint"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FtofTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ftofTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ftofTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FtofTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ftofTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ftofTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ftofTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ftofTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ftofTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FtofTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void FtofTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ForwardTOF::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "forwardTOF"
             << std::endl;
   int FtofCounterListCount=0;
   for (FtofCounterList::iterator it = m_ftofCounter_list.begin();
        it != m_ftofCounter_list.end(); ++it)
   {
      if (++FtofCounterListCount > m_ftofCounter_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FtofTruthPointListCount=0;
   for (FtofTruthPointList::iterator it = m_ftofTruthPoint_list.begin();
        it != m_ftofTruthPoint_list.end(); ++it)
   {
      if (++FtofTruthPointListCount > m_ftofTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string ForwardTOF::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<forwardTOF"
        << ">" << std::endl;
   int FtofCounterListCount=0;
   for (FtofCounterList::iterator it = m_ftofCounter_list.begin();
        it != m_ftofCounter_list.end(); ++it)
   {
      if (++FtofCounterListCount > m_ftofCounter_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FtofTruthPointListCount=0;
   for (FtofTruthPointList::iterator it = m_ftofTruthPoint_list.begin();
        it != m_ftofTruthPoint_list.end(); ++it)
   {
      if (++FtofTruthPointListCount > m_ftofTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</forwardTOF>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ForwardTOF::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("forwardTOF");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "FtofCounterList_size", (char*)&m_ftofCounter_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofCounterList_offset", (char*)&m_ftofCounter_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofTruthPointList_size", (char*)&m_ftofTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FtofTruthPointList_offset", (char*)&m_ftofTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["forwardTOF"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["forwardTOF"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "forwardTOF", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "forwardTOF", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ForwardTOF::hdf5DataPack()
{
   m_ftofCounter_list.deflate();
   m_ftofTruthPoint_list.deflate();
}
void ForwardTOF::hdf5DataUnpack()
{
   {
      std::list<FtofCounter*> *host_plist = &m_host->m_ftofCounter_plist;
      m_ftofCounter_list.inflate(m_host, host_plist, this);
      FtofCounterList::iterator iter;
      for (iter = m_ftofCounter_list.begin();
           iter != m_ftofCounter_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FtofTruthPoint*> *host_plist = &m_host->m_ftofTruthPoint_plist;
      m_ftofTruthPoint_list.inflate(m_host, host_plist, this);
      FtofTruthPointList::iterator iter;
      for (iter = m_ftofTruthPoint_list.begin();
           iter != m_ftofTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FcalDigihit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalDigihit"
        << " integralOverPeak=" << m_integralOverPeak
             << std::endl;
   return ostr.str();
}

std::string FcalDigihit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalDigihit"
        << " integralOverPeak=" << "\"" << getIntegralOverPeak() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalDigihit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalDigihit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "integralOverPeak", (char*)&m_integralOverPeak - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalDigihit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalDigihit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalDigihit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalDigihit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalDigihit::hdf5DataPack()
{
}
void FcalDigihit::hdf5DataUnpack()
{
}
#endif

std::string FcalHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   if (! m_fcalDigihit_link.empty()) {
      ostr << m_fcalDigihit_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FcalHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   if (! m_fcalDigihit_link.empty()) {
      ostr << m_fcalDigihit_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fcalHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FcalDigihitList_size", (char*)&m_fcalDigihit_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalDigihitList_offset", (char*)&m_fcalDigihit_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalHit::hdf5DataPack()
{
   m_fcalDigihit_link.deflate();
}
void FcalHit::hdf5DataUnpack()
{
   {
      std::list<FcalDigihit*> *host_plist = &m_host->m_fcalDigihit_plist;
      m_fcalDigihit_link.inflate(m_host, host_plist, this);
      FcalDigihitList::iterator iter;
      for (iter = m_fcalDigihit_link.begin();
           iter != m_fcalDigihit_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FcalTruthLightGuide::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalTruthLightGuide"
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string FcalTruthLightGuide::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalTruthLightGuide"
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalTruthLightGuide::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalTruthLightGuide");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalTruthLightGuide"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalTruthLightGuide"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalTruthLightGuide", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalTruthLightGuide", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalTruthLightGuide::hdf5DataPack()
{
}
void FcalTruthLightGuide::hdf5DataUnpack()
{
}
#endif

std::string FcalTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalTruthHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   int FcalTruthLightGuideListCount=0;
   for (FcalTruthLightGuideList::iterator it = m_fcalTruthLightGuide_list.begin();
        it != m_fcalTruthLightGuide_list.end(); ++it)
   {
      if (++FcalTruthLightGuideListCount > m_fcalTruthLightGuide_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FcalTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalTruthHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   int FcalTruthLightGuideListCount=0;
   for (FcalTruthLightGuideList::iterator it = m_fcalTruthLightGuide_list.begin();
        it != m_fcalTruthLightGuide_list.end(); ++it)
   {
      if (++FcalTruthLightGuideListCount > m_fcalTruthLightGuide_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fcalTruthHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FcalTruthLightGuideList_size", (char*)&m_fcalTruthLightGuide_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalTruthLightGuideList_offset", (char*)&m_fcalTruthLightGuide_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalTruthHit::hdf5DataPack()
{
   m_fcalTruthLightGuide_list.deflate();
}
void FcalTruthHit::hdf5DataUnpack()
{
   {
      std::list<FcalTruthLightGuide*> *host_plist = &m_host->m_fcalTruthLightGuide_plist;
      m_fcalTruthLightGuide_list.inflate(m_host, host_plist, this);
      FcalTruthLightGuideList::iterator iter;
      for (iter = m_fcalTruthLightGuide_list.begin();
           iter != m_fcalTruthLightGuide_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FcalBlock::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalBlock"
        << " column=" << m_column
        << " row=" << m_row
             << std::endl;
   int FcalHitListCount=0;
   for (FcalHitList::iterator it = m_fcalHit_list.begin();
        it != m_fcalHit_list.end(); ++it)
   {
      if (++FcalHitListCount > m_fcalHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FcalTruthHitListCount=0;
   for (FcalTruthHitList::iterator it = m_fcalTruthHit_list.begin();
        it != m_fcalTruthHit_list.end(); ++it)
   {
      if (++FcalTruthHitListCount > m_fcalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FcalBlock::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalBlock"
        << " column=" << "\"" << getColumn() << "\""
        << " row=" << "\"" << getRow() << "\""
        << ">" << std::endl;
   int FcalHitListCount=0;
   for (FcalHitList::iterator it = m_fcalHit_list.begin();
        it != m_fcalHit_list.end(); ++it)
   {
      if (++FcalHitListCount > m_fcalHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FcalTruthHitListCount=0;
   for (FcalTruthHitList::iterator it = m_fcalTruthHit_list.begin();
        it != m_fcalTruthHit_list.end(); ++it)
   {
      if (++FcalTruthHitListCount > m_fcalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fcalBlock>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalBlock::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalBlock");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "row", (char*)&m_row - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FcalHitList_size", (char*)&m_fcalHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalHitList_offset", (char*)&m_fcalHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalTruthHitList_size", (char*)&m_fcalTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalTruthHitList_offset", (char*)&m_fcalTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalBlock"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalBlock"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalBlock", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalBlock", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalBlock::hdf5DataPack()
{
   m_fcalHit_list.deflate();
   m_fcalTruthHit_list.deflate();
}
void FcalBlock::hdf5DataUnpack()
{
   {
      std::list<FcalHit*> *host_plist = &m_host->m_fcalHit_plist;
      m_fcalHit_list.inflate(m_host, host_plist, this);
      FcalHitList::iterator iter;
      for (iter = m_fcalHit_list.begin();
           iter != m_fcalHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalTruthHit*> *host_plist = &m_host->m_fcalTruthHit_plist;
      m_fcalTruthHit_list.inflate(m_host, host_plist, this);
      FcalTruthHitList::iterator iter;
      for (iter = m_fcalTruthHit_list.begin();
           iter != m_fcalTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FcalTruthShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fcalTruthShower"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FcalTruthShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fcalTruthShower"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fcalTruthShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FcalTruthShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fcalTruthShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fcalTruthShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fcalTruthShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fcalTruthShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fcalTruthShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FcalTruthShower::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void FcalTruthShower::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ForwardEMcal::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "forwardEMcal"
             << std::endl;
   int FcalBlockListCount=0;
   for (FcalBlockList::iterator it = m_fcalBlock_list.begin();
        it != m_fcalBlock_list.end(); ++it)
   {
      if (++FcalBlockListCount > m_fcalBlock_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FcalTruthShowerListCount=0;
   for (FcalTruthShowerList::iterator it = m_fcalTruthShower_list.begin();
        it != m_fcalTruthShower_list.end(); ++it)
   {
      if (++FcalTruthShowerListCount > m_fcalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string ForwardEMcal::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<forwardEMcal"
        << ">" << std::endl;
   int FcalBlockListCount=0;
   for (FcalBlockList::iterator it = m_fcalBlock_list.begin();
        it != m_fcalBlock_list.end(); ++it)
   {
      if (++FcalBlockListCount > m_fcalBlock_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FcalTruthShowerListCount=0;
   for (FcalTruthShowerList::iterator it = m_fcalTruthShower_list.begin();
        it != m_fcalTruthShower_list.end(); ++it)
   {
      if (++FcalTruthShowerListCount > m_fcalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</forwardEMcal>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ForwardEMcal::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("forwardEMcal");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "FcalBlockList_size", (char*)&m_fcalBlock_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalBlockList_offset", (char*)&m_fcalBlock_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalTruthShowerList_size", (char*)&m_fcalTruthShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FcalTruthShowerList_offset", (char*)&m_fcalTruthShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["forwardEMcal"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["forwardEMcal"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "forwardEMcal", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "forwardEMcal", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ForwardEMcal::hdf5DataPack()
{
   m_fcalBlock_list.deflate();
   m_fcalTruthShower_list.deflate();
}
void ForwardEMcal::hdf5DataUnpack()
{
   {
      std::list<FcalBlock*> *host_plist = &m_host->m_fcalBlock_plist;
      m_fcalBlock_list.inflate(m_host, host_plist, this);
      FcalBlockList::iterator iter;
      for (iter = m_fcalBlock_list.begin();
           iter != m_fcalBlock_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FcalTruthShower*> *host_plist = &m_host->m_fcalTruthShower_plist;
      m_fcalTruthShower_list.inflate(m_host, host_plist, this);
      FcalTruthShowerList::iterator iter;
      for (iter = m_fcalTruthShower_list.begin();
           iter != m_fcalTruthShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string EcalHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ecalHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string EcalHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ecalHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t EcalHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ecalHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ecalHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ecalHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ecalHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ecalHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void EcalHit::hdf5DataPack()
{
}
void EcalHit::hdf5DataUnpack()
{
}
#endif

std::string EcalTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ecalTruthHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string EcalTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ecalTruthHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t EcalTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ecalTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ecalTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ecalTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ecalTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ecalTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void EcalTruthHit::hdf5DataPack()
{
}
void EcalTruthHit::hdf5DataUnpack()
{
}
#endif

std::string EcalBlock::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ecalBlock"
        << " column=" << m_column
        << " row=" << m_row
             << std::endl;
   int EcalHitListCount=0;
   for (EcalHitList::iterator it = m_ecalHit_list.begin();
        it != m_ecalHit_list.end(); ++it)
   {
      if (++EcalHitListCount > m_ecalHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int EcalTruthHitListCount=0;
   for (EcalTruthHitList::iterator it = m_ecalTruthHit_list.begin();
        it != m_ecalTruthHit_list.end(); ++it)
   {
      if (++EcalTruthHitListCount > m_ecalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string EcalBlock::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ecalBlock"
        << " column=" << "\"" << getColumn() << "\""
        << " row=" << "\"" << getRow() << "\""
        << ">" << std::endl;
   int EcalHitListCount=0;
   for (EcalHitList::iterator it = m_ecalHit_list.begin();
        it != m_ecalHit_list.end(); ++it)
   {
      if (++EcalHitListCount > m_ecalHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int EcalTruthHitListCount=0;
   for (EcalTruthHitList::iterator it = m_ecalTruthHit_list.begin();
        it != m_ecalTruthHit_list.end(); ++it)
   {
      if (++EcalTruthHitListCount > m_ecalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ecalBlock>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t EcalBlock::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ecalBlock");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "row", (char*)&m_row - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "EcalHitList_size", (char*)&m_ecalHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "EcalHitList_offset", (char*)&m_ecalHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "EcalTruthHitList_size", (char*)&m_ecalTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "EcalTruthHitList_offset", (char*)&m_ecalTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ecalBlock"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ecalBlock"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ecalBlock", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ecalBlock", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void EcalBlock::hdf5DataPack()
{
   m_ecalHit_list.deflate();
   m_ecalTruthHit_list.deflate();
}
void EcalBlock::hdf5DataUnpack()
{
   {
      std::list<EcalHit*> *host_plist = &m_host->m_ecalHit_plist;
      m_ecalHit_list.inflate(m_host, host_plist, this);
      EcalHitList::iterator iter;
      for (iter = m_ecalHit_list.begin();
           iter != m_ecalHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<EcalTruthHit*> *host_plist = &m_host->m_ecalTruthHit_plist;
      m_ecalTruthHit_list.inflate(m_host, host_plist, this);
      EcalTruthHitList::iterator iter;
      for (iter = m_ecalTruthHit_list.begin();
           iter != m_ecalTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string EcalTruthShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ecalTruthShower"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string EcalTruthShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ecalTruthShower"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ecalTruthShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t EcalTruthShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ecalTruthShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ecalTruthShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ecalTruthShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ecalTruthShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ecalTruthShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void EcalTruthShower::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void EcalTruthShower::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CrystalEcal::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "CrystalEcal"
             << std::endl;
   int EcalBlockListCount=0;
   for (EcalBlockList::iterator it = m_ecalBlock_list.begin();
        it != m_ecalBlock_list.end(); ++it)
   {
      if (++EcalBlockListCount > m_ecalBlock_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int EcalTruthShowerListCount=0;
   for (EcalTruthShowerList::iterator it = m_ecalTruthShower_list.begin();
        it != m_ecalTruthShower_list.end(); ++it)
   {
      if (++EcalTruthShowerListCount > m_ecalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string CrystalEcal::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<CrystalEcal"
        << ">" << std::endl;
   int EcalBlockListCount=0;
   for (EcalBlockList::iterator it = m_ecalBlock_list.begin();
        it != m_ecalBlock_list.end(); ++it)
   {
      if (++EcalBlockListCount > m_ecalBlock_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int EcalTruthShowerListCount=0;
   for (EcalTruthShowerList::iterator it = m_ecalTruthShower_list.begin();
        it != m_ecalTruthShower_list.end(); ++it)
   {
      if (++EcalTruthShowerListCount > m_ecalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</CrystalEcal>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CrystalEcal::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("CrystalEcal");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "EcalBlockList_size", (char*)&m_ecalBlock_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "EcalBlockList_offset", (char*)&m_ecalBlock_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "EcalTruthShowerList_size", (char*)&m_ecalTruthShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "EcalTruthShowerList_offset", (char*)&m_ecalTruthShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["CrystalEcal"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["CrystalEcal"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "CrystalEcal", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "CrystalEcal", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CrystalEcal::hdf5DataPack()
{
   m_ecalBlock_list.deflate();
   m_ecalTruthShower_list.deflate();
}
void CrystalEcal::hdf5DataUnpack()
{
   {
      std::list<EcalBlock*> *host_plist = &m_host->m_ecalBlock_plist;
      m_ecalBlock_list.inflate(m_host, host_plist, this);
      EcalBlockList::iterator iter;
      for (iter = m_ecalBlock_list.begin();
           iter != m_ecalBlock_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<EcalTruthShower*> *host_plist = &m_host->m_ecalTruthShower_plist;
      m_ecalTruthShower_list.inflate(m_host, host_plist, this);
      EcalTruthShowerList::iterator iter;
      for (iter = m_ecalTruthShower_list.begin();
           iter != m_ecalTruthShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CcalHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccalHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string CcalHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccalHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcalHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccalHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccalHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccalHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccalHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccalHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcalHit::hdf5DataPack()
{
}
void CcalHit::hdf5DataUnpack()
{
}
#endif

std::string CcalTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccalTruthHit"
        << " E=" << m_E
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string CcalTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccalTruthHit"
        << " E=" << "\"" << getE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcalTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccalTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccalTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccalTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccalTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccalTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcalTruthHit::hdf5DataPack()
{
}
void CcalTruthHit::hdf5DataUnpack()
{
}
#endif

std::string CcalBlock::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccalBlock"
        << " column=" << m_column
        << " row=" << m_row
             << std::endl;
   int CcalHitListCount=0;
   for (CcalHitList::iterator it = m_ccalHit_list.begin();
        it != m_ccalHit_list.end(); ++it)
   {
      if (++CcalHitListCount > m_ccalHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CcalTruthHitListCount=0;
   for (CcalTruthHitList::iterator it = m_ccalTruthHit_list.begin();
        it != m_ccalTruthHit_list.end(); ++it)
   {
      if (++CcalTruthHitListCount > m_ccalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string CcalBlock::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccalBlock"
        << " column=" << "\"" << getColumn() << "\""
        << " row=" << "\"" << getRow() << "\""
        << ">" << std::endl;
   int CcalHitListCount=0;
   for (CcalHitList::iterator it = m_ccalHit_list.begin();
        it != m_ccalHit_list.end(); ++it)
   {
      if (++CcalHitListCount > m_ccalHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CcalTruthHitListCount=0;
   for (CcalTruthHitList::iterator it = m_ccalTruthHit_list.begin();
        it != m_ccalTruthHit_list.end(); ++it)
   {
      if (++CcalTruthHitListCount > m_ccalTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ccalBlock>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcalBlock::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccalBlock");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "row", (char*)&m_row - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "CcalHitList_size", (char*)&m_ccalHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalHitList_offset", (char*)&m_ccalHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalTruthHitList_size", (char*)&m_ccalTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalTruthHitList_offset", (char*)&m_ccalTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccalBlock"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccalBlock"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccalBlock", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccalBlock", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcalBlock::hdf5DataPack()
{
   m_ccalHit_list.deflate();
   m_ccalTruthHit_list.deflate();
}
void CcalBlock::hdf5DataUnpack()
{
   {
      std::list<CcalHit*> *host_plist = &m_host->m_ccalHit_plist;
      m_ccalHit_list.inflate(m_host, host_plist, this);
      CcalHitList::iterator iter;
      for (iter = m_ccalHit_list.begin();
           iter != m_ccalHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CcalTruthHit*> *host_plist = &m_host->m_ccalTruthHit_plist;
      m_ccalTruthHit_list.inflate(m_host, host_plist, this);
      CcalTruthHitList::iterator iter;
      for (iter = m_ccalTruthHit_list.begin();
           iter != m_ccalTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CcalTruthShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ccalTruthShower"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string CcalTruthShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ccalTruthShower"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ccalTruthShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CcalTruthShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ccalTruthShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ccalTruthShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ccalTruthShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ccalTruthShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ccalTruthShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CcalTruthShower::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void CcalTruthShower::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ComptonEMcal::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ComptonEMcal"
             << std::endl;
   int CcalBlockListCount=0;
   for (CcalBlockList::iterator it = m_ccalBlock_list.begin();
        it != m_ccalBlock_list.end(); ++it)
   {
      if (++CcalBlockListCount > m_ccalBlock_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CcalTruthShowerListCount=0;
   for (CcalTruthShowerList::iterator it = m_ccalTruthShower_list.begin();
        it != m_ccalTruthShower_list.end(); ++it)
   {
      if (++CcalTruthShowerListCount > m_ccalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string ComptonEMcal::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ComptonEMcal"
        << ">" << std::endl;
   int CcalBlockListCount=0;
   for (CcalBlockList::iterator it = m_ccalBlock_list.begin();
        it != m_ccalBlock_list.end(); ++it)
   {
      if (++CcalBlockListCount > m_ccalBlock_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CcalTruthShowerListCount=0;
   for (CcalTruthShowerList::iterator it = m_ccalTruthShower_list.begin();
        it != m_ccalTruthShower_list.end(); ++it)
   {
      if (++CcalTruthShowerListCount > m_ccalTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ComptonEMcal>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ComptonEMcal::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ComptonEMcal");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "CcalBlockList_size", (char*)&m_ccalBlock_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalBlockList_offset", (char*)&m_ccalBlock_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalTruthShowerList_size", (char*)&m_ccalTruthShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcalTruthShowerList_offset", (char*)&m_ccalTruthShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ComptonEMcal"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ComptonEMcal"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ComptonEMcal", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ComptonEMcal", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ComptonEMcal::hdf5DataPack()
{
   m_ccalBlock_list.deflate();
   m_ccalTruthShower_list.deflate();
}
void ComptonEMcal::hdf5DataUnpack()
{
   {
      std::list<CcalBlock*> *host_plist = &m_host->m_ccalBlock_plist;
      m_ccalBlock_list.inflate(m_host, host_plist, this);
      CcalBlockList::iterator iter;
      for (iter = m_ccalBlock_list.begin();
           iter != m_ccalBlock_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CcalTruthShower*> *host_plist = &m_host->m_ccalTruthShower_plist;
      m_ccalTruthShower_list.inflate(m_host, host_plist, this);
      CcalTruthShowerList::iterator iter;
      for (iter = m_ccalTruthShower_list.begin();
           iter != m_ccalTruthShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string UpvHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "upvHit"
        << " E=" << m_E
        << " end=" << m_end
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string UpvHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<upvHit"
        << " E=" << "\"" << getE() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UpvHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("upvHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["upvHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["upvHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "upvHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "upvHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UpvHit::hdf5DataPack()
{
}
void UpvHit::hdf5DataUnpack()
{
}
#endif

std::string UpvTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "upvTruthHit"
        << " E=" << m_E
        << " end=" << m_end
        << " t=" << m_t
        << " xlocal=" << m_xlocal
             << std::endl;
   return ostr.str();
}

std::string UpvTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<upvTruthHit"
        << " E=" << "\"" << getE() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << " xlocal=" << "\"" << getXlocal() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UpvTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("upvTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "xlocal", (char*)&m_xlocal - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["upvTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["upvTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "upvTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "upvTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UpvTruthHit::hdf5DataPack()
{
}
void UpvTruthHit::hdf5DataUnpack()
{
}
#endif

std::string UpvPaddle::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "upvPaddle"
        << " layer=" << m_layer
        << " row=" << m_row
             << std::endl;
   int UpvHitListCount=0;
   for (UpvHitList::iterator it = m_upvHit_list.begin();
        it != m_upvHit_list.end(); ++it)
   {
      if (++UpvHitListCount > m_upvHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int UpvTruthHitListCount=0;
   for (UpvTruthHitList::iterator it = m_upvTruthHit_list.begin();
        it != m_upvTruthHit_list.end(); ++it)
   {
      if (++UpvTruthHitListCount > m_upvTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string UpvPaddle::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<upvPaddle"
        << " layer=" << "\"" << getLayer() << "\""
        << " row=" << "\"" << getRow() << "\""
        << ">" << std::endl;
   int UpvHitListCount=0;
   for (UpvHitList::iterator it = m_upvHit_list.begin();
        it != m_upvHit_list.end(); ++it)
   {
      if (++UpvHitListCount > m_upvHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int UpvTruthHitListCount=0;
   for (UpvTruthHitList::iterator it = m_upvTruthHit_list.begin();
        it != m_upvTruthHit_list.end(); ++it)
   {
      if (++UpvTruthHitListCount > m_upvTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</upvPaddle>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UpvPaddle::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("upvPaddle");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "layer", (char*)&m_layer - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "row", (char*)&m_row - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "UpvHitList_size", (char*)&m_upvHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpvHitList_offset", (char*)&m_upvHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpvTruthHitList_size", (char*)&m_upvTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpvTruthHitList_offset", (char*)&m_upvTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["upvPaddle"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["upvPaddle"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "upvPaddle", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "upvPaddle", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UpvPaddle::hdf5DataPack()
{
   m_upvHit_list.deflate();
   m_upvTruthHit_list.deflate();
}
void UpvPaddle::hdf5DataUnpack()
{
   {
      std::list<UpvHit*> *host_plist = &m_host->m_upvHit_plist;
      m_upvHit_list.inflate(m_host, host_plist, this);
      UpvHitList::iterator iter;
      for (iter = m_upvHit_list.begin();
           iter != m_upvHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<UpvTruthHit*> *host_plist = &m_host->m_upvTruthHit_plist;
      m_upvTruthHit_list.inflate(m_host, host_plist, this);
      UpvTruthHitList::iterator iter;
      for (iter = m_upvTruthHit_list.begin();
           iter != m_upvTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string UpvTruthShower::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "upvTruthShower"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string UpvTruthShower::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<upvTruthShower"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</upvTruthShower>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UpvTruthShower::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("upvTruthShower");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["upvTruthShower"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["upvTruthShower"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "upvTruthShower", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "upvTruthShower", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UpvTruthShower::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void UpvTruthShower::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string UpstreamEMveto::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "upstreamEMveto"
             << std::endl;
   int UpvPaddleListCount=0;
   for (UpvPaddleList::iterator it = m_upvPaddle_list.begin();
        it != m_upvPaddle_list.end(); ++it)
   {
      if (++UpvPaddleListCount > m_upvPaddle_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int UpvTruthShowerListCount=0;
   for (UpvTruthShowerList::iterator it = m_upvTruthShower_list.begin();
        it != m_upvTruthShower_list.end(); ++it)
   {
      if (++UpvTruthShowerListCount > m_upvTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string UpstreamEMveto::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<upstreamEMveto"
        << ">" << std::endl;
   int UpvPaddleListCount=0;
   for (UpvPaddleList::iterator it = m_upvPaddle_list.begin();
        it != m_upvPaddle_list.end(); ++it)
   {
      if (++UpvPaddleListCount > m_upvPaddle_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int UpvTruthShowerListCount=0;
   for (UpvTruthShowerList::iterator it = m_upvTruthShower_list.begin();
        it != m_upvTruthShower_list.end(); ++it)
   {
      if (++UpvTruthShowerListCount > m_upvTruthShower_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</upstreamEMveto>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t UpstreamEMveto::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("upstreamEMveto");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "UpvPaddleList_size", (char*)&m_upvPaddle_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpvPaddleList_offset", (char*)&m_upvPaddle_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpvTruthShowerList_size", (char*)&m_upvTruthShower_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpvTruthShowerList_offset", (char*)&m_upvTruthShower_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["upstreamEMveto"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["upstreamEMveto"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "upstreamEMveto", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "upstreamEMveto", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void UpstreamEMveto::hdf5DataPack()
{
   m_upvPaddle_list.deflate();
   m_upvTruthShower_list.deflate();
}
void UpstreamEMveto::hdf5DataUnpack()
{
   {
      std::list<UpvPaddle*> *host_plist = &m_host->m_upvPaddle_plist;
      m_upvPaddle_list.inflate(m_host, host_plist, this);
      UpvPaddleList::iterator iter;
      for (iter = m_upvPaddle_list.begin();
           iter != m_upvPaddle_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<UpvTruthShower*> *host_plist = &m_host->m_upvTruthShower_plist;
      m_upvTruthShower_list.inflate(m_host, host_plist, this);
      UpvTruthShowerList::iterator iter;
      for (iter = m_upvTruthShower_list.begin();
           iter != m_upvTruthShower_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TaggerHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "taggerHit"
        << " npe=" << m_npe
        << " t=" << m_t
        << " tADC=" << m_tADC
             << std::endl;
   return ostr.str();
}

std::string TaggerHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<taggerHit"
        << " npe=" << "\"" << getNpe() << "\""
        << " t=" << "\"" << getT() << "\""
        << " tADC=" << "\"" << getTADC() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TaggerHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("taggerHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "npe", (char*)&m_npe - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "tADC", (char*)&m_tADC - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["taggerHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["taggerHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "taggerHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "taggerHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TaggerHit::hdf5DataPack()
{
}
void TaggerHit::hdf5DataUnpack()
{
}
#endif

std::string TaggerTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "taggerTruthHit"
        << " E=" << m_E
        << " bg=" << m_bg
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string TaggerTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<taggerTruthHit"
        << " E=" << "\"" << getE() << "\""
        << " bg=" << "\"" << getBg() << "\""
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TaggerTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("taggerTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "bg", (char*)&m_bg - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["taggerTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["taggerTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "taggerTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "taggerTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TaggerTruthHit::hdf5DataPack()
{
}
void TaggerTruthHit::hdf5DataUnpack()
{
}
#endif

std::string MicroChannel::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "microChannel"
        << " E=" << m_E
        << " column=" << m_column
        << " row=" << m_row
             << std::endl;
   int TaggerHitListCount=0;
   for (TaggerHitList::iterator it = m_taggerHit_list.begin();
        it != m_taggerHit_list.end(); ++it)
   {
      if (++TaggerHitListCount > m_taggerHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TaggerTruthHitListCount=0;
   for (TaggerTruthHitList::iterator it = m_taggerTruthHit_list.begin();
        it != m_taggerTruthHit_list.end(); ++it)
   {
      if (++TaggerTruthHitListCount > m_taggerTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string MicroChannel::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<microChannel"
        << " E=" << "\"" << getE() << "\""
        << " column=" << "\"" << getColumn() << "\""
        << " row=" << "\"" << getRow() << "\""
        << ">" << std::endl;
   int TaggerHitListCount=0;
   for (TaggerHitList::iterator it = m_taggerHit_list.begin();
        it != m_taggerHit_list.end(); ++it)
   {
      if (++TaggerHitListCount > m_taggerHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TaggerTruthHitListCount=0;
   for (TaggerTruthHitList::iterator it = m_taggerTruthHit_list.begin();
        it != m_taggerTruthHit_list.end(); ++it)
   {
      if (++TaggerTruthHitListCount > m_taggerTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</microChannel>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t MicroChannel::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("microChannel");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "row", (char*)&m_row - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "TaggerHitList_size", (char*)&m_taggerHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerHitList_offset", (char*)&m_taggerHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerTruthHitList_size", (char*)&m_taggerTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerTruthHitList_offset", (char*)&m_taggerTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["microChannel"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["microChannel"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "microChannel", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "microChannel", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void MicroChannel::hdf5DataPack()
{
   m_taggerHit_list.deflate();
   m_taggerTruthHit_list.deflate();
}
void MicroChannel::hdf5DataUnpack()
{
   {
      std::list<TaggerHit*> *host_plist = &m_host->m_taggerHit_plist;
      m_taggerHit_list.inflate(m_host, host_plist, this);
      TaggerHitList::iterator iter;
      for (iter = m_taggerHit_list.begin();
           iter != m_taggerHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TaggerTruthHit*> *host_plist = &m_host->m_taggerTruthHit_plist;
      m_taggerTruthHit_list.inflate(m_host, host_plist, this);
      TaggerTruthHitList::iterator iter;
      for (iter = m_taggerTruthHit_list.begin();
           iter != m_taggerTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string HodoChannel::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "hodoChannel"
        << " E=" << m_E
        << " counterId=" << m_counterId
             << std::endl;
   int TaggerHitListCount=0;
   for (TaggerHitList::iterator it = m_taggerHit_list.begin();
        it != m_taggerHit_list.end(); ++it)
   {
      if (++TaggerHitListCount > m_taggerHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TaggerTruthHitListCount=0;
   for (TaggerTruthHitList::iterator it = m_taggerTruthHit_list.begin();
        it != m_taggerTruthHit_list.end(); ++it)
   {
      if (++TaggerTruthHitListCount > m_taggerTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string HodoChannel::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<hodoChannel"
        << " E=" << "\"" << getE() << "\""
        << " counterId=" << "\"" << getCounterId() << "\""
        << ">" << std::endl;
   int TaggerHitListCount=0;
   for (TaggerHitList::iterator it = m_taggerHit_list.begin();
        it != m_taggerHit_list.end(); ++it)
   {
      if (++TaggerHitListCount > m_taggerHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TaggerTruthHitListCount=0;
   for (TaggerTruthHitList::iterator it = m_taggerTruthHit_list.begin();
        it != m_taggerTruthHit_list.end(); ++it)
   {
      if (++TaggerTruthHitListCount > m_taggerTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</hodoChannel>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t HodoChannel::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("hodoChannel");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "counterId", (char*)&m_counterId - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "TaggerHitList_size", (char*)&m_taggerHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerHitList_offset", (char*)&m_taggerHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerTruthHitList_size", (char*)&m_taggerTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerTruthHitList_offset", (char*)&m_taggerTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["hodoChannel"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["hodoChannel"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "hodoChannel", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "hodoChannel", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void HodoChannel::hdf5DataPack()
{
   m_taggerHit_list.deflate();
   m_taggerTruthHit_list.deflate();
}
void HodoChannel::hdf5DataUnpack()
{
   {
      std::list<TaggerHit*> *host_plist = &m_host->m_taggerHit_plist;
      m_taggerHit_list.inflate(m_host, host_plist, this);
      TaggerHitList::iterator iter;
      for (iter = m_taggerHit_list.begin();
           iter != m_taggerHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TaggerTruthHit*> *host_plist = &m_host->m_taggerTruthHit_plist;
      m_taggerTruthHit_list.inflate(m_host, host_plist, this);
      TaggerTruthHitList::iterator iter;
      for (iter = m_taggerTruthHit_list.begin();
           iter != m_taggerTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string Tagger::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tagger"
             << std::endl;
   int MicroChannelListCount=0;
   for (MicroChannelList::iterator it = m_microChannel_list.begin();
        it != m_microChannel_list.end(); ++it)
   {
      if (++MicroChannelListCount > m_microChannel_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int HodoChannelListCount=0;
   for (HodoChannelList::iterator it = m_hodoChannel_list.begin();
        it != m_hodoChannel_list.end(); ++it)
   {
      if (++HodoChannelListCount > m_hodoChannel_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string Tagger::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tagger"
        << ">" << std::endl;
   int MicroChannelListCount=0;
   for (MicroChannelList::iterator it = m_microChannel_list.begin();
        it != m_microChannel_list.end(); ++it)
   {
      if (++MicroChannelListCount > m_microChannel_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int HodoChannelListCount=0;
   for (HodoChannelList::iterator it = m_hodoChannel_list.begin();
        it != m_hodoChannel_list.end(); ++it)
   {
      if (++HodoChannelListCount > m_hodoChannel_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tagger>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Tagger::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tagger");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "MicroChannelList_size", (char*)&m_microChannel_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "MicroChannelList_offset", (char*)&m_microChannel_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HodoChannelList_size", (char*)&m_hodoChannel_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HodoChannelList_offset", (char*)&m_hodoChannel_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tagger"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tagger"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tagger", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tagger", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Tagger::hdf5DataPack()
{
   m_microChannel_list.deflate();
   m_hodoChannel_list.deflate();
}
void Tagger::hdf5DataUnpack()
{
   {
      std::list<MicroChannel*> *host_plist = &m_host->m_microChannel_plist;
      m_microChannel_list.inflate(m_host, host_plist, this);
      MicroChannelList::iterator iter;
      for (iter = m_microChannel_list.begin();
           iter != m_microChannel_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<HodoChannel*> *host_plist = &m_host->m_hodoChannel_plist;
      m_hodoChannel_list.inflate(m_host, host_plist, this);
      HodoChannelList::iterator iter;
      for (iter = m_hodoChannel_list.begin();
           iter != m_hodoChannel_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string PsHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "psHit"
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string PsHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<psHit"
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PsHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("psHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["psHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["psHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "psHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "psHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PsHit::hdf5DataPack()
{
}
void PsHit::hdf5DataUnpack()
{
}
#endif

std::string PsTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "psTruthHit"
        << " dE=" << m_dE
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string PsTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<psTruthHit"
        << " dE=" << "\"" << getDE() << "\""
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PsTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("psTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["psTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["psTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "psTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "psTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PsTruthHit::hdf5DataPack()
{
}
void PsTruthHit::hdf5DataUnpack()
{
}
#endif

std::string PsTile::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "psTile"
        << " arm=" << m_arm
        << " column=" << m_column
             << std::endl;
   int PsHitListCount=0;
   for (PsHitList::iterator it = m_psHit_list.begin();
        it != m_psHit_list.end(); ++it)
   {
      if (++PsHitListCount > m_psHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int PsTruthHitListCount=0;
   for (PsTruthHitList::iterator it = m_psTruthHit_list.begin();
        it != m_psTruthHit_list.end(); ++it)
   {
      if (++PsTruthHitListCount > m_psTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string PsTile::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<psTile"
        << " arm=" << "\"" << getArm() << "\""
        << " column=" << "\"" << getColumn() << "\""
        << ">" << std::endl;
   int PsHitListCount=0;
   for (PsHitList::iterator it = m_psHit_list.begin();
        it != m_psHit_list.end(); ++it)
   {
      if (++PsHitListCount > m_psHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int PsTruthHitListCount=0;
   for (PsTruthHitList::iterator it = m_psTruthHit_list.begin();
        it != m_psTruthHit_list.end(); ++it)
   {
      if (++PsTruthHitListCount > m_psTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</psTile>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PsTile::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("psTile");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "arm", (char*)&m_arm - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "PsHitList_size", (char*)&m_psHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PsHitList_offset", (char*)&m_psHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PsTruthHitList_size", (char*)&m_psTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PsTruthHitList_offset", (char*)&m_psTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["psTile"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["psTile"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "psTile", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "psTile", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PsTile::hdf5DataPack()
{
   m_psHit_list.deflate();
   m_psTruthHit_list.deflate();
}
void PsTile::hdf5DataUnpack()
{
   {
      std::list<PsHit*> *host_plist = &m_host->m_psHit_plist;
      m_psHit_list.inflate(m_host, host_plist, this);
      PsHitList::iterator iter;
      for (iter = m_psHit_list.begin();
           iter != m_psHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<PsTruthHit*> *host_plist = &m_host->m_psTruthHit_plist;
      m_psTruthHit_list.inflate(m_host, host_plist, this);
      PsTruthHitList::iterator iter;
      for (iter = m_psTruthHit_list.begin();
           iter != m_psTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string PsTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "psTruthPoint"
        << " E=" << m_E
        << " arm=" << m_arm
        << " column=" << m_column
        << " dEdx=" << m_dEdx
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string PsTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<psTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " arm=" << "\"" << getArm() << "\""
        << " column=" << "\"" << getColumn() << "\""
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</psTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PsTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("psTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "arm", (char*)&m_arm - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "column", (char*)&m_column - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["psTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["psTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "psTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "psTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PsTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void PsTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string PairSpectrometerFine::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "pairSpectrometerFine"
             << std::endl;
   int PsTileListCount=0;
   for (PsTileList::iterator it = m_psTile_list.begin();
        it != m_psTile_list.end(); ++it)
   {
      if (++PsTileListCount > m_psTile_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int PsTruthPointListCount=0;
   for (PsTruthPointList::iterator it = m_psTruthPoint_list.begin();
        it != m_psTruthPoint_list.end(); ++it)
   {
      if (++PsTruthPointListCount > m_psTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string PairSpectrometerFine::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<pairSpectrometerFine"
        << ">" << std::endl;
   int PsTileListCount=0;
   for (PsTileList::iterator it = m_psTile_list.begin();
        it != m_psTile_list.end(); ++it)
   {
      if (++PsTileListCount > m_psTile_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int PsTruthPointListCount=0;
   for (PsTruthPointList::iterator it = m_psTruthPoint_list.begin();
        it != m_psTruthPoint_list.end(); ++it)
   {
      if (++PsTruthPointListCount > m_psTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</pairSpectrometerFine>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PairSpectrometerFine::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("pairSpectrometerFine");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "PsTileList_size", (char*)&m_psTile_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PsTileList_offset", (char*)&m_psTile_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PsTruthPointList_size", (char*)&m_psTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PsTruthPointList_offset", (char*)&m_psTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["pairSpectrometerFine"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["pairSpectrometerFine"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "pairSpectrometerFine", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "pairSpectrometerFine", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PairSpectrometerFine::hdf5DataPack()
{
   m_psTile_list.deflate();
   m_psTruthPoint_list.deflate();
}
void PairSpectrometerFine::hdf5DataUnpack()
{
   {
      std::list<PsTile*> *host_plist = &m_host->m_psTile_plist;
      m_psTile_list.inflate(m_host, host_plist, this);
      PsTileList::iterator iter;
      for (iter = m_psTile_list.begin();
           iter != m_psTile_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<PsTruthPoint*> *host_plist = &m_host->m_psTruthPoint_plist;
      m_psTruthPoint_list.inflate(m_host, host_plist, this);
      PsTruthPointList::iterator iter;
      for (iter = m_psTruthPoint_list.begin();
           iter != m_psTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string PscHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "pscHit"
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string PscHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<pscHit"
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PscHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("pscHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["pscHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["pscHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "pscHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "pscHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PscHit::hdf5DataPack()
{
}
void PscHit::hdf5DataUnpack()
{
}
#endif

std::string PscTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "pscTruthHit"
        << " dE=" << m_dE
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string PscTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<pscTruthHit"
        << " dE=" << "\"" << getDE() << "\""
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PscTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("pscTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["pscTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["pscTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "pscTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "pscTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PscTruthHit::hdf5DataPack()
{
}
void PscTruthHit::hdf5DataUnpack()
{
}
#endif

std::string PscPaddle::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "pscPaddle"
        << " arm=" << m_arm
        << " module=" << m_module
             << std::endl;
   int PscHitListCount=0;
   for (PscHitList::iterator it = m_pscHit_list.begin();
        it != m_pscHit_list.end(); ++it)
   {
      if (++PscHitListCount > m_pscHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int PscTruthHitListCount=0;
   for (PscTruthHitList::iterator it = m_pscTruthHit_list.begin();
        it != m_pscTruthHit_list.end(); ++it)
   {
      if (++PscTruthHitListCount > m_pscTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string PscPaddle::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<pscPaddle"
        << " arm=" << "\"" << getArm() << "\""
        << " module=" << "\"" << getModule() << "\""
        << ">" << std::endl;
   int PscHitListCount=0;
   for (PscHitList::iterator it = m_pscHit_list.begin();
        it != m_pscHit_list.end(); ++it)
   {
      if (++PscHitListCount > m_pscHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int PscTruthHitListCount=0;
   for (PscTruthHitList::iterator it = m_pscTruthHit_list.begin();
        it != m_pscTruthHit_list.end(); ++it)
   {
      if (++PscTruthHitListCount > m_pscTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</pscPaddle>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PscPaddle::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("pscPaddle");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "arm", (char*)&m_arm - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "module", (char*)&m_module - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "PscHitList_size", (char*)&m_pscHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PscHitList_offset", (char*)&m_pscHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PscTruthHitList_size", (char*)&m_pscTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PscTruthHitList_offset", (char*)&m_pscTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["pscPaddle"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["pscPaddle"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "pscPaddle", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "pscPaddle", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PscPaddle::hdf5DataPack()
{
   m_pscHit_list.deflate();
   m_pscTruthHit_list.deflate();
}
void PscPaddle::hdf5DataUnpack()
{
   {
      std::list<PscHit*> *host_plist = &m_host->m_pscHit_plist;
      m_pscHit_list.inflate(m_host, host_plist, this);
      PscHitList::iterator iter;
      for (iter = m_pscHit_list.begin();
           iter != m_pscHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<PscTruthHit*> *host_plist = &m_host->m_pscTruthHit_plist;
      m_pscTruthHit_list.inflate(m_host, host_plist, this);
      PscTruthHitList::iterator iter;
      for (iter = m_pscTruthHit_list.begin();
           iter != m_pscTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string PscTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "pscTruthPoint"
        << " E=" << m_E
        << " arm=" << m_arm
        << " dEdx=" << m_dEdx
        << " module=" << m_module
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string PscTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<pscTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " arm=" << "\"" << getArm() << "\""
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " module=" << "\"" << getModule() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</pscTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PscTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("pscTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "arm", (char*)&m_arm - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "module", (char*)&m_module - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["pscTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["pscTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "pscTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "pscTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PscTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void PscTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string PairSpectrometerCoarse::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "pairSpectrometerCoarse"
             << std::endl;
   int PscPaddleListCount=0;
   for (PscPaddleList::iterator it = m_pscPaddle_list.begin();
        it != m_pscPaddle_list.end(); ++it)
   {
      if (++PscPaddleListCount > m_pscPaddle_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int PscTruthPointListCount=0;
   for (PscTruthPointList::iterator it = m_pscTruthPoint_list.begin();
        it != m_pscTruthPoint_list.end(); ++it)
   {
      if (++PscTruthPointListCount > m_pscTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string PairSpectrometerCoarse::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<pairSpectrometerCoarse"
        << ">" << std::endl;
   int PscPaddleListCount=0;
   for (PscPaddleList::iterator it = m_pscPaddle_list.begin();
        it != m_pscPaddle_list.end(); ++it)
   {
      if (++PscPaddleListCount > m_pscPaddle_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int PscTruthPointListCount=0;
   for (PscTruthPointList::iterator it = m_pscTruthPoint_list.begin();
        it != m_pscTruthPoint_list.end(); ++it)
   {
      if (++PscTruthPointListCount > m_pscTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</pairSpectrometerCoarse>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PairSpectrometerCoarse::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("pairSpectrometerCoarse");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "PscPaddleList_size", (char*)&m_pscPaddle_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PscPaddleList_offset", (char*)&m_pscPaddle_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PscTruthPointList_size", (char*)&m_pscTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PscTruthPointList_offset", (char*)&m_pscTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["pairSpectrometerCoarse"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["pairSpectrometerCoarse"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "pairSpectrometerCoarse", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "pairSpectrometerCoarse", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PairSpectrometerCoarse::hdf5DataPack()
{
   m_pscPaddle_list.deflate();
   m_pscTruthPoint_list.deflate();
}
void PairSpectrometerCoarse::hdf5DataUnpack()
{
   {
      std::list<PscPaddle*> *host_plist = &m_host->m_pscPaddle_plist;
      m_pscPaddle_list.inflate(m_host, host_plist, this);
      PscPaddleList::iterator iter;
      for (iter = m_pscPaddle_list.begin();
           iter != m_pscPaddle_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<PscTruthPoint*> *host_plist = &m_host->m_pscTruthPoint_plist;
      m_pscTruthPoint_list.inflate(m_host, host_plist, this);
      PscTruthPointList::iterator iter;
      for (iter = m_pscTruthPoint_list.begin();
           iter != m_pscTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TpolHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tpolHit"
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string TpolHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tpolHit"
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TpolHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tpolHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tpolHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tpolHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tpolHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tpolHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TpolHit::hdf5DataPack()
{
}
void TpolHit::hdf5DataUnpack()
{
}
#endif

std::string TpolTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tpolTruthHit"
        << " dE=" << m_dE
        << " itrack=" << m_itrack
        << " ptype=" << m_ptype
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string TpolTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tpolTruthHit"
        << " dE=" << "\"" << getDE() << "\""
        << " itrack=" << "\"" << getItrack() << "\""
        << " ptype=" << "\"" << getPtype() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TpolTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tpolTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "itrack", (char*)&m_itrack - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tpolTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tpolTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tpolTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tpolTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TpolTruthHit::hdf5DataPack()
{
}
void TpolTruthHit::hdf5DataUnpack()
{
}
#endif

std::string TpolSector::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tpolSector"
        << " ring=" << m_ring
        << " sector=" << m_sector
             << std::endl;
   int TpolHitListCount=0;
   for (TpolHitList::iterator it = m_tpolHit_list.begin();
        it != m_tpolHit_list.end(); ++it)
   {
      if (++TpolHitListCount > m_tpolHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TpolTruthHitListCount=0;
   for (TpolTruthHitList::iterator it = m_tpolTruthHit_list.begin();
        it != m_tpolTruthHit_list.end(); ++it)
   {
      if (++TpolTruthHitListCount > m_tpolTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string TpolSector::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tpolSector"
        << " ring=" << "\"" << getRing() << "\""
        << " sector=" << "\"" << getSector() << "\""
        << ">" << std::endl;
   int TpolHitListCount=0;
   for (TpolHitList::iterator it = m_tpolHit_list.begin();
        it != m_tpolHit_list.end(); ++it)
   {
      if (++TpolHitListCount > m_tpolHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TpolTruthHitListCount=0;
   for (TpolTruthHitList::iterator it = m_tpolTruthHit_list.begin();
        it != m_tpolTruthHit_list.end(); ++it)
   {
      if (++TpolTruthHitListCount > m_tpolTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tpolSector>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TpolSector::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tpolSector");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "ring", (char*)&m_ring - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "sector", (char*)&m_sector - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "TpolHitList_size", (char*)&m_tpolHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TpolHitList_offset", (char*)&m_tpolHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TpolTruthHitList_size", (char*)&m_tpolTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TpolTruthHitList_offset", (char*)&m_tpolTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tpolSector"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tpolSector"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tpolSector", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tpolSector", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TpolSector::hdf5DataPack()
{
   m_tpolHit_list.deflate();
   m_tpolTruthHit_list.deflate();
}
void TpolSector::hdf5DataUnpack()
{
   {
      std::list<TpolHit*> *host_plist = &m_host->m_tpolHit_plist;
      m_tpolHit_list.inflate(m_host, host_plist, this);
      TpolHitList::iterator iter;
      for (iter = m_tpolHit_list.begin();
           iter != m_tpolHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TpolTruthHit*> *host_plist = &m_host->m_tpolTruthHit_plist;
      m_tpolTruthHit_list.inflate(m_host, host_plist, this);
      TpolTruthHitList::iterator iter;
      for (iter = m_tpolTruthHit_list.begin();
           iter != m_tpolTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TpolTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tpolTruthPoint"
        << " E=" << m_E
        << " dEdx=" << m_dEdx
        << " phi=" << m_phi
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " r=" << m_r
        << " t=" << m_t
        << " track=" << m_track
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string TpolTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tpolTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " dEdx=" << "\"" << getDEdx() << "\""
        << " phi=" << "\"" << getPhi() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " r=" << "\"" << getR() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tpolTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TpolTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tpolTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dEdx", (char*)&m_dEdx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "phi", (char*)&m_phi - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "r", (char*)&m_r - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tpolTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tpolTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tpolTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tpolTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TpolTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void TpolTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string TripletPolarimeter::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tripletPolarimeter"
             << std::endl;
   int TpolSectorListCount=0;
   for (TpolSectorList::iterator it = m_tpolSector_list.begin();
        it != m_tpolSector_list.end(); ++it)
   {
      if (++TpolSectorListCount > m_tpolSector_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int TpolTruthPointListCount=0;
   for (TpolTruthPointList::iterator it = m_tpolTruthPoint_list.begin();
        it != m_tpolTruthPoint_list.end(); ++it)
   {
      if (++TpolTruthPointListCount > m_tpolTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string TripletPolarimeter::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tripletPolarimeter"
        << ">" << std::endl;
   int TpolSectorListCount=0;
   for (TpolSectorList::iterator it = m_tpolSector_list.begin();
        it != m_tpolSector_list.end(); ++it)
   {
      if (++TpolSectorListCount > m_tpolSector_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int TpolTruthPointListCount=0;
   for (TpolTruthPointList::iterator it = m_tpolTruthPoint_list.begin();
        it != m_tpolTruthPoint_list.end(); ++it)
   {
      if (++TpolTruthPointListCount > m_tpolTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tripletPolarimeter>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TripletPolarimeter::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tripletPolarimeter");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "TpolSectorList_size", (char*)&m_tpolSector_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TpolSectorList_offset", (char*)&m_tpolSector_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TpolTruthPointList_size", (char*)&m_tpolTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TpolTruthPointList_offset", (char*)&m_tpolTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tripletPolarimeter"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tripletPolarimeter"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tripletPolarimeter", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tripletPolarimeter", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TripletPolarimeter::hdf5DataPack()
{
   m_tpolSector_list.deflate();
   m_tpolTruthPoint_list.deflate();
}
void TripletPolarimeter::hdf5DataUnpack()
{
   {
      std::list<TpolSector*> *host_plist = &m_host->m_tpolSector_plist;
      m_tpolSector_list.inflate(m_host, host_plist, this);
      TpolSectorList::iterator iter;
      for (iter = m_tpolSector_list.begin();
           iter != m_tpolSector_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TpolTruthPoint*> *host_plist = &m_host->m_tpolTruthPoint_plist;
      m_tpolTruthPoint_list.inflate(m_host, host_plist, this);
      TpolTruthPointList::iterator iter;
      for (iter = m_tpolTruthPoint_list.begin();
           iter != m_tpolTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string McTrajectoryPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "mcTrajectoryPoint"
        << " E=" << m_E
        << " dE=" << m_dE
        << " mech=" << m_mech
        << " part=" << m_part
        << " primary_track=" << m_primary_track
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " radlen=" << m_radlen
        << " step=" << m_step
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   return ostr.str();
}

std::string McTrajectoryPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<mcTrajectoryPoint"
        << " E=" << "\"" << getE() << "\""
        << " dE=" << "\"" << getDE() << "\""
        << " mech=" << "\"" << getMech() << "\""
        << " part=" << "\"" << getPart() << "\""
        << " primary_track=" << "\"" << getPrimary_track() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " radlen=" << "\"" << getRadlen() << "\""
        << " step=" << "\"" << getStep() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t McTrajectoryPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("mcTrajectoryPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "mech", (char*)&m_mech - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "part", (char*)&m_part - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "primary_track", (char*)&m_primary_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "radlen", (char*)&m_radlen - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "step", (char*)&m_step - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["mcTrajectoryPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["mcTrajectoryPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "mcTrajectoryPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "mcTrajectoryPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void McTrajectoryPoint::hdf5DataPack()
{
}
void McTrajectoryPoint::hdf5DataUnpack()
{
}
#endif

std::string McTrajectory::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "mcTrajectory"
             << std::endl;
   int McTrajectoryPointListCount=0;
   for (McTrajectoryPointList::iterator it = m_mcTrajectoryPoint_list.begin();
        it != m_mcTrajectoryPoint_list.end(); ++it)
   {
      if (++McTrajectoryPointListCount > m_mcTrajectoryPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string McTrajectory::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<mcTrajectory"
        << ">" << std::endl;
   int McTrajectoryPointListCount=0;
   for (McTrajectoryPointList::iterator it = m_mcTrajectoryPoint_list.begin();
        it != m_mcTrajectoryPoint_list.end(); ++it)
   {
      if (++McTrajectoryPointListCount > m_mcTrajectoryPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</mcTrajectory>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t McTrajectory::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("mcTrajectory");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "McTrajectoryPointList_size", (char*)&m_mcTrajectoryPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "McTrajectoryPointList_offset", (char*)&m_mcTrajectoryPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["mcTrajectory"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["mcTrajectory"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "mcTrajectory", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "mcTrajectory", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void McTrajectory::hdf5DataPack()
{
   m_mcTrajectoryPoint_list.deflate();
}
void McTrajectory::hdf5DataUnpack()
{
   {
      std::list<McTrajectoryPoint*> *host_plist = &m_host->m_mcTrajectoryPoint_plist;
      m_mcTrajectoryPoint_list.inflate(m_host, host_plist, this);
      McTrajectoryPointList::iterator iter;
      for (iter = m_mcTrajectoryPoint_list.begin();
           iter != m_mcTrajectoryPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string RFsubsystem::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "RFsubsystem"
        << " jtag=" << "\"" << m_jtag << "\""
        << " tsync=" << m_tsync
             << std::endl;
   return ostr.str();
}

std::string RFsubsystem::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<RFsubsystem"
        << " jtag=" << "\"" << getJtag() << "\""
        << " tsync=" << "\"" << getTsync() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t RFsubsystem::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("RFsubsystem");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "tsync", (char*)&m_tsync - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["RFsubsystem"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["RFsubsystem"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "RFsubsystem", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "RFsubsystem", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void RFsubsystem::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
}
void RFsubsystem::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
}
#endif

std::string RFtime::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "RFtime"
        << " jtag=" << "\"" << m_jtag << "\""
        << " tsync=" << m_tsync
             << std::endl;
   int RFsubsystemListCount=0;
   for (RFsubsystemList::iterator it = m_RFsubsystem_list.begin();
        it != m_RFsubsystem_list.end(); ++it)
   {
      if (++RFsubsystemListCount > m_RFsubsystem_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string RFtime::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<RFtime"
        << " jtag=" << "\"" << getJtag() << "\""
        << " tsync=" << "\"" << getTsync() << "\""
        << " tunit=" << "\"" << getTunit() << "\""
        << ">" << std::endl;
   int RFsubsystemListCount=0;
   for (RFsubsystemList::iterator it = m_RFsubsystem_list.begin();
        it != m_RFsubsystem_list.end(); ++it)
   {
      if (++RFsubsystemListCount > m_RFsubsystem_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</RFtime>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t RFtime::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("RFtime");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "jtag", (char*)&mx_jtag - (char*)this, vl_string_tid);
   H5Tinsert(tid, "tsync", (char*)&m_tsync - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "RFsubsystemList_size", (char*)&m_RFsubsystem_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RFsubsystemList_offset", (char*)&m_RFsubsystem_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["RFtime"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["RFtime"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "RFtime", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "RFtime", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void RFtime::hdf5DataPack()
{
   mx_jtag = m_jtag.c_str();
   m_RFsubsystem_list.deflate();
}
void RFtime::hdf5DataUnpack()
{
   new(&m_jtag) std::string();
   if (mx_jtag != 0) {
      m_jtag = mx_jtag;
      m_host->m_hdf5_strings.push_back(&m_jtag);
   }
   {
      std::list<RFsubsystem*> *host_plist = &m_host->m_RFsubsystem_plist;
      m_RFsubsystem_list.inflate(m_host, host_plist, this);
      RFsubsystemList::iterator iter;
      for (iter = m_RFsubsystem_list.begin();
           iter != m_RFsubsystem_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FmwpcTruthHitQ::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcTruthHitQ"
        << " d=" << m_d
        << " q=" << m_q
             << std::endl;
   return ostr.str();
}

std::string FmwpcTruthHitQ::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcTruthHitQ"
        << " d=" << "\"" << getD() << "\""
        << " q=" << "\"" << getQ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcTruthHitQ::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcTruthHitQ");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "d", (char*)&m_d - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "q", (char*)&m_q - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcTruthHitQ"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcTruthHitQ"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcTruthHitQ", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcTruthHitQ", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcTruthHitQ::hdf5DataPack()
{
}
void FmwpcTruthHitQ::hdf5DataUnpack()
{
}
#endif

std::string FmwpcTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcTruthHit"
        << " dE=" << m_dE
        << " dx=" << m_dx
        << " t=" << m_t
             << std::endl;
   int FmwpcTruthHitQListCount=0;
   for (FmwpcTruthHitQList::iterator it = m_fmwpcTruthHitQ_list.begin();
        it != m_fmwpcTruthHitQ_list.end(); ++it)
   {
      if (++FmwpcTruthHitQListCount > m_fmwpcTruthHitQ_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FmwpcTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcTruthHit"
        << " dE=" << "\"" << getDE() << "\""
        << " dx=" << "\"" << getDx() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   int FmwpcTruthHitQListCount=0;
   for (FmwpcTruthHitQList::iterator it = m_fmwpcTruthHitQ_list.begin();
        it != m_fmwpcTruthHitQ_list.end(); ++it)
   {
      if (++FmwpcTruthHitQListCount > m_fmwpcTruthHitQ_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fmwpcTruthHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "dx", (char*)&m_dx - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FmwpcTruthHitQList_size", (char*)&m_fmwpcTruthHitQ_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcTruthHitQList_offset", (char*)&m_fmwpcTruthHitQ_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcTruthHit::hdf5DataPack()
{
   m_fmwpcTruthHitQ_list.deflate();
}
void FmwpcTruthHit::hdf5DataUnpack()
{
   {
      std::list<FmwpcTruthHitQ*> *host_plist = &m_host->m_fmwpcTruthHitQ_plist;
      m_fmwpcTruthHitQ_list.inflate(m_host, host_plist, this);
      FmwpcTruthHitQList::iterator iter;
      for (iter = m_fmwpcTruthHitQ_list.begin();
           iter != m_fmwpcTruthHitQ_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FmwpcHitQ::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcHitQ"
        << " q=" << m_q
             << std::endl;
   return ostr.str();
}

std::string FmwpcHitQ::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcHitQ"
        << " q=" << "\"" << getQ() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcHitQ::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcHitQ");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "q", (char*)&m_q - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcHitQ"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcHitQ"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcHitQ", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcHitQ", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcHitQ::hdf5DataPack()
{
}
void FmwpcHitQ::hdf5DataUnpack()
{
}
#endif

std::string FmwpcHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcHit"
        << " dE=" << m_dE
        << " t=" << m_t
             << std::endl;
   int FmwpcHitQListCount=0;
   for (FmwpcHitQList::iterator it = m_fmwpcHitQ_list.begin();
        it != m_fmwpcHitQ_list.end(); ++it)
   {
      if (++FmwpcHitQListCount > m_fmwpcHitQ_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FmwpcHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcHit"
        << " dE=" << "\"" << getDE() << "\""
        << " t=" << "\"" << getT() << "\""
        << ">" << std::endl;
   int FmwpcHitQListCount=0;
   for (FmwpcHitQList::iterator it = m_fmwpcHitQ_list.begin();
        it != m_fmwpcHitQ_list.end(); ++it)
   {
      if (++FmwpcHitQListCount > m_fmwpcHitQ_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fmwpcHit>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "FmwpcHitQList_size", (char*)&m_fmwpcHitQ_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcHitQList_offset", (char*)&m_fmwpcHitQ_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcHit::hdf5DataPack()
{
   m_fmwpcHitQ_list.deflate();
}
void FmwpcHit::hdf5DataUnpack()
{
   {
      std::list<FmwpcHitQ*> *host_plist = &m_host->m_fmwpcHitQ_plist;
      m_fmwpcHitQ_list.inflate(m_host, host_plist, this);
      FmwpcHitQList::iterator iter;
      for (iter = m_fmwpcHitQ_list.begin();
           iter != m_fmwpcHitQ_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FmwpcChamber::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcChamber"
        << " layer=" << m_layer
        << " wire=" << m_wire
             << std::endl;
   int FmwpcTruthHitListCount=0;
   for (FmwpcTruthHitList::iterator it = m_fmwpcTruthHit_list.begin();
        it != m_fmwpcTruthHit_list.end(); ++it)
   {
      if (++FmwpcTruthHitListCount > m_fmwpcTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FmwpcHitListCount=0;
   for (FmwpcHitList::iterator it = m_fmwpcHit_list.begin();
        it != m_fmwpcHit_list.end(); ++it)
   {
      if (++FmwpcHitListCount > m_fmwpcHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string FmwpcChamber::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcChamber"
        << " layer=" << "\"" << getLayer() << "\""
        << " wire=" << "\"" << getWire() << "\""
        << ">" << std::endl;
   int FmwpcTruthHitListCount=0;
   for (FmwpcTruthHitList::iterator it = m_fmwpcTruthHit_list.begin();
        it != m_fmwpcTruthHit_list.end(); ++it)
   {
      if (++FmwpcTruthHitListCount > m_fmwpcTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FmwpcHitListCount=0;
   for (FmwpcHitList::iterator it = m_fmwpcHit_list.begin();
        it != m_fmwpcHit_list.end(); ++it)
   {
      if (++FmwpcHitListCount > m_fmwpcHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fmwpcChamber>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcChamber::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcChamber");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "layer", (char*)&m_layer - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "wire", (char*)&m_wire - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "FmwpcTruthHitList_size", (char*)&m_fmwpcTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcTruthHitList_offset", (char*)&m_fmwpcTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcHitList_size", (char*)&m_fmwpcHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcHitList_offset", (char*)&m_fmwpcHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcChamber"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcChamber"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcChamber", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcChamber", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcChamber::hdf5DataPack()
{
   m_fmwpcTruthHit_list.deflate();
   m_fmwpcHit_list.deflate();
}
void FmwpcChamber::hdf5DataUnpack()
{
   {
      std::list<FmwpcTruthHit*> *host_plist = &m_host->m_fmwpcTruthHit_plist;
      m_fmwpcTruthHit_list.inflate(m_host, host_plist, this);
      FmwpcTruthHitList::iterator iter;
      for (iter = m_fmwpcTruthHit_list.begin();
           iter != m_fmwpcTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FmwpcHit*> *host_plist = &m_host->m_fmwpcHit_plist;
      m_fmwpcHit_list.inflate(m_host, host_plist, this);
      FmwpcHitList::iterator iter;
      for (iter = m_fmwpcHit_list.begin();
           iter != m_fmwpcHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string FmwpcTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "fmwpcTruthPoint"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string FmwpcTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<fmwpcTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</fmwpcTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t FmwpcTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("fmwpcTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["fmwpcTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["fmwpcTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "fmwpcTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void FmwpcTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void FmwpcTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ForwardMWPC::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "forwardMWPC"
             << std::endl;
   int FmwpcChamberListCount=0;
   for (FmwpcChamberList::iterator it = m_fmwpcChamber_list.begin();
        it != m_fmwpcChamber_list.end(); ++it)
   {
      if (++FmwpcChamberListCount > m_fmwpcChamber_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int FmwpcTruthPointListCount=0;
   for (FmwpcTruthPointList::iterator it = m_fmwpcTruthPoint_list.begin();
        it != m_fmwpcTruthPoint_list.end(); ++it)
   {
      if (++FmwpcTruthPointListCount > m_fmwpcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string ForwardMWPC::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<forwardMWPC"
        << ">" << std::endl;
   int FmwpcChamberListCount=0;
   for (FmwpcChamberList::iterator it = m_fmwpcChamber_list.begin();
        it != m_fmwpcChamber_list.end(); ++it)
   {
      if (++FmwpcChamberListCount > m_fmwpcChamber_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int FmwpcTruthPointListCount=0;
   for (FmwpcTruthPointList::iterator it = m_fmwpcTruthPoint_list.begin();
        it != m_fmwpcTruthPoint_list.end(); ++it)
   {
      if (++FmwpcTruthPointListCount > m_fmwpcTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</forwardMWPC>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ForwardMWPC::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("forwardMWPC");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "FmwpcChamberList_size", (char*)&m_fmwpcChamber_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcChamberList_offset", (char*)&m_fmwpcChamber_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcTruthPointList_size", (char*)&m_fmwpcTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "FmwpcTruthPointList_offset", (char*)&m_fmwpcTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["forwardMWPC"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["forwardMWPC"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "forwardMWPC", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "forwardMWPC", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ForwardMWPC::hdf5DataPack()
{
   m_fmwpcChamber_list.deflate();
   m_fmwpcTruthPoint_list.deflate();
}
void ForwardMWPC::hdf5DataUnpack()
{
   {
      std::list<FmwpcChamber*> *host_plist = &m_host->m_fmwpcChamber_plist;
      m_fmwpcChamber_list.inflate(m_host, host_plist, this);
      FmwpcChamberList::iterator iter;
      for (iter = m_fmwpcChamber_list.begin();
           iter != m_fmwpcChamber_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<FmwpcTruthPoint*> *host_plist = &m_host->m_fmwpcTruthPoint_plist;
      m_fmwpcTruthPoint_list.inflate(m_host, host_plist, this);
      FmwpcTruthPointList::iterator iter;
      for (iter = m_fmwpcTruthPoint_list.begin();
           iter != m_fmwpcTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CtofHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ctofHit"
        << " dE=" << m_dE
        << " end=" << m_end
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string CtofHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ctofHit"
        << " dE=" << "\"" << getDE() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CtofHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ctofHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ctofHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ctofHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ctofHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ctofHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CtofHit::hdf5DataPack()
{
}
void CtofHit::hdf5DataUnpack()
{
}
#endif

std::string CtofTruthHit::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ctofTruthHit"
        << " dE=" << m_dE
        << " end=" << m_end
        << " t=" << m_t
             << std::endl;
   return ostr.str();
}

std::string CtofTruthHit::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ctofTruthHit"
        << " dE=" << "\"" << getDE() << "\""
        << " end=" << "\"" << getEnd() << "\""
        << " t=" << "\"" << getT() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CtofTruthHit::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ctofTruthHit");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "dE", (char*)&m_dE - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "end", (char*)&m_end - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ctofTruthHit"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ctofTruthHit"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ctofTruthHit", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ctofTruthHit", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CtofTruthHit::hdf5DataPack()
{
}
void CtofTruthHit::hdf5DataUnpack()
{
}
#endif

std::string CtofCounter::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ctofCounter"
        << " bar=" << m_bar
             << std::endl;
   int CtofHitListCount=0;
   for (CtofHitList::iterator it = m_ctofHit_list.begin();
        it != m_ctofHit_list.end(); ++it)
   {
      if (++CtofHitListCount > m_ctofHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CtofTruthHitListCount=0;
   for (CtofTruthHitList::iterator it = m_ctofTruthHit_list.begin();
        it != m_ctofTruthHit_list.end(); ++it)
   {
      if (++CtofTruthHitListCount > m_ctofTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string CtofCounter::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ctofCounter"
        << " bar=" << "\"" << getBar() << "\""
        << ">" << std::endl;
   int CtofHitListCount=0;
   for (CtofHitList::iterator it = m_ctofHit_list.begin();
        it != m_ctofHit_list.end(); ++it)
   {
      if (++CtofHitListCount > m_ctofHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CtofTruthHitListCount=0;
   for (CtofTruthHitList::iterator it = m_ctofTruthHit_list.begin();
        it != m_ctofTruthHit_list.end(); ++it)
   {
      if (++CtofTruthHitListCount > m_ctofTruthHit_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ctofCounter>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CtofCounter::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ctofCounter");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "bar", (char*)&m_bar - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "CtofHitList_size", (char*)&m_ctofHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofHitList_offset", (char*)&m_ctofHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofTruthHitList_size", (char*)&m_ctofTruthHit_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofTruthHitList_offset", (char*)&m_ctofTruthHit_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ctofCounter"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ctofCounter"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ctofCounter", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ctofCounter", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CtofCounter::hdf5DataPack()
{
   m_ctofHit_list.deflate();
   m_ctofTruthHit_list.deflate();
}
void CtofCounter::hdf5DataUnpack()
{
   {
      std::list<CtofHit*> *host_plist = &m_host->m_ctofHit_plist;
      m_ctofHit_list.inflate(m_host, host_plist, this);
      CtofHitList::iterator iter;
      for (iter = m_ctofHit_list.begin();
           iter != m_ctofHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CtofTruthHit*> *host_plist = &m_host->m_ctofTruthHit_plist;
      m_ctofTruthHit_list.inflate(m_host, host_plist, this);
      CtofTruthHitList::iterator iter;
      for (iter = m_ctofTruthHit_list.begin();
           iter != m_ctofTruthHit_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CtofTruthPoint::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "ctofTruthPoint"
        << " E=" << m_E
        << " primary=" << ((m_primary == 0)? "true" : "false")
        << " ptype=" << m_ptype
        << " px=" << m_px
        << " py=" << m_py
        << " pz=" << m_pz
        << " t=" << m_t
        << " track=" << m_track
        << " x=" << m_x
        << " y=" << m_y
        << " z=" << m_z
             << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string CtofTruthPoint::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<ctofTruthPoint"
        << " E=" << "\"" << getE() << "\""
        << " primary=" << ((m_primary == 0)? "\"true\"" : "\"false\"")
        << " ptype=" << "\"" << getPtype() << "\""
        << " px=" << "\"" << getPx() << "\""
        << " py=" << "\"" << getPy() << "\""
        << " pz=" << "\"" << getPz() << "\""
        << " t=" << "\"" << getT() << "\""
        << " track=" << "\"" << getTrack() << "\""
        << " x=" << "\"" << getX() << "\""
        << " y=" << "\"" << getY() << "\""
        << " z=" << "\"" << getZ() << "\""
        << ">" << std::endl;
   if (! m_trackID_link.empty()) {
      ostr << m_trackID_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</ctofTruthPoint>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CtofTruthPoint::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("ctofTruthPoint");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "E", (char*)&m_E - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "primary", (char*)&m_primary - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "ptype", (char*)&m_ptype - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "px", (char*)&m_px - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "py", (char*)&m_py - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "pz", (char*)&m_pz - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "t", (char*)&m_t - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "track", (char*)&m_track - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "x", (char*)&m_x - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "y", (char*)&m_y - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "z", (char*)&m_z - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "TrackIDList_size", (char*)&m_trackID_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackIDList_offset", (char*)&m_trackID_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["ctofTruthPoint"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["ctofTruthPoint"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "ctofTruthPoint", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "ctofTruthPoint", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CtofTruthPoint::hdf5DataPack()
{
   m_trackID_link.deflate();
}
void CtofTruthPoint::hdf5DataUnpack()
{
   {
      std::list<TrackID*> *host_plist = &m_host->m_trackID_plist;
      m_trackID_link.inflate(m_host, host_plist, this);
      TrackIDList::iterator iter;
      for (iter = m_trackID_link.begin();
           iter != m_trackID_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string CppTOF::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "cppTOF"
             << std::endl;
   int CtofCounterListCount=0;
   for (CtofCounterList::iterator it = m_ctofCounter_list.begin();
        it != m_ctofCounter_list.end(); ++it)
   {
      if (++CtofCounterListCount > m_ctofCounter_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CtofTruthPointListCount=0;
   for (CtofTruthPointList::iterator it = m_ctofTruthPoint_list.begin();
        it != m_ctofTruthPoint_list.end(); ++it)
   {
      if (++CtofTruthPointListCount > m_ctofTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string CppTOF::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<cppTOF"
        << ">" << std::endl;
   int CtofCounterListCount=0;
   for (CtofCounterList::iterator it = m_ctofCounter_list.begin();
        it != m_ctofCounter_list.end(); ++it)
   {
      if (++CtofCounterListCount > m_ctofCounter_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CtofTruthPointListCount=0;
   for (CtofTruthPointList::iterator it = m_ctofTruthPoint_list.begin();
        it != m_ctofTruthPoint_list.end(); ++it)
   {
      if (++CtofTruthPointListCount > m_ctofTruthPoint_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</cppTOF>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t CppTOF::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("cppTOF");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "CtofCounterList_size", (char*)&m_ctofCounter_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofCounterList_offset", (char*)&m_ctofCounter_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofTruthPointList_size", (char*)&m_ctofTruthPoint_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CtofTruthPointList_offset", (char*)&m_ctofTruthPoint_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["cppTOF"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["cppTOF"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "cppTOF", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "cppTOF", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void CppTOF::hdf5DataPack()
{
   m_ctofCounter_list.deflate();
   m_ctofTruthPoint_list.deflate();
}
void CppTOF::hdf5DataUnpack()
{
   {
      std::list<CtofCounter*> *host_plist = &m_host->m_ctofCounter_plist;
      m_ctofCounter_list.inflate(m_host, host_plist, this);
      CtofCounterList::iterator iter;
      for (iter = m_ctofCounter_list.begin();
           iter != m_ctofCounter_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CtofTruthPoint*> *host_plist = &m_host->m_ctofTruthPoint_plist;
      m_ctofTruthPoint_list.inflate(m_host, host_plist, this);
      CtofTruthPointList::iterator iter;
      for (iter = m_ctofTruthPoint_list.begin();
           iter != m_ctofTruthPoint_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string HitView::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "hitView"
             << std::endl;
   if (! m_centralDC_link.empty()) {
      ostr << m_centralDC_link.begin()->toString(indent + 2);
   }
   if (! m_forwardDC_link.empty()) {
      ostr << m_forwardDC_link.begin()->toString(indent + 2);
   }
   if (! m_startCntr_link.empty()) {
      ostr << m_startCntr_link.begin()->toString(indent + 2);
   }
   if (! m_barrelEMcal_link.empty()) {
      ostr << m_barrelEMcal_link.begin()->toString(indent + 2);
   }
   if (! m_gapEMcal_link.empty()) {
      ostr << m_gapEMcal_link.begin()->toString(indent + 2);
   }
   if (! m_Cerenkov_link.empty()) {
      ostr << m_Cerenkov_link.begin()->toString(indent + 2);
   }
   if (! m_RICH_link.empty()) {
      ostr << m_RICH_link.begin()->toString(indent + 2);
   }
   if (! m_DIRC_link.empty()) {
      ostr << m_DIRC_link.begin()->toString(indent + 2);
   }
   if (! m_forwardTOF_link.empty()) {
      ostr << m_forwardTOF_link.begin()->toString(indent + 2);
   }
   if (! m_forwardEMcal_link.empty()) {
      ostr << m_forwardEMcal_link.begin()->toString(indent + 2);
   }
   if (! m_CrystalEcal_link.empty()) {
      ostr << m_CrystalEcal_link.begin()->toString(indent + 2);
   }
   if (! m_ComptonEMcal_link.empty()) {
      ostr << m_ComptonEMcal_link.begin()->toString(indent + 2);
   }
   if (! m_upstreamEMveto_link.empty()) {
      ostr << m_upstreamEMveto_link.begin()->toString(indent + 2);
   }
   if (! m_tagger_link.empty()) {
      ostr << m_tagger_link.begin()->toString(indent + 2);
   }
   if (! m_pairSpectrometerFine_link.empty()) {
      ostr << m_pairSpectrometerFine_link.begin()->toString(indent + 2);
   }
   if (! m_pairSpectrometerCoarse_link.empty()) {
      ostr << m_pairSpectrometerCoarse_link.begin()->toString(indent + 2);
   }
   if (! m_tripletPolarimeter_link.empty()) {
      ostr << m_tripletPolarimeter_link.begin()->toString(indent + 2);
   }
   if (! m_mcTrajectory_link.empty()) {
      ostr << m_mcTrajectory_link.begin()->toString(indent + 2);
   }
   if (! m_RFtime_link.empty()) {
      ostr << m_RFtime_link.begin()->toString(indent + 2);
   }
   if (! m_forwardMWPC_link.empty()) {
      ostr << m_forwardMWPC_link.begin()->toString(indent + 2);
   }
   if (! m_cppTOF_link.empty()) {
      ostr << m_cppTOF_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string HitView::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<hitView"
        << " version=" << "\"" << getVersion() << "\""
        << ">" << std::endl;
   if (! m_centralDC_link.empty()) {
      ostr << m_centralDC_link.begin()->toXML(indent + 2);
   }
   if (! m_forwardDC_link.empty()) {
      ostr << m_forwardDC_link.begin()->toXML(indent + 2);
   }
   if (! m_startCntr_link.empty()) {
      ostr << m_startCntr_link.begin()->toXML(indent + 2);
   }
   if (! m_barrelEMcal_link.empty()) {
      ostr << m_barrelEMcal_link.begin()->toXML(indent + 2);
   }
   if (! m_gapEMcal_link.empty()) {
      ostr << m_gapEMcal_link.begin()->toXML(indent + 2);
   }
   if (! m_Cerenkov_link.empty()) {
      ostr << m_Cerenkov_link.begin()->toXML(indent + 2);
   }
   if (! m_RICH_link.empty()) {
      ostr << m_RICH_link.begin()->toXML(indent + 2);
   }
   if (! m_DIRC_link.empty()) {
      ostr << m_DIRC_link.begin()->toXML(indent + 2);
   }
   if (! m_forwardTOF_link.empty()) {
      ostr << m_forwardTOF_link.begin()->toXML(indent + 2);
   }
   if (! m_forwardEMcal_link.empty()) {
      ostr << m_forwardEMcal_link.begin()->toXML(indent + 2);
   }
   if (! m_CrystalEcal_link.empty()) {
      ostr << m_CrystalEcal_link.begin()->toXML(indent + 2);
   }
   if (! m_ComptonEMcal_link.empty()) {
      ostr << m_ComptonEMcal_link.begin()->toXML(indent + 2);
   }
   if (! m_upstreamEMveto_link.empty()) {
      ostr << m_upstreamEMveto_link.begin()->toXML(indent + 2);
   }
   if (! m_tagger_link.empty()) {
      ostr << m_tagger_link.begin()->toXML(indent + 2);
   }
   if (! m_pairSpectrometerFine_link.empty()) {
      ostr << m_pairSpectrometerFine_link.begin()->toXML(indent + 2);
   }
   if (! m_pairSpectrometerCoarse_link.empty()) {
      ostr << m_pairSpectrometerCoarse_link.begin()->toXML(indent + 2);
   }
   if (! m_tripletPolarimeter_link.empty()) {
      ostr << m_tripletPolarimeter_link.begin()->toXML(indent + 2);
   }
   if (! m_mcTrajectory_link.empty()) {
      ostr << m_mcTrajectory_link.begin()->toXML(indent + 2);
   }
   if (! m_RFtime_link.empty()) {
      ostr << m_RFtime_link.begin()->toXML(indent + 2);
   }
   if (! m_forwardMWPC_link.empty()) {
      ostr << m_forwardMWPC_link.begin()->toXML(indent + 2);
   }
   if (! m_cppTOF_link.empty()) {
      ostr << m_cppTOF_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</hitView>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t HitView::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("hitView");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "CentralDCList_size", (char*)&m_centralDC_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CentralDCList_offset", (char*)&m_centralDC_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardDCList_size", (char*)&m_forwardDC_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardDCList_offset", (char*)&m_forwardDC_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StartCntrList_size", (char*)&m_startCntr_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "StartCntrList_offset", (char*)&m_startCntr_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BarrelEMcalList_size", (char*)&m_barrelEMcal_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "BarrelEMcalList_offset", (char*)&m_barrelEMcal_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GapEMcalList_size", (char*)&m_gapEMcal_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "GapEMcalList_offset", (char*)&m_gapEMcal_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CerenkovList_size", (char*)&m_Cerenkov_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CerenkovList_offset", (char*)&m_Cerenkov_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RICHList_size", (char*)&m_RICH_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RICHList_offset", (char*)&m_RICH_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DIRCList_size", (char*)&m_DIRC_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DIRCList_offset", (char*)&m_DIRC_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardTOFList_size", (char*)&m_forwardTOF_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardTOFList_offset", (char*)&m_forwardTOF_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardEMcalList_size", (char*)&m_forwardEMcal_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardEMcalList_offset", (char*)&m_forwardEMcal_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CrystalEcalList_size", (char*)&m_CrystalEcal_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CrystalEcalList_offset", (char*)&m_CrystalEcal_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ComptonEMcalList_size", (char*)&m_ComptonEMcal_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ComptonEMcalList_offset", (char*)&m_ComptonEMcal_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpstreamEMvetoList_size", (char*)&m_upstreamEMveto_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "UpstreamEMvetoList_offset", (char*)&m_upstreamEMveto_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerList_size", (char*)&m_tagger_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TaggerList_offset", (char*)&m_tagger_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PairSpectrometerFineList_size", (char*)&m_pairSpectrometerFine_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PairSpectrometerFineList_offset", (char*)&m_pairSpectrometerFine_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PairSpectrometerCoarseList_size", (char*)&m_pairSpectrometerCoarse_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PairSpectrometerCoarseList_offset", (char*)&m_pairSpectrometerCoarse_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TripletPolarimeterList_size", (char*)&m_tripletPolarimeter_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TripletPolarimeterList_offset", (char*)&m_tripletPolarimeter_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "McTrajectoryList_size", (char*)&m_mcTrajectory_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "McTrajectoryList_offset", (char*)&m_mcTrajectory_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RFtimeList_size", (char*)&m_RFtime_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "RFtimeList_offset", (char*)&m_RFtime_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardMWPCList_size", (char*)&m_forwardMWPC_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ForwardMWPCList_offset", (char*)&m_forwardMWPC_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CppTOFList_size", (char*)&m_cppTOF_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CppTOFList_offset", (char*)&m_cppTOF_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["hitView"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["hitView"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "hitView", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "hitView", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void HitView::hdf5DataPack()
{
   m_centralDC_link.deflate();
   m_forwardDC_link.deflate();
   m_startCntr_link.deflate();
   m_barrelEMcal_link.deflate();
   m_gapEMcal_link.deflate();
   m_Cerenkov_link.deflate();
   m_RICH_link.deflate();
   m_DIRC_link.deflate();
   m_forwardTOF_link.deflate();
   m_forwardEMcal_link.deflate();
   m_CrystalEcal_link.deflate();
   m_ComptonEMcal_link.deflate();
   m_upstreamEMveto_link.deflate();
   m_tagger_link.deflate();
   m_pairSpectrometerFine_link.deflate();
   m_pairSpectrometerCoarse_link.deflate();
   m_tripletPolarimeter_link.deflate();
   m_mcTrajectory_link.deflate();
   m_RFtime_link.deflate();
   m_forwardMWPC_link.deflate();
   m_cppTOF_link.deflate();
}
void HitView::hdf5DataUnpack()
{
   {
      std::list<CentralDC*> *host_plist = &m_host->m_centralDC_plist;
      m_centralDC_link.inflate(m_host, host_plist, this);
      CentralDCList::iterator iter;
      for (iter = m_centralDC_link.begin();
           iter != m_centralDC_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ForwardDC*> *host_plist = &m_host->m_forwardDC_plist;
      m_forwardDC_link.inflate(m_host, host_plist, this);
      ForwardDCList::iterator iter;
      for (iter = m_forwardDC_link.begin();
           iter != m_forwardDC_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<StartCntr*> *host_plist = &m_host->m_startCntr_plist;
      m_startCntr_link.inflate(m_host, host_plist, this);
      StartCntrList::iterator iter;
      for (iter = m_startCntr_link.begin();
           iter != m_startCntr_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<BarrelEMcal*> *host_plist = &m_host->m_barrelEMcal_plist;
      m_barrelEMcal_link.inflate(m_host, host_plist, this);
      BarrelEMcalList::iterator iter;
      for (iter = m_barrelEMcal_link.begin();
           iter != m_barrelEMcal_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<GapEMcal*> *host_plist = &m_host->m_gapEMcal_plist;
      m_gapEMcal_link.inflate(m_host, host_plist, this);
      GapEMcalList::iterator iter;
      for (iter = m_gapEMcal_link.begin();
           iter != m_gapEMcal_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Cerenkov*> *host_plist = &m_host->m_Cerenkov_plist;
      m_Cerenkov_link.inflate(m_host, host_plist, this);
      CerenkovList::iterator iter;
      for (iter = m_Cerenkov_link.begin();
           iter != m_Cerenkov_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<RICH*> *host_plist = &m_host->m_RICH_plist;
      m_RICH_link.inflate(m_host, host_plist, this);
      RICHList::iterator iter;
      for (iter = m_RICH_link.begin();
           iter != m_RICH_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<DIRC*> *host_plist = &m_host->m_DIRC_plist;
      m_DIRC_link.inflate(m_host, host_plist, this);
      DIRCList::iterator iter;
      for (iter = m_DIRC_link.begin();
           iter != m_DIRC_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ForwardTOF*> *host_plist = &m_host->m_forwardTOF_plist;
      m_forwardTOF_link.inflate(m_host, host_plist, this);
      ForwardTOFList::iterator iter;
      for (iter = m_forwardTOF_link.begin();
           iter != m_forwardTOF_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ForwardEMcal*> *host_plist = &m_host->m_forwardEMcal_plist;
      m_forwardEMcal_link.inflate(m_host, host_plist, this);
      ForwardEMcalList::iterator iter;
      for (iter = m_forwardEMcal_link.begin();
           iter != m_forwardEMcal_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CrystalEcal*> *host_plist = &m_host->m_CrystalEcal_plist;
      m_CrystalEcal_link.inflate(m_host, host_plist, this);
      CrystalEcalList::iterator iter;
      for (iter = m_CrystalEcal_link.begin();
           iter != m_CrystalEcal_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ComptonEMcal*> *host_plist = &m_host->m_ComptonEMcal_plist;
      m_ComptonEMcal_link.inflate(m_host, host_plist, this);
      ComptonEMcalList::iterator iter;
      for (iter = m_ComptonEMcal_link.begin();
           iter != m_ComptonEMcal_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<UpstreamEMveto*> *host_plist = &m_host->m_upstreamEMveto_plist;
      m_upstreamEMveto_link.inflate(m_host, host_plist, this);
      UpstreamEMvetoList::iterator iter;
      for (iter = m_upstreamEMveto_link.begin();
           iter != m_upstreamEMveto_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Tagger*> *host_plist = &m_host->m_tagger_plist;
      m_tagger_link.inflate(m_host, host_plist, this);
      TaggerList::iterator iter;
      for (iter = m_tagger_link.begin();
           iter != m_tagger_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<PairSpectrometerFine*> *host_plist = &m_host->m_pairSpectrometerFine_plist;
      m_pairSpectrometerFine_link.inflate(m_host, host_plist, this);
      PairSpectrometerFineList::iterator iter;
      for (iter = m_pairSpectrometerFine_link.begin();
           iter != m_pairSpectrometerFine_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<PairSpectrometerCoarse*> *host_plist = &m_host->m_pairSpectrometerCoarse_plist;
      m_pairSpectrometerCoarse_link.inflate(m_host, host_plist, this);
      PairSpectrometerCoarseList::iterator iter;
      for (iter = m_pairSpectrometerCoarse_link.begin();
           iter != m_pairSpectrometerCoarse_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TripletPolarimeter*> *host_plist = &m_host->m_tripletPolarimeter_plist;
      m_tripletPolarimeter_link.inflate(m_host, host_plist, this);
      TripletPolarimeterList::iterator iter;
      for (iter = m_tripletPolarimeter_link.begin();
           iter != m_tripletPolarimeter_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<McTrajectory*> *host_plist = &m_host->m_mcTrajectory_plist;
      m_mcTrajectory_link.inflate(m_host, host_plist, this);
      McTrajectoryList::iterator iter;
      for (iter = m_mcTrajectory_link.begin();
           iter != m_mcTrajectory_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<RFtime*> *host_plist = &m_host->m_RFtime_plist;
      m_RFtime_link.inflate(m_host, host_plist, this);
      RFtimeList::iterator iter;
      for (iter = m_RFtime_link.begin();
           iter != m_RFtime_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ForwardMWPC*> *host_plist = &m_host->m_forwardMWPC_plist;
      m_forwardMWPC_link.inflate(m_host, host_plist, this);
      ForwardMWPCList::iterator iter;
      for (iter = m_forwardMWPC_link.begin();
           iter != m_forwardMWPC_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CppTOF*> *host_plist = &m_host->m_cppTOF_plist;
      m_cppTOF_link.inflate(m_host, host_plist, this);
      CppTOFList::iterator iter;
      for (iter = m_cppTOF_link.begin();
           iter != m_cppTOF_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ErrorMatrix::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "errorMatrix"
        << " Ncols=" << m_Ncols
        << " Nrows=" << m_Nrows
        << " type=" << "\"" << m_type << "\""
        << " vals=" << "\"" << m_vals << "\""
             << std::endl;
   return ostr.str();
}

std::string ErrorMatrix::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<errorMatrix"
        << " Ncols=" << "\"" << getNcols() << "\""
        << " Nrows=" << "\"" << getNrows() << "\""
        << " type=" << "\"" << getType() << "\""
        << " vals=" << "\"" << getVals() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ErrorMatrix::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("errorMatrix");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "Ncols", (char*)&m_Ncols - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "Nrows", (char*)&m_Nrows - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "type", (char*)&mx_type - (char*)this, vl_string_tid);
   H5Tinsert(tid, "vals", (char*)&mx_vals - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["errorMatrix"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["errorMatrix"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "errorMatrix", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "errorMatrix", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ErrorMatrix::hdf5DataPack()
{
   mx_type = m_type.c_str();
   mx_vals = m_vals.c_str();
}
void ErrorMatrix::hdf5DataUnpack()
{
   new(&m_type) std::string();
   if (mx_type != 0) {
      m_type = mx_type;
      m_host->m_hdf5_strings.push_back(&m_type);
   }
   new(&m_vals) std::string();
   if (mx_vals != 0) {
      m_vals = mx_vals;
      m_host->m_hdf5_strings.push_back(&m_vals);
   }
}
#endif

std::string TrackingErrorMatrix::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "TrackingErrorMatrix"
        << " Ncols=" << m_Ncols
        << " Nrows=" << m_Nrows
        << " type=" << "\"" << m_type << "\""
        << " vals=" << "\"" << m_vals << "\""
             << std::endl;
   return ostr.str();
}

std::string TrackingErrorMatrix::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<TrackingErrorMatrix"
        << " Ncols=" << "\"" << getNcols() << "\""
        << " Nrows=" << "\"" << getNrows() << "\""
        << " type=" << "\"" << getType() << "\""
        << " vals=" << "\"" << getVals() << "\""
        << " />" << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t TrackingErrorMatrix::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("TrackingErrorMatrix");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "Ncols", (char*)&m_Ncols - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "Nrows", (char*)&m_Nrows - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "type", (char*)&mx_type - (char*)this, vl_string_tid);
   H5Tinsert(tid, "vals", (char*)&mx_vals - (char*)this, vl_string_tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["TrackingErrorMatrix"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["TrackingErrorMatrix"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "TrackingErrorMatrix", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "TrackingErrorMatrix", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void TrackingErrorMatrix::hdf5DataPack()
{
   mx_type = m_type.c_str();
   mx_vals = m_vals.c_str();
}
void TrackingErrorMatrix::hdf5DataUnpack()
{
   new(&m_type) std::string();
   if (mx_type != 0) {
      m_type = mx_type;
      m_host->m_hdf5_strings.push_back(&m_type);
   }
   new(&m_vals) std::string();
   if (mx_vals != 0) {
      m_vals = mx_vals;
      m_host->m_hdf5_strings.push_back(&m_vals);
   }
}
#endif

std::string Tracktimebased::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "tracktimebased"
        << " FOM=" << m_FOM
        << " Ndof=" << m_Ndof
        << " candidateid=" << m_candidateid
        << " chisq=" << m_chisq
        << " id=" << m_id
        << " trackid=" << m_trackid
             << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toString(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toString(indent + 2);
   }
   if (! m_origin_link.empty()) {
      ostr << m_origin_link.begin()->toString(indent + 2);
   }
   if (! m_errorMatrix_link.empty()) {
      ostr << m_errorMatrix_link.begin()->toString(indent + 2);
   }
   if (! m_TrackingErrorMatrix_link.empty()) {
      ostr << m_TrackingErrorMatrix_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string Tracktimebased::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<tracktimebased"
        << " FOM=" << "\"" << getFOM() << "\""
        << " Ndof=" << "\"" << getNdof() << "\""
        << " candidateid=" << "\"" << getCandidateid() << "\""
        << " chisq=" << "\"" << getChisq() << "\""
        << " id=" << "\"" << getId() << "\""
        << " trackid=" << "\"" << getTrackid() << "\""
        << ">" << std::endl;
   if (! m_momentum_link.empty()) {
      ostr << m_momentum_link.begin()->toXML(indent + 2);
   }
   if (! m_properties_link.empty()) {
      ostr << m_properties_link.begin()->toXML(indent + 2);
   }
   if (! m_origin_link.empty()) {
      ostr << m_origin_link.begin()->toXML(indent + 2);
   }
   if (! m_errorMatrix_link.empty()) {
      ostr << m_errorMatrix_link.begin()->toXML(indent + 2);
   }
   if (! m_TrackingErrorMatrix_link.empty()) {
      ostr << m_TrackingErrorMatrix_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</tracktimebased>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t Tracktimebased::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("tracktimebased");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "FOM", (char*)&m_FOM - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "Ndof", (char*)&m_Ndof - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "candidateid", (char*)&m_candidateid - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "chisq", (char*)&m_chisq - (char*)this, ((inmemory)? H5T_NATIVE_FLOAT : H5T_IEEE_F32LE));
   H5Tinsert(tid, "id", (char*)&m_id - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "trackid", (char*)&m_trackid - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "MomentumList_size", (char*)&m_momentum_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "MomentumList_offset", (char*)&m_momentum_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_size", (char*)&m_properties_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "PropertiesList_offset", (char*)&m_properties_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "OriginList_size", (char*)&m_origin_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "OriginList_offset", (char*)&m_origin_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ErrorMatrixList_size", (char*)&m_errorMatrix_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ErrorMatrixList_offset", (char*)&m_errorMatrix_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackingErrorMatrixList_size", (char*)&m_TrackingErrorMatrix_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TrackingErrorMatrixList_offset", (char*)&m_TrackingErrorMatrix_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["tracktimebased"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["tracktimebased"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "tracktimebased", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "tracktimebased", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void Tracktimebased::hdf5DataPack()
{
   m_momentum_link.deflate();
   m_properties_link.deflate();
   m_origin_link.deflate();
   m_errorMatrix_link.deflate();
   m_TrackingErrorMatrix_link.deflate();
}
void Tracktimebased::hdf5DataUnpack()
{
   {
      std::list<Momentum*> *host_plist = &m_host->m_momentum_plist;
      m_momentum_link.inflate(m_host, host_plist, this);
      MomentumList::iterator iter;
      for (iter = m_momentum_link.begin();
           iter != m_momentum_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Properties*> *host_plist = &m_host->m_properties_plist;
      m_properties_link.inflate(m_host, host_plist, this);
      PropertiesList::iterator iter;
      for (iter = m_properties_link.begin();
           iter != m_properties_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Origin*> *host_plist = &m_host->m_origin_plist;
      m_origin_link.inflate(m_host, host_plist, this);
      OriginList::iterator iter;
      for (iter = m_origin_link.begin();
           iter != m_origin_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ErrorMatrix*> *host_plist = &m_host->m_errorMatrix_plist;
      m_errorMatrix_link.inflate(m_host, host_plist, this);
      ErrorMatrixList::iterator iter;
      for (iter = m_errorMatrix_link.begin();
           iter != m_errorMatrix_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<TrackingErrorMatrix*> *host_plist = &m_host->m_TrackingErrorMatrix_plist;
      m_TrackingErrorMatrix_link.inflate(m_host, host_plist, this);
      TrackingErrorMatrixList::iterator iter;
      for (iter = m_TrackingErrorMatrix_link.begin();
           iter != m_TrackingErrorMatrix_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string ReconView::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "reconView"
             << std::endl;
   int TracktimebasedListCount=0;
   for (TracktimebasedList::iterator it = m_tracktimebased_list.begin();
        it != m_tracktimebased_list.end(); ++it)
   {
      if (++TracktimebasedListCount > m_tracktimebased_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string ReconView::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<reconView"
        << " version=" << "\"" << getVersion() << "\""
        << ">" << std::endl;
   int TracktimebasedListCount=0;
   for (TracktimebasedList::iterator it = m_tracktimebased_list.begin();
        it != m_tracktimebased_list.end(); ++it)
   {
      if (++TracktimebasedListCount > m_tracktimebased_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</reconView>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t ReconView::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("reconView");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "TracktimebasedList_size", (char*)&m_tracktimebased_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "TracktimebasedList_offset", (char*)&m_tracktimebased_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["reconView"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["reconView"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "reconView", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "reconView", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void ReconView::hdf5DataPack()
{
   m_tracktimebased_list.deflate();
}
void ReconView::hdf5DataUnpack()
{
   {
      std::list<Tracktimebased*> *host_plist = &m_host->m_tracktimebased_plist;
      m_tracktimebased_list.inflate(m_host, host_plist, this);
      TracktimebasedList::iterator iter;
      for (iter = m_tracktimebased_list.begin();
           iter != m_tracktimebased_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string PhysicsEvent::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "physicsEvent"
        << " eventNo=" << m_eventNo
        << " runNo=" << m_runNo
             << std::endl;
   int DataVersionStringListCount=0;
   for (DataVersionStringList::iterator it = m_dataVersionString_list.begin();
        it != m_dataVersionString_list.end(); ++it)
   {
      if (++DataVersionStringListCount > m_dataVersionString_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int CcdbContextListCount=0;
   for (CcdbContextList::iterator it = m_ccdbContext_list.begin();
        it != m_ccdbContext_list.end(); ++it)
   {
      if (++CcdbContextListCount > m_ccdbContext_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   int ReactionListCount=0;
   for (ReactionList::iterator it = m_reaction_list.begin();
        it != m_reaction_list.end(); ++it)
   {
      if (++ReactionListCount > m_reaction_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   if (! m_hitView_link.empty()) {
      ostr << m_hitView_link.begin()->toString(indent + 2);
   }
   if (! m_reconView_link.empty()) {
      ostr << m_reconView_link.begin()->toString(indent + 2);
   }
   return ostr.str();
}

std::string PhysicsEvent::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<physicsEvent"
        << " eventNo=" << "\"" << getEventNo() << "\""
        << " runNo=" << "\"" << getRunNo() << "\""
        << ">" << std::endl;
   int DataVersionStringListCount=0;
   for (DataVersionStringList::iterator it = m_dataVersionString_list.begin();
        it != m_dataVersionString_list.end(); ++it)
   {
      if (++DataVersionStringListCount > m_dataVersionString_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int CcdbContextListCount=0;
   for (CcdbContextList::iterator it = m_ccdbContext_list.begin();
        it != m_ccdbContext_list.end(); ++it)
   {
      if (++CcdbContextListCount > m_ccdbContext_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   int ReactionListCount=0;
   for (ReactionList::iterator it = m_reaction_list.begin();
        it != m_reaction_list.end(); ++it)
   {
      if (++ReactionListCount > m_reaction_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   if (! m_hitView_link.empty()) {
      ostr << m_hitView_link.begin()->toXML(indent + 2);
   }
   if (! m_reconView_link.empty()) {
      ostr << m_reconView_link.begin()->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</physicsEvent>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t PhysicsEvent::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("physicsEvent");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   H5Tinsert(tid, "eventNo", (char*)&m_eventNo - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "runNo", (char*)&m_runNo - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I32LE));
   H5Tinsert(tid, "DataVersionStringList_size", (char*)&m_dataVersionString_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "DataVersionStringList_offset", (char*)&m_dataVersionString_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcdbContextList_size", (char*)&m_ccdbContext_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "CcdbContextList_offset", (char*)&m_ccdbContext_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ReactionList_size", (char*)&m_reaction_list.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ReactionList_offset", (char*)&m_reaction_list.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HitViewList_size", (char*)&m_hitView_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "HitViewList_offset", (char*)&m_hitView_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ReconViewList_size", (char*)&m_reconView_link.m_size - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   H5Tinsert(tid, "ReconViewList_offset", (char*)&m_reconView_link.m_ref - (char*)this, ((inmemory)? H5T_NATIVE_INT : H5T_STD_I16LE));
   if (inmemory) {
      HDDM::s_hdf5_memorytype["physicsEvent"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["physicsEvent"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "physicsEvent", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "physicsEvent", ddlstring);
      free(ddlstring);
   }
   return tid;
}
void PhysicsEvent::hdf5DataPack()
{
   m_dataVersionString_list.deflate();
   m_ccdbContext_list.deflate();
   m_reaction_list.deflate();
   m_hitView_link.deflate();
   m_reconView_link.deflate();
}
void PhysicsEvent::hdf5DataUnpack()
{
   {
      std::list<DataVersionString*> *host_plist = &m_host->m_dataVersionString_plist;
      m_dataVersionString_list.inflate(m_host, host_plist, this);
      DataVersionStringList::iterator iter;
      for (iter = m_dataVersionString_list.begin();
           iter != m_dataVersionString_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<CcdbContext*> *host_plist = &m_host->m_ccdbContext_plist;
      m_ccdbContext_list.inflate(m_host, host_plist, this);
      CcdbContextList::iterator iter;
      for (iter = m_ccdbContext_list.begin();
           iter != m_ccdbContext_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<Reaction*> *host_plist = &m_host->m_reaction_plist;
      m_reaction_list.inflate(m_host, host_plist, this);
      ReactionList::iterator iter;
      for (iter = m_reaction_list.begin();
           iter != m_reaction_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<HitView*> *host_plist = &m_host->m_hitView_plist;
      m_hitView_link.inflate(m_host, host_plist, this);
      HitViewList::iterator iter;
      for (iter = m_hitView_link.begin();
           iter != m_hitView_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<ReconView*> *host_plist = &m_host->m_reconView_plist;
      m_reconView_link.inflate(m_host, host_plist, this);
      ReconViewList::iterator iter;
      for (iter = m_reconView_link.begin();
           iter != m_reconView_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif

std::string HDDM::toString(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "HDDM"
             << std::endl;
   if (! m_geometry_link.empty()) {
      ostr << m_geometry_link.begin()->toString(indent + 2);
   }
   int PhysicsEventListCount=0;
   for (PhysicsEventList::iterator it = m_physicsEvent_list.begin();
        it != m_physicsEvent_list.end(); ++it)
   {
      if (++PhysicsEventListCount > m_physicsEvent_list.size()) {
         throw std::runtime_error("hddm_s::toString error - list improperly terminated!");
      }
      ostr << it->toString(indent + 2);
   }
   return ostr.str();
}

std::string HDDM::toXML(int indent) {
   std::stringstream ostr;
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "<HDDM"
        << " class=" << "\"" << getClass() << "\""
        << " version=" << "\"" << getVersion() << "\""
        << " xmlns=" << "\"" << getXmlns() << "\""
        << ">" << std::endl;
   if (! m_geometry_link.empty()) {
      ostr << m_geometry_link.begin()->toXML(indent + 2);
   }
   int PhysicsEventListCount=0;
   for (PhysicsEventList::iterator it = m_physicsEvent_list.begin();
        it != m_physicsEvent_list.end(); ++it)
   {
      if (++PhysicsEventListCount > m_physicsEvent_list.size()) {
         throw std::runtime_error("hddm_s::toXML error - list improperly terminated!");
      }
      ostr << it->toXML(indent + 2);
   }
   for (int n=0; n < indent; ++n)
      ostr << " ";
   ostr << "</HDDM>"
        << std::endl;
   return ostr.str();
}

#ifdef HDF5_SUPPORT
hid_t HDDM::hdf5Datatype(int inmemory, int verbose)
{
   std::string tname("HDDM");
   if (inmemory) {
      if (HDDM::s_hdf5_memorytype.find(tname) != HDDM::s_hdf5_memorytype.end())
         return HDDM::s_hdf5_memorytype[tname];
   }
   else {
      if (HDDM::s_hdf5_datatype.find(tname) != HDDM::s_hdf5_datatype.end())
         return HDDM::s_hdf5_datatype[tname];
   }
   hid_t tid = H5Tcreate(H5T_COMPOUND, sizeof(*this));
   hid_t vl_string_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(vl_string_tid, H5T_VARIABLE);
   hid_t vl_tid;
   Cerenkov l_Cerenkov;
   vl_tid = H5Tvlen_create(l_Cerenkov.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_Cerenkov", (char*)&m_hdf5_record.vl_Cerenkov - (char*)&m_hdf5_record, vl_tid);
   ComptonEMcal l_ComptonEMcal;
   vl_tid = H5Tvlen_create(l_ComptonEMcal.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ComptonEMcal", (char*)&m_hdf5_record.vl_ComptonEMcal - (char*)&m_hdf5_record, vl_tid);
   CrystalEcal l_CrystalEcal;
   vl_tid = H5Tvlen_create(l_CrystalEcal.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_CrystalEcal", (char*)&m_hdf5_record.vl_CrystalEcal - (char*)&m_hdf5_record, vl_tid);
   DIRC l_DIRC;
   vl_tid = H5Tvlen_create(l_DIRC.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_DIRC", (char*)&m_hdf5_record.vl_DIRC - (char*)&m_hdf5_record, vl_tid);
   RFsubsystem l_RFsubsystem;
   vl_tid = H5Tvlen_create(l_RFsubsystem.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_RFsubsystem", (char*)&m_hdf5_record.vl_RFsubsystem - (char*)&m_hdf5_record, vl_tid);
   RFtime l_RFtime;
   vl_tid = H5Tvlen_create(l_RFtime.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_RFtime", (char*)&m_hdf5_record.vl_RFtime - (char*)&m_hdf5_record, vl_tid);
   RICH l_RICH;
   vl_tid = H5Tvlen_create(l_RICH.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_RICH", (char*)&m_hdf5_record.vl_RICH - (char*)&m_hdf5_record, vl_tid);
   TrackingErrorMatrix l_TrackingErrorMatrix;
   vl_tid = H5Tvlen_create(l_TrackingErrorMatrix.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_TrackingErrorMatrix", (char*)&m_hdf5_record.vl_TrackingErrorMatrix - (char*)&m_hdf5_record, vl_tid);
   BarrelEMcal l_barrelEMcal;
   vl_tid = H5Tvlen_create(l_barrelEMcal.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_barrelEMcal", (char*)&m_hdf5_record.vl_barrelEMcal - (char*)&m_hdf5_record, vl_tid);
   BcalCell l_bcalCell;
   vl_tid = H5Tvlen_create(l_bcalCell.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalCell", (char*)&m_hdf5_record.vl_bcalCell - (char*)&m_hdf5_record, vl_tid);
   BcalSiPMDownHit l_bcalSiPMDownHit;
   vl_tid = H5Tvlen_create(l_bcalSiPMDownHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalSiPMDownHit", (char*)&m_hdf5_record.vl_bcalSiPMDownHit - (char*)&m_hdf5_record, vl_tid);
   BcalSiPMSpectrum l_bcalSiPMSpectrum;
   vl_tid = H5Tvlen_create(l_bcalSiPMSpectrum.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalSiPMSpectrum", (char*)&m_hdf5_record.vl_bcalSiPMSpectrum - (char*)&m_hdf5_record, vl_tid);
   BcalSiPMTruth l_bcalSiPMTruth;
   vl_tid = H5Tvlen_create(l_bcalSiPMTruth.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalSiPMTruth", (char*)&m_hdf5_record.vl_bcalSiPMTruth - (char*)&m_hdf5_record, vl_tid);
   BcalSiPMUpHit l_bcalSiPMUpHit;
   vl_tid = H5Tvlen_create(l_bcalSiPMUpHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalSiPMUpHit", (char*)&m_hdf5_record.vl_bcalSiPMUpHit - (char*)&m_hdf5_record, vl_tid);
   BcalTDCDigiHit l_bcalTDCDigiHit;
   vl_tid = H5Tvlen_create(l_bcalTDCDigiHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalTDCDigiHit", (char*)&m_hdf5_record.vl_bcalTDCDigiHit - (char*)&m_hdf5_record, vl_tid);
   BcalTDCHit l_bcalTDCHit;
   vl_tid = H5Tvlen_create(l_bcalTDCHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalTDCHit", (char*)&m_hdf5_record.vl_bcalTDCHit - (char*)&m_hdf5_record, vl_tid);
   BcalTruthHit l_bcalTruthHit;
   vl_tid = H5Tvlen_create(l_bcalTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalTruthHit", (char*)&m_hdf5_record.vl_bcalTruthHit - (char*)&m_hdf5_record, vl_tid);
   BcalTruthIncidentParticle l_bcalTruthIncidentParticle;
   vl_tid = H5Tvlen_create(l_bcalTruthIncidentParticle.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalTruthIncidentParticle", (char*)&m_hdf5_record.vl_bcalTruthIncidentParticle - (char*)&m_hdf5_record, vl_tid);
   BcalTruthShower l_bcalTruthShower;
   vl_tid = H5Tvlen_create(l_bcalTruthShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalTruthShower", (char*)&m_hdf5_record.vl_bcalTruthShower - (char*)&m_hdf5_record, vl_tid);
   BcalfADCDigiHit l_bcalfADCDigiHit;
   vl_tid = H5Tvlen_create(l_bcalfADCDigiHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalfADCDigiHit", (char*)&m_hdf5_record.vl_bcalfADCDigiHit - (char*)&m_hdf5_record, vl_tid);
   BcalfADCHit l_bcalfADCHit;
   vl_tid = H5Tvlen_create(l_bcalfADCHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalfADCHit", (char*)&m_hdf5_record.vl_bcalfADCHit - (char*)&m_hdf5_record, vl_tid);
   BcalfADCPeak l_bcalfADCPeak;
   vl_tid = H5Tvlen_create(l_bcalfADCPeak.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_bcalfADCPeak", (char*)&m_hdf5_record.vl_bcalfADCPeak - (char*)&m_hdf5_record, vl_tid);
   Beam l_beam;
   vl_tid = H5Tvlen_create(l_beam.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_beam", (char*)&m_hdf5_record.vl_beam - (char*)&m_hdf5_record, vl_tid);
   CcalBlock l_ccalBlock;
   vl_tid = H5Tvlen_create(l_ccalBlock.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccalBlock", (char*)&m_hdf5_record.vl_ccalBlock - (char*)&m_hdf5_record, vl_tid);
   CcalHit l_ccalHit;
   vl_tid = H5Tvlen_create(l_ccalHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccalHit", (char*)&m_hdf5_record.vl_ccalHit - (char*)&m_hdf5_record, vl_tid);
   CcalTruthHit l_ccalTruthHit;
   vl_tid = H5Tvlen_create(l_ccalTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccalTruthHit", (char*)&m_hdf5_record.vl_ccalTruthHit - (char*)&m_hdf5_record, vl_tid);
   CcalTruthShower l_ccalTruthShower;
   vl_tid = H5Tvlen_create(l_ccalTruthShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccalTruthShower", (char*)&m_hdf5_record.vl_ccalTruthShower - (char*)&m_hdf5_record, vl_tid);
   CcdbContext l_ccdbContext;
   vl_tid = H5Tvlen_create(l_ccdbContext.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ccdbContext", (char*)&m_hdf5_record.vl_ccdbContext - (char*)&m_hdf5_record, vl_tid);
   CdcDigihit l_cdcDigihit;
   vl_tid = H5Tvlen_create(l_cdcDigihit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cdcDigihit", (char*)&m_hdf5_record.vl_cdcDigihit - (char*)&m_hdf5_record, vl_tid);
   CdcHitQF l_cdcHitQF;
   vl_tid = H5Tvlen_create(l_cdcHitQF.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cdcHitQF", (char*)&m_hdf5_record.vl_cdcHitQF - (char*)&m_hdf5_record, vl_tid);
   CdcStraw l_cdcStraw;
   vl_tid = H5Tvlen_create(l_cdcStraw.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cdcStraw", (char*)&m_hdf5_record.vl_cdcStraw - (char*)&m_hdf5_record, vl_tid);
   CdcStrawHit l_cdcStrawHit;
   vl_tid = H5Tvlen_create(l_cdcStrawHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cdcStrawHit", (char*)&m_hdf5_record.vl_cdcStrawHit - (char*)&m_hdf5_record, vl_tid);
   CdcStrawTruthHit l_cdcStrawTruthHit;
   vl_tid = H5Tvlen_create(l_cdcStrawTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cdcStrawTruthHit", (char*)&m_hdf5_record.vl_cdcStrawTruthHit - (char*)&m_hdf5_record, vl_tid);
   CdcTruthPoint l_cdcTruthPoint;
   vl_tid = H5Tvlen_create(l_cdcTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cdcTruthPoint", (char*)&m_hdf5_record.vl_cdcTruthPoint - (char*)&m_hdf5_record, vl_tid);
   CentralDC l_centralDC;
   vl_tid = H5Tvlen_create(l_centralDC.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_centralDC", (char*)&m_hdf5_record.vl_centralDC - (char*)&m_hdf5_record, vl_tid);
   CereHit l_cereHit;
   vl_tid = H5Tvlen_create(l_cereHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cereHit", (char*)&m_hdf5_record.vl_cereHit - (char*)&m_hdf5_record, vl_tid);
   CereSection l_cereSection;
   vl_tid = H5Tvlen_create(l_cereSection.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cereSection", (char*)&m_hdf5_record.vl_cereSection - (char*)&m_hdf5_record, vl_tid);
   CereTruthHit l_cereTruthHit;
   vl_tid = H5Tvlen_create(l_cereTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cereTruthHit", (char*)&m_hdf5_record.vl_cereTruthHit - (char*)&m_hdf5_record, vl_tid);
   CereTruthPoint l_cereTruthPoint;
   vl_tid = H5Tvlen_create(l_cereTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cereTruthPoint", (char*)&m_hdf5_record.vl_cereTruthPoint - (char*)&m_hdf5_record, vl_tid);
   CppTOF l_cppTOF;
   vl_tid = H5Tvlen_create(l_cppTOF.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_cppTOF", (char*)&m_hdf5_record.vl_cppTOF - (char*)&m_hdf5_record, vl_tid);
   CtofCounter l_ctofCounter;
   vl_tid = H5Tvlen_create(l_ctofCounter.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ctofCounter", (char*)&m_hdf5_record.vl_ctofCounter - (char*)&m_hdf5_record, vl_tid);
   CtofHit l_ctofHit;
   vl_tid = H5Tvlen_create(l_ctofHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ctofHit", (char*)&m_hdf5_record.vl_ctofHit - (char*)&m_hdf5_record, vl_tid);
   CtofTruthHit l_ctofTruthHit;
   vl_tid = H5Tvlen_create(l_ctofTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ctofTruthHit", (char*)&m_hdf5_record.vl_ctofTruthHit - (char*)&m_hdf5_record, vl_tid);
   CtofTruthPoint l_ctofTruthPoint;
   vl_tid = H5Tvlen_create(l_ctofTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ctofTruthPoint", (char*)&m_hdf5_record.vl_ctofTruthPoint - (char*)&m_hdf5_record, vl_tid);
   DataVersionString l_dataVersionString;
   vl_tid = H5Tvlen_create(l_dataVersionString.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dataVersionString", (char*)&m_hdf5_record.vl_dataVersionString - (char*)&m_hdf5_record, vl_tid);
   DircPmtHit l_dircPmtHit;
   vl_tid = H5Tvlen_create(l_dircPmtHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircPmtHit", (char*)&m_hdf5_record.vl_dircPmtHit - (char*)&m_hdf5_record, vl_tid);
   DircTruthBarHit l_dircTruthBarHit;
   vl_tid = H5Tvlen_create(l_dircTruthBarHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircTruthBarHit", (char*)&m_hdf5_record.vl_dircTruthBarHit - (char*)&m_hdf5_record, vl_tid);
   DircTruthPmtHit l_dircTruthPmtHit;
   vl_tid = H5Tvlen_create(l_dircTruthPmtHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircTruthPmtHit", (char*)&m_hdf5_record.vl_dircTruthPmtHit - (char*)&m_hdf5_record, vl_tid);
   DircTruthPmtHitExtra l_dircTruthPmtHitExtra;
   vl_tid = H5Tvlen_create(l_dircTruthPmtHitExtra.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_dircTruthPmtHitExtra", (char*)&m_hdf5_record.vl_dircTruthPmtHitExtra - (char*)&m_hdf5_record, vl_tid);
   EcalBlock l_ecalBlock;
   vl_tid = H5Tvlen_create(l_ecalBlock.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ecalBlock", (char*)&m_hdf5_record.vl_ecalBlock - (char*)&m_hdf5_record, vl_tid);
   EcalHit l_ecalHit;
   vl_tid = H5Tvlen_create(l_ecalHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ecalHit", (char*)&m_hdf5_record.vl_ecalHit - (char*)&m_hdf5_record, vl_tid);
   EcalTruthHit l_ecalTruthHit;
   vl_tid = H5Tvlen_create(l_ecalTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ecalTruthHit", (char*)&m_hdf5_record.vl_ecalTruthHit - (char*)&m_hdf5_record, vl_tid);
   EcalTruthShower l_ecalTruthShower;
   vl_tid = H5Tvlen_create(l_ecalTruthShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ecalTruthShower", (char*)&m_hdf5_record.vl_ecalTruthShower - (char*)&m_hdf5_record, vl_tid);
   ErrorMatrix l_errorMatrix;
   vl_tid = H5Tvlen_create(l_errorMatrix.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_errorMatrix", (char*)&m_hdf5_record.vl_errorMatrix - (char*)&m_hdf5_record, vl_tid);
   FcalBlock l_fcalBlock;
   vl_tid = H5Tvlen_create(l_fcalBlock.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalBlock", (char*)&m_hdf5_record.vl_fcalBlock - (char*)&m_hdf5_record, vl_tid);
   FcalDigihit l_fcalDigihit;
   vl_tid = H5Tvlen_create(l_fcalDigihit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalDigihit", (char*)&m_hdf5_record.vl_fcalDigihit - (char*)&m_hdf5_record, vl_tid);
   FcalHit l_fcalHit;
   vl_tid = H5Tvlen_create(l_fcalHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalHit", (char*)&m_hdf5_record.vl_fcalHit - (char*)&m_hdf5_record, vl_tid);
   FcalTruthHit l_fcalTruthHit;
   vl_tid = H5Tvlen_create(l_fcalTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalTruthHit", (char*)&m_hdf5_record.vl_fcalTruthHit - (char*)&m_hdf5_record, vl_tid);
   FcalTruthLightGuide l_fcalTruthLightGuide;
   vl_tid = H5Tvlen_create(l_fcalTruthLightGuide.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalTruthLightGuide", (char*)&m_hdf5_record.vl_fcalTruthLightGuide - (char*)&m_hdf5_record, vl_tid);
   FcalTruthShower l_fcalTruthShower;
   vl_tid = H5Tvlen_create(l_fcalTruthShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fcalTruthShower", (char*)&m_hdf5_record.vl_fcalTruthShower - (char*)&m_hdf5_record, vl_tid);
   FdcAnodeHit l_fdcAnodeHit;
   vl_tid = H5Tvlen_create(l_fdcAnodeHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcAnodeHit", (char*)&m_hdf5_record.vl_fdcAnodeHit - (char*)&m_hdf5_record, vl_tid);
   FdcAnodeTruthHit l_fdcAnodeTruthHit;
   vl_tid = H5Tvlen_create(l_fdcAnodeTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcAnodeTruthHit", (char*)&m_hdf5_record.vl_fdcAnodeTruthHit - (char*)&m_hdf5_record, vl_tid);
   FdcAnodeWire l_fdcAnodeWire;
   vl_tid = H5Tvlen_create(l_fdcAnodeWire.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcAnodeWire", (char*)&m_hdf5_record.vl_fdcAnodeWire - (char*)&m_hdf5_record, vl_tid);
   FdcCathodeHit l_fdcCathodeHit;
   vl_tid = H5Tvlen_create(l_fdcCathodeHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcCathodeHit", (char*)&m_hdf5_record.vl_fdcCathodeHit - (char*)&m_hdf5_record, vl_tid);
   FdcCathodeStrip l_fdcCathodeStrip;
   vl_tid = H5Tvlen_create(l_fdcCathodeStrip.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcCathodeStrip", (char*)&m_hdf5_record.vl_fdcCathodeStrip - (char*)&m_hdf5_record, vl_tid);
   FdcCathodeTruthHit l_fdcCathodeTruthHit;
   vl_tid = H5Tvlen_create(l_fdcCathodeTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcCathodeTruthHit", (char*)&m_hdf5_record.vl_fdcCathodeTruthHit - (char*)&m_hdf5_record, vl_tid);
   FdcChamber l_fdcChamber;
   vl_tid = H5Tvlen_create(l_fdcChamber.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcChamber", (char*)&m_hdf5_record.vl_fdcChamber - (char*)&m_hdf5_record, vl_tid);
   FdcDigihit l_fdcDigihit;
   vl_tid = H5Tvlen_create(l_fdcDigihit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcDigihit", (char*)&m_hdf5_record.vl_fdcDigihit - (char*)&m_hdf5_record, vl_tid);
   FdcTruthPoint l_fdcTruthPoint;
   vl_tid = H5Tvlen_create(l_fdcTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fdcTruthPoint", (char*)&m_hdf5_record.vl_fdcTruthPoint - (char*)&m_hdf5_record, vl_tid);
   FmwpcChamber l_fmwpcChamber;
   vl_tid = H5Tvlen_create(l_fmwpcChamber.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcChamber", (char*)&m_hdf5_record.vl_fmwpcChamber - (char*)&m_hdf5_record, vl_tid);
   FmwpcHit l_fmwpcHit;
   vl_tid = H5Tvlen_create(l_fmwpcHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcHit", (char*)&m_hdf5_record.vl_fmwpcHit - (char*)&m_hdf5_record, vl_tid);
   FmwpcHitQ l_fmwpcHitQ;
   vl_tid = H5Tvlen_create(l_fmwpcHitQ.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcHitQ", (char*)&m_hdf5_record.vl_fmwpcHitQ - (char*)&m_hdf5_record, vl_tid);
   FmwpcTruthHit l_fmwpcTruthHit;
   vl_tid = H5Tvlen_create(l_fmwpcTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcTruthHit", (char*)&m_hdf5_record.vl_fmwpcTruthHit - (char*)&m_hdf5_record, vl_tid);
   FmwpcTruthHitQ l_fmwpcTruthHitQ;
   vl_tid = H5Tvlen_create(l_fmwpcTruthHitQ.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcTruthHitQ", (char*)&m_hdf5_record.vl_fmwpcTruthHitQ - (char*)&m_hdf5_record, vl_tid);
   FmwpcTruthPoint l_fmwpcTruthPoint;
   vl_tid = H5Tvlen_create(l_fmwpcTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_fmwpcTruthPoint", (char*)&m_hdf5_record.vl_fmwpcTruthPoint - (char*)&m_hdf5_record, vl_tid);
   ForwardDC l_forwardDC;
   vl_tid = H5Tvlen_create(l_forwardDC.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_forwardDC", (char*)&m_hdf5_record.vl_forwardDC - (char*)&m_hdf5_record, vl_tid);
   ForwardEMcal l_forwardEMcal;
   vl_tid = H5Tvlen_create(l_forwardEMcal.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_forwardEMcal", (char*)&m_hdf5_record.vl_forwardEMcal - (char*)&m_hdf5_record, vl_tid);
   ForwardMWPC l_forwardMWPC;
   vl_tid = H5Tvlen_create(l_forwardMWPC.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_forwardMWPC", (char*)&m_hdf5_record.vl_forwardMWPC - (char*)&m_hdf5_record, vl_tid);
   ForwardTOF l_forwardTOF;
   vl_tid = H5Tvlen_create(l_forwardTOF.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_forwardTOF", (char*)&m_hdf5_record.vl_forwardTOF - (char*)&m_hdf5_record, vl_tid);
   FtofCounter l_ftofCounter;
   vl_tid = H5Tvlen_create(l_ftofCounter.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ftofCounter", (char*)&m_hdf5_record.vl_ftofCounter - (char*)&m_hdf5_record, vl_tid);
   FtofDigihit l_ftofDigihit;
   vl_tid = H5Tvlen_create(l_ftofDigihit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ftofDigihit", (char*)&m_hdf5_record.vl_ftofDigihit - (char*)&m_hdf5_record, vl_tid);
   FtofHit l_ftofHit;
   vl_tid = H5Tvlen_create(l_ftofHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ftofHit", (char*)&m_hdf5_record.vl_ftofHit - (char*)&m_hdf5_record, vl_tid);
   FtofTruthExtra l_ftofTruthExtra;
   vl_tid = H5Tvlen_create(l_ftofTruthExtra.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ftofTruthExtra", (char*)&m_hdf5_record.vl_ftofTruthExtra - (char*)&m_hdf5_record, vl_tid);
   FtofTruthHit l_ftofTruthHit;
   vl_tid = H5Tvlen_create(l_ftofTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ftofTruthHit", (char*)&m_hdf5_record.vl_ftofTruthHit - (char*)&m_hdf5_record, vl_tid);
   FtofTruthPoint l_ftofTruthPoint;
   vl_tid = H5Tvlen_create(l_ftofTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_ftofTruthPoint", (char*)&m_hdf5_record.vl_ftofTruthPoint - (char*)&m_hdf5_record, vl_tid);
   GapEMcal l_gapEMcal;
   vl_tid = H5Tvlen_create(l_gapEMcal.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_gapEMcal", (char*)&m_hdf5_record.vl_gapEMcal - (char*)&m_hdf5_record, vl_tid);
   GcalCell l_gcalCell;
   vl_tid = H5Tvlen_create(l_gcalCell.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_gcalCell", (char*)&m_hdf5_record.vl_gcalCell - (char*)&m_hdf5_record, vl_tid);
   GcalHit l_gcalHit;
   vl_tid = H5Tvlen_create(l_gcalHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_gcalHit", (char*)&m_hdf5_record.vl_gcalHit - (char*)&m_hdf5_record, vl_tid);
   GcalTruthHit l_gcalTruthHit;
   vl_tid = H5Tvlen_create(l_gcalTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_gcalTruthHit", (char*)&m_hdf5_record.vl_gcalTruthHit - (char*)&m_hdf5_record, vl_tid);
   GcalTruthShower l_gcalTruthShower;
   vl_tid = H5Tvlen_create(l_gcalTruthShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_gcalTruthShower", (char*)&m_hdf5_record.vl_gcalTruthShower - (char*)&m_hdf5_record, vl_tid);
   Geometry l_geometry;
   vl_tid = H5Tvlen_create(l_geometry.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_geometry", (char*)&m_hdf5_record.vl_geometry - (char*)&m_hdf5_record, vl_tid);
   HitView l_hitView;
   vl_tid = H5Tvlen_create(l_hitView.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_hitView", (char*)&m_hdf5_record.vl_hitView - (char*)&m_hdf5_record, vl_tid);
   HodoChannel l_hodoChannel;
   vl_tid = H5Tvlen_create(l_hodoChannel.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_hodoChannel", (char*)&m_hdf5_record.vl_hodoChannel - (char*)&m_hdf5_record, vl_tid);
   McTrajectory l_mcTrajectory;
   vl_tid = H5Tvlen_create(l_mcTrajectory.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_mcTrajectory", (char*)&m_hdf5_record.vl_mcTrajectory - (char*)&m_hdf5_record, vl_tid);
   McTrajectoryPoint l_mcTrajectoryPoint;
   vl_tid = H5Tvlen_create(l_mcTrajectoryPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_mcTrajectoryPoint", (char*)&m_hdf5_record.vl_mcTrajectoryPoint - (char*)&m_hdf5_record, vl_tid);
   MicroChannel l_microChannel;
   vl_tid = H5Tvlen_create(l_microChannel.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_microChannel", (char*)&m_hdf5_record.vl_microChannel - (char*)&m_hdf5_record, vl_tid);
   Momentum l_momentum;
   vl_tid = H5Tvlen_create(l_momentum.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_momentum", (char*)&m_hdf5_record.vl_momentum - (char*)&m_hdf5_record, vl_tid);
   Origin l_origin;
   vl_tid = H5Tvlen_create(l_origin.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_origin", (char*)&m_hdf5_record.vl_origin - (char*)&m_hdf5_record, vl_tid);
   PairSpectrometerCoarse l_pairSpectrometerCoarse;
   vl_tid = H5Tvlen_create(l_pairSpectrometerCoarse.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_pairSpectrometerCoarse", (char*)&m_hdf5_record.vl_pairSpectrometerCoarse - (char*)&m_hdf5_record, vl_tid);
   PairSpectrometerFine l_pairSpectrometerFine;
   vl_tid = H5Tvlen_create(l_pairSpectrometerFine.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_pairSpectrometerFine", (char*)&m_hdf5_record.vl_pairSpectrometerFine - (char*)&m_hdf5_record, vl_tid);
   PhysicsEvent l_physicsEvent;
   vl_tid = H5Tvlen_create(l_physicsEvent.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_physicsEvent", (char*)&m_hdf5_record.vl_physicsEvent - (char*)&m_hdf5_record, vl_tid);
   Polarization l_polarization;
   vl_tid = H5Tvlen_create(l_polarization.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_polarization", (char*)&m_hdf5_record.vl_polarization - (char*)&m_hdf5_record, vl_tid);
   Product l_product;
   vl_tid = H5Tvlen_create(l_product.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_product", (char*)&m_hdf5_record.vl_product - (char*)&m_hdf5_record, vl_tid);
   Properties l_properties;
   vl_tid = H5Tvlen_create(l_properties.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_properties", (char*)&m_hdf5_record.vl_properties - (char*)&m_hdf5_record, vl_tid);
   PsHit l_psHit;
   vl_tid = H5Tvlen_create(l_psHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_psHit", (char*)&m_hdf5_record.vl_psHit - (char*)&m_hdf5_record, vl_tid);
   PsTile l_psTile;
   vl_tid = H5Tvlen_create(l_psTile.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_psTile", (char*)&m_hdf5_record.vl_psTile - (char*)&m_hdf5_record, vl_tid);
   PsTruthHit l_psTruthHit;
   vl_tid = H5Tvlen_create(l_psTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_psTruthHit", (char*)&m_hdf5_record.vl_psTruthHit - (char*)&m_hdf5_record, vl_tid);
   PsTruthPoint l_psTruthPoint;
   vl_tid = H5Tvlen_create(l_psTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_psTruthPoint", (char*)&m_hdf5_record.vl_psTruthPoint - (char*)&m_hdf5_record, vl_tid);
   PscHit l_pscHit;
   vl_tid = H5Tvlen_create(l_pscHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_pscHit", (char*)&m_hdf5_record.vl_pscHit - (char*)&m_hdf5_record, vl_tid);
   PscPaddle l_pscPaddle;
   vl_tid = H5Tvlen_create(l_pscPaddle.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_pscPaddle", (char*)&m_hdf5_record.vl_pscPaddle - (char*)&m_hdf5_record, vl_tid);
   PscTruthHit l_pscTruthHit;
   vl_tid = H5Tvlen_create(l_pscTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_pscTruthHit", (char*)&m_hdf5_record.vl_pscTruthHit - (char*)&m_hdf5_record, vl_tid);
   PscTruthPoint l_pscTruthPoint;
   vl_tid = H5Tvlen_create(l_pscTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_pscTruthPoint", (char*)&m_hdf5_record.vl_pscTruthPoint - (char*)&m_hdf5_record, vl_tid);
   Random l_random;
   vl_tid = H5Tvlen_create(l_random.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_random", (char*)&m_hdf5_record.vl_random - (char*)&m_hdf5_record, vl_tid);
   Reaction l_reaction;
   vl_tid = H5Tvlen_create(l_reaction.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_reaction", (char*)&m_hdf5_record.vl_reaction - (char*)&m_hdf5_record, vl_tid);
   ReconView l_reconView;
   vl_tid = H5Tvlen_create(l_reconView.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_reconView", (char*)&m_hdf5_record.vl_reconView - (char*)&m_hdf5_record, vl_tid);
   RichTruthHit l_richTruthHit;
   vl_tid = H5Tvlen_create(l_richTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_richTruthHit", (char*)&m_hdf5_record.vl_richTruthHit - (char*)&m_hdf5_record, vl_tid);
   RichTruthPoint l_richTruthPoint;
   vl_tid = H5Tvlen_create(l_richTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_richTruthPoint", (char*)&m_hdf5_record.vl_richTruthPoint - (char*)&m_hdf5_record, vl_tid);
   StartCntr l_startCntr;
   vl_tid = H5Tvlen_create(l_startCntr.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_startCntr", (char*)&m_hdf5_record.vl_startCntr - (char*)&m_hdf5_record, vl_tid);
   StcDigihit l_stcDigihit;
   vl_tid = H5Tvlen_create(l_stcDigihit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_stcDigihit", (char*)&m_hdf5_record.vl_stcDigihit - (char*)&m_hdf5_record, vl_tid);
   StcHit l_stcHit;
   vl_tid = H5Tvlen_create(l_stcHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_stcHit", (char*)&m_hdf5_record.vl_stcHit - (char*)&m_hdf5_record, vl_tid);
   StcPaddle l_stcPaddle;
   vl_tid = H5Tvlen_create(l_stcPaddle.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_stcPaddle", (char*)&m_hdf5_record.vl_stcPaddle - (char*)&m_hdf5_record, vl_tid);
   StcTruthHit l_stcTruthHit;
   vl_tid = H5Tvlen_create(l_stcTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_stcTruthHit", (char*)&m_hdf5_record.vl_stcTruthHit - (char*)&m_hdf5_record, vl_tid);
   StcTruthPoint l_stcTruthPoint;
   vl_tid = H5Tvlen_create(l_stcTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_stcTruthPoint", (char*)&m_hdf5_record.vl_stcTruthPoint - (char*)&m_hdf5_record, vl_tid);
   Tagger l_tagger;
   vl_tid = H5Tvlen_create(l_tagger.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tagger", (char*)&m_hdf5_record.vl_tagger - (char*)&m_hdf5_record, vl_tid);
   TaggerHit l_taggerHit;
   vl_tid = H5Tvlen_create(l_taggerHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_taggerHit", (char*)&m_hdf5_record.vl_taggerHit - (char*)&m_hdf5_record, vl_tid);
   TaggerTruthHit l_taggerTruthHit;
   vl_tid = H5Tvlen_create(l_taggerTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_taggerTruthHit", (char*)&m_hdf5_record.vl_taggerTruthHit - (char*)&m_hdf5_record, vl_tid);
   Target l_target;
   vl_tid = H5Tvlen_create(l_target.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_target", (char*)&m_hdf5_record.vl_target - (char*)&m_hdf5_record, vl_tid);
   TpolHit l_tpolHit;
   vl_tid = H5Tvlen_create(l_tpolHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tpolHit", (char*)&m_hdf5_record.vl_tpolHit - (char*)&m_hdf5_record, vl_tid);
   TpolSector l_tpolSector;
   vl_tid = H5Tvlen_create(l_tpolSector.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tpolSector", (char*)&m_hdf5_record.vl_tpolSector - (char*)&m_hdf5_record, vl_tid);
   TpolTruthHit l_tpolTruthHit;
   vl_tid = H5Tvlen_create(l_tpolTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tpolTruthHit", (char*)&m_hdf5_record.vl_tpolTruthHit - (char*)&m_hdf5_record, vl_tid);
   TpolTruthPoint l_tpolTruthPoint;
   vl_tid = H5Tvlen_create(l_tpolTruthPoint.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tpolTruthPoint", (char*)&m_hdf5_record.vl_tpolTruthPoint - (char*)&m_hdf5_record, vl_tid);
   TrackID l_trackID;
   vl_tid = H5Tvlen_create(l_trackID.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_trackID", (char*)&m_hdf5_record.vl_trackID - (char*)&m_hdf5_record, vl_tid);
   Tracktimebased l_tracktimebased;
   vl_tid = H5Tvlen_create(l_tracktimebased.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tracktimebased", (char*)&m_hdf5_record.vl_tracktimebased - (char*)&m_hdf5_record, vl_tid);
   TripletPolarimeter l_tripletPolarimeter;
   vl_tid = H5Tvlen_create(l_tripletPolarimeter.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_tripletPolarimeter", (char*)&m_hdf5_record.vl_tripletPolarimeter - (char*)&m_hdf5_record, vl_tid);
   UpstreamEMveto l_upstreamEMveto;
   vl_tid = H5Tvlen_create(l_upstreamEMveto.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_upstreamEMveto", (char*)&m_hdf5_record.vl_upstreamEMveto - (char*)&m_hdf5_record, vl_tid);
   UpvHit l_upvHit;
   vl_tid = H5Tvlen_create(l_upvHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_upvHit", (char*)&m_hdf5_record.vl_upvHit - (char*)&m_hdf5_record, vl_tid);
   UpvPaddle l_upvPaddle;
   vl_tid = H5Tvlen_create(l_upvPaddle.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_upvPaddle", (char*)&m_hdf5_record.vl_upvPaddle - (char*)&m_hdf5_record, vl_tid);
   UpvTruthHit l_upvTruthHit;
   vl_tid = H5Tvlen_create(l_upvTruthHit.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_upvTruthHit", (char*)&m_hdf5_record.vl_upvTruthHit - (char*)&m_hdf5_record, vl_tid);
   UpvTruthShower l_upvTruthShower;
   vl_tid = H5Tvlen_create(l_upvTruthShower.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_upvTruthShower", (char*)&m_hdf5_record.vl_upvTruthShower - (char*)&m_hdf5_record, vl_tid);
   UserData l_userData;
   vl_tid = H5Tvlen_create(l_userData.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_userData", (char*)&m_hdf5_record.vl_userData - (char*)&m_hdf5_record, vl_tid);
   UserDataFloat l_userDataFloat;
   vl_tid = H5Tvlen_create(l_userDataFloat.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_userDataFloat", (char*)&m_hdf5_record.vl_userDataFloat - (char*)&m_hdf5_record, vl_tid);
   UserDataInt l_userDataInt;
   vl_tid = H5Tvlen_create(l_userDataInt.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_userDataInt", (char*)&m_hdf5_record.vl_userDataInt - (char*)&m_hdf5_record, vl_tid);
   Vertex l_vertex;
   vl_tid = H5Tvlen_create(l_vertex.hdf5Datatype(inmemory));
   H5Tinsert(tid, "vl_vertex", (char*)&m_hdf5_record.vl_vertex - (char*)&m_hdf5_record, vl_tid);
   if (inmemory == 0)
      H5Tpack(tid);
   if (inmemory) {
      HDDM::s_hdf5_memorytype["HDDM"] = tid;
   }
   else {
      HDDM::s_hdf5_datatype["HDDM"] = tid;
   }
   if (verbose) {
      size_t slen;
      H5LTdtype_to_text(tid, 0, H5LT_DDL, &slen);
      char *ddlstring = (char*)malloc(slen);
      H5LTdtype_to_text(tid, ddlstring, H5LT_DDL, &slen);
      if (inmemory)
         printf("=== in-memory datatype %ld for %s is:\n %s\n", (long int)tid, "HDDM", ddlstring);
      else
         printf("=== on-disk datatype %ld for %s is:\n %s\n", (long int)tid, "HDDM", ddlstring);
      free(ddlstring);
   }
   return tid;
}
herr_t HDDM::hdf5FileStamp(hid_t file_id, char **tags)
{
   std::string stamp(DocumentString());
   while (tags != 0 && *tags != 0) {
      stamp += "<stamptag>";
      stamp += *tags;
      stamp += "</stamptag>\n";
      ++tags;
   }
   hid_t stamp_tid = H5Tcopy(H5T_C_S1);
   H5Tset_size(stamp_tid, H5T_VARIABLE);
   hsize_t dims[1] = {1};
   hsize_t maxdims[1] = {1};
   hid_t stamp_sid = H5Screate_simple(1, dims, maxdims);
   char *pstamp = (char*)stamp.c_str();
   hid_t stamp_id = H5Lexists(file_id, "HDDMstamp", H5P_DEFAULT);
   if (stamp_id > 0) {
      stamp_id = H5Dopen(file_id, "HDDMstamp", H5P_DEFAULT);
   }
   else {
      stamp_id = H5Dcreate(file_id, "HDDMstamp",
                           stamp_tid, stamp_sid,
                           H5P_DEFAULT, H5P_DEFAULT,
                           H5P_DEFAULT);
   }
   herr_t res = H5Dwrite(stamp_id, stamp_tid,
                         H5S_ALL, H5S_ALL,
                         H5P_DEFAULT, &pstamp);
   return res;
}
herr_t HDDM::hdf5FileCheck(hid_t file_id, char **tags)
{
   char *pstamp;
   hid_t stamp_id = H5Dopen(file_id, "HDDMstamp", H5P_DEFAULT);
   hid_t stamp_sid = H5Dget_space(stamp_id);
   hid_t stamp_tid = H5Dget_type(stamp_id);
   stamp_tid = H5Tget_native_type(stamp_tid, H5T_DIR_DEFAULT);
   herr_t res = H5Dread(stamp_id, stamp_tid,
                        H5S_ALL, H5S_ALL,
                        H5P_DEFAULT, &pstamp);
   std::string sstamp(pstamp);
   H5Dvlen_reclaim(stamp_tid, stamp_sid,
                   H5P_DEFAULT, &pstamp);
   if (sstamp.find(DocumentString()) != 0) {
      throw std::runtime_error("hddm_s::hdf5FileCheck - "
                  "HDF5 input record format mismatch!");
   }
   while (tags != 0 && *tags != 0) {
      std::string stag("<stamptag>");
      stag += *tags;
      stag += "</stamptag>";
      if (sstamp.find(stag) == sstamp.npos) {
         throw std::runtime_error("hddm_s::hdf5FileCheck - "
                  "HDF5 input record tag is missing!");
      }
      ++tags;
   }
   H5Dclose(stamp_id);
   return res;
}
std::string HDDM::hdf5DocumentString(hid_t file_id)
{
   char *pstamp;
   hid_t stamp_id = H5Dopen(file_id, "HDDMstamp", H5P_DEFAULT);
   hid_t stamp_sid = H5Dget_space(stamp_id);
   hid_t stamp_tid = H5Dget_type(stamp_id);
   stamp_tid = H5Tget_native_type(stamp_tid, H5T_DIR_DEFAULT);
   H5Dread(stamp_id, stamp_tid,
           H5S_ALL, H5S_ALL, H5P_DEFAULT, &pstamp);
   std::string sstamp(pstamp);
   H5Dvlen_reclaim(stamp_tid, stamp_sid,
                   H5P_DEFAULT, &pstamp);
   H5Dclose(stamp_id);
   return sstamp;
}
hsize_t HDDM::hdf5GetEntries(hid_t file_id)
{
   hid_t eventspace_id;
   hid_t eventdata_id;
   hid_t chunking_id;
   htri_t exists =   H5Lexists(file_id, "HDDMevents", H5P_DEFAULT);
   if (exists <= 0)
      return exists;
   if (s_hdf5_dataset.find(file_id) == s_hdf5_dataset.end()) {

      eventdata_id = H5Dopen(file_id, "HDDMevents",
                               H5P_DEFAULT);
      chunking_id = H5Dget_create_plist(eventdata_id);
      eventspace_id = H5Dget_space(eventdata_id);
      s_hdf5_dataset[file_id] = eventdata_id;
      s_hdf5_chunking[file_id] = chunking_id;
      s_hdf5_dataspace[file_id] = eventspace_id;
   }
   else {
      eventdata_id = s_hdf5_dataset[file_id];
      chunking_id = s_hdf5_chunking[file_id];
      eventspace_id = s_hdf5_dataspace[file_id];
   }
   hsize_t dims;
   hsize_t maxdims;
   H5Sget_simple_extent_dims(eventspace_id, &dims, &maxdims);
   return dims;
}
herr_t HDDM::hdf5SetChunksize(hid_t file_id, hsize_t chunksize)
{
   hid_t chunking_id;
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      chunking_id = H5Pcreate(H5P_DATASET_CREATE);
      s_hdf5_chunking[file_id] = chunking_id;
   }
   else {
      chunking_id = s_hdf5_chunking[file_id];
   }
   hsize_t chunks[1] = {chunksize};
   return H5Pset_chunk(chunking_id, 1, chunks);
}
hsize_t HDDM::hdf5GetChunksize(hid_t file_id)
{
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      return HDF5_DEFAULT_CHUNK_SIZE;
   }
   hid_t chunking_id = s_hdf5_chunking[file_id];
   hsize_t dims[1];
   H5Pget_chunk(chunking_id, 1, dims);
   return dims[0];
}
herr_t HDDM::hdf5SetFilters(hid_t file_id, std::vector<H5Z_filter_t> &filters)
{
   hid_t chunking_id;
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      chunking_id = H5Pcreate(H5P_DATASET_CREATE);
      s_hdf5_chunking[file_id] = chunking_id;
   }
   else {
      chunking_id = s_hdf5_chunking[file_id];
   }
   for (auto filter : filters) {
      if (filter == H5Z_FILTER_DEFLATE) {
         H5Pset_deflate(chunking_id, 9);
      }
      else if (filter == H5Z_FILTER_SZIP) {
         H5Pset_szip(chunking_id, H5_SZIP_NN_OPTION_MASK, 8);
      }
      else if (filter == H5Z_FILTER_SHUFFLE) {
         H5Pset_shuffle(chunking_id);
      }
      else if (filter == H5Z_FILTER_SCALEOFFSET) {
         H5Pset_scaleoffset(chunking_id, H5Z_SO_INT,
                            H5Z_SO_INT_MINBITS_DEFAULT);
      }
      else if (filter == H5Z_FILTER_NBIT) {
         H5Pset_nbit(chunking_id);
      }
      else if (filter == H5Z_FILTER_FLETCHER32) {
         H5Pset_fletcher32(chunking_id);
      }
      else {
         unsigned int cd_values[] = {6};
         H5Pset_filter(chunking_id, filter,
                       H5Z_FLAG_MANDATORY, (size_t)1, cd_values);      }

   }
   return 0;
}
herr_t HDDM::hdf5GetFilters(hid_t file_id, std::vector<H5Z_filter_t> &filters)
{
   filters.clear();
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      return 0;
   }
   hid_t chunking_id = s_hdf5_chunking[file_id];
   for (int i=0; i < H5Pget_nfilters(chunking_id); ++i) {
      unsigned int flags;
      size_t cd_nelmts = 9;
      unsigned int cd_values[9];
      size_t namelen = 99;
      char name[99];
      unsigned int filter_config;
      filters.push_back(H5Pget_filter2(chunking_id, i,
                        &flags, &cd_nelmts, cd_values,
                        namelen, name, &filter_config));
   }
   return 0;
}
herr_t HDDM::hdf5FileWrite(hid_t file_id, long int entry)
{
   hdf5_record_t hdf5_record;
   int size;

   size_t len;

   if ((len = hdf5_record.vl_Cerenkov.len = m_Cerenkov_plist.size()) > 0) {
      size = sizeof(Cerenkov);
      hdf5_record.vl_Cerenkov.p = malloc(len * size);
      std::list<Cerenkov*>::iterator iter = m_Cerenkov_plist.begin();
      Cerenkov *p = (Cerenkov*)hdf5_record.vl_Cerenkov.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ComptonEMcal.len = m_ComptonEMcal_plist.size()) > 0) {
      size = sizeof(ComptonEMcal);
      hdf5_record.vl_ComptonEMcal.p = malloc(len * size);
      std::list<ComptonEMcal*>::iterator iter = m_ComptonEMcal_plist.begin();
      ComptonEMcal *p = (ComptonEMcal*)hdf5_record.vl_ComptonEMcal.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_CrystalEcal.len = m_CrystalEcal_plist.size()) > 0) {
      size = sizeof(CrystalEcal);
      hdf5_record.vl_CrystalEcal.p = malloc(len * size);
      std::list<CrystalEcal*>::iterator iter = m_CrystalEcal_plist.begin();
      CrystalEcal *p = (CrystalEcal*)hdf5_record.vl_CrystalEcal.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_DIRC.len = m_DIRC_plist.size()) > 0) {
      size = sizeof(DIRC);
      hdf5_record.vl_DIRC.p = malloc(len * size);
      std::list<DIRC*>::iterator iter = m_DIRC_plist.begin();
      DIRC *p = (DIRC*)hdf5_record.vl_DIRC.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_RFsubsystem.len = m_RFsubsystem_plist.size()) > 0) {
      size = sizeof(RFsubsystem);
      hdf5_record.vl_RFsubsystem.p = malloc(len * size);
      std::list<RFsubsystem*>::iterator iter = m_RFsubsystem_plist.begin();
      RFsubsystem *p = (RFsubsystem*)hdf5_record.vl_RFsubsystem.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_RFtime.len = m_RFtime_plist.size()) > 0) {
      size = sizeof(RFtime);
      hdf5_record.vl_RFtime.p = malloc(len * size);
      std::list<RFtime*>::iterator iter = m_RFtime_plist.begin();
      RFtime *p = (RFtime*)hdf5_record.vl_RFtime.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_RICH.len = m_RICH_plist.size()) > 0) {
      size = sizeof(RICH);
      hdf5_record.vl_RICH.p = malloc(len * size);
      std::list<RICH*>::iterator iter = m_RICH_plist.begin();
      RICH *p = (RICH*)hdf5_record.vl_RICH.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_TrackingErrorMatrix.len = m_TrackingErrorMatrix_plist.size()) > 0) {
      size = sizeof(TrackingErrorMatrix);
      hdf5_record.vl_TrackingErrorMatrix.p = malloc(len * size);
      std::list<TrackingErrorMatrix*>::iterator iter = m_TrackingErrorMatrix_plist.begin();
      TrackingErrorMatrix *p = (TrackingErrorMatrix*)hdf5_record.vl_TrackingErrorMatrix.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_barrelEMcal.len = m_barrelEMcal_plist.size()) > 0) {
      size = sizeof(BarrelEMcal);
      hdf5_record.vl_barrelEMcal.p = malloc(len * size);
      std::list<BarrelEMcal*>::iterator iter = m_barrelEMcal_plist.begin();
      BarrelEMcal *p = (BarrelEMcal*)hdf5_record.vl_barrelEMcal.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalCell.len = m_bcalCell_plist.size()) > 0) {
      size = sizeof(BcalCell);
      hdf5_record.vl_bcalCell.p = malloc(len * size);
      std::list<BcalCell*>::iterator iter = m_bcalCell_plist.begin();
      BcalCell *p = (BcalCell*)hdf5_record.vl_bcalCell.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalSiPMDownHit.len = m_bcalSiPMDownHit_plist.size()) > 0) {
      size = sizeof(BcalSiPMDownHit);
      hdf5_record.vl_bcalSiPMDownHit.p = malloc(len * size);
      std::list<BcalSiPMDownHit*>::iterator iter = m_bcalSiPMDownHit_plist.begin();
      BcalSiPMDownHit *p = (BcalSiPMDownHit*)hdf5_record.vl_bcalSiPMDownHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalSiPMSpectrum.len = m_bcalSiPMSpectrum_plist.size()) > 0) {
      size = sizeof(BcalSiPMSpectrum);
      hdf5_record.vl_bcalSiPMSpectrum.p = malloc(len * size);
      std::list<BcalSiPMSpectrum*>::iterator iter = m_bcalSiPMSpectrum_plist.begin();
      BcalSiPMSpectrum *p = (BcalSiPMSpectrum*)hdf5_record.vl_bcalSiPMSpectrum.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalSiPMTruth.len = m_bcalSiPMTruth_plist.size()) > 0) {
      size = sizeof(BcalSiPMTruth);
      hdf5_record.vl_bcalSiPMTruth.p = malloc(len * size);
      std::list<BcalSiPMTruth*>::iterator iter = m_bcalSiPMTruth_plist.begin();
      BcalSiPMTruth *p = (BcalSiPMTruth*)hdf5_record.vl_bcalSiPMTruth.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalSiPMUpHit.len = m_bcalSiPMUpHit_plist.size()) > 0) {
      size = sizeof(BcalSiPMUpHit);
      hdf5_record.vl_bcalSiPMUpHit.p = malloc(len * size);
      std::list<BcalSiPMUpHit*>::iterator iter = m_bcalSiPMUpHit_plist.begin();
      BcalSiPMUpHit *p = (BcalSiPMUpHit*)hdf5_record.vl_bcalSiPMUpHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalTDCDigiHit.len = m_bcalTDCDigiHit_plist.size()) > 0) {
      size = sizeof(BcalTDCDigiHit);
      hdf5_record.vl_bcalTDCDigiHit.p = malloc(len * size);
      std::list<BcalTDCDigiHit*>::iterator iter = m_bcalTDCDigiHit_plist.begin();
      BcalTDCDigiHit *p = (BcalTDCDigiHit*)hdf5_record.vl_bcalTDCDigiHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalTDCHit.len = m_bcalTDCHit_plist.size()) > 0) {
      size = sizeof(BcalTDCHit);
      hdf5_record.vl_bcalTDCHit.p = malloc(len * size);
      std::list<BcalTDCHit*>::iterator iter = m_bcalTDCHit_plist.begin();
      BcalTDCHit *p = (BcalTDCHit*)hdf5_record.vl_bcalTDCHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalTruthHit.len = m_bcalTruthHit_plist.size()) > 0) {
      size = sizeof(BcalTruthHit);
      hdf5_record.vl_bcalTruthHit.p = malloc(len * size);
      std::list<BcalTruthHit*>::iterator iter = m_bcalTruthHit_plist.begin();
      BcalTruthHit *p = (BcalTruthHit*)hdf5_record.vl_bcalTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalTruthIncidentParticle.len = m_bcalTruthIncidentParticle_plist.size()) > 0) {
      size = sizeof(BcalTruthIncidentParticle);
      hdf5_record.vl_bcalTruthIncidentParticle.p = malloc(len * size);
      std::list<BcalTruthIncidentParticle*>::iterator iter = m_bcalTruthIncidentParticle_plist.begin();
      BcalTruthIncidentParticle *p = (BcalTruthIncidentParticle*)hdf5_record.vl_bcalTruthIncidentParticle.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalTruthShower.len = m_bcalTruthShower_plist.size()) > 0) {
      size = sizeof(BcalTruthShower);
      hdf5_record.vl_bcalTruthShower.p = malloc(len * size);
      std::list<BcalTruthShower*>::iterator iter = m_bcalTruthShower_plist.begin();
      BcalTruthShower *p = (BcalTruthShower*)hdf5_record.vl_bcalTruthShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalfADCDigiHit.len = m_bcalfADCDigiHit_plist.size()) > 0) {
      size = sizeof(BcalfADCDigiHit);
      hdf5_record.vl_bcalfADCDigiHit.p = malloc(len * size);
      std::list<BcalfADCDigiHit*>::iterator iter = m_bcalfADCDigiHit_plist.begin();
      BcalfADCDigiHit *p = (BcalfADCDigiHit*)hdf5_record.vl_bcalfADCDigiHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalfADCHit.len = m_bcalfADCHit_plist.size()) > 0) {
      size = sizeof(BcalfADCHit);
      hdf5_record.vl_bcalfADCHit.p = malloc(len * size);
      std::list<BcalfADCHit*>::iterator iter = m_bcalfADCHit_plist.begin();
      BcalfADCHit *p = (BcalfADCHit*)hdf5_record.vl_bcalfADCHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_bcalfADCPeak.len = m_bcalfADCPeak_plist.size()) > 0) {
      size = sizeof(BcalfADCPeak);
      hdf5_record.vl_bcalfADCPeak.p = malloc(len * size);
      std::list<BcalfADCPeak*>::iterator iter = m_bcalfADCPeak_plist.begin();
      BcalfADCPeak *p = (BcalfADCPeak*)hdf5_record.vl_bcalfADCPeak.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_beam.len = m_beam_plist.size()) > 0) {
      size = sizeof(Beam);
      hdf5_record.vl_beam.p = malloc(len * size);
      std::list<Beam*>::iterator iter = m_beam_plist.begin();
      Beam *p = (Beam*)hdf5_record.vl_beam.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccalBlock.len = m_ccalBlock_plist.size()) > 0) {
      size = sizeof(CcalBlock);
      hdf5_record.vl_ccalBlock.p = malloc(len * size);
      std::list<CcalBlock*>::iterator iter = m_ccalBlock_plist.begin();
      CcalBlock *p = (CcalBlock*)hdf5_record.vl_ccalBlock.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccalHit.len = m_ccalHit_plist.size()) > 0) {
      size = sizeof(CcalHit);
      hdf5_record.vl_ccalHit.p = malloc(len * size);
      std::list<CcalHit*>::iterator iter = m_ccalHit_plist.begin();
      CcalHit *p = (CcalHit*)hdf5_record.vl_ccalHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccalTruthHit.len = m_ccalTruthHit_plist.size()) > 0) {
      size = sizeof(CcalTruthHit);
      hdf5_record.vl_ccalTruthHit.p = malloc(len * size);
      std::list<CcalTruthHit*>::iterator iter = m_ccalTruthHit_plist.begin();
      CcalTruthHit *p = (CcalTruthHit*)hdf5_record.vl_ccalTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccalTruthShower.len = m_ccalTruthShower_plist.size()) > 0) {
      size = sizeof(CcalTruthShower);
      hdf5_record.vl_ccalTruthShower.p = malloc(len * size);
      std::list<CcalTruthShower*>::iterator iter = m_ccalTruthShower_plist.begin();
      CcalTruthShower *p = (CcalTruthShower*)hdf5_record.vl_ccalTruthShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ccdbContext.len = m_ccdbContext_plist.size()) > 0) {
      size = sizeof(CcdbContext);
      hdf5_record.vl_ccdbContext.p = malloc(len * size);
      std::list<CcdbContext*>::iterator iter = m_ccdbContext_plist.begin();
      CcdbContext *p = (CcdbContext*)hdf5_record.vl_ccdbContext.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cdcDigihit.len = m_cdcDigihit_plist.size()) > 0) {
      size = sizeof(CdcDigihit);
      hdf5_record.vl_cdcDigihit.p = malloc(len * size);
      std::list<CdcDigihit*>::iterator iter = m_cdcDigihit_plist.begin();
      CdcDigihit *p = (CdcDigihit*)hdf5_record.vl_cdcDigihit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cdcHitQF.len = m_cdcHitQF_plist.size()) > 0) {
      size = sizeof(CdcHitQF);
      hdf5_record.vl_cdcHitQF.p = malloc(len * size);
      std::list<CdcHitQF*>::iterator iter = m_cdcHitQF_plist.begin();
      CdcHitQF *p = (CdcHitQF*)hdf5_record.vl_cdcHitQF.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cdcStraw.len = m_cdcStraw_plist.size()) > 0) {
      size = sizeof(CdcStraw);
      hdf5_record.vl_cdcStraw.p = malloc(len * size);
      std::list<CdcStraw*>::iterator iter = m_cdcStraw_plist.begin();
      CdcStraw *p = (CdcStraw*)hdf5_record.vl_cdcStraw.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cdcStrawHit.len = m_cdcStrawHit_plist.size()) > 0) {
      size = sizeof(CdcStrawHit);
      hdf5_record.vl_cdcStrawHit.p = malloc(len * size);
      std::list<CdcStrawHit*>::iterator iter = m_cdcStrawHit_plist.begin();
      CdcStrawHit *p = (CdcStrawHit*)hdf5_record.vl_cdcStrawHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cdcStrawTruthHit.len = m_cdcStrawTruthHit_plist.size()) > 0) {
      size = sizeof(CdcStrawTruthHit);
      hdf5_record.vl_cdcStrawTruthHit.p = malloc(len * size);
      std::list<CdcStrawTruthHit*>::iterator iter = m_cdcStrawTruthHit_plist.begin();
      CdcStrawTruthHit *p = (CdcStrawTruthHit*)hdf5_record.vl_cdcStrawTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cdcTruthPoint.len = m_cdcTruthPoint_plist.size()) > 0) {
      size = sizeof(CdcTruthPoint);
      hdf5_record.vl_cdcTruthPoint.p = malloc(len * size);
      std::list<CdcTruthPoint*>::iterator iter = m_cdcTruthPoint_plist.begin();
      CdcTruthPoint *p = (CdcTruthPoint*)hdf5_record.vl_cdcTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_centralDC.len = m_centralDC_plist.size()) > 0) {
      size = sizeof(CentralDC);
      hdf5_record.vl_centralDC.p = malloc(len * size);
      std::list<CentralDC*>::iterator iter = m_centralDC_plist.begin();
      CentralDC *p = (CentralDC*)hdf5_record.vl_centralDC.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cereHit.len = m_cereHit_plist.size()) > 0) {
      size = sizeof(CereHit);
      hdf5_record.vl_cereHit.p = malloc(len * size);
      std::list<CereHit*>::iterator iter = m_cereHit_plist.begin();
      CereHit *p = (CereHit*)hdf5_record.vl_cereHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cereSection.len = m_cereSection_plist.size()) > 0) {
      size = sizeof(CereSection);
      hdf5_record.vl_cereSection.p = malloc(len * size);
      std::list<CereSection*>::iterator iter = m_cereSection_plist.begin();
      CereSection *p = (CereSection*)hdf5_record.vl_cereSection.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cereTruthHit.len = m_cereTruthHit_plist.size()) > 0) {
      size = sizeof(CereTruthHit);
      hdf5_record.vl_cereTruthHit.p = malloc(len * size);
      std::list<CereTruthHit*>::iterator iter = m_cereTruthHit_plist.begin();
      CereTruthHit *p = (CereTruthHit*)hdf5_record.vl_cereTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cereTruthPoint.len = m_cereTruthPoint_plist.size()) > 0) {
      size = sizeof(CereTruthPoint);
      hdf5_record.vl_cereTruthPoint.p = malloc(len * size);
      std::list<CereTruthPoint*>::iterator iter = m_cereTruthPoint_plist.begin();
      CereTruthPoint *p = (CereTruthPoint*)hdf5_record.vl_cereTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_cppTOF.len = m_cppTOF_plist.size()) > 0) {
      size = sizeof(CppTOF);
      hdf5_record.vl_cppTOF.p = malloc(len * size);
      std::list<CppTOF*>::iterator iter = m_cppTOF_plist.begin();
      CppTOF *p = (CppTOF*)hdf5_record.vl_cppTOF.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ctofCounter.len = m_ctofCounter_plist.size()) > 0) {
      size = sizeof(CtofCounter);
      hdf5_record.vl_ctofCounter.p = malloc(len * size);
      std::list<CtofCounter*>::iterator iter = m_ctofCounter_plist.begin();
      CtofCounter *p = (CtofCounter*)hdf5_record.vl_ctofCounter.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ctofHit.len = m_ctofHit_plist.size()) > 0) {
      size = sizeof(CtofHit);
      hdf5_record.vl_ctofHit.p = malloc(len * size);
      std::list<CtofHit*>::iterator iter = m_ctofHit_plist.begin();
      CtofHit *p = (CtofHit*)hdf5_record.vl_ctofHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ctofTruthHit.len = m_ctofTruthHit_plist.size()) > 0) {
      size = sizeof(CtofTruthHit);
      hdf5_record.vl_ctofTruthHit.p = malloc(len * size);
      std::list<CtofTruthHit*>::iterator iter = m_ctofTruthHit_plist.begin();
      CtofTruthHit *p = (CtofTruthHit*)hdf5_record.vl_ctofTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ctofTruthPoint.len = m_ctofTruthPoint_plist.size()) > 0) {
      size = sizeof(CtofTruthPoint);
      hdf5_record.vl_ctofTruthPoint.p = malloc(len * size);
      std::list<CtofTruthPoint*>::iterator iter = m_ctofTruthPoint_plist.begin();
      CtofTruthPoint *p = (CtofTruthPoint*)hdf5_record.vl_ctofTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dataVersionString.len = m_dataVersionString_plist.size()) > 0) {
      size = sizeof(DataVersionString);
      hdf5_record.vl_dataVersionString.p = malloc(len * size);
      std::list<DataVersionString*>::iterator iter = m_dataVersionString_plist.begin();
      DataVersionString *p = (DataVersionString*)hdf5_record.vl_dataVersionString.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircPmtHit.len = m_dircPmtHit_plist.size()) > 0) {
      size = sizeof(DircPmtHit);
      hdf5_record.vl_dircPmtHit.p = malloc(len * size);
      std::list<DircPmtHit*>::iterator iter = m_dircPmtHit_plist.begin();
      DircPmtHit *p = (DircPmtHit*)hdf5_record.vl_dircPmtHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircTruthBarHit.len = m_dircTruthBarHit_plist.size()) > 0) {
      size = sizeof(DircTruthBarHit);
      hdf5_record.vl_dircTruthBarHit.p = malloc(len * size);
      std::list<DircTruthBarHit*>::iterator iter = m_dircTruthBarHit_plist.begin();
      DircTruthBarHit *p = (DircTruthBarHit*)hdf5_record.vl_dircTruthBarHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircTruthPmtHit.len = m_dircTruthPmtHit_plist.size()) > 0) {
      size = sizeof(DircTruthPmtHit);
      hdf5_record.vl_dircTruthPmtHit.p = malloc(len * size);
      std::list<DircTruthPmtHit*>::iterator iter = m_dircTruthPmtHit_plist.begin();
      DircTruthPmtHit *p = (DircTruthPmtHit*)hdf5_record.vl_dircTruthPmtHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_dircTruthPmtHitExtra.len = m_dircTruthPmtHitExtra_plist.size()) > 0) {
      size = sizeof(DircTruthPmtHitExtra);
      hdf5_record.vl_dircTruthPmtHitExtra.p = malloc(len * size);
      std::list<DircTruthPmtHitExtra*>::iterator iter = m_dircTruthPmtHitExtra_plist.begin();
      DircTruthPmtHitExtra *p = (DircTruthPmtHitExtra*)hdf5_record.vl_dircTruthPmtHitExtra.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ecalBlock.len = m_ecalBlock_plist.size()) > 0) {
      size = sizeof(EcalBlock);
      hdf5_record.vl_ecalBlock.p = malloc(len * size);
      std::list<EcalBlock*>::iterator iter = m_ecalBlock_plist.begin();
      EcalBlock *p = (EcalBlock*)hdf5_record.vl_ecalBlock.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ecalHit.len = m_ecalHit_plist.size()) > 0) {
      size = sizeof(EcalHit);
      hdf5_record.vl_ecalHit.p = malloc(len * size);
      std::list<EcalHit*>::iterator iter = m_ecalHit_plist.begin();
      EcalHit *p = (EcalHit*)hdf5_record.vl_ecalHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ecalTruthHit.len = m_ecalTruthHit_plist.size()) > 0) {
      size = sizeof(EcalTruthHit);
      hdf5_record.vl_ecalTruthHit.p = malloc(len * size);
      std::list<EcalTruthHit*>::iterator iter = m_ecalTruthHit_plist.begin();
      EcalTruthHit *p = (EcalTruthHit*)hdf5_record.vl_ecalTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ecalTruthShower.len = m_ecalTruthShower_plist.size()) > 0) {
      size = sizeof(EcalTruthShower);
      hdf5_record.vl_ecalTruthShower.p = malloc(len * size);
      std::list<EcalTruthShower*>::iterator iter = m_ecalTruthShower_plist.begin();
      EcalTruthShower *p = (EcalTruthShower*)hdf5_record.vl_ecalTruthShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_errorMatrix.len = m_errorMatrix_plist.size()) > 0) {
      size = sizeof(ErrorMatrix);
      hdf5_record.vl_errorMatrix.p = malloc(len * size);
      std::list<ErrorMatrix*>::iterator iter = m_errorMatrix_plist.begin();
      ErrorMatrix *p = (ErrorMatrix*)hdf5_record.vl_errorMatrix.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalBlock.len = m_fcalBlock_plist.size()) > 0) {
      size = sizeof(FcalBlock);
      hdf5_record.vl_fcalBlock.p = malloc(len * size);
      std::list<FcalBlock*>::iterator iter = m_fcalBlock_plist.begin();
      FcalBlock *p = (FcalBlock*)hdf5_record.vl_fcalBlock.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalDigihit.len = m_fcalDigihit_plist.size()) > 0) {
      size = sizeof(FcalDigihit);
      hdf5_record.vl_fcalDigihit.p = malloc(len * size);
      std::list<FcalDigihit*>::iterator iter = m_fcalDigihit_plist.begin();
      FcalDigihit *p = (FcalDigihit*)hdf5_record.vl_fcalDigihit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalHit.len = m_fcalHit_plist.size()) > 0) {
      size = sizeof(FcalHit);
      hdf5_record.vl_fcalHit.p = malloc(len * size);
      std::list<FcalHit*>::iterator iter = m_fcalHit_plist.begin();
      FcalHit *p = (FcalHit*)hdf5_record.vl_fcalHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalTruthHit.len = m_fcalTruthHit_plist.size()) > 0) {
      size = sizeof(FcalTruthHit);
      hdf5_record.vl_fcalTruthHit.p = malloc(len * size);
      std::list<FcalTruthHit*>::iterator iter = m_fcalTruthHit_plist.begin();
      FcalTruthHit *p = (FcalTruthHit*)hdf5_record.vl_fcalTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalTruthLightGuide.len = m_fcalTruthLightGuide_plist.size()) > 0) {
      size = sizeof(FcalTruthLightGuide);
      hdf5_record.vl_fcalTruthLightGuide.p = malloc(len * size);
      std::list<FcalTruthLightGuide*>::iterator iter = m_fcalTruthLightGuide_plist.begin();
      FcalTruthLightGuide *p = (FcalTruthLightGuide*)hdf5_record.vl_fcalTruthLightGuide.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fcalTruthShower.len = m_fcalTruthShower_plist.size()) > 0) {
      size = sizeof(FcalTruthShower);
      hdf5_record.vl_fcalTruthShower.p = malloc(len * size);
      std::list<FcalTruthShower*>::iterator iter = m_fcalTruthShower_plist.begin();
      FcalTruthShower *p = (FcalTruthShower*)hdf5_record.vl_fcalTruthShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcAnodeHit.len = m_fdcAnodeHit_plist.size()) > 0) {
      size = sizeof(FdcAnodeHit);
      hdf5_record.vl_fdcAnodeHit.p = malloc(len * size);
      std::list<FdcAnodeHit*>::iterator iter = m_fdcAnodeHit_plist.begin();
      FdcAnodeHit *p = (FdcAnodeHit*)hdf5_record.vl_fdcAnodeHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcAnodeTruthHit.len = m_fdcAnodeTruthHit_plist.size()) > 0) {
      size = sizeof(FdcAnodeTruthHit);
      hdf5_record.vl_fdcAnodeTruthHit.p = malloc(len * size);
      std::list<FdcAnodeTruthHit*>::iterator iter = m_fdcAnodeTruthHit_plist.begin();
      FdcAnodeTruthHit *p = (FdcAnodeTruthHit*)hdf5_record.vl_fdcAnodeTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcAnodeWire.len = m_fdcAnodeWire_plist.size()) > 0) {
      size = sizeof(FdcAnodeWire);
      hdf5_record.vl_fdcAnodeWire.p = malloc(len * size);
      std::list<FdcAnodeWire*>::iterator iter = m_fdcAnodeWire_plist.begin();
      FdcAnodeWire *p = (FdcAnodeWire*)hdf5_record.vl_fdcAnodeWire.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcCathodeHit.len = m_fdcCathodeHit_plist.size()) > 0) {
      size = sizeof(FdcCathodeHit);
      hdf5_record.vl_fdcCathodeHit.p = malloc(len * size);
      std::list<FdcCathodeHit*>::iterator iter = m_fdcCathodeHit_plist.begin();
      FdcCathodeHit *p = (FdcCathodeHit*)hdf5_record.vl_fdcCathodeHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcCathodeStrip.len = m_fdcCathodeStrip_plist.size()) > 0) {
      size = sizeof(FdcCathodeStrip);
      hdf5_record.vl_fdcCathodeStrip.p = malloc(len * size);
      std::list<FdcCathodeStrip*>::iterator iter = m_fdcCathodeStrip_plist.begin();
      FdcCathodeStrip *p = (FdcCathodeStrip*)hdf5_record.vl_fdcCathodeStrip.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcCathodeTruthHit.len = m_fdcCathodeTruthHit_plist.size()) > 0) {
      size = sizeof(FdcCathodeTruthHit);
      hdf5_record.vl_fdcCathodeTruthHit.p = malloc(len * size);
      std::list<FdcCathodeTruthHit*>::iterator iter = m_fdcCathodeTruthHit_plist.begin();
      FdcCathodeTruthHit *p = (FdcCathodeTruthHit*)hdf5_record.vl_fdcCathodeTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcChamber.len = m_fdcChamber_plist.size()) > 0) {
      size = sizeof(FdcChamber);
      hdf5_record.vl_fdcChamber.p = malloc(len * size);
      std::list<FdcChamber*>::iterator iter = m_fdcChamber_plist.begin();
      FdcChamber *p = (FdcChamber*)hdf5_record.vl_fdcChamber.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcDigihit.len = m_fdcDigihit_plist.size()) > 0) {
      size = sizeof(FdcDigihit);
      hdf5_record.vl_fdcDigihit.p = malloc(len * size);
      std::list<FdcDigihit*>::iterator iter = m_fdcDigihit_plist.begin();
      FdcDigihit *p = (FdcDigihit*)hdf5_record.vl_fdcDigihit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fdcTruthPoint.len = m_fdcTruthPoint_plist.size()) > 0) {
      size = sizeof(FdcTruthPoint);
      hdf5_record.vl_fdcTruthPoint.p = malloc(len * size);
      std::list<FdcTruthPoint*>::iterator iter = m_fdcTruthPoint_plist.begin();
      FdcTruthPoint *p = (FdcTruthPoint*)hdf5_record.vl_fdcTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcChamber.len = m_fmwpcChamber_plist.size()) > 0) {
      size = sizeof(FmwpcChamber);
      hdf5_record.vl_fmwpcChamber.p = malloc(len * size);
      std::list<FmwpcChamber*>::iterator iter = m_fmwpcChamber_plist.begin();
      FmwpcChamber *p = (FmwpcChamber*)hdf5_record.vl_fmwpcChamber.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcHit.len = m_fmwpcHit_plist.size()) > 0) {
      size = sizeof(FmwpcHit);
      hdf5_record.vl_fmwpcHit.p = malloc(len * size);
      std::list<FmwpcHit*>::iterator iter = m_fmwpcHit_plist.begin();
      FmwpcHit *p = (FmwpcHit*)hdf5_record.vl_fmwpcHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcHitQ.len = m_fmwpcHitQ_plist.size()) > 0) {
      size = sizeof(FmwpcHitQ);
      hdf5_record.vl_fmwpcHitQ.p = malloc(len * size);
      std::list<FmwpcHitQ*>::iterator iter = m_fmwpcHitQ_plist.begin();
      FmwpcHitQ *p = (FmwpcHitQ*)hdf5_record.vl_fmwpcHitQ.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcTruthHit.len = m_fmwpcTruthHit_plist.size()) > 0) {
      size = sizeof(FmwpcTruthHit);
      hdf5_record.vl_fmwpcTruthHit.p = malloc(len * size);
      std::list<FmwpcTruthHit*>::iterator iter = m_fmwpcTruthHit_plist.begin();
      FmwpcTruthHit *p = (FmwpcTruthHit*)hdf5_record.vl_fmwpcTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcTruthHitQ.len = m_fmwpcTruthHitQ_plist.size()) > 0) {
      size = sizeof(FmwpcTruthHitQ);
      hdf5_record.vl_fmwpcTruthHitQ.p = malloc(len * size);
      std::list<FmwpcTruthHitQ*>::iterator iter = m_fmwpcTruthHitQ_plist.begin();
      FmwpcTruthHitQ *p = (FmwpcTruthHitQ*)hdf5_record.vl_fmwpcTruthHitQ.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_fmwpcTruthPoint.len = m_fmwpcTruthPoint_plist.size()) > 0) {
      size = sizeof(FmwpcTruthPoint);
      hdf5_record.vl_fmwpcTruthPoint.p = malloc(len * size);
      std::list<FmwpcTruthPoint*>::iterator iter = m_fmwpcTruthPoint_plist.begin();
      FmwpcTruthPoint *p = (FmwpcTruthPoint*)hdf5_record.vl_fmwpcTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_forwardDC.len = m_forwardDC_plist.size()) > 0) {
      size = sizeof(ForwardDC);
      hdf5_record.vl_forwardDC.p = malloc(len * size);
      std::list<ForwardDC*>::iterator iter = m_forwardDC_plist.begin();
      ForwardDC *p = (ForwardDC*)hdf5_record.vl_forwardDC.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_forwardEMcal.len = m_forwardEMcal_plist.size()) > 0) {
      size = sizeof(ForwardEMcal);
      hdf5_record.vl_forwardEMcal.p = malloc(len * size);
      std::list<ForwardEMcal*>::iterator iter = m_forwardEMcal_plist.begin();
      ForwardEMcal *p = (ForwardEMcal*)hdf5_record.vl_forwardEMcal.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_forwardMWPC.len = m_forwardMWPC_plist.size()) > 0) {
      size = sizeof(ForwardMWPC);
      hdf5_record.vl_forwardMWPC.p = malloc(len * size);
      std::list<ForwardMWPC*>::iterator iter = m_forwardMWPC_plist.begin();
      ForwardMWPC *p = (ForwardMWPC*)hdf5_record.vl_forwardMWPC.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_forwardTOF.len = m_forwardTOF_plist.size()) > 0) {
      size = sizeof(ForwardTOF);
      hdf5_record.vl_forwardTOF.p = malloc(len * size);
      std::list<ForwardTOF*>::iterator iter = m_forwardTOF_plist.begin();
      ForwardTOF *p = (ForwardTOF*)hdf5_record.vl_forwardTOF.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ftofCounter.len = m_ftofCounter_plist.size()) > 0) {
      size = sizeof(FtofCounter);
      hdf5_record.vl_ftofCounter.p = malloc(len * size);
      std::list<FtofCounter*>::iterator iter = m_ftofCounter_plist.begin();
      FtofCounter *p = (FtofCounter*)hdf5_record.vl_ftofCounter.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ftofDigihit.len = m_ftofDigihit_plist.size()) > 0) {
      size = sizeof(FtofDigihit);
      hdf5_record.vl_ftofDigihit.p = malloc(len * size);
      std::list<FtofDigihit*>::iterator iter = m_ftofDigihit_plist.begin();
      FtofDigihit *p = (FtofDigihit*)hdf5_record.vl_ftofDigihit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ftofHit.len = m_ftofHit_plist.size()) > 0) {
      size = sizeof(FtofHit);
      hdf5_record.vl_ftofHit.p = malloc(len * size);
      std::list<FtofHit*>::iterator iter = m_ftofHit_plist.begin();
      FtofHit *p = (FtofHit*)hdf5_record.vl_ftofHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ftofTruthExtra.len = m_ftofTruthExtra_plist.size()) > 0) {
      size = sizeof(FtofTruthExtra);
      hdf5_record.vl_ftofTruthExtra.p = malloc(len * size);
      std::list<FtofTruthExtra*>::iterator iter = m_ftofTruthExtra_plist.begin();
      FtofTruthExtra *p = (FtofTruthExtra*)hdf5_record.vl_ftofTruthExtra.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ftofTruthHit.len = m_ftofTruthHit_plist.size()) > 0) {
      size = sizeof(FtofTruthHit);
      hdf5_record.vl_ftofTruthHit.p = malloc(len * size);
      std::list<FtofTruthHit*>::iterator iter = m_ftofTruthHit_plist.begin();
      FtofTruthHit *p = (FtofTruthHit*)hdf5_record.vl_ftofTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_ftofTruthPoint.len = m_ftofTruthPoint_plist.size()) > 0) {
      size = sizeof(FtofTruthPoint);
      hdf5_record.vl_ftofTruthPoint.p = malloc(len * size);
      std::list<FtofTruthPoint*>::iterator iter = m_ftofTruthPoint_plist.begin();
      FtofTruthPoint *p = (FtofTruthPoint*)hdf5_record.vl_ftofTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_gapEMcal.len = m_gapEMcal_plist.size()) > 0) {
      size = sizeof(GapEMcal);
      hdf5_record.vl_gapEMcal.p = malloc(len * size);
      std::list<GapEMcal*>::iterator iter = m_gapEMcal_plist.begin();
      GapEMcal *p = (GapEMcal*)hdf5_record.vl_gapEMcal.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_gcalCell.len = m_gcalCell_plist.size()) > 0) {
      size = sizeof(GcalCell);
      hdf5_record.vl_gcalCell.p = malloc(len * size);
      std::list<GcalCell*>::iterator iter = m_gcalCell_plist.begin();
      GcalCell *p = (GcalCell*)hdf5_record.vl_gcalCell.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_gcalHit.len = m_gcalHit_plist.size()) > 0) {
      size = sizeof(GcalHit);
      hdf5_record.vl_gcalHit.p = malloc(len * size);
      std::list<GcalHit*>::iterator iter = m_gcalHit_plist.begin();
      GcalHit *p = (GcalHit*)hdf5_record.vl_gcalHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_gcalTruthHit.len = m_gcalTruthHit_plist.size()) > 0) {
      size = sizeof(GcalTruthHit);
      hdf5_record.vl_gcalTruthHit.p = malloc(len * size);
      std::list<GcalTruthHit*>::iterator iter = m_gcalTruthHit_plist.begin();
      GcalTruthHit *p = (GcalTruthHit*)hdf5_record.vl_gcalTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_gcalTruthShower.len = m_gcalTruthShower_plist.size()) > 0) {
      size = sizeof(GcalTruthShower);
      hdf5_record.vl_gcalTruthShower.p = malloc(len * size);
      std::list<GcalTruthShower*>::iterator iter = m_gcalTruthShower_plist.begin();
      GcalTruthShower *p = (GcalTruthShower*)hdf5_record.vl_gcalTruthShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_geometry.len = m_geometry_plist.size()) > 0) {
      size = sizeof(Geometry);
      hdf5_record.vl_geometry.p = malloc(len * size);
      std::list<Geometry*>::iterator iter = m_geometry_plist.begin();
      Geometry *p = (Geometry*)hdf5_record.vl_geometry.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_hitView.len = m_hitView_plist.size()) > 0) {
      size = sizeof(HitView);
      hdf5_record.vl_hitView.p = malloc(len * size);
      std::list<HitView*>::iterator iter = m_hitView_plist.begin();
      HitView *p = (HitView*)hdf5_record.vl_hitView.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_hodoChannel.len = m_hodoChannel_plist.size()) > 0) {
      size = sizeof(HodoChannel);
      hdf5_record.vl_hodoChannel.p = malloc(len * size);
      std::list<HodoChannel*>::iterator iter = m_hodoChannel_plist.begin();
      HodoChannel *p = (HodoChannel*)hdf5_record.vl_hodoChannel.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_mcTrajectory.len = m_mcTrajectory_plist.size()) > 0) {
      size = sizeof(McTrajectory);
      hdf5_record.vl_mcTrajectory.p = malloc(len * size);
      std::list<McTrajectory*>::iterator iter = m_mcTrajectory_plist.begin();
      McTrajectory *p = (McTrajectory*)hdf5_record.vl_mcTrajectory.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_mcTrajectoryPoint.len = m_mcTrajectoryPoint_plist.size()) > 0) {
      size = sizeof(McTrajectoryPoint);
      hdf5_record.vl_mcTrajectoryPoint.p = malloc(len * size);
      std::list<McTrajectoryPoint*>::iterator iter = m_mcTrajectoryPoint_plist.begin();
      McTrajectoryPoint *p = (McTrajectoryPoint*)hdf5_record.vl_mcTrajectoryPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_microChannel.len = m_microChannel_plist.size()) > 0) {
      size = sizeof(MicroChannel);
      hdf5_record.vl_microChannel.p = malloc(len * size);
      std::list<MicroChannel*>::iterator iter = m_microChannel_plist.begin();
      MicroChannel *p = (MicroChannel*)hdf5_record.vl_microChannel.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_momentum.len = m_momentum_plist.size()) > 0) {
      size = sizeof(Momentum);
      hdf5_record.vl_momentum.p = malloc(len * size);
      std::list<Momentum*>::iterator iter = m_momentum_plist.begin();
      Momentum *p = (Momentum*)hdf5_record.vl_momentum.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_origin.len = m_origin_plist.size()) > 0) {
      size = sizeof(Origin);
      hdf5_record.vl_origin.p = malloc(len * size);
      std::list<Origin*>::iterator iter = m_origin_plist.begin();
      Origin *p = (Origin*)hdf5_record.vl_origin.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_pairSpectrometerCoarse.len = m_pairSpectrometerCoarse_plist.size()) > 0) {
      size = sizeof(PairSpectrometerCoarse);
      hdf5_record.vl_pairSpectrometerCoarse.p = malloc(len * size);
      std::list<PairSpectrometerCoarse*>::iterator iter = m_pairSpectrometerCoarse_plist.begin();
      PairSpectrometerCoarse *p = (PairSpectrometerCoarse*)hdf5_record.vl_pairSpectrometerCoarse.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_pairSpectrometerFine.len = m_pairSpectrometerFine_plist.size()) > 0) {
      size = sizeof(PairSpectrometerFine);
      hdf5_record.vl_pairSpectrometerFine.p = malloc(len * size);
      std::list<PairSpectrometerFine*>::iterator iter = m_pairSpectrometerFine_plist.begin();
      PairSpectrometerFine *p = (PairSpectrometerFine*)hdf5_record.vl_pairSpectrometerFine.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_physicsEvent.len = m_physicsEvent_plist.size()) > 0) {
      size = sizeof(PhysicsEvent);
      hdf5_record.vl_physicsEvent.p = malloc(len * size);
      std::list<PhysicsEvent*>::iterator iter = m_physicsEvent_plist.begin();
      PhysicsEvent *p = (PhysicsEvent*)hdf5_record.vl_physicsEvent.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_polarization.len = m_polarization_plist.size()) > 0) {
      size = sizeof(Polarization);
      hdf5_record.vl_polarization.p = malloc(len * size);
      std::list<Polarization*>::iterator iter = m_polarization_plist.begin();
      Polarization *p = (Polarization*)hdf5_record.vl_polarization.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_product.len = m_product_plist.size()) > 0) {
      size = sizeof(Product);
      hdf5_record.vl_product.p = malloc(len * size);
      std::list<Product*>::iterator iter = m_product_plist.begin();
      Product *p = (Product*)hdf5_record.vl_product.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_properties.len = m_properties_plist.size()) > 0) {
      size = sizeof(Properties);
      hdf5_record.vl_properties.p = malloc(len * size);
      std::list<Properties*>::iterator iter = m_properties_plist.begin();
      Properties *p = (Properties*)hdf5_record.vl_properties.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_psHit.len = m_psHit_plist.size()) > 0) {
      size = sizeof(PsHit);
      hdf5_record.vl_psHit.p = malloc(len * size);
      std::list<PsHit*>::iterator iter = m_psHit_plist.begin();
      PsHit *p = (PsHit*)hdf5_record.vl_psHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_psTile.len = m_psTile_plist.size()) > 0) {
      size = sizeof(PsTile);
      hdf5_record.vl_psTile.p = malloc(len * size);
      std::list<PsTile*>::iterator iter = m_psTile_plist.begin();
      PsTile *p = (PsTile*)hdf5_record.vl_psTile.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_psTruthHit.len = m_psTruthHit_plist.size()) > 0) {
      size = sizeof(PsTruthHit);
      hdf5_record.vl_psTruthHit.p = malloc(len * size);
      std::list<PsTruthHit*>::iterator iter = m_psTruthHit_plist.begin();
      PsTruthHit *p = (PsTruthHit*)hdf5_record.vl_psTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_psTruthPoint.len = m_psTruthPoint_plist.size()) > 0) {
      size = sizeof(PsTruthPoint);
      hdf5_record.vl_psTruthPoint.p = malloc(len * size);
      std::list<PsTruthPoint*>::iterator iter = m_psTruthPoint_plist.begin();
      PsTruthPoint *p = (PsTruthPoint*)hdf5_record.vl_psTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_pscHit.len = m_pscHit_plist.size()) > 0) {
      size = sizeof(PscHit);
      hdf5_record.vl_pscHit.p = malloc(len * size);
      std::list<PscHit*>::iterator iter = m_pscHit_plist.begin();
      PscHit *p = (PscHit*)hdf5_record.vl_pscHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_pscPaddle.len = m_pscPaddle_plist.size()) > 0) {
      size = sizeof(PscPaddle);
      hdf5_record.vl_pscPaddle.p = malloc(len * size);
      std::list<PscPaddle*>::iterator iter = m_pscPaddle_plist.begin();
      PscPaddle *p = (PscPaddle*)hdf5_record.vl_pscPaddle.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_pscTruthHit.len = m_pscTruthHit_plist.size()) > 0) {
      size = sizeof(PscTruthHit);
      hdf5_record.vl_pscTruthHit.p = malloc(len * size);
      std::list<PscTruthHit*>::iterator iter = m_pscTruthHit_plist.begin();
      PscTruthHit *p = (PscTruthHit*)hdf5_record.vl_pscTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_pscTruthPoint.len = m_pscTruthPoint_plist.size()) > 0) {
      size = sizeof(PscTruthPoint);
      hdf5_record.vl_pscTruthPoint.p = malloc(len * size);
      std::list<PscTruthPoint*>::iterator iter = m_pscTruthPoint_plist.begin();
      PscTruthPoint *p = (PscTruthPoint*)hdf5_record.vl_pscTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_random.len = m_random_plist.size()) > 0) {
      size = sizeof(Random);
      hdf5_record.vl_random.p = malloc(len * size);
      std::list<Random*>::iterator iter = m_random_plist.begin();
      Random *p = (Random*)hdf5_record.vl_random.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_reaction.len = m_reaction_plist.size()) > 0) {
      size = sizeof(Reaction);
      hdf5_record.vl_reaction.p = malloc(len * size);
      std::list<Reaction*>::iterator iter = m_reaction_plist.begin();
      Reaction *p = (Reaction*)hdf5_record.vl_reaction.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_reconView.len = m_reconView_plist.size()) > 0) {
      size = sizeof(ReconView);
      hdf5_record.vl_reconView.p = malloc(len * size);
      std::list<ReconView*>::iterator iter = m_reconView_plist.begin();
      ReconView *p = (ReconView*)hdf5_record.vl_reconView.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_richTruthHit.len = m_richTruthHit_plist.size()) > 0) {
      size = sizeof(RichTruthHit);
      hdf5_record.vl_richTruthHit.p = malloc(len * size);
      std::list<RichTruthHit*>::iterator iter = m_richTruthHit_plist.begin();
      RichTruthHit *p = (RichTruthHit*)hdf5_record.vl_richTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_richTruthPoint.len = m_richTruthPoint_plist.size()) > 0) {
      size = sizeof(RichTruthPoint);
      hdf5_record.vl_richTruthPoint.p = malloc(len * size);
      std::list<RichTruthPoint*>::iterator iter = m_richTruthPoint_plist.begin();
      RichTruthPoint *p = (RichTruthPoint*)hdf5_record.vl_richTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_startCntr.len = m_startCntr_plist.size()) > 0) {
      size = sizeof(StartCntr);
      hdf5_record.vl_startCntr.p = malloc(len * size);
      std::list<StartCntr*>::iterator iter = m_startCntr_plist.begin();
      StartCntr *p = (StartCntr*)hdf5_record.vl_startCntr.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_stcDigihit.len = m_stcDigihit_plist.size()) > 0) {
      size = sizeof(StcDigihit);
      hdf5_record.vl_stcDigihit.p = malloc(len * size);
      std::list<StcDigihit*>::iterator iter = m_stcDigihit_plist.begin();
      StcDigihit *p = (StcDigihit*)hdf5_record.vl_stcDigihit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_stcHit.len = m_stcHit_plist.size()) > 0) {
      size = sizeof(StcHit);
      hdf5_record.vl_stcHit.p = malloc(len * size);
      std::list<StcHit*>::iterator iter = m_stcHit_plist.begin();
      StcHit *p = (StcHit*)hdf5_record.vl_stcHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_stcPaddle.len = m_stcPaddle_plist.size()) > 0) {
      size = sizeof(StcPaddle);
      hdf5_record.vl_stcPaddle.p = malloc(len * size);
      std::list<StcPaddle*>::iterator iter = m_stcPaddle_plist.begin();
      StcPaddle *p = (StcPaddle*)hdf5_record.vl_stcPaddle.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_stcTruthHit.len = m_stcTruthHit_plist.size()) > 0) {
      size = sizeof(StcTruthHit);
      hdf5_record.vl_stcTruthHit.p = malloc(len * size);
      std::list<StcTruthHit*>::iterator iter = m_stcTruthHit_plist.begin();
      StcTruthHit *p = (StcTruthHit*)hdf5_record.vl_stcTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_stcTruthPoint.len = m_stcTruthPoint_plist.size()) > 0) {
      size = sizeof(StcTruthPoint);
      hdf5_record.vl_stcTruthPoint.p = malloc(len * size);
      std::list<StcTruthPoint*>::iterator iter = m_stcTruthPoint_plist.begin();
      StcTruthPoint *p = (StcTruthPoint*)hdf5_record.vl_stcTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tagger.len = m_tagger_plist.size()) > 0) {
      size = sizeof(Tagger);
      hdf5_record.vl_tagger.p = malloc(len * size);
      std::list<Tagger*>::iterator iter = m_tagger_plist.begin();
      Tagger *p = (Tagger*)hdf5_record.vl_tagger.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_taggerHit.len = m_taggerHit_plist.size()) > 0) {
      size = sizeof(TaggerHit);
      hdf5_record.vl_taggerHit.p = malloc(len * size);
      std::list<TaggerHit*>::iterator iter = m_taggerHit_plist.begin();
      TaggerHit *p = (TaggerHit*)hdf5_record.vl_taggerHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_taggerTruthHit.len = m_taggerTruthHit_plist.size()) > 0) {
      size = sizeof(TaggerTruthHit);
      hdf5_record.vl_taggerTruthHit.p = malloc(len * size);
      std::list<TaggerTruthHit*>::iterator iter = m_taggerTruthHit_plist.begin();
      TaggerTruthHit *p = (TaggerTruthHit*)hdf5_record.vl_taggerTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_target.len = m_target_plist.size()) > 0) {
      size = sizeof(Target);
      hdf5_record.vl_target.p = malloc(len * size);
      std::list<Target*>::iterator iter = m_target_plist.begin();
      Target *p = (Target*)hdf5_record.vl_target.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tpolHit.len = m_tpolHit_plist.size()) > 0) {
      size = sizeof(TpolHit);
      hdf5_record.vl_tpolHit.p = malloc(len * size);
      std::list<TpolHit*>::iterator iter = m_tpolHit_plist.begin();
      TpolHit *p = (TpolHit*)hdf5_record.vl_tpolHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tpolSector.len = m_tpolSector_plist.size()) > 0) {
      size = sizeof(TpolSector);
      hdf5_record.vl_tpolSector.p = malloc(len * size);
      std::list<TpolSector*>::iterator iter = m_tpolSector_plist.begin();
      TpolSector *p = (TpolSector*)hdf5_record.vl_tpolSector.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tpolTruthHit.len = m_tpolTruthHit_plist.size()) > 0) {
      size = sizeof(TpolTruthHit);
      hdf5_record.vl_tpolTruthHit.p = malloc(len * size);
      std::list<TpolTruthHit*>::iterator iter = m_tpolTruthHit_plist.begin();
      TpolTruthHit *p = (TpolTruthHit*)hdf5_record.vl_tpolTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tpolTruthPoint.len = m_tpolTruthPoint_plist.size()) > 0) {
      size = sizeof(TpolTruthPoint);
      hdf5_record.vl_tpolTruthPoint.p = malloc(len * size);
      std::list<TpolTruthPoint*>::iterator iter = m_tpolTruthPoint_plist.begin();
      TpolTruthPoint *p = (TpolTruthPoint*)hdf5_record.vl_tpolTruthPoint.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_trackID.len = m_trackID_plist.size()) > 0) {
      size = sizeof(TrackID);
      hdf5_record.vl_trackID.p = malloc(len * size);
      std::list<TrackID*>::iterator iter = m_trackID_plist.begin();
      TrackID *p = (TrackID*)hdf5_record.vl_trackID.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tracktimebased.len = m_tracktimebased_plist.size()) > 0) {
      size = sizeof(Tracktimebased);
      hdf5_record.vl_tracktimebased.p = malloc(len * size);
      std::list<Tracktimebased*>::iterator iter = m_tracktimebased_plist.begin();
      Tracktimebased *p = (Tracktimebased*)hdf5_record.vl_tracktimebased.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_tripletPolarimeter.len = m_tripletPolarimeter_plist.size()) > 0) {
      size = sizeof(TripletPolarimeter);
      hdf5_record.vl_tripletPolarimeter.p = malloc(len * size);
      std::list<TripletPolarimeter*>::iterator iter = m_tripletPolarimeter_plist.begin();
      TripletPolarimeter *p = (TripletPolarimeter*)hdf5_record.vl_tripletPolarimeter.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_upstreamEMveto.len = m_upstreamEMveto_plist.size()) > 0) {
      size = sizeof(UpstreamEMveto);
      hdf5_record.vl_upstreamEMveto.p = malloc(len * size);
      std::list<UpstreamEMveto*>::iterator iter = m_upstreamEMveto_plist.begin();
      UpstreamEMveto *p = (UpstreamEMveto*)hdf5_record.vl_upstreamEMveto.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_upvHit.len = m_upvHit_plist.size()) > 0) {
      size = sizeof(UpvHit);
      hdf5_record.vl_upvHit.p = malloc(len * size);
      std::list<UpvHit*>::iterator iter = m_upvHit_plist.begin();
      UpvHit *p = (UpvHit*)hdf5_record.vl_upvHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_upvPaddle.len = m_upvPaddle_plist.size()) > 0) {
      size = sizeof(UpvPaddle);
      hdf5_record.vl_upvPaddle.p = malloc(len * size);
      std::list<UpvPaddle*>::iterator iter = m_upvPaddle_plist.begin();
      UpvPaddle *p = (UpvPaddle*)hdf5_record.vl_upvPaddle.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_upvTruthHit.len = m_upvTruthHit_plist.size()) > 0) {
      size = sizeof(UpvTruthHit);
      hdf5_record.vl_upvTruthHit.p = malloc(len * size);
      std::list<UpvTruthHit*>::iterator iter = m_upvTruthHit_plist.begin();
      UpvTruthHit *p = (UpvTruthHit*)hdf5_record.vl_upvTruthHit.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_upvTruthShower.len = m_upvTruthShower_plist.size()) > 0) {
      size = sizeof(UpvTruthShower);
      hdf5_record.vl_upvTruthShower.p = malloc(len * size);
      std::list<UpvTruthShower*>::iterator iter = m_upvTruthShower_plist.begin();
      UpvTruthShower *p = (UpvTruthShower*)hdf5_record.vl_upvTruthShower.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_userData.len = m_userData_plist.size()) > 0) {
      size = sizeof(UserData);
      hdf5_record.vl_userData.p = malloc(len * size);
      std::list<UserData*>::iterator iter = m_userData_plist.begin();
      UserData *p = (UserData*)hdf5_record.vl_userData.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_userDataFloat.len = m_userDataFloat_plist.size()) > 0) {
      size = sizeof(UserDataFloat);
      hdf5_record.vl_userDataFloat.p = malloc(len * size);
      std::list<UserDataFloat*>::iterator iter = m_userDataFloat_plist.begin();
      UserDataFloat *p = (UserDataFloat*)hdf5_record.vl_userDataFloat.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_userDataInt.len = m_userDataInt_plist.size()) > 0) {
      size = sizeof(UserDataInt);
      hdf5_record.vl_userDataInt.p = malloc(len * size);
      std::list<UserDataInt*>::iterator iter = m_userDataInt_plist.begin();
      UserDataInt *p = (UserDataInt*)hdf5_record.vl_userDataInt.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   if ((len = hdf5_record.vl_vertex.len = m_vertex_plist.size()) > 0) {
      size = sizeof(Vertex);
      hdf5_record.vl_vertex.p = malloc(len * size);
      std::list<Vertex*>::iterator iter = m_vertex_plist.begin();
      Vertex *p = (Vertex*)hdf5_record.vl_vertex.p;
      for (int i=0; i < (int)len; ++i, ++iter) {
         hdf5_memcpy(p+i, *iter, size);
         p[i].hdf5DataPack();
      }
   }
   hid_t eventtype_id = hdf5Datatype();
   hid_t memorytype_id = hdf5Datatype(1);
   hid_t chunking_id;
   if (s_hdf5_chunking.find(file_id) == s_hdf5_chunking.end()) {
      hdf5SetChunksize(file_id, HDF5_DEFAULT_CHUNK_SIZE);
   }
   chunking_id = s_hdf5_chunking[file_id];
   hid_t memoryspace_id;
   if (s_hdf5_memoryspace.find("HDDM") == s_hdf5_memoryspace.end()) {
      hsize_t dims[1] = {1};
      hsize_t maxdims[1] = {H5S_UNLIMITED};
      memoryspace_id = H5Screate_simple(1, dims, maxdims);
      s_hdf5_memoryspace["HDDM"] = memoryspace_id;
   }
   else {
      memoryspace_id = s_hdf5_memoryspace["HDDM"];
   }
   hid_t eventspace_id;
   if (s_hdf5_dataspace.find(file_id) == s_hdf5_dataspace.end()) {
      hsize_t dims[1] = {1};
      hsize_t maxdims[1] = {H5S_UNLIMITED};
      eventspace_id = H5Screate_simple(1, dims, maxdims);
      s_hdf5_dataspace[file_id] = eventspace_id;
   }
   else {
      eventspace_id = HDDM::s_hdf5_dataspace[file_id];
   }
   hid_t eventdata_id;
   if (s_hdf5_dataset.find(file_id) == s_hdf5_dataset.end()) {
      eventdata_id = H5Dcreate(file_id, "HDDMevents",
                               eventtype_id, eventspace_id,
                               H5P_DEFAULT, chunking_id,
                               H5P_DEFAULT);
      s_hdf5_dataset[file_id] = eventdata_id;
      m_hdf5_record_extent = 0;
      m_hdf5_record_offset = 0;
   }
   else {
      eventdata_id = s_hdf5_dataset[file_id];
      hsize_t maxdims;
      H5Sget_simple_extent_dims(eventspace_id, &m_hdf5_record_extent, &maxdims);
      H5Sget_select_bounds(eventspace_id, &m_hdf5_record_offset, &maxdims);
      ++m_hdf5_record_offset;
   }
   if (entry >= 0) {
      m_hdf5_record_offset = entry;
   }
   if (m_hdf5_record_offset >= m_hdf5_record_extent) {
      m_hdf5_record_extent = m_hdf5_record_offset + 1;
      H5Dset_extent(eventdata_id, &m_hdf5_record_extent);
      H5Sclose(eventspace_id);
      eventspace_id = H5Dget_space(eventdata_id);
      s_hdf5_dataspace[file_id] = eventspace_id;
   }
   hsize_t hdf5_record_count = 1;
   H5Sselect_hyperslab(eventspace_id, H5S_SELECT_SET,
                       &m_hdf5_record_offset, NULL,
                       &hdf5_record_count, NULL);
   herr_t res = H5Dwrite(eventdata_id, memorytype_id,
                         memoryspace_id, eventspace_id,
                         H5P_DEFAULT, &hdf5_record);
   if ((len = hdf5_record.vl_Cerenkov.len = m_Cerenkov_plist.size()) > 0) {
      free(hdf5_record.vl_Cerenkov.p);
   }
   if ((len = hdf5_record.vl_ComptonEMcal.len = m_ComptonEMcal_plist.size()) > 0) {
      free(hdf5_record.vl_ComptonEMcal.p);
   }
   if ((len = hdf5_record.vl_CrystalEcal.len = m_CrystalEcal_plist.size()) > 0) {
      free(hdf5_record.vl_CrystalEcal.p);
   }
   if ((len = hdf5_record.vl_DIRC.len = m_DIRC_plist.size()) > 0) {
      free(hdf5_record.vl_DIRC.p);
   }
   if ((len = hdf5_record.vl_RFsubsystem.len = m_RFsubsystem_plist.size()) > 0) {
      free(hdf5_record.vl_RFsubsystem.p);
   }
   if ((len = hdf5_record.vl_RFtime.len = m_RFtime_plist.size()) > 0) {
      free(hdf5_record.vl_RFtime.p);
   }
   if ((len = hdf5_record.vl_RICH.len = m_RICH_plist.size()) > 0) {
      free(hdf5_record.vl_RICH.p);
   }
   if ((len = hdf5_record.vl_TrackingErrorMatrix.len = m_TrackingErrorMatrix_plist.size()) > 0) {
      free(hdf5_record.vl_TrackingErrorMatrix.p);
   }
   if ((len = hdf5_record.vl_barrelEMcal.len = m_barrelEMcal_plist.size()) > 0) {
      free(hdf5_record.vl_barrelEMcal.p);
   }
   if ((len = hdf5_record.vl_bcalCell.len = m_bcalCell_plist.size()) > 0) {
      free(hdf5_record.vl_bcalCell.p);
   }
   if ((len = hdf5_record.vl_bcalSiPMDownHit.len = m_bcalSiPMDownHit_plist.size()) > 0) {
      free(hdf5_record.vl_bcalSiPMDownHit.p);
   }
   if ((len = hdf5_record.vl_bcalSiPMSpectrum.len = m_bcalSiPMSpectrum_plist.size()) > 0) {
      free(hdf5_record.vl_bcalSiPMSpectrum.p);
   }
   if ((len = hdf5_record.vl_bcalSiPMTruth.len = m_bcalSiPMTruth_plist.size()) > 0) {
      free(hdf5_record.vl_bcalSiPMTruth.p);
   }
   if ((len = hdf5_record.vl_bcalSiPMUpHit.len = m_bcalSiPMUpHit_plist.size()) > 0) {
      free(hdf5_record.vl_bcalSiPMUpHit.p);
   }
   if ((len = hdf5_record.vl_bcalTDCDigiHit.len = m_bcalTDCDigiHit_plist.size()) > 0) {
      free(hdf5_record.vl_bcalTDCDigiHit.p);
   }
   if ((len = hdf5_record.vl_bcalTDCHit.len = m_bcalTDCHit_plist.size()) > 0) {
      free(hdf5_record.vl_bcalTDCHit.p);
   }
   if ((len = hdf5_record.vl_bcalTruthHit.len = m_bcalTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_bcalTruthHit.p);
   }
   if ((len = hdf5_record.vl_bcalTruthIncidentParticle.len = m_bcalTruthIncidentParticle_plist.size()) > 0) {
      free(hdf5_record.vl_bcalTruthIncidentParticle.p);
   }
   if ((len = hdf5_record.vl_bcalTruthShower.len = m_bcalTruthShower_plist.size()) > 0) {
      free(hdf5_record.vl_bcalTruthShower.p);
   }
   if ((len = hdf5_record.vl_bcalfADCDigiHit.len = m_bcalfADCDigiHit_plist.size()) > 0) {
      free(hdf5_record.vl_bcalfADCDigiHit.p);
   }
   if ((len = hdf5_record.vl_bcalfADCHit.len = m_bcalfADCHit_plist.size()) > 0) {
      free(hdf5_record.vl_bcalfADCHit.p);
   }
   if ((len = hdf5_record.vl_bcalfADCPeak.len = m_bcalfADCPeak_plist.size()) > 0) {
      free(hdf5_record.vl_bcalfADCPeak.p);
   }
   if ((len = hdf5_record.vl_beam.len = m_beam_plist.size()) > 0) {
      free(hdf5_record.vl_beam.p);
   }
   if ((len = hdf5_record.vl_ccalBlock.len = m_ccalBlock_plist.size()) > 0) {
      free(hdf5_record.vl_ccalBlock.p);
   }
   if ((len = hdf5_record.vl_ccalHit.len = m_ccalHit_plist.size()) > 0) {
      free(hdf5_record.vl_ccalHit.p);
   }
   if ((len = hdf5_record.vl_ccalTruthHit.len = m_ccalTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_ccalTruthHit.p);
   }
   if ((len = hdf5_record.vl_ccalTruthShower.len = m_ccalTruthShower_plist.size()) > 0) {
      free(hdf5_record.vl_ccalTruthShower.p);
   }
   if ((len = hdf5_record.vl_ccdbContext.len = m_ccdbContext_plist.size()) > 0) {
      free(hdf5_record.vl_ccdbContext.p);
   }
   if ((len = hdf5_record.vl_cdcDigihit.len = m_cdcDigihit_plist.size()) > 0) {
      free(hdf5_record.vl_cdcDigihit.p);
   }
   if ((len = hdf5_record.vl_cdcHitQF.len = m_cdcHitQF_plist.size()) > 0) {
      free(hdf5_record.vl_cdcHitQF.p);
   }
   if ((len = hdf5_record.vl_cdcStraw.len = m_cdcStraw_plist.size()) > 0) {
      free(hdf5_record.vl_cdcStraw.p);
   }
   if ((len = hdf5_record.vl_cdcStrawHit.len = m_cdcStrawHit_plist.size()) > 0) {
      free(hdf5_record.vl_cdcStrawHit.p);
   }
   if ((len = hdf5_record.vl_cdcStrawTruthHit.len = m_cdcStrawTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_cdcStrawTruthHit.p);
   }
   if ((len = hdf5_record.vl_cdcTruthPoint.len = m_cdcTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_cdcTruthPoint.p);
   }
   if ((len = hdf5_record.vl_centralDC.len = m_centralDC_plist.size()) > 0) {
      free(hdf5_record.vl_centralDC.p);
   }
   if ((len = hdf5_record.vl_cereHit.len = m_cereHit_plist.size()) > 0) {
      free(hdf5_record.vl_cereHit.p);
   }
   if ((len = hdf5_record.vl_cereSection.len = m_cereSection_plist.size()) > 0) {
      free(hdf5_record.vl_cereSection.p);
   }
   if ((len = hdf5_record.vl_cereTruthHit.len = m_cereTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_cereTruthHit.p);
   }
   if ((len = hdf5_record.vl_cereTruthPoint.len = m_cereTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_cereTruthPoint.p);
   }
   if ((len = hdf5_record.vl_cppTOF.len = m_cppTOF_plist.size()) > 0) {
      free(hdf5_record.vl_cppTOF.p);
   }
   if ((len = hdf5_record.vl_ctofCounter.len = m_ctofCounter_plist.size()) > 0) {
      free(hdf5_record.vl_ctofCounter.p);
   }
   if ((len = hdf5_record.vl_ctofHit.len = m_ctofHit_plist.size()) > 0) {
      free(hdf5_record.vl_ctofHit.p);
   }
   if ((len = hdf5_record.vl_ctofTruthHit.len = m_ctofTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_ctofTruthHit.p);
   }
   if ((len = hdf5_record.vl_ctofTruthPoint.len = m_ctofTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_ctofTruthPoint.p);
   }
   if ((len = hdf5_record.vl_dataVersionString.len = m_dataVersionString_plist.size()) > 0) {
      free(hdf5_record.vl_dataVersionString.p);
   }
   if ((len = hdf5_record.vl_dircPmtHit.len = m_dircPmtHit_plist.size()) > 0) {
      free(hdf5_record.vl_dircPmtHit.p);
   }
   if ((len = hdf5_record.vl_dircTruthBarHit.len = m_dircTruthBarHit_plist.size()) > 0) {
      free(hdf5_record.vl_dircTruthBarHit.p);
   }
   if ((len = hdf5_record.vl_dircTruthPmtHit.len = m_dircTruthPmtHit_plist.size()) > 0) {
      free(hdf5_record.vl_dircTruthPmtHit.p);
   }
   if ((len = hdf5_record.vl_dircTruthPmtHitExtra.len = m_dircTruthPmtHitExtra_plist.size()) > 0) {
      free(hdf5_record.vl_dircTruthPmtHitExtra.p);
   }
   if ((len = hdf5_record.vl_ecalBlock.len = m_ecalBlock_plist.size()) > 0) {
      free(hdf5_record.vl_ecalBlock.p);
   }
   if ((len = hdf5_record.vl_ecalHit.len = m_ecalHit_plist.size()) > 0) {
      free(hdf5_record.vl_ecalHit.p);
   }
   if ((len = hdf5_record.vl_ecalTruthHit.len = m_ecalTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_ecalTruthHit.p);
   }
   if ((len = hdf5_record.vl_ecalTruthShower.len = m_ecalTruthShower_plist.size()) > 0) {
      free(hdf5_record.vl_ecalTruthShower.p);
   }
   if ((len = hdf5_record.vl_errorMatrix.len = m_errorMatrix_plist.size()) > 0) {
      free(hdf5_record.vl_errorMatrix.p);
   }
   if ((len = hdf5_record.vl_fcalBlock.len = m_fcalBlock_plist.size()) > 0) {
      free(hdf5_record.vl_fcalBlock.p);
   }
   if ((len = hdf5_record.vl_fcalDigihit.len = m_fcalDigihit_plist.size()) > 0) {
      free(hdf5_record.vl_fcalDigihit.p);
   }
   if ((len = hdf5_record.vl_fcalHit.len = m_fcalHit_plist.size()) > 0) {
      free(hdf5_record.vl_fcalHit.p);
   }
   if ((len = hdf5_record.vl_fcalTruthHit.len = m_fcalTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_fcalTruthHit.p);
   }
   if ((len = hdf5_record.vl_fcalTruthLightGuide.len = m_fcalTruthLightGuide_plist.size()) > 0) {
      free(hdf5_record.vl_fcalTruthLightGuide.p);
   }
   if ((len = hdf5_record.vl_fcalTruthShower.len = m_fcalTruthShower_plist.size()) > 0) {
      free(hdf5_record.vl_fcalTruthShower.p);
   }
   if ((len = hdf5_record.vl_fdcAnodeHit.len = m_fdcAnodeHit_plist.size()) > 0) {
      free(hdf5_record.vl_fdcAnodeHit.p);
   }
   if ((len = hdf5_record.vl_fdcAnodeTruthHit.len = m_fdcAnodeTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_fdcAnodeTruthHit.p);
   }
   if ((len = hdf5_record.vl_fdcAnodeWire.len = m_fdcAnodeWire_plist.size()) > 0) {
      free(hdf5_record.vl_fdcAnodeWire.p);
   }
   if ((len = hdf5_record.vl_fdcCathodeHit.len = m_fdcCathodeHit_plist.size()) > 0) {
      free(hdf5_record.vl_fdcCathodeHit.p);
   }
   if ((len = hdf5_record.vl_fdcCathodeStrip.len = m_fdcCathodeStrip_plist.size()) > 0) {
      free(hdf5_record.vl_fdcCathodeStrip.p);
   }
   if ((len = hdf5_record.vl_fdcCathodeTruthHit.len = m_fdcCathodeTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_fdcCathodeTruthHit.p);
   }
   if ((len = hdf5_record.vl_fdcChamber.len = m_fdcChamber_plist.size()) > 0) {
      free(hdf5_record.vl_fdcChamber.p);
   }
   if ((len = hdf5_record.vl_fdcDigihit.len = m_fdcDigihit_plist.size()) > 0) {
      free(hdf5_record.vl_fdcDigihit.p);
   }
   if ((len = hdf5_record.vl_fdcTruthPoint.len = m_fdcTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_fdcTruthPoint.p);
   }
   if ((len = hdf5_record.vl_fmwpcChamber.len = m_fmwpcChamber_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcChamber.p);
   }
   if ((len = hdf5_record.vl_fmwpcHit.len = m_fmwpcHit_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcHit.p);
   }
   if ((len = hdf5_record.vl_fmwpcHitQ.len = m_fmwpcHitQ_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcHitQ.p);
   }
   if ((len = hdf5_record.vl_fmwpcTruthHit.len = m_fmwpcTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcTruthHit.p);
   }
   if ((len = hdf5_record.vl_fmwpcTruthHitQ.len = m_fmwpcTruthHitQ_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcTruthHitQ.p);
   }
   if ((len = hdf5_record.vl_fmwpcTruthPoint.len = m_fmwpcTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_fmwpcTruthPoint.p);
   }
   if ((len = hdf5_record.vl_forwardDC.len = m_forwardDC_plist.size()) > 0) {
      free(hdf5_record.vl_forwardDC.p);
   }
   if ((len = hdf5_record.vl_forwardEMcal.len = m_forwardEMcal_plist.size()) > 0) {
      free(hdf5_record.vl_forwardEMcal.p);
   }
   if ((len = hdf5_record.vl_forwardMWPC.len = m_forwardMWPC_plist.size()) > 0) {
      free(hdf5_record.vl_forwardMWPC.p);
   }
   if ((len = hdf5_record.vl_forwardTOF.len = m_forwardTOF_plist.size()) > 0) {
      free(hdf5_record.vl_forwardTOF.p);
   }
   if ((len = hdf5_record.vl_ftofCounter.len = m_ftofCounter_plist.size()) > 0) {
      free(hdf5_record.vl_ftofCounter.p);
   }
   if ((len = hdf5_record.vl_ftofDigihit.len = m_ftofDigihit_plist.size()) > 0) {
      free(hdf5_record.vl_ftofDigihit.p);
   }
   if ((len = hdf5_record.vl_ftofHit.len = m_ftofHit_plist.size()) > 0) {
      free(hdf5_record.vl_ftofHit.p);
   }
   if ((len = hdf5_record.vl_ftofTruthExtra.len = m_ftofTruthExtra_plist.size()) > 0) {
      free(hdf5_record.vl_ftofTruthExtra.p);
   }
   if ((len = hdf5_record.vl_ftofTruthHit.len = m_ftofTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_ftofTruthHit.p);
   }
   if ((len = hdf5_record.vl_ftofTruthPoint.len = m_ftofTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_ftofTruthPoint.p);
   }
   if ((len = hdf5_record.vl_gapEMcal.len = m_gapEMcal_plist.size()) > 0) {
      free(hdf5_record.vl_gapEMcal.p);
   }
   if ((len = hdf5_record.vl_gcalCell.len = m_gcalCell_plist.size()) > 0) {
      free(hdf5_record.vl_gcalCell.p);
   }
   if ((len = hdf5_record.vl_gcalHit.len = m_gcalHit_plist.size()) > 0) {
      free(hdf5_record.vl_gcalHit.p);
   }
   if ((len = hdf5_record.vl_gcalTruthHit.len = m_gcalTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_gcalTruthHit.p);
   }
   if ((len = hdf5_record.vl_gcalTruthShower.len = m_gcalTruthShower_plist.size()) > 0) {
      free(hdf5_record.vl_gcalTruthShower.p);
   }
   if ((len = hdf5_record.vl_geometry.len = m_geometry_plist.size()) > 0) {
      free(hdf5_record.vl_geometry.p);
   }
   if ((len = hdf5_record.vl_hitView.len = m_hitView_plist.size()) > 0) {
      free(hdf5_record.vl_hitView.p);
   }
   if ((len = hdf5_record.vl_hodoChannel.len = m_hodoChannel_plist.size()) > 0) {
      free(hdf5_record.vl_hodoChannel.p);
   }
   if ((len = hdf5_record.vl_mcTrajectory.len = m_mcTrajectory_plist.size()) > 0) {
      free(hdf5_record.vl_mcTrajectory.p);
   }
   if ((len = hdf5_record.vl_mcTrajectoryPoint.len = m_mcTrajectoryPoint_plist.size()) > 0) {
      free(hdf5_record.vl_mcTrajectoryPoint.p);
   }
   if ((len = hdf5_record.vl_microChannel.len = m_microChannel_plist.size()) > 0) {
      free(hdf5_record.vl_microChannel.p);
   }
   if ((len = hdf5_record.vl_momentum.len = m_momentum_plist.size()) > 0) {
      free(hdf5_record.vl_momentum.p);
   }
   if ((len = hdf5_record.vl_origin.len = m_origin_plist.size()) > 0) {
      free(hdf5_record.vl_origin.p);
   }
   if ((len = hdf5_record.vl_pairSpectrometerCoarse.len = m_pairSpectrometerCoarse_plist.size()) > 0) {
      free(hdf5_record.vl_pairSpectrometerCoarse.p);
   }
   if ((len = hdf5_record.vl_pairSpectrometerFine.len = m_pairSpectrometerFine_plist.size()) > 0) {
      free(hdf5_record.vl_pairSpectrometerFine.p);
   }
   if ((len = hdf5_record.vl_physicsEvent.len = m_physicsEvent_plist.size()) > 0) {
      free(hdf5_record.vl_physicsEvent.p);
   }
   if ((len = hdf5_record.vl_polarization.len = m_polarization_plist.size()) > 0) {
      free(hdf5_record.vl_polarization.p);
   }
   if ((len = hdf5_record.vl_product.len = m_product_plist.size()) > 0) {
      free(hdf5_record.vl_product.p);
   }
   if ((len = hdf5_record.vl_properties.len = m_properties_plist.size()) > 0) {
      free(hdf5_record.vl_properties.p);
   }
   if ((len = hdf5_record.vl_psHit.len = m_psHit_plist.size()) > 0) {
      free(hdf5_record.vl_psHit.p);
   }
   if ((len = hdf5_record.vl_psTile.len = m_psTile_plist.size()) > 0) {
      free(hdf5_record.vl_psTile.p);
   }
   if ((len = hdf5_record.vl_psTruthHit.len = m_psTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_psTruthHit.p);
   }
   if ((len = hdf5_record.vl_psTruthPoint.len = m_psTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_psTruthPoint.p);
   }
   if ((len = hdf5_record.vl_pscHit.len = m_pscHit_plist.size()) > 0) {
      free(hdf5_record.vl_pscHit.p);
   }
   if ((len = hdf5_record.vl_pscPaddle.len = m_pscPaddle_plist.size()) > 0) {
      free(hdf5_record.vl_pscPaddle.p);
   }
   if ((len = hdf5_record.vl_pscTruthHit.len = m_pscTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_pscTruthHit.p);
   }
   if ((len = hdf5_record.vl_pscTruthPoint.len = m_pscTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_pscTruthPoint.p);
   }
   if ((len = hdf5_record.vl_random.len = m_random_plist.size()) > 0) {
      free(hdf5_record.vl_random.p);
   }
   if ((len = hdf5_record.vl_reaction.len = m_reaction_plist.size()) > 0) {
      free(hdf5_record.vl_reaction.p);
   }
   if ((len = hdf5_record.vl_reconView.len = m_reconView_plist.size()) > 0) {
      free(hdf5_record.vl_reconView.p);
   }
   if ((len = hdf5_record.vl_richTruthHit.len = m_richTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_richTruthHit.p);
   }
   if ((len = hdf5_record.vl_richTruthPoint.len = m_richTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_richTruthPoint.p);
   }
   if ((len = hdf5_record.vl_startCntr.len = m_startCntr_plist.size()) > 0) {
      free(hdf5_record.vl_startCntr.p);
   }
   if ((len = hdf5_record.vl_stcDigihit.len = m_stcDigihit_plist.size()) > 0) {
      free(hdf5_record.vl_stcDigihit.p);
   }
   if ((len = hdf5_record.vl_stcHit.len = m_stcHit_plist.size()) > 0) {
      free(hdf5_record.vl_stcHit.p);
   }
   if ((len = hdf5_record.vl_stcPaddle.len = m_stcPaddle_plist.size()) > 0) {
      free(hdf5_record.vl_stcPaddle.p);
   }
   if ((len = hdf5_record.vl_stcTruthHit.len = m_stcTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_stcTruthHit.p);
   }
   if ((len = hdf5_record.vl_stcTruthPoint.len = m_stcTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_stcTruthPoint.p);
   }
   if ((len = hdf5_record.vl_tagger.len = m_tagger_plist.size()) > 0) {
      free(hdf5_record.vl_tagger.p);
   }
   if ((len = hdf5_record.vl_taggerHit.len = m_taggerHit_plist.size()) > 0) {
      free(hdf5_record.vl_taggerHit.p);
   }
   if ((len = hdf5_record.vl_taggerTruthHit.len = m_taggerTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_taggerTruthHit.p);
   }
   if ((len = hdf5_record.vl_target.len = m_target_plist.size()) > 0) {
      free(hdf5_record.vl_target.p);
   }
   if ((len = hdf5_record.vl_tpolHit.len = m_tpolHit_plist.size()) > 0) {
      free(hdf5_record.vl_tpolHit.p);
   }
   if ((len = hdf5_record.vl_tpolSector.len = m_tpolSector_plist.size()) > 0) {
      free(hdf5_record.vl_tpolSector.p);
   }
   if ((len = hdf5_record.vl_tpolTruthHit.len = m_tpolTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_tpolTruthHit.p);
   }
   if ((len = hdf5_record.vl_tpolTruthPoint.len = m_tpolTruthPoint_plist.size()) > 0) {
      free(hdf5_record.vl_tpolTruthPoint.p);
   }
   if ((len = hdf5_record.vl_trackID.len = m_trackID_plist.size()) > 0) {
      free(hdf5_record.vl_trackID.p);
   }
   if ((len = hdf5_record.vl_tracktimebased.len = m_tracktimebased_plist.size()) > 0) {
      free(hdf5_record.vl_tracktimebased.p);
   }
   if ((len = hdf5_record.vl_tripletPolarimeter.len = m_tripletPolarimeter_plist.size()) > 0) {
      free(hdf5_record.vl_tripletPolarimeter.p);
   }
   if ((len = hdf5_record.vl_upstreamEMveto.len = m_upstreamEMveto_plist.size()) > 0) {
      free(hdf5_record.vl_upstreamEMveto.p);
   }
   if ((len = hdf5_record.vl_upvHit.len = m_upvHit_plist.size()) > 0) {
      free(hdf5_record.vl_upvHit.p);
   }
   if ((len = hdf5_record.vl_upvPaddle.len = m_upvPaddle_plist.size()) > 0) {
      free(hdf5_record.vl_upvPaddle.p);
   }
   if ((len = hdf5_record.vl_upvTruthHit.len = m_upvTruthHit_plist.size()) > 0) {
      free(hdf5_record.vl_upvTruthHit.p);
   }
   if ((len = hdf5_record.vl_upvTruthShower.len = m_upvTruthShower_plist.size()) > 0) {
      free(hdf5_record.vl_upvTruthShower.p);
   }
   if ((len = hdf5_record.vl_userData.len = m_userData_plist.size()) > 0) {
      free(hdf5_record.vl_userData.p);
   }
   if ((len = hdf5_record.vl_userDataFloat.len = m_userDataFloat_plist.size()) > 0) {
      free(hdf5_record.vl_userDataFloat.p);
   }
   if ((len = hdf5_record.vl_userDataInt.len = m_userDataInt_plist.size()) > 0) {
      free(hdf5_record.vl_userDataInt.p);
   }
   if ((len = hdf5_record.vl_vertex.len = m_vertex_plist.size()) > 0) {
      free(hdf5_record.vl_vertex.p);
   }
   return res;
}
herr_t HDDM::hdf5FileRead(hid_t file_id, long int entry)
{
   clear();
   hid_t memorytype_id = hdf5Datatype(1);
   hid_t memoryspace_id;
   if (s_hdf5_memoryspace.find("HDDM") == s_hdf5_memoryspace.end()) {
      hsize_t dims[1] = {1};
      hsize_t maxdims[1] = {H5S_UNLIMITED};
      memoryspace_id = H5Screate_simple(1, dims, maxdims);
      s_hdf5_memoryspace["HDDM"] = memoryspace_id;
   }
   else {
      memoryspace_id = s_hdf5_memoryspace["HDDM"];
   }
   hid_t eventdata_id;
   hid_t chunking_id;
   if (s_hdf5_dataset.find(file_id) == s_hdf5_dataset.end()) {

      eventdata_id = H5Dopen(file_id, "HDDMevents",
                               H5P_DEFAULT);
      chunking_id = H5Dget_create_plist(eventdata_id);
      s_hdf5_dataset[file_id] = eventdata_id;      s_hdf5_chunking[file_id] = chunking_id;
   }
   else {
      eventdata_id = s_hdf5_dataset[file_id];
      chunking_id = s_hdf5_chunking[file_id];
   }
   hid_t eventspace_id;
   if (s_hdf5_dataspace.find(file_id) == s_hdf5_dataspace.end()) {
      eventspace_id = H5Dget_space(eventdata_id);
      s_hdf5_dataspace[file_id] = eventspace_id;
      hsize_t maxdims;
      H5Sget_simple_extent_dims(eventspace_id, &m_hdf5_record_extent, &maxdims);
      m_hdf5_record_offset = 0;
   }
   else {
      eventspace_id = HDDM::s_hdf5_dataspace[file_id];
      hsize_t maxdims;
      H5Sget_simple_extent_dims(eventspace_id, &m_hdf5_record_extent, &maxdims);
      H5Sget_select_bounds(eventspace_id, &m_hdf5_record_offset, &maxdims);
      ++m_hdf5_record_offset;
   }
   if (entry >= 0) {
      m_hdf5_record_offset = entry;
   }
   if (m_hdf5_record_offset >= m_hdf5_record_extent)
      return -1;
   m_hdf5_record_count = 1;
   H5Sselect_hyperslab(eventspace_id, H5S_SELECT_SET,
                       &m_hdf5_record_offset, NULL,
                       &m_hdf5_record_count, NULL);
   herr_t res = H5Dread(eventdata_id, memorytype_id,
                        memoryspace_id, eventspace_id,
                        H5P_DEFAULT, &m_hdf5_record);
   size_t len;
   if ((len = m_hdf5_record.vl_Cerenkov.len) > 0) {
      Cerenkov *p =(Cerenkov*)m_hdf5_record.vl_Cerenkov.p;
      for (int i=0; i < (int)len; ++i ) {
         m_Cerenkov_plist.push_back(new(p+i) Cerenkov);
      }
   }
   if ((len = m_hdf5_record.vl_ComptonEMcal.len) > 0) {
      ComptonEMcal *p =(ComptonEMcal*)m_hdf5_record.vl_ComptonEMcal.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ComptonEMcal_plist.push_back(new(p+i) ComptonEMcal);
      }
   }
   if ((len = m_hdf5_record.vl_CrystalEcal.len) > 0) {
      CrystalEcal *p =(CrystalEcal*)m_hdf5_record.vl_CrystalEcal.p;
      for (int i=0; i < (int)len; ++i ) {
         m_CrystalEcal_plist.push_back(new(p+i) CrystalEcal);
      }
   }
   if ((len = m_hdf5_record.vl_DIRC.len) > 0) {
      DIRC *p =(DIRC*)m_hdf5_record.vl_DIRC.p;
      for (int i=0; i < (int)len; ++i ) {
         m_DIRC_plist.push_back(new(p+i) DIRC);
      }
   }
   if ((len = m_hdf5_record.vl_RFsubsystem.len) > 0) {
      RFsubsystem *p =(RFsubsystem*)m_hdf5_record.vl_RFsubsystem.p;
      for (int i=0; i < (int)len; ++i ) {
         m_RFsubsystem_plist.push_back(new(p+i) RFsubsystem);
      }
   }
   if ((len = m_hdf5_record.vl_RFtime.len) > 0) {
      RFtime *p =(RFtime*)m_hdf5_record.vl_RFtime.p;
      for (int i=0; i < (int)len; ++i ) {
         m_RFtime_plist.push_back(new(p+i) RFtime);
      }
   }
   if ((len = m_hdf5_record.vl_RICH.len) > 0) {
      RICH *p =(RICH*)m_hdf5_record.vl_RICH.p;
      for (int i=0; i < (int)len; ++i ) {
         m_RICH_plist.push_back(new(p+i) RICH);
      }
   }
   if ((len = m_hdf5_record.vl_TrackingErrorMatrix.len) > 0) {
      TrackingErrorMatrix *p =(TrackingErrorMatrix*)m_hdf5_record.vl_TrackingErrorMatrix.p;
      for (int i=0; i < (int)len; ++i ) {
         m_TrackingErrorMatrix_plist.push_back(new(p+i) TrackingErrorMatrix);
      }
   }
   if ((len = m_hdf5_record.vl_barrelEMcal.len) > 0) {
      BarrelEMcal *p =(BarrelEMcal*)m_hdf5_record.vl_barrelEMcal.p;
      for (int i=0; i < (int)len; ++i ) {
         m_barrelEMcal_plist.push_back(new(p+i) BarrelEMcal);
      }
   }
   if ((len = m_hdf5_record.vl_bcalCell.len) > 0) {
      BcalCell *p =(BcalCell*)m_hdf5_record.vl_bcalCell.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalCell_plist.push_back(new(p+i) BcalCell);
      }
   }
   if ((len = m_hdf5_record.vl_bcalSiPMDownHit.len) > 0) {
      BcalSiPMDownHit *p =(BcalSiPMDownHit*)m_hdf5_record.vl_bcalSiPMDownHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalSiPMDownHit_plist.push_back(new(p+i) BcalSiPMDownHit);
      }
   }
   if ((len = m_hdf5_record.vl_bcalSiPMSpectrum.len) > 0) {
      BcalSiPMSpectrum *p =(BcalSiPMSpectrum*)m_hdf5_record.vl_bcalSiPMSpectrum.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalSiPMSpectrum_plist.push_back(new(p+i) BcalSiPMSpectrum);
      }
   }
   if ((len = m_hdf5_record.vl_bcalSiPMTruth.len) > 0) {
      BcalSiPMTruth *p =(BcalSiPMTruth*)m_hdf5_record.vl_bcalSiPMTruth.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalSiPMTruth_plist.push_back(new(p+i) BcalSiPMTruth);
      }
   }
   if ((len = m_hdf5_record.vl_bcalSiPMUpHit.len) > 0) {
      BcalSiPMUpHit *p =(BcalSiPMUpHit*)m_hdf5_record.vl_bcalSiPMUpHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalSiPMUpHit_plist.push_back(new(p+i) BcalSiPMUpHit);
      }
   }
   if ((len = m_hdf5_record.vl_bcalTDCDigiHit.len) > 0) {
      BcalTDCDigiHit *p =(BcalTDCDigiHit*)m_hdf5_record.vl_bcalTDCDigiHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalTDCDigiHit_plist.push_back(new(p+i) BcalTDCDigiHit);
      }
   }
   if ((len = m_hdf5_record.vl_bcalTDCHit.len) > 0) {
      BcalTDCHit *p =(BcalTDCHit*)m_hdf5_record.vl_bcalTDCHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalTDCHit_plist.push_back(new(p+i) BcalTDCHit);
      }
   }
   if ((len = m_hdf5_record.vl_bcalTruthHit.len) > 0) {
      BcalTruthHit *p =(BcalTruthHit*)m_hdf5_record.vl_bcalTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalTruthHit_plist.push_back(new(p+i) BcalTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_bcalTruthIncidentParticle.len) > 0) {
      BcalTruthIncidentParticle *p =(BcalTruthIncidentParticle*)m_hdf5_record.vl_bcalTruthIncidentParticle.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalTruthIncidentParticle_plist.push_back(new(p+i) BcalTruthIncidentParticle);
      }
   }
   if ((len = m_hdf5_record.vl_bcalTruthShower.len) > 0) {
      BcalTruthShower *p =(BcalTruthShower*)m_hdf5_record.vl_bcalTruthShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalTruthShower_plist.push_back(new(p+i) BcalTruthShower);
      }
   }
   if ((len = m_hdf5_record.vl_bcalfADCDigiHit.len) > 0) {
      BcalfADCDigiHit *p =(BcalfADCDigiHit*)m_hdf5_record.vl_bcalfADCDigiHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalfADCDigiHit_plist.push_back(new(p+i) BcalfADCDigiHit);
      }
   }
   if ((len = m_hdf5_record.vl_bcalfADCHit.len) > 0) {
      BcalfADCHit *p =(BcalfADCHit*)m_hdf5_record.vl_bcalfADCHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalfADCHit_plist.push_back(new(p+i) BcalfADCHit);
      }
   }
   if ((len = m_hdf5_record.vl_bcalfADCPeak.len) > 0) {
      BcalfADCPeak *p =(BcalfADCPeak*)m_hdf5_record.vl_bcalfADCPeak.p;
      for (int i=0; i < (int)len; ++i ) {
         m_bcalfADCPeak_plist.push_back(new(p+i) BcalfADCPeak);
      }
   }
   if ((len = m_hdf5_record.vl_beam.len) > 0) {
      Beam *p =(Beam*)m_hdf5_record.vl_beam.p;
      for (int i=0; i < (int)len; ++i ) {
         m_beam_plist.push_back(new(p+i) Beam);
      }
   }
   if ((len = m_hdf5_record.vl_ccalBlock.len) > 0) {
      CcalBlock *p =(CcalBlock*)m_hdf5_record.vl_ccalBlock.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccalBlock_plist.push_back(new(p+i) CcalBlock);
      }
   }
   if ((len = m_hdf5_record.vl_ccalHit.len) > 0) {
      CcalHit *p =(CcalHit*)m_hdf5_record.vl_ccalHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccalHit_plist.push_back(new(p+i) CcalHit);
      }
   }
   if ((len = m_hdf5_record.vl_ccalTruthHit.len) > 0) {
      CcalTruthHit *p =(CcalTruthHit*)m_hdf5_record.vl_ccalTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccalTruthHit_plist.push_back(new(p+i) CcalTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_ccalTruthShower.len) > 0) {
      CcalTruthShower *p =(CcalTruthShower*)m_hdf5_record.vl_ccalTruthShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccalTruthShower_plist.push_back(new(p+i) CcalTruthShower);
      }
   }
   if ((len = m_hdf5_record.vl_ccdbContext.len) > 0) {
      CcdbContext *p =(CcdbContext*)m_hdf5_record.vl_ccdbContext.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ccdbContext_plist.push_back(new(p+i) CcdbContext);
      }
   }
   if ((len = m_hdf5_record.vl_cdcDigihit.len) > 0) {
      CdcDigihit *p =(CdcDigihit*)m_hdf5_record.vl_cdcDigihit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cdcDigihit_plist.push_back(new(p+i) CdcDigihit);
      }
   }
   if ((len = m_hdf5_record.vl_cdcHitQF.len) > 0) {
      CdcHitQF *p =(CdcHitQF*)m_hdf5_record.vl_cdcHitQF.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cdcHitQF_plist.push_back(new(p+i) CdcHitQF);
      }
   }
   if ((len = m_hdf5_record.vl_cdcStraw.len) > 0) {
      CdcStraw *p =(CdcStraw*)m_hdf5_record.vl_cdcStraw.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cdcStraw_plist.push_back(new(p+i) CdcStraw);
      }
   }
   if ((len = m_hdf5_record.vl_cdcStrawHit.len) > 0) {
      CdcStrawHit *p =(CdcStrawHit*)m_hdf5_record.vl_cdcStrawHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cdcStrawHit_plist.push_back(new(p+i) CdcStrawHit);
      }
   }
   if ((len = m_hdf5_record.vl_cdcStrawTruthHit.len) > 0) {
      CdcStrawTruthHit *p =(CdcStrawTruthHit*)m_hdf5_record.vl_cdcStrawTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cdcStrawTruthHit_plist.push_back(new(p+i) CdcStrawTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_cdcTruthPoint.len) > 0) {
      CdcTruthPoint *p =(CdcTruthPoint*)m_hdf5_record.vl_cdcTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cdcTruthPoint_plist.push_back(new(p+i) CdcTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_centralDC.len) > 0) {
      CentralDC *p =(CentralDC*)m_hdf5_record.vl_centralDC.p;
      for (int i=0; i < (int)len; ++i ) {
         m_centralDC_plist.push_back(new(p+i) CentralDC);
      }
   }
   if ((len = m_hdf5_record.vl_cereHit.len) > 0) {
      CereHit *p =(CereHit*)m_hdf5_record.vl_cereHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cereHit_plist.push_back(new(p+i) CereHit);
      }
   }
   if ((len = m_hdf5_record.vl_cereSection.len) > 0) {
      CereSection *p =(CereSection*)m_hdf5_record.vl_cereSection.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cereSection_plist.push_back(new(p+i) CereSection);
      }
   }
   if ((len = m_hdf5_record.vl_cereTruthHit.len) > 0) {
      CereTruthHit *p =(CereTruthHit*)m_hdf5_record.vl_cereTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cereTruthHit_plist.push_back(new(p+i) CereTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_cereTruthPoint.len) > 0) {
      CereTruthPoint *p =(CereTruthPoint*)m_hdf5_record.vl_cereTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cereTruthPoint_plist.push_back(new(p+i) CereTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_cppTOF.len) > 0) {
      CppTOF *p =(CppTOF*)m_hdf5_record.vl_cppTOF.p;
      for (int i=0; i < (int)len; ++i ) {
         m_cppTOF_plist.push_back(new(p+i) CppTOF);
      }
   }
   if ((len = m_hdf5_record.vl_ctofCounter.len) > 0) {
      CtofCounter *p =(CtofCounter*)m_hdf5_record.vl_ctofCounter.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ctofCounter_plist.push_back(new(p+i) CtofCounter);
      }
   }
   if ((len = m_hdf5_record.vl_ctofHit.len) > 0) {
      CtofHit *p =(CtofHit*)m_hdf5_record.vl_ctofHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ctofHit_plist.push_back(new(p+i) CtofHit);
      }
   }
   if ((len = m_hdf5_record.vl_ctofTruthHit.len) > 0) {
      CtofTruthHit *p =(CtofTruthHit*)m_hdf5_record.vl_ctofTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ctofTruthHit_plist.push_back(new(p+i) CtofTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_ctofTruthPoint.len) > 0) {
      CtofTruthPoint *p =(CtofTruthPoint*)m_hdf5_record.vl_ctofTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ctofTruthPoint_plist.push_back(new(p+i) CtofTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_dataVersionString.len) > 0) {
      DataVersionString *p =(DataVersionString*)m_hdf5_record.vl_dataVersionString.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dataVersionString_plist.push_back(new(p+i) DataVersionString);
      }
   }
   if ((len = m_hdf5_record.vl_dircPmtHit.len) > 0) {
      DircPmtHit *p =(DircPmtHit*)m_hdf5_record.vl_dircPmtHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircPmtHit_plist.push_back(new(p+i) DircPmtHit);
      }
   }
   if ((len = m_hdf5_record.vl_dircTruthBarHit.len) > 0) {
      DircTruthBarHit *p =(DircTruthBarHit*)m_hdf5_record.vl_dircTruthBarHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircTruthBarHit_plist.push_back(new(p+i) DircTruthBarHit);
      }
   }
   if ((len = m_hdf5_record.vl_dircTruthPmtHit.len) > 0) {
      DircTruthPmtHit *p =(DircTruthPmtHit*)m_hdf5_record.vl_dircTruthPmtHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircTruthPmtHit_plist.push_back(new(p+i) DircTruthPmtHit);
      }
   }
   if ((len = m_hdf5_record.vl_dircTruthPmtHitExtra.len) > 0) {
      DircTruthPmtHitExtra *p =(DircTruthPmtHitExtra*)m_hdf5_record.vl_dircTruthPmtHitExtra.p;
      for (int i=0; i < (int)len; ++i ) {
         m_dircTruthPmtHitExtra_plist.push_back(new(p+i) DircTruthPmtHitExtra);
      }
   }
   if ((len = m_hdf5_record.vl_ecalBlock.len) > 0) {
      EcalBlock *p =(EcalBlock*)m_hdf5_record.vl_ecalBlock.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ecalBlock_plist.push_back(new(p+i) EcalBlock);
      }
   }
   if ((len = m_hdf5_record.vl_ecalHit.len) > 0) {
      EcalHit *p =(EcalHit*)m_hdf5_record.vl_ecalHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ecalHit_plist.push_back(new(p+i) EcalHit);
      }
   }
   if ((len = m_hdf5_record.vl_ecalTruthHit.len) > 0) {
      EcalTruthHit *p =(EcalTruthHit*)m_hdf5_record.vl_ecalTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ecalTruthHit_plist.push_back(new(p+i) EcalTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_ecalTruthShower.len) > 0) {
      EcalTruthShower *p =(EcalTruthShower*)m_hdf5_record.vl_ecalTruthShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ecalTruthShower_plist.push_back(new(p+i) EcalTruthShower);
      }
   }
   if ((len = m_hdf5_record.vl_errorMatrix.len) > 0) {
      ErrorMatrix *p =(ErrorMatrix*)m_hdf5_record.vl_errorMatrix.p;
      for (int i=0; i < (int)len; ++i ) {
         m_errorMatrix_plist.push_back(new(p+i) ErrorMatrix);
      }
   }
   if ((len = m_hdf5_record.vl_fcalBlock.len) > 0) {
      FcalBlock *p =(FcalBlock*)m_hdf5_record.vl_fcalBlock.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalBlock_plist.push_back(new(p+i) FcalBlock);
      }
   }
   if ((len = m_hdf5_record.vl_fcalDigihit.len) > 0) {
      FcalDigihit *p =(FcalDigihit*)m_hdf5_record.vl_fcalDigihit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalDigihit_plist.push_back(new(p+i) FcalDigihit);
      }
   }
   if ((len = m_hdf5_record.vl_fcalHit.len) > 0) {
      FcalHit *p =(FcalHit*)m_hdf5_record.vl_fcalHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalHit_plist.push_back(new(p+i) FcalHit);
      }
   }
   if ((len = m_hdf5_record.vl_fcalTruthHit.len) > 0) {
      FcalTruthHit *p =(FcalTruthHit*)m_hdf5_record.vl_fcalTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalTruthHit_plist.push_back(new(p+i) FcalTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_fcalTruthLightGuide.len) > 0) {
      FcalTruthLightGuide *p =(FcalTruthLightGuide*)m_hdf5_record.vl_fcalTruthLightGuide.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalTruthLightGuide_plist.push_back(new(p+i) FcalTruthLightGuide);
      }
   }
   if ((len = m_hdf5_record.vl_fcalTruthShower.len) > 0) {
      FcalTruthShower *p =(FcalTruthShower*)m_hdf5_record.vl_fcalTruthShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fcalTruthShower_plist.push_back(new(p+i) FcalTruthShower);
      }
   }
   if ((len = m_hdf5_record.vl_fdcAnodeHit.len) > 0) {
      FdcAnodeHit *p =(FdcAnodeHit*)m_hdf5_record.vl_fdcAnodeHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcAnodeHit_plist.push_back(new(p+i) FdcAnodeHit);
      }
   }
   if ((len = m_hdf5_record.vl_fdcAnodeTruthHit.len) > 0) {
      FdcAnodeTruthHit *p =(FdcAnodeTruthHit*)m_hdf5_record.vl_fdcAnodeTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcAnodeTruthHit_plist.push_back(new(p+i) FdcAnodeTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_fdcAnodeWire.len) > 0) {
      FdcAnodeWire *p =(FdcAnodeWire*)m_hdf5_record.vl_fdcAnodeWire.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcAnodeWire_plist.push_back(new(p+i) FdcAnodeWire);
      }
   }
   if ((len = m_hdf5_record.vl_fdcCathodeHit.len) > 0) {
      FdcCathodeHit *p =(FdcCathodeHit*)m_hdf5_record.vl_fdcCathodeHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcCathodeHit_plist.push_back(new(p+i) FdcCathodeHit);
      }
   }
   if ((len = m_hdf5_record.vl_fdcCathodeStrip.len) > 0) {
      FdcCathodeStrip *p =(FdcCathodeStrip*)m_hdf5_record.vl_fdcCathodeStrip.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcCathodeStrip_plist.push_back(new(p+i) FdcCathodeStrip);
      }
   }
   if ((len = m_hdf5_record.vl_fdcCathodeTruthHit.len) > 0) {
      FdcCathodeTruthHit *p =(FdcCathodeTruthHit*)m_hdf5_record.vl_fdcCathodeTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcCathodeTruthHit_plist.push_back(new(p+i) FdcCathodeTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_fdcChamber.len) > 0) {
      FdcChamber *p =(FdcChamber*)m_hdf5_record.vl_fdcChamber.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcChamber_plist.push_back(new(p+i) FdcChamber);
      }
   }
   if ((len = m_hdf5_record.vl_fdcDigihit.len) > 0) {
      FdcDigihit *p =(FdcDigihit*)m_hdf5_record.vl_fdcDigihit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcDigihit_plist.push_back(new(p+i) FdcDigihit);
      }
   }
   if ((len = m_hdf5_record.vl_fdcTruthPoint.len) > 0) {
      FdcTruthPoint *p =(FdcTruthPoint*)m_hdf5_record.vl_fdcTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fdcTruthPoint_plist.push_back(new(p+i) FdcTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcChamber.len) > 0) {
      FmwpcChamber *p =(FmwpcChamber*)m_hdf5_record.vl_fmwpcChamber.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcChamber_plist.push_back(new(p+i) FmwpcChamber);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcHit.len) > 0) {
      FmwpcHit *p =(FmwpcHit*)m_hdf5_record.vl_fmwpcHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcHit_plist.push_back(new(p+i) FmwpcHit);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcHitQ.len) > 0) {
      FmwpcHitQ *p =(FmwpcHitQ*)m_hdf5_record.vl_fmwpcHitQ.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcHitQ_plist.push_back(new(p+i) FmwpcHitQ);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcTruthHit.len) > 0) {
      FmwpcTruthHit *p =(FmwpcTruthHit*)m_hdf5_record.vl_fmwpcTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcTruthHit_plist.push_back(new(p+i) FmwpcTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcTruthHitQ.len) > 0) {
      FmwpcTruthHitQ *p =(FmwpcTruthHitQ*)m_hdf5_record.vl_fmwpcTruthHitQ.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcTruthHitQ_plist.push_back(new(p+i) FmwpcTruthHitQ);
      }
   }
   if ((len = m_hdf5_record.vl_fmwpcTruthPoint.len) > 0) {
      FmwpcTruthPoint *p =(FmwpcTruthPoint*)m_hdf5_record.vl_fmwpcTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_fmwpcTruthPoint_plist.push_back(new(p+i) FmwpcTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_forwardDC.len) > 0) {
      ForwardDC *p =(ForwardDC*)m_hdf5_record.vl_forwardDC.p;
      for (int i=0; i < (int)len; ++i ) {
         m_forwardDC_plist.push_back(new(p+i) ForwardDC);
      }
   }
   if ((len = m_hdf5_record.vl_forwardEMcal.len) > 0) {
      ForwardEMcal *p =(ForwardEMcal*)m_hdf5_record.vl_forwardEMcal.p;
      for (int i=0; i < (int)len; ++i ) {
         m_forwardEMcal_plist.push_back(new(p+i) ForwardEMcal);
      }
   }
   if ((len = m_hdf5_record.vl_forwardMWPC.len) > 0) {
      ForwardMWPC *p =(ForwardMWPC*)m_hdf5_record.vl_forwardMWPC.p;
      for (int i=0; i < (int)len; ++i ) {
         m_forwardMWPC_plist.push_back(new(p+i) ForwardMWPC);
      }
   }
   if ((len = m_hdf5_record.vl_forwardTOF.len) > 0) {
      ForwardTOF *p =(ForwardTOF*)m_hdf5_record.vl_forwardTOF.p;
      for (int i=0; i < (int)len; ++i ) {
         m_forwardTOF_plist.push_back(new(p+i) ForwardTOF);
      }
   }
   if ((len = m_hdf5_record.vl_ftofCounter.len) > 0) {
      FtofCounter *p =(FtofCounter*)m_hdf5_record.vl_ftofCounter.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ftofCounter_plist.push_back(new(p+i) FtofCounter);
      }
   }
   if ((len = m_hdf5_record.vl_ftofDigihit.len) > 0) {
      FtofDigihit *p =(FtofDigihit*)m_hdf5_record.vl_ftofDigihit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ftofDigihit_plist.push_back(new(p+i) FtofDigihit);
      }
   }
   if ((len = m_hdf5_record.vl_ftofHit.len) > 0) {
      FtofHit *p =(FtofHit*)m_hdf5_record.vl_ftofHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ftofHit_plist.push_back(new(p+i) FtofHit);
      }
   }
   if ((len = m_hdf5_record.vl_ftofTruthExtra.len) > 0) {
      FtofTruthExtra *p =(FtofTruthExtra*)m_hdf5_record.vl_ftofTruthExtra.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ftofTruthExtra_plist.push_back(new(p+i) FtofTruthExtra);
      }
   }
   if ((len = m_hdf5_record.vl_ftofTruthHit.len) > 0) {
      FtofTruthHit *p =(FtofTruthHit*)m_hdf5_record.vl_ftofTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ftofTruthHit_plist.push_back(new(p+i) FtofTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_ftofTruthPoint.len) > 0) {
      FtofTruthPoint *p =(FtofTruthPoint*)m_hdf5_record.vl_ftofTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_ftofTruthPoint_plist.push_back(new(p+i) FtofTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_gapEMcal.len) > 0) {
      GapEMcal *p =(GapEMcal*)m_hdf5_record.vl_gapEMcal.p;
      for (int i=0; i < (int)len; ++i ) {
         m_gapEMcal_plist.push_back(new(p+i) GapEMcal);
      }
   }
   if ((len = m_hdf5_record.vl_gcalCell.len) > 0) {
      GcalCell *p =(GcalCell*)m_hdf5_record.vl_gcalCell.p;
      for (int i=0; i < (int)len; ++i ) {
         m_gcalCell_plist.push_back(new(p+i) GcalCell);
      }
   }
   if ((len = m_hdf5_record.vl_gcalHit.len) > 0) {
      GcalHit *p =(GcalHit*)m_hdf5_record.vl_gcalHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_gcalHit_plist.push_back(new(p+i) GcalHit);
      }
   }
   if ((len = m_hdf5_record.vl_gcalTruthHit.len) > 0) {
      GcalTruthHit *p =(GcalTruthHit*)m_hdf5_record.vl_gcalTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_gcalTruthHit_plist.push_back(new(p+i) GcalTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_gcalTruthShower.len) > 0) {
      GcalTruthShower *p =(GcalTruthShower*)m_hdf5_record.vl_gcalTruthShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_gcalTruthShower_plist.push_back(new(p+i) GcalTruthShower);
      }
   }
   if ((len = m_hdf5_record.vl_geometry.len) > 0) {
      Geometry *p =(Geometry*)m_hdf5_record.vl_geometry.p;
      for (int i=0; i < (int)len; ++i ) {
         m_geometry_plist.push_back(new(p+i) Geometry);
      }
   }
   if ((len = m_hdf5_record.vl_hitView.len) > 0) {
      HitView *p =(HitView*)m_hdf5_record.vl_hitView.p;
      for (int i=0; i < (int)len; ++i ) {
         m_hitView_plist.push_back(new(p+i) HitView);
      }
   }
   if ((len = m_hdf5_record.vl_hodoChannel.len) > 0) {
      HodoChannel *p =(HodoChannel*)m_hdf5_record.vl_hodoChannel.p;
      for (int i=0; i < (int)len; ++i ) {
         m_hodoChannel_plist.push_back(new(p+i) HodoChannel);
      }
   }
   if ((len = m_hdf5_record.vl_mcTrajectory.len) > 0) {
      McTrajectory *p =(McTrajectory*)m_hdf5_record.vl_mcTrajectory.p;
      for (int i=0; i < (int)len; ++i ) {
         m_mcTrajectory_plist.push_back(new(p+i) McTrajectory);
      }
   }
   if ((len = m_hdf5_record.vl_mcTrajectoryPoint.len) > 0) {
      McTrajectoryPoint *p =(McTrajectoryPoint*)m_hdf5_record.vl_mcTrajectoryPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_mcTrajectoryPoint_plist.push_back(new(p+i) McTrajectoryPoint);
      }
   }
   if ((len = m_hdf5_record.vl_microChannel.len) > 0) {
      MicroChannel *p =(MicroChannel*)m_hdf5_record.vl_microChannel.p;
      for (int i=0; i < (int)len; ++i ) {
         m_microChannel_plist.push_back(new(p+i) MicroChannel);
      }
   }
   if ((len = m_hdf5_record.vl_momentum.len) > 0) {
      Momentum *p =(Momentum*)m_hdf5_record.vl_momentum.p;
      for (int i=0; i < (int)len; ++i ) {
         m_momentum_plist.push_back(new(p+i) Momentum);
      }
   }
   if ((len = m_hdf5_record.vl_origin.len) > 0) {
      Origin *p =(Origin*)m_hdf5_record.vl_origin.p;
      for (int i=0; i < (int)len; ++i ) {
         m_origin_plist.push_back(new(p+i) Origin);
      }
   }
   if ((len = m_hdf5_record.vl_pairSpectrometerCoarse.len) > 0) {
      PairSpectrometerCoarse *p =(PairSpectrometerCoarse*)m_hdf5_record.vl_pairSpectrometerCoarse.p;
      for (int i=0; i < (int)len; ++i ) {
         m_pairSpectrometerCoarse_plist.push_back(new(p+i) PairSpectrometerCoarse);
      }
   }
   if ((len = m_hdf5_record.vl_pairSpectrometerFine.len) > 0) {
      PairSpectrometerFine *p =(PairSpectrometerFine*)m_hdf5_record.vl_pairSpectrometerFine.p;
      for (int i=0; i < (int)len; ++i ) {
         m_pairSpectrometerFine_plist.push_back(new(p+i) PairSpectrometerFine);
      }
   }
   if ((len = m_hdf5_record.vl_physicsEvent.len) > 0) {
      PhysicsEvent *p =(PhysicsEvent*)m_hdf5_record.vl_physicsEvent.p;
      for (int i=0; i < (int)len; ++i ) {
         m_physicsEvent_plist.push_back(new(p+i) PhysicsEvent);
      }
   }
   if ((len = m_hdf5_record.vl_polarization.len) > 0) {
      Polarization *p =(Polarization*)m_hdf5_record.vl_polarization.p;
      for (int i=0; i < (int)len; ++i ) {
         m_polarization_plist.push_back(new(p+i) Polarization);
      }
   }
   if ((len = m_hdf5_record.vl_product.len) > 0) {
      Product *p =(Product*)m_hdf5_record.vl_product.p;
      for (int i=0; i < (int)len; ++i ) {
         m_product_plist.push_back(new(p+i) Product);
      }
   }
   if ((len = m_hdf5_record.vl_properties.len) > 0) {
      Properties *p =(Properties*)m_hdf5_record.vl_properties.p;
      for (int i=0; i < (int)len; ++i ) {
         m_properties_plist.push_back(new(p+i) Properties);
      }
   }
   if ((len = m_hdf5_record.vl_psHit.len) > 0) {
      PsHit *p =(PsHit*)m_hdf5_record.vl_psHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_psHit_plist.push_back(new(p+i) PsHit);
      }
   }
   if ((len = m_hdf5_record.vl_psTile.len) > 0) {
      PsTile *p =(PsTile*)m_hdf5_record.vl_psTile.p;
      for (int i=0; i < (int)len; ++i ) {
         m_psTile_plist.push_back(new(p+i) PsTile);
      }
   }
   if ((len = m_hdf5_record.vl_psTruthHit.len) > 0) {
      PsTruthHit *p =(PsTruthHit*)m_hdf5_record.vl_psTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_psTruthHit_plist.push_back(new(p+i) PsTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_psTruthPoint.len) > 0) {
      PsTruthPoint *p =(PsTruthPoint*)m_hdf5_record.vl_psTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_psTruthPoint_plist.push_back(new(p+i) PsTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_pscHit.len) > 0) {
      PscHit *p =(PscHit*)m_hdf5_record.vl_pscHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_pscHit_plist.push_back(new(p+i) PscHit);
      }
   }
   if ((len = m_hdf5_record.vl_pscPaddle.len) > 0) {
      PscPaddle *p =(PscPaddle*)m_hdf5_record.vl_pscPaddle.p;
      for (int i=0; i < (int)len; ++i ) {
         m_pscPaddle_plist.push_back(new(p+i) PscPaddle);
      }
   }
   if ((len = m_hdf5_record.vl_pscTruthHit.len) > 0) {
      PscTruthHit *p =(PscTruthHit*)m_hdf5_record.vl_pscTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_pscTruthHit_plist.push_back(new(p+i) PscTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_pscTruthPoint.len) > 0) {
      PscTruthPoint *p =(PscTruthPoint*)m_hdf5_record.vl_pscTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_pscTruthPoint_plist.push_back(new(p+i) PscTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_random.len) > 0) {
      Random *p =(Random*)m_hdf5_record.vl_random.p;
      for (int i=0; i < (int)len; ++i ) {
         m_random_plist.push_back(new(p+i) Random);
      }
   }
   if ((len = m_hdf5_record.vl_reaction.len) > 0) {
      Reaction *p =(Reaction*)m_hdf5_record.vl_reaction.p;
      for (int i=0; i < (int)len; ++i ) {
         m_reaction_plist.push_back(new(p+i) Reaction);
      }
   }
   if ((len = m_hdf5_record.vl_reconView.len) > 0) {
      ReconView *p =(ReconView*)m_hdf5_record.vl_reconView.p;
      for (int i=0; i < (int)len; ++i ) {
         m_reconView_plist.push_back(new(p+i) ReconView);
      }
   }
   if ((len = m_hdf5_record.vl_richTruthHit.len) > 0) {
      RichTruthHit *p =(RichTruthHit*)m_hdf5_record.vl_richTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_richTruthHit_plist.push_back(new(p+i) RichTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_richTruthPoint.len) > 0) {
      RichTruthPoint *p =(RichTruthPoint*)m_hdf5_record.vl_richTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_richTruthPoint_plist.push_back(new(p+i) RichTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_startCntr.len) > 0) {
      StartCntr *p =(StartCntr*)m_hdf5_record.vl_startCntr.p;
      for (int i=0; i < (int)len; ++i ) {
         m_startCntr_plist.push_back(new(p+i) StartCntr);
      }
   }
   if ((len = m_hdf5_record.vl_stcDigihit.len) > 0) {
      StcDigihit *p =(StcDigihit*)m_hdf5_record.vl_stcDigihit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_stcDigihit_plist.push_back(new(p+i) StcDigihit);
      }
   }
   if ((len = m_hdf5_record.vl_stcHit.len) > 0) {
      StcHit *p =(StcHit*)m_hdf5_record.vl_stcHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_stcHit_plist.push_back(new(p+i) StcHit);
      }
   }
   if ((len = m_hdf5_record.vl_stcPaddle.len) > 0) {
      StcPaddle *p =(StcPaddle*)m_hdf5_record.vl_stcPaddle.p;
      for (int i=0; i < (int)len; ++i ) {
         m_stcPaddle_plist.push_back(new(p+i) StcPaddle);
      }
   }
   if ((len = m_hdf5_record.vl_stcTruthHit.len) > 0) {
      StcTruthHit *p =(StcTruthHit*)m_hdf5_record.vl_stcTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_stcTruthHit_plist.push_back(new(p+i) StcTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_stcTruthPoint.len) > 0) {
      StcTruthPoint *p =(StcTruthPoint*)m_hdf5_record.vl_stcTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_stcTruthPoint_plist.push_back(new(p+i) StcTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_tagger.len) > 0) {
      Tagger *p =(Tagger*)m_hdf5_record.vl_tagger.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tagger_plist.push_back(new(p+i) Tagger);
      }
   }
   if ((len = m_hdf5_record.vl_taggerHit.len) > 0) {
      TaggerHit *p =(TaggerHit*)m_hdf5_record.vl_taggerHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_taggerHit_plist.push_back(new(p+i) TaggerHit);
      }
   }
   if ((len = m_hdf5_record.vl_taggerTruthHit.len) > 0) {
      TaggerTruthHit *p =(TaggerTruthHit*)m_hdf5_record.vl_taggerTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_taggerTruthHit_plist.push_back(new(p+i) TaggerTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_target.len) > 0) {
      Target *p =(Target*)m_hdf5_record.vl_target.p;
      for (int i=0; i < (int)len; ++i ) {
         m_target_plist.push_back(new(p+i) Target);
      }
   }
   if ((len = m_hdf5_record.vl_tpolHit.len) > 0) {
      TpolHit *p =(TpolHit*)m_hdf5_record.vl_tpolHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tpolHit_plist.push_back(new(p+i) TpolHit);
      }
   }
   if ((len = m_hdf5_record.vl_tpolSector.len) > 0) {
      TpolSector *p =(TpolSector*)m_hdf5_record.vl_tpolSector.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tpolSector_plist.push_back(new(p+i) TpolSector);
      }
   }
   if ((len = m_hdf5_record.vl_tpolTruthHit.len) > 0) {
      TpolTruthHit *p =(TpolTruthHit*)m_hdf5_record.vl_tpolTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tpolTruthHit_plist.push_back(new(p+i) TpolTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_tpolTruthPoint.len) > 0) {
      TpolTruthPoint *p =(TpolTruthPoint*)m_hdf5_record.vl_tpolTruthPoint.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tpolTruthPoint_plist.push_back(new(p+i) TpolTruthPoint);
      }
   }
   if ((len = m_hdf5_record.vl_trackID.len) > 0) {
      TrackID *p =(TrackID*)m_hdf5_record.vl_trackID.p;
      for (int i=0; i < (int)len; ++i ) {
         m_trackID_plist.push_back(new(p+i) TrackID);
      }
   }
   if ((len = m_hdf5_record.vl_tracktimebased.len) > 0) {
      Tracktimebased *p =(Tracktimebased*)m_hdf5_record.vl_tracktimebased.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tracktimebased_plist.push_back(new(p+i) Tracktimebased);
      }
   }
   if ((len = m_hdf5_record.vl_tripletPolarimeter.len) > 0) {
      TripletPolarimeter *p =(TripletPolarimeter*)m_hdf5_record.vl_tripletPolarimeter.p;
      for (int i=0; i < (int)len; ++i ) {
         m_tripletPolarimeter_plist.push_back(new(p+i) TripletPolarimeter);
      }
   }
   if ((len = m_hdf5_record.vl_upstreamEMveto.len) > 0) {
      UpstreamEMveto *p =(UpstreamEMveto*)m_hdf5_record.vl_upstreamEMveto.p;
      for (int i=0; i < (int)len; ++i ) {
         m_upstreamEMveto_plist.push_back(new(p+i) UpstreamEMveto);
      }
   }
   if ((len = m_hdf5_record.vl_upvHit.len) > 0) {
      UpvHit *p =(UpvHit*)m_hdf5_record.vl_upvHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_upvHit_plist.push_back(new(p+i) UpvHit);
      }
   }
   if ((len = m_hdf5_record.vl_upvPaddle.len) > 0) {
      UpvPaddle *p =(UpvPaddle*)m_hdf5_record.vl_upvPaddle.p;
      for (int i=0; i < (int)len; ++i ) {
         m_upvPaddle_plist.push_back(new(p+i) UpvPaddle);
      }
   }
   if ((len = m_hdf5_record.vl_upvTruthHit.len) > 0) {
      UpvTruthHit *p =(UpvTruthHit*)m_hdf5_record.vl_upvTruthHit.p;
      for (int i=0; i < (int)len; ++i ) {
         m_upvTruthHit_plist.push_back(new(p+i) UpvTruthHit);
      }
   }
   if ((len = m_hdf5_record.vl_upvTruthShower.len) > 0) {
      UpvTruthShower *p =(UpvTruthShower*)m_hdf5_record.vl_upvTruthShower.p;
      for (int i=0; i < (int)len; ++i ) {
         m_upvTruthShower_plist.push_back(new(p+i) UpvTruthShower);
      }
   }
   if ((len = m_hdf5_record.vl_userData.len) > 0) {
      UserData *p =(UserData*)m_hdf5_record.vl_userData.p;
      for (int i=0; i < (int)len; ++i ) {
         m_userData_plist.push_back(new(p+i) UserData);
      }
   }
   if ((len = m_hdf5_record.vl_userDataFloat.len) > 0) {
      UserDataFloat *p =(UserDataFloat*)m_hdf5_record.vl_userDataFloat.p;
      for (int i=0; i < (int)len; ++i ) {
         m_userDataFloat_plist.push_back(new(p+i) UserDataFloat);
      }
   }
   if ((len = m_hdf5_record.vl_userDataInt.len) > 0) {
      UserDataInt *p =(UserDataInt*)m_hdf5_record.vl_userDataInt.p;
      for (int i=0; i < (int)len; ++i ) {
         m_userDataInt_plist.push_back(new(p+i) UserDataInt);
      }
   }
   if ((len = m_hdf5_record.vl_vertex.len) > 0) {
      Vertex *p =(Vertex*)m_hdf5_record.vl_vertex.p;
      for (int i=0; i < (int)len; ++i ) {
         m_vertex_plist.push_back(new(p+i) Vertex);
      }
   }
   new(&m_geometry_link) GeometryLink(&m_geometry_plist,
            m_geometry_plist.begin(),
            m_geometry_plist.end(),
            this);
   new(&m_physicsEvent_list) PhysicsEventList(&m_physicsEvent_plist,
            m_physicsEvent_plist.begin(),
            m_physicsEvent_plist.end(),
            this);
   hdf5DataUnpack();
   return res;
}
hid_t HDDM::hdf5FileCreate(std::string name, unsigned int flags)
{
   hid_t file_id = H5Fcreate(name.c_str(), flags, H5P_DEFAULT, H5P_DEFAULT);
   hdf5FileStamp(file_id);
   return file_id;
}
hid_t HDDM::hdf5FileOpen(std::string name, unsigned int flags)
{
   hid_t file_id = H5Fopen(name.c_str(), flags, H5P_DEFAULT);
   hdf5FileCheck(file_id);
   return file_id;
}
herr_t HDDM::hdf5FileClose(hid_t file_id)
{
   herr_t res = H5Fclose(file_id);
   if (HDDM::s_hdf5_dataspace.find(file_id) != HDDM::s_hdf5_dataspace.end()) {
        H5Sclose(s_hdf5_dataspace[file_id]);
        s_hdf5_dataspace.erase(file_id);
   }
   if (s_hdf5_chunking.find(file_id) != s_hdf5_chunking.end()) {
       H5Pclose(s_hdf5_chunking[file_id]);
       s_hdf5_chunking.erase(file_id);
   }
   if (s_hdf5_dataset.find(file_id) != s_hdf5_dataset.end()) {
       H5Dclose(s_hdf5_dataset[file_id]);
       s_hdf5_dataset.erase(file_id);
   }
   return res;
}

void HDDM::hdf5DataPack()
{
   m_geometry_link.deflate();
   m_physicsEvent_list.deflate();
}
void HDDM::hdf5DataUnpack()
{
   {
      std::list<Geometry*> *host_plist = &m_host->m_geometry_plist;
      m_geometry_link.inflate(m_host, host_plist, this);
      GeometryList::iterator iter;
      for (iter = m_geometry_link.begin();
           iter != m_geometry_link.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
   {
      std::list<PhysicsEvent*> *host_plist = &m_host->m_physicsEvent_plist;
      m_physicsEvent_list.inflate(m_host, host_plist, this);
      PhysicsEventList::iterator iter;
      for (iter = m_physicsEvent_list.begin();
           iter != m_physicsEvent_list.end(); ++iter)
      {
         iter->hdf5DataUnpack();
      }
   }
}
#endif


void debug_print(CerenkovList &list) {
   list.debug_print();
}

void debug_print(ComptonEMcalList &list) {
   list.debug_print();
}

void debug_print(CrystalEcalList &list) {
   list.debug_print();
}

void debug_print(DIRCList &list) {
   list.debug_print();
}

void debug_print(RFsubsystemList &list) {
   list.debug_print();
}

void debug_print(RFtimeList &list) {
   list.debug_print();
}

void debug_print(RICHList &list) {
   list.debug_print();
}

void debug_print(TrackingErrorMatrixList &list) {
   list.debug_print();
}

void debug_print(BarrelEMcalList &list) {
   list.debug_print();
}

void debug_print(BcalCellList &list) {
   list.debug_print();
}

void debug_print(BcalSiPMDownHitList &list) {
   list.debug_print();
}

void debug_print(BcalSiPMSpectrumList &list) {
   list.debug_print();
}

void debug_print(BcalSiPMTruthList &list) {
   list.debug_print();
}

void debug_print(BcalSiPMUpHitList &list) {
   list.debug_print();
}

void debug_print(BcalTDCDigiHitList &list) {
   list.debug_print();
}

void debug_print(BcalTDCHitList &list) {
   list.debug_print();
}

void debug_print(BcalTruthHitList &list) {
   list.debug_print();
}

void debug_print(BcalTruthIncidentParticleList &list) {
   list.debug_print();
}

void debug_print(BcalTruthShowerList &list) {
   list.debug_print();
}

void debug_print(BcalfADCDigiHitList &list) {
   list.debug_print();
}

void debug_print(BcalfADCHitList &list) {
   list.debug_print();
}

void debug_print(BcalfADCPeakList &list) {
   list.debug_print();
}

void debug_print(BeamList &list) {
   list.debug_print();
}

void debug_print(CcalBlockList &list) {
   list.debug_print();
}

void debug_print(CcalHitList &list) {
   list.debug_print();
}

void debug_print(CcalTruthHitList &list) {
   list.debug_print();
}

void debug_print(CcalTruthShowerList &list) {
   list.debug_print();
}

void debug_print(CcdbContextList &list) {
   list.debug_print();
}

void debug_print(CdcDigihitList &list) {
   list.debug_print();
}

void debug_print(CdcHitQFList &list) {
   list.debug_print();
}

void debug_print(CdcStrawList &list) {
   list.debug_print();
}

void debug_print(CdcStrawHitList &list) {
   list.debug_print();
}

void debug_print(CdcStrawTruthHitList &list) {
   list.debug_print();
}

void debug_print(CdcTruthPointList &list) {
   list.debug_print();
}

void debug_print(CentralDCList &list) {
   list.debug_print();
}

void debug_print(CereHitList &list) {
   list.debug_print();
}

void debug_print(CereSectionList &list) {
   list.debug_print();
}

void debug_print(CereTruthHitList &list) {
   list.debug_print();
}

void debug_print(CereTruthPointList &list) {
   list.debug_print();
}

void debug_print(CppTOFList &list) {
   list.debug_print();
}

void debug_print(CtofCounterList &list) {
   list.debug_print();
}

void debug_print(CtofHitList &list) {
   list.debug_print();
}

void debug_print(CtofTruthHitList &list) {
   list.debug_print();
}

void debug_print(CtofTruthPointList &list) {
   list.debug_print();
}

void debug_print(DataVersionStringList &list) {
   list.debug_print();
}

void debug_print(DircPmtHitList &list) {
   list.debug_print();
}

void debug_print(DircTruthBarHitList &list) {
   list.debug_print();
}

void debug_print(DircTruthPmtHitList &list) {
   list.debug_print();
}

void debug_print(DircTruthPmtHitExtraList &list) {
   list.debug_print();
}

void debug_print(EcalBlockList &list) {
   list.debug_print();
}

void debug_print(EcalHitList &list) {
   list.debug_print();
}

void debug_print(EcalTruthHitList &list) {
   list.debug_print();
}

void debug_print(EcalTruthShowerList &list) {
   list.debug_print();
}

void debug_print(ErrorMatrixList &list) {
   list.debug_print();
}

void debug_print(FcalBlockList &list) {
   list.debug_print();
}

void debug_print(FcalDigihitList &list) {
   list.debug_print();
}

void debug_print(FcalHitList &list) {
   list.debug_print();
}

void debug_print(FcalTruthHitList &list) {
   list.debug_print();
}

void debug_print(FcalTruthLightGuideList &list) {
   list.debug_print();
}

void debug_print(FcalTruthShowerList &list) {
   list.debug_print();
}

void debug_print(FdcAnodeHitList &list) {
   list.debug_print();
}

void debug_print(FdcAnodeTruthHitList &list) {
   list.debug_print();
}

void debug_print(FdcAnodeWireList &list) {
   list.debug_print();
}

void debug_print(FdcCathodeHitList &list) {
   list.debug_print();
}

void debug_print(FdcCathodeStripList &list) {
   list.debug_print();
}

void debug_print(FdcCathodeTruthHitList &list) {
   list.debug_print();
}

void debug_print(FdcChamberList &list) {
   list.debug_print();
}

void debug_print(FdcDigihitList &list) {
   list.debug_print();
}

void debug_print(FdcTruthPointList &list) {
   list.debug_print();
}

void debug_print(FmwpcChamberList &list) {
   list.debug_print();
}

void debug_print(FmwpcHitList &list) {
   list.debug_print();
}

void debug_print(FmwpcHitQList &list) {
   list.debug_print();
}

void debug_print(FmwpcTruthHitList &list) {
   list.debug_print();
}

void debug_print(FmwpcTruthHitQList &list) {
   list.debug_print();
}

void debug_print(FmwpcTruthPointList &list) {
   list.debug_print();
}

void debug_print(ForwardDCList &list) {
   list.debug_print();
}

void debug_print(ForwardEMcalList &list) {
   list.debug_print();
}

void debug_print(ForwardMWPCList &list) {
   list.debug_print();
}

void debug_print(ForwardTOFList &list) {
   list.debug_print();
}

void debug_print(FtofCounterList &list) {
   list.debug_print();
}

void debug_print(FtofDigihitList &list) {
   list.debug_print();
}

void debug_print(FtofHitList &list) {
   list.debug_print();
}

void debug_print(FtofTruthExtraList &list) {
   list.debug_print();
}

void debug_print(FtofTruthHitList &list) {
   list.debug_print();
}

void debug_print(FtofTruthPointList &list) {
   list.debug_print();
}

void debug_print(GapEMcalList &list) {
   list.debug_print();
}

void debug_print(GcalCellList &list) {
   list.debug_print();
}

void debug_print(GcalHitList &list) {
   list.debug_print();
}

void debug_print(GcalTruthHitList &list) {
   list.debug_print();
}

void debug_print(GcalTruthShowerList &list) {
   list.debug_print();
}

void debug_print(GeometryList &list) {
   list.debug_print();
}

void debug_print(HitViewList &list) {
   list.debug_print();
}

void debug_print(HodoChannelList &list) {
   list.debug_print();
}

void debug_print(McTrajectoryList &list) {
   list.debug_print();
}

void debug_print(McTrajectoryPointList &list) {
   list.debug_print();
}

void debug_print(MicroChannelList &list) {
   list.debug_print();
}

void debug_print(MomentumList &list) {
   list.debug_print();
}

void debug_print(OriginList &list) {
   list.debug_print();
}

void debug_print(PairSpectrometerCoarseList &list) {
   list.debug_print();
}

void debug_print(PairSpectrometerFineList &list) {
   list.debug_print();
}

void debug_print(PhysicsEventList &list) {
   list.debug_print();
}

void debug_print(PolarizationList &list) {
   list.debug_print();
}

void debug_print(ProductList &list) {
   list.debug_print();
}

void debug_print(PropertiesList &list) {
   list.debug_print();
}

void debug_print(PsHitList &list) {
   list.debug_print();
}

void debug_print(PsTileList &list) {
   list.debug_print();
}

void debug_print(PsTruthHitList &list) {
   list.debug_print();
}

void debug_print(PsTruthPointList &list) {
   list.debug_print();
}

void debug_print(PscHitList &list) {
   list.debug_print();
}

void debug_print(PscPaddleList &list) {
   list.debug_print();
}

void debug_print(PscTruthHitList &list) {
   list.debug_print();
}

void debug_print(PscTruthPointList &list) {
   list.debug_print();
}

void debug_print(RandomList &list) {
   list.debug_print();
}

void debug_print(ReactionList &list) {
   list.debug_print();
}

void debug_print(ReconViewList &list) {
   list.debug_print();
}

void debug_print(RichTruthHitList &list) {
   list.debug_print();
}

void debug_print(RichTruthPointList &list) {
   list.debug_print();
}

void debug_print(StartCntrList &list) {
   list.debug_print();
}

void debug_print(StcDigihitList &list) {
   list.debug_print();
}

void debug_print(StcHitList &list) {
   list.debug_print();
}

void debug_print(StcPaddleList &list) {
   list.debug_print();
}

void debug_print(StcTruthHitList &list) {
   list.debug_print();
}

void debug_print(StcTruthPointList &list) {
   list.debug_print();
}

void debug_print(TaggerList &list) {
   list.debug_print();
}

void debug_print(TaggerHitList &list) {
   list.debug_print();
}

void debug_print(TaggerTruthHitList &list) {
   list.debug_print();
}

void debug_print(TargetList &list) {
   list.debug_print();
}

void debug_print(TpolHitList &list) {
   list.debug_print();
}

void debug_print(TpolSectorList &list) {
   list.debug_print();
}

void debug_print(TpolTruthHitList &list) {
   list.debug_print();
}

void debug_print(TpolTruthPointList &list) {
   list.debug_print();
}

void debug_print(TrackIDList &list) {
   list.debug_print();
}

void debug_print(TracktimebasedList &list) {
   list.debug_print();
}

void debug_print(TripletPolarimeterList &list) {
   list.debug_print();
}

void debug_print(UpstreamEMvetoList &list) {
   list.debug_print();
}

void debug_print(UpvHitList &list) {
   list.debug_print();
}

void debug_print(UpvPaddleList &list) {
   list.debug_print();
}

void debug_print(UpvTruthHitList &list) {
   list.debug_print();
}

void debug_print(UpvTruthShowerList &list) {
   list.debug_print();
}

void debug_print(UserDataList &list) {
   list.debug_print();
}

void debug_print(UserDataFloatList &list) {
   list.debug_print();
}

void debug_print(UserDataIntList &list) {
   list.debug_print();
}

void debug_print(VertexList &list) {
   list.debug_print();
}

streamposition::streamposition()
 : block_start(), block_offset(), block_status() {}

streamposition::streamposition(uint64_t start, uint32_t offset, uint32_t status)
 : block_start(start), block_offset(offset), block_status(status) {}

istream::istream(std::istream &src)
 : m_istr(src),
   m_status_bits(0)
{
   char hdr[1000];
   src.getline(hdr,7);
   m_documentString = hdr;
   while (m_documentString != "<HDDM ") {
      if (m_documentString == "<?xml ") {
         src.clear();
         src.getline(hdr,1000);
         src.getline(hdr,7);
         m_documentString = hdr;
         continue;
      }
      throw std::runtime_error("hddm_s::istream::istream error - invalid hddm header");
   }
   src.clear();
   std::string line;
   while (std::getline(src,line).good()) {
      m_documentString += line + "\n";
      if (line == "</HDDM>") {
         break;
      }
   }
   if (src.bad()) {
      throw std::runtime_error("hddm_s::istream::istream error - hddm header invalid");
   }
   pthread_mutex_init(&m_streambuf_mutex,0);
   for (int i=0; i<threads::max_threads; ++i) {
      my_thread_private[i] = 0;
   }
   m_leftovers[0] = 0;
   init_private_data();
}

istream::~istream() {
   pthread_mutex_destroy(&m_streambuf_mutex);
   for (int i=0; i<threads::max_threads; ++i) {
      thread_private_data *my_private = my_thread_private[i];
      if (my_private != 0) {
         if (MY(istr))
            delete MY(istr);
         if (MY(xcmp))
            delete MY(xcmp);
         if (MY(xstr))
            delete MY(xstr);
         if (MY(sbuf))
            delete MY(sbuf);
         delete [] MY(event_buffer);
         delete my_private;
      }
   }
}

void istream::init_private_data() {
   int threadID = threads::getID();
   if (my_thread_private[threadID] == 0) {
      my_thread_private[threadID] = new thread_private_data;
   }
   MY_SETUP
   MY(genome).m_tagname = "HDDM";
   MY(genome).m_sequence = synthesize(m_documentString,0,HDDM::DocumentString(),0);
   MY(event_buffer) = new char[MY(event_buffer_size) = 100000];
   MY(sbuf) = new istreambuffer(MY(event_buffer),MY(event_buffer_size));
   MY(xstr) = new xstream::xdr::istream(MY(sbuf));
   MY(istr) = new std::istream(m_istr.rdbuf());
   MY(xcmp) = 0;
   MY(event_size) = 0;
   MY(last_start) = 0;
   MY(last_offset) = 0;
   MY(next_start) = 0;
   MY(events_to_skip) = 0;
   MY(status_bits) = 0;
   MY(mutex_lock) = 0;
   MY(bytes_read) = 0;
   MY(records_read) = 0;
   MY(sequencing) = 0;
   MY(hit_eof) = 0;
}

streamposition istream::getPosition() {
   MY_SETUP
   streamposition pos;
   pos.block_start = MY(last_start);
   pos.block_offset = MY(last_offset);
   pos.block_status = MY(status_bits);
   return pos;
}

void istream::setPosition(const streamposition &pos) {
   MY_SETUP
   m_status_bits = pos.block_status;
   lock_streambufs();
   update_streambufs();
   unlock_streambufs();
   if (MY(status_bits) & (k_bz2_compression | k_z_compression)) {
      if (((int)m_status_bits & k_bits_compression) != 0 &&
          ((int)m_status_bits & k_can_reposition) == 0)
      {
         throw std::runtime_error("hddm_s::istream::setPosition error - "
                                  "old-format hddm input file does not support repositioning.");
      }
      else if (MY(xcmp) == 0) {
         throw std::runtime_error("hddm_s::istream::setPosition error - "
                                  "compressed stream encountered but no decompressor configured.");
      }
      if (MY(status_bits) & k_z_compression) {
         ((xstream::z::istreambuf*)MY(xcmp))->
             set_new_position(pos.block_start, pos.block_offset);
      }
      else if (MY(status_bits) & k_bz2_compression) {
         ((xstream::bz::istreambuf*)MY(xcmp))->
             set_new_position(pos.block_start, pos.block_offset);
      }
   }
   else {
      MY(next_start) = pos.block_start;
   }
}

void istream::update_streambufs() {
   MY_SETUP
   if ((int)m_status_bits != MY(status_bits)) {
      configure_streambufs();
   }
}

void istream::configure_streambufs() {
   MY_SETUP
   int oldcmp = MY(status_bits) & k_bits_compression;
   int newcmp = (int)m_status_bits & k_bits_compression;
   if (oldcmp != newcmp) {
      if (oldcmp != k_no_compression) {
         MY(istr)->rdbuf(m_istr.rdbuf());
         delete MY(xcmp);
         MY(xcmp) = 0;
      }
      if (newcmp == k_z_compression) {
         //std::cerr << "input switched on z compression" << std::endl;
         MY(xcmp) = new xstream::z::istreambuf(m_istr.rdbuf(), m_leftovers,
                                                        sizeof(m_leftovers));
         MY(istr)->rdbuf(MY(xcmp));
      }
      else if (newcmp == k_bz2_compression) {
         //std::cerr << "input switched on bz2 compression" << std::endl;
         MY(xcmp) = new xstream::bz::istreambuf(m_istr.rdbuf(), m_leftovers,
                                                         sizeof(m_leftovers));
         MY(istr)->rdbuf(MY(xcmp));
      }
      else if (newcmp != k_no_compression) {
         throw std::runtime_error("hddm_s::istream::configure_streambufs error - "
                                  "unrecognized compression flag requested.");
      }
   }
   MY(status_bits) = m_status_bits;
}

void istream::lock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) != 0) {
      unlock_streambufs();
      throw std::runtime_error("hddm_s::istream::lock_streambufs error - "
                               "mutex lock requested when lock already held.");
   }
   if ((MY(status_bits) & k_bits_compression) == k_no_compression) {
      pthread_mutex_lock(&m_streambuf_mutex);
      MY(mutex_lock) = 1;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_z_compression) {
      ((xstream::z::istreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 2;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_bz2_compression) {
      ((xstream::bz::istreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 3;
   }
   else {
      MY(mutex_lock) = -1;
   }
}

void istream::unlock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) == 0) {
      throw std::runtime_error("hddm_s::istream::unlock_streambufs error - "
                               "mutex unlock requested when lock not held.");
   }
   else if (MY(mutex_lock) == 1) {
      pthread_mutex_unlock(&m_streambuf_mutex);
   }
   else if (MY(mutex_lock) == 2) {
      ((xstream::z::istreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   else if (MY(mutex_lock) == 3) {
      ((xstream::bz::istreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   MY(mutex_lock) = 0;
}

istream &istream::operator>>(HDDM &record) {
   MY_SETUP
   while (1 == 1) {
      lock_streambufs();
      MY(event_size) = 0;
      while (MY(event_size) == 0) {
         update_streambufs();
         if (MY(status_bits) & (k_bz2_compression | k_z_compression)) {
            if (MY(status_bits) & k_can_reposition) {
               MY(istr)->clear();
               MY(istr)->read(MY(event_buffer),4);
               MY(bytes_read) += MY(istr)->gcount();
               if (!MY(istr)->good()) {
                  unlock_streambufs();
                  MY(hit_eof) = 1;
                  return *this;
               }
               if (MY(status_bits) & k_bz2_compression) {
                  MY(last_start)  = dynamic_cast<xstream::bz::istreambuf*>
                                    (MY(xcmp))->get_block_start();
                  MY(last_offset) = dynamic_cast<xstream::bz::istreambuf*>
                                    (MY(xcmp))->get_block_offset();
               }
               else {
                  MY(last_start)  = dynamic_cast<xstream::z::istreambuf*>
                                    (MY(xcmp))->get_block_start();
                  MY(last_offset) = dynamic_cast<xstream::z::istreambuf*>
                                    (MY(xcmp))->get_block_offset();
               }
               MY(last_offset) -= 4;
            }
            else {
               MY(last_start) = 0;
               MY(last_offset) = 0;
            }
         }
         else {
            if (MY(next_start) > 0) {
               m_istr.seekg(MY(next_start), std::ios_base::beg);
               MY(istr)->clear();
               MY(last_start) = MY(next_start);
               MY(last_offset) = 0;
               MY(next_start) = 0;
            }
            else {
               MY(last_start) = m_istr.tellg();
               MY(last_offset) = 0;
            }
            MY(istr)->read(MY(event_buffer),4);
            MY(bytes_read) += MY(istr)->gcount();
            if (!MY(istr)->good()) {
               unlock_streambufs();
               MY(hit_eof) = 1;
               return *this;
            }
         }
         MY(hit_eof) = 0;
         MY(sbuf)->reset();
         *MY(xstr) >> MY(event_size);
         if (MY(event_size) == 1) {
            MY(istr)->read(MY(event_buffer)+4,4);
            MY(bytes_read) += MY(istr)->gcount();
            if (!MY(istr)->good()) {
               unlock_streambufs();
               throw std::runtime_error("hddm_s::istream::operator>> error -"
                                        " read error on token input!");
            }
            int size;
            *MY(xstr) >> size;
            MY(istr)->read(MY(event_buffer)+8,size);
            MY(bytes_read) += MY(istr)->gcount();
            if (!MY(istr)->good()) {
               unlock_streambufs();
               throw std::runtime_error("hddm_s::istream::operator>> error -"
                                        " read error on token input!");
            }
            int format, flags;
            *MY(xstr) >> format >> flags;
            if (format != 0) {
               unlock_streambufs();
               throw std::runtime_error("hddm_s::istream::operator>> error - "
                                        "unsupported compression format!");
            }
            m_status_bits.store(flags);
            MY(event_size) = 0;
         }
      }
      if (MY(event_size)+8 > MY(event_buffer_size)) {
         delete MY(xstr);
         delete MY(sbuf);
         char *newbuf = new char[MY(event_buffer_size) = MY(event_size)+1000];
         MY(sbuf) = new istreambuffer(newbuf, MY(event_buffer_size));
         MY(xstr) = new xstream::xdr::istream(MY(sbuf));
         memcpy(newbuf,MY(event_buffer),4);
         delete [] MY(event_buffer);
         MY(event_buffer) = newbuf;
      }
      MY(istr)->read(MY(event_buffer)+4,MY(event_size));
      MY(bytes_read) += MY(istr)->gcount();
      MY(records_read)++;
      if (!MY(istr)->good()) {
         unlock_streambufs();
         throw std::runtime_error("hddm_s::istream::operator>> error -"
                                  " read error in mid-record!");
      }
      if ((MY(status_bits) & k_crc32_integrity) != 0) {
         unsigned int recorded_crc;
         char crcbuf[10];
         istreambuffer sbuf(crcbuf,10);
         xstream::xdr::istream xstr(&sbuf);
         MY(istr)->read(crcbuf,4);
         MY(bytes_read) += MY(istr)->gcount();
         xstr >> recorded_crc;
         xstream::digest::crc32 crc;
         std::ostream out(&crc);
         out.write(MY(event_buffer),MY(event_size)+4);
         out.flush();
         if (crc.digest() != recorded_crc) {
            char errmsg[] = 
                 "WARNING: crc data integrity check failed"
                 " on hddm_s input stream!";
            if ((MY(status_bits) & 0x02) == 0) {
               std::cerr << errmsg << std::endl;
               MY(status_bits) |= 0x02;
            }
            //unlock_streambufs();
            //throw std::runtime_error("hddm_s::istream::operator>> error -"
            //                 " crc check error on input stream!");
         }
      }
      unlock_streambufs();
      if (MY(events_to_skip) > 0) {
         --MY(events_to_skip);
      }
      else {
         break;
      }
   }
   MY(sbuf)->reset();
   MY(sequencing) = 0;
   MY(codon) = &MY(genome);
   record.clear();
   *this >> (streamable&)record;
   return *this;
}

ostream::ostream(std::ostream &src)
 : m_ostr(src),
   m_status_bits(k_default_status)
{
   m_ostr << HDDM::DocumentString();
   if (!m_ostr.good()) {
      throw std::runtime_error("hddm_s::ostream::ostream(ostream) "
                               "error - write error on header output!");
   }
   pthread_mutex_init(&m_streambuf_mutex,0);
   for (int i=0; i<threads::max_threads; ++i) {
      my_thread_private[i] = 0;
   }
   init_private_data();
}

ostream::~ostream() {
   pthread_mutex_destroy(&m_streambuf_mutex);
   for (int i=0; i<threads::max_threads; ++i) {
      thread_private_data *my_private = my_thread_private[i];
      if (my_private != 0) {
         if (MY(xstr)) {
            delete MY(xstr);
         }
         if (MY(sbuf)) {
            delete MY(sbuf);
         }
         if (MY(xcmp)) {
            MY(xcmp)->pubsync();
            MY(ostr)->rdbuf(m_ostr.rdbuf());
            delete MY(xcmp);
         }
         if (MY(ostr)) {
            MY(ostr)->flush();
            delete MY(ostr);
         }
         delete [] MY(event_buffer);
         delete my_private;
      }
   }
}

void ostream::init_private_data() {
   int threadID = threads::getID();
   if (my_thread_private[threadID] == 0) {
      my_thread_private[threadID] = new thread_private_data;
   }
   MY_SETUP
   MY(event_buffer) = new char[MY(event_buffer_size) = 100000];
   MY(sbuf) = new ostreambuffer(MY(event_buffer),MY(event_buffer_size));
   MY(xstr) = new xstream::xdr::ostream(MY(sbuf));
   MY(ostr) = new std::ostream(m_ostr.rdbuf());
   MY(xcmp) = 0;
   MY(last_start) = 0;
   MY(last_offset) = 0;
   MY(records_written) = 0;
   MY(bytes_written) = 0;
   MY(status_bits) = 0;
   MY(mutex_lock) = 0;
}

void ostream::setCompression(int flags) {
   MY_SETUP
   int oldcmp = (int)m_status_bits & k_bits_compression;
   int newcmp = flags & k_bits_compression;
   if (oldcmp != newcmp) {
      m_status_bits.fetch_and(~k_bits_compression | flags);
      m_status_bits.fetch_or(k_bits_compression & flags);
      if (newcmp != 0)
         m_status_bits.fetch_or(k_can_reposition);
      MY(sbuf)->reset();
      *MY(xstr) << 1 << 8 << 0 << (int)m_status_bits;
      lock_streambufs();
      MY(ostr)->write(MY(sbuf)->getbuf(),MY(sbuf)->size());
      if (!MY(ostr)->good()) {
         unlock_streambufs();
         throw std::runtime_error("hddm_s::ostream::setCompression"
                                  " error - write error on token output!");
      }
      MY(ostr)->flush();
      update_streambufs();
      unlock_streambufs();
   }
}

void ostream::setIntegrityChecks(int flags) {
   MY_SETUP
   int oldint = (int)m_status_bits & k_bits_integrity;
   int newint = flags & k_bits_integrity;
   if (oldint != newint) {
      m_status_bits.fetch_and(~k_bits_integrity | flags);
      m_status_bits.fetch_or(k_bits_integrity & flags);
      MY(sbuf)->reset();
      *MY(xstr) << 1 << 8 << 0 << (int)m_status_bits;
      lock_streambufs();
      MY(ostr)->write(MY(sbuf)->getbuf(),MY(sbuf)->size());
      if (!MY(ostr)->good()) {
         unlock_streambufs();
         throw std::runtime_error("hddm_s::ostream::setIntegrityChecks"
                                 " error - write error on token output!");
      }
      MY(ostr)->flush();
      update_streambufs();
      unlock_streambufs();
   }
}

streamposition ostream::getPosition() {
   MY_SETUP
   streamposition pos;
   pos.block_start = MY(last_start);
   pos.block_start = MY(last_offset);
   pos.block_status = MY(status_bits);
   return pos;
}

void ostream::update_streambufs() {
   MY_SETUP
   if ((int)m_status_bits != MY(status_bits)) {
      configure_streambufs();
   }
}

void ostream::configure_streambufs() {
   MY_SETUP
   int oldcmp = MY(status_bits) & k_bits_compression;
   int newcmp = (int)m_status_bits & k_bits_compression;
   if (oldcmp != newcmp) {
      if (oldcmp != k_no_compression) {
         MY(ostr)->rdbuf(m_ostr.rdbuf());
         delete MY(xcmp);
         MY(xcmp) = 0;
      }
      if (newcmp == k_z_compression) {
         //std::cerr << "output switched on z compression" << std::endl;
         MY(xcmp) = new xstream::z::ostreambuf(m_ostr.rdbuf());
         MY(ostr)->rdbuf(MY(xcmp));
      }
      else if (newcmp == k_bz2_compression) {
         //std::cerr << "output switched on bz2 compression" << std::endl;
         MY(xcmp )= new xstream::bz::ostreambuf(m_ostr.rdbuf());
         MY(ostr)->rdbuf(MY(xcmp));
      }
      else if (newcmp != k_no_compression) {
         throw std::runtime_error("hddm_s::ostream::configure_streambufs error - "
                                  "unrecognized compression flag requested.");
      }
   }
   MY(status_bits) = m_status_bits;
}

void ostream::lock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) != 0) {
      unlock_streambufs();
      throw std::runtime_error("hddm_s::ostream::lock_streambufs error - "
                               "mutex lock requested when lock already held.");
   }
   if ((MY(status_bits) & k_bits_compression) == k_no_compression) {
      pthread_mutex_lock(&m_streambuf_mutex);
      MY(mutex_lock) = 1;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_z_compression) {
      ((xstream::z::ostreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 2;
   }
   else if ((MY(status_bits) & k_bits_compression) == k_bz2_compression) {
      ((xstream::bz::ostreambuf*)MY(xcmp))->set_streambuf_mutex(&m_streambuf_mutex);
      MY(mutex_lock) = 3;
   }
   else {
      MY(mutex_lock) = -1;
   }
}

void ostream::unlock_streambufs() {
   MY_SETUP
   if (MY(mutex_lock) == 0) {
      throw std::runtime_error("hddm_s::ostream::unlock_streambufs error - "
                               "mutex unlock requested when lock not held.");
   }
   else if (MY(mutex_lock) == 1) {
      pthread_mutex_unlock(&m_streambuf_mutex);
   }
   else if (MY(mutex_lock) == 2) {
      ((xstream::z::ostreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   else if (MY(mutex_lock) == 3) {
      ((xstream::bz::ostreambuf*)MY(xcmp))->set_streambuf_mutex(0);
   }
   MY(mutex_lock) = 0;
}

size_t istream::getTag(const std::string &src, size_t start,
                       std::string &tag, int &level)
{
   tag = "";
   size_t p_btag = src.find("<",start);
   size_t p_bline = src.find_last_of("\n",p_btag);
   if (p_bline == std::string::npos)
   {
      p_bline = 0;
   }
   else
   {
      ++p_bline;
   }
   level = int(p_btag-p_bline)/2;
   size_t p_etag = p_btag;
   for (size_t quotes=0; p_etag < src.size(); ++p_etag) {
      if (src[p_etag] == '"') {
         tag += "\"";
         ++quotes;
      }
      else if (quotes/2*2 != quotes) {
         tag += src[p_etag];
      }
      else if (src.find_first_of(" \t\n",p_etag) == 0) {
         tag += " ";
         p_etag = src.find_first_not_of(" \t\n",p_etag)-1;
      }
      else if (src[p_etag] == '>') {
         tag += ">";
         break;
      }
      else {
         tag += src[p_etag];
      }
   }
   if (p_etag == src.size()) {
      std::stringstream sstr;
      sstr << "hddm_s::istream::getTag"
           << " error - bad header format" << std::endl
           << "   tag " << tag << " at position " << start
           << std::endl;
      throw std::runtime_error(sstr.str());
   }
   return p_etag+2;
}

size_t istream::getEndTag(const std::string &src, size_t start,
                          const std::string &tag)
{
   if (tag.rfind("/>") == tag.size()-2) {
      return src.find(tag,start) + tag.size()+1;
   }
   else {
      std::string etag = "</";
      etag += tag.substr(1,tag.find_first_of(' ')-1) + ">";
      size_t p_etag = src.find(etag,start);
      size_t p_quote = src.find_first_of('"',start);
      while (p_quote != std::string::npos && p_quote < p_etag) {
         p_quote = src.find_first_of('"',p_quote+1);
         if (p_quote > p_etag) {
            p_etag = src.find(etag,p_quote+1);
         }
         p_quote = src.find_first_of('"',p_quote+1);
      }
      if (p_etag == std::string::npos) {
         std::stringstream sstr;
         sstr << "hddm_s::istream::getEndTag"
              << " error - bad header format" << std::endl
              << "   tag " << tag << " at position " << start
              << std::endl
              << "   end tag " << etag << " not found."
              << std::endl;
         throw std::runtime_error(sstr.str());
      }
      return p_etag + etag.size()+1;
   }
}

void istream::collide(const std::string &itag, const std::string &rtag) {
   std::string itagname = itag.substr(1,itag.find(" ")-1);
   std::string rtagname = rtag.substr(1,rtag.find(" ")-1);
   std::string errmsg = "hddm_s::istream::collide warning:\n"
         "tag " + itagname + " in input file "
         "does not match c++ header hddm_s.hpp\n"
         "  input file: " + itag + "\n"
         "  c++ header: " + rtag + "\n"
         "  === Tag " + itagname + " will be ignored,"
         " rebuild to cure the problem ===";
   if (itagname != "HDDM") {
      std::cerr << errmsg << std::endl;
   }
   else {
      throw std::runtime_error(errmsg);
   }
}

chromosome istream::synthesize(const std::string &src, size_t p_src,
                               const std::string &ref, size_t p_ref)
{
   chromosome chrom;
   int slevel, rlevel;
   std::string stag, rtag;
   p_src = getTag(src,p_src,stag,slevel);
   p_ref = getTag(ref,p_ref,rtag,rlevel);
   std::string stagname = stag.substr(1,stag.find(" ")-1);
   std::string rtagname = rtag.substr(1,rtag.find(" ")-1);
   if (stagname != rtagname) {
      throw std::runtime_error("hddm_s::istream::synthesize error - matching algorithm error #2");
   }
   else if (!tags_match(stag,rtag)) {
      collide(stag,rtag);
      return chrom;
   }

   size_t p2_src, p2_ref;
   int s2level, r2level;
   std::string s2tag, r2tag;
   getTag(src,p2_src=p_src,s2tag,s2level);
   while (s2level > slevel) {
      codon *gene = new codon();
      std::string s2tagname = s2tag.substr(1,s2tag.find(" ")-1);
      getTag(ref,p2_ref=p_ref,r2tag,r2level);
      int order_of_this_tag_in_ref = 1;
      while (r2level == s2level) {
         std::string r2tagname = r2tag.substr(1,r2tag.find(" ")-1);
         if (s2tagname == r2tagname) {
            if (!tags_match(s2tag,r2tag)) {
               collide(s2tag,r2tag);
               break;
            }
            else {
               gene->m_order = order_of_this_tag_in_ref;
            }
            gene->m_sequence = synthesize(src,p2_src,ref,p2_ref);
            break;
         }
         p2_ref = getEndTag(ref,p2_ref,r2tag);
         getTag(ref,p2_ref,r2tag,r2level);
         ++order_of_this_tag_in_ref;
      }
      gene->m_tagname = s2tagname;
      chrom.push_back(*gene);
      delete gene;
      p2_src = getEndTag(src,p2_src,s2tag);
      getTag(src,p2_src,s2tag,s2level);
   }
   return chrom;
}

#ifdef HDF5_SUPPORT
std::map<std::string, hid_t> HDDM::s_hdf5_datatype;
std::map<std::string, hid_t> HDDM::s_hdf5_memorytype;
std::map<std::string, hid_t> HDDM::s_hdf5_memoryspace;
std::map<hid_t, hid_t> HDDM::s_hdf5_dataspace;
std::map<hid_t, hid_t> HDDM::s_hdf5_chunking;
std::map<hid_t, hid_t> HDDM::s_hdf5_dataset;
#endif
