# coding: utf-8

import pprint
import re

import six





class CustomerErrorDetail:


    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    sensitive_list = []

    openapi_types = {
        'error_code': 'str',
        'error_msg': 'str',
        'id': 'str'
    }

    attribute_map = {
        'error_code': 'error_code',
        'error_msg': 'error_msg',
        'id': 'id'
    }

    def __init__(self, error_code=None, error_msg=None, id=None):
        """CustomerErrorDetail - a model defined in huaweicloud sdk"""
        
        

        self._error_code = None
        self._error_msg = None
        self._id = None
        self.discriminator = None

        if error_code is not None:
            self.error_code = error_code
        if error_msg is not None:
            self.error_msg = error_msg
        if id is not None:
            self.id = id

    @property
    def error_code(self):
        """Gets the error_code of this CustomerErrorDetail.

        |参数名称：返回码。具体请参见表 未命名。注意，这个时候的状态码全部是200| |参数约束及描述：返回码。具体请参见表 未命名。注意，这个时候的状态码全部是200|

        :return: The error_code of this CustomerErrorDetail.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this CustomerErrorDetail.

        |参数名称：返回码。具体请参见表 未命名。注意，这个时候的状态码全部是200| |参数约束及描述：返回码。具体请参见表 未命名。注意，这个时候的状态码全部是200|

        :param error_code: The error_code of this CustomerErrorDetail.
        :type: str
        """
        self._error_code = error_code

    @property
    def error_msg(self):
        """Gets the error_msg of this CustomerErrorDetail.

        |参数名称：返回码的描述信息。| |参数约束及描述：返回码的描述信息。|

        :return: The error_msg of this CustomerErrorDetail.
        :rtype: str
        """
        return self._error_msg

    @error_msg.setter
    def error_msg(self, error_msg):
        """Sets the error_msg of this CustomerErrorDetail.

        |参数名称：返回码的描述信息。| |参数约束及描述：返回码的描述信息。|

        :param error_msg: The error_msg of this CustomerErrorDetail.
        :type: str
        """
        self._error_msg = error_msg

    @property
    def id(self):
        """Gets the id of this CustomerErrorDetail.

        |参数名称：标示ID。该接口对应的是customerId。| |参数约束及描述：标示ID。该接口对应的是customerId。|

        :return: The id of this CustomerErrorDetail.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CustomerErrorDetail.

        |参数名称：标示ID。该接口对应的是customerId。| |参数约束及描述：标示ID。该接口对应的是customerId。|

        :param id: The id of this CustomerErrorDetail.
        :type: str
        """
        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if attr in self.sensitive_list:
                    result[attr] = "****"
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CustomerErrorDetail):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
