"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsRuleToStepFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_eventbridge_stepfunctions_1 = require("@aws-solutions-constructs/aws-eventbridge-stepfunctions");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
class EventsRuleToStepFunction extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the EventsRuleToStepFunction class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventsRuleToStepFunctionProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const convertedProps = { ...props };
        // W (for 'wrapped') is added to the id so that the id's of the constructs with the old and new names don't collide
        // If this character pushes you beyond the 64 character limit, just import the new named construct and instantiate
        // it in place of the older named version. They are functionally identical, aside from the types no other changes
        // will be required.  (eg - new EventbridgeToStepfunctions instead of EventsRuleToStepFunction)
        const wrappedConstruct = new aws_eventbridge_stepfunctions_1.EventbridgeToStepfunctions(this, `${id}W`, convertedProps);
        this.stateMachine = wrappedConstruct.stateMachine;
        this.stateMachineLogGroup = wrappedConstruct.stateMachineLogGroup;
        this.eventsRule = wrappedConstruct.eventsRule;
        this.cloudwatchAlarms = wrappedConstruct.cloudwatchAlarms;
        this.eventBus = wrappedConstruct.eventBus;
    }
}
exports.EventsRuleToStepFunction = EventsRuleToStepFunction;
_a = JSII_RTTI_SYMBOL_1;
EventsRuleToStepFunction[_a] = { fqn: "@aws-solutions-constructs/aws-events-rule-step-function.EventsRuleToStepFunction", version: "1.172.0" };
//# sourceMappingURL=data:application/json;base64,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