# Copyright (c) 2014-present ZhiXin <contact@zhixin.org>
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from zhixin.exception import ZhixinException, UserSideException


class UnitTestError(ZhixinException):
    pass


class TestDirNotExistsError(UnitTestError, UserSideException):
    MESSAGE = (
        "A test folder '{0}' does not exist.\nPlease create 'test' "
        "directory in the project root and put a test suite.\n"
        "More details about Unit "
        "Testing: https://docs.zhixin.org/en/latest/advanced/"
        "unit-testing/index.html"
    )


class UnitTestSuiteError(UnitTestError):
    pass
