package unimr.vod.hmac;

/*
 * RED5 Open Source Flash Server - http://www.osflash.org/red5
 * 
 * Copyright (c) 2006-2008 by respective authors (see below). All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU Lesser General Public License as published by the Free Software 
 * Foundation; either version 2.1 of the License, or (at your option) any later 
 * version. 
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along 
 * with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

import org.red5.server.api.IScope;
//import org.red5.server.api.ScopeUtils;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

/**
 *  @author Andreas Gabriel (gabriel@hrz.uni-marburg.de)
 *  @author David Nax (naxd@hrz.uni-marburg.de)
 */
public class StreamFilenameGenerator implements IStreamFilenameGenerator {

	/**
	 * Generate stream directory based on relative scope path by
	 * cropping the signature and expire date. The base directory is
	 * <code>streams</code>, e.g. a scope with signature
	 * <code>/application/one/two/signature/expires/</code> will
	 * generate a directory <code>/streams/one/two/</code> inside the
	 * application.
	 * 
	 * @param scope            Scope
	 * @return                 Directory based on relative scope path
	 */

	protected Logger log = Red5LoggerFactory.getLogger( StreamFilenameGenerator.class , "protectedVOD");
	/** {@inheritDoc} */
	private String getStreamDirectory(IScope scope) {
		String contextPath, virtualPath;
		final StringBuilder result = new StringBuilder();
		final String prefix = "streams/";
		final StringBuilder realPath = new StringBuilder();

		contextPath = scope.getContextPath();

		// strip beginning slash from path
		if(contextPath.startsWith("/")){
			contextPath = contextPath.substring(1);
		}
		result.append(contextPath);

		if (result.length() == 0) {
			virtualPath = prefix;
		} else {
			result.insert(0, prefix);
			virtualPath = result.toString();
			if (!result.toString().endsWith("/")){
				result.append("/");
			}
			virtualPath = result.toString();
		}

		// cropping signature and expire date
		String[] params = virtualPath.split("/");
		for (int i = 0; i < params.length; i++){
			if (i < params.length -2 ) {
				realPath.append(params[i]+"/");	
			}
		}

		return realPath.toString();
	}

	/** {@inheritDoc} */
	public String generateFilename(IScope scope, String name, GenerationType type) {
		return generateFilename(scope, name, null, type);
	}

	/** {@inheritDoc} */
	public String generateFilename(IScope scope, String name, String extension, GenerationType type) {
		// strip beginning slash from name

		if(name.startsWith("/")){
			name = name.substring(1);
		}	
		String result = getStreamDirectory(scope) + name;
		if (extension != null && !extension.equals("")) {
			result += extension;
		}
		log.info(result);
		return result;
	}

	/**
	 * The default filenames are relative to the scope path, so always return <code>false</code>.
	 * 
	 * @return	always <code>false</code>
	 */
	public boolean resolvesToAbsolutePath() {
		return false;
	}  

}
