# =====================================================================================================================
# VERSION = (0, 0, 1)   # use import EXACT_OBJECTS! not *
#   from .main import *                 # INcorrect
#   from .main import EXACT_OBJECTS     # CORRECT


# =====================================================================================================================
from .info import (
    ObjectInfo,

    ItemInternal,
    ObjectState,
)
from .obj_types import (
    TypeChecker,
    TypeEnsure,

    TYPE__NONE,
    TYPE__FUNCTION,
    TYPE__METHOD,
)

# ---------------------------------------------------------------------------------------------------------------------
from .primitives import (
    BLANK,

    # BASE
    GEN_COMPR,

    FUNC,
    FUNC_NONE, FUNC_TRUE, FUNC_FALSE, FUNC_ECHO,
    FUNC_EXX, FUNC_RAISE,
    FUNC_ALL,
    FUNC_ANY,
    FUNC_LIST_DIRECT,
    FUNC_LIST_VALUES,
    FUNC_DICT,
    FUNC_GEN,

    SLEEP,
    SLEEP_NONE, SLEEP_TRUE, SLEEP_FALSE,
    SLEEP_EXX, SLEEP_RAISE,

    LAMBDA,
    LAMBDA_NONE, LAMBDA_TRUE, LAMBDA_FALSE, LAMBDA_ECHO,
    LAMBDA_EXX, LAMBDA_RAISE,
    LAMBDA_ALL,
    LAMBDA_ANY,
    LAMBDA_LIST_DIRECT,
    LAMBDA_LIST_VALUES,
    LAMBDA_DICT,
    LAMBDA_GEN,

    ClsException, INST_EXCEPTION,

    ClsInt,
    ClsFloat,
    ClsStr,
    ClsList,
    ClsSet,
    ClsDict,

    Cls, INST,
    ClsEmpty, INST_EMPTY,

    ClsInitArgsKwargs,
    ClsInitRaise,

    ClsCall, INST_CALL,
    ClsCallNone, INST_CALL_NONE,
    ClsCallTrue, INST_CALL_TRUE,
    ClsCallFalse, INST_CALL_FALSE,
    ClsCallExx, INST_CALL_EXX,
    ClsCallRaise, INST_CALL_RAISE,

    ClsBoolTrue, INST_BOOL_TRUE,
    ClsBoolFalse, INST_BOOL_FALSE,
    ClsBoolRaise, INST_BOOL_RAISE,

    ClsIterYield, INST_ITER_YIELD,
    ClsIterArgs, INST_ITER_ARGS,
    ClsGen, INST_GEN,

    ClsEq, INST_EQ,
    ClsEqTrue, INST_EQ_TRUE,
    ClsEqFalse, INST_EQ_FALSE,
    ClsEqRaise, INST_EQ_RAISE,

    ClsFullTypes, INST_FULL_TYPES,

    CALLABLE_LAMBDA,
    CALLABLE_FUNC,

    CALLABLE_CLS,
    CALLABLE_INST,

    CALLABLE_METH_CLS,
    CALLABLE_METH_CLS_CLASSMETHOD,
    CALLABLE_METH_CLS_STATICMETHOD,
    CALLABLE_METH_CLS_PROPERTY,
    CALLABLE_METH_CLS_PROPERTY_CLASSMETHOD,

    CALLABLE_METH_INST,
    CALLABLE_METH_INST_CLASSMETHOD,
    CALLABLE_METH_INST_STATICMETHOD,
    CALLABLE_METH_INST_PROPERTY,
    CALLABLE_METH_INST_PROPERTY_CLASSMETHOD,
)


# =====================================================================================================================
