"""
    Production API

    API exposing endpoints for managing well  and daily production.  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

import nulltype  # noqa: F401

from openapi_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


class Formation(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('primary_fluid_type',): {
            'OIL': "OIL",
            'GAS': "GAS",
            'WATER': "WATER",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'xid': (str,),  # noqa: E501
            'source_id': (str,),  # noqa: E501
            'name': (str, none_type,),  # noqa: E501
            'pressure_formation_initial_datum': (float,),  # noqa: E501
            'temperature_formation_datum': (float,),  # noqa: E501
            'depth': (float,),  # noqa: E501
            'primary_fluid_type': (str,),  # noqa: E501
            'rsi': (float,),  # noqa: E501
            'fluid_gravity_api': (float,),  # noqa: E501
            'fluid_gravity_gas': (float,),  # noqa: E501
            'fluid_salinity_water': (float,),  # noqa: E501
            'allocation_factor': (float, none_type,),  # noqa: E501
            'compressibility_rock': (float, none_type,),  # noqa: E501
            'thickness_formation': (float, none_type,),  # noqa: E501
            'porosity': (float, none_type,),  # noqa: E501
            'saturation_water_initial': (float, none_type,),  # noqa: E501
            'saturation_gas_initial': (float, none_type,),  # noqa: E501
            'saturation_oil_initial': (float, none_type,),  # noqa: E501
            'volume_acquifer_initial': (float, none_type,),  # noqa: E501
            'fluid_comingled_gor': (float, none_type,),  # noqa: E501
            'fluid_molar_frac_n2': (float, none_type,),  # noqa: E501
            'fluid_molar_frac_co2': (float, none_type,),  # noqa: E501
            'fluid_molar_frac_h2_s': (float, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'xid': 'xid',  # noqa: E501
        'source_id': 'sourceId',  # noqa: E501
        'name': 'name',  # noqa: E501
        'pressure_formation_initial_datum': 'pressureFormationInitialDatum',  # noqa: E501
        'temperature_formation_datum': 'temperatureFormationDatum',  # noqa: E501
        'depth': 'depth',  # noqa: E501
        'primary_fluid_type': 'primaryFluidType',  # noqa: E501
        'rsi': 'rsi',  # noqa: E501
        'fluid_gravity_api': 'fluidGravityApi',  # noqa: E501
        'fluid_gravity_gas': 'fluidGravityGas',  # noqa: E501
        'fluid_salinity_water': 'fluidSalinityWater',  # noqa: E501
        'allocation_factor': 'allocationFactor',  # noqa: E501
        'compressibility_rock': 'compressibilityRock',  # noqa: E501
        'thickness_formation': 'thicknessFormation',  # noqa: E501
        'porosity': 'porosity',  # noqa: E501
        'saturation_water_initial': 'saturationWaterInitial',  # noqa: E501
        'saturation_gas_initial': 'saturationGasInitial',  # noqa: E501
        'saturation_oil_initial': 'saturationOilInitial',  # noqa: E501
        'volume_acquifer_initial': 'volumeAcquiferInitial',  # noqa: E501
        'fluid_comingled_gor': 'fluidComingledGOR',  # noqa: E501
        'fluid_molar_frac_n2': 'fluidMolarFracN2',  # noqa: E501
        'fluid_molar_frac_co2': 'fluidMolarFracCO2',  # noqa: E501
        'fluid_molar_frac_h2_s': 'fluidMolarFracH2S',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, xid, source_id, name, pressure_formation_initial_datum, temperature_formation_datum, depth, rsi, fluid_gravity_api, fluid_gravity_gas, fluid_salinity_water, *args, **kwargs):  # noqa: E501
        """Formation - a model defined in OpenAPI

        Args:
            xid (str):
            source_id (str):
            name (str, none_type):
            pressure_formation_initial_datum (float):
            temperature_formation_datum (float):
            depth (float):
            rsi (float):
            fluid_gravity_api (float):
            fluid_gravity_gas (float):
            fluid_salinity_water (float):

        Keyword Args:
            primary_fluid_type (str): defaults to "OIL", must be one of ["OIL", "GAS", "WATER", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            allocation_factor (float, none_type): [optional] if omitted the server will use the default value of 1.0  # noqa: E501
            compressibility_rock (float, none_type): [optional]  # noqa: E501
            thickness_formation (float, none_type): [optional]  # noqa: E501
            porosity (float, none_type): [optional]  # noqa: E501
            saturation_water_initial (float, none_type): [optional]  # noqa: E501
            saturation_gas_initial (float, none_type): [optional]  # noqa: E501
            saturation_oil_initial (float, none_type): [optional]  # noqa: E501
            volume_acquifer_initial (float, none_type): [optional]  # noqa: E501
            fluid_comingled_gor (float, none_type): [optional]  # noqa: E501
            fluid_molar_frac_n2 (float, none_type): [optional] if omitted the server will use the default value of 0.0  # noqa: E501
            fluid_molar_frac_co2 (float, none_type): [optional] if omitted the server will use the default value of 0.0  # noqa: E501
            fluid_molar_frac_h2_s (float, none_type): [optional] if omitted the server will use the default value of 0.0  # noqa: E501
        """

        primary_fluid_type = kwargs.get('primary_fluid_type', "OIL")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.xid = xid
        self.source_id = source_id
        self.name = name
        self.pressure_formation_initial_datum = pressure_formation_initial_datum
        self.temperature_formation_datum = temperature_formation_datum
        self.depth = depth
        self.primary_fluid_type = primary_fluid_type
        self.rsi = rsi
        self.fluid_gravity_api = fluid_gravity_api
        self.fluid_gravity_gas = fluid_gravity_gas
        self.fluid_salinity_water = fluid_salinity_water
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
