from http import HTTPStatus
from typing import Any

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.geofence import Geofence
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    all_: bool | Unset = UNSET,
    user_id: int | Unset = UNSET,
    device_id: int | Unset = UNSET,
    group_id: int | Unset = UNSET,
    refresh: bool | Unset = UNSET,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    params["all"] = all_

    params["userId"] = user_id

    params["deviceId"] = device_id

    params["groupId"] = group_id

    params["refresh"] = refresh

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": "/geofences",
        "params": params,
    }

    return _kwargs


def _parse_response(*, client: AuthenticatedClient | Client, response: httpx.Response) -> list[Geofence] | None:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = Geofence.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(*, client: AuthenticatedClient | Client, response: httpx.Response) -> Response[list[Geofence]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient | Client,
    all_: bool | Unset = UNSET,
    user_id: int | Unset = UNSET,
    device_id: int | Unset = UNSET,
    group_id: int | Unset = UNSET,
    refresh: bool | Unset = UNSET,
) -> Response[list[Geofence]]:
    """Fetch a list of Geofences

     Without params, it returns a list of Geofences the user has access to

    Args:
        all_ (bool | Unset):
        user_id (int | Unset):
        device_id (int | Unset):
        group_id (int | Unset):
        refresh (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[list[Geofence]]
    """

    kwargs = _get_kwargs(
        all_=all_,
        user_id=user_id,
        device_id=device_id,
        group_id=group_id,
        refresh=refresh,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient | Client,
    all_: bool | Unset = UNSET,
    user_id: int | Unset = UNSET,
    device_id: int | Unset = UNSET,
    group_id: int | Unset = UNSET,
    refresh: bool | Unset = UNSET,
) -> list[Geofence] | None:
    """Fetch a list of Geofences

     Without params, it returns a list of Geofences the user has access to

    Args:
        all_ (bool | Unset):
        user_id (int | Unset):
        device_id (int | Unset):
        group_id (int | Unset):
        refresh (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        list[Geofence]
    """

    return sync_detailed(
        client=client,
        all_=all_,
        user_id=user_id,
        device_id=device_id,
        group_id=group_id,
        refresh=refresh,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient | Client,
    all_: bool | Unset = UNSET,
    user_id: int | Unset = UNSET,
    device_id: int | Unset = UNSET,
    group_id: int | Unset = UNSET,
    refresh: bool | Unset = UNSET,
) -> Response[list[Geofence]]:
    """Fetch a list of Geofences

     Without params, it returns a list of Geofences the user has access to

    Args:
        all_ (bool | Unset):
        user_id (int | Unset):
        device_id (int | Unset):
        group_id (int | Unset):
        refresh (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[list[Geofence]]
    """

    kwargs = _get_kwargs(
        all_=all_,
        user_id=user_id,
        device_id=device_id,
        group_id=group_id,
        refresh=refresh,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient | Client,
    all_: bool | Unset = UNSET,
    user_id: int | Unset = UNSET,
    device_id: int | Unset = UNSET,
    group_id: int | Unset = UNSET,
    refresh: bool | Unset = UNSET,
) -> list[Geofence] | None:
    """Fetch a list of Geofences

     Without params, it returns a list of Geofences the user has access to

    Args:
        all_ (bool | Unset):
        user_id (int | Unset):
        device_id (int | Unset):
        group_id (int | Unset):
        refresh (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        list[Geofence]
    """

    return (
        await asyncio_detailed(
            client=client,
            all_=all_,
            user_id=user_id,
            device_id=device_id,
            group_id=group_id,
            refresh=refresh,
        )
    ).parsed
