import unittest
from tubeframes import Search


class TestSearch(unittest.TestCase):

    def test_df_shape(self):
        df_shape = Search("Test", maxres=25).df
        self.assertTrue(df_shape.shape[0] >= 1)
        self.assertEqual(df_shape.shape[1], 13)

    def test_caption(self):
        df_caption = Search("Test", caption=True).df
        list_caption = df_caption["video_caption"].to_list()
        self.assertTrue(len([_ for _ in list_caption if _ is None]) > 0)

    def test_channel(self):
        df_channel = Search("Test", item_type="channel").df
        self.assertTrue(df_channel.shape[0] >= 1)
        self.assertEqual(df_channel.shape[1], 8)

    def test_big_shape(self):
        df_shape = Search("Test", maxres=100).df.shape
        self.assertTrue(df_shape[0] >= 50)
