"""
    OneSignal

    A powerful way to send personalized messages at scale and build effective customer engagement strategies. Learn more at onesignal.com  # noqa: E501

    The version of the OpenAPI document: 5.3.0
    Contact: devrel@onesignal.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from onesignal.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from onesignal.exceptions import ApiAttributeError



class App(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('apns_env',): {
            'None': None,
            'SANDBOX': "sandbox",
            'PRODUCTION': "production",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'players': (int,),  # noqa: E501
            'messageable_players': (int,),  # noqa: E501
            'updated_at': (datetime,),  # noqa: E501
            'created_at': (datetime,),  # noqa: E501
            'android_gcm_sender_id': (str,),  # noqa: E501
            'gcm_key': (str, none_type,),  # noqa: E501
            'chrome_web_origin': (str, none_type,),  # noqa: E501
            'chrome_key': (str, none_type,),  # noqa: E501
            'chrome_web_default_notification_icon': (str, none_type,),  # noqa: E501
            'chrome_web_sub_domain': (str, none_type,),  # noqa: E501
            'apns_env': (str, none_type,),  # noqa: E501
            'apns_p12': (str,),  # noqa: E501
            'apns_p12_password': (str,),  # noqa: E501
            'apns_certificates': (str, none_type,),  # noqa: E501
            'safari_apns_certificates': (str,),  # noqa: E501
            'safari_apns_p12': (str,),  # noqa: E501
            'safari_apns_p12_password': (str,),  # noqa: E501
            'apns_key_id': (str, none_type,),  # noqa: E501
            'apns_team_id': (str, none_type,),  # noqa: E501
            'apns_bundle_id': (str, none_type,),  # noqa: E501
            'apns_p8': (str, none_type,),  # noqa: E501
            'safari_site_origin': (str, none_type,),  # noqa: E501
            'safari_push_id': (str, none_type,),  # noqa: E501
            'safari_icon_16_16': (str,),  # noqa: E501
            'safari_icon_32_32': (str,),  # noqa: E501
            'safari_icon_64_64': (str,),  # noqa: E501
            'safari_icon_128_128': (str,),  # noqa: E501
            'safari_icon_256_256': (str,),  # noqa: E501
            'site_name': (str, none_type,),  # noqa: E501
            'basic_auth_key': (str, none_type,),  # noqa: E501
            'organization_id': (str,),  # noqa: E501
            'additional_data_is_root_payload': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'players': 'players',  # noqa: E501
        'messageable_players': 'messageable_players',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
        'android_gcm_sender_id': 'android_gcm_sender_id',  # noqa: E501
        'gcm_key': 'gcm_key',  # noqa: E501
        'chrome_web_origin': 'chrome_web_origin',  # noqa: E501
        'chrome_key': 'chrome_key',  # noqa: E501
        'chrome_web_default_notification_icon': 'chrome_web_default_notification_icon',  # noqa: E501
        'chrome_web_sub_domain': 'chrome_web_sub_domain',  # noqa: E501
        'apns_env': 'apns_env',  # noqa: E501
        'apns_p12': 'apns_p12',  # noqa: E501
        'apns_p12_password': 'apns_p12_password',  # noqa: E501
        'apns_certificates': 'apns_certificates',  # noqa: E501
        'safari_apns_certificates': 'safari_apns_certificates',  # noqa: E501
        'safari_apns_p12': 'safari_apns_p12',  # noqa: E501
        'safari_apns_p12_password': 'safari_apns_p12_password',  # noqa: E501
        'apns_key_id': 'apns_key_id',  # noqa: E501
        'apns_team_id': 'apns_team_id',  # noqa: E501
        'apns_bundle_id': 'apns_bundle_id',  # noqa: E501
        'apns_p8': 'apns_p8',  # noqa: E501
        'safari_site_origin': 'safari_site_origin',  # noqa: E501
        'safari_push_id': 'safari_push_id',  # noqa: E501
        'safari_icon_16_16': 'safari_icon_16_16',  # noqa: E501
        'safari_icon_32_32': 'safari_icon_32_32',  # noqa: E501
        'safari_icon_64_64': 'safari_icon_64_64',  # noqa: E501
        'safari_icon_128_128': 'safari_icon_128_128',  # noqa: E501
        'safari_icon_256_256': 'safari_icon_256_256',  # noqa: E501
        'site_name': 'site_name',  # noqa: E501
        'basic_auth_key': 'basic_auth_key',  # noqa: E501
        'organization_id': 'organization_id',  # noqa: E501
        'additional_data_is_root_payload': 'additional_data_is_root_payload',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
        'players',  # noqa: E501
        'messageable_players',  # noqa: E501
        'updated_at',  # noqa: E501
        'created_at',  # noqa: E501
        'apns_certificates',  # noqa: E501
        'safari_apns_certificates',  # noqa: E501
        'safari_push_id',  # noqa: E501
        'safari_icon_16_16',  # noqa: E501
        'safari_icon_32_32',  # noqa: E501
        'safari_icon_64_64',  # noqa: E501
        'safari_icon_128_128',  # noqa: E501
        'basic_auth_key',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """App - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): [optional]  # noqa: E501
            name (str): The name of your app, as displayed on your apps list on the dashboard.  This can be renamed.. [optional]  # noqa: E501
            players (int): [optional]  # noqa: E501
            messageable_players (int): [optional]  # noqa: E501
            updated_at (datetime): [optional]  # noqa: E501
            created_at (datetime): [optional]  # noqa: E501
            android_gcm_sender_id (str): Android: Your Google Project number.  Also known as Sender ID.. [optional]  # noqa: E501
            gcm_key (str, none_type): Android: Your Google Push Messaging Auth Key. [optional]  # noqa: E501
            chrome_web_origin (str, none_type): Chrome (All Browsers except Safari) (Recommended): The URL to your website.  This field is required if you wish to enable web push and specify other web push parameters.. [optional]  # noqa: E501
            chrome_key (str, none_type): Not for web push.  Your Google Push Messaging Auth Key if you use Chrome Apps / Extensions.. [optional]  # noqa: E501
            chrome_web_default_notification_icon (str, none_type): Chrome (All Browsers except Safari): Your default notification icon. Should be 256x256 pixels, min 80x80.. [optional]  # noqa: E501
            chrome_web_sub_domain (str, none_type): Chrome (All Browsers except Safari): A subdomain of your choice in order to support Web Push on non-HTTPS websites. This field must be set in order for the chrome_web_gcm_sender_id property to be processed.. [optional]  # noqa: E501
            apns_env (str, none_type): iOS: Either sandbox or production. [optional]  # noqa: E501
            apns_p12 (str): iOS: Your apple push notification p12 certificate file, converted to a string and Base64 encoded.. [optional]  # noqa: E501
            apns_p12_password (str): iOS: Required if using p12 certificate.  Password for the apns_p12 file.. [optional]  # noqa: E501
            apns_certificates (str, none_type): [optional]  # noqa: E501
            safari_apns_certificates (str): [optional]  # noqa: E501
            safari_apns_p12 (str): Safari: Your apple push notification p12 certificate file for Safari Push Notifications, converted to a string and Base64 encoded.. [optional]  # noqa: E501
            safari_apns_p12_password (str): Safari: Password for safari_apns_p12 file. [optional]  # noqa: E501
            apns_key_id (str, none_type): iOS: Required if using p8. Unique identifier for the p8 authentication key.. [optional]  # noqa: E501
            apns_team_id (str, none_type): iOS: Required if using p8. Team ID generated by Apple for your developer account.. [optional]  # noqa: E501
            apns_bundle_id (str, none_type): iOS: Required if using p8. Bundle ID for your app in the Apple ecosystem.. [optional]  # noqa: E501
            apns_p8 (str, none_type): iOS: Required if using p8. Base64 encoded p8 key. [optional]  # noqa: E501
            safari_site_origin (str, none_type): Safari (Recommended): The hostname to your website including http(s)://. [optional]  # noqa: E501
            safari_push_id (str, none_type): [optional]  # noqa: E501
            safari_icon_16_16 (str): [optional]  # noqa: E501
            safari_icon_32_32 (str): [optional]  # noqa: E501
            safari_icon_64_64 (str): [optional]  # noqa: E501
            safari_icon_128_128 (str): [optional]  # noqa: E501
            safari_icon_256_256 (str): Safari: A url for a 256x256 png notification icon. This is the only Safari icon URL you need to provide.. [optional]  # noqa: E501
            site_name (str, none_type): All Browsers (Recommended): The Site Name. Requires both chrome_web_origin and safari_site_origin to be set to add or update it.. [optional]  # noqa: E501
            basic_auth_key (str, none_type): [optional]  # noqa: E501
            organization_id (str): The Id of the Organization you would like to add this app to.. [optional]  # noqa: E501
            additional_data_is_root_payload (bool): iOS: Notification data (additional data) values will be added to the root of the apns payload when sent to the device.  Ignore if you're not using any other plugins, or not using OneSignal SDK methods to read the payload.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """App - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): [optional]  # noqa: E501
            name (str): The name of your app, as displayed on your apps list on the dashboard.  This can be renamed.. [optional]  # noqa: E501
            players (int): [optional]  # noqa: E501
            messageable_players (int): [optional]  # noqa: E501
            updated_at (datetime): [optional]  # noqa: E501
            created_at (datetime): [optional]  # noqa: E501
            android_gcm_sender_id (str): Android: Your Google Project number.  Also known as Sender ID.. [optional]  # noqa: E501
            gcm_key (str, none_type): Android: Your Google Push Messaging Auth Key. [optional]  # noqa: E501
            chrome_web_origin (str, none_type): Chrome (All Browsers except Safari) (Recommended): The URL to your website.  This field is required if you wish to enable web push and specify other web push parameters.. [optional]  # noqa: E501
            chrome_key (str, none_type): Not for web push.  Your Google Push Messaging Auth Key if you use Chrome Apps / Extensions.. [optional]  # noqa: E501
            chrome_web_default_notification_icon (str, none_type): Chrome (All Browsers except Safari): Your default notification icon. Should be 256x256 pixels, min 80x80.. [optional]  # noqa: E501
            chrome_web_sub_domain (str, none_type): Chrome (All Browsers except Safari): A subdomain of your choice in order to support Web Push on non-HTTPS websites. This field must be set in order for the chrome_web_gcm_sender_id property to be processed.. [optional]  # noqa: E501
            apns_env (str, none_type): iOS: Either sandbox or production. [optional]  # noqa: E501
            apns_p12 (str): iOS: Your apple push notification p12 certificate file, converted to a string and Base64 encoded.. [optional]  # noqa: E501
            apns_p12_password (str): iOS: Required if using p12 certificate.  Password for the apns_p12 file.. [optional]  # noqa: E501
            apns_certificates (str, none_type): [optional]  # noqa: E501
            safari_apns_certificates (str): [optional]  # noqa: E501
            safari_apns_p12 (str): Safari: Your apple push notification p12 certificate file for Safari Push Notifications, converted to a string and Base64 encoded.. [optional]  # noqa: E501
            safari_apns_p12_password (str): Safari: Password for safari_apns_p12 file. [optional]  # noqa: E501
            apns_key_id (str, none_type): iOS: Required if using p8. Unique identifier for the p8 authentication key.. [optional]  # noqa: E501
            apns_team_id (str, none_type): iOS: Required if using p8. Team ID generated by Apple for your developer account.. [optional]  # noqa: E501
            apns_bundle_id (str, none_type): iOS: Required if using p8. Bundle ID for your app in the Apple ecosystem.. [optional]  # noqa: E501
            apns_p8 (str, none_type): iOS: Required if using p8. Base64 encoded p8 key. [optional]  # noqa: E501
            safari_site_origin (str, none_type): Safari (Recommended): The hostname to your website including http(s)://. [optional]  # noqa: E501
            safari_push_id (str, none_type): [optional]  # noqa: E501
            safari_icon_16_16 (str): [optional]  # noqa: E501
            safari_icon_32_32 (str): [optional]  # noqa: E501
            safari_icon_64_64 (str): [optional]  # noqa: E501
            safari_icon_128_128 (str): [optional]  # noqa: E501
            safari_icon_256_256 (str): Safari: A url for a 256x256 png notification icon. This is the only Safari icon URL you need to provide.. [optional]  # noqa: E501
            site_name (str, none_type): All Browsers (Recommended): The Site Name. Requires both chrome_web_origin and safari_site_origin to be set to add or update it.. [optional]  # noqa: E501
            basic_auth_key (str, none_type): [optional]  # noqa: E501
            organization_id (str): The Id of the Organization you would like to add this app to.. [optional]  # noqa: E501
            additional_data_is_root_payload (bool): iOS: Notification data (additional data) values will be added to the root of the apns payload when sent to the device.  Ignore if you're not using any other plugins, or not using OneSignal SDK methods to read the payload.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
