#
#  Copyright MindBridge Analytics Inc. all rights reserved.
#
#  This material is confidential and may not be copied, distributed,
#  reversed engineered, decompiled or otherwise disseminated without
#  the prior written consent of MindBridge Analytics Inc.
#

from __future__ import annotations
from datetime import date
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from pydantic import AwareDatetime, BaseModel, ConfigDict, Field, RootModel
from typing_extensions import Annotated


class Type(str, Enum):
    """
    The type of account group error.
    """

    ERROR_INVALID_INDUSTRY_TAG = "ERROR_INVALID_INDUSTRY_TAG"
    ERROR_LOWEST_LEVEL_WITH_NO_MAC = "ERROR_LOWEST_LEVEL_WITH_NO_MAC"
    ERROR_LOWEST_LEVEL_WITHOUT_LEVEL_4_MAC = "ERROR_LOWEST_LEVEL_WITHOUT_LEVEL_4_MAC"
    ERROR_INCONSISTENT_SHEET_HIERARCHY = "ERROR_INCONSISTENT_SHEET_HIERARCHY"


class ApiAccountGroupErrorRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    arguments: Annotated[
        Optional[List[str]],
        Field(
            description="A list of values relevant to the type of account group error."
        ),
    ] = None
    type: Annotated[
        Optional[Type], Field(description="The type of account group error.")
    ] = None


class ApiAccountGroupRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    account_grouping_id: Annotated[
        Optional[str],
        Field(
            alias="accountGroupingId",
            description="The unique identifier for the account grouping that the account group belongs to.",
        ),
    ] = None
    account_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="accountTags",
            description="A list of account tags assigned to this account group.",
        ),
    ] = None
    code: Annotated[
        Optional[str], Field(description="The account code for this account group.")
    ] = None
    description: Annotated[
        Optional[Dict[str, str]],
        Field(description="A description of the account code for this account group."),
    ] = None
    errors: Annotated[
        Optional[List[ApiAccountGroupErrorRead]],
        Field(description="A list of errors associated with this account group."),
    ] = None
    hierarchy: Annotated[
        Optional[List[str]],
        Field(description="A list of the parent codes for this account group."),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    industry_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="industryTags",
            description="A list of industry tags assigned to this account group.",
        ),
    ] = None
    lowest_level: Annotated[Optional[bool], Field(alias="lowestLevel")] = None
    mac_code: Annotated[
        Optional[str],
        Field(
            alias="macCode", description="The MAC code mapped to this account group."
        ),
    ] = None
    order_index: Annotated[
        Optional[int],
        Field(
            alias="orderIndex",
            description="The order in which this account group is displayed, relative to other account groups with the same parent.",
        ),
    ] = None
    parent_code: Annotated[
        Optional[str],
        Field(
            alias="parentCode", description="The parent code for this account group."
        ),
    ] = None
    published_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="publishedDate",
            description="The date this account group was published. If not set, this account group is not published.\n\nPublished account groups cannot be updated.",
        ),
    ] = None


class ApiAccountGroupUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    account_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="accountTags",
            description="A list of account tags assigned to this account group.",
        ),
    ] = None
    industry_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="industryTags",
            description="A list of industry tags assigned to this account group.",
        ),
    ] = None
    mac_code: Annotated[
        Optional[str],
        Field(
            alias="macCode", description="The MAC code mapped to this account group."
        ),
    ] = None


class PublishStatus(str, Enum):
    """
    The current status of the account grouping.
    """

    DRAFT = "DRAFT"
    UNPUBLISHED_CHANGES = "UNPUBLISHED_CHANGES"
    PUBLISHED = "PUBLISHED"


class ApiAccountGroupingUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    archived: Annotated[
        Optional[bool],
        Field(description="When `true`, the account grouping is archived."),
    ] = None
    name: Annotated[
        Optional[Dict[str, str]], Field(description="The name of the account grouping.")
    ] = None
    publish_status: Annotated[
        Optional[PublishStatus],
        Field(
            alias="publishStatus",
            description="The current status of the account grouping.",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(description="The data integrity version, to ensure data consistency."),
    ] = None


class Frequency(str, Enum):
    """
    The frequency with which your client's financial data is reported.
    """

    ANNUAL = "ANNUAL"
    SEMI_ANNUAL = "SEMI_ANNUAL"
    QUARTERLY = "QUARTERLY"
    MONTHLY = "MONTHLY"
    THIRTEEN_PERIODS = "THIRTEEN_PERIODS"


class ApiAccountingPeriodCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    fiscal_start_day: Annotated[
        Optional[int],
        Field(
            alias="fiscalStartDay",
            description="The date of the month that the fiscal period begins.",
        ),
    ] = None
    fiscal_start_month: Annotated[
        Optional[int],
        Field(
            alias="fiscalStartMonth",
            description="The month that the fiscal period begins.",
        ),
    ] = None
    frequency: Annotated[
        Optional[Frequency],
        Field(
            description="The frequency with which your client's financial data is reported."
        ),
    ] = None


class ApiAccountingPeriodRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    fiscal_start_day: Annotated[
        Optional[int],
        Field(
            alias="fiscalStartDay",
            description="The date of the month that the fiscal period begins.",
        ),
    ] = None
    fiscal_start_month: Annotated[
        Optional[int],
        Field(
            alias="fiscalStartMonth",
            description="The month that the fiscal period begins.",
        ),
    ] = None
    frequency: Annotated[
        Optional[Frequency],
        Field(
            description="The frequency with which your client's financial data is reported."
        ),
    ] = None


class ApiAccountingPeriodUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    fiscal_start_day: Annotated[
        Optional[int],
        Field(
            alias="fiscalStartDay",
            description="The date of the month that the fiscal period begins.",
        ),
    ] = None
    fiscal_start_month: Annotated[
        Optional[int],
        Field(
            alias="fiscalStartMonth",
            description="The month that the fiscal period begins.",
        ),
    ] = None
    frequency: Annotated[
        Optional[Frequency],
        Field(
            description="The frequency with which your client's financial data is reported."
        ),
    ] = None


class ApiAmbiguousColumnRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    ambiguous_formats: Annotated[
        Optional[List[str]],
        Field(
            alias="ambiguousFormats",
            description="A list of ambiguous formats detected.",
        ),
    ] = None
    position: Annotated[
        Optional[int],
        Field(description="The position of the column with the resolution."),
    ] = None
    selected_format: Annotated[
        Optional[str],
        Field(
            alias="selectedFormat",
            description="The data format to be used in case of ambiguity.",
        ),
    ] = None


class ApiAmbiguousColumnUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    position: Annotated[
        Optional[int],
        Field(description="The position of the column with the resolution."),
    ] = None
    selected_format: Annotated[
        Optional[str],
        Field(
            alias="selectedFormat",
            description="The data format to be used in case of ambiguity.",
        ),
    ] = None


class ApiAnalysisImportantColumnRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_name: Annotated[
        Optional[str],
        Field(
            alias="columnName",
            description="The name of the column as it appears in the imported file.",
        ),
    ] = None
    field: Annotated[
        Optional[str], Field(description="The name of the additional data column.")
    ] = None


class ApiAnalysisPeriodGapRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_period_id: Annotated[
        Optional[str],
        Field(alias="analysisPeriodId", description="Identifies the analysis period."),
    ] = None
    days: Annotated[
        Optional[int],
        Field(description="The number of days between two analysis periods."),
    ] = None
    previous_analysis_period_id: Annotated[
        Optional[str],
        Field(
            alias="previousAnalysisPeriodId",
            description="Identifies the previous analysis period relevant to the current analysis period.",
        ),
    ] = None


class ApiAnalysisPeriodCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    end_date: Annotated[
        Optional[date],
        Field(
            alias="endDate", description="The last day of the period under analysis."
        ),
    ] = None
    interim_as_at_date: Annotated[
        Optional[date],
        Field(
            alias="interimAsAtDate",
            description="The last day of the interim period under analysis.",
        ),
    ] = None
    start_date: Annotated[
        Optional[date],
        Field(
            alias="startDate", description="The first day of the period under analysis."
        ),
    ] = None


class ApiAnalysisPeriodRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    end_date: Annotated[
        Optional[date],
        Field(
            alias="endDate", description="The last day of the period under analysis."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    interim_as_at_date: Annotated[
        Optional[date],
        Field(
            alias="interimAsAtDate",
            description="The last day of the interim period under analysis.",
        ),
    ] = None
    start_date: Annotated[
        Optional[date],
        Field(
            alias="startDate", description="The first day of the period under analysis."
        ),
    ] = None


class ApiAnalysisPeriodUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    end_date: Annotated[
        Optional[date],
        Field(
            alias="endDate", description="The last day of the period under analysis."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    interim_as_at_date: Annotated[
        Optional[date],
        Field(
            alias="interimAsAtDate",
            description="The last day of the interim period under analysis.",
        ),
    ] = None
    start_date: Annotated[
        Optional[date],
        Field(
            alias="startDate", description="The first day of the period under analysis."
        ),
    ] = None


class Status(str, Enum):
    """
    The current state of the analysis source.
    """

    IMPORTING = "IMPORTING"
    UPLOADING = "UPLOADING"
    IN_PROGRESS = "IN_PROGRESS"
    COMPLETED = "COMPLETED"
    CANCELLED = "CANCELLED"
    FAILED = "FAILED"


class ApiAnalysisSourceStatusRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_source_type_id: Annotated[
        Optional[str],
        Field(
            alias="analysisSourceTypeId",
            description="Identifies the analysis source type.",
        ),
    ] = None
    period_id: Annotated[
        Optional[str],
        Field(
            alias="periodId",
            description="Identifies the analysis period within the analysis.",
        ),
    ] = None
    source_id: Annotated[
        Optional[str],
        Field(alias="sourceId", description="Identifies the analysis source object."),
    ] = None
    status: Annotated[
        Optional[Status], Field(description="The current state of the analysis source.")
    ] = None


class Feature(str, Enum):
    FORMAT_DETECTION = "FORMAT_DETECTION"
    DATA_VALIDATION = "DATA_VALIDATION"
    COLUMN_MAPPING = "COLUMN_MAPPING"
    EFFECTIVE_DATE_METRICS = "EFFECTIVE_DATE_METRICS"
    TRANSACTION_ID_SELECTION = "TRANSACTION_ID_SELECTION"
    PARSE = "PARSE"
    CONFIRM_SETTINGS = "CONFIRM_SETTINGS"
    REVIEW_FUNDS = "REVIEW_FUNDS"


class TargetWorkflowState(str, Enum):
    """
    The state that the current workflow will advance to.
    """

    COMPLETED = "COMPLETED"
    CANCELLED = "CANCELLED"
    FAILED = "FAILED"
    STARTED = "STARTED"
    DETECTING_FORMAT = "DETECTING_FORMAT"
    ANALYZING_COLUMNS = "ANALYZING_COLUMNS"
    CHECKING_INTEGRITY = "CHECKING_INTEGRITY"
    PARSING = "PARSING"
    ANALYZING_EFFECTIVE_DATE_METRICS = "ANALYZING_EFFECTIVE_DATE_METRICS"
    FORMAT_DETECTION_COMPLETED = "FORMAT_DETECTION_COMPLETED"
    COLUMN_MAPPINGS_CONFIRMED = "COLUMN_MAPPINGS_CONFIRMED"
    SETTINGS_CONFIRMED = "SETTINGS_CONFIRMED"
    ANALYSIS_PERIOD_SELECTED = "ANALYSIS_PERIOD_SELECTED"
    FUNDS_REVIEWED = "FUNDS_REVIEWED"
    RUNNING = "RUNNING"
    UNPACK_COMPLETE = "UNPACK_COMPLETE"
    UPLOADED = "UPLOADED"
    FORMAT_DETECTED = "FORMAT_DETECTED"
    COLUMNS_ANALYZED = "COLUMNS_ANALYZED"
    INTEGRITY_CHECKED = "INTEGRITY_CHECKED"
    PARSED = "PARSED"
    AUTHENTICATED = "AUTHENTICATED"
    CONFIGURED = "CONFIGURED"
    EFFECTIVE_DATE_METRICS_ANALYZED = "EFFECTIVE_DATE_METRICS_ANALYZED"
    DATA_VALIDATION_CONFIRMED = "DATA_VALIDATION_CONFIRMED"


class DetectedFormat(str, Enum):
    """
    The data format that MindBridge detected.
    """

    QUICKBOOKS_JOURNAL = "QUICKBOOKS_JOURNAL"
    QUICKBOOKS_JOURNAL_2024 = "QUICKBOOKS_JOURNAL_2024"
    QUICKBOOKS_TRANSACTION_DETAIL_BY_ACCOUNT = (
        "QUICKBOOKS_TRANSACTION_DETAIL_BY_ACCOUNT"
    )
    SAGE50_LEDGER = "SAGE50_LEDGER"
    SAGE50_TRANSACTIONS = "SAGE50_TRANSACTIONS"
    CCH_ACCOUNT_LIST = "CCH_ACCOUNT_LIST"


class WorkflowState(str, Enum):
    """
    The current state of the workflow.
    """

    COMPLETED = "COMPLETED"
    CANCELLED = "CANCELLED"
    FAILED = "FAILED"
    STARTED = "STARTED"
    DETECTING_FORMAT = "DETECTING_FORMAT"
    ANALYZING_COLUMNS = "ANALYZING_COLUMNS"
    CHECKING_INTEGRITY = "CHECKING_INTEGRITY"
    PARSING = "PARSING"
    ANALYZING_EFFECTIVE_DATE_METRICS = "ANALYZING_EFFECTIVE_DATE_METRICS"
    FORMAT_DETECTION_COMPLETED = "FORMAT_DETECTION_COMPLETED"
    COLUMN_MAPPINGS_CONFIRMED = "COLUMN_MAPPINGS_CONFIRMED"
    SETTINGS_CONFIRMED = "SETTINGS_CONFIRMED"
    ANALYSIS_PERIOD_SELECTED = "ANALYSIS_PERIOD_SELECTED"
    FUNDS_REVIEWED = "FUNDS_REVIEWED"
    RUNNING = "RUNNING"
    UNPACK_COMPLETE = "UNPACK_COMPLETE"
    UPLOADED = "UPLOADED"
    FORMAT_DETECTED = "FORMAT_DETECTED"
    COLUMNS_ANALYZED = "COLUMNS_ANALYZED"
    INTEGRITY_CHECKED = "INTEGRITY_CHECKED"
    PARSED = "PARSED"
    AUTHENTICATED = "AUTHENTICATED"
    CONFIGURED = "CONFIGURED"
    EFFECTIVE_DATE_METRICS_ANALYZED = "EFFECTIVE_DATE_METRICS_ANALYZED"
    DATA_VALIDATION_CONFIRMED = "DATA_VALIDATION_CONFIRMED"


class PreflightError(str, Enum):
    IN_PROGRESS = "IN_PROGRESS"
    NOT_READY = "NOT_READY"
    ARCHIVED = "ARCHIVED"
    REQUIRED_FILES_MISSING = "REQUIRED_FILES_MISSING"
    SOURCES_NOT_READY = "SOURCES_NOT_READY"
    SOURCE_ERROR = "SOURCE_ERROR"
    UNVERIFIED_ACCOUNT_MAPPINGS = "UNVERIFIED_ACCOUNT_MAPPINGS"
    ANALYSIS_PERIOD_OVERLAP = "ANALYSIS_PERIOD_OVERLAP"
    SOURCE_WARNINGS_PRESENT = "SOURCE_WARNINGS_PRESENT"


class Status1(str, Enum):
    """
    The current state of the analysis.
    """

    NOT_STARTED = "NOT_STARTED"
    IMPORTING_FILE = "IMPORTING_FILE"
    PREPARING_DATA = "PREPARING_DATA"
    PROCESSING = "PROCESSING"
    CONSOLIDATING_RESULTS = "CONSOLIDATING_RESULTS"
    COMPLETED = "COMPLETED"
    FAILED = "FAILED"


class ApiAnalysisStatusRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_id: Annotated[
        Optional[str],
        Field(alias="analysisId", description="Identifies the associated analysis."),
    ] = None
    analysis_type_id: Annotated[
        Optional[str],
        Field(alias="analysisTypeId", description="Identifies the type of analysis."),
    ] = None
    available_features: Annotated[
        Optional[Dict[str, bool]],
        Field(
            alias="availableFeatures",
            description="Details about the various analysis capabilities available in MindBridge. [Learn more](https://support.mindbridge.ai/hc/en-us/articles/360056395234)",
        ),
    ] = None
    inferred_account_mapping_count: Annotated[
        Optional[int],
        Field(
            alias="inferredAccountMappingCount",
            description="The number of inferred account mapping; this can be considered a warning on partial matches.",
        ),
    ] = None
    mapped_account_mapping_count: Annotated[
        Optional[int],
        Field(
            alias="mappedAccountMappingCount",
            description="The number of mapped accounts.",
        ),
    ] = None
    preflight_errors: Annotated[
        Optional[List[PreflightError]],
        Field(
            alias="preflightErrors",
            description="The errors that occurred before the analysis was run.",
        ),
    ] = None
    re_run_ready: Annotated[
        Optional[bool],
        Field(
            alias="reRunReady",
            description="Indicates whether or not the analysis is ready to be run again.",
        ),
    ] = None
    ready: Annotated[
        Optional[bool],
        Field(description="Indicates whether or not the analysis is ready to be run."),
    ] = None
    source_statuses: Annotated[
        Optional[List[ApiAnalysisSourceStatusRead]],
        Field(
            alias="sourceStatuses",
            description="Details about the state of each analysis source.",
        ),
    ] = None
    status: Annotated[
        Optional[Status1], Field(description="The current state of the analysis.")
    ] = None
    unmapped_account_mapping_count: Annotated[
        Optional[int],
        Field(
            alias="unmappedAccountMappingCount",
            description="The number of unmapped accounts.",
        ),
    ] = None


class ApiAnalysisCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_periods: Annotated[
        Optional[List[ApiAnalysisPeriodCreateOnly]],
        Field(
            alias="analysisPeriods",
            description="Details about the specific analysis periods under audit.",
        ),
    ] = None
    analysis_type_id: Annotated[
        Optional[str],
        Field(alias="analysisTypeId", description="Identifies the type of analysis."),
    ] = None
    currency_code: Annotated[
        Optional[str],
        Field(
            alias="currencyCode",
            description="The currency to be displayed across the analysis results.",
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    interim: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the analysis is using an interim time frame."
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the analysis.", max_length=80, min_length=0),
    ] = None
    periodic: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the analysis is using a periodic time frame."
        ),
    ] = None


class ApiAnalysisUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_periods: Annotated[
        Optional[List[ApiAnalysisPeriodUpdate]],
        Field(
            alias="analysisPeriods",
            description="Details about the specific analysis periods under audit.",
        ),
    ] = None
    archived: Annotated[
        Optional[bool],
        Field(description="Indicates whether or not the analysis has been archived."),
    ] = None
    currency_code: Annotated[
        Optional[str],
        Field(
            alias="currencyCode",
            description="The currency to be displayed across the analysis results.",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the analysis.", max_length=80, min_length=0),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class Permission(str, Enum):
    API_ORGANIZATIONS_READ = "api.organizations.read"
    API_ORGANIZATIONS_WRITE = "api.organizations.write"
    API_ORGANIZATIONS_DELETE = "api.organizations.delete"
    API_ENGAGEMENTS_READ = "api.engagements.read"
    API_ENGAGEMENTS_WRITE = "api.engagements.write"
    API_ENGAGEMENTS_DELETE = "api.engagements.delete"
    API_ANALYSES_READ = "api.analyses.read"
    API_ANALYSES_WRITE = "api.analyses.write"
    API_ANALYSES_DELETE = "api.analyses.delete"
    API_ANALYSES_RUN = "api.analyses.run"
    API_ANALYSIS_SOURCES_READ = "api.analysis-sources.read"
    API_ANALYSIS_SOURCES_WRITE = "api.analysis-sources.write"
    API_ANALYSIS_SOURCES_DELETE = "api.analysis-sources.delete"
    API_FILE_MANAGER_READ = "api.file-manager.read"
    API_FILE_MANAGER_WRITE = "api.file-manager.write"
    API_FILE_MANAGER_DELETE = "api.file-manager.delete"
    API_LIBRARIES_READ = "api.libraries.read"
    API_LIBRARIES_WRITE = "api.libraries.write"
    API_LIBRARIES_DELETE = "api.libraries.delete"
    API_ACCOUNT_GROUPINGS_READ = "api.account-groupings.read"
    API_ACCOUNT_GROUPINGS_WRITE = "api.account-groupings.write"
    API_ACCOUNT_GROUPINGS_DELETE = "api.account-groupings.delete"
    API_ENGAGEMENT_ACCOUNT_GROUPINGS_READ = "api.engagement-account-groupings.read"
    API_ENGAGEMENT_ACCOUNT_GROUPINGS_WRITE = "api.engagement-account-groupings.write"
    API_ENGAGEMENT_ACCOUNT_GROUPINGS_DELETE = "api.engagement-account-groupings.delete"
    API_USERS_READ = "api.users.read"
    API_USERS_WRITE = "api.users.write"
    API_USERS_DELETE = "api.users.delete"
    API_DATA_TABLES_READ = "api.data-tables.read"
    API_API_TOKENS_READ = "api.api-tokens.read"
    API_API_TOKENS_WRITE = "api.api-tokens.write"
    API_API_TOKENS_DELETE = "api.api-tokens.delete"
    API_TASKS_READ = "api.tasks.read"
    API_TASKS_WRITE = "api.tasks.write"
    API_TASKS_DELETE = "api.tasks.delete"
    API_ADMIN_REPORTS_RUN = "api.admin-reports.run"
    API_ANALYSIS_TYPES_READ = "api.analysis-types.read"
    API_ANALYSIS_SOURCE_TYPES_READ = "api.analysis-source-types.read"
    SCIM_USER_READ = "scim.user.read"
    SCIM_USER_WRITE = "scim.user.write"
    SCIM_USER_DELETE = "scim.user.delete"
    SCIM_USER_SCHEMA = "scim.user.schema"


class ApiApiTokenCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    allowed_addresses: Annotated[
        Optional[List[str]],
        Field(
            alias="allowedAddresses",
            description="Indicates the set of addresses that are allowed to use this token. If empty, any address may use it.",
        ),
    ] = None
    expiry: Annotated[
        Optional[AwareDatetime],
        Field(description="The day on which the API token expires."),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The token record’s name. This will also be used as the API Token User’s name."
        ),
    ] = None
    permissions: Annotated[
        Optional[List[Permission]],
        Field(
            description="The set of permissions that inform which endpoints this token is authorized to access."
        ),
    ] = None


class ApiApiTokenUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str],
        Field(
            description="The token record’s name. This will also be used as the API Token User’s name."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class EntityType(str, Enum):
    """
    Identifies the entity type used in the job.
    """

    ORGANIZATION = "ORGANIZATION"
    ENGAGEMENT = "ENGAGEMENT"
    ANALYSIS = "ANALYSIS"
    ANALYSIS_SOURCE = "ANALYSIS_SOURCE"
    FILE_RESULT = "FILE_RESULT"
    GDPDU_UNPACK_JOB = "GDPDU_UNPACK_JOB"
    ACCOUNT_GROUPING = "ACCOUNT_GROUPING"
    ENGAGEMENT_ACCOUNT_GROUPING = "ENGAGEMENT_ACCOUNT_GROUPING"


class Status2(str, Enum):
    """
    Indicates the current state of the job.
    """

    IN_PROGRESS = "IN_PROGRESS"
    COMPLETE = "COMPLETE"
    ERROR = "ERROR"


class Type1(str, Enum):
    """
    Indicates the type of job being run.
    """

    ANALYSIS_RUN = "ANALYSIS_RUN"
    ANALYSIS_SOURCE_INGESTION = "ANALYSIS_SOURCE_INGESTION"
    ADMIN_REPORT = "ADMIN_REPORT"
    DATA_TABLE_EXPORT = "DATA_TABLE_EXPORT"
    ANALYSIS_ROLL_FORWARD = "ANALYSIS_ROLL_FORWARD"
    GDPDU_UNPACK_JOB = "GDPDU_UNPACK_JOB"
    ACCOUNT_GROUPING_EXPORT = "ACCOUNT_GROUPING_EXPORT"


class State(str, Enum):
    PASS_ = "PASS"
    WARN = "WARN"
    FAIL = "FAIL"


class ApiChunkedFilePart(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    offset: Annotated[
        Optional[int],
        Field(
            description="Indicates the start position of the file part in the chunked file.",
            ge=0,
        ),
    ] = None
    size: Annotated[
        Optional[int], Field(description="The size of the file part.", ge=0)
    ] = None


class ApiChunkedFilePartRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    offset: Annotated[
        Optional[int],
        Field(
            description="Indicates the start position of the file part in the chunked file.",
            ge=0,
        ),
    ] = None
    size: Annotated[
        Optional[int], Field(description="The size of the file part.", ge=0)
    ] = None


class ApiChunkedFileCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str], Field(description="The name of the chunked file.")
    ] = None
    size: Annotated[
        Optional[int], Field(description="The size of the chunked file.", ge=0)
    ] = None


class ApiColumnDateTimeFormatRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    custom_format_pattern: Annotated[
        Optional[str], Field(alias="customFormatPattern")
    ] = None
    sample_converted_values: Annotated[
        Optional[List[AwareDatetime]], Field(alias="sampleConvertedValues")
    ] = None
    sample_raw_values: Annotated[
        Optional[List[str]], Field(alias="sampleRawValues")
    ] = None
    selected: Optional[bool] = None


class Type3(str, Enum):
    """
    The type of data this column accepts.
    """

    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    UNKNOWN = "UNKNOWN"
    FLOAT64 = "FLOAT64"


class ApiColumnDefinitionRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    allow_blanks: Annotated[
        Optional[bool],
        Field(
            alias="allowBlanks",
            description="Indicates whether or not this column allows the source column to contain blank values.",
        ),
    ] = None
    alternative_mappings: Annotated[
        Optional[List[str]],
        Field(
            alias="alternativeMappings",
            description="A list of alternative mappings, identified by their `mindbridgeFieldName`. If all of the alternatives are mapped, then this mapping’s `required` constraint is considered satisfied. \n\n**Note**: This column may not be mapped if any alternative is also mapped.",
        ),
    ] = None
    mindbridge_field_name: Annotated[
        Optional[str],
        Field(
            alias="mindbridgeFieldName",
            description="The internal name of the analysis source type’s column.",
        ),
    ] = None
    mindbridge_field_name_for_non_mac_groupings: Annotated[
        Optional[str],
        Field(
            alias="mindbridgeFieldNameForNonMacGroupings",
            description="The alternative column name when a non-MAC based account grouping is used.",
        ),
    ] = None
    required: Annotated[
        Optional[bool],
        Field(description="Indicates whether or not this column is required."),
    ] = None
    required_for_non_mac_groupings: Annotated[
        Optional[bool],
        Field(
            alias="requiredForNonMacGroupings",
            description="Indicates whether or not this column is required when using a non-MAC based account grouping.",
        ),
    ] = None
    type: Annotated[
        Optional[Type3], Field(description="The type of data this column accepts.")
    ] = None


class MappingType(str, Enum):
    """
    The method used to map the column.
    """

    AUTO = "AUTO"
    NOT_MAPPED = "NOT_MAPPED"
    MANUAL = "MANUAL"


class ApiColumnMappingRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    additional_column_name: Annotated[
        Optional[str],
        Field(
            alias="additionalColumnName",
            description="Additional columns of data that were added to the analysis.",
        ),
    ] = None
    field: Annotated[Optional[str], Field(description="The column name.")] = None
    mapping_type: Annotated[
        Optional[MappingType],
        Field(alias="mappingType", description="The method used to map the column."),
    ] = None
    mindbridge_field: Annotated[
        Optional[str],
        Field(
            alias="mindbridgeField",
            description="The MindBridge field that the data column was mapped to.",
        ),
    ] = None
    position: Annotated[
        Optional[int], Field(description="The position of the column mapping.")
    ] = None


class ApiColumnMappingUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    additional_column_name: Annotated[
        Optional[str],
        Field(
            alias="additionalColumnName",
            description="Additional columns of data that were added to the analysis.",
        ),
    ] = None
    mindbridge_field: Annotated[
        Optional[str],
        Field(
            alias="mindbridgeField",
            description="The MindBridge field that the data column was mapped to.",
        ),
    ] = None
    position: Annotated[
        Optional[int], Field(description="The position of the column mapping.")
    ] = None


class ApiCsvConfiguration(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    delimiter: Annotated[
        Optional[str], Field(description="The character used to separate entries.")
    ] = None
    quote: Annotated[
        Optional[str], Field(description="The character used to encapsulate an entry.")
    ] = None
    quote_escape: Annotated[
        Optional[str],
        Field(
            alias="quoteEscape",
            description="The character used to escape the quote character.",
        ),
    ] = None
    quote_escape_escape: Annotated[
        Optional[str],
        Field(
            alias="quoteEscapeEscape",
            description="The character used to escape the quote escape character.",
        ),
    ] = None


class ApiCurrencyFormatRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    ambiguous_delimiters: Annotated[
        Optional[List[str]], Field(alias="ambiguousDelimiters")
    ] = None
    decimal_character: Annotated[Optional[str], Field(alias="decimalCharacter")] = None
    example: Optional[str] = None
    non_decimal_delimiters: Annotated[
        Optional[List[str]], Field(alias="nonDecimalDelimiters")
    ] = None


class ApiDataPreviewRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column: Optional[int] = None
    data: Optional[str] = None
    row: Optional[int] = None


class Type4(str, Enum):
    """
    The type of data found in the column.
    """

    STRING = "STRING"
    DATE = "DATE"
    DATE_TIME = "DATE_TIME"
    BOOLEAN = "BOOLEAN"
    INT16 = "INT16"
    INT32 = "INT32"
    INT64 = "INT64"
    FLOAT32 = "FLOAT32"
    FLOAT64 = "FLOAT64"
    MONEY_100 = "MONEY_100"
    PERCENTAGE_FIXED_POINT = "PERCENTAGE_FIXED_POINT"
    ARRAY_STRINGS = "ARRAY_STRINGS"
    KEYWORD_SEARCH = "KEYWORD_SEARCH"
    OBJECTID = "OBJECTID"
    BOOLEAN_FLAGS = "BOOLEAN_FLAGS"
    MAP_SCALARS = "MAP_SCALARS"
    LEGACY_ACCOUNT_TAG_EFFECTS = "LEGACY_ACCOUNT_TAG_EFFECTS"


class ApiDataTableColumnRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    case_insensitive_prefix_search: Annotated[
        Optional[bool],
        Field(
            alias="caseInsensitivePrefixSearch",
            description="Indicates whether or not a case insensitive search can be performed on a prefix.",
        ),
    ] = None
    case_insensitive_substring_search: Annotated[
        Optional[bool],
        Field(
            alias="caseInsensitiveSubstringSearch",
            description="Indicates whether or not a case insensitive search can be performed on a substring.",
        ),
    ] = None
    contains_search: Annotated[
        Optional[bool],
        Field(
            alias="containsSearch",
            description="Indicates whether or not a value-based search can be performed.",
        ),
    ] = None
    equality_search: Annotated[
        Optional[bool],
        Field(
            alias="equalitySearch",
            description="Indicates whether or not a search can be performed based on two equal operands.",
        ),
    ] = None
    field: Annotated[Optional[str], Field(description="The column name.")] = None
    filter_only: Annotated[
        Optional[bool],
        Field(
            alias="filterOnly",
            description="Indicates whether a field can only be used as part of a filter.",
        ),
    ] = None
    keyword_search: Annotated[
        Optional[bool],
        Field(
            alias="keywordSearch",
            description="Indicates whether or not a keyword search can be performed.",
        ),
    ] = None
    nullable: Annotated[
        Optional[bool],
        Field(description="Indicates whether or not NULL values are allowed."),
    ] = None
    original_name: Annotated[
        Optional[str],
        Field(
            alias="originalName",
            description="The original field name entered by the user (from the original input file, risk score name, etc.)",
        ),
    ] = None
    range_search: Annotated[
        Optional[bool],
        Field(
            alias="rangeSearch",
            description="Indicates whether or not a search can be performed on a value-based comparison.",
        ),
    ] = None
    sortable: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the data table can be sorted by this column."
        ),
    ] = None
    type: Annotated[
        Optional[Type4], Field(description="The type of data found in the column.")
    ] = None


class ApiDataTablePage(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[Dict[str, Dict[str, Any]]]] = None


class Direction(str, Enum):
    """
    How the column will be sorted.
    """

    ASC = "ASC"
    DESC = "DESC"


class ApiDataTableQuerySortOrder(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    direction: Annotated[
        Optional[Direction], Field(description="How the column will be sorted.")
    ] = None
    field: Annotated[Optional[str], Field(description="The data table column.")] = None


class ApiDataTableQuerySortOrderRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    direction: Annotated[
        Optional[Direction], Field(description="How the column will be sorted.")
    ] = None
    field: Annotated[Optional[str], Field(description="The data table column.")] = None


class ApiDataTableRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_id: Annotated[
        Optional[str],
        Field(alias="analysisId", description="Identifies the associated analysis."),
    ] = None
    columns: Annotated[
        Optional[List[ApiDataTableColumnRead]],
        Field(description="Details about the data table columns."),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    logical_name: Annotated[
        Optional[str],
        Field(alias="logicalName", description="The name of the data table."),
    ] = None
    type: Annotated[Optional[str], Field(description="The type of data table.")] = None


class DetectedType(str, Enum):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    UNKNOWN = "UNKNOWN"
    FLOAT64 = "FLOAT64"


class DominantType(str, Enum):
    TEXT = "TEXT"
    NUMBER = "NUMBER"
    DATE = "DATE"
    UNKNOWN = "UNKNOWN"
    FLOAT64 = "FLOAT64"


class ApiDensityMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    blanks: Optional[int] = None
    count: Optional[int] = None
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    density: Optional[float] = None
    state: Optional[State] = None


class ApiDistinctValueMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    count: Optional[int] = None
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    state: Optional[State] = None


class PeriodType(str, Enum):
    """
    Indicates the time period by which the histogram has been broken down.
    """

    DAY = "DAY"
    WEEK = "WEEK"
    MONTH = "MONTH"


class ApiEffectiveDateMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    credits_in_period: Annotated[
        Optional[int],
        Field(
            alias="creditsInPeriod",
            description="The total credit amount that occurred within the source period’s date range.",
        ),
    ] = None
    debits_in_period: Annotated[
        Optional[int],
        Field(
            alias="debitsInPeriod",
            description="The total debit amount that occurred within the source period’s date range.",
        ),
    ] = None
    entries_in_period: Annotated[
        Optional[int],
        Field(
            alias="entriesInPeriod",
            description="The number of entries that occurred within the source period’s date range.",
        ),
    ] = None
    entries_out_of_period: Annotated[
        Optional[int],
        Field(
            alias="entriesOutOfPeriod",
            description="The number of entries that occurred outside of the source period’s date range.",
        ),
    ] = None
    in_period_count_histogram: Annotated[
        Optional[Dict[str, int]],
        Field(
            alias="inPeriodCountHistogram",
            description="A map showing the total number of entries that occurred within each indicated date period.",
        ),
    ] = None
    out_of_period_count_histogram: Annotated[
        Optional[Dict[str, int]],
        Field(
            alias="outOfPeriodCountHistogram",
            description="A map showing the total number of entries that occurred outside of each indicated date period.",
        ),
    ] = None
    period_type: Annotated[
        Optional[PeriodType],
        Field(
            alias="periodType",
            description="Indicates the time period by which the histogram has been broken down.",
        ),
    ] = None


class ApiEngagementRollForwardRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_id: Annotated[
        Optional[str],
        Field(
            alias="analysisId", description="Identifies the analysis to roll forward."
        ),
    ] = None
    interim: Annotated[
        Optional[bool],
        Field(
            description="When `true`, the new analysis period will use an interim time frame."
        ),
    ] = None
    target_engagement_id: Annotated[
        Optional[str],
        Field(
            alias="targetEngagementId",
            description="Identifies the engagement that the analysis will be rolled forward into.",
        ),
    ] = None


class ApiEngagementCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    accounting_package: Annotated[
        Optional[str],
        Field(
            alias="accountingPackage",
            description="The ERP or financial management system that your client is using.",
        ),
    ] = None
    accounting_period: Annotated[
        Optional[ApiAccountingPeriodCreateOnly], Field(alias="accountingPeriod")
    ] = None
    audit_period_end_date: Annotated[
        Optional[date],
        Field(
            alias="auditPeriodEndDate",
            description="The last day of the occurring audit.",
        ),
    ] = None
    auditor_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="auditorIds",
            description="Identifies the users who will act as auditors in the engagement.",
        ),
    ] = None
    billing_code: Annotated[
        Optional[str],
        Field(
            alias="billingCode",
            description="A unique code that associates engagements and analyses with clients to ensure those clients are billed appropriately for MindBridge usage.",
        ),
    ] = None
    engagement_lead_id: Annotated[
        Optional[str],
        Field(
            alias="engagementLeadId",
            description="Identifies the user who will lead the engagement.",
        ),
    ] = None
    industry: Annotated[
        Optional[str],
        Field(description="The type of industry that your client operates within."),
    ] = None
    library_id: Annotated[
        Optional[str], Field(alias="libraryId", description="Identifies the library.")
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the engagement.", max_length=80, min_length=0),
    ] = None
    organization_id: Annotated[
        Optional[str],
        Field(alias="organizationId", description="Identifies the organization."),
    ] = None
    settings_based_on_engagement_id: Annotated[
        Optional[str],
        Field(
            alias="settingsBasedOnEngagementId",
            description="Identifies the engagement that the settings are based on.",
        ),
    ] = None


class ApiEngagementUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    accounting_package: Annotated[
        Optional[str],
        Field(
            alias="accountingPackage",
            description="The ERP or financial management system that your client is using.",
        ),
    ] = None
    accounting_period: Annotated[
        Optional[ApiAccountingPeriodUpdate], Field(alias="accountingPeriod")
    ] = None
    audit_period_end_date: Annotated[
        Optional[date],
        Field(
            alias="auditPeriodEndDate",
            description="The last day of the occurring audit.",
        ),
    ] = None
    auditor_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="auditorIds",
            description="Identifies the users who will act as auditors in the engagement.",
        ),
    ] = None
    billing_code: Annotated[
        Optional[str],
        Field(
            alias="billingCode",
            description="A unique code that associates engagements and analyses with clients to ensure those clients are billed appropriately for MindBridge usage.",
        ),
    ] = None
    engagement_lead_id: Annotated[
        Optional[str],
        Field(
            alias="engagementLeadId",
            description="Identifies the user who will lead the engagement.",
        ),
    ] = None
    industry: Annotated[
        Optional[str],
        Field(description="The type of industry that your client operates within."),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the engagement.", max_length=80, min_length=0),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiFileInfoRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[Optional[str], Field(description="The name of the file.")] = None
    type: Annotated[Optional[str], Field(description="The file info entity type.")] = (
        None
    )


class ApiFileManagerDirectoryCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    name: Annotated[
        Optional[str], Field(description="The current name of the directory.")
    ] = None
    parent_file_manager_entity_id: Annotated[
        Optional[str],
        Field(
            alias="parentFileManagerEntityId",
            description="Identifies the parent directory. If NULL, the directory is positioned at the root level.",
        ),
    ] = None


class Type5(str, Enum):
    """
    Indicates whether the object is a DIRECTORY or a FILE within the directory.
    """

    DIRECTORY = "DIRECTORY"
    FILE = "FILE"


class ApiFileManagerEntityUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    parent_file_manager_entity_id: Annotated[
        Optional[str],
        Field(
            alias="parentFileManagerEntityId",
            description="Identifies the parent directory. If NULL, the directory is positioned at the root level.",
        ),
    ] = None
    type: Annotated[
        Optional[Type5],
        Field(
            description="Indicates whether the object is a DIRECTORY or a FILE within the directory."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiFileManagerFileCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The current name of the file, excluding the extension."),
    ] = None
    parent_file_manager_entity_id: Annotated[
        Optional[str],
        Field(
            alias="parentFileManagerEntityId",
            description="Identifies the parent directory. If NULL, the directory is positioned at the root level.",
        ),
    ] = None


class StatusEnum(str, Enum):
    MODIFIED = "MODIFIED"
    ROLLED_FORWARD = "ROLLED_FORWARD"


class ApiFileManagerFileUpdate(ApiFileManagerEntityUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str],
        Field(description="The current name of the file, excluding the extension."),
    ] = None
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiHistogramMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    count: Optional[int] = None
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    histogram: Optional[Dict[str, int]] = None
    state: Optional[State] = None


class Type7(str, Enum):
    """
    The type of account grouping file being imported.
    """

    MINDBRIDGE_TEMPLATE = "MINDBRIDGE_TEMPLATE"
    CCH_GROUP_TRIAL_BALANCE = "CCH_GROUP_TRIAL_BALANCE"


class ApiImportAccountGroupingParamsCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    chunked_file_id: Annotated[
        Optional[str],
        Field(
            alias="chunkedFileId",
            description="The unique identifier of the chunked file that contains the account grouping data.",
        ),
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the new account grouping.")
    ] = None
    type: Annotated[
        Optional[Type7],
        Field(description="The type of account grouping file being imported."),
    ] = None


class ApiImportAccountGroupingParamsUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    chunked_file_id: Annotated[
        Optional[str],
        Field(
            alias="chunkedFileId",
            description="The unique identifier of the chunked file that contains the account grouping data.",
        ),
    ] = None


class RiskScoreDisplay(str, Enum):
    """
    Determines whether risk scores will be presented as percentages (%), or using High, Medium, and Low label indicators.
    """

    HIGH_MEDIUM_LOW = "HIGH_MEDIUM_LOW"
    PERCENTAGE = "PERCENTAGE"


class ApiLibraryCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    account_grouping_id: Annotated[
        Optional[str],
        Field(
            alias="accountGroupingId",
            description="Identifies the account grouping used.",
        ),
    ] = None
    analysis_type_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="analysisTypeIds",
            description="Identifies the analysis types used in the library.",
        ),
    ] = None
    based_on_library_id: Annotated[
        Optional[str],
        Field(
            alias="basedOnLibraryId",
            description="Identifies the library that the new library is based on. This may be a user-created library or a MindBridge system library.",
        ),
    ] = None
    control_point_selection_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointSelectionPermission",
            description="When set to `true`, control points can be added or removed within each risk score.",
        ),
    ] = None
    control_point_settings_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointSettingsPermission",
            description="When set to `true`, individual control point settings can be adjusted within each risk score.",
        ),
    ] = None
    control_point_weight_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointWeightPermission",
            description="When set to `true`, the weight of each control point can be adjusted within each risk score.",
        ),
    ] = None
    convert_settings: Annotated[
        Optional[bool],
        Field(
            alias="convertSettings",
            description="Indicates whether or not settings from the selected base library should be converted for use with the selected account grouping.",
        ),
    ] = None
    default_delimiter: Annotated[
        Optional[str],
        Field(
            alias="defaultDelimiter",
            description="Identifies the default delimiter used in imported CSV files.",
        ),
    ] = None
    industry_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="industryTags",
            description="The tags used to indicate the industry that your client operates in.",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The current name of the library.", max_length=80, min_length=0
        ),
    ] = None
    risk_score_and_groups_selection_permission: Annotated[
        Optional[bool],
        Field(
            alias="riskScoreAndGroupsSelectionPermission",
            description="When set to `true`, risk scores and groups can be disabled, and accounts associated with risk scores can be edited.",
        ),
    ] = None
    risk_score_display: Annotated[
        Optional[RiskScoreDisplay],
        Field(
            alias="riskScoreDisplay",
            description="Determines whether risk scores will be presented as percentages (%), or using High, Medium, and Low label indicators.",
        ),
    ] = None
    warnings_dismissed: Annotated[
        Optional[bool],
        Field(
            alias="warningsDismissed",
            description="When set to `true`, any conversion warnings for this library will not be displayed in the **Libraries** tab in the UI.",
        ),
    ] = None


class ApiLibraryUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_type_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="analysisTypeIds",
            description="Identifies the analysis types used in the library.",
        ),
    ] = None
    archived: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the library is archived. Archived libraries cannot be selected when creating an engagement."
        ),
    ] = None
    control_point_selection_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointSelectionPermission",
            description="When set to `true`, control points can be added or removed within each risk score.",
        ),
    ] = None
    control_point_settings_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointSettingsPermission",
            description="When set to `true`, individual control point settings can be adjusted within each risk score.",
        ),
    ] = None
    control_point_weight_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointWeightPermission",
            description="When set to `true`, the weight of each control point can be adjusted within each risk score.",
        ),
    ] = None
    default_delimiter: Annotated[
        Optional[str],
        Field(
            alias="defaultDelimiter",
            description="Identifies the default delimiter used in imported CSV files.",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The current name of the library.", max_length=80, min_length=0
        ),
    ] = None
    risk_score_and_groups_selection_permission: Annotated[
        Optional[bool],
        Field(
            alias="riskScoreAndGroupsSelectionPermission",
            description="When set to `true`, risk scores and groups can be disabled, and accounts associated with risk scores can be edited.",
        ),
    ] = None
    risk_score_display: Annotated[
        Optional[RiskScoreDisplay],
        Field(
            alias="riskScoreDisplay",
            description="Determines whether risk scores will be presented as percentages (%), or using High, Medium, and Low label indicators.",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None
    warnings_dismissed: Annotated[
        Optional[bool],
        Field(
            alias="warningsDismissed",
            description="When set to `true`, any conversion warnings for this library will not be displayed in the **Libraries** tab in the UI.",
        ),
    ] = None


class ApiMessageRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: Annotated[
        Optional[str], Field(description="Identifies the message type.")
    ] = None
    default_message: Annotated[
        Optional[str],
        Field(
            alias="defaultMessage",
            description="The message as it appears in MindBridge.",
        ),
    ] = None


class ApiOrganizationCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    external_client_code: Annotated[
        Optional[str],
        Field(
            alias="externalClientCode",
            description="The unique client ID applied to this organization.",
            max_length=80,
            min_length=0,
        ),
    ] = None
    manager_user_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="managerUserIds",
            description="Identifies users assigned to the organization manager role.",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the organization.", max_length=80, min_length=0),
    ] = None


class ApiOrganizationUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    external_client_code: Annotated[
        Optional[str],
        Field(
            alias="externalClientCode",
            description="The unique client ID applied to this organization.",
            max_length=80,
            min_length=0,
        ),
    ] = None
    manager_user_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="managerUserIds",
            description="Identifies users assigned to the organization manager role.",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the organization.", max_length=80, min_length=0),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiOverallDataTypeMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    blank_records: Annotated[Optional[int], Field(alias="blankRecords")] = None
    cell_type_counts: Annotated[
        Optional[Dict[str, int]], Field(alias="cellTypeCounts")
    ] = None
    column_count: Annotated[Optional[int], Field(alias="columnCount")] = None
    column_type_counts: Annotated[
        Optional[Dict[str, int]], Field(alias="columnTypeCounts")
    ] = None
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    state: Optional[State] = None
    total_records: Annotated[Optional[int], Field(alias="totalRecords")] = None
    total_rows: Annotated[Optional[int], Field(alias="totalRows")] = None


class ApiProposedAmbiguousColumnResolutionCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    position: Annotated[
        Optional[int],
        Field(
            description="The position of the column with the proposed resolution.", ge=0
        ),
    ] = None
    selected_format: Annotated[
        Optional[str],
        Field(
            alias="selectedFormat",
            description="The selected format of the proposed resolution.",
        ),
    ] = None


class ApiProposedAmbiguousColumnResolutionRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    position: Annotated[
        Optional[int],
        Field(
            description="The position of the column with the proposed resolution.", ge=0
        ),
    ] = None
    selected_format: Annotated[
        Optional[str],
        Field(
            alias="selectedFormat",
            description="The selected format of the proposed resolution.",
        ),
    ] = None


class ApiProposedAmbiguousColumnResolutionUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    position: Annotated[
        Optional[int],
        Field(
            description="The position of the column with the proposed resolution.", ge=0
        ),
    ] = None
    selected_format: Annotated[
        Optional[str],
        Field(
            alias="selectedFormat",
            description="The selected format of the proposed resolution.",
        ),
    ] = None


class ApiProposedColumnMappingCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    additional_column_name: Annotated[
        Optional[str],
        Field(
            alias="additionalColumnName",
            description="Proposed additional columns of data to be added to the analysis.",
        ),
    ] = None
    column_position: Annotated[
        Optional[int],
        Field(
            alias="columnPosition",
            description="The position of the proposed column mapping in the original input file.",
        ),
    ] = None
    mindbridge_field: Annotated[
        Optional[str],
        Field(
            alias="mindbridgeField",
            description="The MindBridge field that the data column should be mapped to.",
        ),
    ] = None
    virtual_column_index: Annotated[
        Optional[int],
        Field(
            alias="virtualColumnIndex",
            description="The position of the proposed virtual columns within the `proposedVirtualColumns` list.",
        ),
    ] = None


class ApiProposedColumnMappingRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    additional_column_name: Annotated[
        Optional[str],
        Field(
            alias="additionalColumnName",
            description="Proposed additional columns of data to be added to the analysis.",
        ),
    ] = None
    column_position: Annotated[
        Optional[int],
        Field(
            alias="columnPosition",
            description="The position of the proposed column mapping in the original input file.",
        ),
    ] = None
    mindbridge_field: Annotated[
        Optional[str],
        Field(
            alias="mindbridgeField",
            description="The MindBridge field that the data column should be mapped to.",
        ),
    ] = None
    virtual_column_index: Annotated[
        Optional[int],
        Field(
            alias="virtualColumnIndex",
            description="The position of the proposed virtual columns within the `proposedVirtualColumns` list.",
        ),
    ] = None


class ApiProposedColumnMappingUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    additional_column_name: Annotated[
        Optional[str],
        Field(
            alias="additionalColumnName",
            description="Proposed additional columns of data to be added to the analysis.",
        ),
    ] = None
    column_position: Annotated[
        Optional[int],
        Field(
            alias="columnPosition",
            description="The position of the proposed column mapping in the original input file.",
        ),
    ] = None
    mindbridge_field: Annotated[
        Optional[str],
        Field(
            alias="mindbridgeField",
            description="The MindBridge field that the data column should be mapped to.",
        ),
    ] = None
    virtual_column_index: Annotated[
        Optional[int],
        Field(
            alias="virtualColumnIndex",
            description="The position of the proposed virtual columns within the `proposedVirtualColumns` list.",
        ),
    ] = None


class Type8(str, Enum):
    """
    The type of proposed virtual column.
    """

    DUPLICATE = "DUPLICATE"
    SPLIT_BY_POSITION = "SPLIT_BY_POSITION"
    SPLIT_BY_DELIMITER = "SPLIT_BY_DELIMITER"
    JOIN = "JOIN"


class ApiProposedVirtualColumnCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str], Field(description="The name of the proposed virtual column.")
    ] = None
    type: Annotated[
        Optional[Type8], Field(description="The type of proposed virtual column.")
    ] = None


class ApiProposedVirtualColumnRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str], Field(description="The name of the proposed virtual column.")
    ] = None
    type: Annotated[
        Optional[Type8], Field(description="The type of proposed virtual column.")
    ] = None


class ApiProposedVirtualColumnUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str], Field(description="The name of the proposed virtual column.")
    ] = None
    type: Annotated[
        Optional[Type8], Field(description="The type of proposed virtual column.")
    ] = None


class ApiSheetMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    count: Optional[int] = None
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    sheet_names: Annotated[Optional[List[str]], Field(alias="sheetNames")] = None
    state: Optional[State] = None
    valid_sheets: Annotated[Optional[List[str]], Field(alias="validSheets")] = None


class SourceScope(str, Enum):
    """
    Indicates whether the source configuration applies to the current period, all of the prior periods, or the entire analysis.

    **Note**: Sources with an `ANALYSIS` scope should not provide an `analysisPeriodId`.
    """

    CURRENT_PERIOD = "CURRENT_PERIOD"
    PRIOR_PERIOD = "PRIOR_PERIOD"
    ANALYSIS = "ANALYSIS"


class ApiSourceConfigurationRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    allow_multiple: Annotated[
        Optional[bool],
        Field(
            alias="allowMultiple",
            description="When `true`, multiple versions of this analysis source type may be imported using this source scope.",
        ),
    ] = None
    allow_multiple_for_periodic: Annotated[
        Optional[bool],
        Field(
            alias="allowMultipleForPeriodic",
            description="When `true` and the periodic time frame is used, multiple versions of this analysis source type may be imported using this source scope.",
        ),
    ] = None
    alternative_required_source_types: Annotated[
        Optional[List[str]],
        Field(
            alias="alternativeRequiredSourceTypes",
            description="A list of alternative analysis source types. If one of the alternatives is present for this source scope, then the `required` constraint is considered satisfied.",
        ),
    ] = None
    disable_for_interim: Annotated[
        Optional[bool],
        Field(
            alias="disableForInterim",
            description="When `true` and the interim time frame is used (i.e., it has not been converted for use with a full time frame), new analysis sources of this source type and source scope cannot be added.",
        ),
    ] = None
    interim_only: Annotated[
        Optional[bool],
        Field(
            alias="interimOnly",
            description="When `true`, this source configuration only applies when the interim time frame is used (i.e., it has not been converted for use with a full time frame).",
        ),
    ] = None
    post_analysis: Annotated[
        Optional[bool],
        Field(
            alias="postAnalysis",
            description="When `true`, this source configuration will be enabled after an analysis is run (not before).",
        ),
    ] = None
    required: Annotated[
        Optional[bool],
        Field(
            description="When `true`, the analysis cannot be run until at least one analysis source with this source type in this source scope is present."
        ),
    ] = None
    source_scope: Annotated[
        Optional[SourceScope],
        Field(
            alias="sourceScope",
            description="Indicates whether the source configuration applies to the current period, all of the prior periods, or the entire analysis.\n\n**Note**: Sources with an `ANALYSIS` scope should not provide an `analysisPeriodId`.",
        ),
    ] = None
    source_type_id: Annotated[
        Optional[str],
        Field(
            alias="sourceTypeId",
            description="The source type ID selected as part of this configuration.",
        ),
    ] = None
    tracks_additional_data_entries: Annotated[
        Optional[bool],
        Field(
            alias="tracksAdditionalDataEntries",
            description="When `true`, the `additionalDataColumnField` field is required upon importing an analysis source type.",
        ),
    ] = None


class ApiTaskCommentCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    comment_text: Annotated[
        Optional[str],
        Field(alias="commentText", description="The text of the comment."),
    ] = None


class ApiTaskCommentRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    author_id: Annotated[
        Optional[str],
        Field(
            alias="authorId",
            description="The unique identifier of the user who created this comment.",
        ),
    ] = None
    captured: Annotated[
        Optional[AwareDatetime],
        Field(description="The timestamp when this comment was made."),
    ] = None
    comment_text: Annotated[
        Optional[str],
        Field(alias="commentText", description="The text of the comment."),
    ] = None


class Status4(str, Enum):
    """
    The current state of the task.
    """

    OPEN = "OPEN"
    NORMAL = "NORMAL"
    RESOLVED = "RESOLVED"


class Type11(str, Enum):
    """
    The type of entry this task is associated with.
    """

    ENTRY = "ENTRY"
    TRANSACTION = "TRANSACTION"
    AP_ENTRY = "AP_ENTRY"
    AR_ENTRY = "AR_ENTRY"
    AP_OUTSTANDING_ENTRY = "AP_OUTSTANDING_ENTRY"
    AR_OUTSTANDING_ENTRY = "AR_OUTSTANDING_ENTRY"


class ApiTaskCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_id: Annotated[
        Optional[str],
        Field(alias="analysisId", description="Identifies the associated analysis."),
    ] = None
    assertions: Annotated[
        Optional[List[str]],
        Field(description="Which assertions this task is associated with."),
    ] = None
    assigned_id: Annotated[
        Optional[str],
        Field(
            alias="assignedId", description="Identifies the user assigned to this task."
        ),
    ] = None
    audit_areas: Annotated[
        Optional[List[str]],
        Field(
            alias="auditAreas",
            description="Which audit areas this task is associated with.",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="A description of the task.")
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    row_id: Annotated[
        Optional[int],
        Field(alias="rowId", description="Identifies the associated entry."),
    ] = None
    sample: Annotated[
        Optional[str], Field(description="Which sample this task is a part of.")
    ] = None
    status: Annotated[
        Optional[Status4], Field(description="The current state of the task.")
    ] = None
    transaction_id: Annotated[
        Optional[int],
        Field(
            alias="transactionId", description="Identifies the associated transaction."
        ),
    ] = None
    type: Annotated[
        Optional[Type11],
        Field(description="The type of entry this task is associated with."),
    ] = None


class SampleType(str, Enum):
    """
    The sampling method used to create this task.
    """

    RISK_BASED = "RISK_BASED"
    RANDOM = "RANDOM"
    MANUAL = "MANUAL"


class ApiTaskUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    assertions: Annotated[
        Optional[List[str]],
        Field(description="Which assertions this task is associated with."),
    ] = None
    assigned_id: Annotated[
        Optional[str],
        Field(
            alias="assignedId", description="Identifies the user assigned to this task."
        ),
    ] = None
    audit_areas: Annotated[
        Optional[List[str]],
        Field(
            alias="auditAreas",
            description="Which audit areas this task is associated with.",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="A description of the task.")
    ] = None
    sample: Annotated[
        Optional[str], Field(description="Which sample this task is a part of.")
    ] = None
    status: Annotated[
        Optional[Status4], Field(description="The current state of the task.")
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class Rating(str, Enum):
    """
    The quality of the indicator as rated by MindBridge.
    """

    FAIL = "FAIL"
    POOR = "POOR"
    NEUTRAL = "NEUTRAL"
    GOOD = "GOOD"


class ApiTransactionIdPreviewRowRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    balance: Annotated[
        Optional[int], Field(description="The balance of the transaction.")
    ] = None
    detail_rows: Annotated[
        Optional[List[Dict[str, Dict[str, Any]]]],
        Field(
            alias="detailRows",
            description="The set of entries that appear within the transaction.",
        ),
    ] = None
    entry_count: Annotated[
        Optional[int],
        Field(
            alias="entryCount",
            description="The number of entries that appear within the transaction.",
        ),
    ] = None
    transaction_id: Annotated[
        Optional[str],
        Field(
            alias="transactionId",
            description="Identifies the transaction ID for this transaction.",
        ),
    ] = None


class OverallRating(str, Enum):
    """
    The quality of the transaction ID as rated by MindBridge.
    """

    FAIL = "FAIL"
    POOR = "POOR"
    NEUTRAL = "NEUTRAL"
    GOOD = "GOOD"


class Type13(str, Enum):
    """
    The type used when selecting a transaction ID.
    """

    COMBINATION = "COMBINATION"
    RUNNING_TOTAL = "RUNNING_TOTAL"


class ApiTransactionIdSelectionCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    apply_smart_splitter: Annotated[
        Optional[bool],
        Field(
            alias="applySmartSplitter",
            description="Indicates whether or not the Smart Splitter was run when selecting a transaction ID.",
        ),
    ] = None
    column_selection: Annotated[
        Optional[List[int]],
        Field(
            alias="columnSelection",
            description="The columns included when selecting a transaction ID.",
        ),
    ] = None
    type: Annotated[
        Optional[Type13],
        Field(description="The type used when selecting a transaction ID."),
    ] = None
    virtual_column_selection: Annotated[
        Optional[List[int]],
        Field(
            alias="virtualColumnSelection",
            description="The virtual columns included when selecting a transaction ID.",
        ),
    ] = None


class ApiTransactionIdSelectionRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    apply_smart_splitter: Annotated[
        Optional[bool],
        Field(
            alias="applySmartSplitter",
            description="Indicates whether or not the Smart Splitter was run when selecting a transaction ID.",
        ),
    ] = None
    column_selection: Annotated[
        Optional[List[int]],
        Field(
            alias="columnSelection",
            description="The columns included when selecting a transaction ID.",
        ),
    ] = None
    type: Annotated[
        Optional[Type13],
        Field(description="The type used when selecting a transaction ID."),
    ] = None
    virtual_column_selection: Annotated[
        Optional[List[int]],
        Field(
            alias="virtualColumnSelection",
            description="The virtual columns included when selecting a transaction ID.",
        ),
    ] = None


class ApiTransactionIdSelectionUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    apply_smart_splitter: Annotated[
        Optional[bool],
        Field(
            alias="applySmartSplitter",
            description="Indicates whether or not the Smart Splitter was run when selecting a transaction ID.",
        ),
    ] = None
    column_selection: Annotated[
        Optional[List[int]],
        Field(
            alias="columnSelection",
            description="The columns included when selecting a transaction ID.",
        ),
    ] = None
    type: Annotated[
        Optional[Type13],
        Field(description="The type used when selecting a transaction ID."),
    ] = None
    virtual_column_selection: Annotated[
        Optional[List[int]],
        Field(
            alias="virtualColumnSelection",
            description="The virtual columns included when selecting a transaction ID.",
        ),
    ] = None


class ApiUserInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    user_id: Annotated[
        Optional[str], Field(alias="userId", description="Identifies the user.")
    ] = None
    user_name: Annotated[
        Optional[str], Field(alias="userName", description="The name of the user.")
    ] = None


class ApiUserInfoRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    user_id: Annotated[
        Optional[str], Field(alias="userId", description="Identifies the user.")
    ] = None
    user_name: Annotated[
        Optional[str], Field(alias="userName", description="The name of the user.")
    ] = None


class Role(str, Enum):
    """
    The MindBridge role assigned to the user. [Learn about user roles](https://support.mindbridge.ai/hc/en-us/articles/360056394954-User-roles-available-in-MindBridge)
    """

    ROLE_ADMIN = "ROLE_ADMIN"
    ROLE_ORGANIZATION_ADMIN = "ROLE_ORGANIZATION_ADMIN"
    ROLE_USER = "ROLE_USER"
    ROLE_CLIENT = "ROLE_CLIENT"
    ROLE_MINDBRIDGE_SUPPORT = "ROLE_MINDBRIDGE_SUPPORT"
    ROLE_USER_ADMIN = "ROLE_USER_ADMIN"


class ApiUserCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    email: Annotated[Optional[str], Field(description="The user’s email address.")] = (
        None
    )
    role: Annotated[
        Optional[Role],
        Field(
            description="The MindBridge role assigned to the user. [Learn about user roles](https://support.mindbridge.ai/hc/en-us/articles/360056394954-User-roles-available-in-MindBridge)"
        ),
    ] = None


class ApiUserRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    email: Annotated[Optional[str], Field(description="The user’s email address.")] = (
        None
    )
    enabled: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the user is enabled within this tenant."
        ),
    ] = None
    first_name: Annotated[
        Optional[str], Field(alias="firstName", description="The user’s first name.")
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    last_name: Annotated[
        Optional[str], Field(alias="lastName", description="The user’s last name.")
    ] = None
    role: Annotated[
        Optional[Role],
        Field(
            description="The MindBridge role assigned to the user. [Learn about user roles](https://support.mindbridge.ai/hc/en-us/articles/360056394954-User-roles-available-in-MindBridge)"
        ),
    ] = None
    service_account: Annotated[
        Optional[bool],
        Field(
            alias="serviceAccount",
            description="Indicates whether or not this account is used as part of an API token.",
        ),
    ] = None
    validated: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the user has opened the account activation link after being created."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiUserUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    enabled: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the user is enabled within this tenant."
        ),
    ] = None
    role: Annotated[
        Optional[Role],
        Field(
            description="The MindBridge role assigned to the user. [Learn about user roles](https://support.mindbridge.ai/hc/en-us/articles/360056394954-User-roles-available-in-MindBridge)"
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class Type17(str, Enum):
    """
    The type of virtual column.
    """

    DUPLICATE = "DUPLICATE"
    SPLIT_BY_POSITION = "SPLIT_BY_POSITION"
    SPLIT_BY_DELIMITER = "SPLIT_BY_DELIMITER"
    JOIN = "JOIN"


class ApiVirtualColumnRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    index: Annotated[
        Optional[int], Field(description="The position of the virtual column.")
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the virtual column.")
    ] = None
    type: Annotated[
        Optional[Type17], Field(description="The type of virtual column.")
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiVirtualColumnUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str], Field(description="The name of the virtual column.")
    ] = None
    type: Annotated[
        Optional[Type17], Field(description="The type of virtual column.")
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class CreateApiTokenResponseRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    allowed_addresses: Annotated[
        Optional[List[str]],
        Field(
            alias="allowedAddresses",
            description="Indicates the set of addresses that are allowed to use this token. If empty, any address may use it.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    expiry: Annotated[
        Optional[AwareDatetime],
        Field(description="The day on which the API token expires."),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The token record’s name. This will also be used as the API Token User’s name."
        ),
    ] = None
    partial_token: Annotated[
        Optional[str],
        Field(
            alias="partialToken",
            description="A partial representation of the API token.",
        ),
    ] = None
    permissions: Annotated[
        Optional[List[Permission]],
        Field(
            description="The set of permissions that inform which endpoints this token is authorized to access."
        ),
    ] = None
    token: Annotated[
        Optional[str],
        Field(
            description="The API token.\n\n**Note:** The security of the API token is paramount. If compromised, contact your **App Admin** immediately."
        ),
    ] = None
    user_id: Annotated[
        Optional[str],
        Field(
            alias="userId",
            description="Identifies the API Token User associated with this token.",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class MindBridgeQueryTerm1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_eq: Annotated[Optional[Union[int, float, bool, str]], Field(alias="$eq")] = (
        None
    )


class MindBridgeQueryTerm2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_ne: Annotated[Optional[Union[int, float, bool, str]], Field(alias="$ne")] = (
        None
    )


class MindBridgeQueryTerm3(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_gt: Annotated[Optional[Union[int, float, str]], Field(alias="$gt")] = None


class MindBridgeQueryTerm4(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_gte: Annotated[Optional[Union[int, float, str]], Field(alias="$gte")] = None


class MindBridgeQueryTerm5(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_lt: Annotated[Optional[Union[int, float, str]], Field(alias="$lt")] = None


class MindBridgeQueryTerm6(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_lte: Annotated[Optional[Union[int, float, str]], Field(alias="$lte")] = None


class MindBridgeQueryTerm7(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_contains: Annotated[Optional[List[str]], Field(alias="$contains")] = None


class MindBridgeQueryTerm9(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_in: Annotated[
        Optional[List[Union[int, float, bool, str]]], Field(alias="$in")
    ] = None


class MindBridgeQueryTerm10(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_nin: Annotated[
        Optional[List[Union[int, float, bool, str]]], Field(alias="$nin")
    ] = None


class MindBridgeQueryTerm11(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_flags: Annotated[Optional[Dict[str, bool]], Field(alias="$flags")] = None


class MindBridgeQueryTerm12(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_isubstr: Annotated[Optional[str], Field(alias="$isubstr")] = None


class MindBridgeQueryTerm13(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_iprefix: Annotated[Optional[str], Field(alias="$iprefix")] = None


class MindBridgeQueryTerm14(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_niprefix: Annotated[Optional[str], Field(alias="$niprefix")] = None


class MindBridgeQueryTerm17(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_keyword_prefix: Annotated[Optional[str], Field(alias="$keyword_prefix")] = (
        None
    )


class MindBridgeQueryTerm18(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_keyword_prefix_not: Annotated[
        Optional[str], Field(alias="$keyword_prefix_not")
    ] = None


class ProblemType(str, Enum):
    """
    The type of problem.
    """

    UNKNOWN = "UNKNOWN"
    ILLEGAL_ARGUMENT = "ILLEGAL_ARGUMENT"
    CANNOT_DELETE = "CANNOT_DELETE"
    GREATER_VALUE_REQUIRED = "GREATER_VALUE_REQUIRED"
    LESS_VALUE_REQUIRED = "LESS_VALUE_REQUIRED"
    NON_UNIQUE_VALUE = "NON_UNIQUE_VALUE"
    USER_EMAIL_ALREADY_EXISTS = "USER_EMAIL_ALREADY_EXISTS"
    INCORRECT_DATA_TYPE = "INCORRECT_DATA_TYPE"
    RATIO_CONVERSION_FAILED = "RATIO_CONVERSION_FAILED"
    RISK_SCORE_FILTER_CONVERSION_FAILED = "RISK_SCORE_FILTER_CONVERSION_FAILED"
    FILTER_CONVERSION_FAILED = "FILTER_CONVERSION_FAILED"
    POPULATION_CONVERSION_FAILED = "POPULATION_CONVERSION_FAILED"
    INSUFFICIENT_PERMISSION = "INSUFFICIENT_PERMISSION"
    ACCOUNT_GROUPING_NODES_CONTAIN_ERRORS = "ACCOUNT_GROUPING_NODES_CONTAIN_ERRORS"
    ACCOUNT_GROUPING_IN_USE_BY_LIBRARY = "ACCOUNT_GROUPING_IN_USE_BY_LIBRARY"
    INVALID_ACCOUNT_GROUPING_FILE = "INVALID_ACCOUNT_GROUPING_FILE"


class Severity(str, Enum):
    """
    Indicates how severe the error is.
    """

    WARNING = "WARNING"
    ERROR = "ERROR"


class Problem(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    entity_id: Annotated[
        Optional[str],
        Field(
            alias="entityId",
            description="Identifies the entity impacted by the problem.",
        ),
    ] = None
    entity_type: Annotated[
        Optional[str],
        Field(
            alias="entityType",
            description="The type of entity impacted by the problem.",
        ),
    ] = None
    identifier: Annotated[
        Optional[str], Field(description="Identifies the field causing the problem.")
    ] = None
    problem_count: Annotated[
        Optional[int],
        Field(alias="problemCount", description="The total number of problems."),
    ] = None
    problem_type: Annotated[
        Optional[ProblemType],
        Field(alias="problemType", description="The type of problem."),
    ] = None
    reason: Annotated[
        Optional[str], Field(description="The reason(s) why the problem occurred.")
    ] = None
    severity: Annotated[
        Optional[Severity], Field(description="Indicates how severe the error is.")
    ] = None
    suggested_values: Annotated[
        Optional[List[str]],
        Field(
            alias="suggestedValues",
            description="A suggested set of values to assist in resolving the problem.",
        ),
    ] = None
    values: Annotated[
        Optional[List[str]],
        Field(description="Identifies the entity impacted by the error."),
    ] = None


class ProblemRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    entity_id: Annotated[
        Optional[str],
        Field(
            alias="entityId",
            description="Identifies the entity impacted by the problem.",
        ),
    ] = None
    entity_type: Annotated[
        Optional[str],
        Field(
            alias="entityType",
            description="The type of entity impacted by the problem.",
        ),
    ] = None
    identifier: Annotated[
        Optional[str], Field(description="Identifies the field causing the problem.")
    ] = None
    problem_count: Annotated[
        Optional[int],
        Field(alias="problemCount", description="The total number of problems."),
    ] = None
    problem_type: Annotated[
        Optional[ProblemType],
        Field(alias="problemType", description="The type of problem."),
    ] = None
    reason: Annotated[
        Optional[str], Field(description="The reason(s) why the problem occurred.")
    ] = None
    severity: Annotated[
        Optional[Severity], Field(description="Indicates how severe the error is.")
    ] = None
    suggested_values: Annotated[
        Optional[List[str]],
        Field(
            alias="suggestedValues",
            description="A suggested set of values to assist in resolving the problem.",
        ),
    ] = None
    values: Annotated[
        Optional[List[str]],
        Field(description="Identifies the entity impacted by the error."),
    ] = None


class RangeBigDecimalRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    max: Optional[float] = None
    min: Optional[float] = None


class RangeIntegerRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    max: Optional[int] = None
    min: Optional[int] = None


class RangeZonedDateTimeRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    max: Optional[AwareDatetime] = None
    min: Optional[AwareDatetime] = None


class Category(str, Enum):
    ACCOUNT_GROUPING = "ACCOUNT_GROUPING"
    ACCOUNT_MAPPING = "ACCOUNT_MAPPING"
    ADMIN_REPORT = "ADMIN_REPORT"
    ANALYSIS_TYPE = "ANALYSIS_TYPE"
    API_TOKEN = "API_TOKEN"
    AUDIT_ANNOTATION = "AUDIT_ANNOTATION"
    CLOUD_ELEMENTS = "CLOUD_ELEMENTS"
    COLLECTION_ASSIGNMENT = "COLLECTION_ASSIGNMENT"
    ENGAGEMENT = "ENGAGEMENT"
    FILE_LOCKER = "FILE_LOCKER"
    FILE_MANAGER = "FILE_MANAGER"
    FILTER = "FILTER"
    GDPDU = "GDPDU"
    INGESTION = "INGESTION"
    INTEGRATIONS = "INTEGRATIONS"
    LIBRARY = "LIBRARY"
    MIGRATION = "MIGRATION"
    ORGANIZATION = "ORGANIZATION"
    POPULATION = "POPULATION"
    QUERY = "QUERY"
    RATIO = "RATIO"
    REPORT_BUILDER = "REPORT_BUILDER"
    REPORT = "REPORT"
    RESULTS_EXPORT = "RESULTS_EXPORT"
    RISK_RANGES = "RISK_RANGES"
    RISK_SEGMENTATION_DASHBOARD = "RISK_SEGMENTATION_DASHBOARD"
    SCIM_API = "SCIM_API"
    SUPPORT_ACCESS = "SUPPORT_ACCESS"
    TASK = "TASK"
    USER = "USER"
    WORKFLOW = "WORKFLOW"


class RunActivityReportRequestRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    categories: Annotated[
        Optional[List[Category]],
        Field(
            description="The categories to include in the report. If empty, all categories will be included."
        ),
    ] = None
    end: Annotated[
        Optional[AwareDatetime],
        Field(description="The last date in the reporting timeframe."),
    ] = None
    only_completed_analyses: Annotated[
        Optional[bool],
        Field(
            alias="onlyCompletedAnalyses",
            description="Restrict entries to analysis complete events.",
        ),
    ] = None
    start: Annotated[
        Optional[AwareDatetime],
        Field(description="The first date in the reporting timeframe."),
    ] = None
    user_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="userIds",
            description="The users to include in the report. If empty, all users will be included.",
        ),
    ] = None


class RunAdminReportRequestRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    end: Annotated[
        Optional[AwareDatetime],
        Field(description="The last date in the reporting timeframe."),
    ] = None
    start: Annotated[
        Optional[AwareDatetime],
        Field(description="The first date in the reporting timeframe."),
    ] = None


class SortObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    ascending: Optional[bool] = None
    direction: Optional[str] = None
    ignore_case: Annotated[Optional[bool], Field(alias="ignoreCase")] = None
    null_handling: Annotated[Optional[str], Field(alias="nullHandling")] = None
    property: Optional[str] = None


class ActionableErrorResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    entity_id: Annotated[
        Optional[str],
        Field(
            alias="entityId", description="Identifies the entity impacted by the error."
        ),
    ] = None
    entity_type: Annotated[
        Optional[str],
        Field(
            alias="entityType", description="The type of entity impacted by the error."
        ),
    ] = None
    instance: Annotated[
        Optional[str], Field(description="A unique identifier for this request.")
    ] = None
    origin: Annotated[
        Optional[str],
        Field(description="The endpoint where this request originated from."),
    ] = None
    problem_count: Annotated[
        Optional[int],
        Field(alias="problemCount", description="The total number of problems."),
    ] = None
    problems: Annotated[
        Optional[List[Problem]],
        Field(description="The reason(s) why the error occurred."),
    ] = None
    status: Annotated[
        Optional[int],
        Field(description="The HTTP status code determined by the error type."),
    ] = None
    title: Annotated[
        Optional[str], Field(description="A description of the error.")
    ] = None
    type: Annotated[
        Optional[str],
        Field(
            description="Indicates the type of error that occurred. Type values are formatted as URLs."
        ),
    ] = None


class ApiAccountGrouping(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    archived: Annotated[
        Optional[bool],
        Field(description="When `true`, the account grouping is archived."),
    ] = None
    code_display_name: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="codeDisplayName",
            description="The name of the account code hierarchy system used within the dataset.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfo], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The delimiter character used to separate each category level in an account grouping code."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    industry_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="industryTags",
            description="A set of all the unique industry tags included in the account grouping.",
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfo], Field(alias="lastModifiedUserInfo")
    ] = None
    mac: Annotated[
        Optional[bool],
        Field(
            description="When `true`, the account grouping is based on the MAC code system."
        ),
    ] = None
    name: Annotated[
        Optional[Dict[str, str]], Field(description="The name of the account grouping.")
    ] = None
    publish_status: Annotated[
        Optional[PublishStatus],
        Field(
            alias="publishStatus",
            description="The current status of the account grouping.",
        ),
    ] = None
    published_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="publishedDate",
            description="The date that the account grouping was published.",
        ),
    ] = None
    system: Annotated[
        Optional[bool],
        Field(
            description="When `true`, the account grouping is a system account grouping and cannot be modified."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(description="The data integrity version, to ensure data consistency."),
    ] = None


class ApiAccountGroupingRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    archived: Annotated[
        Optional[bool],
        Field(description="When `true`, the account grouping is archived."),
    ] = None
    code_display_name: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="codeDisplayName",
            description="The name of the account code hierarchy system used within the dataset.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The delimiter character used to separate each category level in an account grouping code."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    industry_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="industryTags",
            description="A set of all the unique industry tags included in the account grouping.",
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    mac: Annotated[
        Optional[bool],
        Field(
            description="When `true`, the account grouping is based on the MAC code system."
        ),
    ] = None
    name: Annotated[
        Optional[Dict[str, str]], Field(description="The name of the account grouping.")
    ] = None
    publish_status: Annotated[
        Optional[PublishStatus],
        Field(
            alias="publishStatus",
            description="The current status of the account grouping.",
        ),
    ] = None
    published_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="publishedDate",
            description="The date that the account grouping was published.",
        ),
    ] = None
    system: Annotated[
        Optional[bool],
        Field(
            description="When `true`, the account grouping is a system account grouping and cannot be modified."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(description="The data integrity version, to ensure data consistency."),
    ] = None


class ApiAnalysisSourceTypeRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    archived: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the analysis source type is archived."
        ),
    ] = None
    column_definitions: Annotated[
        Optional[List[ApiColumnDefinitionRead]],
        Field(
            alias="columnDefinitions",
            description="A list of MindBridge column definitions that this analysis source type supports.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    features: Annotated[
        Optional[List[Feature]],
        Field(
            description="A list of the features used when importing data for this analysis source type."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    interim_name: Annotated[
        Optional[str],
        Field(
            alias="interimName",
            description="The name of the analysis source type when the analysis uses an interim time frame.",
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the analysis source type.")
    ] = None
    version: Annotated[
        Optional[int],
        Field(description="Data integrity version to ensure data consistency."),
    ] = None


class ApiAnalysisTypeRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    account_mapping_required: Annotated[
        Optional[bool],
        Field(
            alias="accountMappingRequired",
            description="Indicates whether or not account mapping must be performed.",
        ),
    ] = None
    archived: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the analysis type has been archived."
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="The description of the analysis type.")
    ] = None
    fund_supported: Annotated[
        Optional[bool],
        Field(
            alias="fundSupported",
            description="Indicates whether or not the analysis supports restricted and unrestricted funds.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    interim_name: Annotated[
        Optional[str],
        Field(
            alias="interimName",
            description="The name of the analysis type when the analysis uses an interim time frame.",
        ),
    ] = None
    interim_supported: Annotated[
        Optional[bool],
        Field(
            alias="interimSupported",
            description="Indicates whether or not the analysis supports the interim time frame.",
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the analysis type.")
    ] = None
    periodic_supported: Annotated[
        Optional[bool],
        Field(
            alias="periodicSupported",
            description="Indicates whether or not the analysis supports the periodic time frame.",
        ),
    ] = None
    source_configurations: Annotated[
        Optional[List[ApiSourceConfigurationRead]],
        Field(
            alias="sourceConfigurations",
            description="A list of analysis source configurations that can be imported into the analysis, as determined by the analysis type.",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(description="Data integrity version to ensure data consistency."),
    ] = None


class ApiAnalysisRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_period_gaps: Annotated[
        Optional[List[ApiAnalysisPeriodGapRead]],
        Field(
            alias="analysisPeriodGaps",
            description="Details about the gap in time between two analysis periods.",
        ),
    ] = None
    analysis_periods: Annotated[
        Optional[List[ApiAnalysisPeriodRead]],
        Field(
            alias="analysisPeriods",
            description="Details about the specific analysis periods under audit.",
        ),
    ] = None
    analysis_type_id: Annotated[
        Optional[str],
        Field(alias="analysisTypeId", description="Identifies the type of analysis."),
    ] = None
    archived: Annotated[
        Optional[bool],
        Field(description="Indicates whether or not the analysis has been archived."),
    ] = None
    converted: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not an interim analysis time frame has been converted to a full analysis time frame."
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    currency_code: Annotated[
        Optional[str],
        Field(
            alias="currencyCode",
            description="The currency to be displayed across the analysis results.",
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    important_columns: Annotated[
        Optional[List[ApiAnalysisImportantColumnRead]],
        Field(
            alias="importantColumns",
            description="Additional data columns that can be used when importing additional data.",
        ),
    ] = None
    interim: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the analysis is using an interim time frame."
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the analysis.", max_length=80, min_length=0),
    ] = None
    periodic: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the analysis is using a periodic time frame."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiApiTokenRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    allowed_addresses: Annotated[
        Optional[List[str]],
        Field(
            alias="allowedAddresses",
            description="Indicates the set of addresses that are allowed to use this token. If empty, any address may use it.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    expiry: Annotated[
        Optional[AwareDatetime],
        Field(description="The day on which the API token expires."),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The token record’s name. This will also be used as the API Token User’s name."
        ),
    ] = None
    partial_token: Annotated[
        Optional[str],
        Field(
            alias="partialToken",
            description="A partial representation of the API token.",
        ),
    ] = None
    permissions: Annotated[
        Optional[List[Permission]],
        Field(
            description="The set of permissions that inform which endpoints this token is authorized to access."
        ),
    ] = None
    user_id: Annotated[
        Optional[str],
        Field(
            alias="userId",
            description="Identifies the API Token User associated with this token.",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiAsyncResult(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    created_user_info: Annotated[
        Optional[ApiUserInfo], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    entity_id: Annotated[
        Optional[str],
        Field(alias="entityId", description="Identifies the entity used in the job."),
    ] = None
    entity_type: Annotated[
        Optional[EntityType],
        Field(
            alias="entityType",
            description="Identifies the entity type used in the job.",
        ),
    ] = None
    error: Annotated[
        Optional[str], Field(description="The reason why the async job failed.")
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfo], Field(alias="lastModifiedUserInfo")
    ] = None
    status: Annotated[
        Optional[Status2], Field(description="Indicates the current state of the job.")
    ] = None
    type: Annotated[
        Optional[Type1], Field(description="Indicates the type of job being run.")
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiAsyncResultRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    entity_id: Annotated[
        Optional[str],
        Field(alias="entityId", description="Identifies the entity used in the job."),
    ] = None
    entity_type: Annotated[
        Optional[EntityType],
        Field(
            alias="entityType",
            description="Identifies the entity type used in the job.",
        ),
    ] = None
    error: Annotated[
        Optional[str], Field(description="The reason why the async job failed.")
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    status: Annotated[
        Optional[Status2], Field(description="Indicates the current state of the job.")
    ] = None
    type: Annotated[
        Optional[Type1], Field(description="Indicates the type of job being run.")
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiBasicMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    state: Optional[State] = None


class ApiChunkedFileRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    chunked_file_parts: Annotated[
        Optional[List[ApiChunkedFilePartRead]],
        Field(
            alias="chunkedFileParts",
            description="The offset and size of the chunked file parts.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str], Field(description="The name of the chunked file.")
    ] = None
    size: Annotated[
        Optional[int], Field(description="The size of the chunked file.", ge=0)
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiCountMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    count: Optional[int] = None
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    state: Optional[State] = None


class ApiDateTypeDetailsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    ambiguous_date_time_formats: Annotated[
        Optional[List[ApiColumnDateTimeFormatRead]],
        Field(alias="ambiguousDateTimeFormats"),
    ] = None
    range: Optional[RangeZonedDateTimeRead] = None
    unambiguous_date_time_formats: Annotated[
        Optional[List[ApiColumnDateTimeFormatRead]],
        Field(alias="unambiguousDateTimeFormats"),
    ] = None


class ApiDuplicateVirtualColumnRead(ApiVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the duplicated column."
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiDuplicateVirtualColumnUpdate(ApiVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the duplicated column."
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiEngagementAccountGroupingRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    account_grouping_id: Annotated[
        Optional[str],
        Field(
            alias="accountGroupingId",
            description="The unique identifier of the account grouping on which this is based.",
        ),
    ] = None
    code_display_name: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="codeDisplayName",
            description="The name of the account code hierarchy system used within the dataset.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The delimiter character used to separate each category level in an account grouping code."
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId",
            description="The unique identifier of the engagement that this engagement account grouping belongs to.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[Dict[str, str]], Field(description="The name of the account grouping.")
    ] = None
    version: Annotated[
        Optional[int],
        Field(description="The data integrity version, to ensure data consistency."),
    ] = None


class ApiEngagementRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    accounting_package: Annotated[
        Optional[str],
        Field(
            alias="accountingPackage",
            description="The ERP or financial management system that your client is using.",
        ),
    ] = None
    accounting_period: Annotated[
        Optional[ApiAccountingPeriodRead], Field(alias="accountingPeriod")
    ] = None
    audit_period_end_date: Annotated[
        Optional[date],
        Field(
            alias="auditPeriodEndDate",
            description="The last day of the occurring audit.",
        ),
    ] = None
    auditor_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="auditorIds",
            description="Identifies the users who will act as auditors in the engagement.",
        ),
    ] = None
    billing_code: Annotated[
        Optional[str],
        Field(
            alias="billingCode",
            description="A unique code that associates engagements and analyses with clients to ensure those clients are billed appropriately for MindBridge usage.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    engagement_lead_id: Annotated[
        Optional[str],
        Field(
            alias="engagementLeadId",
            description="Identifies the user who will lead the engagement.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    industry: Annotated[
        Optional[str],
        Field(description="The type of industry that your client operates within."),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    library_id: Annotated[
        Optional[str], Field(alias="libraryId", description="Identifies the library.")
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the engagement.", max_length=80, min_length=0),
    ] = None
    organization_id: Annotated[
        Optional[str],
        Field(alias="organizationId", description="Identifies the organization."),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiFileExportRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    file_name: Annotated[
        Optional[str], Field(alias="fileName", description="The name of the file.")
    ] = None
    id: Annotated[
        Optional[str], Field(description="The unique file export identifier.")
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    size: Annotated[Optional[int], Field(description="The size of the file.")] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiFileManagerDirectoryUpdate(ApiFileManagerEntityUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str], Field(description="The current name of the directory.")
    ] = None
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiFileManagerEntityRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    parent_file_manager_entity_id: Annotated[
        Optional[str],
        Field(
            alias="parentFileManagerEntityId",
            description="Identifies the parent directory. If NULL, the directory is positioned at the root level.",
        ),
    ] = None
    type: Annotated[
        Optional[Type5],
        Field(
            description="Indicates whether the object is a DIRECTORY or a FILE within the directory."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiFileManagerFileRead(ApiFileManagerEntityRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    extension: Annotated[
        Optional[str], Field(description="The suffix used at the end of the file.")
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The current name of the file, excluding the extension."),
    ] = None
    original_name: Annotated[
        Optional[str],
        Field(
            alias="originalName",
            description="The name of the file as it appeared when first imported, including the extension.",
        ),
    ] = None
    status: Annotated[
        Optional[List[StatusEnum]],
        Field(description="The status of the file as it appears in MindBridge."),
    ] = None
    engagement_id: Annotated[
        str,
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiJoinVirtualColumnRead(ApiVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_indices: Annotated[
        Optional[List[int]],
        Field(
            alias="columnIndices",
            description="The positions of the column to be joined.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be inserted to separate values."
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiJoinVirtualColumnUpdate(ApiVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_indices: Annotated[
        Optional[List[int]],
        Field(
            alias="columnIndices",
            description="The positions of the column to be joined.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be inserted to separate values."
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiLibraryRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    account_grouping_id: Annotated[
        Optional[str],
        Field(
            alias="accountGroupingId",
            description="Identifies the account grouping used.",
        ),
    ] = None
    analysis_type_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="analysisTypeIds",
            description="Identifies the analysis types used in the library.",
        ),
    ] = None
    archived: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the library is archived. Archived libraries cannot be selected when creating an engagement."
        ),
    ] = None
    based_on_library_id: Annotated[
        Optional[str],
        Field(
            alias="basedOnLibraryId",
            description="Identifies the library that the new library is based on. This may be a user-created library or a MindBridge system library.",
        ),
    ] = None
    control_point_selection_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointSelectionPermission",
            description="When set to `true`, control points can be added or removed within each risk score.",
        ),
    ] = None
    control_point_settings_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointSettingsPermission",
            description="When set to `true`, individual control point settings can be adjusted within each risk score.",
        ),
    ] = None
    control_point_weight_permission: Annotated[
        Optional[bool],
        Field(
            alias="controlPointWeightPermission",
            description="When set to `true`, the weight of each control point can be adjusted within each risk score.",
        ),
    ] = None
    conversion_warnings: Annotated[
        Optional[List[ProblemRead]],
        Field(
            alias="conversionWarnings",
            description="A list of accounts that failed to convert the selected base library’s setting to the selected account grouping.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    default_delimiter: Annotated[
        Optional[str],
        Field(
            alias="defaultDelimiter",
            description="Identifies the default delimiter used in imported CSV files.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    industry_tags: Annotated[
        Optional[List[str]],
        Field(
            alias="industryTags",
            description="The tags used to indicate the industry that your client operates in.",
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The current name of the library.", max_length=80, min_length=0
        ),
    ] = None
    original_system_library_id: Annotated[
        Optional[str],
        Field(
            alias="originalSystemLibraryId",
            description="Identifies the original MindBridge-supplied library.",
        ),
    ] = None
    risk_score_and_groups_selection_permission: Annotated[
        Optional[bool],
        Field(
            alias="riskScoreAndGroupsSelectionPermission",
            description="When set to `true`, risk scores and groups can be disabled, and accounts associated with risk scores can be edited.",
        ),
    ] = None
    risk_score_display: Annotated[
        Optional[RiskScoreDisplay],
        Field(
            alias="riskScoreDisplay",
            description="Determines whether risk scores will be presented as percentages (%), or using High, Medium, and Low label indicators.",
        ),
    ] = None
    system: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether or not the library is a MindBridge system library."
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None
    warnings_dismissed: Annotated[
        Optional[bool],
        Field(
            alias="warningsDismissed",
            description="When set to `true`, any conversion warnings for this library will not be displayed in the **Libraries** tab in the UI.",
        ),
    ] = None


class ApiNumericTypeDetailsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    capped_max: Annotated[Optional[bool], Field(alias="cappedMax")] = None
    capped_sum: Annotated[Optional[bool], Field(alias="cappedSum")] = None
    currency_format: Annotated[
        Optional[ApiCurrencyFormatRead], Field(alias="currencyFormat")
    ] = None
    example_pair_from_currency_formatter: Annotated[
        Optional[List[str]], Field(alias="examplePairFromCurrencyFormatter")
    ] = None
    range: Optional[RangeBigDecimalRead] = None
    sum: Optional[float] = None


class ApiOrganizationRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    external_client_code: Annotated[
        Optional[str],
        Field(
            alias="externalClientCode",
            description="The unique client ID applied to this organization.",
            max_length=80,
            min_length=0,
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    manager_user_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="managerUserIds",
            description="Identifies users assigned to the organization manager role.",
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(description="The name of the organization.", max_length=80, min_length=0),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiPopulationTagRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_id: Annotated[
        Optional[str],
        Field(alias="analysisId", description="Identifies the parent analysis ID."),
    ] = None
    base_population_id: Annotated[
        Optional[str],
        Field(
            alias="basePopulationId",
            description="Identifies the population the current population was based off of.",
        ),
    ] = None
    category: Annotated[
        Optional[str],
        Field(
            description="The category of the population.", max_length=80, min_length=0
        ),
    ] = None
    cloned_from: Annotated[
        Optional[str],
        Field(
            alias="clonedFrom",
            description="Identifies the population the current population was cloned form.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    derived_from_engagement: Annotated[
        Optional[bool],
        Field(
            alias="derivedFromEngagement",
            description="Identifies the engagement that the analysis population is derived from.",
        ),
    ] = None
    derived_from_library: Annotated[
        Optional[bool],
        Field(
            alias="derivedFromLibrary",
            description="Identifies the library that the engagement population is derived from.",
        ),
    ] = None
    description: Annotated[
        Optional[str],
        Field(
            description="The description of the population.",
            max_length=250,
            min_length=0,
        ),
    ] = None
    disabled: Annotated[
        Optional[bool],
        Field(description="Indicates whether or not the population is disabled."),
    ] = None
    disabled_for_analysis_ids: Annotated[
        Optional[List[str]],
        Field(
            alias="disabledForAnalysisIds",
            description="Identifies the analyses that the engagement population is disabled within.",
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(alias="engagementId", description="Identifies the parent engagement ID."),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    library_id: Annotated[
        Optional[str],
        Field(alias="libraryId", description="Identifies the parent library ID."),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The current name of the population.",
            max_length=80,
            min_length=0,
        ),
    ] = None
    promoted_from_analysis_id: Annotated[
        Optional[str],
        Field(
            alias="promotedFromAnalysisId",
            description="Identifies the analysis that the engagement population was added to.",
        ),
    ] = None
    reason_for_change: Annotated[
        Optional[str],
        Field(
            alias="reasonForChange",
            description="The reason for the latest change to the population.",
            max_length=250,
            min_length=0,
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiProposedDuplicateVirtualColumnCreateOnly(ApiProposedVirtualColumnCreateOnly):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex",
            description="The position of the column to be duplicated.",
        ),
    ] = None


class ApiProposedDuplicateVirtualColumnRead(ApiProposedVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex",
            description="The position of the column to be duplicated.",
        ),
    ] = None


class ApiProposedDuplicateVirtualColumnUpdate(ApiProposedVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex",
            description="The position of the column to be duplicated.",
        ),
    ] = None


class ApiProposedJoinVirtualColumnCreateOnly(ApiProposedVirtualColumnCreateOnly):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_indices: Annotated[
        Optional[List[int]],
        Field(
            alias="columnIndices",
            description="The positions of the columns to be joined.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be inserted to separate values."
        ),
    ] = None


class ApiProposedJoinVirtualColumnRead(ApiProposedVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_indices: Annotated[
        Optional[List[int]],
        Field(
            alias="columnIndices",
            description="The positions of the columns to be joined.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be inserted to separate values."
        ),
    ] = None


class ApiProposedJoinVirtualColumnUpdate(ApiProposedVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_indices: Annotated[
        Optional[List[int]],
        Field(
            alias="columnIndices",
            description="The positions of the columns to be joined.",
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be inserted to separate values."
        ),
    ] = None


class ApiProposedSplitByDelimiterVirtualColumnCreateOnly(
    ApiProposedVirtualColumnCreateOnly
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the column to be split."
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be used to separate the string into parts."
        ),
    ] = None
    split_index: Annotated[
        Optional[int],
        Field(
            alias="splitIndex",
            description="The position of the part to be used as a virtual column.",
        ),
    ] = None


class ApiProposedSplitByDelimiterVirtualColumnRead(ApiProposedVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the column to be split."
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be used to separate the string into parts."
        ),
    ] = None
    split_index: Annotated[
        Optional[int],
        Field(
            alias="splitIndex",
            description="The position of the part to be used as a virtual column.",
        ),
    ] = None


class ApiProposedSplitByDelimiterVirtualColumnUpdate(ApiProposedVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the column to be split."
        ),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(
            description="The character(s) that should be used to separate the string into parts."
        ),
    ] = None
    split_index: Annotated[
        Optional[int],
        Field(
            alias="splitIndex",
            description="The position of the part to be used as a virtual column.",
        ),
    ] = None


class ApiProposedSplitByPositionVirtualColumnCreateOnly(
    ApiProposedVirtualColumnCreateOnly
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the column to be split."
        ),
    ] = None
    end_position: Annotated[
        Optional[int],
        Field(
            alias="endPosition",
            description="The ending position of the substring to be used as the new column. **Exclusive**.",
        ),
    ] = None
    start_position: Annotated[
        Optional[int],
        Field(
            alias="startPosition",
            description="The starting position of the substring to be used as the new column. **Inclusive**.",
        ),
    ] = None


class ApiProposedSplitByPositionVirtualColumnRead(ApiProposedVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the column to be split."
        ),
    ] = None
    end_position: Annotated[
        Optional[int],
        Field(
            alias="endPosition",
            description="The ending position of the substring to be used as the new column. **Exclusive**.",
        ),
    ] = None
    start_position: Annotated[
        Optional[int],
        Field(
            alias="startPosition",
            description="The starting position of the substring to be used as the new column. **Inclusive**.",
        ),
    ] = None


class ApiProposedSplitByPositionVirtualColumnUpdate(ApiProposedVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(
            alias="columnIndex", description="The position of the column to be split."
        ),
    ] = None
    end_position: Annotated[
        Optional[int],
        Field(
            alias="endPosition",
            description="The ending position of the substring to be used as the new column. **Exclusive**.",
        ),
    ] = None
    start_position: Annotated[
        Optional[int],
        Field(
            alias="startPosition",
            description="The starting position of the substring to be used as the new column. **Inclusive**.",
        ),
    ] = None


class ApiSplitByDelimiterVirtualColumnRead(ApiVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(alias="columnIndex", description="The position of the split column."),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(description="The character(s) used to separate the string into parts."),
    ] = None
    split_index: Annotated[
        Optional[int],
        Field(
            alias="splitIndex",
            description="The position of the part used as a virtual column.",
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiSplitByDelimiterVirtualColumnUpdate(ApiVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(alias="columnIndex", description="The position of the split column."),
    ] = None
    delimiter: Annotated[
        Optional[str],
        Field(description="The character(s) used to separate the string into parts."),
    ] = None
    split_index: Annotated[
        Optional[int],
        Field(
            alias="splitIndex",
            description="The position of the part used as a virtual column.",
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiSplitByPositionVirtualColumnRead(ApiVirtualColumnRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(alias="columnIndex", description="The position of the split column."),
    ] = None
    end_position: Annotated[
        Optional[int],
        Field(
            alias="endPosition",
            description="The ending position of the substring in the new column. **Exclusive**.",
        ),
    ] = None
    start_position: Annotated[
        Optional[int],
        Field(
            alias="startPosition",
            description="The starting position of the substring in the new column. **Inclusive**.",
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiSplitByPositionVirtualColumnUpdate(ApiVirtualColumnUpdate):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_index: Annotated[
        Optional[int],
        Field(alias="columnIndex", description="The position of the split column."),
    ] = None
    end_position: Annotated[
        Optional[int],
        Field(
            alias="endPosition",
            description="The ending position of the substring in the new column. **Exclusive**.",
        ),
    ] = None
    start_position: Annotated[
        Optional[int],
        Field(
            alias="startPosition",
            description="The starting position of the substring in the new column. **Inclusive**.",
        ),
    ] = None
    name: Annotated[str, Field(description="The name of the virtual column.")]
    type: Annotated[Type17, Field(description="The type of virtual column.")]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class ApiTableMetadataRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cell_length_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="cellLengthMetrics")
    ] = None
    density_metrics: Annotated[
        Optional[ApiDensityMetricsRead], Field(alias="densityMetrics")
    ] = None
    inconsistent_date_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="inconsistentDateMetrics")
    ] = None
    null_value_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="nullValueMetrics")
    ] = None
    numeric_column_metrics: Annotated[
        Optional[ApiBasicMetricsRead], Field(alias="numericColumnMetrics")
    ] = None
    overall_data_type_metrics: Annotated[
        Optional[ApiOverallDataTypeMetricsRead], Field(alias="overallDataTypeMetrics")
    ] = None
    scientific_notation_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="scientificNotationMetrics")
    ] = None
    sheet_metrics: Annotated[
        Optional[ApiSheetMetricsRead], Field(alias="sheetMetrics")
    ] = None
    special_character_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="specialCharacterMetrics")
    ] = None
    uneven_columns_metrics: Annotated[
        Optional[ApiHistogramMetricsRead], Field(alias="unevenColumnsMetrics")
    ] = None


class ApiTaskRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_id: Annotated[
        Optional[str],
        Field(alias="analysisId", description="Identifies the associated analysis."),
    ] = None
    analysis_type_id: Annotated[
        Optional[str],
        Field(
            alias="analysisTypeId",
            description="Identifies the associated analysis type.",
        ),
    ] = None
    assertions: Annotated[
        Optional[List[str]],
        Field(description="Which assertions this task is associated with."),
    ] = None
    assigned_id: Annotated[
        Optional[str],
        Field(
            alias="assignedId", description="Identifies the user assigned to this task."
        ),
    ] = None
    audit_areas: Annotated[
        Optional[List[str]],
        Field(
            alias="auditAreas",
            description="Which audit areas this task is associated with.",
        ),
    ] = None
    comments: Annotated[
        Optional[List[ApiTaskCommentRead]],
        Field(
            description="A list of all the comments that have been made on this task."
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    credit_value: Annotated[
        Optional[int],
        Field(
            alias="creditValue",
            description="The credit value of the associated transaction or entry, formatted as MONEY_100.",
        ),
    ] = None
    customer_name: Annotated[
        Optional[str],
        Field(
            alias="customerName",
            description="For AR analyses this is the customer name for the associated entry.",
        ),
    ] = None
    debit_value: Annotated[
        Optional[int],
        Field(
            alias="debitValue",
            description="The debit value of the associated transaction or entry, formatted as MONEY_100.",
        ),
    ] = None
    description: Annotated[
        Optional[str], Field(description="A description of the task.")
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    entry_type: Annotated[
        Optional[str],
        Field(
            alias="entryType",
            description="For AP and AR analyses this is the entry type for the associated entry.",
        ),
    ] = None
    filter_statement: Annotated[
        Optional[str],
        Field(
            alias="filterStatement",
            description="The filter statement that was applied when creating this task via a bulk task creation.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    invoice_ref: Annotated[
        Optional[str],
        Field(
            alias="invoiceRef",
            description="For AP and AR analyses this is the Invoice ref value for the associated entry.",
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description="The task's name. Generated based on on the related entry or transaction."
        ),
    ] = None
    risk_scores: Annotated[
        Optional[Dict[str, int]],
        Field(
            alias="riskScores",
            description="A map of ensemble names or IDs mapped to their risk score value. The value is a PERCENTAGE_FIXED_POINT type.",
        ),
    ] = None
    row_id: Annotated[
        Optional[int],
        Field(alias="rowId", description="Identifies the associated entry."),
    ] = None
    sample: Annotated[
        Optional[str], Field(description="Which sample this task is a part of.")
    ] = None
    sample_type: Annotated[
        Optional[SampleType],
        Field(
            alias="sampleType",
            description="The sampling method used to create this task.",
        ),
    ] = None
    status: Annotated[
        Optional[Status4], Field(description="The current state of the task.")
    ] = None
    transaction: Annotated[
        Optional[str], Field(description="The name of the associated transaction.")
    ] = None
    transaction_id: Annotated[
        Optional[int],
        Field(
            alias="transactionId", description="Identifies the associated transaction."
        ),
    ] = None
    type: Annotated[
        Optional[Type11],
        Field(description="The type of entry this task is associated with."),
    ] = None
    vendor_name: Annotated[
        Optional[str],
        Field(
            alias="vendorName",
            description="For AP analyses this is the vendor name for the associated entry.",
        ),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class ApiTextTypeDetailsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    range: Optional[RangeIntegerRead] = None


class ApiTransactionIdPreviewIndicatorRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: Annotated[
        Optional[List[ApiTransactionIdPreviewRowRead]],
        Field(description="The set of transactions related to a specific indicator."),
    ] = None
    rating: Annotated[
        Optional[Rating],
        Field(description="The quality of the indicator as rated by MindBridge."),
    ] = None
    value: Annotated[
        Optional[Dict[str, Any]],
        Field(description="A value for this specific indicator."),
    ] = None


class ApiTransactionIdPreviewRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    analysis_id: Annotated[
        Optional[str],
        Field(
            alias="analysisId",
            description="The unique identifier of the associated analysis.",
        ),
    ] = None
    analysis_source_id: Annotated[
        Optional[str],
        Field(
            alias="analysisSourceId",
            description="The unique identifier of the associated analysis source.",
        ),
    ] = None
    column_selection: Annotated[
        Optional[List[int]],
        Field(
            alias="columnSelection",
            description="The list of columns used to generate the transaction ID.",
        ),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId",
            description="The unique identifier of the associated engagement.",
        ),
    ] = None
    entry_previews: Annotated[
        Optional[List[ApiTransactionIdPreviewRowRead]],
        Field(
            alias="entryPreviews",
            description="Details about the transactions generated by this transaction ID selection.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    indicators: Annotated[
        Optional[Dict[str, ApiTransactionIdPreviewIndicatorRead]],
        Field(
            description="The data integrity checks used when selecting a transaction ID."
        ),
    ] = None
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    overall_rating: Annotated[
        Optional[OverallRating],
        Field(
            alias="overallRating",
            description="The quality of the transaction ID as rated by MindBridge.",
        ),
    ] = None
    smart_splitter: Annotated[
        Optional[bool],
        Field(
            alias="smartSplitter",
            description="Indicates whether or not the Smart Splitter was run when selecting a transaction ID.",
        ),
    ] = None
    type: Annotated[
        Optional[Type13],
        Field(description="The type used when selecting a transaction ID."),
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None


class PageableObjectRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    offset: Optional[int] = None
    page_number: Annotated[Optional[int], Field(alias="pageNumber")] = None
    page_size: Annotated[Optional[int], Field(alias="pageSize")] = None
    paged: Optional[bool] = None
    sort: Optional[List[SortObject]] = None
    unpaged: Optional[bool] = None


class ApiAnalysisSourceCreateOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    additional_data_column_field: Annotated[
        Optional[str],
        Field(
            alias="additionalDataColumnField",
            description="When creating an additional data source type, this indicates which additional data column is being targeted.",
        ),
    ] = None
    analysis_id: Annotated[
        Optional[str],
        Field(alias="analysisId", description="Identifies the associated analysis."),
    ] = None
    analysis_period_id: Annotated[
        Optional[str],
        Field(
            alias="analysisPeriodId",
            description="Identifies the analysis period within MindBridge.",
        ),
    ] = None
    analysis_source_type_id: Annotated[
        Optional[str],
        Field(
            alias="analysisSourceTypeId",
            description="Identifies the analysis source type.",
        ),
    ] = None
    apply_degrouper: Annotated[
        Optional[bool],
        Field(
            alias="applyDegrouper",
            description="Indicates whether or not the degrouper should be applied.",
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    file_manager_file_id: Annotated[
        Optional[str],
        Field(
            alias="fileManagerFileId",
            description="Identifies the specific file manager file within MindBridge.",
        ),
    ] = None
    proposed_ambiguous_column_resolutions: Annotated[
        Optional[List[ApiProposedAmbiguousColumnResolutionCreateOnly]],
        Field(
            alias="proposedAmbiguousColumnResolutions",
            description="Details about the virtual columns added during file ingestion.",
        ),
    ] = None
    proposed_column_mappings: Annotated[
        Optional[List[ApiProposedColumnMappingCreateOnly]],
        Field(
            alias="proposedColumnMappings",
            description="Details about the proposed column mapping.",
        ),
    ] = None
    proposed_transaction_id_selection: Annotated[
        Optional[ApiTransactionIdSelectionCreateOnly],
        Field(alias="proposedTransactionIdSelection"),
    ] = None
    proposed_virtual_columns: Annotated[
        Optional[
            List[
                Union[
                    ApiProposedDuplicateVirtualColumnCreateOnly,
                    ApiProposedJoinVirtualColumnCreateOnly,
                    ApiProposedSplitByDelimiterVirtualColumnCreateOnly,
                    ApiProposedSplitByPositionVirtualColumnCreateOnly,
                ]
            ]
        ],
        Field(
            alias="proposedVirtualColumns",
            description="Details about the proposed virtual columns added during the file import process.",
        ),
    ] = None
    target_workflow_state: Annotated[
        Optional[TargetWorkflowState],
        Field(
            alias="targetWorkflowState",
            description="The state that the current workflow will advance to.",
        ),
    ] = None
    warnings_ignored: Annotated[
        Optional[bool],
        Field(
            alias="warningsIgnored",
            description="Indicates whether or not warnings should be ignored.",
        ),
    ] = None


class ApiAnalysisSourceUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    ambiguous_column_resolutions: Annotated[
        Optional[List[ApiAmbiguousColumnUpdate]],
        Field(
            alias="ambiguousColumnResolutions",
            description="Details about resolutions to ambiguity in a column.",
        ),
    ] = None
    apply_degrouper: Annotated[
        Optional[bool],
        Field(
            alias="applyDegrouper",
            description="Indicates whether or not the degrouper should be applied.",
        ),
    ] = None
    column_mappings: Annotated[
        Optional[List[ApiColumnMappingUpdate]],
        Field(alias="columnMappings", description="Details about column mapping."),
    ] = None
    proposed_ambiguous_column_resolutions: Annotated[
        Optional[List[ApiProposedAmbiguousColumnResolutionUpdate]],
        Field(
            alias="proposedAmbiguousColumnResolutions",
            description="Details about the virtual columns added during file ingestion.",
        ),
    ] = None
    proposed_column_mappings: Annotated[
        Optional[List[ApiProposedColumnMappingUpdate]],
        Field(
            alias="proposedColumnMappings",
            description="Details about the proposed column mapping.",
        ),
    ] = None
    proposed_transaction_id_selection: Annotated[
        Optional[ApiTransactionIdSelectionUpdate],
        Field(alias="proposedTransactionIdSelection"),
    ] = None
    proposed_virtual_columns: Annotated[
        Optional[
            List[
                Union[
                    ApiProposedDuplicateVirtualColumnUpdate,
                    ApiProposedJoinVirtualColumnUpdate,
                    ApiProposedSplitByDelimiterVirtualColumnUpdate,
                    ApiProposedSplitByPositionVirtualColumnUpdate,
                ]
            ]
        ],
        Field(
            alias="proposedVirtualColumns",
            description="Details about the proposed virtual columns added during the file import process.",
        ),
    ] = None
    target_workflow_state: Annotated[
        Optional[TargetWorkflowState],
        Field(
            alias="targetWorkflowState",
            description="The state that the current workflow will advance to.",
        ),
    ] = None
    transaction_id_selection: Annotated[
        Optional[ApiTransactionIdSelectionUpdate], Field(alias="transactionIdSelection")
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None
    virtual_columns: Annotated[
        Optional[
            List[
                Union[
                    ApiDuplicateVirtualColumnUpdate,
                    ApiJoinVirtualColumnUpdate,
                    ApiSplitByDelimiterVirtualColumnUpdate,
                    ApiSplitByPositionVirtualColumnUpdate,
                ]
            ]
        ],
        Field(
            alias="virtualColumns",
            description="Details about the virtual columns added during file ingestion. ",
        ),
    ] = None
    warnings_ignored: Annotated[
        Optional[bool],
        Field(
            alias="warningsIgnored",
            description="Indicates whether or not warnings should be ignored.",
        ),
    ] = None


class ApiDataTypeMetricsRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data_previews: Annotated[
        Optional[List[ApiDataPreviewRead]], Field(alias="dataPreviews")
    ] = None
    date_type_details: Annotated[
        Optional[ApiDateTypeDetailsRead], Field(alias="dateTypeDetails")
    ] = None
    detected_types: Annotated[
        Optional[List[DetectedType]], Field(alias="detectedTypes")
    ] = None
    dominant_type: Annotated[Optional[DominantType], Field(alias="dominantType")] = None
    non_null_value_count: Annotated[Optional[int], Field(alias="nonNullValueCount")] = (
        None
    )
    numeric_type_details: Annotated[
        Optional[ApiNumericTypeDetailsRead], Field(alias="numericTypeDetails")
    ] = None
    state: Optional[State] = None
    text_type_details: Annotated[
        Optional[ApiTextTypeDetailsRead], Field(alias="textTypeDetails")
    ] = None
    type_counts: Annotated[Optional[Dict[str, int]], Field(alias="typeCounts")] = None


class ApiFileManagerDirectoryRead(ApiFileManagerEntityRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Annotated[
        Optional[str], Field(description="The current name of the directory.")
    ] = None
    engagement_id: Annotated[
        str,
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ]
    version: Annotated[
        int,
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ]


class PageApiAccountGroupRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiAccountGroupRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiAccountGroupingRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiAccountGroupingRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiAnalysisSourceTypeRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiAnalysisSourceTypeRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiAnalysisTypeRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiAnalysisTypeRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiAnalysisRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiAnalysisRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiApiTokenRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiApiTokenRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiAsyncResultRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiAsyncResultRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiChunkedFileRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiChunkedFileRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiDataTableRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiDataTableRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiEngagementAccountGroupingRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiEngagementAccountGroupingRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiEngagementRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiEngagementRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiFileExportRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiFileExportRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiFileManagerEntityRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[
        List[Union[ApiFileManagerDirectoryRead, ApiFileManagerFileRead]]
    ] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiLibraryRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiLibraryRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiOrganizationRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiOrganizationRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiPopulationTagRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiPopulationTagRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiTaskRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiTaskRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiTransactionIdPreviewRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiTransactionIdPreviewRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class PageApiUserRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiUserRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class ApiColumnMetadataRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cell_length_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="cellLengthMetrics")
    ] = None
    data_type_metrics: Annotated[
        Optional[ApiDataTypeMetricsRead], Field(alias="dataTypeMetrics")
    ] = None
    density_metrics: Annotated[
        Optional[ApiDensityMetricsRead], Field(alias="densityMetrics")
    ] = None
    distinct_value_metrics: Annotated[
        Optional[ApiDistinctValueMetricsRead], Field(alias="distinctValueMetrics")
    ] = None
    null_value_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="nullValueMetrics")
    ] = None
    scientific_notation_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="scientificNotationMetrics")
    ] = None
    special_character_metrics: Annotated[
        Optional[ApiCountMetricsRead], Field(alias="specialCharacterMetrics")
    ] = None


class ApiColumnDataRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_metadata: Annotated[
        Optional[ApiColumnMetadataRead], Field(alias="columnMetadata")
    ] = None
    column_name: Annotated[Optional[str], Field(alias="columnName")] = None
    position: Optional[int] = None
    row_sample: Annotated[Optional[List[str]], Field(alias="rowSample")] = None
    synthetic: Optional[bool] = None


class ApiTabularFileInfoRead(ApiFileInfoRead):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    column_data: Annotated[
        Optional[List[ApiColumnDataRead]],
        Field(
            alias="columnData",
            description="The metadata associated with each individual column within the table.",
        ),
    ] = None
    header_row_index: Annotated[
        Optional[int],
        Field(
            alias="headerRowIndex",
            description="The line where the table header is located.",
        ),
    ] = None
    table_metadata: Annotated[
        Optional[ApiTableMetadataRead], Field(alias="tableMetadata")
    ] = None


class ApiAnalysisSourceRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    additional_data_column_field: Annotated[
        Optional[str],
        Field(
            alias="additionalDataColumnField",
            description="When creating an additional data source type, this indicates which additional data column is being targeted.",
        ),
    ] = None
    ambiguous_column_resolutions: Annotated[
        Optional[List[ApiAmbiguousColumnRead]],
        Field(
            alias="ambiguousColumnResolutions",
            description="Details about resolutions to ambiguity in a column.",
        ),
    ] = None
    analysis_id: Annotated[
        Optional[str],
        Field(alias="analysisId", description="Identifies the associated analysis."),
    ] = None
    analysis_period_id: Annotated[
        Optional[str],
        Field(
            alias="analysisPeriodId",
            description="Identifies the analysis period within MindBridge.",
        ),
    ] = None
    analysis_source_type_id: Annotated[
        Optional[str],
        Field(
            alias="analysisSourceTypeId",
            description="Identifies the analysis source type.",
        ),
    ] = None
    apply_degrouper: Annotated[
        Optional[bool],
        Field(
            alias="applyDegrouper",
            description="Indicates whether or not the degrouper should be applied.",
        ),
    ] = None
    column_mappings: Annotated[
        Optional[List[ApiColumnMappingRead]],
        Field(alias="columnMappings", description="Details about column mapping."),
    ] = None
    created_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="createdUserInfo")
    ] = None
    creation_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="creationDate",
            description="The date that the object was originally created.",
        ),
    ] = None
    degrouper_applied: Annotated[
        Optional[bool],
        Field(
            alias="degrouperApplied",
            description="Indicates whether or not the degrouper was applied.",
        ),
    ] = None
    detected_format: Annotated[
        Optional[DetectedFormat],
        Field(
            alias="detectedFormat",
            description="The data format that MindBridge detected.",
        ),
    ] = None
    engagement_id: Annotated[
        Optional[str],
        Field(
            alias="engagementId", description="Identifies the associated engagement."
        ),
    ] = None
    errors: Annotated[
        Optional[List[ApiMessageRead]],
        Field(
            description="Details about the errors associated with the specific source."
        ),
    ] = None
    file_info: Annotated[
        Optional[Union[ApiFileInfoRead, ApiTabularFileInfoRead]],
        Field(
            alias="fileInfo",
            description="Details about the file being imported into MindBridge.",
        ),
    ] = None
    file_manager_file_id: Annotated[
        Optional[str],
        Field(
            alias="fileManagerFileId",
            description="Identifies the specific file manager file within MindBridge.",
        ),
    ] = None
    id: Annotated[Optional[str], Field(description="The unique object identifier.")] = (
        None
    )
    last_modified_date: Annotated[
        Optional[AwareDatetime],
        Field(
            alias="lastModifiedDate",
            description="The date that the object was last updated or modified.",
        ),
    ] = None
    last_modified_user_info: Annotated[
        Optional[ApiUserInfoRead], Field(alias="lastModifiedUserInfo")
    ] = None
    proposed_ambiguous_column_resolutions: Annotated[
        Optional[List[ApiProposedAmbiguousColumnResolutionRead]],
        Field(
            alias="proposedAmbiguousColumnResolutions",
            description="Details about the virtual columns added during file ingestion.",
        ),
    ] = None
    proposed_column_mappings: Annotated[
        Optional[List[ApiProposedColumnMappingRead]],
        Field(
            alias="proposedColumnMappings",
            description="Details about the proposed column mapping.",
        ),
    ] = None
    proposed_transaction_id_selection: Annotated[
        Optional[ApiTransactionIdSelectionRead],
        Field(alias="proposedTransactionIdSelection"),
    ] = None
    proposed_virtual_columns: Annotated[
        Optional[
            List[
                Union[
                    ApiProposedDuplicateVirtualColumnRead,
                    ApiProposedJoinVirtualColumnRead,
                    ApiProposedSplitByDelimiterVirtualColumnRead,
                    ApiProposedSplitByPositionVirtualColumnRead,
                ]
            ]
        ],
        Field(
            alias="proposedVirtualColumns",
            description="Details about the proposed virtual columns added during the file import process.",
        ),
    ] = None
    target_workflow_state: Annotated[
        Optional[TargetWorkflowState],
        Field(
            alias="targetWorkflowState",
            description="The state that the current workflow will advance to.",
        ),
    ] = None
    transaction_id_selection: Annotated[
        Optional[ApiTransactionIdSelectionRead], Field(alias="transactionIdSelection")
    ] = None
    version: Annotated[
        Optional[int],
        Field(
            description="Indicates the data integrity version to ensure data consistency."
        ),
    ] = None
    virtual_columns: Annotated[
        Optional[
            List[
                Union[
                    ApiDuplicateVirtualColumnRead,
                    ApiJoinVirtualColumnRead,
                    ApiSplitByDelimiterVirtualColumnRead,
                    ApiSplitByPositionVirtualColumnRead,
                ]
            ]
        ],
        Field(
            alias="virtualColumns",
            description="Details about the virtual columns added during file ingestion. ",
        ),
    ] = None
    warnings: Annotated[
        Optional[List[ApiMessageRead]],
        Field(description="Details about the warnings associated with the source."),
    ] = None
    warnings_ignored: Annotated[
        Optional[bool],
        Field(
            alias="warningsIgnored",
            description="Indicates whether or not warnings should be ignored.",
        ),
    ] = None
    workflow_state: Annotated[
        Optional[WorkflowState],
        Field(alias="workflowState", description="The current state of the workflow."),
    ] = None


class PageApiAnalysisSourceRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[List[ApiAnalysisSourceRead]] = None
    empty: Optional[bool] = None
    first: Optional[bool] = None
    last: Optional[bool] = None
    number: Optional[int] = None
    number_of_elements: Annotated[Optional[int], Field(alias="numberOfElements")] = None
    pageable: Optional[PageableObjectRead] = None
    size: Optional[int] = None
    sort: Optional[List[SortObject]] = None
    total_elements: Annotated[Optional[int], Field(alias="totalElements")] = None
    total_pages: Annotated[Optional[int], Field(alias="totalPages")] = None


class ApiDataTableExportRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    csv_configuration: Annotated[
        Optional[ApiCsvConfiguration], Field(alias="csvConfiguration")
    ] = None
    fields: Annotated[
        Optional[List[str]],
        Field(description="The data table fields to be included in the results."),
    ] = None
    inner_list_csv_configuration: Annotated[
        Optional[ApiCsvConfiguration], Field(alias="innerListCsvConfiguration")
    ] = None
    limit: Annotated[
        Optional[int], Field(description="The number of results to be returned.", ge=1)
    ] = None
    query: Optional[MindBridgeQueryTerm] = None
    sort: Optional[ApiDataTableQuerySortOrder] = None


class ApiDataTableQueryRead(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    fields: Annotated[
        Optional[List[str]],
        Field(description="The data table fields to be included in the results."),
    ] = None
    page: Annotated[
        Optional[int],
        Field(
            description="The specific page of results. This operates on a zero-based page index (0..N).",
            ge=0,
        ),
    ] = None
    page_size: Annotated[
        Optional[int],
        Field(
            alias="pageSize",
            description="The number of results to be returned on each page.",
            ge=1,
            le=100,
        ),
    ] = None
    query: Optional[MindBridgeQueryTerm] = None
    sort: Optional[ApiDataTableQuerySortOrderRead] = None


class MindBridgeQueryTerm15(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_and: Annotated[Optional[List[MindBridgeQueryTerm]], Field(alias="$and")] = (
        None
    )


class MindBridgeQueryTerm16(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    field_or: Annotated[Optional[List[MindBridgeQueryTerm]], Field(alias="$or")] = None


class MindBridgeQueryTerm(
    RootModel[
        Optional[
            Union[
                Dict[str, Union[int, float, bool, str]],
                Dict[str, MindBridgeQueryTerm1],
                Dict[str, MindBridgeQueryTerm2],
                Dict[str, MindBridgeQueryTerm3],
                Dict[str, MindBridgeQueryTerm4],
                Dict[str, MindBridgeQueryTerm5],
                Dict[str, MindBridgeQueryTerm6],
                Dict[str, MindBridgeQueryTerm7],
                Dict[str, MindBridgeQueryTerm9],
                Dict[str, MindBridgeQueryTerm10],
                Dict[str, MindBridgeQueryTerm11],
                Dict[str, MindBridgeQueryTerm12],
                Dict[str, MindBridgeQueryTerm13],
                Dict[str, MindBridgeQueryTerm14],
                MindBridgeQueryTerm15,
                MindBridgeQueryTerm16,
                MindBridgeQueryTerm17,
                MindBridgeQueryTerm18,
                Dict[str, Any],
            ]
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Optional[
        Union[
            Dict[str, Union[int, float, bool, str]],
            Dict[str, MindBridgeQueryTerm1],
            Dict[str, MindBridgeQueryTerm2],
            Dict[str, MindBridgeQueryTerm3],
            Dict[str, MindBridgeQueryTerm4],
            Dict[str, MindBridgeQueryTerm5],
            Dict[str, MindBridgeQueryTerm6],
            Dict[str, MindBridgeQueryTerm7],
            Dict[str, MindBridgeQueryTerm9],
            Dict[str, MindBridgeQueryTerm10],
            Dict[str, MindBridgeQueryTerm11],
            Dict[str, MindBridgeQueryTerm12],
            Dict[str, MindBridgeQueryTerm13],
            Dict[str, MindBridgeQueryTerm14],
            MindBridgeQueryTerm15,
            MindBridgeQueryTerm16,
            MindBridgeQueryTerm17,
            MindBridgeQueryTerm18,
            Dict[str, Any],
        ]
    ] = None


class ShieldQueryTermRead(RootModel[Optional[MindBridgeQueryTerm]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Optional[MindBridgeQueryTerm] = None


ApiDataTableExportRequest.model_rebuild()
ApiDataTableQueryRead.model_rebuild()
MindBridgeQueryTerm15.model_rebuild()
MindBridgeQueryTerm16.model_rebuild()
