# generated by datamodel-codegen:
#   filename:  alfresco-workflow.yaml
#   timestamp: 2025-06-25T01:56:54+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Annotated

from pydantic import BaseModel, Field


class CandidateType(Enum):
    user = 'user'
    group = 'group'


class Candidate(BaseModel):
    candidateId: str | None = None
    candidateType: CandidateType | None = None


class CandidateEntry(BaseModel):
    entry: Candidate | None = None


class Company(BaseModel):
    address1: str | None = None
    address2: str | None = None
    address3: str | None = None
    email: str | None = None
    fax: str | None = None
    organization: str | None = None
    postcode: str | None = None
    telephone: str | None = None


class Deployment(BaseModel):
    category: str | None = None
    deployedAt: datetime | None = None
    id: str
    name: str | None = None


class DeploymentEntry(BaseModel):
    entry: Deployment | None = None


class Error1(BaseModel):
    briefSummary: str | None = None
    descriptionURL: str | None = None
    errorKey: str | None = None
    logId: str | None = None
    stackTrace: str | None = None
    statusCode: int | None = None


class Error(BaseModel):
    error: Error1


class ItemBody(BaseModel):
    id: str | None = None


class Pagination(BaseModel):
    count: Annotated[
        int | None, Field(description='The number of objects in the entries array.\n')
    ] = None
    hasMoreItems: Annotated[
        bool | None,
        Field(
            description='A boolean value which is **true** if there are more entities in the collection\nbeyond those in this response. A true value means a request with a larger value\nfor the **skipCount** or the **maxItems** parameter will return more entities.\n'
        ),
    ] = None
    maxItems: Annotated[
        int | None,
        Field(
            description='The value of the **maxItems** parameter used to generate this list,\nor if there was no **maxItems** parameter the default value, 10\n'
        ),
    ] = None
    skipCount: Annotated[
        int | None,
        Field(
            description='An integer describing how many entities exist in the collection before\nthose included in this list.\n'
        ),
    ] = None
    totalItems: Annotated[
        int | None,
        Field(
            description='An integer describing the total number of entities in the collection.\nThe API might not be able to determine this value,\nin which case this property will not be present.\n'
        ),
    ] = None


class Person(BaseModel):
    avatarId: str | None = None
    company: Company | None = None
    description: str | None = None
    email: str | None = None
    emailNotificationsEnabled: bool | None = None
    enabled: bool | None = True
    firstName: str | None = None
    googleId: str | None = None
    id: str
    instantMessageId: str | None = None
    jobTitle: str | None = None
    lastName: str | None = None
    location: str | None = None
    mobile: str | None = None
    skypeId: str | None = None
    statusUpdatedAt: datetime | None = None
    telephone: str | None = None
    userStatus: str | None = None


class Process(BaseModel):
    businessKey: Annotated[str | None, Field(description='The business key')] = None
    deleteReason: Annotated[
        str | None, Field(description='The reason this process was canceled')
    ] = None
    durationInMs: Annotated[int | None, Field(description='The duration of this process')] = None
    endActivityDefinitionId: Annotated[
        str | None, Field(description='The id of the last activity in the process')
    ] = None
    endedAt: Annotated[datetime | None, Field(description='The date time this process started')] = (
        None
    )
    id: Annotated[str, Field(description='The unique id of this process')]
    processDefinitionId: Annotated[
        str | None, Field(description='The unique identity of the owning process definition')
    ] = None
    startActivityDefinitionId: Annotated[
        str | None, Field(description='The id of the first activity in the process')
    ] = None
    startUserId: Annotated[
        str | None, Field(description='The id of the user who started the process')
    ] = None
    startedAt: Annotated[
        datetime | None, Field(description='The date time this process started')
    ] = None


class ProcessBodyVariable(BaseModel):
    bpm_assignee: str | None = None
    bpm_sendEMailNotifications: bool | None = None
    bpm_workflowPriority: int | None = None


class ProcessDefinition(BaseModel):
    category: Annotated[
        str | None, Field(description='The category to which this process definition belongs')
    ] = None
    deploymentId: Annotated[
        str | None, Field(description='The deployment of which this process definition is a part')
    ] = None
    description: Annotated[
        str | None, Field(description='The description of this process definition')
    ] = None
    graphicNotationDefined: bool | None = None
    id: Annotated[str, Field(description='The unique id of this process definition')]
    key: Annotated[str | None, Field(description='The key of this process definition')] = None
    name: Annotated[str | None, Field(description='The name of this process definition')] = None
    startFormResourceKey: Annotated[str | None, Field(description='The start form key')] = None
    title: Annotated[str | None, Field(description='The title of this process definition')] = None


class ProcessDefinitionEntry(BaseModel):
    entry: ProcessDefinition | None = None


class List3(BaseModel):
    entries: list[ProcessDefinitionEntry] | None = None
    pagination: Pagination | None = None


class ProcessDefinitionPaging(BaseModel):
    list: List3 | None = None


class ProcessEntry(BaseModel):
    entry: Process | None = None


class List4(BaseModel):
    entries: list[ProcessEntry] | None = None
    pagination: Pagination | None = None


class ProcessPaging(BaseModel):
    list: List4 | None = None


class State(Enum):
    unclaimed = 'unclaimed'
    claimed = 'claimed'
    completed = 'completed'
    resolved = 'resolved'


class TaskFormModel(BaseModel):
    allowedValues: Annotated[
        list[str] | None, Field(description='An array of allowed values for this item')
    ] = None
    dataType: str | None = None
    defaultValue: str | None = None
    name: str | None = None
    qualifiedName: str | None = None
    required: bool | None = None
    title: str | None = None


class TaskFormModelEntry(BaseModel):
    entry: TaskFormModel | None = None


class List5(BaseModel):
    entries: list[TaskFormModelEntry] | None = None
    pagination: Pagination | None = None


class TaskFormModelPaging(BaseModel):
    list: List5 | None = None


class Variable(BaseModel):
    name: str | None = None
    scope: str | None = None
    type: str | None = None
    value: int | None = None


class VariableBody(BaseModel):
    name: str | None = None
    type: str | None = None
    value: int | None = None


class VariableEntry(BaseModel):
    entry: Variable | None = None


class List7(BaseModel):
    entries: list[VariableEntry] | None = None
    pagination: Pagination | None = None


class VariablePaging(BaseModel):
    list: List7 | None = None


class List(BaseModel):
    entries: list[CandidateEntry] | None = None
    pagination: Pagination | None = None


class CandidatePaging(BaseModel):
    list: List | None = None


class List1(BaseModel):
    entries: list[DeploymentEntry] | None = None
    pagination: Pagination | None = None


class DeploymentPaging(BaseModel):
    list: List1 | None = None


class Item(BaseModel):
    createdAt: datetime | None = None
    createdBy: Person | None = None
    description: str | None = None
    edited: bool | None = None
    id: str | None = None
    mimeType: str | None = None
    modifiedAt: datetime | None = None
    modifiedBy: Person | None = None
    name: str | None = None
    size: int | None = None
    title: str | None = None
    value: int | None = None


class ItemEntry(BaseModel):
    entry: Item | None = None


class List2(BaseModel):
    entries: list[ItemEntry] | None = None
    pagination: Pagination | None = None


class ItemPaging(BaseModel):
    list: List2 | None = None


class ProcessBody(BaseModel):
    processDefinitionKey: str | None = None
    variables: ProcessBodyVariable | None = None


class Task(BaseModel):
    activityDefinitionId: Annotated[
        str | None, Field(description='The activity id of this task')
    ] = None
    assignee: Annotated[
        str | None, Field(description='The id of the user who is currently assigned this task')
    ] = None
    description: Annotated[str | None, Field(description='The description of this task')] = None
    dueAt: Annotated[datetime | None, Field(description='The date time this task is due')] = None
    durationInMs: Annotated[int | None, Field(description='The duration of this task')] = None
    endedAt: Annotated[datetime | None, Field(description='The date time this task started')] = None
    formResourceKey: Annotated[
        str | None, Field(description='The key of the form for this task')
    ] = None
    id: Annotated[str, Field(description='The unique id of this task')]
    name: Annotated[str | None, Field(description='The text name of this task')] = None
    owner: Annotated[str | None, Field(description='The id of the user who owns this task')] = None
    priority: Annotated[int | None, Field(description='The numeric priority of this task')] = None
    processDefinitionId: Annotated[
        str | None, Field(description='The unique identity of the owning process definition')
    ] = None
    processId: Annotated[str | None, Field(description="The containing process's unique id")] = None
    startedAt: Annotated[datetime | None, Field(description='The date time this task started')] = (
        None
    )
    state: Annotated[State | None, Field(description='The state of this task')] = None
    variables: Annotated[
        list[Variable] | None, Field(description='An array of variables for this task')
    ] = None


class TaskBody(BaseModel):
    description: Annotated[str | None, Field(description='The description of this task')] = None
    dueAt: Annotated[datetime | None, Field(description='The date time this task is due')] = None
    name: Annotated[str | None, Field(description='The text name of this task')] = None
    owner: Annotated[str | None, Field(description='The id of the user who owns this task')] = None
    priority: Annotated[int | None, Field(description='The numeric priority of this task')] = None
    state: Annotated[State | None, Field(description='The state of this task')] = None
    variables: Annotated[
        list[Variable] | None, Field(description='An array of variables for this task')
    ] = None


class TaskEntry(BaseModel):
    entry: Task | None = None


class List6(BaseModel):
    entries: list[TaskEntry] | None = None
    pagination: Pagination | None = None


class TaskPaging(BaseModel):
    list: List6 | None = None
