/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api;

import io.ray.api.RayCall;
import io.ray.api.RayObject;
import io.ray.api.WaitResult;
import io.ray.api.id.ObjectId;
import io.ray.api.id.UniqueId;
import io.ray.api.runtime.RayRuntime;
import io.ray.api.runtime.RayRuntimeFactory;
import io.ray.api.runtimecontext.RuntimeContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class Ray
extends RayCall {
    private static RayRuntime runtime = null;

    public static void init() {
        try {
            Class<?> clz = Class.forName("io.ray.runtime.DefaultRayRuntimeFactory");
            RayRuntimeFactory factory = (RayRuntimeFactory)clz.newInstance();
            Ray.init(factory);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Ray runtime.", e);
        }
    }

    public static synchronized void init(RayRuntimeFactory factory) {
        if (runtime == null) {
            runtime = factory.createRayRuntime();
            Runtime.getRuntime().addShutdownHook(new Thread(Ray::shutdown));
        }
    }

    public static synchronized void shutdown() {
        if (runtime != null) {
            runtime.shutdown();
            runtime = null;
        }
    }

    public static <T> RayObject<T> put(T obj) {
        return runtime.put(obj);
    }

    public static <T> T get(ObjectId objectId, Class<T> objectType) {
        return runtime.get(objectId, objectType);
    }

    public static <T> List<T> get(List<ObjectId> objectIds, Class<T> objectType) {
        return runtime.get(objectIds, objectType);
    }

    public static <T> List<T> get(List<RayObject<T>> objectList) {
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        Class<T> objectType = null;
        for (RayObject<T> o : objectList) {
            objectIds.add(o.getId());
            objectType = o.getType();
        }
        return runtime.get(objectIds, objectType);
    }

    public static <T> WaitResult<T> wait(List<RayObject<T>> waitList, int numReturns, int timeoutMs) {
        return runtime.wait(waitList, numReturns, timeoutMs);
    }

    public static <T> WaitResult<T> wait(List<RayObject<T>> waitList, int numReturns) {
        return runtime.wait(waitList, numReturns, Integer.MAX_VALUE);
    }

    public static <T> WaitResult<T> wait(List<RayObject<T>> waitList) {
        return runtime.wait(waitList, waitList.size(), Integer.MAX_VALUE);
    }

    public static Object getAsyncContext() {
        return runtime.getAsyncContext();
    }

    public static void setAsyncContext(Object asyncContext) {
        runtime.setAsyncContext(asyncContext);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        return runtime.wrapRunnable(runnable);
    }

    public static <T> Callable<T> wrapCallable(Callable<T> callable) {
        return runtime.wrapCallable(callable);
    }

    public static RayRuntime internal() {
        return runtime;
    }

    public static void setResource(UniqueId nodeId, String resourceName, double capacity) {
        runtime.setResource(resourceName, capacity, nodeId);
    }

    public static void setResource(String resourceName, double capacity) {
        runtime.setResource(resourceName, capacity, UniqueId.NIL);
    }

    public static RuntimeContext getRuntimeContext() {
        return runtime.getRuntimeContext();
    }
}

