/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.options;

import io.ray.api.options.BaseTaskOptions;
import java.util.HashMap;
import java.util.Map;

public class ActorCreationOptions
extends BaseTaskOptions {
    public final int maxRestarts;
    public final String jvmOptions;
    public final int maxConcurrency;

    private ActorCreationOptions(Map<String, Double> resources, int maxRestarts, String jvmOptions, int maxConcurrency) {
        super(resources);
        this.maxRestarts = maxRestarts;
        this.jvmOptions = jvmOptions;
        this.maxConcurrency = maxConcurrency;
    }

    public static class Builder {
        private Map<String, Double> resources = new HashMap<String, Double>();
        private int maxRestarts = 0;
        private String jvmOptions = null;
        private int maxConcurrency = 1;

        public Builder setResources(Map<String, Double> resources) {
            this.resources = resources;
            return this;
        }

        public Builder setMaxRestarts(int maxRestarts) {
            this.maxRestarts = maxRestarts;
            return this;
        }

        public Builder setJvmOptions(String jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public Builder setMaxConcurrency(int maxConcurrency) {
            if (maxConcurrency <= 0) {
                throw new IllegalArgumentException("maxConcurrency must be greater than 0.");
            }
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public ActorCreationOptions createActorCreationOptions() {
            return new ActorCreationOptions(this.resources, this.maxRestarts, this.jvmOptions, this.maxConcurrency);
        }
    }
}

