/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import io.ray.api.runtime.RayRuntime;
import io.ray.api.runtime.RayRuntimeFactory;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.RayDevRuntime;
import io.ray.runtime.RayNativeRuntime;
import io.ray.runtime.RayRuntimeInternal;
import io.ray.runtime.RayRuntimeProxy;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.config.RunMode;
import io.ray.runtime.generated.Common;
import io.ray.runtime.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRayRuntimeFactory
implements RayRuntimeFactory {
    @Override
    public RayRuntime createRayRuntime() {
        RayConfig rayConfig = RayConfig.getInstance();
        LoggingUtil.setupLogging(rayConfig);
        Logger logger = LoggerFactory.getLogger(DefaultRayRuntimeFactory.class);
        if (rayConfig.workerMode == Common.WorkerType.WORKER) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(String.format("Uncaught worker exception in thread %s", t), e));
        }
        try {
            logger.debug("Initializing runtime with config: {}", (Object)rayConfig);
            AbstractRayRuntime innerRuntime = rayConfig.runMode == RunMode.SINGLE_PROCESS ? new RayDevRuntime(rayConfig) : new RayNativeRuntime(rayConfig);
            RayRuntimeInternal runtime = rayConfig.numWorkersPerProcess > 1 ? RayRuntimeProxy.newInstance(innerRuntime) : innerRuntime;
            runtime.start();
            return runtime;
        }
        catch (Exception e2) {
            logger.error("Failed to initialize ray runtime, with config " + rayConfig, e2);
            throw new RuntimeException("Failed to initialize ray runtime", e2);
        }
    }
}

