/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import io.ray.api.id.JobId;
import io.ray.runtime.config.RunMode;
import io.ray.runtime.generated.Common;
import io.ray.runtime.util.NetworkUtil;
import io.ray.runtime.util.ResourceUtil;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RayConfig {
    public static final String DEFAULT_CONFIG_FILE = "ray.default.conf";
    public static final String CUSTOM_CONFIG_FILE = "ray.conf";
    private static final Random RANDOM = new Random();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("YYYY-MM-dd_HH-mm-ss");
    private static final String DEFAULT_TEMP_DIR = "/tmp/ray";
    private Config config;
    public final String nodeIp;
    public final Common.WorkerType workerMode;
    public final RunMode runMode;
    public final Map<String, Double> resources;
    private JobId jobId;
    public String sessionDir;
    public String logDir;
    public final List<String> libraryPath;
    public final List<String> classpath;
    public final List<String> jvmParameters;
    private String redisAddress;
    private String redisIp;
    private Integer redisPort;
    public final int headRedisPort;
    public final int[] redisShardPorts;
    public final int numberRedisShards;
    public final String headRedisPassword;
    public final String redisPassword;
    public String objectStoreSocketName;
    public final Long objectStoreSize;
    public String rayletSocketName;
    private int nodeManagerPort;
    public final Map<String, String> rayletConfigParameters;
    public final String jobResourcePath;
    public final String pythonWorkerCommand;
    public final boolean gcsServiceEnabled;
    private static volatile RayConfig instance = null;
    public final int numWorkersPerProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RayConfig getInstance() {
        if (instance != null) return instance;
        Class<RayConfig> clazz = RayConfig.class;
        synchronized (RayConfig.class) {
            if (instance != null) return instance;
            instance = RayConfig.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<RayConfig> clazz = RayConfig.class;
        synchronized (RayConfig.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void validate() {
        if (this.workerMode == Common.WorkerType.WORKER) {
            Preconditions.checkArgument(this.redisAddress != null, "Redis address must be set in worker mode.");
        }
    }

    private String removeTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public RayConfig(Config config) {
        String jobId;
        Common.WorkerType localWorkerMode;
        this.config = config;
        try {
            localWorkerMode = config.getEnum(Common.WorkerType.class, "ray.worker.mode");
        }
        catch (ConfigException.Missing e) {
            localWorkerMode = Common.WorkerType.DRIVER;
        }
        this.workerMode = localWorkerMode;
        boolean isDriver = this.workerMode == Common.WorkerType.DRIVER;
        this.runMode = config.getEnum(RunMode.class, "ray.run-mode");
        String nodeIp = config.getString("ray.node-ip");
        if (nodeIp.isEmpty()) {
            nodeIp = NetworkUtil.getIpAddress(null);
        }
        this.nodeIp = nodeIp;
        this.resources = ResourceUtil.getResourcesMapFromString(config.getString("ray.resources"));
        if (isDriver && !this.resources.containsKey("CPU")) {
            int numCpu = Runtime.getRuntime().availableProcessors();
            this.resources.put("CPU", (double)numCpu * 1.0);
        }
        this.jobId = !(jobId = config.getString("ray.job.id")).isEmpty() ? JobId.fromHexString(jobId) : JobId.NIL;
        this.updateSessionDir();
        this.objectStoreSize = config.getBytes("ray.object-store.size");
        this.libraryPath = config.getStringList("ray.library.path");
        this.classpath = config.getStringList("ray.classpath");
        this.jvmParameters = config.hasPath("ray.worker.jvm-parameters") ? config.getStringList("ray.worker.jvm-parameters") : ImmutableList.of();
        this.pythonWorkerCommand = config.hasPath("ray.worker.python-command") ? config.getString("ray.worker.python-command") : null;
        String redisAddress = config.getString("ray.redis.address");
        if (!redisAddress.isEmpty()) {
            this.setRedisAddress(redisAddress);
        } else {
            this.redisAddress = null;
        }
        this.headRedisPort = config.hasPath("ray.redis.head-port") ? config.getInt("ray.redis.head-port") : NetworkUtil.getUnusedPort();
        this.numberRedisShards = config.getInt("ray.redis.shard-number");
        this.redisShardPorts = new int[this.numberRedisShards];
        for (int i = 0; i < this.numberRedisShards; ++i) {
            this.redisShardPorts[i] = NetworkUtil.getUnusedPort();
        }
        this.headRedisPassword = config.getString("ray.redis.head-password");
        this.redisPassword = config.getString("ray.redis.password");
        this.nodeManagerPort = config.getInt("ray.raylet.node-manager-port");
        if (this.nodeManagerPort == 0) {
            Preconditions.checkState(this.redisAddress == null, "Java worker started by raylet should accept the node manager port from raylet.");
            this.nodeManagerPort = NetworkUtil.getUnusedPort();
        }
        this.rayletConfigParameters = new HashMap<String, String>();
        Config rayletConfig = config.getConfig("ray.raylet.config");
        Iterator<Map.Entry<String, ConfigValue>> iterator = rayletConfig.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, ConfigValue> entry;
            this.rayletConfigParameters.put(entry.getKey(), (value = (entry = iterator.next()).getValue().unwrapped()) == null ? "" : value.toString());
        }
        this.jobResourcePath = config.hasPath("ray.job.resource-path") ? config.getString("ray.job.resource-path") : null;
        this.numWorkersPerProcess = config.getInt("ray.raylet.config.num_workers_per_process_java");
        this.gcsServiceEnabled = System.getenv("RAY_GCS_SERVICE_ENABLED") == null || System.getenv("RAY_GCS_SERVICE_ENABLED").toLowerCase().equals("true");
        this.validate();
    }

    public void setRedisAddress(String redisAddress) {
        Preconditions.checkNotNull(redisAddress);
        Preconditions.checkState(this.redisAddress == null, "Redis address was already set");
        this.redisAddress = redisAddress;
        String[] ipAndPort = redisAddress.split(":");
        Preconditions.checkArgument(ipAndPort.length == 2, "Invalid redis address.");
        this.redisIp = ipAndPort[0];
        this.redisPort = Integer.parseInt(ipAndPort[1]);
    }

    public String getRedisAddress() {
        return this.redisAddress;
    }

    public String getRedisIp() {
        return this.redisIp;
    }

    public Integer getRedisPort() {
        return this.redisPort;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public int getNodeManagerPort() {
        return this.nodeManagerPort;
    }

    public void setSessionDir(String sessionDir) {
        this.sessionDir = sessionDir;
    }

    public String getSessionDir() {
        return this.sessionDir;
    }

    public Config getInternalConfig() {
        return this.config;
    }

    public String render() {
        HashMap<String, Object> dynamic = new HashMap<String, Object>();
        dynamic.put("ray.session-dir", this.sessionDir);
        dynamic.put("ray.raylet.socket-name", this.rayletSocketName);
        dynamic.put("ray.object-store.socket-name", this.objectStoreSocketName);
        dynamic.put("ray.raylet.node-manager-port", this.nodeManagerPort);
        dynamic.put("ray.redis.address", this.redisAddress);
        dynamic.put("ray.job.resource-path", this.jobResourcePath);
        Config toRender = ConfigFactory.parseMap(dynamic).withFallback(this.config);
        return toRender.root().render(ConfigRenderOptions.concise());
    }

    private void updateSessionDir() {
        if (this.workerMode == Common.WorkerType.DRIVER) {
            int minBound = 100000;
            int maxBound = 999999;
            String sessionName = String.format("session_%s_%d", DATE_TIME_FORMATTER.format(LocalDateTime.now()), RANDOM.nextInt(899999) + 100000);
            this.sessionDir = String.format("%s/%s", DEFAULT_TEMP_DIR, sessionName);
        } else if (this.workerMode == Common.WorkerType.WORKER) {
            this.sessionDir = this.removeTrailingSlash(this.config.getString("ray.session-dir"));
        } else {
            throw new RuntimeException("Unknown worker type.");
        }
        String localLogDir = null;
        if (this.config.hasPath("ray.logging.dir")) {
            localLogDir = this.removeTrailingSlash(this.config.getString("ray.logging.dir"));
        }
        this.logDir = Strings.isNullOrEmpty(localLogDir) ? String.format("%s/logs", this.sessionDir) : localLogDir;
        String localObjectStoreSocketName = null;
        if (this.config.hasPath("ray.object-store.socket-name")) {
            localObjectStoreSocketName = this.config.getString("ray.object-store.socket-name");
        }
        this.objectStoreSocketName = Strings.isNullOrEmpty(localObjectStoreSocketName) ? String.format("%s/sockets/object_store", this.sessionDir) : localObjectStoreSocketName;
        String localRayletSocketName = null;
        if (this.config.hasPath("ray.raylet.socket-name")) {
            localRayletSocketName = this.config.getString("ray.raylet.socket-name");
        }
        this.rayletSocketName = Strings.isNullOrEmpty(localRayletSocketName) ? String.format("%s/sockets/raylet", this.sessionDir) : localRayletSocketName;
    }

    public String toString() {
        return this.render();
    }

    public static RayConfig create() {
        ConfigFactory.invalidateCaches();
        Config config = ConfigFactory.systemProperties();
        String configPath = System.getProperty("ray.config-file");
        config = Strings.isNullOrEmpty(configPath) ? config.withFallback(ConfigFactory.load(CUSTOM_CONFIG_FILE)) : config.withFallback(ConfigFactory.parseFile(new File(configPath)));
        config = config.withFallback(ConfigFactory.load(DEFAULT_CONFIG_FILE));
        return new RayConfig(config.withOnlyPath("ray"));
    }
}

