/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.gcs;

import com.google.common.base.Preconditions;
import io.ray.api.id.ActorId;
import io.ray.api.id.UniqueId;
import java.util.List;

public class GlobalStateAccessor {
    private Long globalStateAccessorNativePointer = 0L;
    private static GlobalStateAccessor globalStateAccessor;

    public static synchronized GlobalStateAccessor getInstance(String redisAddress, String redisPassword) {
        if (null == globalStateAccessor) {
            globalStateAccessor = new GlobalStateAccessor(redisAddress, redisPassword);
        }
        return globalStateAccessor;
    }

    public static synchronized void destroyInstance() {
        if (null != globalStateAccessor) {
            globalStateAccessor.destroyGlobalStateAccessor();
            globalStateAccessor = null;
        }
    }

    private GlobalStateAccessor(String redisAddress, String redisPassword) {
        this.globalStateAccessorNativePointer = this.nativeCreateGlobalStateAccessor(redisAddress, redisPassword);
        Preconditions.checkState(this.globalStateAccessorNativePointer != 0L, "Global state accessor native pointer must not be 0.");
        this.connect();
    }

    private boolean connect() {
        return this.nativeConnect(this.globalStateAccessorNativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAllJobInfo() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            Preconditions.checkState(this.globalStateAccessorNativePointer != 0L, "Get all job info when global state accessor have been destroyed.");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nativeGetAllJobInfo(this.globalStateAccessorNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAllNodeInfo() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            Preconditions.checkState(this.globalStateAccessorNativePointer != 0L, "Get all node info when global state accessor have been destroyed.");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nativeGetAllNodeInfo(this.globalStateAccessorNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNodeResourceInfo(UniqueId nodeId) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            Preconditions.checkState(this.globalStateAccessorNativePointer != 0L, "Get resource info by node id when global state accessor have been destroyed.");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.nativeGetNodeResourceInfo(this.globalStateAccessorNativePointer, nodeId.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getAllActorInfo() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            Preconditions.checkState(this.globalStateAccessorNativePointer != 0L);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nativeGetAllActorInfo(this.globalStateAccessorNativePointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getActorInfo(ActorId actorId) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            Preconditions.checkState(this.globalStateAccessorNativePointer != 0L);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.nativeGetActorInfo(this.globalStateAccessorNativePointer, actorId.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getActorCheckpointId(ActorId actorId) {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            Preconditions.checkState(this.globalStateAccessorNativePointer != 0L);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.nativeGetActorCheckpointId(this.globalStateAccessorNativePointer, actorId.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGlobalStateAccessor() {
        Class<GlobalStateAccessor> clazz = GlobalStateAccessor.class;
        synchronized (GlobalStateAccessor.class) {
            if (0L == this.globalStateAccessorNativePointer) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.nativeDestroyGlobalStateAccessor(this.globalStateAccessorNativePointer);
            this.globalStateAccessorNativePointer = 0L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private native long nativeCreateGlobalStateAccessor(String var1, String var2);

    private native void nativeDestroyGlobalStateAccessor(long var1);

    private native boolean nativeConnect(long var1);

    private native void nativeDisconnect(long var1);

    private native List<byte[]> nativeGetAllJobInfo(long var1);

    private native List<byte[]> nativeGetAllNodeInfo(long var1);

    private native byte[] nativeGetNodeResourceInfo(long var1, byte[] var3);

    private native List<byte[]> nativeGetAllActorInfo(long var1);

    private native byte[] nativeGetActorInfo(long var1, byte[] var3);

    private native byte[] nativeGetActorCheckpointId(long var1, byte[] var3);
}

