/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.exception.RayActorException;
import io.ray.api.exception.RayTaskException;
import io.ray.api.exception.RayWorkerException;
import io.ray.api.exception.UnreconstructableException;
import io.ray.api.id.ObjectId;
import io.ray.runtime.generated.Gcs;
import io.ray.runtime.object.NativeRayObject;
import io.ray.runtime.serializer.Serializer;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;

public class ObjectSerializer {
    private static final byte[] WORKER_EXCEPTION_META = String.valueOf(Gcs.ErrorType.WORKER_DIED.getNumber()).getBytes();
    private static final byte[] ACTOR_EXCEPTION_META = String.valueOf(Gcs.ErrorType.ACTOR_DIED.getNumber()).getBytes();
    private static final byte[] UNRECONSTRUCTABLE_EXCEPTION_META = String.valueOf(Gcs.ErrorType.OBJECT_UNRECONSTRUCTABLE.getNumber()).getBytes();
    private static final byte[] TASK_EXECUTION_EXCEPTION_META = String.valueOf(Gcs.ErrorType.TASK_EXECUTION_EXCEPTION.getNumber()).getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_CROSS_LANGUAGE = "XLANG".getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_JAVA = "JAVA".getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_PYTHON = "PYTHON".getBytes();
    public static final byte[] OBJECT_METADATA_TYPE_RAW = "RAW".getBytes();

    public static Object deserialize(NativeRayObject nativeRayObject, ObjectId objectId, Class<?> objectType) {
        byte[] meta = nativeRayObject.metadata;
        byte[] data = nativeRayObject.data;
        if (meta != null && meta.length > 0) {
            if (Arrays.equals(meta, OBJECT_METADATA_TYPE_RAW)) {
                return data;
            }
            if (Arrays.equals(meta, OBJECT_METADATA_TYPE_CROSS_LANGUAGE) || Arrays.equals(meta, OBJECT_METADATA_TYPE_JAVA)) {
                return Serializer.decode(data, objectType);
            }
            if (Arrays.equals(meta, WORKER_EXCEPTION_META)) {
                return new RayWorkerException();
            }
            if (Arrays.equals(meta, ACTOR_EXCEPTION_META)) {
                return new RayActorException();
            }
            if (Arrays.equals(meta, UNRECONSTRUCTABLE_EXCEPTION_META)) {
                return new UnreconstructableException(objectId);
            }
            if (Arrays.equals(meta, TASK_EXECUTION_EXCEPTION_META)) {
                return Serializer.decode(data, objectType);
            }
            if (Arrays.equals(meta, OBJECT_METADATA_TYPE_PYTHON)) {
                throw new IllegalArgumentException("Can't deserialize Python object: " + objectId.toString());
            }
            throw new IllegalArgumentException("Unrecognized metadata " + Arrays.toString(meta));
        }
        return Serializer.decode(data, objectType);
    }

    public static NativeRayObject serialize(Object object) {
        Pair<byte[], Boolean> serialized;
        if (object instanceof NativeRayObject) {
            return (NativeRayObject)object;
        }
        if (object instanceof byte[]) {
            return new NativeRayObject((byte[])object, OBJECT_METADATA_TYPE_RAW);
        }
        if (object instanceof RayTaskException) {
            byte[] serializedBytes = Serializer.encode(object).getLeft();
            return new NativeRayObject(serializedBytes, TASK_EXECUTION_EXCEPTION_META);
        }
        return new NativeRayObject(serialized.getLeft(), (serialized = Serializer.encode(object)).getRight() != false ? OBJECT_METADATA_TYPE_CROSS_LANGUAGE : OBJECT_METADATA_TYPE_JAVA);
    }
}

