/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.sun.jna.NativeLibrary;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.util.BinaryFileUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JniUtils.class);
    private static Set<String> loadedLibs = Sets.newHashSet();

    public static synchronized void loadLibrary(String libraryName) {
        JniUtils.loadLibrary(libraryName, false);
    }

    public static synchronized void loadLibrary(String libraryName, boolean exportSymbols) {
        if (!loadedLibs.contains(libraryName)) {
            LOGGER.debug("Loading native library {}.", (Object)libraryName);
            String fileName = System.mapLibraryName(libraryName);
            String sessionDir = RayConfig.getInstance().sessionDir;
            File file = BinaryFileUtil.getFile(sessionDir, fileName);
            if (exportSymbols) {
                NativeLibrary.getInstance(file.getAbsolutePath());
            }
            System.load(file.getAbsolutePath());
            LOGGER.debug("Native library loaded.");
            JniUtils.resetLibraryPath(file.getAbsolutePath());
            loadedLibs.add(libraryName);
        }
    }

    public static synchronized void resetLibraryPath(String libPath) {
        if (Strings.isNullOrEmpty(libPath)) {
            return;
        }
        String path = System.getProperty("java.library.path");
        String separator = System.getProperty("path.separator");
        path = Strings.isNullOrEmpty(path) ? "" : path + separator;
        path = path + String.join((CharSequence)separator, libPath);
        System.setProperty("java.library.path", path);
        try {
            Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
            sysPathsField.setAccessible(true);
            sysPathsField.set(null, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Failed to set library path.", e);
        }
    }
}

