/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph;

import io.ray.streaming.api.Language;
import io.ray.streaming.jobgraph.VertexType;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.runtime.core.graph.ExecutionEdge;
import io.ray.streaming.runtime.core.graph.ExecutionTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExecutionNode
implements Serializable {
    private int nodeId;
    private int parallelism;
    private Map<String, String> config;
    private NodeType nodeType;
    private StreamOperator streamOperator;
    private List<ExecutionTask> executionTasks;
    private List<ExecutionEdge> inputsEdges;
    private List<ExecutionEdge> outputEdges;

    public ExecutionNode(int nodeId, int parallelism, Map<String, String> config) {
        this.nodeId = nodeId;
        this.parallelism = parallelism;
        this.config = config;
        this.executionTasks = new ArrayList<ExecutionTask>();
        this.inputsEdges = new ArrayList<ExecutionEdge>();
        this.outputEdges = new ArrayList<ExecutionEdge>();
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public List<ExecutionTask> getExecutionTasks() {
        return this.executionTasks;
    }

    public void setExecutionTasks(List<ExecutionTask> executionTasks) {
        this.executionTasks = executionTasks;
    }

    public List<ExecutionEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public void addOutputEdge(ExecutionEdge executionEdge) {
        this.outputEdges.add(executionEdge);
    }

    public void addInputEdge(ExecutionEdge executionEdge) {
        this.inputsEdges.add(executionEdge);
    }

    public List<ExecutionEdge> getInputsEdges() {
        return this.inputsEdges;
    }

    public StreamOperator getStreamOperator() {
        return this.streamOperator;
    }

    public void setStreamOperator(StreamOperator streamOperator) {
        this.streamOperator = streamOperator;
    }

    public Language getLanguage() {
        return this.streamOperator.getLanguage();
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(VertexType vertexType) {
        switch (vertexType) {
            case SOURCE: {
                this.nodeType = NodeType.SOURCE;
                break;
            }
            case SINK: {
                this.nodeType = NodeType.SINK;
                break;
            }
            default: {
                this.nodeType = NodeType.TRANSFORM;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExecutionNode{");
        sb.append("nodeId=").append(this.nodeId);
        sb.append(", parallelism=").append(this.parallelism);
        sb.append(", nodeType=").append((Object)this.nodeType);
        sb.append(", streamOperator=").append(this.streamOperator);
        sb.append('}');
        return sb.toString();
    }

    public static enum NodeType {
        SOURCE,
        TRANSFORM,
        SINK;

    }
}

