/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.schedule;

import io.ray.api.BaseActor;
import io.ray.api.Ray;
import io.ray.api.RayActor;
import io.ray.api.RayPyActor;
import io.ray.api.function.PyActorMethod;
import io.ray.streaming.api.Language;
import io.ray.streaming.jobgraph.JobGraph;
import io.ray.streaming.runtime.core.graph.ExecutionGraph;
import io.ray.streaming.runtime.core.graph.ExecutionNode;
import io.ray.streaming.runtime.core.graph.ExecutionTask;
import io.ray.streaming.runtime.generated.RemoteCall;
import io.ray.streaming.runtime.python.GraphPbBuilder;
import io.ray.streaming.runtime.schedule.TaskAssigner;
import io.ray.streaming.runtime.schedule.TaskAssignerImpl;
import io.ray.streaming.runtime.worker.JobWorker;
import io.ray.streaming.runtime.worker.context.WorkerContext;
import io.ray.streaming.schedule.JobScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JobSchedulerImpl
implements JobScheduler {
    private JobGraph jobGraph;
    private Map<String, String> jobConfig;
    private TaskAssigner taskAssigner = new TaskAssignerImpl();

    @Override
    public void schedule(JobGraph jobGraph, Map<String, String> jobConfig) {
        this.jobConfig = jobConfig;
        this.jobGraph = jobGraph;
        ExecutionGraph executionGraph = this.taskAssigner.assign(this.jobGraph);
        List<ExecutionNode> executionNodes = executionGraph.getExecutionNodeList();
        boolean hasPythonNode = executionNodes.stream().anyMatch(node -> node.getLanguage() == Language.PYTHON);
        RemoteCall.ExecutionGraph executionGraphPb = null;
        if (hasPythonNode) {
            executionGraphPb = new GraphPbBuilder().buildExecutionGraphPb(executionGraph);
        }
        ArrayList waits = new ArrayList();
        for (ExecutionNode executionNode : executionNodes) {
            List<ExecutionTask> executionTasks = executionNode.getExecutionTasks();
            block5: for (ExecutionTask executionTask : executionTasks) {
                int taskId = executionTask.getTaskId();
                BaseActor worker = executionTask.getWorker();
                switch (executionNode.getLanguage()) {
                    case JAVA: {
                        RayActor jobWorker = (RayActor)worker;
                        waits.add(jobWorker.call(JobWorker::init, new WorkerContext(taskId, executionGraph, jobConfig)));
                        continue block5;
                    }
                    case PYTHON: {
                        byte[] workerContextBytes = this.buildPythonWorkerContext(taskId, executionGraphPb, jobConfig);
                        waits.add(((RayPyActor)worker).call(new PyActorMethod<Object>("init", Object.class), workerContextBytes));
                        continue block5;
                    }
                }
                throw new UnsupportedOperationException("Unsupported language " + (Object)((Object)executionNode.getLanguage()));
            }
        }
        Ray.wait(waits);
    }

    private byte[] buildPythonWorkerContext(int taskId, RemoteCall.ExecutionGraph executionGraphPb, Map<String, String> jobConfig) {
        return RemoteCall.WorkerContext.newBuilder().setTaskId(taskId).putAllConf(jobConfig).setGraph(executionGraphPb).build().toByteArray();
    }
}

