/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.keystate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.ray.streaming.state.keystate.KeyGroup;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class KeyGroupAssignment {
    public static KeyGroup getKeyGroup(int maxParallelism, int parallelism, int index) {
        Preconditions.checkArgument(maxParallelism >= parallelism, "Maximum parallelism (%s) must not be smaller than parallelism(%s)", maxParallelism, parallelism);
        int start = index == 0 ? 0 : (index * maxParallelism - 1) / parallelism + 1;
        int end = ((index + 1) * maxParallelism - 1) / parallelism;
        return new KeyGroup(start, end);
    }

    public static int assignKeyGroupIndexForKey(Object key, int maxParallelism) {
        return Math.abs(key.hashCode() % maxParallelism);
    }

    public static Map<Integer, List<Integer>> computeKeyGroupToTask(int maxParallelism, List<Integer> targetTasks) {
        ConcurrentHashMap<Integer, List<Integer>> keyGroupToTask = new ConcurrentHashMap<Integer, List<Integer>>();
        for (int index = 0; index < targetTasks.size(); ++index) {
            KeyGroup taskKeyGroup = KeyGroupAssignment.getKeyGroup(maxParallelism, targetTasks.size(), index);
            for (int groupId = taskKeyGroup.getStartIndex(); groupId <= taskKeyGroup.getEndIndex(); ++groupId) {
                keyGroupToTask.put(groupId, ImmutableList.of(targetTasks.get(index)));
            }
        }
        return keyGroupToTask;
    }
}

