/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.serialization.impl;

import com.google.common.hash.Hashing;
import io.ray.streaming.state.StateException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialization {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSerialization.class);

    public String generateRowKeyPrefix(String key) {
        if (StringUtils.isNotEmpty(key)) {
            String md5 = Hashing.md5().hashUnencodedChars(key).toString();
            if ("".equals(md5)) {
                throw new StateException("Invalid value to md5:" + key);
            }
            return StringUtils.substring(md5, 0, 4) + ":" + key;
        }
        LOG.warn("key is empty");
        return key;
    }
}

