/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.state.store.impl;

import com.google.common.collect.Maps;
import io.ray.streaming.state.store.KeyMapStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MemoryKeyMapStore<K, S, T>
implements KeyMapStore<K, S, T> {
    private Map<K, Map<S, T>> memoryStore = Maps.newConcurrentMap();

    @Override
    public void put(K key, Map<S, T> value) throws IOException {
        this.memoryStore.put(key, value);
    }

    @Override
    public void put(K key, S subKey, T value) throws IOException {
        if (this.memoryStore.containsKey(key)) {
            this.memoryStore.get(key).put(subKey, value);
        } else {
            HashMap<S, T> map = new HashMap<S, T>();
            map.put(subKey, value);
            this.memoryStore.put(key, map);
        }
    }

    @Override
    public Map<S, T> get(K key) throws IOException {
        return this.memoryStore.get(key);
    }

    @Override
    public T get(K key, S subKey) throws IOException {
        if (this.memoryStore.containsKey(key)) {
            return this.memoryStore.get(key).get(subKey);
        }
        return null;
    }

    @Override
    public void remove(K key) throws IOException {
        this.memoryStore.remove(key);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void close() throws IOException {
        if (this.memoryStore != null) {
            this.memoryStore.clear();
        }
    }
}

