"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const fs = require("fs");
const os = require("os");
const path = require("path");
const copy_1 = require("./copy");
const fingerprint_1 = require("./fingerprint");
__exportStar(require("./ignore"), exports);
__exportStar(require("./options"), exports);
/**
 * File system utilities.
 */
class FileSystem {
    /**
     * Copies an entire directory structure.
     *
     * @param srcDir Source directory.
     * @param destDir Destination directory.
     * @param options options.
     * @param rootDir Root directory to calculate exclusions from.
     */
    static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
    }
    /**
     * Produces fingerprint based on the contents of a single file or an entire directory tree.
     *
     * The fingerprint will also include:
     * 1. An extra string if defined in `options.extra`.
     * 2. The set of exclude patterns, if defined in `options.exclude`
     * 3. The symlink follow mode value.
     *
     * @param fileOrDirectory The directory or file to fingerprint.
     * @param options Fingerprinting options.
     */
    static fingerprint(fileOrDirectory, options = {}) {
        return fingerprint_1.fingerprint(fileOrDirectory, options);
    }
    /**
     * Checks whether a directory is empty.
     *
     * @param dir The directory to check.
     */
    static isEmpty(dir) {
        return fs.readdirSync(dir).length === 0;
    }
    /**
     * The real path of the system temp directory.
     */
    static get tmpdir() {
        if (FileSystem._tmpdir) {
            return FileSystem._tmpdir;
        }
        FileSystem._tmpdir = fs.realpathSync(os.tmpdir());
        return FileSystem._tmpdir;
    }
    /**
     * Creates a unique temporary directory in the **system temp directory**.
     *
     * @param prefix A prefix for the directory name.
     */
    static mkdtemp(prefix) {
        return fs.mkdtempSync(path.join(FileSystem.tmpdir, prefix));
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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