# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddressRuleResult',
    'AwaitableGetAddressRuleResult',
    'get_address_rule',
    'get_address_rule_output',
]

@pulumi.output_type
class GetAddressRuleResult:
    """
    A collection of values returned by getAddressRule.
    """
    def __init__(__self__, addresses=None, compartment_id=None, contacts=None, country_code=None, id=None, osp_home_region=None, taxes=None):
        if addresses and not isinstance(addresses, list):
            raise TypeError("Expected argument 'addresses' to be a list")
        pulumi.set(__self__, "addresses", addresses)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if contacts and not isinstance(contacts, list):
            raise TypeError("Expected argument 'contacts' to be a list")
        pulumi.set(__self__, "contacts", contacts)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if osp_home_region and not isinstance(osp_home_region, str):
            raise TypeError("Expected argument 'osp_home_region' to be a str")
        pulumi.set(__self__, "osp_home_region", osp_home_region)
        if taxes and not isinstance(taxes, list):
            raise TypeError("Expected argument 'taxes' to be a list")
        pulumi.set(__self__, "taxes", taxes)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.GetAddressRuleAddressResult']:
        """
        Address type rule information
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def contacts(self) -> Sequence['outputs.GetAddressRuleContactResult']:
        """
        Contact type rule information
        """
        return pulumi.get(self, "contacts")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        Country code for the address rule in ISO-3166-1 2-letter format
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> str:
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter
    def taxes(self) -> Sequence['outputs.GetAddressRuleTaxResult']:
        """
        Tax type rule information
        """
        return pulumi.get(self, "taxes")


class AwaitableGetAddressRuleResult(GetAddressRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressRuleResult(
            addresses=self.addresses,
            compartment_id=self.compartment_id,
            contacts=self.contacts,
            country_code=self.country_code,
            id=self.id,
            osp_home_region=self.osp_home_region,
            taxes=self.taxes)


def get_address_rule(compartment_id: Optional[str] = None,
                     country_code: Optional[str] = None,
                     osp_home_region: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressRuleResult:
    """
    This data source provides details about a specific Address Rule resource in Oracle Cloud Infrastructure Osp Gateway service.

    Get the address rule for the compartment based on the country code

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_address_rule = oci.OspGateway.get_address_rule(compartment_id=compartment_id,
        country_code=address_rule_country_code,
        osp_home_region=address_rule_osp_home_region)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str country_code: Country code for the address rule in ISO-3166-1 2-letter format.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['countryCode'] = country_code
    __args__['ospHomeRegion'] = osp_home_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OspGateway/getAddressRule:getAddressRule', __args__, opts=opts, typ=GetAddressRuleResult).value

    return AwaitableGetAddressRuleResult(
        addresses=pulumi.get(__ret__, 'addresses'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        contacts=pulumi.get(__ret__, 'contacts'),
        country_code=pulumi.get(__ret__, 'country_code'),
        id=pulumi.get(__ret__, 'id'),
        osp_home_region=pulumi.get(__ret__, 'osp_home_region'),
        taxes=pulumi.get(__ret__, 'taxes'))
def get_address_rule_output(compartment_id: Optional[pulumi.Input[str]] = None,
                            country_code: Optional[pulumi.Input[str]] = None,
                            osp_home_region: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAddressRuleResult]:
    """
    This data source provides details about a specific Address Rule resource in Oracle Cloud Infrastructure Osp Gateway service.

    Get the address rule for the compartment based on the country code

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_address_rule = oci.OspGateway.get_address_rule(compartment_id=compartment_id,
        country_code=address_rule_country_code,
        osp_home_region=address_rule_osp_home_region)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str country_code: Country code for the address rule in ISO-3166-1 2-letter format.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['countryCode'] = country_code
    __args__['ospHomeRegion'] = osp_home_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OspGateway/getAddressRule:getAddressRule', __args__, opts=opts, typ=GetAddressRuleResult)
    return __ret__.apply(lambda __response__: GetAddressRuleResult(
        addresses=pulumi.get(__response__, 'addresses'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        contacts=pulumi.get(__response__, 'contacts'),
        country_code=pulumi.get(__response__, 'country_code'),
        id=pulumi.get(__response__, 'id'),
        osp_home_region=pulumi.get(__response__, 'osp_home_region'),
        taxes=pulumi.get(__response__, 'taxes')))
