from pingsafe_cli.psgraph.common.models.enums import CheckResult, CheckCategories
from pingsafe_cli.psgraph.terraform.checks.resource.base_resource_value_check import BaseResourceCheck
from typing import List


class PostgreSQLServerLogCheckpointsEnabled(BaseResourceCheck):
    def __init__(self):
        name = "Ensure server parameter 'log_checkpoints' is set to 'ON' for PostgreSQL Database Server"
        id = "CKV_AZURE_30"
        supported_resources = ['azurerm_postgresql_configuration']
        categories = [CheckCategories.LOGGING]
        super().__init__(name=name, id=id, categories=categories, supported_resources=supported_resources)

    def scan_resource_conf(self, conf):
        if conf['name'][0] == 'log_checkpoints' and conf['value'][0] == 'off':
            return CheckResult.FAILED
        return CheckResult.PASSED

    def get_evaluated_keys(self) -> List[str]:
        return ['name', 'value']


check = PostgreSQLServerLogCheckpointsEnabled()
