from typing import Any

from pingsafe_cli.psgraph.common.models.enums import CheckCategories, CheckResult
from pingsafe_cli.psgraph.terraform.checks.resource.base_resource_value_check import BaseResourceValueCheck


class WebhookInsecureSsl(BaseResourceValueCheck):
    def __init__(self) -> None:
        name = "Ensure GitHub repository webhooks are using HTTPS"
        id = "CKV_GIT_2"
        supported_resources = ("github_repository_webhook",)
        categories = (CheckCategories.GENERAL_SECURITY,)
        super().__init__(name=name, id=id, categories=categories, supported_resources=supported_resources,
                         missing_block_result=CheckResult.PASSED)

    def get_inspected_key(self) -> str:
        return "configuration/[0]/insecure_ssl/[0]"

    def get_expected_value(self) -> Any:
        return False


check = WebhookInsecureSsl()
