# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field
from vrt_lss_studio.models.calculation_settings import CalculationSettings
from vrt_lss_studio.models.geo_settings import GeoSettings

class ActualizeSettings(BaseModel):
    """
    Actualize settings. 
    """
    current_time: Optional[datetime] = Field(None, description="Current date and time according to the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6). If not specified, the current time when the request was received by the server is taken. ")
    geo_settings: Optional[GeoSettings] = None
    calculation_settings: Optional[CalculationSettings] = None
    __properties = ["current_time", "geo_settings", "calculation_settings"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ActualizeSettings:
        """Create an instance of ActualizeSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geo_settings
        if self.geo_settings:
            _dict['geo_settings'] = self.geo_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of calculation_settings
        if self.calculation_settings:
            _dict['calculation_settings'] = self.calculation_settings.to_dict()
        # set to None if current_time (nullable) is None
        # and __fields_set__ contains the field
        if self.current_time is None and "current_time" in self.__fields_set__:
            _dict['current_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ActualizeSettings:
        """Create an instance of ActualizeSettings from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ActualizeSettings.parse_obj(obj)

        _obj = ActualizeSettings.parse_obj({
            "current_time": obj.get("current_time"),
            "geo_settings": GeoSettings.from_dict(obj.get("geo_settings")) if obj.get("geo_settings") is not None else None,
            "calculation_settings": CalculationSettings.from_dict(obj.get("calculation_settings")) if obj.get("calculation_settings") is not None else None
        })
        return _obj

