# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from vrt_lss_studio.models.box_compatibilities import BoxCompatibilities
from vrt_lss_studio.models.box_limits import BoxLimits
from vrt_lss_studio.models.capacity import Capacity

class Box(BaseModel):
    """
    A transport box capable to hold a cargo. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Unique compartment key used to identify the cargo placement in compartments.")
    capacity: Optional[Capacity] = None
    compatibilities: Optional[BoxCompatibilities] = None
    limits: Optional[BoxLimits] = None
    __properties = ["key", "capacity", "compatibilities", "limits"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Box:
        """Create an instance of Box from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of capacity
        if self.capacity:
            _dict['capacity'] = self.capacity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of limits
        if self.limits:
            _dict['limits'] = self.limits.to_dict()
        # set to None if capacity (nullable) is None
        # and __fields_set__ contains the field
        if self.capacity is None and "capacity" in self.__fields_set__:
            _dict['capacity'] = None

        # set to None if compatibilities (nullable) is None
        # and __fields_set__ contains the field
        if self.compatibilities is None and "compatibilities" in self.__fields_set__:
            _dict['compatibilities'] = None

        # set to None if limits (nullable) is None
        # and __fields_set__ contains the field
        if self.limits is None and "limits" in self.__fields_set__:
            _dict['limits'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Box:
        """Create an instance of Box from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Box.parse_obj(obj)

        _obj = Box.parse_obj({
            "key": obj.get("key"),
            "capacity": Capacity.from_dict(obj.get("capacity")) if obj.get("capacity") is not None else None,
            "compatibilities": BoxCompatibilities.from_dict(obj.get("compatibilities")) if obj.get("compatibilities") is not None else None,
            "limits": BoxLimits.from_dict(obj.get("limits")) if obj.get("limits") is not None else None
        })
        return _obj

