# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, constr
from vrt_lss_studio.models.order_fact_type import OrderFactType

class OrderFact(BaseModel):
    """
    The fact about the order is the action taken with the order or its part (demand). 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Fact key.")
    time: datetime = Field(..., description="Fact time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format.")
    type: OrderFactType = Field(...)
    order_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Order key.")
    demand_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Demand key, required for facts with type `DEMAND_DONE` and `DEMAND_START`.")
    __properties = ["key", "time", "type", "order_key", "demand_key"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrderFact:
        """Create an instance of OrderFact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if demand_key (nullable) is None
        # and __fields_set__ contains the field
        if self.demand_key is None and "demand_key" in self.__fields_set__:
            _dict['demand_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrderFact:
        """Create an instance of OrderFact from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrderFact.parse_obj(obj)

        _obj = OrderFact.parse_obj({
            "key": obj.get("key"),
            "time": obj.get("time"),
            "type": obj.get("type"),
            "order_key": obj.get("order_key"),
            "demand_key": obj.get("demand_key")
        })
        return _obj

