# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, confloat, conint, constr, validator

class PerformerTariffConstraint(BaseModel):
    """
    The paid period of time is an integral part of the tariff.
    """
    stage_length: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT24H', description="Length of the paid period according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    cost_per_unit: Optional[Union[confloat(le=10000, ge=0.001, strict=True), conint(le=10000, ge=1, strict=True)]] = Field(0.001, description="Cost within the paid period, monetary unit per second of work. ")
    __properties = ["stage_length", "cost_per_unit"]

    @validator('stage_length')
    def stage_length_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PerformerTariffConstraint:
        """Create an instance of PerformerTariffConstraint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PerformerTariffConstraint:
        """Create an instance of PerformerTariffConstraint from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PerformerTariffConstraint.parse_obj(obj)

        _obj = PerformerTariffConstraint.parse_obj({
            "stage_length": obj.get("stage_length") if obj.get("stage_length") is not None else 'PT24H',
            "cost_per_unit": obj.get("cost_per_unit") if obj.get("cost_per_unit") is not None else 0.001
        })
        return _obj

