# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, constr, validator
from vrt_lss_studio.models.basic_time_window import BasicTimeWindow

class TableTripFields(BaseModel):
    """
    Trip\\stops fields for table.
    """
    essence_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Key, unique identifier.")
    essence_type: Optional[StrictStr] = Field('TRIP', description="Essence type.")
    enabled: Optional[StrictBool] = Field(True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    working_time: Optional[BasicTimeWindow] = None
    orders_count: Optional[conint(strict=True, le=15001, ge=0)] = Field(0, description="Count.")
    trip_name: Optional[constr(strict=True, max_length=64, min_length=0)] = Field('', description="Trip name.")
    attributes: Optional[constr(strict=True, max_length=1000000, min_length=0)] = Field('', description="Attributes.")
    __properties = ["essence_key", "essence_type", "enabled", "pristine", "working_time", "orders_count", "trip_name", "attributes"]

    @validator('essence_type')
    def essence_type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ('TRIP', 'STOP'):
            raise ValueError("must be one of enum values ('TRIP', 'STOP')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableTripFields:
        """Create an instance of TableTripFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "pristine",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of working_time
        if self.working_time:
            _dict['working_time'] = self.working_time.to_dict()
        # set to None if essence_key (nullable) is None
        # and __fields_set__ contains the field
        if self.essence_key is None and "essence_key" in self.__fields_set__:
            _dict['essence_key'] = None

        # set to None if working_time (nullable) is None
        # and __fields_set__ contains the field
        if self.working_time is None and "working_time" in self.__fields_set__:
            _dict['working_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableTripFields:
        """Create an instance of TableTripFields from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableTripFields.parse_obj(obj)

        _obj = TableTripFields.parse_obj({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'TRIP',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "working_time": BasicTimeWindow.from_dict(obj.get("working_time")) if obj.get("working_time") is not None else None,
            "orders_count": obj.get("orders_count") if obj.get("orders_count") is not None else 0,
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "attributes": obj.get("attributes") if obj.get("attributes") is not None else ''
        })
        return _obj

