# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, confloat, conint
from vrt_lss_studio.models.transport_type import TransportType

class TransportFactor(BaseModel):
    """
    Speed change coefficient for the specified transport type.
    """
    transport_type: TransportType = Field(...)
    speed: Union[confloat(le=1000, ge=0.1, strict=True), conint(le=1000, ge=1, strict=True)] = Field(..., description="Average transport speed multiplier.")
    __properties = ["transport_type", "speed"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransportFactor:
        """Create an instance of TransportFactor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransportFactor:
        """Create an instance of TransportFactor from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransportFactor.parse_obj(obj)

        _obj = TransportFactor.parse_obj({
            "transport_type": obj.get("transport_type"),
            "speed": obj.get("speed")
        })
        return _obj

