# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_studio.models.assigned_performer import AssignedPerformer
from vrt_lss_studio.models.assigned_transport import AssignedTransport
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.trip_state import TripState

class Trip(BaseModel):
    """
    A trip is a sequence of states assigned to the specified performer driving the specified transport. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Unique trip identifier.")
    name: Optional[constr(strict=True, max_length=64, min_length=0)] = Field('', description="Trip name.")
    performer: AssignedPerformer = Field(...)
    transport: AssignedTransport = Field(...)
    states: conlist(TripState, max_items=15001, min_items=0) = Field(..., description="List of performer's states.")
    waitlist: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=15001, min_items=0, unique_items=True)] = Field(None, description="A list of keys assigned to orders, but not scheduled for a specific time.")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "name", "performer", "transport", "states", "waitlist", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Trip:
        """Create an instance of Trip from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of performer
        if self.performer:
            _dict['performer'] = self.performer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transport
        if self.transport:
            _dict['transport'] = self.transport.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in states (list)
        _items = []
        if self.states:
            for _item in self.states:
                if _item:
                    _items.append(_item.to_dict())
            _dict['states'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Trip:
        """Create an instance of Trip from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Trip.parse_obj(obj)

        _obj = Trip.parse_obj({
            "key": obj.get("key"),
            "name": obj.get("name") if obj.get("name") is not None else '',
            "performer": AssignedPerformer.from_dict(obj.get("performer")) if obj.get("performer") is not None else None,
            "transport": AssignedTransport.from_dict(obj.get("transport")) if obj.get("transport") is not None else None,
            "states": [TripState.from_dict(_item) for _item in obj.get("states")] if obj.get("states") is not None else None,
            "waitlist": obj.get("waitlist"),
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

