# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from vrt_lss_studio.models.compatibility_penalty import CompatibilityPenalty

class TripPenalties(BaseModel):
    """
    Planning penalties - ability to disrupt a part of the planning business rules. 
    """
    compatibilities: Optional[conlist(CompatibilityPenalty, max_items=1000000, min_items=0, unique_items=True)] = Field(None, description="Penalties for compatibility violation.")
    __properties = ["compatibilities"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TripPenalties:
        """Create an instance of TripPenalties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in compatibilities (list)
        _items = []
        if self.compatibilities:
            for _item in self.compatibilities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['compatibilities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TripPenalties:
        """Create an instance of TripPenalties from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TripPenalties.parse_obj(obj)

        _obj = TripPenalties.parse_obj({
            "compatibilities": [CompatibilityPenalty.from_dict(_item) for _item in obj.get("compatibilities")] if obj.get("compatibilities") is not None else None
        })
        return _obj

