# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from vrt_lss_studio.models.trip_assumptions import TripAssumptions
from vrt_lss_studio.models.trip_penalties import TripPenalties
from vrt_lss_studio.models.trip_start_time_strategy import TripStartTimeStrategy

class TripsSettings(BaseModel):
    """
    Trip creation settings.
    """
    configuration: Optional[constr(strict=True, max_length=256, min_length=1)] = Field('default', description="Name of the planning configuration. The configuration determines the result goal and quality.     [List of available](#section/Description/Planning-configuration) planning configurations.")
    trip_start_time_strategy: Optional[TripStartTimeStrategy] = None
    assumptions: Optional[TripAssumptions] = None
    penalties: Optional[TripPenalties] = None
    __properties = ["configuration", "trip_start_time_strategy", "assumptions", "penalties"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TripsSettings:
        """Create an instance of TripsSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of assumptions
        if self.assumptions:
            _dict['assumptions'] = self.assumptions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of penalties
        if self.penalties:
            _dict['penalties'] = self.penalties.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TripsSettings:
        """Create an instance of TripsSettings from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TripsSettings.parse_obj(obj)

        _obj = TripsSettings.parse_obj({
            "configuration": obj.get("configuration") if obj.get("configuration") is not None else 'default',
            "trip_start_time_strategy": obj.get("trip_start_time_strategy"),
            "assumptions": TripAssumptions.from_dict(obj.get("assumptions")) if obj.get("assumptions") is not None else None,
            "penalties": TripPenalties.from_dict(obj.get("penalties")) if obj.get("penalties") is not None else None
        })
        return _obj

